/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleComponent;
import android.graphics.drawable.RippleDrawable;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.view.DisplayListCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RippleForeground
extends RippleComponent
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static TimeInterpolator LINEAR_INTERPOLATOR;
    private static TimeInterpolator DECELERATE_INTERPOLATOR;
    private static int RIPPLE_ENTER_DURATION = 225;
    private static int RIPPLE_ORIGIN_DURATION = 225;
    private static int OPACITY_ENTER_DURATION = 75;
    private static int OPACITY_EXIT_DURATION = 150;
    private static int OPACITY_HOLD_DURATION = 225;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private CanvasProperty<Paint> mPropPaint;
    private CanvasProperty<Float> mPropRadius;
    private CanvasProperty<Float> mPropX;
    private CanvasProperty<Float> mPropY;
    private float mTargetX;
    private float mTargetY;
    private float mOpacity;
    private float mTweenRadius;
    private float mTweenX;
    private float mTweenY;
    private boolean mHasFinishedExit;
    private boolean mUsingProperties;
    private long mEnterStartedAtMillis;
    private ArrayList<RenderNodeAnimator> mPendingHwAnimators;
    private ArrayList<RenderNodeAnimator> mRunningHwAnimators;
    private ArrayList<Animator> mRunningSwAnimators;
    private boolean mForceSoftware;
    private float mStartRadius;
    private AnimatorListenerAdapter mAnimationListener;
    private static FloatProperty<RippleForeground> TWEEN_RADIUS;
    private static FloatProperty<RippleForeground> TWEEN_ORIGIN;
    private static FloatProperty<RippleForeground> OPACITY;

    private void $$robo$$android_graphics_drawable_RippleForeground$__constructor__(RippleDrawable owner, Rect bounds, float startingX, float startingY, boolean forceSoftware) {
        this.mTargetX = 0.0f;
        this.mTargetY = 0.0f;
        this.mOpacity = 0.0f;
        this.mTweenRadius = 0.0f;
        this.mTweenX = 0.0f;
        this.mTweenY = 0.0f;
        this.mPendingHwAnimators = new ArrayList();
        this.mRunningHwAnimators = new ArrayList();
        this.mRunningSwAnimators = new ArrayList();
        this.mStartRadius = 0.0f;
        this.mAnimationListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RippleForeground this$0;

            private void $$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(RippleForeground this$0) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_1$onAnimationEnd(Animator animator2) {
                this.this$0.mHasFinishedExit = true;
                this.this$0.pruneHwFinished();
                this.this$0.pruneSwFinished();
                if (this.this$0.mRunningHwAnimators.isEmpty()) {
                    this.this$0.clearHwProps();
                }
            }

            private void __constructor__(RippleForeground rippleForeground) {
                this.$$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(rippleForeground);
            }
            {
                this.this$0 = rippleForeground;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_1$__constructor__(android.graphics.drawable.RippleForeground ), 0, this, rippleForeground);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_graphics_drawable_RippleForeground_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mForceSoftware = forceSoftware;
        this.mStartingX = startingX;
        this.mStartingY = startingY;
        this.mStartRadius = (float)Math.max(bounds.width(), bounds.height()) * 0.3f;
        this.clampStartingPosition();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$onTargetRadiusChanged(float targetRadius) {
        this.clampStartingPosition();
        this.switchToUiThreadAnimation();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$drawSoftware(Canvas c, Paint p) {
        int origAlpha = p.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        float radius = this.getCurrentRadius();
        if (alpha > 0 && radius > 0.0f) {
            float x = this.getCurrentX();
            float y = this.getCurrentY();
            p.setAlpha(alpha);
            c.drawCircle(x, y, radius, p);
            p.setAlpha(origAlpha);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$startPending(DisplayListCanvas c) {
        if (!this.mPendingHwAnimators.isEmpty()) {
            for (int i = 0; i < this.mPendingHwAnimators.size(); ++i) {
                RenderNodeAnimator animator2 = this.mPendingHwAnimators.get(i);
                animator2.setTarget(c);
                animator2.start();
                this.mRunningHwAnimators.add(animator2);
            }
            this.mPendingHwAnimators.clear();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$pruneHwFinished() {
        if (!this.mRunningHwAnimators.isEmpty()) {
            for (int i = this.mRunningHwAnimators.size() - 1; i >= 0; --i) {
                if (this.mRunningHwAnimators.get(i).isRunning()) continue;
                this.mRunningHwAnimators.remove(i);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$pruneSwFinished() {
        if (!this.mRunningSwAnimators.isEmpty()) {
            for (int i = this.mRunningSwAnimators.size() - 1; i >= 0; --i) {
                if (this.mRunningSwAnimators.get(i).isRunning()) continue;
                this.mRunningSwAnimators.remove(i);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$drawHardware(DisplayListCanvas c, Paint p) {
        this.startPending(c);
        this.pruneHwFinished();
        if (this.mPropPaint != null) {
            this.mUsingProperties = true;
            c.drawCircle(this.mPropX, this.mPropY, this.mPropRadius, this.mPropPaint);
        } else {
            this.mUsingProperties = false;
            this.drawSoftware(c, p);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$getBounds(Rect bounds) {
        int outerX = (int)this.mTargetX;
        int outerY = (int)this.mTargetY;
        int r = (int)this.mTargetRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    private final boolean $$robo$$android_graphics_drawable_RippleForeground$hasFinishedExit() {
        return this.mHasFinishedExit;
    }

    private final long $$robo$$android_graphics_drawable_RippleForeground$computeFadeOutDelay() {
        long timeSinceEnter = AnimationUtils.currentAnimationTimeMillis() - this.mEnterStartedAtMillis;
        if (timeSinceEnter > 0L && timeSinceEnter < 225L) {
            return 225L - timeSinceEnter;
        }
        return 0L;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$startSoftwareEnter() {
        for (int i = 0; i < this.mRunningSwAnimators.size(); ++i) {
            this.mRunningSwAnimators.get(i).cancel();
        }
        this.mRunningSwAnimators.clear();
        ObjectAnimator tweenRadius = ObjectAnimator.ofFloat(this, TWEEN_RADIUS, 1.0f);
        tweenRadius.setDuration(225L);
        tweenRadius.setInterpolator(DECELERATE_INTERPOLATOR);
        tweenRadius.start();
        this.mRunningSwAnimators.add(tweenRadius);
        ObjectAnimator tweenOrigin = ObjectAnimator.ofFloat(this, TWEEN_ORIGIN, 1.0f);
        tweenOrigin.setDuration(225L);
        tweenOrigin.setInterpolator(DECELERATE_INTERPOLATOR);
        tweenOrigin.start();
        this.mRunningSwAnimators.add(tweenOrigin);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
        opacity.setDuration(75L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.start();
        this.mRunningSwAnimators.add(opacity);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$startSoftwareExit() {
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 0.0f);
        opacity.setDuration(150L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.addListener(this.mAnimationListener);
        opacity.setStartDelay(this.computeFadeOutDelay());
        opacity.start();
        this.mRunningSwAnimators.add(opacity);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$startHardwareEnter() {
        if (this.mForceSoftware) {
            return;
        }
        this.mPropX = CanvasProperty.createFloat(this.getCurrentX());
        this.mPropY = CanvasProperty.createFloat(this.getCurrentY());
        this.mPropRadius = CanvasProperty.createFloat(this.getCurrentRadius());
        Paint paint = this.mOwner.getRipplePaint();
        this.mPropPaint = CanvasProperty.createPaint(paint);
        RenderNodeAnimator radius = new RenderNodeAnimator(this.mPropRadius, this.mTargetRadius);
        radius.setDuration(225L);
        radius.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(radius);
        RenderNodeAnimator x = new RenderNodeAnimator(this.mPropX, this.mTargetX);
        x.setDuration(225L);
        x.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(x);
        RenderNodeAnimator y = new RenderNodeAnimator(this.mPropY, this.mTargetY);
        y.setDuration(225L);
        y.setInterpolator(DECELERATE_INTERPOLATOR);
        this.mPendingHwAnimators.add(y);
        RenderNodeAnimator opacity = new RenderNodeAnimator(this.mPropPaint, 1, paint.getAlpha());
        opacity.setDuration(75L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.setStartValue(0.0f);
        this.mPendingHwAnimators.add(opacity);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$startHardwareExit() {
        if (this.mForceSoftware || this.mPropPaint == null) {
            return;
        }
        RenderNodeAnimator opacity = new RenderNodeAnimator(this.mPropPaint, 1, 0.0f);
        opacity.setDuration(150L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        opacity.addListener(this.mAnimationListener);
        opacity.setStartDelay(this.computeFadeOutDelay());
        opacity.setStartValue(this.mOwner.getRipplePaint().getAlpha());
        this.mPendingHwAnimators.add(opacity);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$enter() {
        this.mEnterStartedAtMillis = AnimationUtils.currentAnimationTimeMillis();
        this.startSoftwareEnter();
        this.startHardwareEnter();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$exit() {
        this.startSoftwareExit();
        this.startHardwareExit();
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentX() {
        return MathUtils.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mTargetX, this.mTweenX);
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentY() {
        return MathUtils.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mTargetY, this.mTweenY);
    }

    private final float $$robo$$android_graphics_drawable_RippleForeground$getCurrentRadius() {
        return MathUtils.lerp(this.mStartRadius, this.mTargetRadius, this.mTweenRadius);
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$draw(Canvas c, Paint p) {
        boolean hasDisplayListCanvas = !this.mForceSoftware && c instanceof DisplayListCanvas;
        this.pruneSwFinished();
        if (hasDisplayListCanvas) {
            DisplayListCanvas hw = (DisplayListCanvas)c;
            this.drawHardware(hw, p);
        } else {
            this.drawSoftware(c, p);
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mTargetRadius - this.mStartRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$end() {
        int i;
        for (i = 0; i < this.mRunningSwAnimators.size(); ++i) {
            this.mRunningSwAnimators.get(i).end();
        }
        this.mRunningSwAnimators.clear();
        for (i = 0; i < this.mRunningHwAnimators.size(); ++i) {
            this.mRunningHwAnimators.get(i).end();
        }
        this.mRunningHwAnimators.clear();
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$onAnimationPropertyChanged() {
        if (!this.mUsingProperties) {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$clearHwProps() {
        this.mPropPaint = null;
        this.mPropRadius = null;
        this.mPropX = null;
        this.mPropY = null;
        this.mUsingProperties = false;
    }

    private final void $$robo$$android_graphics_drawable_RippleForeground$switchToUiThreadAnimation() {
        for (int i = 0; i < this.mRunningHwAnimators.size(); ++i) {
            Animator animator2 = this.mRunningHwAnimators.get(i);
            animator2.removeListener(this.mAnimationListener);
            animator2.end();
        }
        this.mRunningHwAnimators.clear();
        this.clearHwProps();
        this.invalidateSelf();
    }

    static void __staticInitializer__() {
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        DECELERATE_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
        TWEEN_RADIUS = new FloatProperty<RippleForeground>("tweenRadius"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(String x0) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_2$setValue(RippleForeground object, float value) {
                object.mTweenRadius = value;
                object.onAnimationPropertyChanged();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_2$get(RippleForeground object) {
                return Float.valueOf(object.mTweenRadius);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_2$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_2$setValue(android.graphics.drawable.RippleForeground float ), 0, this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_2$get(android.graphics.drawable.RippleForeground ), 0, this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TWEEN_ORIGIN = new FloatProperty<RippleForeground>("tweenOrigin"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(String x0) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_3$setValue(RippleForeground object, float value) {
                object.mTweenX = value;
                object.mTweenY = value;
                object.onAnimationPropertyChanged();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_3$get(RippleForeground object) {
                return Float.valueOf(object.mTweenX);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_3$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_3$setValue(android.graphics.drawable.RippleForeground float ), 0, this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_3$get(android.graphics.drawable.RippleForeground ), 0, this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        OPACITY = new FloatProperty<RippleForeground>("opacity"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(String x0) {
            }

            private final void $$robo$$android_graphics_drawable_RippleForeground_4$setValue(RippleForeground object, float value) {
                object.mOpacity = value;
                object.onAnimationPropertyChanged();
            }

            private final Float $$robo$$android_graphics_drawable_RippleForeground_4$get(RippleForeground object) {
                return Float.valueOf(object.mOpacity);
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground_4$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(RippleForeground rippleForeground, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_graphics_drawable_RippleForeground_4$setValue(android.graphics.drawable.RippleForeground float ), 0, this, rippleForeground, f);
            }

            @Override
            public Float get(RippleForeground rippleForeground) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_graphics_drawable_RippleForeground_4$get(android.graphics.drawable.RippleForeground ), 0, this, rippleForeground);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(RippleDrawable rippleDrawable, Rect rect, float f, float f2, boolean bl) {
        this.$$robo$$android_graphics_drawable_RippleForeground$__constructor__(rippleDrawable, rect, f, f2, bl);
    }

    public RippleForeground(RippleDrawable rippleDrawable, Rect rect, float f, float f2, boolean bl) {
        super(rippleDrawable, rect);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_RippleForeground$__constructor__(android.graphics.drawable.RippleDrawable android.graphics.Rect float float boolean ), 0, this, rippleDrawable, rect, f, f2, bl);
    }

    @Override
    protected void onTargetRadiusChanged(float f) {
        InvokeDynamicSupport.bootstrap("onTargetRadiusChanged", $$robo$$android_graphics_drawable_RippleForeground$onTargetRadiusChanged(float ), 0, this, f);
    }

    private void drawSoftware(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawSoftware", $$robo$$android_graphics_drawable_RippleForeground$drawSoftware(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    private void startPending(DisplayListCanvas displayListCanvas) {
        InvokeDynamicSupport.bootstrap("startPending", $$robo$$android_graphics_drawable_RippleForeground$startPending(android.view.DisplayListCanvas ), 0, this, displayListCanvas);
    }

    private void pruneHwFinished() {
        InvokeDynamicSupport.bootstrap("pruneHwFinished", $$robo$$android_graphics_drawable_RippleForeground$pruneHwFinished(), 0, this);
    }

    private void pruneSwFinished() {
        InvokeDynamicSupport.bootstrap("pruneSwFinished", $$robo$$android_graphics_drawable_RippleForeground$pruneSwFinished(), 0, this);
    }

    private void drawHardware(DisplayListCanvas displayListCanvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawHardware", $$robo$$android_graphics_drawable_RippleForeground$drawHardware(android.view.DisplayListCanvas android.graphics.Paint ), 0, this, displayListCanvas, paint);
    }

    @Override
    public void getBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_graphics_drawable_RippleForeground$getBounds(android.graphics.Rect ), 0, this, rect);
    }

    public void move(float f, float f2) {
        InvokeDynamicSupport.bootstrap("move", $$robo$$android_graphics_drawable_RippleForeground$move(float float ), 0, this, f, f2);
    }

    public boolean hasFinishedExit() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFinishedExit", $$robo$$android_graphics_drawable_RippleForeground$hasFinishedExit(), 0, this);
    }

    private long computeFadeOutDelay() {
        return (long)InvokeDynamicSupport.bootstrap("computeFadeOutDelay", $$robo$$android_graphics_drawable_RippleForeground$computeFadeOutDelay(), 0, this);
    }

    private void startSoftwareEnter() {
        InvokeDynamicSupport.bootstrap("startSoftwareEnter", $$robo$$android_graphics_drawable_RippleForeground$startSoftwareEnter(), 0, this);
    }

    private void startSoftwareExit() {
        InvokeDynamicSupport.bootstrap("startSoftwareExit", $$robo$$android_graphics_drawable_RippleForeground$startSoftwareExit(), 0, this);
    }

    private void startHardwareEnter() {
        InvokeDynamicSupport.bootstrap("startHardwareEnter", $$robo$$android_graphics_drawable_RippleForeground$startHardwareEnter(), 0, this);
    }

    private void startHardwareExit() {
        InvokeDynamicSupport.bootstrap("startHardwareExit", $$robo$$android_graphics_drawable_RippleForeground$startHardwareExit(), 0, this);
    }

    public void enter() {
        InvokeDynamicSupport.bootstrap("enter", $$robo$$android_graphics_drawable_RippleForeground$enter(), 0, this);
    }

    public void exit() {
        InvokeDynamicSupport.bootstrap("exit", $$robo$$android_graphics_drawable_RippleForeground$exit(), 0, this);
    }

    private float getCurrentX() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentX", $$robo$$android_graphics_drawable_RippleForeground$getCurrentX(), 0, this);
    }

    private float getCurrentY() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentY", $$robo$$android_graphics_drawable_RippleForeground$getCurrentY(), 0, this);
    }

    private float getCurrentRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrentRadius", $$robo$$android_graphics_drawable_RippleForeground$getCurrentRadius(), 0, this);
    }

    public void draw(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_RippleForeground$draw(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    private void clampStartingPosition() {
        InvokeDynamicSupport.bootstrap("clampStartingPosition", $$robo$$android_graphics_drawable_RippleForeground$clampStartingPosition(), 0, this);
    }

    public void end() {
        InvokeDynamicSupport.bootstrap("end", $$robo$$android_graphics_drawable_RippleForeground$end(), 0, this);
    }

    private void onAnimationPropertyChanged() {
        InvokeDynamicSupport.bootstrap("onAnimationPropertyChanged", $$robo$$android_graphics_drawable_RippleForeground$onAnimationPropertyChanged(), 0, this);
    }

    private void clearHwProps() {
        InvokeDynamicSupport.bootstrap("clearHwProps", $$robo$$android_graphics_drawable_RippleForeground$clearHwProps(), 0, this);
    }

    private void switchToUiThreadAnimation() {
        InvokeDynamicSupport.bootstrap("switchToUiThreadAnimation", $$robo$$android_graphics_drawable_RippleForeground$switchToUiThreadAnimation(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RippleForeground.class);
    }

    public /* synthetic */ RippleForeground() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RippleForeground)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

