/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class HardwareBuffer
implements Parcelable,
AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int RGBA_8888 = 1;
    public static int RGBX_8888 = 2;
    public static int RGB_888 = 3;
    public static int RGB_565 = 4;
    public static int RGBA_FP16 = 22;
    public static int RGBA_1010102 = 43;
    public static int BLOB = 33;
    public static int D_16 = 48;
    public static int D_24 = 49;
    public static int DS_24UI8 = 50;
    public static int D_FP32 = 51;
    public static int DS_FP32UI8 = 52;
    public static int S_UI8 = 53;
    private long mNativeObject;
    private Runnable mCleaner;
    private CloseGuard mCloseGuard;
    public static long USAGE_CPU_READ_RARELY = 2L;
    public static long USAGE_CPU_READ_OFTEN = 3L;
    public static long USAGE_CPU_WRITE_RARELY = 32L;
    public static long USAGE_CPU_WRITE_OFTEN = 48L;
    public static long USAGE_GPU_SAMPLED_IMAGE = 256L;
    public static long USAGE_GPU_COLOR_OUTPUT = 512L;
    public static long USAGE_PROTECTED_CONTENT = 16384L;
    public static long USAGE_VIDEO_ENCODE = 65536L;
    public static long USAGE_SENSOR_DIRECT_DATA = 0x800000L;
    public static long USAGE_GPU_DATA_BUFFER = 0x1000000L;
    public static long USAGE_GPU_CUBE_MAP = 0x2000000L;
    public static long USAGE_GPU_MIPMAP_COMPLETE = 0x4000000L;
    private static long NATIVE_HARDWARE_BUFFER_SIZE = 232L;
    public static Parcelable.Creator<HardwareBuffer> CREATOR;

    private static final HardwareBuffer $$robo$$android_hardware_HardwareBuffer$create(int width, int height, int format, int layers, long usage) {
        if (!HardwareBuffer.isSupportedFormat(format)) {
            throw new IllegalArgumentException("Invalid pixel format " + format);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        long nativeObject = HardwareBuffer.nCreateHardwareBuffer(width, height, format, layers, usage);
        if (nativeObject == 0L) {
            throw new IllegalArgumentException("Unable to create a HardwareBuffer, either the dimensions passed were too large, too many image layers were requested, or an invalid set of usage flags or invalid format was passed");
        }
        return new HardwareBuffer(nativeObject);
    }

    private void $$robo$$android_hardware_HardwareBuffer$__constructor__(long nativeObject) {
        this.mCloseGuard = CloseGuard.get();
        this.mNativeObject = nativeObject;
        ClassLoader loader = HardwareBuffer.class.getClassLoader();
        NativeAllocationRegistry registry = new NativeAllocationRegistry(loader, HardwareBuffer.nGetNativeFinalizer(), 232L);
        this.mCleaner = registry.registerNativeAllocation((Object)this, this.mNativeObject);
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_hardware_HardwareBuffer$finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final int $$robo$$android_hardware_HardwareBuffer$getWidth() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its width cannot be obtained.");
        }
        return HardwareBuffer.nGetWidth(this.mNativeObject);
    }

    private final int $$robo$$android_hardware_HardwareBuffer$getHeight() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its height cannot be obtained.");
        }
        return HardwareBuffer.nGetHeight(this.mNativeObject);
    }

    private final int $$robo$$android_hardware_HardwareBuffer$getFormat() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its format cannot be obtained.");
        }
        return HardwareBuffer.nGetFormat(this.mNativeObject);
    }

    private final int $$robo$$android_hardware_HardwareBuffer$getLayers() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its layer count cannot be obtained.");
        }
        return HardwareBuffer.nGetLayers(this.mNativeObject);
    }

    private final long $$robo$$android_hardware_HardwareBuffer$getUsage() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and its usage cannot be obtained.");
        }
        return HardwareBuffer.nGetUsage(this.mNativeObject);
    }

    @Deprecated
    private final void $$robo$$android_hardware_HardwareBuffer$destroy() {
        this.close();
    }

    @Deprecated
    private final boolean $$robo$$android_hardware_HardwareBuffer$isDestroyed() {
        return this.isClosed();
    }

    private final void $$robo$$android_hardware_HardwareBuffer$close() {
        if (!this.isClosed()) {
            this.mCloseGuard.close();
            this.mNativeObject = 0L;
            this.mCleaner.run();
            this.mCleaner = null;
        }
    }

    private final boolean $$robo$$android_hardware_HardwareBuffer$isClosed() {
        return this.mNativeObject == 0L;
    }

    private final int $$robo$$android_hardware_HardwareBuffer$describeContents() {
        return 1;
    }

    private final void $$robo$$android_hardware_HardwareBuffer$writeToParcel(Parcel dest, int flags) {
        if (this.isClosed()) {
            throw new IllegalStateException("This HardwareBuffer has been closed and cannot be written to a parcel.");
        }
        HardwareBuffer.nWriteHardwareBufferToParcel(this.mNativeObject, dest);
    }

    private static final boolean $$robo$$android_hardware_HardwareBuffer$isSupportedFormat(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 22: 
            case 33: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private static final long $$robo$$android_hardware_HardwareBuffer$nCreateHardwareBuffer(int n, int n2, int n3, int n4, long l) {
        return 0L;
    }

    private static final long $$robo$$android_hardware_HardwareBuffer$nGetNativeFinalizer() {
        return 0L;
    }

    private static final void $$robo$$android_hardware_HardwareBuffer$nWriteHardwareBufferToParcel(long l, Parcel parcel) {
    }

    private static final long $$robo$$android_hardware_HardwareBuffer$nReadHardwareBufferFromParcel(Parcel parcel) {
        return 0L;
    }

    @FastNative
    private static final int $$robo$$android_hardware_HardwareBuffer$nGetWidth(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_hardware_HardwareBuffer$nGetHeight(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_hardware_HardwareBuffer$nGetFormat(long l) {
        return 0;
    }

    @FastNative
    private static final int $$robo$$android_hardware_HardwareBuffer$nGetLayers(long l) {
        return 0;
    }

    @FastNative
    private static final long $$robo$$android_hardware_HardwareBuffer$nGetUsage(long l) {
        return 0L;
    }

    private /* synthetic */ void $$robo$$android_hardware_HardwareBuffer$__constructor__(long x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<HardwareBuffer>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_HardwareBuffer_1$__constructor__() {
            }

            private final HardwareBuffer $$robo$$android_hardware_HardwareBuffer_1$createFromParcel(Parcel in) {
                long nativeObject = HardwareBuffer.nReadHardwareBufferFromParcel(in);
                if (nativeObject != 0L) {
                    return new HardwareBuffer(nativeObject);
                }
                return null;
            }

            private final HardwareBuffer[] $$robo$$android_hardware_HardwareBuffer_1$newArray(int size) {
                return new HardwareBuffer[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_HardwareBuffer_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_HardwareBuffer_1$__constructor__(), 0, this);
            }

            @Override
            public HardwareBuffer createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_HardwareBuffer_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public HardwareBuffer[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_HardwareBuffer_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static HardwareBuffer create(int n, int n2, int n3, int n4, long l) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_hardware_HardwareBuffer$create(int int int int long ), 0, (int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_hardware_HardwareBuffer$__constructor__(l);
    }

    private HardwareBuffer(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_HardwareBuffer$__constructor__(long ), 0, this, l);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_HardwareBuffer$finalize(), 0, this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_hardware_HardwareBuffer$getWidth(), 0, this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_hardware_HardwareBuffer$getHeight(), 0, this);
    }

    public int getFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_hardware_HardwareBuffer$getFormat(), 0, this);
    }

    public int getLayers() {
        return (int)InvokeDynamicSupport.bootstrap("getLayers", $$robo$$android_hardware_HardwareBuffer$getLayers(), 0, this);
    }

    public long getUsage() {
        return (long)InvokeDynamicSupport.bootstrap("getUsage", $$robo$$android_hardware_HardwareBuffer$getUsage(), 0, this);
    }

    @Deprecated
    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_hardware_HardwareBuffer$destroy(), 0, this);
    }

    @Deprecated
    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_hardware_HardwareBuffer$isDestroyed(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_HardwareBuffer$close(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_hardware_HardwareBuffer$isClosed(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_HardwareBuffer$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_HardwareBuffer$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static boolean isSupportedFormat(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupportedFormat", $$robo$$android_hardware_HardwareBuffer$isSupportedFormat(int ), 0, (int)n);
    }

    private static final native /* synthetic */ long $$robo$$nCreateHardwareBuffer$nativeBinding(int var0, int var1, int var2, int var3, long var4);

    private static long nCreateHardwareBuffer(int n, int n2, int n3, int n4, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateHardwareBuffer", $$robo$$android_hardware_HardwareBuffer$nCreateHardwareBuffer(int int int int long ), 1, (int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nGetNativeFinalizer$nativeBinding();

    private static long nGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetNativeFinalizer", $$robo$$android_hardware_HardwareBuffer$nGetNativeFinalizer(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nWriteHardwareBufferToParcel$nativeBinding(long var0, Parcel var2);

    private static void nWriteHardwareBufferToParcel(long l, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("nWriteHardwareBufferToParcel", $$robo$$android_hardware_HardwareBuffer$nWriteHardwareBufferToParcel(long android.os.Parcel ), 1, (long)l, (Parcel)parcel);
    }

    private static final native /* synthetic */ long $$robo$$nReadHardwareBufferFromParcel$nativeBinding(Parcel var0);

    private static long nReadHardwareBufferFromParcel(Parcel parcel) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nReadHardwareBufferFromParcel", $$robo$$android_hardware_HardwareBuffer$nReadHardwareBufferFromParcel(android.os.Parcel ), 1, (Parcel)parcel);
    }

    private static final native /* synthetic */ int $$robo$$nGetWidth$nativeBinding(long var0);

    private static int nGetWidth(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetWidth", $$robo$$android_hardware_HardwareBuffer$nGetWidth(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nGetHeight$nativeBinding(long var0);

    private static int nGetHeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetHeight", $$robo$$android_hardware_HardwareBuffer$nGetHeight(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nGetFormat$nativeBinding(long var0);

    private static int nGetFormat(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetFormat", $$robo$$android_hardware_HardwareBuffer$nGetFormat(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nGetLayers$nativeBinding(long var0);

    private static int nGetLayers(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetLayers", $$robo$$android_hardware_HardwareBuffer$nGetLayers(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nGetUsage$nativeBinding(long var0);

    private static long nGetUsage(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetUsage", $$robo$$android_hardware_HardwareBuffer$nGetUsage(long ), 1, (long)l);
    }

    private /* synthetic */ void __constructor__(long l, 1 var3_2) {
        this.$$robo$$android_hardware_HardwareBuffer$__constructor__(l, var3_2);
    }

    static {
        RobolectricInternals.classInitializing(HardwareBuffer.class);
    }

    public /* synthetic */ HardwareBuffer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HardwareBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Format {
    }
}

