/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.MemoryFile;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SensorDirectChannel
implements Channel,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TYPE_MEMORY_FILE = 1;
    public static int TYPE_HARDWARE_BUFFER = 2;
    public static int RATE_STOP = 0;
    public static int RATE_NORMAL = 1;
    public static int RATE_FAST = 2;
    public static int RATE_VERY_FAST = 3;
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    private SensorManager mManager;
    private int mNativeHandle;
    private long mSize;
    private int mType;

    private final boolean $$robo$$android_hardware_SensorDirectChannel$isOpen() {
        return !this.mClosed.get();
    }

    @Deprecated
    private final boolean $$robo$$android_hardware_SensorDirectChannel$isValid() {
        return this.isOpen();
    }

    private final void $$robo$$android_hardware_SensorDirectChannel$close() {
        if (this.mClosed.compareAndSet(false, true)) {
            this.mCloseGuard.close();
            this.mManager.destroyDirectChannel(this);
        }
    }

    private final int $$robo$$android_hardware_SensorDirectChannel$configure(Sensor sensor, int rateLevel) {
        return this.mManager.configureDirectChannelImpl(this, sensor, rateLevel);
    }

    private void $$robo$$android_hardware_SensorDirectChannel$__constructor__(SensorManager manager, int id2, int type, long size) {
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        this.mManager = manager;
        this.mNativeHandle = id2;
        this.mType = type;
        this.mSize = size;
        this.mCloseGuard.open("SensorDirectChannel");
    }

    private final int $$robo$$android_hardware_SensorDirectChannel$getNativeHandle() {
        return this.mNativeHandle;
    }

    private static final long[] $$robo$$android_hardware_SensorDirectChannel$encodeData(MemoryFile ashmem) {
        Object fd;
        try {
            fd = InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)ashmem.getFileDescriptor());
        }
        catch (IOException e) {
            fd = -1;
        }
        return new long[]{1L, 0L, (long)fd};
    }

    private final void $$robo$$android_hardware_SensorDirectChannel$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_hardware_SensorDirectChannel$isOpen(), 0, this);
    }

    @Deprecated
    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_hardware_SensorDirectChannel$isValid(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_SensorDirectChannel$close(), 0, this);
    }

    public int configure(Sensor sensor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("configure", $$robo$$android_hardware_SensorDirectChannel$configure(android.hardware.Sensor int ), 0, this, sensor, n);
    }

    private void __constructor__(SensorManager sensorManager, int n, int n2, long l) {
        this.$$robo$$android_hardware_SensorDirectChannel$__constructor__(sensorManager, n, n2, l);
    }

    SensorDirectChannel(SensorManager sensorManager, int n, int n2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_SensorDirectChannel$__constructor__(android.hardware.SensorManager int int long ), 0, this, sensorManager, n, n2, l);
    }

    int getNativeHandle() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeHandle", $$robo$$android_hardware_SensorDirectChannel$getNativeHandle(), 0, this);
    }

    static long[] encodeData(MemoryFile memoryFile) {
        return InvokeDynamicSupport.bootstrapStatic("encodeData", $$robo$$android_hardware_SensorDirectChannel$encodeData(android.os.MemoryFile ), 0, (MemoryFile)memoryFile);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_SensorDirectChannel$finalize(), 0, this);
    }

    public /* synthetic */ SensorDirectChannel() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorDirectChannel)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RateLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemoryType {
    }
}

