/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricConstants;
import android.hardware.biometrics.IBiometricPromptReceiver;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.security.Signature;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BiometricPrompt
implements BiometricAuthenticator,
BiometricConstants,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String KEY_TITLE = "title";
    public static String KEY_SUBTITLE = "subtitle";
    public static String KEY_DESCRIPTION = "description";
    public static String KEY_POSITIVE_TEXT = "positive_text";
    public static String KEY_NEGATIVE_TEXT = "negative_text";
    public static int HIDE_DIALOG_DELAY = 2000;
    public static int DISMISSED_REASON_POSITIVE = 1;
    public static int DISMISSED_REASON_NEGATIVE = 2;
    public static int DISMISSED_REASON_USER_CANCEL = 3;
    private PackageManager mPackageManager;
    private FingerprintManager mFingerprintManager;
    private Bundle mBundle;
    private ButtonInfo mPositiveButtonInfo;
    private ButtonInfo mNegativeButtonInfo;
    IBiometricPromptReceiver mDialogReceiver;

    private void $$robo$$android_hardware_biometrics_BiometricPrompt$__constructor__(Context context, Bundle bundle, ButtonInfo positiveButtonInfo, ButtonInfo negativeButtonInfo) {
        this.mDialogReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BiometricPrompt this$0;

            private void $$robo$$android_hardware_biometrics_BiometricPrompt_1$__constructor__(BiometricPrompt this$0) {
            }

            private final void $$robo$$android_hardware_biometrics_BiometricPrompt_1$onDialogDismissed(int reason) {
                if (reason == 1) {
                    ((BiometricPrompt)this.this$0).mPositiveButtonInfo.executor.execute(() -> ((BiometricPrompt)this.this$0).mPositiveButtonInfo.listener.onClick(null, -1));
                } else if (reason == 2) {
                    ((BiometricPrompt)this.this$0).mNegativeButtonInfo.executor.execute(() -> ((BiometricPrompt)this.this$0).mNegativeButtonInfo.listener.onClick(null, -2));
                }
            }

            private void __constructor__(BiometricPrompt biometricPrompt) {
                this.$$robo$$android_hardware_biometrics_BiometricPrompt_1$__constructor__(biometricPrompt);
            }
            {
                this.this$0 = biometricPrompt;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_1$__constructor__(android.hardware.biometrics.BiometricPrompt ), 0, this, biometricPrompt);
            }

            @Override
            public void onDialogDismissed(int n) {
                InvokeDynamicSupport.bootstrap("onDialogDismissed", $$robo$$android_hardware_biometrics_BiometricPrompt_1$onDialogDismissed(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBundle = bundle;
        this.mPositiveButtonInfo = positiveButtonInfo;
        this.mNegativeButtonInfo = negativeButtonInfo;
        this.mFingerprintManager = context.getSystemService(FingerprintManager.class);
        this.mPackageManager = context.getPackageManager();
    }

    private final void $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(android.hardware.biometrics.CryptoObject crypto, CancellationSignal cancel, Executor executor, BiometricAuthenticator.AuthenticationCallback callback) {
        if (!(callback instanceof AuthenticationCallback)) {
            throw new IllegalArgumentException("Callback cannot be casted");
        }
        this.authenticate(crypto, cancel, executor, (BiometricAuthenticator.AuthenticationCallback)((AuthenticationCallback)callback));
    }

    private final void $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(CancellationSignal cancel, Executor executor, BiometricAuthenticator.AuthenticationCallback callback) {
        if (!(callback instanceof AuthenticationCallback)) {
            throw new IllegalArgumentException("Callback cannot be casted");
        }
        this.authenticate(cancel, executor, (AuthenticationCallback)callback);
    }

    private final void $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(CryptoObject crypto, CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (this.handlePreAuthenticationErrors(callback, executor)) {
            return;
        }
        this.mFingerprintManager.authenticate(crypto, cancel, this.mBundle, executor, this.mDialogReceiver, callback);
    }

    private final void $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(CancellationSignal cancel, Executor executor, AuthenticationCallback callback) {
        if (this.handlePreAuthenticationErrors(callback, executor)) {
            return;
        }
        this.mFingerprintManager.authenticate(cancel, this.mBundle, executor, this.mDialogReceiver, callback);
    }

    private final boolean $$robo$$android_hardware_biometrics_BiometricPrompt$handlePreAuthenticationErrors(AuthenticationCallback callback, Executor executor) {
        if (!this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
            this.sendError(12, callback, executor);
            return true;
        }
        if (!this.mFingerprintManager.isHardwareDetected()) {
            this.sendError(1, callback, executor);
            return true;
        }
        if (!this.mFingerprintManager.hasEnrolledFingerprints()) {
            this.sendError(11, callback, executor);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_hardware_biometrics_BiometricPrompt$sendError(int error, AuthenticationCallback callback, Executor executor) {
        executor.execute(() -> callback.onAuthenticationError(error, this.mFingerprintManager.getErrorString(error, 0)));
    }

    private /* synthetic */ void $$robo$$android_hardware_biometrics_BiometricPrompt$__constructor__(Context x0, Bundle x1, ButtonInfo x2, ButtonInfo x3, 1 x4) {
    }

    private void __constructor__(Context context, Bundle bundle, ButtonInfo buttonInfo, ButtonInfo buttonInfo2) {
        this.$$robo$$android_hardware_biometrics_BiometricPrompt$__constructor__(context, bundle, buttonInfo, buttonInfo2);
    }

    private BiometricPrompt(Context context, Bundle bundle, ButtonInfo buttonInfo, ButtonInfo buttonInfo2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt$__constructor__(android.content.Context android.os.Bundle android.hardware.biometrics.BiometricPrompt$ButtonInfo android.hardware.biometrics.BiometricPrompt$ButtonInfo ), 0, this, context, bundle, buttonInfo, buttonInfo2);
    }

    @Override
    public void authenticate(android.hardware.biometrics.CryptoObject cryptoObject, CancellationSignal cancellationSignal, Executor executor, BiometricAuthenticator.AuthenticationCallback authenticationCallback) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(android.hardware.biometrics.CryptoObject android.os.CancellationSignal java.util.concurrent.Executor android.hardware.biometrics.BiometricAuthenticator$AuthenticationCallback ), 0, this, cryptoObject, cancellationSignal, executor, authenticationCallback);
    }

    @Override
    public void authenticate(CancellationSignal cancellationSignal, Executor executor, BiometricAuthenticator.AuthenticationCallback authenticationCallback) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(android.os.CancellationSignal java.util.concurrent.Executor android.hardware.biometrics.BiometricAuthenticator$AuthenticationCallback ), 0, this, cancellationSignal, executor, authenticationCallback);
    }

    public void authenticate(CryptoObject cryptoObject, CancellationSignal cancellationSignal, Executor executor, AuthenticationCallback authenticationCallback) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(android.hardware.biometrics.BiometricPrompt$CryptoObject android.os.CancellationSignal java.util.concurrent.Executor android.hardware.biometrics.BiometricPrompt$AuthenticationCallback ), 0, this, cryptoObject, cancellationSignal, executor, authenticationCallback);
    }

    public void authenticate(CancellationSignal cancellationSignal, Executor executor, AuthenticationCallback authenticationCallback) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_biometrics_BiometricPrompt$authenticate(android.os.CancellationSignal java.util.concurrent.Executor android.hardware.biometrics.BiometricPrompt$AuthenticationCallback ), 0, this, cancellationSignal, executor, authenticationCallback);
    }

    private boolean handlePreAuthenticationErrors(AuthenticationCallback authenticationCallback, Executor executor) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePreAuthenticationErrors", $$robo$$android_hardware_biometrics_BiometricPrompt$handlePreAuthenticationErrors(android.hardware.biometrics.BiometricPrompt$AuthenticationCallback java.util.concurrent.Executor ), 0, this, authenticationCallback, executor);
    }

    private void sendError(int n, AuthenticationCallback authenticationCallback, Executor executor) {
        InvokeDynamicSupport.bootstrap("sendError", $$robo$$android_hardware_biometrics_BiometricPrompt$sendError(int android.hardware.biometrics.BiometricPrompt$AuthenticationCallback java.util.concurrent.Executor ), 0, this, n, authenticationCallback, executor);
    }

    private /* synthetic */ void __constructor__(Context context, Bundle bundle, ButtonInfo buttonInfo, ButtonInfo buttonInfo2, 1 var5_5) {
        this.$$robo$$android_hardware_biometrics_BiometricPrompt$__constructor__(context, bundle, buttonInfo, buttonInfo2, var5_5);
    }

    public /* synthetic */ BiometricPrompt() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BiometricPrompt)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationError(int errorCode, CharSequence errString) {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationSucceeded(AuthenticationResult result) {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationFailed() {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationAcquired(int acquireInfo) {
        }

        private final void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationSucceeded(BiometricAuthenticator.AuthenticationResult result) {
            this.onAuthenticationSucceeded(new AuthenticationResult((CryptoObject)result.getCryptoObject(), result.getId(), result.getUserId()));
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$__constructor__();
        }

        public AuthenticationCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$__constructor__(), 0, this);
        }

        @Override
        public void onAuthenticationError(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onAuthenticationError", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationError(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        @Override
        public void onAuthenticationHelp(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onAuthenticationHelp", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationHelp(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onAuthenticationSucceeded(AuthenticationResult authenticationResult) {
            InvokeDynamicSupport.bootstrap("onAuthenticationSucceeded", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationSucceeded(android.hardware.biometrics.BiometricPrompt$AuthenticationResult ), 0, this, authenticationResult);
        }

        @Override
        public void onAuthenticationFailed() {
            InvokeDynamicSupport.bootstrap("onAuthenticationFailed", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationFailed(), 0, this);
        }

        @Override
        public void onAuthenticationAcquired(int n) {
            InvokeDynamicSupport.bootstrap("onAuthenticationAcquired", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationAcquired(int ), 0, this, n);
        }

        @Override
        public void onAuthenticationSucceeded(BiometricAuthenticator.AuthenticationResult authenticationResult) {
            InvokeDynamicSupport.bootstrap("onAuthenticationSucceeded", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationCallback$onAuthenticationSucceeded(android.hardware.biometrics.BiometricAuthenticator$AuthenticationResult ), 0, this, authenticationResult);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthenticationCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AuthenticationResult
    extends BiometricAuthenticator.AuthenticationResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationResult$__constructor__(CryptoObject crypto, BiometricAuthenticator.BiometricIdentifier identifier, int userId) {
        }

        private final CryptoObject $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationResult$getCryptoObject() {
            return (CryptoObject)super.getCryptoObject();
        }

        private void __constructor__(CryptoObject cryptoObject, BiometricAuthenticator.BiometricIdentifier biometricIdentifier, int n) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationResult$__constructor__(cryptoObject, biometricIdentifier, n);
        }

        public AuthenticationResult(CryptoObject cryptoObject, BiometricAuthenticator.BiometricIdentifier biometricIdentifier, int n) {
            super(cryptoObject, biometricIdentifier, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationResult$__constructor__(android.hardware.biometrics.BiometricPrompt$CryptoObject android.hardware.biometrics.BiometricAuthenticator$BiometricIdentifier int ), 0, this, cryptoObject, biometricIdentifier, n);
        }

        @Override
        public CryptoObject getCryptoObject() {
            return InvokeDynamicSupport.bootstrap("getCryptoObject", $$robo$$android_hardware_biometrics_BiometricPrompt_AuthenticationResult$getCryptoObject(), 0, this);
        }

        public /* synthetic */ AuthenticationResult() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthenticationResult)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CryptoObject
    extends android.hardware.biometrics.CryptoObject
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(Signature signature) {
        }

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(Cipher cipher) {
        }

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(Mac mac) {
        }

        private final Signature $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getSignature() {
            return super.getSignature();
        }

        private final Cipher $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getCipher() {
            return super.getCipher();
        }

        private final Mac $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getMac() {
            return super.getMac();
        }

        private void __constructor__(Signature signature) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(signature);
        }

        public CryptoObject(Signature signature) {
            super(signature);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(java.security.Signature ), 0, this, signature);
        }

        private void __constructor__(Cipher cipher) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(cipher);
        }

        public CryptoObject(Cipher cipher) {
            super(cipher);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(javax.crypto.Cipher ), 0, this, cipher);
        }

        private void __constructor__(Mac mac) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(mac);
        }

        public CryptoObject(Mac mac) {
            super(mac);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$__constructor__(javax.crypto.Mac ), 0, this, mac);
        }

        @Override
        public Signature getSignature() {
            return InvokeDynamicSupport.bootstrap("getSignature", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getSignature(), 0, this);
        }

        @Override
        public Cipher getCipher() {
            return InvokeDynamicSupport.bootstrap("getCipher", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getCipher(), 0, this);
        }

        @Override
        public Mac getMac() {
            return InvokeDynamicSupport.bootstrap("getMac", $$robo$$android_hardware_biometrics_BiometricPrompt_CryptoObject$getMac(), 0, this);
        }

        public /* synthetic */ CryptoObject() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoObject)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bundle mBundle;
        private ButtonInfo mPositiveButtonInfo;
        private ButtonInfo mNegativeButtonInfo;
        private Context mContext;

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$__constructor__(Context context) {
            this.mBundle = new Bundle();
            this.mContext = context;
        }

        private final Builder $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setTitle(CharSequence title) {
            this.mBundle.putCharSequence("title", title);
            return this;
        }

        private final Builder $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setSubtitle(CharSequence subtitle) {
            this.mBundle.putCharSequence("subtitle", subtitle);
            return this;
        }

        private final Builder $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setDescription(CharSequence description) {
            this.mBundle.putCharSequence("description", description);
            return this;
        }

        private final Builder $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setPositiveButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.mBundle.putCharSequence("positive_text", text);
            this.mPositiveButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        private final Builder $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setNegativeButton(CharSequence text, Executor executor, DialogInterface.OnClickListener listener) {
            if (TextUtils.isEmpty(text)) {
                throw new IllegalArgumentException("Text must be set and non-empty");
            }
            if (executor == null) {
                throw new IllegalArgumentException("Executor must not be null");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.mBundle.putCharSequence("negative_text", text);
            this.mNegativeButtonInfo = new ButtonInfo(executor, listener);
            return this;
        }

        private final BiometricPrompt $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$build() {
            CharSequence title = this.mBundle.getCharSequence("title");
            CharSequence negative = this.mBundle.getCharSequence("negative_text");
            if (TextUtils.isEmpty(title)) {
                throw new IllegalArgumentException("Title must be set and non-empty");
            }
            if (TextUtils.isEmpty(negative)) {
                throw new IllegalArgumentException("Negative text must be set and non-empty");
            }
            return new BiometricPrompt(this.mContext, this.mBundle, this.mPositiveButtonInfo, this.mNegativeButtonInfo);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        public Builder setTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setSubtitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setSubtitle", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setSubtitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setDescription(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setDescription(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setPositiveButton(CharSequence charSequence, Executor executor, DialogInterface.OnClickListener onClickListener) {
            return InvokeDynamicSupport.bootstrap("setPositiveButton", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setPositiveButton(java.lang.CharSequence java.util.concurrent.Executor android.content.DialogInterface$OnClickListener ), 0, this, charSequence, executor, onClickListener);
        }

        public Builder setNegativeButton(CharSequence charSequence, Executor executor, DialogInterface.OnClickListener onClickListener) {
            return InvokeDynamicSupport.bootstrap("setNegativeButton", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$setNegativeButton(java.lang.CharSequence java.util.concurrent.Executor android.content.DialogInterface$OnClickListener ), 0, this, charSequence, executor, onClickListener);
        }

        public BiometricPrompt build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_biometrics_BiometricPrompt_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ButtonInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Executor executor;
        DialogInterface.OnClickListener listener;

        private void $$robo$$android_hardware_biometrics_BiometricPrompt_ButtonInfo$__constructor__(Executor ex, DialogInterface.OnClickListener l) {
            this.executor = ex;
            this.listener = l;
        }

        private void __constructor__(Executor executor, DialogInterface.OnClickListener onClickListener) {
            this.$$robo$$android_hardware_biometrics_BiometricPrompt_ButtonInfo$__constructor__(executor, onClickListener);
        }

        ButtonInfo(Executor executor, DialogInterface.OnClickListener onClickListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_biometrics_BiometricPrompt_ButtonInfo$__constructor__(java.util.concurrent.Executor android.content.DialogInterface$OnClickListener ), 0, this, executor, onClickListener);
        }

        public /* synthetic */ ButtonInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ButtonInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

