/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.location.Location;
import android.media.Image;
import android.os.SystemClock;
import android.util.Log;
import android.util.Size;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DngCreator
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DngCreator";
    public static int MAX_THUMBNAIL_DIMENSION = 256;
    private static String GPS_LAT_REF_NORTH = "N";
    private static String GPS_LAT_REF_SOUTH = "S";
    private static String GPS_LONG_REF_EAST = "E";
    private static String GPS_LONG_REF_WEST = "W";
    private static String GPS_DATE_FORMAT_STR = "yyyy:MM:dd";
    private static String TIFF_DATETIME_FORMAT = "yyyy:MM:dd HH:mm:ss";
    private static DateFormat sExifGPSDateStamp;
    private Calendar mGPSTimeStampCalendar;
    private static int DEFAULT_PIXEL_STRIDE = 2;
    private static int BYTES_PER_RGB_PIX = 3;
    private static int TAG_ORIENTATION_UNKNOWN = 9;
    private long mNativeContext;

    private void $$robo$$android_hardware_camera2_DngCreator$__constructor__(CameraCharacteristics characteristics, CaptureResult metadata) {
        this.mGPSTimeStampCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        if (characteristics == null || metadata == null) {
            throw new IllegalArgumentException("Null argument to DngCreator constructor");
        }
        CallSite currentTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        Object timeOffset = 0L;
        int timestampSource = characteristics.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
        if (timestampSource == 1) {
            timeOffset = currentTime - SystemClock.elapsedRealtime();
        } else if (timestampSource == 0) {
            timeOffset = currentTime - SystemClock.uptimeMillis();
        } else {
            Log.w("DngCreator", "Sensor timestamp source is unexpected: " + timestampSource);
            timeOffset = currentTime - SystemClock.uptimeMillis();
        }
        Long timestamp = metadata.get(CaptureResult.SENSOR_TIMESTAMP);
        Object captureTime = currentTime;
        if (timestamp != null) {
            captureTime = timestamp / 1000000L + timeOffset;
        }
        SimpleDateFormat dateTimeStampFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss", Locale.US);
        dateTimeStampFormat.setTimeZone(TimeZone.getDefault());
        String formattedCaptureTime = dateTimeStampFormat.format((long)captureTime);
        this.nativeInit(characteristics.getNativeCopy(), metadata.getNativeCopy(), formattedCaptureTime);
    }

    private final DngCreator $$robo$$android_hardware_camera2_DngCreator$setOrientation(int orientation) {
        if (orientation < 0 || orientation > 8) {
            throw new IllegalArgumentException("Orientation " + orientation + " is not a valid EXIF orientation value");
        }
        if (orientation == 0) {
            orientation = 9;
        }
        this.nativeSetOrientation(orientation);
        return this;
    }

    private final DngCreator $$robo$$android_hardware_camera2_DngCreator$setThumbnail(Bitmap pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (width > 256 || height > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + width + "," + height + ") too large, dimensions must be smaller than " + 256);
        }
        ByteBuffer rgbBuffer = DngCreator.convertToRGB(pixels);
        this.nativeSetThumbnail(rgbBuffer, width, height);
        return this;
    }

    private final DngCreator $$robo$$android_hardware_camera2_DngCreator$setThumbnail(Image pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("Null argument to setThumbnail");
        }
        int format = pixels.getFormat();
        if (format != 35) {
            throw new IllegalArgumentException("Unsupported Image format " + format);
        }
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (width > 256 || height > 256) {
            throw new IllegalArgumentException("Thumbnail dimensions width,height (" + width + "," + height + ") too large, dimensions must be smaller than " + 256);
        }
        ByteBuffer rgbBuffer = DngCreator.convertToRGB(pixels);
        this.nativeSetThumbnail(rgbBuffer, width, height);
        return this;
    }

    private final DngCreator $$robo$$android_hardware_camera2_DngCreator$setLocation(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location passed to setLocation");
        }
        double latitude = location.getLatitude();
        double longitude = location.getLongitude();
        long time = location.getTime();
        int[] latTag = DngCreator.toExifLatLong(latitude);
        int[] longTag = DngCreator.toExifLatLong(longitude);
        String latRef = latitude >= 0.0 ? "N" : "S";
        String longRef = longitude >= 0.0 ? "E" : "W";
        String dateTag = sExifGPSDateStamp.format(time);
        this.mGPSTimeStampCalendar.setTimeInMillis(time);
        int[] timeTag = new int[]{this.mGPSTimeStampCalendar.get(11), 1, this.mGPSTimeStampCalendar.get(12), 1, this.mGPSTimeStampCalendar.get(13), 1};
        this.nativeSetGpsTags(latTag, latRef, longTag, longRef, dateTag, timeTag);
        return this;
    }

    private final DngCreator $$robo$$android_hardware_camera2_DngCreator$setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Null description passed to setDescription.");
        }
        this.nativeSetDescription(description);
        return this;
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$writeInputStream(OutputStream dngOutput, Size size, InputStream pixels, long offset) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeInputStream");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeInputStream");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels passed to writeInputStream");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeInputStream");
        }
        int width = size.getWidth();
        int height = size.getHeight();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Size with invalid width, height: (" + width + "," + height + ") passed to writeInputStream");
        }
        this.nativeWriteInputStream(dngOutput, pixels, width, height, offset);
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$writeByteBuffer(OutputStream dngOutput, Size size, ByteBuffer pixels, long offset) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput passed to writeByteBuffer");
        }
        if (size == null) {
            throw new IllegalArgumentException("Null size passed to writeByteBuffer");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels passed to writeByteBuffer");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Negative offset passed to writeByteBuffer");
        }
        int width = size.getWidth();
        int height = size.getHeight();
        this.writeByteBuffer(width, height, pixels, dngOutput, 2, width * 2, offset);
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$writeImage(OutputStream dngOutput, Image pixels) throws IOException {
        if (dngOutput == null) {
            throw new IllegalArgumentException("Null dngOutput to writeImage");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Null pixels to writeImage");
        }
        int format = pixels.getFormat();
        if (format != 32) {
            throw new IllegalArgumentException("Unsupported image format " + format);
        }
        Image.Plane[] planes = pixels.getPlanes();
        if (planes == null || planes.length <= 0) {
            throw new IllegalArgumentException("Image with no planes passed to writeImage");
        }
        ByteBuffer buf = planes[0].getBuffer();
        this.writeByteBuffer(pixels.getWidth(), pixels.getHeight(), buf, dngOutput, planes[0].getPixelStride(), planes[0].getRowStride(), 0L);
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$close() {
        this.nativeDestroy();
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_hardware_camera2_DngCreator$writeByteBuffer(int width, int height, ByteBuffer pixels, OutputStream dngOutput, int pixelStride, int rowStride, long offset) throws IOException {
        long totalSize;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image with invalid width, height: (" + width + "," + height + ") passed to write");
        }
        long capacity = pixels.capacity();
        if (capacity < (totalSize = (long)rowStride * (long)height + offset)) {
            throw new IllegalArgumentException("Image size " + capacity + " is too small (must be larger than " + totalSize + ")");
        }
        int minRowStride = pixelStride * width;
        if (minRowStride > rowStride) {
            throw new IllegalArgumentException("Invalid image pixel stride, row byte width " + minRowStride + " is too large, expecting " + rowStride);
        }
        pixels.clear();
        this.nativeWriteImage(dngOutput, width, height, pixels, rowStride, pixelStride, offset, pixels.isDirect());
        pixels.clear();
    }

    private static final void $$robo$$android_hardware_camera2_DngCreator$yuvToRgb(byte[] yuvData, int outOffset, byte[] rgbOut) {
        int COLOR_MAX = 255;
        float y = yuvData[0] & 0xFF;
        float cb = yuvData[1] & 0xFF;
        float cr = yuvData[2] & 0xFF;
        float r = y + 1.402f * (cr - 128.0f);
        float g = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f);
        float b = y + 1.772f * (cb - 128.0f);
        rgbOut[outOffset] = (byte)Math.max(0.0f, Math.min(255.0f, r));
        rgbOut[outOffset + 1] = (byte)Math.max(0.0f, Math.min(255.0f, g));
        rgbOut[outOffset + 2] = (byte)Math.max(0.0f, Math.min(255.0f, b));
    }

    private static final void $$robo$$android_hardware_camera2_DngCreator$colorToRgb(int color2, int outOffset, byte[] rgbOut) {
        rgbOut[outOffset] = (byte)Color.red(color2);
        rgbOut[outOffset + 1] = (byte)Color.green(color2);
        rgbOut[outOffset + 2] = (byte)Color.blue(color2);
    }

    private static final ByteBuffer $$robo$$android_hardware_camera2_DngCreator$convertToRGB(Image yuvImage) {
        int width = yuvImage.getWidth();
        int height = yuvImage.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(3 * width * height);
        Image.Plane yPlane = yuvImage.getPlanes()[0];
        Image.Plane uPlane = yuvImage.getPlanes()[1];
        Image.Plane vPlane = yuvImage.getPlanes()[2];
        ByteBuffer yBuf = yPlane.getBuffer();
        ByteBuffer uBuf = uPlane.getBuffer();
        ByteBuffer vBuf = vPlane.getBuffer();
        yBuf.rewind();
        uBuf.rewind();
        vBuf.rewind();
        int yRowStride = yPlane.getRowStride();
        int vRowStride = vPlane.getRowStride();
        int uRowStride = uPlane.getRowStride();
        int yPixStride = yPlane.getPixelStride();
        int vPixStride = vPlane.getPixelStride();
        int uPixStride = uPlane.getPixelStride();
        byte[] yuvPixel = new byte[]{0, 0, 0};
        byte[] yFullRow = new byte[yPixStride * (width - 1) + 1];
        byte[] uFullRow = new byte[uPixStride * (width / 2 - 1) + 1];
        byte[] vFullRow = new byte[vPixStride * (width / 2 - 1) + 1];
        byte[] finalRow = new byte[3 * width];
        for (int i = 0; i < height; ++i) {
            int halfH = i / 2;
            yBuf.position(yRowStride * i);
            yBuf.get(yFullRow);
            uBuf.position(uRowStride * halfH);
            uBuf.get(uFullRow);
            vBuf.position(vRowStride * halfH);
            vBuf.get(vFullRow);
            for (int j = 0; j < width; ++j) {
                int halfW = j / 2;
                yuvPixel[0] = yFullRow[yPixStride * j];
                yuvPixel[1] = uFullRow[uPixStride * halfW];
                yuvPixel[2] = vFullRow[vPixStride * halfW];
                DngCreator.yuvToRgb(yuvPixel, j * 3, finalRow);
            }
            buf.put(finalRow);
        }
        yBuf.rewind();
        uBuf.rewind();
        vBuf.rewind();
        buf.rewind();
        return buf;
    }

    private static final ByteBuffer $$robo$$android_hardware_camera2_DngCreator$convertToRGB(Bitmap argbBitmap) {
        int width = argbBitmap.getWidth();
        int height = argbBitmap.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(3 * width * height);
        int[] pixelRow = new int[width];
        byte[] finalRow = new byte[3 * width];
        for (int i = 0; i < height; ++i) {
            argbBitmap.getPixels(pixelRow, 0, width, 0, i, width, 1);
            for (int j = 0; j < width; ++j) {
                DngCreator.colorToRgb(pixelRow[j], j * 3, finalRow);
            }
            buf.put(finalRow);
        }
        buf.rewind();
        return buf;
    }

    private static final int[] $$robo$$android_hardware_camera2_DngCreator$toExifLatLong(double value) {
        value = Math.abs(value);
        int degrees = (int)value;
        value = (value - (double)degrees) * 60.0;
        int minutes = (int)value;
        value = (value - (double)minutes) * 6000.0;
        int seconds = (int)value;
        return new int[]{degrees, 1, minutes, 1, seconds, 100};
    }

    private static final void $$robo$$android_hardware_camera2_DngCreator$nativeClassInit() {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeInit(CameraMetadataNative cameraMetadataNative, CameraMetadataNative cameraMetadataNative2, String string2) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeDestroy() {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeSetOrientation(int n) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeSetDescription(String string2) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeSetGpsTags(int[] nArray, String string2, int[] nArray2, String string3, String string4, int[] nArray3) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeSetThumbnail(ByteBuffer byteBuffer, int n, int n2) {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeWriteImage(OutputStream outputStream, int n, int n2, ByteBuffer byteBuffer, int n3, int n4, long l, boolean bl) throws IOException {
    }

    private final synchronized void $$robo$$android_hardware_camera2_DngCreator$nativeWriteInputStream(OutputStream outputStream, InputStream inputStream, int n, int n2, long l) throws IOException {
    }

    static void __staticInitializer__() {
        sExifGPSDateStamp = new SimpleDateFormat("yyyy:MM:dd", Locale.US);
        sExifGPSDateStamp.setTimeZone(TimeZone.getTimeZone("UTC"));
        DngCreator.nativeClassInit();
    }

    private void __constructor__(CameraCharacteristics cameraCharacteristics, CaptureResult captureResult) {
        this.$$robo$$android_hardware_camera2_DngCreator$__constructor__(cameraCharacteristics, captureResult);
    }

    public DngCreator(CameraCharacteristics cameraCharacteristics, CaptureResult captureResult) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_DngCreator$__constructor__(android.hardware.camera2.CameraCharacteristics android.hardware.camera2.CaptureResult ), 0, this, cameraCharacteristics, captureResult);
    }

    public DngCreator setOrientation(int n) {
        return InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_hardware_camera2_DngCreator$setOrientation(int ), 0, this, n);
    }

    public DngCreator setThumbnail(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrap("setThumbnail", $$robo$$android_hardware_camera2_DngCreator$setThumbnail(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public DngCreator setThumbnail(Image image) {
        return InvokeDynamicSupport.bootstrap("setThumbnail", $$robo$$android_hardware_camera2_DngCreator$setThumbnail(android.media.Image ), 0, this, image);
    }

    public DngCreator setLocation(Location location) {
        return InvokeDynamicSupport.bootstrap("setLocation", $$robo$$android_hardware_camera2_DngCreator$setLocation(android.location.Location ), 0, this, location);
    }

    public DngCreator setDescription(String string2) {
        return InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_hardware_camera2_DngCreator$setDescription(java.lang.String ), 0, this, string2);
    }

    public void writeInputStream(OutputStream outputStream, Size size, InputStream inputStream, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("writeInputStream", $$robo$$android_hardware_camera2_DngCreator$writeInputStream(java.io.OutputStream android.util.Size java.io.InputStream long ), 0, this, outputStream, size, inputStream, l);
    }

    public void writeByteBuffer(OutputStream outputStream, Size size, ByteBuffer byteBuffer, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("writeByteBuffer", $$robo$$android_hardware_camera2_DngCreator$writeByteBuffer(java.io.OutputStream android.util.Size java.nio.ByteBuffer long ), 0, this, outputStream, size, byteBuffer, l);
    }

    public void writeImage(OutputStream outputStream, Image image) throws IOException {
        InvokeDynamicSupport.bootstrap("writeImage", $$robo$$android_hardware_camera2_DngCreator$writeImage(java.io.OutputStream android.media.Image ), 0, this, outputStream, image);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_DngCreator$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_DngCreator$finalize(), 0, this);
    }

    private void writeByteBuffer(int n, int n2, ByteBuffer byteBuffer, OutputStream outputStream, int n3, int n4, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("writeByteBuffer", $$robo$$android_hardware_camera2_DngCreator$writeByteBuffer(int int java.nio.ByteBuffer java.io.OutputStream int int long ), 0, this, n, n2, byteBuffer, outputStream, n3, n4, l);
    }

    private static void yuvToRgb(byte[] byArray, int n, byte[] byArray2) {
        InvokeDynamicSupport.bootstrapStatic("yuvToRgb", $$robo$$android_hardware_camera2_DngCreator$yuvToRgb(byte[] int byte[] ), 0, (byte[])byArray, (int)n, (byte[])byArray2);
    }

    private static void colorToRgb(int n, int n2, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToRgb", $$robo$$android_hardware_camera2_DngCreator$colorToRgb(int int byte[] ), 0, (int)n, (int)n2, (byte[])byArray);
    }

    private static ByteBuffer convertToRGB(Image image) {
        return InvokeDynamicSupport.bootstrapStatic("convertToRGB", $$robo$$android_hardware_camera2_DngCreator$convertToRGB(android.media.Image ), 0, (Image)image);
    }

    private static ByteBuffer convertToRGB(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("convertToRGB", $$robo$$android_hardware_camera2_DngCreator$convertToRGB(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    private static int[] toExifLatLong(double d) {
        return InvokeDynamicSupport.bootstrapStatic("toExifLatLong", $$robo$$android_hardware_camera2_DngCreator$toExifLatLong(double ), 0, (double)d);
    }

    private static final native /* synthetic */ void $$robo$$nativeClassInit$nativeBinding();

    private static void nativeClassInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeClassInit", $$robo$$android_hardware_camera2_DngCreator$nativeClassInit(), 1);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeInit$nativeBinding(CameraMetadataNative var1, CameraMetadataNative var2, String var3);

    private synchronized void nativeInit(CameraMetadataNative cameraMetadataNative, CameraMetadataNative cameraMetadataNative2, String string2) {
        InvokeDynamicSupport.bootstrap("nativeInit", $$robo$$android_hardware_camera2_DngCreator$nativeInit(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CameraMetadataNative java.lang.String ), 1, this, cameraMetadataNative, cameraMetadataNative2, string2);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeDestroy$nativeBinding();

    private synchronized void nativeDestroy() {
        InvokeDynamicSupport.bootstrap("nativeDestroy", $$robo$$android_hardware_camera2_DngCreator$nativeDestroy(), 1, this);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeSetOrientation$nativeBinding(int var1);

    private synchronized void nativeSetOrientation(int n) {
        InvokeDynamicSupport.bootstrap("nativeSetOrientation", $$robo$$android_hardware_camera2_DngCreator$nativeSetOrientation(int ), 1, this, n);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeSetDescription$nativeBinding(String var1);

    private synchronized void nativeSetDescription(String string2) {
        InvokeDynamicSupport.bootstrap("nativeSetDescription", $$robo$$android_hardware_camera2_DngCreator$nativeSetDescription(java.lang.String ), 1, this, string2);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeSetGpsTags$nativeBinding(int[] var1, String var2, int[] var3, String var4, String var5, int[] var6);

    private synchronized void nativeSetGpsTags(int[] nArray, String string2, int[] nArray2, String string3, String string4, int[] nArray3) {
        InvokeDynamicSupport.bootstrap("nativeSetGpsTags", $$robo$$android_hardware_camera2_DngCreator$nativeSetGpsTags(int[] java.lang.String int[] java.lang.String java.lang.String int[] ), 1, this, nArray, string2, nArray2, string3, string4, nArray3);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeSetThumbnail$nativeBinding(ByteBuffer var1, int var2, int var3);

    private synchronized void nativeSetThumbnail(ByteBuffer byteBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("nativeSetThumbnail", $$robo$$android_hardware_camera2_DngCreator$nativeSetThumbnail(java.nio.ByteBuffer int int ), 1, this, byteBuffer, n, n2);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeWriteImage$nativeBinding(OutputStream var1, int var2, int var3, ByteBuffer var4, int var5, int var6, long var7, boolean var9) throws IOException;

    private synchronized void nativeWriteImage(OutputStream outputStream, int n, int n2, ByteBuffer byteBuffer, int n3, int n4, long l, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeWriteImage", $$robo$$android_hardware_camera2_DngCreator$nativeWriteImage(java.io.OutputStream int int java.nio.ByteBuffer int int long boolean ), 1, this, outputStream, n, n2, byteBuffer, n3, n4, l, bl);
    }

    private final synchronized native /* synthetic */ void $$robo$$nativeWriteInputStream$nativeBinding(OutputStream var1, InputStream var2, int var3, int var4, long var5) throws IOException;

    private synchronized void nativeWriteInputStream(OutputStream outputStream, InputStream inputStream, int n, int n2, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("nativeWriteInputStream", $$robo$$android_hardware_camera2_DngCreator$nativeWriteInputStream(java.io.OutputStream java.io.InputStream int int long ), 1, this, outputStream, inputStream, n, n2, l);
    }

    static {
        RobolectricInternals.classInitializing(DngCreator.class);
    }

    public /* synthetic */ DngCreator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DngCreator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

