/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CallbackProxies;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.utils.TaskDrainer;
import android.hardware.camera2.utils.TaskSingleDrainer;
import android.os.Binder;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraCaptureSessionImpl
extends CameraCaptureSession
implements CameraCaptureSessionCore,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CameraCaptureSession";
    private static boolean DEBUG = false;
    private int mId;
    private String mIdString;
    private Surface mInput;
    private CameraCaptureSession.StateCallback mStateCallback;
    private Executor mStateExecutor;
    private CameraDeviceImpl mDeviceImpl;
    private Executor mDeviceExecutor;
    private TaskDrainer<Integer> mSequenceDrainer;
    private TaskSingleDrainer mIdleDrainer;
    private TaskSingleDrainer mAbortDrainer;
    private boolean mClosed;
    private boolean mConfigureSuccess;
    private boolean mSkipUnconfigure;
    private volatile boolean mAborting;

    private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(int id2, Surface input, CameraCaptureSession.StateCallback callback, Executor stateExecutor, CameraDeviceImpl deviceImpl, Executor deviceStateExecutor, boolean configureSuccess) {
        this.mClosed = false;
        this.mSkipUnconfigure = false;
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.mId = id2;
        this.mIdString = String.format("Session %d: ", this.mId);
        this.mInput = input;
        this.mStateExecutor = Preconditions.checkNotNull(stateExecutor, "stateExecutor must not be null");
        this.mStateCallback = this.createUserStateCallbackProxy(this.mStateExecutor, callback);
        this.mDeviceExecutor = Preconditions.checkNotNull(deviceStateExecutor, "deviceStateExecutor must not be null");
        this.mDeviceImpl = Preconditions.checkNotNull(deviceImpl, "deviceImpl must not be null");
        this.mSequenceDrainer = new TaskDrainer(this.mDeviceExecutor, new SequenceDrainListener(this), "seq");
        this.mIdleDrainer = new TaskSingleDrainer(this.mDeviceExecutor, new IdleDrainListener(this), "idle");
        this.mAbortDrainer = new TaskSingleDrainer(this.mDeviceExecutor, new AbortDrainListener(this), "abort");
        if (configureSuccess) {
            this.mStateCallback.onConfigured(this);
            this.mConfigureSuccess = true;
        } else {
            this.mStateCallback.onConfigureFailed(this);
            this.mClosed = true;
            Log.e("CameraCaptureSession", this.mIdString + "Failed to create capture session; configuration failed");
            this.mConfigureSuccess = false;
        }
    }

    private final CameraDevice $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDevice() {
        return this.mDeviceImpl;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(int maxCount, Surface surface) throws CameraAccessException {
        this.mDeviceImpl.prepare(maxCount, surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$tearDown(Surface surface) throws CameraAccessException {
        this.mDeviceImpl.tearDown(surface);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalizeOutputConfigurations(List<OutputConfiguration> outputConfigs) throws CameraAccessException {
        this.mDeviceImpl.finalizeOutputConfigs(outputConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$capture(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        this.checkCaptureRequest(request);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            handler = CameraDeviceImpl.checkHandler(handler, callback);
            return this.addPendingSequence(this.mDeviceImpl.capture(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureSingleRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.checkCaptureRequest(request);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            executor = CameraDeviceImpl.checkExecutor(executor, callback);
            return this.addPendingSequence(this.mDeviceImpl.capture(request, this.createCaptureCallbackProxyWithExecutor(executor, callback), this.mDeviceExecutor));
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkCaptureRequest(CaptureRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess() && !this.isReprocessable()) {
            throw new IllegalArgumentException("this capture session cannot handle reprocess requests");
        }
        if (request.isReprocess() && request.getReprocessableSessionId() != this.mId) {
            throw new IllegalArgumentException("capture request was created for another session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        this.checkCaptureRequests(requests);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            handler = CameraDeviceImpl.checkHandler(handler, callback);
            return this.addPendingSequence(this.mDeviceImpl.captureBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.checkCaptureRequests(requests);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            executor = CameraDeviceImpl.checkExecutor(executor, callback);
            return this.addPendingSequence(this.mDeviceImpl.captureBurst(requests, this.createCaptureCallbackProxyWithExecutor(executor, callback), this.mDeviceExecutor));
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkCaptureRequests(List<CaptureRequest> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("Requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("Requests must have at least one element");
        }
        for (CaptureRequest request : requests) {
            if (!request.isReprocess()) continue;
            if (!this.isReprocessable()) {
                throw new IllegalArgumentException("This capture session cannot handle reprocess requests");
            }
            if (request.getReprocessableSessionId() == this.mId) continue;
            throw new IllegalArgumentException("Capture request was created for another session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingRequest(CaptureRequest request, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        this.checkRepeatingRequest(request);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            handler = CameraDeviceImpl.checkHandler(handler, callback);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(request, this.createCaptureCallbackProxy(handler, callback), this.mDeviceExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setSingleRepeatingRequest(CaptureRequest request, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.checkRepeatingRequest(request);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            executor = CameraDeviceImpl.checkExecutor(executor, callback);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingRequest(request, this.createCaptureCallbackProxyWithExecutor(executor, callback), this.mDeviceExecutor));
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkRepeatingRequest(CaptureRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (request.isReprocess()) {
            throw new IllegalArgumentException("repeating reprocess requests are not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurst(List<CaptureRequest> requests, CameraCaptureSession.CaptureCallback callback, Handler handler) throws CameraAccessException {
        this.checkRepeatingRequests(requests);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            handler = CameraDeviceImpl.checkHandler(handler, callback);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(requests, this.createCaptureCallbackProxy(handler, callback), this.mDeviceExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurstRequests(List<CaptureRequest> requests, Executor executor, CameraCaptureSession.CaptureCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.checkRepeatingRequests(requests);
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            executor = CameraDeviceImpl.checkExecutor(executor, callback);
            return this.addPendingSequence(this.mDeviceImpl.setRepeatingBurst(requests, this.createCaptureCallbackProxyWithExecutor(executor, callback), this.mDeviceExecutor));
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkRepeatingRequests(List<CaptureRequest> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("requests must not be null");
        }
        if (requests.isEmpty()) {
            throw new IllegalArgumentException("requests must have at least one element");
        }
        for (CaptureRequest r : requests) {
            if (!r.isReprocess()) continue;
            throw new IllegalArgumentException("repeating reprocess burst requests are not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$stopRepeating() throws CameraAccessException {
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            this.mDeviceImpl.stopRepeating();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$abortCaptures() throws CameraAccessException {
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.mAborting) {
                Log.w("CameraCaptureSession", this.mIdString + "abortCaptures - Session is already aborting; doing nothing");
                return;
            }
            this.mAborting = true;
            this.mAbortDrainer.taskStarted();
            this.mDeviceImpl.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.checkNotClosed();
            this.mDeviceImpl.updateOutputConfiguration(config);
        }
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isReprocessable() {
        return this.mInput != null;
    }

    private final Surface $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getInputSurface() {
        return this.mInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$replaceSessionClose() {
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            this.mSkipUnconfigure = true;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$close() {
        Object object = this.mDeviceImpl.mInterfaceLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
            try {
                this.mDeviceImpl.stopRepeating();
            }
            catch (IllegalStateException e) {
                this.mStateCallback.onClosed(this);
                return;
            }
            catch (CameraAccessException e) {
                Log.e("CameraCaptureSession", this.mIdString + "Exception while stopping repeating: ", e);
            }
            this.mSequenceDrainer.beginDrain();
        }
        if (this.mInput != null) {
            this.mInput.release();
        }
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isAborting() {
        return this.mAborting;
    }

    private final CameraCaptureSession.StateCallback $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createUserStateCallbackProxy(Executor executor, CameraCaptureSession.StateCallback callback) {
        return new CallbackProxies.SessionStateCallbackProxy(executor, callback);
    }

    private final CameraDeviceImpl.CaptureCallback $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback callback) {
        Executor executor = callback != null ? CameraDeviceImpl.checkAndWrapHandler(handler) : null;
        return this.createCaptureCallbackProxyWithExecutor(executor, callback);
    }

    private final CameraDeviceImpl.CaptureCallback $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxyWithExecutor(Executor executor, CameraCaptureSession.CaptureCallback callback) {
        return new CameraDeviceImpl.CaptureCallback(this, callback, executor){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraCaptureSession.CaptureCallback val$callback;
            /* synthetic */ Executor val$executor;
            /* synthetic */ CameraCaptureSessionImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(CameraCaptureSessionImpl this$0, CameraCaptureSession.CaptureCallback captureCallback, Executor executor) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureStarted(CameraDevice camera, CaptureRequest request, long timestamp, long frameNumber) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureStarted(this.this$0, request, timestamp, frameNumber));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCapturePartial(CameraDevice camera, CaptureRequest request, CaptureResult result) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCapturePartial(this.this$0, request, result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureProgressed(CameraDevice camera, CaptureRequest request, CaptureResult partialResult) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureProgressed(this.this$0, request, partialResult));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureCompleted(CameraDevice camera, CaptureRequest request, TotalCaptureResult result) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureCompleted(this.this$0, request, result));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureFailed(CameraDevice camera, CaptureRequest request, CaptureFailure failure) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureFailed(this.this$0, request, failure));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceCompleted(CameraDevice camera, int sequenceId, long frameNumber) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureSequenceCompleted(this.this$0, sequenceId, frameNumber));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                this.this$0.finishPendingSequence(sequenceId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceAborted(CameraDevice camera, int sequenceId) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureSequenceAborted(this.this$0, sequenceId));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                this.this$0.finishPendingSequence(sequenceId);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureBufferLost(CameraDevice camera, CaptureRequest request, Surface target, long frameNumber) {
                if (this.val$callback != null && this.val$executor != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.val$executor.execute(() -> this.val$callback.onCaptureBufferLost(this.this$0, request, target, frameNumber));
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }

            private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, CameraCaptureSession.CaptureCallback captureCallback, Executor executor) {
                this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(cameraCaptureSessionImpl, captureCallback, executor);
            }
            {
                this.this$0 = cameraCaptureSessionImpl;
                this.val$callback = captureCallback;
                this.val$executor = executor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl android.hardware.camera2.CameraCaptureSession$CaptureCallback java.util.concurrent.Executor ), 0, this, cameraCaptureSessionImpl, captureCallback, executor);
            }

            @Override
            public void onCaptureStarted(CameraDevice cameraDevice, CaptureRequest captureRequest, long l, long l2) {
                InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureStarted(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest long long ), 0, this, cameraDevice, captureRequest, l, l2);
            }

            @Override
            public void onCapturePartial(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
                InvokeDynamicSupport.bootstrap("onCapturePartial", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCapturePartial(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDevice, captureRequest, captureResult);
            }

            @Override
            public void onCaptureProgressed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureResult captureResult) {
                InvokeDynamicSupport.bootstrap("onCaptureProgressed", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureProgressed(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDevice, captureRequest, captureResult);
            }

            @Override
            public void onCaptureCompleted(CameraDevice cameraDevice, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                InvokeDynamicSupport.bootstrap("onCaptureCompleted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureCompleted(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.TotalCaptureResult ), 0, this, cameraDevice, captureRequest, totalCaptureResult);
            }

            @Override
            public void onCaptureFailed(CameraDevice cameraDevice, CaptureRequest captureRequest, CaptureFailure captureFailure) {
                InvokeDynamicSupport.bootstrap("onCaptureFailed", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureFailed(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureFailure ), 0, this, cameraDevice, captureRequest, captureFailure);
            }

            @Override
            public void onCaptureSequenceCompleted(CameraDevice cameraDevice, int n, long l) {
                InvokeDynamicSupport.bootstrap("onCaptureSequenceCompleted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceCompleted(android.hardware.camera2.CameraDevice int long ), 0, this, cameraDevice, n, l);
            }

            @Override
            public void onCaptureSequenceAborted(CameraDevice cameraDevice, int n) {
                InvokeDynamicSupport.bootstrap("onCaptureSequenceAborted", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureSequenceAborted(android.hardware.camera2.CameraDevice int ), 0, this, cameraDevice, n);
            }

            @Override
            public void onCaptureBufferLost(CameraDevice cameraDevice, CaptureRequest captureRequest, Surface surface, long l) {
                InvokeDynamicSupport.bootstrap("onCaptureBufferLost", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_1$onCaptureBufferLost(android.hardware.camera2.CameraDevice android.hardware.camera2.CaptureRequest android.view.Surface long ), 0, this, cameraDevice, captureRequest, surface, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final CameraDeviceImpl.StateCallbackKK $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDeviceStateCallback() {
        CameraCaptureSessionImpl session = this;
        Object interfaceLock = this.mDeviceImpl.mInterfaceLock;
        return new ShadowedObject(this, session, interfaceLock){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mBusy;
            private boolean mActive;
            /* synthetic */ CameraCaptureSession val$session;
            /* synthetic */ Object val$interfaceLock;
            /* synthetic */ CameraCaptureSessionImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(CameraCaptureSessionImpl this$0, CameraCaptureSession cameraCaptureSession, Object object) {
                this.mBusy = false;
                this.mActive = false;
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onOpened(CameraDevice camera) {
                throw new AssertionError((Object)"Camera must already be open before creating a session");
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onDisconnected(CameraDevice camera) {
                this.this$0.close();
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onError(CameraDevice camera, int error) {
                Log.wtf("CameraCaptureSession", this.this$0.mIdString + "Got device error " + error);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onActive(CameraDevice camera) {
                this.this$0.mIdleDrainer.taskStarted();
                this.mActive = true;
                this.this$0.mStateCallback.onActive(this.val$session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onIdle(CameraDevice camera) {
                boolean isAborting;
                Object object = this.val$interfaceLock;
                synchronized (object) {
                    isAborting = this.this$0.mAborting;
                }
                if (this.mBusy && isAborting) {
                    this.this$0.mAbortDrainer.taskFinished();
                    object = this.val$interfaceLock;
                    synchronized (object) {
                        this.this$0.mAborting = false;
                    }
                }
                if (this.mActive) {
                    this.this$0.mIdleDrainer.taskFinished();
                }
                this.mBusy = false;
                this.mActive = false;
                this.this$0.mStateCallback.onReady(this.val$session);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onBusy(CameraDevice camera) {
                this.mBusy = true;
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onUnconfigured(CameraDevice camera) {
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onRequestQueueEmpty() {
                this.this$0.mStateCallback.onCaptureQueueEmpty(this.val$session);
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onSurfacePrepared(Surface surface) {
                this.this$0.mStateCallback.onSurfacePrepared(this.val$session, surface);
            }

            private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, CameraCaptureSession cameraCaptureSession, Object object) {
                this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(cameraCaptureSessionImpl, cameraCaptureSession, object);
            }
            {
                this.this$0 = cameraCaptureSessionImpl;
                this.val$session = cameraCaptureSession;
                this.val$interfaceLock = object;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl android.hardware.camera2.CameraCaptureSession java.lang.Object ), 0, this, cameraCaptureSessionImpl, cameraCaptureSession, object);
            }

            @Override
            public void onOpened(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onOpened", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onOpened(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onDisconnected(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onDisconnected(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onError(CameraDevice cameraDevice, int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onError(android.hardware.camera2.CameraDevice int ), 0, this, cameraDevice, n);
            }

            @Override
            public void onActive(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onActive", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onActive(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onIdle(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onIdle(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onBusy(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onBusy(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onUnconfigured(CameraDevice cameraDevice) {
                InvokeDynamicSupport.bootstrap("onUnconfigured", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onUnconfigured(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
            }

            @Override
            public void onRequestQueueEmpty() {
                InvokeDynamicSupport.bootstrap("onRequestQueueEmpty", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onRequestQueueEmpty(), 0, this);
            }

            @Override
            public void onSurfacePrepared(Surface surface) {
                InvokeDynamicSupport.bootstrap("onSurfacePrepared", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_2$onSurfacePrepared(android.view.Surface ), 0, this, surface);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Session has been closed; further changes are illegal.");
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$addPendingSequence(int sequenceId) {
        this.mSequenceDrainer.taskStarted(sequenceId);
        return sequenceId;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finishPendingSequence(int sequenceId) {
        try {
            this.mSequenceDrainer.taskFinished(sequenceId);
        }
        catch (IllegalStateException e) {
            Log.w("CameraCaptureSession", e.getMessage());
        }
    }

    private void __constructor__(int n, Surface surface, CameraCaptureSession.StateCallback stateCallback, Executor executor, CameraDeviceImpl cameraDeviceImpl, Executor executor2, boolean bl) {
        this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(n, surface, stateCallback, executor, cameraDeviceImpl, executor2, bl);
    }

    CameraCaptureSessionImpl(int n, Surface surface, CameraCaptureSession.StateCallback stateCallback, Executor executor, CameraDeviceImpl cameraDeviceImpl, Executor executor2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$__constructor__(int android.view.Surface android.hardware.camera2.CameraCaptureSession$StateCallback java.util.concurrent.Executor android.hardware.camera2.impl.CameraDeviceImpl java.util.concurrent.Executor boolean ), 0, this, n, surface, stateCallback, executor, cameraDeviceImpl, executor2, bl);
    }

    @Override
    public CameraDevice getDevice() {
        return InvokeDynamicSupport.bootstrap("getDevice", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDevice(), 0, this);
    }

    @Override
    public void prepare(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void prepare(int n, Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$prepare(int android.view.Surface ), 0, this, n, surface);
    }

    @Override
    public void tearDown(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$tearDown(android.view.Surface ), 0, this, surface);
    }

    @Override
    public void finalizeOutputConfigurations(List<OutputConfiguration> list) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("finalizeOutputConfigurations", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalizeOutputConfigurations(java.util.List<android.hardware.camera2.params.OutputConfiguration> ), 0, this, list);
    }

    @Override
    public int capture(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("capture", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$capture(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public int captureSingleRequest(CaptureRequest captureRequest, Executor executor, CameraCaptureSession.CaptureCallback captureCallback) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureSingleRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureSingleRequest(android.hardware.camera2.CaptureRequest java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, captureRequest, executor, captureCallback);
    }

    private void checkCaptureRequest(CaptureRequest captureRequest) {
        InvokeDynamicSupport.bootstrap("checkCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkCaptureRequest(android.hardware.camera2.CaptureRequest ), 0, this, captureRequest);
    }

    @Override
    public int captureBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurst", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public int captureBurstRequests(List<CaptureRequest> list, Executor executor, CameraCaptureSession.CaptureCallback captureCallback) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurstRequests", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$captureBurstRequests(java.util.List<android.hardware.camera2.CaptureRequest> java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, list, executor, captureCallback);
    }

    private void checkCaptureRequests(List<CaptureRequest> list) {
        InvokeDynamicSupport.bootstrap("checkCaptureRequests", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkCaptureRequests(java.util.List<android.hardware.camera2.CaptureRequest> ), 0, this, list);
    }

    @Override
    public int setRepeatingRequest(CaptureRequest captureRequest, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingRequest(android.hardware.camera2.CaptureRequest android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    @Override
    public int setSingleRepeatingRequest(CaptureRequest captureRequest, Executor executor, CameraCaptureSession.CaptureCallback captureCallback) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setSingleRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setSingleRepeatingRequest(android.hardware.camera2.CaptureRequest java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, captureRequest, executor, captureCallback);
    }

    private void checkRepeatingRequest(CaptureRequest captureRequest) {
        InvokeDynamicSupport.bootstrap("checkRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkRepeatingRequest(android.hardware.camera2.CaptureRequest ), 0, this, captureRequest);
    }

    @Override
    public int setRepeatingBurst(List<CaptureRequest> list, CameraCaptureSession.CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurst", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.CameraCaptureSession$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    @Override
    public int setRepeatingBurstRequests(List<CaptureRequest> list, Executor executor, CameraCaptureSession.CaptureCallback captureCallback) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurstRequests", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$setRepeatingBurstRequests(java.util.List<android.hardware.camera2.CaptureRequest> java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, list, executor, captureCallback);
    }

    private void checkRepeatingRequests(List<CaptureRequest> list) {
        InvokeDynamicSupport.bootstrap("checkRepeatingRequests", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkRepeatingRequests(java.util.List<android.hardware.camera2.CaptureRequest> ), 0, this, list);
    }

    @Override
    public void stopRepeating() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$stopRepeating(), 0, this);
    }

    @Override
    public void abortCaptures() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("abortCaptures", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$abortCaptures(), 0, this);
    }

    @Override
    public void updateOutputConfiguration(OutputConfiguration outputConfiguration) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("updateOutputConfiguration", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$updateOutputConfiguration(android.hardware.camera2.params.OutputConfiguration ), 0, this, outputConfiguration);
    }

    @Override
    public boolean isReprocessable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReprocessable", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isReprocessable(), 0, this);
    }

    @Override
    public Surface getInputSurface() {
        return InvokeDynamicSupport.bootstrap("getInputSurface", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getInputSurface(), 0, this);
    }

    @Override
    public void replaceSessionClose() {
        InvokeDynamicSupport.bootstrap("replaceSessionClose", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$replaceSessionClose(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$close(), 0, this);
    }

    @Override
    public boolean isAborting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAborting", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$isAborting(), 0, this);
    }

    private CameraCaptureSession.StateCallback createUserStateCallbackProxy(Executor executor, CameraCaptureSession.StateCallback stateCallback) {
        return InvokeDynamicSupport.bootstrap("createUserStateCallbackProxy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createUserStateCallbackProxy(java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$StateCallback ), 0, this, executor, stateCallback);
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxy(Handler handler, CameraCaptureSession.CaptureCallback captureCallback) {
        return InvokeDynamicSupport.bootstrap("createCaptureCallbackProxy", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxy(android.os.Handler android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, handler, captureCallback);
    }

    private CameraDeviceImpl.CaptureCallback createCaptureCallbackProxyWithExecutor(Executor executor, CameraCaptureSession.CaptureCallback captureCallback) {
        return InvokeDynamicSupport.bootstrap("createCaptureCallbackProxyWithExecutor", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$createCaptureCallbackProxyWithExecutor(java.util.concurrent.Executor android.hardware.camera2.CameraCaptureSession$CaptureCallback ), 0, this, executor, captureCallback);
    }

    @Override
    public CameraDeviceImpl.StateCallbackKK getDeviceStateCallback() {
        return InvokeDynamicSupport.bootstrap("getDeviceStateCallback", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$getDeviceStateCallback(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finalize(), 0, this);
    }

    private void checkNotClosed() {
        InvokeDynamicSupport.bootstrap("checkNotClosed", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$checkNotClosed(), 0, this);
    }

    private int addPendingSequence(int n) {
        return (int)InvokeDynamicSupport.bootstrap("addPendingSequence", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$addPendingSequence(int ), 0, this, n);
    }

    private void finishPendingSequence(int n) {
        InvokeDynamicSupport.bootstrap("finishPendingSequence", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl$finishPendingSequence(int ), 0, this, n);
    }

    public /* synthetic */ CameraCaptureSessionImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraCaptureSessionImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IdleDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$onDrained() {
            Object object = ((CameraCaptureSessionImpl)this.this$0).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mSkipUnconfigure) {
                    return;
                }
                try {
                    this.this$0.mDeviceImpl.configureStreamsChecked(null, null, 0, null);
                }
                catch (CameraAccessException e) {
                    Log.e("CameraCaptureSession", this.this$0.mIdString + "Exception while unconfiguring outputs: ", e);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private IdleDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_IdleDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ IdleDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AbortDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$onDrained() {
            Object object = ((CameraCaptureSessionImpl)this.this$0).mDeviceImpl.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mSkipUnconfigure) {
                    return;
                }
                this.this$0.mIdleDrainer.beginDrain();
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private AbortDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_AbortDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ AbortDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbortDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SequenceDrainListener
    implements TaskDrainer.DrainListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraCaptureSessionImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$onDrained() {
            this.this$0.mStateCallback.onClosed(this.this$0);
            if (this.this$0.mSkipUnconfigure) {
                return;
            }
            this.this$0.mAbortDrainer.beginDrain();
        }

        private /* synthetic */ void $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(CameraCaptureSessionImpl x0, 1 x1) {
        }

        private void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(cameraCaptureSessionImpl);
        }

        private SequenceDrainListener(CameraCaptureSessionImpl cameraCaptureSessionImpl) {
            this.this$0 = cameraCaptureSessionImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(android.hardware.camera2.impl.CameraCaptureSessionImpl ), 0, this, cameraCaptureSessionImpl);
        }

        @Override
        public void onDrained() {
            InvokeDynamicSupport.bootstrap("onDrained", $$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$onDrained(), 0, this);
        }

        private /* synthetic */ void __constructor__(CameraCaptureSessionImpl cameraCaptureSessionImpl, 1 var2_2) {
            this.$$robo$$android_hardware_camera2_impl_CameraCaptureSessionImpl_SequenceDrainListener$__constructor__(cameraCaptureSessionImpl, var2_2);
        }

        public /* synthetic */ SequenceDrainListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SequenceDrainListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

