/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestThreadManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.ArrayUtils;
import android.hardware.camera2.utils.SubmitInfo;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyCameraDevice
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private static boolean DEBUG = false;
    private int mCameraId;
    private CameraCharacteristics mStaticCharacteristics;
    private ICameraDeviceCallbacks mDeviceCallbacks;
    private CameraDeviceState mDeviceState;
    private SparseArray<Surface> mConfiguredSurfaces;
    private boolean mClosed;
    private ConditionVariable mIdle;
    private HandlerThread mResultThread;
    private HandlerThread mCallbackHandlerThread;
    private Handler mCallbackHandler;
    private Handler mResultHandler;
    private static int ILLEGAL_VALUE = -1;
    private static int GRALLOC_USAGE_RENDERSCRIPT = 0x100000;
    private static int GRALLOC_USAGE_SW_READ_OFTEN = 3;
    private static int GRALLOC_USAGE_HW_TEXTURE = 256;
    private static int GRALLOC_USAGE_HW_COMPOSER = 2048;
    private static int GRALLOC_USAGE_HW_RENDER = 512;
    private static int GRALLOC_USAGE_HW_VIDEO_ENCODER = 65536;
    public static int MAX_DIMEN_FOR_ROUNDING = 1920;
    public static int NATIVE_WINDOW_SCALING_MODE_SCALE_TO_WINDOW = 1;
    private CameraDeviceState.CameraDeviceStateListener mStateListener;
    private RequestThreadManager mRequestThreadManager;

    private final CaptureResultExtras $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(RequestHolder holder) {
        return this.getExtrasFromRequest(holder, -1, null);
    }

    private final CaptureResultExtras $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(RequestHolder holder, int errorCode, Object errorArg) {
        int errorStreamId = -1;
        if (errorCode == 5) {
            Surface errorTarget = (Surface)errorArg;
            int indexOfTarget = this.mConfiguredSurfaces.indexOfValue(errorTarget);
            if (indexOfTarget < 0) {
                Log.e(this.TAG, "Buffer drop error reported for unknown Surface");
            } else {
                errorStreamId = this.mConfiguredSurfaces.keyAt(indexOfTarget);
            }
        }
        if (holder == null) {
            return new CaptureResultExtras(-1, -1, -1, -1, -1L, -1, -1);
        }
        return new CaptureResultExtras(holder.getRequestId(), holder.getSubsequeceId(), 0, 0, holder.getFrameNumber(), 1, errorStreamId);
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$needsConversion(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        int nativeType = LegacyCameraDevice.detectSurfaceType(s);
        return nativeType == 35 || nativeType == 842094169 || nativeType == 17;
    }

    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(int cameraId, Camera camera, CameraCharacteristics characteristics, ICameraDeviceCallbacks callbacks) {
        this.mDeviceState = new CameraDeviceState();
        this.mClosed = false;
        this.mIdle = new ConditionVariable(true);
        this.mResultThread = new HandlerThread("ResultThread");
        this.mCallbackHandlerThread = new HandlerThread("CallbackThread");
        this.mStateListener = new CameraDeviceState.CameraDeviceStateListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ LegacyCameraDevice this$0;

            private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(LegacyCameraDevice this$0) {
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onError(int errorCode, Object errorArg, RequestHolder holder) {
                switch (errorCode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.this$0.mIdle.open();
                    }
                }
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder, errorCode, errorArg);
                this.this$0.mResultHandler.post(new Runnable(this, holder, errorCode, extras){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ int val$errorCode;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(1 this$1, RequestHolder requestHolder, int n, CaptureResultExtras captureResultExtras) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onDeviceError(this.val$errorCode, this.val$extras);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, int n, CaptureResultExtras captureResultExtras) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(var1_1, requestHolder, n, captureResultExtras);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$errorCode = n;
                        this.val$extras = captureResultExtras;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, var1_1, requestHolder, n, captureResultExtras);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onConfiguring() {
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onIdle() {
                this.this$0.mIdle.open();
                this.this$0.mResultHandler.post(new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(1 this$1) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onDeviceIdle();
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraIdle callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onBusy() {
                this.this$0.mIdle.close();
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureStarted(RequestHolder holder, long timestamp) {
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder);
                this.this$0.mResultHandler.post(new Runnable(this, holder, extras, timestamp){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ long val$timestamp;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(1 this$1, RequestHolder requestHolder, CaptureResultExtras captureResultExtras, long l) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onCaptureStarted(this.val$extras, this.val$timestamp);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, CaptureResultExtras captureResultExtras, long l) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(var1_1, requestHolder, captureResultExtras, l);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$extras = captureResultExtras;
                        this.val$timestamp = l;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CaptureResultExtras long ), 0, this, var1_1, requestHolder, captureResultExtras, l);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onRequestQueueEmpty() {
                this.this$0.mResultHandler.post(new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(1 this$1) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onRequestQueueEmpty();
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onRequestQueueEmpty callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_4$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureResult(CameraMetadataNative result, RequestHolder holder) {
                CaptureResultExtras extras = this.this$0.getExtrasFromRequest(holder);
                this.this$0.mResultHandler.post(new Runnable(this, holder, result, extras){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RequestHolder val$holder;
                    /* synthetic */ CameraMetadataNative val$result;
                    /* synthetic */ CaptureResultExtras val$extras;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_5$__constructor__(1 this$1, RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_5$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onResultReceived(this.val$result, this.val$extras, new PhysicalCaptureResultInfo[0]);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, RequestHolder requestHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_5$__constructor__(var1_1, requestHolder, cameraMetadataNative, captureResultExtras);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$holder = requestHolder;
                        this.val$result = cameraMetadataNative;
                        this.val$extras = captureResultExtras;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_5$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 android.hardware.camera2.legacy.RequestHolder android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), 0, this, var1_1, requestHolder, cameraMetadataNative, captureResultExtras);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_5$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) {
                this.this$0.mResultHandler.post(new Runnable(this, lastFrameNumber, repeatingRequestId){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ long val$lastFrameNumber;
                    /* synthetic */ int val$repeatingRequestId;
                    /* synthetic */ 1 this$1;

                    private void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_6$__constructor__(1 this$1, long l, int n) {
                    }

                    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_6$run() {
                        try {
                            this.this$1.this$0.mDeviceCallbacks.onRepeatingRequestError(this.val$lastFrameNumber, this.val$repeatingRequestId);
                        }
                        catch (RemoteException e) {
                            throw new IllegalStateException("Received remote exception during onRepeatingRequestError callback: ", e);
                        }
                    }

                    private void __constructor__(1 var1_1, long l, int n) {
                        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_6$__constructor__(var1_1, l, n);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$lastFrameNumber = l;
                        this.val$repeatingRequestId = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_6$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice$1 long int ), 0, this, var1_1, l, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1_6$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(LegacyCameraDevice legacyCameraDevice) {
                this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(legacyCameraDevice);
            }
            {
                this.this$0 = legacyCameraDevice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$__constructor__(android.hardware.camera2.legacy.LegacyCameraDevice ), 0, this, legacyCameraDevice);
            }

            @Override
            public void onError(int n, Object object, RequestHolder requestHolder) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onError(int java.lang.Object android.hardware.camera2.legacy.RequestHolder ), 0, this, n, object, requestHolder);
            }

            @Override
            public void onConfiguring() {
                InvokeDynamicSupport.bootstrap("onConfiguring", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onConfiguring(), 0, this);
            }

            @Override
            public void onIdle() {
                InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onIdle(), 0, this);
            }

            @Override
            public void onBusy() {
                InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onBusy(), 0, this);
            }

            @Override
            public void onCaptureStarted(RequestHolder requestHolder, long l) {
                InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureStarted(android.hardware.camera2.legacy.RequestHolder long ), 0, this, requestHolder, l);
            }

            @Override
            public void onRequestQueueEmpty() {
                InvokeDynamicSupport.bootstrap("onRequestQueueEmpty", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onRequestQueueEmpty(), 0, this);
            }

            @Override
            public void onCaptureResult(CameraMetadataNative cameraMetadataNative, RequestHolder requestHolder) {
                InvokeDynamicSupport.bootstrap("onCaptureResult", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onCaptureResult(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.legacy.RequestHolder ), 0, this, cameraMetadataNative, requestHolder);
            }

            @Override
            public void onRepeatingRequestError(long l, int n) {
                InvokeDynamicSupport.bootstrap("onRepeatingRequestError", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice_1$onRepeatingRequestError(long int ), 0, this, l, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCameraId = cameraId;
        this.mDeviceCallbacks = callbacks;
        this.TAG = String.format("CameraDevice-%d-LE", this.mCameraId);
        this.mResultThread.start();
        this.mResultHandler = new Handler(this.mResultThread.getLooper());
        this.mCallbackHandlerThread.start();
        this.mCallbackHandler = new Handler(this.mCallbackHandlerThread.getLooper());
        this.mDeviceState.setCameraDeviceCallbacks(this.mCallbackHandler, this.mStateListener);
        this.mStaticCharacteristics = characteristics;
        this.mRequestThreadManager = new RequestThreadManager(cameraId, camera, characteristics, this.mDeviceState);
        this.mRequestThreadManager.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureOutputs(SparseArray<Surface> outputs) {
        ArrayList<Pair<Surface, Size>> sizedSurfaces = new ArrayList<Pair<Surface, Size>>();
        if (outputs != null) {
            int count = outputs.size();
            for (int i = 0; i < count; ++i) {
                Surface output = outputs.valueAt(i);
                if (output == null) {
                    Log.e(this.TAG, "configureOutputs - null outputs are not allowed");
                    return LegacyExceptionUtils.BAD_VALUE;
                }
                if (!output.isValid()) {
                    Log.e(this.TAG, "configureOutputs - invalid output surfaces are not allowed");
                    return LegacyExceptionUtils.BAD_VALUE;
                }
                StreamConfigurationMap streamConfigurations = this.mStaticCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                try {
                    Size s;
                    block14: {
                        s = LegacyCameraDevice.getSurfaceSize(output);
                        int surfaceType = LegacyCameraDevice.detectSurfaceType(output);
                        boolean flexibleConsumer = LegacyCameraDevice.isFlexibleConsumer(output);
                        Object[] sizes = streamConfigurations.getOutputSizes(surfaceType);
                        if (sizes == null) {
                            if (surfaceType == 34) {
                                sizes = streamConfigurations.getOutputSizes(35);
                            } else if (surfaceType == 33) {
                                sizes = streamConfigurations.getOutputSizes(256);
                            }
                        }
                        if (!ArrayUtils.contains(sizes, s)) {
                            if (flexibleConsumer && (s = LegacyCameraDevice.findClosestSize(s, (Size[])sizes)) != null) {
                                sizedSurfaces.add(new Pair<Surface, Size>(output, s));
                                break block14;
                            } else {
                                String reason = sizes == null ? "format is invalid." : "size not in valid set: " + Arrays.toString(sizes);
                                Log.e(this.TAG, String.format("Surface with size (w=%d, h=%d) and format 0x%x is not valid, %s", s.getWidth(), s.getHeight(), surfaceType, reason));
                                return LegacyExceptionUtils.BAD_VALUE;
                            }
                        }
                        sizedSurfaces.add(new Pair<Surface, Size>(output, s));
                    }
                    LegacyCameraDevice.setSurfaceDimens(output, s.getWidth(), s.getHeight());
                    continue;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.e(this.TAG, "Surface bufferqueue is abandoned, cannot configure as output: ", e);
                    return LegacyExceptionUtils.BAD_VALUE;
                }
            }
        }
        boolean success = false;
        if (this.mDeviceState.setConfiguring()) {
            this.mRequestThreadManager.configure(sizedSurfaces);
            success = this.mDeviceState.setIdle();
        }
        if (!success) return LegacyExceptionUtils.INVALID_OPERATION;
        this.mConfiguredSurfaces = outputs;
        return 0;
    }

    private final SubmitInfo $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequestList(CaptureRequest[] requestList, boolean repeating) {
        ArrayList<Long> surfaceIds;
        if (requestList == null || requestList.length == 0) {
            Log.e(this.TAG, "submitRequestList - Empty/null requests are not allowed");
            throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Empty/null requests are not allowed");
        }
        try {
            surfaceIds = this.mConfiguredSurfaces == null ? new ArrayList() : LegacyCameraDevice.getSurfaceIds(this.mConfiguredSurfaces);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - configured surface is abandoned.");
        }
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                Log.e(this.TAG, "submitRequestList - Each request must have at least one Surface target");
                throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface == null) {
                    Log.e(this.TAG, "submitRequestList - Null Surface targets are not allowed");
                    throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - Null Surface targets are not allowed");
                }
                if (this.mConfiguredSurfaces == null) {
                    Log.e(this.TAG, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                    throw new ServiceSpecificException(LegacyExceptionUtils.INVALID_OPERATION, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                }
                if (LegacyCameraDevice.containsSurfaceId(surface, surfaceIds)) continue;
                Log.e(this.TAG, "submitRequestList - cannot use a surface that wasn't configured");
                throw new ServiceSpecificException(LegacyExceptionUtils.BAD_VALUE, "submitRequestList - cannot use a surface that wasn't configured");
            }
        }
        this.mIdle.close();
        return this.mRequestThreadManager.submitCaptureRequests(requestList, repeating);
    }

    private final SubmitInfo $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequest(CaptureRequest request, boolean repeating) {
        CaptureRequest[] requestList = new CaptureRequest[]{request};
        return this.submitRequestList(requestList, repeating);
    }

    private final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$cancelRequest(int requestId) {
        return this.mRequestThreadManager.cancelRepeating(requestId);
    }

    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$waitUntilIdle() {
        this.mIdle.block();
    }

    private final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$flush() {
        long lastFrame = this.mRequestThreadManager.flush();
        this.waitUntilIdle();
        return lastFrame;
    }

    private final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isClosed() {
        return this.mClosed;
    }

    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$close() {
        this.mRequestThreadManager.quit();
        this.mCallbackHandlerThread.quitSafely();
        this.mResultThread.quitSafely();
        try {
            this.mCallbackHandlerThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mCallbackHandlerThread.getName(), this.mCallbackHandlerThread.getId()));
        }
        try {
            this.mResultThread.join();
        }
        catch (InterruptedException e) {
            Log.e(this.TAG, String.format("Thread %s (%d) interrupted while quitting.", this.mResultThread.getName(), this.mResultThread.getId()));
        }
        this.mClosed = true;
    }

    private final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$finalize() throws Throwable {
        try {
            this.close();
        }
        catch (ServiceSpecificException e) {
            Log.e(this.TAG, "Got error while trying to finalize, ignoring: " + e.getMessage());
        }
        finally {
            super.finalize();
        }
    }

    private static final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$findEuclidDistSquare(Size a, Size b) {
        long d0 = a.getWidth() - b.getWidth();
        long d1 = a.getHeight() - b.getHeight();
        return d0 * d0 + d1 * d1;
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$findClosestSize(Size size, Size[] supportedSizes) {
        if (size == null || supportedSizes == null) {
            return null;
        }
        Size bestSize = null;
        for (Size s : supportedSizes) {
            if (s.equals(size)) {
                return size;
            }
            if (s.getWidth() > 1920 || bestSize != null && LegacyCameraDevice.findEuclidDistSquare(size, s) >= LegacyCameraDevice.findEuclidDistSquare(bestSize, s)) continue;
            bestSize = s;
        }
        return bestSize;
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDimens(surface, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isFlexibleConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 0x110000;
        int allowedFlags = 2307;
        boolean flexibleConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        return flexibleConsumer;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isPreviewConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 0x110003;
        int allowedFlags = 2816;
        boolean previewConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        int surfaceFormat = 0;
        try {
            surfaceFormat = LegacyCameraDevice.detectSurfaceType(output);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
        return previewConsumer;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isVideoEncoderConsumer(Surface output) {
        int usageFlags = LegacyCameraDevice.detectSurfaceUsageFlags(output);
        int disallowedFlags = 1050883;
        int allowedFlags = 65536;
        boolean videoEncoderConsumer = (usageFlags & disallowedFlags) == 0 && (usageFlags & allowedFlags) != 0;
        int surfaceFormat = 0;
        try {
            surfaceFormat = LegacyCameraDevice.detectSurfaceType(output);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            throw new IllegalArgumentException("Surface was abandoned", e);
        }
        return videoEncoderConsumer;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceUsageFlags(Surface surface) {
        Preconditions.checkNotNull(surface);
        return LegacyCameraDevice.nativeDetectSurfaceUsageFlags(surface);
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int surfaceType = LegacyCameraDevice.nativeDetectSurfaceType(surface);
        if (surfaceType >= 1 && surfaceType <= 5) {
            surfaceType = 34;
        }
        return LegacyExceptionUtils.throwOnError(surfaceType);
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceDataspace(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        return LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDataspace(surface));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$connectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeConnectSurface(surface));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$disconnectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surface == null) {
            return;
        }
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDisconnectSurface(surface));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$produceFrame(Surface surface, byte[] pixelBuffer, int width, int height, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkNotNull(pixelBuffer);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeProduceFrame(surface, pixelBuffer, width, height, pixelFormat));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceFormat(Surface surface, int pixelFormat) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceFormat(surface, pixelFormat));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceDimens(Surface surface, int width, int height) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(width, "width must be positive.");
        Preconditions.checkArgumentPositive(height, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceDimens(surface, width, height));
    }

    private static final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceId(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        try {
            return LegacyCameraDevice.nativeGetSurfaceId(surface);
        }
        catch (IllegalArgumentException e) {
            throw new LegacyExceptionUtils.BufferQueueAbandonedException();
        }
    }

    private static final List<Long> $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(SparseArray<Surface> surfaces) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surfaces == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> surfaceIds = new ArrayList<Long>();
        int count = surfaces.size();
        for (int i = 0; i < count; ++i) {
            long id2 = LegacyCameraDevice.getSurfaceId(surfaces.valueAt(i));
            if (id2 == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            surfaceIds.add(id2);
        }
        return surfaceIds;
    }

    private static final List<Long> $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(Collection<Surface> surfaces) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        if (surfaces == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> surfaceIds = new ArrayList<Long>();
        for (Surface s : surfaces) {
            long id2 = LegacyCameraDevice.getSurfaceId(s);
            if (id2 == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            surfaceIds.add(id2);
        }
        return surfaceIds;
    }

    private static final boolean $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$containsSurfaceId(Surface s, Collection<Long> ids) {
        long id2 = 0L;
        try {
            id2 = LegacyCameraDevice.getSurfaceId(s);
        }
        catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
            return false;
        }
        return ids.contains(id2);
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceOrientation(Surface surface, int facing, int sensorOrientation) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceOrientation(surface, facing, sensorOrientation));
    }

    private static final Size $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surfaceTexture);
        int[] dimens = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectTextureDimens(surfaceTexture, dimens));
        return new Size(dimens[0], dimens[1]);
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setNextTimestamp(Surface surface, long timestamp) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetNextTimestamp(surface, timestamp));
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setScalingMode(Surface surface, int mode) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetScalingMode(surface, mode));
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceType(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDataspace(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeConnectSurface(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeProduceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceFormat(Surface surface, int n) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceDimens(Surface surface, int n, int n2) {
        return 0;
    }

    private static final long $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetSurfaceId(Surface surface) {
        return 0L;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceOrientation(Surface surface, int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectTextureDimens(SurfaceTexture surfaceTexture, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetNextTimestamp(Surface surface, long l) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceUsageFlags(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetScalingMode(Surface surface, int n) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDisconnectSurface(Surface surface) {
        return 0;
    }

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetJpegFooterSize() {
        return 0;
    }

    private CaptureResultExtras getExtrasFromRequest(RequestHolder requestHolder) {
        return InvokeDynamicSupport.bootstrap("getExtrasFromRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(android.hardware.camera2.legacy.RequestHolder ), 0, this, requestHolder);
    }

    private CaptureResultExtras getExtrasFromRequest(RequestHolder requestHolder, int n, Object object) {
        return InvokeDynamicSupport.bootstrap("getExtrasFromRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getExtrasFromRequest(android.hardware.camera2.legacy.RequestHolder int java.lang.Object ), 0, this, requestHolder, n, object);
    }

    static boolean needsConversion(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("needsConversion", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$needsConversion(android.view.Surface ), 0, (Surface)surface);
    }

    private void __constructor__(int n, Camera camera, CameraCharacteristics cameraCharacteristics, ICameraDeviceCallbacks iCameraDeviceCallbacks) {
        this.$$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(n, camera, cameraCharacteristics, iCameraDeviceCallbacks);
    }

    public LegacyCameraDevice(int n, Camera camera, CameraCharacteristics cameraCharacteristics, ICameraDeviceCallbacks iCameraDeviceCallbacks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$__constructor__(int android.hardware.Camera android.hardware.camera2.CameraCharacteristics android.hardware.camera2.ICameraDeviceCallbacks ), 0, this, n, camera, cameraCharacteristics, iCameraDeviceCallbacks);
    }

    public int configureOutputs(SparseArray<Surface> sparseArray) {
        return (int)InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$configureOutputs(android.util.SparseArray<android.view.Surface> ), 0, this, sparseArray);
    }

    public SubmitInfo submitRequestList(CaptureRequest[] captureRequestArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submitRequestList", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequestList(android.hardware.camera2.CaptureRequest[] boolean ), 0, this, captureRequestArray, bl);
    }

    public SubmitInfo submitRequest(CaptureRequest captureRequest, boolean bl) {
        return InvokeDynamicSupport.bootstrap("submitRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$submitRequest(android.hardware.camera2.CaptureRequest boolean ), 0, this, captureRequest, bl);
    }

    public long cancelRequest(int n) {
        return (long)InvokeDynamicSupport.bootstrap("cancelRequest", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$cancelRequest(int ), 0, this, n);
    }

    public void waitUntilIdle() {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$waitUntilIdle(), 0, this);
    }

    public long flush() {
        return (long)InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$flush(), 0, this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isClosed(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$finalize(), 0, this);
    }

    static long findEuclidDistSquare(Size size, Size size2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("findEuclidDistSquare", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$findEuclidDistSquare(android.util.Size android.util.Size ), 0, (Size)size, (Size)size2);
    }

    static Size findClosestSize(Size size, Size[] sizeArray) {
        return InvokeDynamicSupport.bootstrapStatic("findClosestSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$findClosestSize(android.util.Size android.util.Size[] ), 0, (Size)size, (Size[])sizeArray);
    }

    public static Size getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceSize(android.view.Surface ), 0, (Surface)surface);
    }

    public static boolean isFlexibleConsumer(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFlexibleConsumer", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isFlexibleConsumer(android.view.Surface ), 0, (Surface)surface);
    }

    public static boolean isPreviewConsumer(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPreviewConsumer", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isPreviewConsumer(android.view.Surface ), 0, (Surface)surface);
    }

    public static boolean isVideoEncoderConsumer(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVideoEncoderConsumer", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$isVideoEncoderConsumer(android.view.Surface ), 0, (Surface)surface);
    }

    static int detectSurfaceUsageFlags(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("detectSurfaceUsageFlags", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceUsageFlags(android.view.Surface ), 0, (Surface)surface);
    }

    public static int detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (int)InvokeDynamicSupport.bootstrapStatic("detectSurfaceType", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceType(android.view.Surface ), 0, (Surface)surface);
    }

    public static int detectSurfaceDataspace(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (int)InvokeDynamicSupport.bootstrapStatic("detectSurfaceDataspace", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$detectSurfaceDataspace(android.view.Surface ), 0, (Surface)surface);
    }

    static void connectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("connectSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$connectSurface(android.view.Surface ), 0, (Surface)surface);
    }

    static void disconnectSurface(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("disconnectSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$disconnectSurface(android.view.Surface ), 0, (Surface)surface);
    }

    static void produceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("produceFrame", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$produceFrame(android.view.Surface byte[] int int int ), 0, (Surface)surface, (byte[])byArray, (int)n, (int)n2, (int)n3);
    }

    static void setSurfaceFormat(Surface surface, int n) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceFormat", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceFormat(android.view.Surface int ), 0, (Surface)surface, (int)n);
    }

    static void setSurfaceDimens(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceDimens(android.view.Surface int int ), 0, (Surface)surface, (int)n, (int)n2);
    }

    public static long getSurfaceId(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return (long)InvokeDynamicSupport.bootstrapStatic("getSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceId(android.view.Surface ), 0, (Surface)surface);
    }

    static List<Long> getSurfaceIds(SparseArray<Surface> sparseArray) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceIds", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(android.util.SparseArray<android.view.Surface> ), 0, sparseArray);
    }

    static List<Long> getSurfaceIds(Collection<Surface> collection) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getSurfaceIds", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getSurfaceIds(java.util.Collection<android.view.Surface> ), 0, collection);
    }

    static boolean containsSurfaceId(Surface surface, Collection<Long> collection) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$containsSurfaceId(android.view.Surface java.util.Collection<java.lang.Long> ), 0, (Surface)surface, collection);
    }

    static void setSurfaceOrientation(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setSurfaceOrientation", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setSurfaceOrientation(android.view.Surface int int ), 0, (Surface)surface, (int)n, (int)n2);
    }

    static Size getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return InvokeDynamicSupport.bootstrapStatic("getTextureSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$getTextureSize(android.graphics.SurfaceTexture ), 0, (SurfaceTexture)surfaceTexture);
    }

    static void setNextTimestamp(Surface surface, long l) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setNextTimestamp", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setNextTimestamp(android.view.Surface long ), 0, (Surface)surface, (long)l);
    }

    static void setScalingMode(Surface surface, int n) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        InvokeDynamicSupport.bootstrapStatic("setScalingMode", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$setScalingMode(android.view.Surface int ), 0, (Surface)surface, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceType$nativeBinding(Surface var0);

    private static int nativeDetectSurfaceType(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceType", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceType(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceDataspace$nativeBinding(Surface var0);

    private static int nativeDetectSurfaceDataspace(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceDataspace", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDataspace(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceDimens$nativeBinding(Surface var0, int[] var1);

    private static int nativeDetectSurfaceDimens(Surface surface, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceDimens(android.view.Surface int[] ), 1, (Surface)surface, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$nativeConnectSurface$nativeBinding(Surface var0);

    private static int nativeConnectSurface(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeConnectSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeConnectSurface(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeProduceFrame$nativeBinding(Surface var0, byte[] var1, int var2, int var3, int var4);

    private static int nativeProduceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeProduceFrame", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeProduceFrame(android.view.Surface byte[] int int int ), 1, (Surface)surface, (byte[])byArray, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceFormat$nativeBinding(Surface var0, int var1);

    private static int nativeSetSurfaceFormat(Surface surface, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceFormat", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceFormat(android.view.Surface int ), 1, (Surface)surface, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceDimens$nativeBinding(Surface var0, int var1, int var2);

    private static int nativeSetSurfaceDimens(Surface surface, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceDimens(android.view.Surface int int ), 1, (Surface)surface, (int)n, (int)n2);
    }

    private static final native /* synthetic */ long $$robo$$nativeGetSurfaceId$nativeBinding(Surface var0);

    private static long nativeGetSurfaceId(Surface surface) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetSurfaceId", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetSurfaceId(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetSurfaceOrientation$nativeBinding(Surface var0, int var1, int var2);

    private static int nativeSetSurfaceOrientation(Surface surface, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetSurfaceOrientation", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetSurfaceOrientation(android.view.Surface int int ), 1, (Surface)surface, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectTextureDimens$nativeBinding(SurfaceTexture var0, int[] var1);

    private static int nativeDetectTextureDimens(SurfaceTexture surfaceTexture, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectTextureDimens", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectTextureDimens(android.graphics.SurfaceTexture int[] ), 1, (SurfaceTexture)surfaceTexture, (int[])nArray);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetNextTimestamp$nativeBinding(Surface var0, long var1);

    private static int nativeSetNextTimestamp(Surface surface, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetNextTimestamp", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetNextTimestamp(android.view.Surface long ), 1, (Surface)surface, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nativeDetectSurfaceUsageFlags$nativeBinding(Surface var0);

    private static int nativeDetectSurfaceUsageFlags(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDetectSurfaceUsageFlags", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDetectSurfaceUsageFlags(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeSetScalingMode$nativeBinding(Surface var0, int var1);

    private static int nativeSetScalingMode(Surface surface, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeSetScalingMode", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeSetScalingMode(android.view.Surface int ), 1, (Surface)surface, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeDisconnectSurface$nativeBinding(Surface var0);

    private static int nativeDisconnectSurface(Surface surface) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeDisconnectSurface", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeDisconnectSurface(android.view.Surface ), 1, (Surface)surface);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetJpegFooterSize$nativeBinding();

    static int nativeGetJpegFooterSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetJpegFooterSize", $$robo$$android_hardware_camera2_legacy_LegacyCameraDevice$nativeGetJpegFooterSize(), 1);
    }

    public /* synthetic */ LegacyCameraDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyCameraDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

