/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.ServiceSpecificException;
import android.system.OsConstants;
import android.util.AndroidException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LegacyExceptionUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LegacyExceptionUtils";
    public static int NO_ERROR = 0;
    public static int PERMISSION_DENIED;
    public static int ALREADY_EXISTS;
    public static int BAD_VALUE;
    public static int DEAD_OBJECT;
    public static int INVALID_OPERATION;
    public static int TIMED_OUT;

    private static final int $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$throwOnError(int errorFlag) throws BufferQueueAbandonedException {
        if (errorFlag == 0) {
            return 0;
        }
        if (errorFlag == BAD_VALUE) {
            throw new BufferQueueAbandonedException();
        }
        if (errorFlag < 0) {
            throw new UnsupportedOperationException("Unknown error " + errorFlag);
        }
        return errorFlag;
    }

    private static final void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$throwOnServiceError(int errorFlag) {
        String errorMsg;
        int errorCode = 10;
        if (errorFlag >= 0) {
            return;
        }
        if (errorFlag == PERMISSION_DENIED) {
            errorCode = 1;
            errorMsg = "Lacking privileges to access camera service";
        } else {
            if (errorFlag == ALREADY_EXISTS) {
                return;
            }
            if (errorFlag == BAD_VALUE) {
                errorCode = 3;
                errorMsg = "Bad argument passed to camera service";
            } else if (errorFlag == DEAD_OBJECT) {
                errorCode = 4;
                errorMsg = "Camera service not available";
            } else if (errorFlag == TIMED_OUT) {
                errorCode = 10;
                errorMsg = "Operation timed out in camera service";
            } else if (errorFlag == -OsConstants.EACCES) {
                errorCode = 6;
                errorMsg = "Camera disabled by policy";
            } else if (errorFlag == -OsConstants.EBUSY) {
                errorCode = 7;
                errorMsg = "Camera already in use";
            } else if (errorFlag == -OsConstants.EUSERS) {
                errorCode = 8;
                errorMsg = "Maximum number of cameras in use";
            } else if (errorFlag == -OsConstants.ENODEV) {
                errorCode = 4;
                errorMsg = "Camera device not available";
            } else if (errorFlag == -OsConstants.EOPNOTSUPP) {
                errorCode = 9;
                errorMsg = "Deprecated camera HAL does not support this";
            } else if (errorFlag == INVALID_OPERATION) {
                errorCode = 10;
                errorMsg = "Illegal state encountered in camera service.";
            } else {
                errorCode = 10;
                errorMsg = "Unknown camera device error " + errorFlag;
            }
        }
        throw new ServiceSpecificException(errorCode, errorMsg);
    }

    private void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$__constructor__() {
        throw new AssertionError();
    }

    static void __staticInitializer__() {
        PERMISSION_DENIED = -OsConstants.EPERM;
        ALREADY_EXISTS = -OsConstants.EEXIST;
        BAD_VALUE = -OsConstants.EINVAL;
        DEAD_OBJECT = -OsConstants.ENOSYS;
        INVALID_OPERATION = -OsConstants.EPIPE;
        TIMED_OUT = -OsConstants.ETIMEDOUT;
    }

    public static int throwOnError(int n) throws BufferQueueAbandonedException {
        return (int)InvokeDynamicSupport.bootstrapStatic("throwOnError", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$throwOnError(int ), 0, (int)n);
    }

    public static void throwOnServiceError(int n) {
        InvokeDynamicSupport.bootstrapStatic("throwOnServiceError", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$throwOnServiceError(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$__constructor__();
    }

    private LegacyExceptionUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(LegacyExceptionUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LegacyExceptionUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BufferQueueAbandonedException
    extends AndroidException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__() {
        }

        private void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(String name) {
        }

        private void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(String name, Throwable cause) {
        }

        private void $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(Exception cause) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__();
        }

        public BufferQueueAbandonedException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(string2);
        }

        public BufferQueueAbandonedException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(String string2, Throwable throwable) {
            this.$$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(string2, throwable);
        }

        public BufferQueueAbandonedException(String string2, Throwable throwable) {
            super(string2, throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
        }

        private void __constructor__(Exception exception) {
            this.$$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(exception);
        }

        public BufferQueueAbandonedException(Exception exception) {
            super(exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_legacy_LegacyExceptionUtils_BufferQueueAbandonedException$__constructor__(java.lang.Exception ), 0, this, exception);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferQueueAbandonedException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

