/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.SystemApi;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class OutputConfiguration
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @SystemApi
    public static int ROTATION_0 = 0;
    @SystemApi
    public static int ROTATION_90 = 1;
    @SystemApi
    public static int ROTATION_180 = 2;
    @SystemApi
    public static int ROTATION_270 = 3;
    public static int SURFACE_GROUP_ID_NONE = -1;
    private int SURFACE_TYPE_UNKNOWN = -1;
    private int SURFACE_TYPE_SURFACE_VIEW = 0;
    private int SURFACE_TYPE_SURFACE_TEXTURE = 1;
    private static int MAX_SURFACES_COUNT = 4;
    public static Parcelable.Creator<OutputConfiguration> CREATOR;
    private static String TAG = "OutputConfiguration";
    private ArrayList<Surface> mSurfaces;
    private int mRotation;
    private int mSurfaceGroupId;
    private int mSurfaceType;
    private Size mConfiguredSize;
    private int mConfiguredFormat;
    private int mConfiguredDataspace;
    private int mConfiguredGenerationId;
    private boolean mIsDeferredConfig;
    private boolean mIsShared;
    private String mPhysicalCameraId;

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Surface surface) {
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int surfaceGroupId, Surface surface) {
    }

    @SystemApi
    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Surface surface, int rotation) {
    }

    @SystemApi
    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int surfaceGroupId, Surface surface, int rotation) {
        this.SURFACE_TYPE_UNKNOWN = -1;
        this.SURFACE_TYPE_SURFACE_VIEW = 0;
        this.SURFACE_TYPE_SURFACE_TEXTURE = 1;
        Preconditions.checkNotNull(surface, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceGroupId;
        this.mSurfaceType = -1;
        this.mSurfaces = new ArrayList();
        this.mSurfaces.add(surface);
        this.mRotation = rotation;
        this.mConfiguredSize = SurfaceUtils.getSurfaceSize(surface);
        this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(surface);
        this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(surface);
        this.mConfiguredGenerationId = surface.getGenerationId();
        this.mIsDeferredConfig = false;
        this.mIsShared = false;
        this.mPhysicalCameraId = null;
    }

    private <T> void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Size surfaceSize, Class<T> klass) {
        this.SURFACE_TYPE_UNKNOWN = -1;
        this.SURFACE_TYPE_SURFACE_VIEW = 0;
        this.SURFACE_TYPE_SURFACE_TEXTURE = 1;
        Preconditions.checkNotNull(klass, "surfaceSize must not be null");
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == SurfaceHolder.class) {
            this.mSurfaceType = 0;
        } else if (klass == SurfaceTexture.class) {
            this.mSurfaceType = 1;
        } else {
            this.mSurfaceType = -1;
            throw new IllegalArgumentException("Unknow surface source class type");
        }
        if (surfaceSize.getWidth() == 0 || surfaceSize.getHeight() == 0) {
            throw new IllegalArgumentException("Surface size needs to be non-zero");
        }
        this.mSurfaceGroupId = -1;
        this.mSurfaces = new ArrayList();
        this.mRotation = 0;
        this.mConfiguredSize = surfaceSize;
        this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
        this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
        this.mConfiguredGenerationId = 0;
        this.mIsDeferredConfig = true;
        this.mIsShared = false;
        this.mPhysicalCameraId = null;
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$enableSurfaceSharing() {
        this.mIsShared = true;
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$setPhysicalCameraId(String physicalCameraId) {
        this.mPhysicalCameraId = physicalCameraId;
    }

    private final boolean $$robo$$android_hardware_camera2_params_OutputConfiguration$isForPhysicalCamera() {
        return this.mPhysicalCameraId != null;
    }

    private final boolean $$robo$$android_hardware_camera2_params_OutputConfiguration$isDeferredConfiguration() {
        return this.mIsDeferredConfig;
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$addSurface(Surface surface) {
        Preconditions.checkNotNull(surface, "Surface must not be null");
        if (this.mSurfaces.contains(surface)) {
            throw new IllegalStateException("Surface is already added!");
        }
        if (this.mSurfaces.size() == 1 && !this.mIsShared) {
            throw new IllegalStateException("Cannot have 2 surfaces for a non-sharing configuration");
        }
        if (this.mSurfaces.size() + 1 > 4) {
            throw new IllegalArgumentException("Exceeds maximum number of surfaces");
        }
        Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
        if (!surfaceSize.equals(this.mConfiguredSize)) {
            Log.w("OutputConfiguration", "Added surface size " + surfaceSize + " is different than pre-configured size " + this.mConfiguredSize + ", the pre-configured size will be used.");
        }
        if (this.mConfiguredFormat != SurfaceUtils.getSurfaceFormat(surface)) {
            throw new IllegalArgumentException("The format of added surface format doesn't match");
        }
        if (this.mConfiguredFormat != 34 && this.mConfiguredDataspace != SurfaceUtils.getSurfaceDataspace(surface)) {
            throw new IllegalArgumentException("The dataspace of added surface doesn't match");
        }
        this.mSurfaces.add(surface);
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$removeSurface(Surface surface) {
        if (this.getSurface() == surface) {
            throw new IllegalArgumentException("Cannot remove surface associated with this output configuration");
        }
        if (!this.mSurfaces.remove(surface)) {
            throw new IllegalArgumentException("Surface is not part of this output configuration");
        }
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(OutputConfiguration other) {
        this.SURFACE_TYPE_UNKNOWN = -1;
        this.SURFACE_TYPE_SURFACE_VIEW = 0;
        this.SURFACE_TYPE_SURFACE_TEXTURE = 1;
        if (other == null) {
            throw new IllegalArgumentException("OutputConfiguration shouldn't be null");
        }
        this.mSurfaces = other.mSurfaces;
        this.mRotation = other.mRotation;
        this.mSurfaceGroupId = other.mSurfaceGroupId;
        this.mSurfaceType = other.mSurfaceType;
        this.mConfiguredDataspace = other.mConfiguredDataspace;
        this.mConfiguredFormat = other.mConfiguredFormat;
        this.mConfiguredSize = other.mConfiguredSize;
        this.mConfiguredGenerationId = other.mConfiguredGenerationId;
        this.mIsDeferredConfig = other.mIsDeferredConfig;
        this.mIsShared = other.mIsShared;
        this.mPhysicalCameraId = other.mPhysicalCameraId;
    }

    private void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Parcel source) {
        this.SURFACE_TYPE_UNKNOWN = -1;
        this.SURFACE_TYPE_SURFACE_VIEW = 0;
        this.SURFACE_TYPE_SURFACE_TEXTURE = 1;
        int rotation = source.readInt();
        int surfaceSetId = source.readInt();
        int surfaceType = source.readInt();
        int width = source.readInt();
        int height = source.readInt();
        boolean isDeferred = source.readInt() == 1;
        boolean isShared = source.readInt() == 1;
        ArrayList surfaces = new ArrayList();
        source.readTypedList(surfaces, Surface.CREATOR);
        String physicalCameraId = source.readString();
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceSetId;
        this.mRotation = rotation;
        this.mSurfaces = surfaces;
        this.mConfiguredSize = new Size(width, height);
        this.mIsDeferredConfig = isDeferred;
        this.mIsShared = isShared;
        this.mSurfaces = surfaces;
        if (this.mSurfaces.size() > 0) {
            this.mSurfaceType = -1;
            this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(this.mSurfaces.get(0));
            this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(this.mSurfaces.get(0));
            this.mConfiguredGenerationId = this.mSurfaces.get(0).getGenerationId();
        } else {
            this.mSurfaceType = surfaceType;
            this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
            this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
            this.mConfiguredGenerationId = 0;
        }
        this.mPhysicalCameraId = physicalCameraId;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$getMaxSharedSurfaceCount() {
        return 4;
    }

    private final Surface $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurface() {
        if (this.mSurfaces.size() == 0) {
            return null;
        }
        return this.mSurfaces.get(0);
    }

    private final List<Surface> $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaces() {
        return Collections.unmodifiableList(this.mSurfaces);
    }

    @SystemApi
    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$getRotation() {
        return this.mRotation;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaceGroupId() {
        return this.mSurfaceGroupId;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_camera2_params_OutputConfiguration$writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mSurfaceGroupId);
        dest.writeInt(this.mSurfaceType);
        dest.writeInt(this.mConfiguredSize.getWidth());
        dest.writeInt(this.mConfiguredSize.getHeight());
        dest.writeInt(this.mIsDeferredConfig ? 1 : 0);
        dest.writeInt(this.mIsShared ? 1 : 0);
        dest.writeTypedList(this.mSurfaces);
        dest.writeString(this.mPhysicalCameraId);
    }

    private final boolean $$robo$$android_hardware_camera2_params_OutputConfiguration$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputConfiguration) {
            OutputConfiguration other = (OutputConfiguration)obj;
            if (this.mRotation != other.mRotation || !this.mConfiguredSize.equals(other.mConfiguredSize) || this.mConfiguredFormat != other.mConfiguredFormat || this.mSurfaceGroupId != other.mSurfaceGroupId || this.mSurfaceType != other.mSurfaceType || this.mIsDeferredConfig != other.mIsDeferredConfig || this.mIsShared != other.mIsShared || this.mConfiguredFormat != other.mConfiguredFormat || this.mConfiguredDataspace != other.mConfiguredDataspace || this.mConfiguredGenerationId != other.mConfiguredGenerationId) {
                return false;
            }
            int minLen = Math.min(this.mSurfaces.size(), other.mSurfaces.size());
            for (int i = 0; i < minLen; ++i) {
                if (this.mSurfaces.get(i) == other.mSurfaces.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_OutputConfiguration$hashCode() {
        if (this.mIsDeferredConfig) {
            return HashCodeHelpers.hashCode(this.mRotation, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId, this.mSurfaceType, this.mIsShared ? 1 : 0, this.mPhysicalCameraId == null ? 0 : this.mPhysicalCameraId.hashCode());
        }
        return HashCodeHelpers.hashCode(this.mRotation, this.mSurfaces.hashCode(), this.mConfiguredGenerationId, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId, this.mIsShared ? 1 : 0, this.mPhysicalCameraId == null ? 0 : this.mPhysicalCameraId.hashCode());
    }

    private /* synthetic */ void $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<OutputConfiguration>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__() {
            }

            private final OutputConfiguration $$robo$$android_hardware_camera2_params_OutputConfiguration_1$createFromParcel(Parcel source) {
                try {
                    OutputConfiguration outputConfiguration = new OutputConfiguration(source);
                    return outputConfiguration;
                }
                catch (Exception e) {
                    Log.e("OutputConfiguration", "Exception creating OutputConfiguration from parcel", e);
                    return null;
                }
            }

            private final OutputConfiguration[] $$robo$$android_hardware_camera2_params_OutputConfiguration_1$newArray(int size) {
                return new OutputConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$__constructor__(), 0, this);
            }

            @Override
            public OutputConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public OutputConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_camera2_params_OutputConfiguration_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Surface surface) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(surface);
    }

    public OutputConfiguration(Surface surface) {
        this(-1, surface, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.view.Surface ), 0, this, surface);
    }

    private void __constructor__(int n, Surface surface) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(n, surface);
    }

    public OutputConfiguration(int n, Surface surface) {
        this(n, surface, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int android.view.Surface ), 0, this, n, surface);
    }

    private void __constructor__(Surface surface, int n) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(surface, n);
    }

    public OutputConfiguration(Surface surface, int n) {
        this(-1, surface, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.view.Surface int ), 0, this, surface, n);
    }

    private void __constructor__(int n, Surface surface, int n2) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(n, surface, n2);
    }

    public OutputConfiguration(int n, Surface surface, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(int android.view.Surface int ), 0, this, n, surface, n2);
    }

    private <T> void __constructor__(Size size, Class<T> clazz) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(size, clazz);
    }

    public <T> OutputConfiguration(Size size, Class<T> clazz) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.util.Size java.lang.Class<T> ), 0, this, size, clazz);
    }

    public void enableSurfaceSharing() {
        InvokeDynamicSupport.bootstrap("enableSurfaceSharing", $$robo$$android_hardware_camera2_params_OutputConfiguration$enableSurfaceSharing(), 0, this);
    }

    public void setPhysicalCameraId(String string2) {
        InvokeDynamicSupport.bootstrap("setPhysicalCameraId", $$robo$$android_hardware_camera2_params_OutputConfiguration$setPhysicalCameraId(java.lang.String ), 0, this, string2);
    }

    public boolean isForPhysicalCamera() {
        return (boolean)InvokeDynamicSupport.bootstrap("isForPhysicalCamera", $$robo$$android_hardware_camera2_params_OutputConfiguration$isForPhysicalCamera(), 0, this);
    }

    public boolean isDeferredConfiguration() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeferredConfiguration", $$robo$$android_hardware_camera2_params_OutputConfiguration$isDeferredConfiguration(), 0, this);
    }

    public void addSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("addSurface", $$robo$$android_hardware_camera2_params_OutputConfiguration$addSurface(android.view.Surface ), 0, this, surface);
    }

    public void removeSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("removeSurface", $$robo$$android_hardware_camera2_params_OutputConfiguration$removeSurface(android.view.Surface ), 0, this, surface);
    }

    private void __constructor__(OutputConfiguration outputConfiguration) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(outputConfiguration);
    }

    public OutputConfiguration(OutputConfiguration outputConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.hardware.camera2.params.OutputConfiguration ), 0, this, outputConfiguration);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(parcel);
    }

    private OutputConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public int getMaxSharedSurfaceCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxSharedSurfaceCount", $$robo$$android_hardware_camera2_params_OutputConfiguration$getMaxSharedSurfaceCount(), 0, this);
    }

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurface(), 0, this);
    }

    public List<Surface> getSurfaces() {
        return InvokeDynamicSupport.bootstrap("getSurfaces", $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaces(), 0, this);
    }

    @SystemApi
    public int getRotation() {
        return (int)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_hardware_camera2_params_OutputConfiguration$getRotation(), 0, this);
    }

    public int getSurfaceGroupId() {
        return (int)InvokeDynamicSupport.bootstrap("getSurfaceGroupId", $$robo$$android_hardware_camera2_params_OutputConfiguration$getSurfaceGroupId(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_camera2_params_OutputConfiguration$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_camera2_params_OutputConfiguration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_OutputConfiguration$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_OutputConfiguration$hashCode(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_camera2_params_OutputConfiguration$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(OutputConfiguration.class);
    }

    public /* synthetic */ OutputConfiguration() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

