/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.time.LocalDate;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AmbientBrightnessDayStats
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private LocalDate mLocalDate;
    private float[] mBucketBoundaries;
    private float[] mStats;
    public static Parcelable.Creator<AmbientBrightnessDayStats> CREATOR;

    private void $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(LocalDate localDate, float[] bucketBoundaries) {
    }

    private void $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(LocalDate localDate, float[] bucketBoundaries, float[] stats) {
        Preconditions.checkNotNull(localDate);
        Preconditions.checkNotNull(bucketBoundaries);
        Preconditions.checkArrayElementsInRange(bucketBoundaries, 0.0f, Float.MAX_VALUE, "bucketBoundaries");
        if (bucketBoundaries.length < 1) {
            throw new IllegalArgumentException("Bucket boundaries must contain at least 1 value");
        }
        AmbientBrightnessDayStats.checkSorted(bucketBoundaries);
        if (stats == null) {
            stats = new float[bucketBoundaries.length];
        } else {
            Preconditions.checkArrayElementsInRange(stats, 0.0f, Float.MAX_VALUE, "stats");
            if (bucketBoundaries.length != stats.length) {
                throw new IllegalArgumentException("Bucket boundaries and stats must be of same size.");
            }
        }
        this.mLocalDate = localDate;
        this.mBucketBoundaries = bucketBoundaries;
        this.mStats = stats;
    }

    private final LocalDate $$robo$$android_hardware_display_AmbientBrightnessDayStats$getLocalDate() {
        return this.mLocalDate;
    }

    private final float[] $$robo$$android_hardware_display_AmbientBrightnessDayStats$getStats() {
        return this.mStats;
    }

    private final float[] $$robo$$android_hardware_display_AmbientBrightnessDayStats$getBucketBoundaries() {
        return this.mBucketBoundaries;
    }

    private void $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(Parcel source) {
        this.mLocalDate = LocalDate.parse(source.readString());
        this.mBucketBoundaries = source.createFloatArray();
        this.mStats = source.createFloatArray();
    }

    private final boolean $$robo$$android_hardware_display_AmbientBrightnessDayStats$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmbientBrightnessDayStats other = (AmbientBrightnessDayStats)obj;
        return this.mLocalDate.equals(other.mLocalDate) && Arrays.equals(this.mBucketBoundaries, other.mBucketBoundaries) && Arrays.equals(this.mStats, other.mStats);
    }

    private final int $$robo$$android_hardware_display_AmbientBrightnessDayStats$hashCode() {
        int prime = 31;
        int result = 1;
        result = result * 31 + this.mLocalDate.hashCode();
        result = result * 31 + Arrays.hashCode(this.mBucketBoundaries);
        result = result * 31 + Arrays.hashCode(this.mStats);
        return result;
    }

    private final String $$robo$$android_hardware_display_AmbientBrightnessDayStats$toString() {
        StringBuilder bucketBoundariesString = new StringBuilder();
        StringBuilder statsString = new StringBuilder();
        for (int i = 0; i < this.mBucketBoundaries.length; ++i) {
            if (i != 0) {
                bucketBoundariesString.append(", ");
                statsString.append(", ");
            }
            bucketBoundariesString.append(this.mBucketBoundaries[i]);
            statsString.append(this.mStats[i]);
        }
        return this.mLocalDate + " " + "{" + bucketBoundariesString + "} " + "{" + statsString + "}";
    }

    private final int $$robo$$android_hardware_display_AmbientBrightnessDayStats$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_display_AmbientBrightnessDayStats$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mLocalDate.toString());
        dest.writeFloatArray(this.mBucketBoundaries);
        dest.writeFloatArray(this.mStats);
    }

    private final void $$robo$$android_hardware_display_AmbientBrightnessDayStats$log(float ambientBrightness, float durationSec) {
        int bucketIndex = this.getBucketIndex(ambientBrightness);
        if (bucketIndex >= 0) {
            int n = bucketIndex;
            this.mStats[n] = this.mStats[n] + durationSec;
        }
    }

    private final int $$robo$$android_hardware_display_AmbientBrightnessDayStats$getBucketIndex(float ambientBrightness) {
        if (ambientBrightness < this.mBucketBoundaries[0]) {
            return -1;
        }
        int low = 0;
        int high = this.mBucketBoundaries.length - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            if (this.mBucketBoundaries[mid] <= ambientBrightness && ambientBrightness < this.mBucketBoundaries[mid + 1]) {
                return mid;
            }
            if (this.mBucketBoundaries[mid] < ambientBrightness) {
                low = mid + 1;
                continue;
            }
            if (!(this.mBucketBoundaries[mid] > ambientBrightness)) continue;
            high = mid - 1;
        }
        return low;
    }

    private static final void $$robo$$android_hardware_display_AmbientBrightnessDayStats$checkSorted(float[] values) {
        if (values.length <= 1) {
            return;
        }
        float prevValue = values[0];
        for (int i = 1; i < values.length; ++i) {
            Preconditions.checkState(prevValue < values[i]);
            prevValue = values[i];
        }
    }

    private /* synthetic */ void $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AmbientBrightnessDayStats>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$__constructor__() {
            }

            private final AmbientBrightnessDayStats $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$createFromParcel(Parcel source) {
                return new AmbientBrightnessDayStats(source);
            }

            private final AmbientBrightnessDayStats[] $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$newArray(int size) {
                return new AmbientBrightnessDayStats[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_display_AmbientBrightnessDayStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$__constructor__(), 0, this);
            }

            @Override
            public AmbientBrightnessDayStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AmbientBrightnessDayStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_display_AmbientBrightnessDayStats_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(LocalDate localDate, float[] fArray) {
        this.$$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(localDate, fArray);
    }

    public AmbientBrightnessDayStats(LocalDate localDate, float[] fArray) {
        this(localDate, fArray, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(java.time.LocalDate float[] ), 0, this, localDate, fArray);
    }

    private void __constructor__(LocalDate localDate, float[] fArray, float[] fArray2) {
        this.$$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(localDate, fArray, fArray2);
    }

    public AmbientBrightnessDayStats(LocalDate localDate, float[] fArray, float[] fArray2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(java.time.LocalDate float[] float[] ), 0, this, localDate, fArray, fArray2);
    }

    public LocalDate getLocalDate() {
        return InvokeDynamicSupport.bootstrap("getLocalDate", $$robo$$android_hardware_display_AmbientBrightnessDayStats$getLocalDate(), 0, this);
    }

    public float[] getStats() {
        return InvokeDynamicSupport.bootstrap("getStats", $$robo$$android_hardware_display_AmbientBrightnessDayStats$getStats(), 0, this);
    }

    public float[] getBucketBoundaries() {
        return InvokeDynamicSupport.bootstrap("getBucketBoundaries", $$robo$$android_hardware_display_AmbientBrightnessDayStats$getBucketBoundaries(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(parcel);
    }

    private AmbientBrightnessDayStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_display_AmbientBrightnessDayStats$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_display_AmbientBrightnessDayStats$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_display_AmbientBrightnessDayStats$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_display_AmbientBrightnessDayStats$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_display_AmbientBrightnessDayStats$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void log(float f, float f2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_hardware_display_AmbientBrightnessDayStats$log(float float ), 0, this, f, f2);
    }

    private int getBucketIndex(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getBucketIndex", $$robo$$android_hardware_display_AmbientBrightnessDayStats$getBucketIndex(float ), 0, this, f);
    }

    private static void checkSorted(float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("checkSorted", $$robo$$android_hardware_display_AmbientBrightnessDayStats$checkSorted(float[] ), 0, (float[])fArray);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_display_AmbientBrightnessDayStats$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AmbientBrightnessDayStats.class);
    }

    public /* synthetic */ AmbientBrightnessDayStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AmbientBrightnessDayStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

