/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.SystemApi;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.util.Pair;
import android.util.SparseArray;
import android.view.Display;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DisplayManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DisplayManager";
    private static boolean DEBUG = false;
    private Context mContext;
    private DisplayManagerGlobal mGlobal;
    private Object mLock;
    private SparseArray<Display> mDisplays;
    private ArrayList<Display> mTempDisplays;
    public static String ACTION_WIFI_DISPLAY_STATUS_CHANGED = "android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED";
    public static String EXTRA_WIFI_DISPLAY_STATUS = "android.hardware.display.extra.WIFI_DISPLAY_STATUS";
    public static String DISPLAY_CATEGORY_PRESENTATION = "android.hardware.display.category.PRESENTATION";
    public static int VIRTUAL_DISPLAY_FLAG_PUBLIC = 1;
    public static int VIRTUAL_DISPLAY_FLAG_PRESENTATION = 2;
    public static int VIRTUAL_DISPLAY_FLAG_SECURE = 4;
    public static int VIRTUAL_DISPLAY_FLAG_OWN_CONTENT_ONLY = 8;
    public static int VIRTUAL_DISPLAY_FLAG_AUTO_MIRROR = 16;
    public static int VIRTUAL_DISPLAY_FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    public static int VIRTUAL_DISPLAY_FLAG_SUPPORTS_TOUCH = 64;
    public static int VIRTUAL_DISPLAY_FLAG_ROTATES_WITH_CONTENT = 128;
    public static int VIRTUAL_DISPLAY_FLAG_DESTROY_CONTENT_ON_REMOVAL = 256;

    private void $$robo$$android_hardware_display_DisplayManager$__constructor__(Context context) {
        this.mLock = new Object();
        this.mDisplays = new SparseArray();
        this.mTempDisplays = new ArrayList();
        this.mContext = context;
        this.mGlobal = DisplayManagerGlobal.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Display $$robo$$android_hardware_display_DisplayManager$getDisplay(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getOrCreateDisplayLocked(displayId, false);
        }
    }

    private final Display[] $$robo$$android_hardware_display_DisplayManager$getDisplays() {
        return this.getDisplays(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Display[] $$robo$$android_hardware_display_DisplayManager$getDisplays(String category) {
        int[] displayIds = this.mGlobal.getDisplayIds();
        Object object = this.mLock;
        synchronized (object) {
            Display[] displayArray;
            try {
                if (category == null) {
                    this.addAllDisplaysLocked(this.mTempDisplays, displayIds);
                } else if (category.equals("android.hardware.display.category.PRESENTATION")) {
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 3);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 2);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 4);
                    this.addPresentationDisplaysLocked(this.mTempDisplays, displayIds, 5);
                }
                displayArray = this.mTempDisplays.toArray(new Display[this.mTempDisplays.size()]);
                this.mTempDisplays.clear();
            }
            catch (Throwable throwable) {
                this.mTempDisplays.clear();
                throw throwable;
            }
            return displayArray;
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManager$addAllDisplaysLocked(ArrayList<Display> displays, int[] displayIds) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(displayIds[i], true);
            if (display == null) continue;
            displays.add(display);
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManager$addPresentationDisplaysLocked(ArrayList<Display> displays, int[] displayIds, int matchType) {
        for (int i = 0; i < displayIds.length; ++i) {
            Display display = this.getOrCreateDisplayLocked(displayIds[i], true);
            if (display == null || (display.getFlags() & 8) == 0 || display.getType() != matchType) continue;
            displays.add(display);
        }
    }

    private final Display $$robo$$android_hardware_display_DisplayManager$getOrCreateDisplayLocked(int displayId, boolean assumeValid) {
        Display display = this.mDisplays.get(displayId);
        if (display == null) {
            Context context = this.mContext.getDisplay().getDisplayId() == displayId ? this.mContext : this.mContext.getApplicationContext();
            display = this.mGlobal.getCompatibleDisplay(displayId, context.getResources());
            if (display != null) {
                this.mDisplays.put(displayId, display);
            }
        } else if (!assumeValid && !display.isValid()) {
            display = null;
        }
        return display;
    }

    private final void $$robo$$android_hardware_display_DisplayManager$registerDisplayListener(DisplayListener listener, Handler handler) {
        this.mGlobal.registerDisplayListener(listener, handler);
    }

    private final void $$robo$$android_hardware_display_DisplayManager$unregisterDisplayListener(DisplayListener listener) {
        this.mGlobal.unregisterDisplayListener(listener);
    }

    private final void $$robo$$android_hardware_display_DisplayManager$startWifiDisplayScan() {
        this.mGlobal.startWifiDisplayScan();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$stopWifiDisplayScan() {
        this.mGlobal.stopWifiDisplayScan();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$connectWifiDisplay(String deviceAddress) {
        this.mGlobal.connectWifiDisplay(deviceAddress);
    }

    private final void $$robo$$android_hardware_display_DisplayManager$pauseWifiDisplay() {
        this.mGlobal.pauseWifiDisplay();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$resumeWifiDisplay() {
        this.mGlobal.resumeWifiDisplay();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$disconnectWifiDisplay() {
        this.mGlobal.disconnectWifiDisplay();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$renameWifiDisplay(String deviceAddress, String alias) {
        this.mGlobal.renameWifiDisplay(deviceAddress, alias);
    }

    private final void $$robo$$android_hardware_display_DisplayManager$forgetWifiDisplay(String deviceAddress) {
        this.mGlobal.forgetWifiDisplay(deviceAddress);
    }

    private final WifiDisplayStatus $$robo$$android_hardware_display_DisplayManager$getWifiDisplayStatus() {
        return this.mGlobal.getWifiDisplayStatus();
    }

    @SystemApi
    private final void $$robo$$android_hardware_display_DisplayManager$setSaturationLevel(float level) {
        this.mGlobal.setSaturationLevel(level);
    }

    private final VirtualDisplay $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags) {
        return this.createVirtualDisplay(name, width, height, densityDpi, surface, flags, null, null);
    }

    private final VirtualDisplay $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler) {
        return this.createVirtualDisplay(null, name, width, height, densityDpi, surface, flags, callback, handler, null);
    }

    private final VirtualDisplay $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(MediaProjection projection, String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler, String uniqueId) {
        return this.mGlobal.createVirtualDisplay(this.mContext, projection, name, width, height, densityDpi, surface, flags, callback, handler, uniqueId);
    }

    @SystemApi
    private final Point $$robo$$android_hardware_display_DisplayManager$getStableDisplaySize() {
        return this.mGlobal.getStableDisplaySize();
    }

    @SystemApi
    private final List<BrightnessChangeEvent> $$robo$$android_hardware_display_DisplayManager$getBrightnessEvents() {
        return this.mGlobal.getBrightnessEvents(this.mContext.getOpPackageName());
    }

    @SystemApi
    private final List<AmbientBrightnessDayStats> $$robo$$android_hardware_display_DisplayManager$getAmbientBrightnessStats() {
        return this.mGlobal.getAmbientBrightnessStats();
    }

    @SystemApi
    private final void $$robo$$android_hardware_display_DisplayManager$setBrightnessConfiguration(BrightnessConfiguration c) {
        this.setBrightnessConfigurationForUser(c, this.mContext.getUserId(), this.mContext.getPackageName());
    }

    private final void $$robo$$android_hardware_display_DisplayManager$setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) {
        this.mGlobal.setBrightnessConfigurationForUser(c, userId, packageName);
    }

    @SystemApi
    private final BrightnessConfiguration $$robo$$android_hardware_display_DisplayManager$getBrightnessConfiguration() {
        return this.getBrightnessConfigurationForUser(this.mContext.getUserId());
    }

    private final BrightnessConfiguration $$robo$$android_hardware_display_DisplayManager$getBrightnessConfigurationForUser(int userId) {
        return this.mGlobal.getBrightnessConfigurationForUser(userId);
    }

    @SystemApi
    private final BrightnessConfiguration $$robo$$android_hardware_display_DisplayManager$getDefaultBrightnessConfiguration() {
        return this.mGlobal.getDefaultBrightnessConfiguration();
    }

    private final void $$robo$$android_hardware_display_DisplayManager$setTemporaryBrightness(int brightness) {
        this.mGlobal.setTemporaryBrightness(brightness);
    }

    private final void $$robo$$android_hardware_display_DisplayManager$setTemporaryAutoBrightnessAdjustment(float adjustment) {
        this.mGlobal.setTemporaryAutoBrightnessAdjustment(adjustment);
    }

    @SystemApi
    private final Pair<float[], float[]> $$robo$$android_hardware_display_DisplayManager$getMinimumBrightnessCurve() {
        return this.mGlobal.getMinimumBrightnessCurve();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_display_DisplayManager$__constructor__(context);
    }

    public DisplayManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public Display getDisplay(int n) {
        return InvokeDynamicSupport.bootstrap("getDisplay", $$robo$$android_hardware_display_DisplayManager$getDisplay(int ), 0, this, n);
    }

    public Display[] getDisplays() {
        return InvokeDynamicSupport.bootstrap("getDisplays", $$robo$$android_hardware_display_DisplayManager$getDisplays(), 0, this);
    }

    public Display[] getDisplays(String string2) {
        return InvokeDynamicSupport.bootstrap("getDisplays", $$robo$$android_hardware_display_DisplayManager$getDisplays(java.lang.String ), 0, this, string2);
    }

    private void addAllDisplaysLocked(ArrayList<Display> arrayList, int[] nArray) {
        InvokeDynamicSupport.bootstrap("addAllDisplaysLocked", $$robo$$android_hardware_display_DisplayManager$addAllDisplaysLocked(java.util.ArrayList<android.view.Display> int[] ), 0, this, arrayList, nArray);
    }

    private void addPresentationDisplaysLocked(ArrayList<Display> arrayList, int[] nArray, int n) {
        InvokeDynamicSupport.bootstrap("addPresentationDisplaysLocked", $$robo$$android_hardware_display_DisplayManager$addPresentationDisplaysLocked(java.util.ArrayList<android.view.Display> int[] int ), 0, this, arrayList, nArray, n);
    }

    private Display getOrCreateDisplayLocked(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getOrCreateDisplayLocked", $$robo$$android_hardware_display_DisplayManager$getOrCreateDisplayLocked(int boolean ), 0, this, n, bl);
    }

    public void registerDisplayListener(DisplayListener displayListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerDisplayListener", $$robo$$android_hardware_display_DisplayManager$registerDisplayListener(android.hardware.display.DisplayManager$DisplayListener android.os.Handler ), 0, this, displayListener, handler);
    }

    public void unregisterDisplayListener(DisplayListener displayListener) {
        InvokeDynamicSupport.bootstrap("unregisterDisplayListener", $$robo$$android_hardware_display_DisplayManager$unregisterDisplayListener(android.hardware.display.DisplayManager$DisplayListener ), 0, this, displayListener);
    }

    public void startWifiDisplayScan() {
        InvokeDynamicSupport.bootstrap("startWifiDisplayScan", $$robo$$android_hardware_display_DisplayManager$startWifiDisplayScan(), 0, this);
    }

    public void stopWifiDisplayScan() {
        InvokeDynamicSupport.bootstrap("stopWifiDisplayScan", $$robo$$android_hardware_display_DisplayManager$stopWifiDisplayScan(), 0, this);
    }

    public void connectWifiDisplay(String string2) {
        InvokeDynamicSupport.bootstrap("connectWifiDisplay", $$robo$$android_hardware_display_DisplayManager$connectWifiDisplay(java.lang.String ), 0, this, string2);
    }

    public void pauseWifiDisplay() {
        InvokeDynamicSupport.bootstrap("pauseWifiDisplay", $$robo$$android_hardware_display_DisplayManager$pauseWifiDisplay(), 0, this);
    }

    public void resumeWifiDisplay() {
        InvokeDynamicSupport.bootstrap("resumeWifiDisplay", $$robo$$android_hardware_display_DisplayManager$resumeWifiDisplay(), 0, this);
    }

    public void disconnectWifiDisplay() {
        InvokeDynamicSupport.bootstrap("disconnectWifiDisplay", $$robo$$android_hardware_display_DisplayManager$disconnectWifiDisplay(), 0, this);
    }

    public void renameWifiDisplay(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("renameWifiDisplay", $$robo$$android_hardware_display_DisplayManager$renameWifiDisplay(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void forgetWifiDisplay(String string2) {
        InvokeDynamicSupport.bootstrap("forgetWifiDisplay", $$robo$$android_hardware_display_DisplayManager$forgetWifiDisplay(java.lang.String ), 0, this, string2);
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        return InvokeDynamicSupport.bootstrap("getWifiDisplayStatus", $$robo$$android_hardware_display_DisplayManager$getWifiDisplayStatus(), 0, this);
    }

    @SystemApi
    public void setSaturationLevel(float f) {
        InvokeDynamicSupport.bootstrap("setSaturationLevel", $$robo$$android_hardware_display_DisplayManager$setSaturationLevel(float ), 0, this, f);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, Surface surface, int n4) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(java.lang.String int int int android.view.Surface int ), 0, this, string2, n, n2, n3, surface, n4);
    }

    public VirtualDisplay createVirtualDisplay(String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(java.lang.String int int int android.view.Surface int android.hardware.display.VirtualDisplay$Callback android.os.Handler ), 0, this, string2, n, n2, n3, surface, n4, callback, handler);
    }

    public VirtualDisplay createVirtualDisplay(MediaProjection mediaProjection, String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler, String string3) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_hardware_display_DisplayManager$createVirtualDisplay(android.media.projection.MediaProjection java.lang.String int int int android.view.Surface int android.hardware.display.VirtualDisplay$Callback android.os.Handler java.lang.String ), 0, this, mediaProjection, string2, n, n2, n3, surface, n4, callback, handler, string3);
    }

    @SystemApi
    public Point getStableDisplaySize() {
        return InvokeDynamicSupport.bootstrap("getStableDisplaySize", $$robo$$android_hardware_display_DisplayManager$getStableDisplaySize(), 0, this);
    }

    @SystemApi
    public List<BrightnessChangeEvent> getBrightnessEvents() {
        return InvokeDynamicSupport.bootstrap("getBrightnessEvents", $$robo$$android_hardware_display_DisplayManager$getBrightnessEvents(), 0, this);
    }

    @SystemApi
    public List<AmbientBrightnessDayStats> getAmbientBrightnessStats() {
        return InvokeDynamicSupport.bootstrap("getAmbientBrightnessStats", $$robo$$android_hardware_display_DisplayManager$getAmbientBrightnessStats(), 0, this);
    }

    @SystemApi
    public void setBrightnessConfiguration(BrightnessConfiguration brightnessConfiguration) {
        InvokeDynamicSupport.bootstrap("setBrightnessConfiguration", $$robo$$android_hardware_display_DisplayManager$setBrightnessConfiguration(android.hardware.display.BrightnessConfiguration ), 0, this, brightnessConfiguration);
    }

    public void setBrightnessConfigurationForUser(BrightnessConfiguration brightnessConfiguration, int n, String string2) {
        InvokeDynamicSupport.bootstrap("setBrightnessConfigurationForUser", $$robo$$android_hardware_display_DisplayManager$setBrightnessConfigurationForUser(android.hardware.display.BrightnessConfiguration int java.lang.String ), 0, this, brightnessConfiguration, n, string2);
    }

    @SystemApi
    public BrightnessConfiguration getBrightnessConfiguration() {
        return InvokeDynamicSupport.bootstrap("getBrightnessConfiguration", $$robo$$android_hardware_display_DisplayManager$getBrightnessConfiguration(), 0, this);
    }

    public BrightnessConfiguration getBrightnessConfigurationForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getBrightnessConfigurationForUser", $$robo$$android_hardware_display_DisplayManager$getBrightnessConfigurationForUser(int ), 0, this, n);
    }

    @SystemApi
    public BrightnessConfiguration getDefaultBrightnessConfiguration() {
        return InvokeDynamicSupport.bootstrap("getDefaultBrightnessConfiguration", $$robo$$android_hardware_display_DisplayManager$getDefaultBrightnessConfiguration(), 0, this);
    }

    public void setTemporaryBrightness(int n) {
        InvokeDynamicSupport.bootstrap("setTemporaryBrightness", $$robo$$android_hardware_display_DisplayManager$setTemporaryBrightness(int ), 0, this, n);
    }

    public void setTemporaryAutoBrightnessAdjustment(float f) {
        InvokeDynamicSupport.bootstrap("setTemporaryAutoBrightnessAdjustment", $$robo$$android_hardware_display_DisplayManager$setTemporaryAutoBrightnessAdjustment(float ), 0, this, f);
    }

    @SystemApi
    public Pair<float[], float[]> getMinimumBrightnessCurve() {
        return InvokeDynamicSupport.bootstrap("getMinimumBrightnessCurve", $$robo$$android_hardware_display_DisplayManager$getMinimumBrightnessCurve(), 0, this);
    }

    public /* synthetic */ DisplayManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface DisplayListener
    extends InstrumentedInterface {
        public void onDisplayAdded(int var1);

        public void onDisplayRemoved(int var1);

        public void onDisplayChanged(int var1);
    }
}

