/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.IContextHubClient;
import android.hardware.location.NanoAppMessage;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class ContextHubClient
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private IContextHubClient mClientProxy;
    private ContextHubInfo mAttachedHub;
    private CloseGuard mCloseGuard;
    private AtomicBoolean mIsClosed;

    private void $$robo$$android_hardware_location_ContextHubClient$__constructor__(ContextHubInfo hubInfo) {
        this.mClientProxy = null;
        this.mCloseGuard = CloseGuard.get();
        this.mIsClosed = new AtomicBoolean(false);
        this.mAttachedHub = hubInfo;
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_hardware_location_ContextHubClient$setClientProxy(IContextHubClient clientProxy) {
        Preconditions.checkNotNull(clientProxy, "IContextHubClient cannot be null");
        if (this.mClientProxy != null) {
            throw new IllegalStateException("Cannot change client proxy multiple times");
        }
        this.mClientProxy = clientProxy;
    }

    private final ContextHubInfo $$robo$$android_hardware_location_ContextHubClient$getAttachedHub() {
        return this.mAttachedHub;
    }

    private final void $$robo$$android_hardware_location_ContextHubClient$close() {
        if (!this.mIsClosed.getAndSet(true)) {
            this.mCloseGuard.close();
            try {
                this.mClientProxy.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final int $$robo$$android_hardware_location_ContextHubClient$sendMessageToNanoApp(NanoAppMessage message) {
        Preconditions.checkNotNull(message, "NanoAppMessage cannot be null");
        try {
            return this.mClientProxy.sendMessageToNanoApp(message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_location_ContextHubClient$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void __constructor__(ContextHubInfo contextHubInfo) {
        this.$$robo$$android_hardware_location_ContextHubClient$__constructor__(contextHubInfo);
    }

    ContextHubClient(ContextHubInfo contextHubInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubClient$__constructor__(android.hardware.location.ContextHubInfo ), 0, this, contextHubInfo);
    }

    void setClientProxy(IContextHubClient iContextHubClient) {
        InvokeDynamicSupport.bootstrap("setClientProxy", $$robo$$android_hardware_location_ContextHubClient$setClientProxy(android.hardware.location.IContextHubClient ), 0, this, iContextHubClient);
    }

    public ContextHubInfo getAttachedHub() {
        return InvokeDynamicSupport.bootstrap("getAttachedHub", $$robo$$android_hardware_location_ContextHubClient$getAttachedHub(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_location_ContextHubClient$close(), 0, this);
    }

    public int sendMessageToNanoApp(NanoAppMessage nanoAppMessage) {
        return (int)InvokeDynamicSupport.bootstrap("sendMessageToNanoApp", $$robo$$android_hardware_location_ContextHubClient$sendMessageToNanoApp(android.hardware.location.NanoAppMessage ), 0, this, nanoAppMessage);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_location_ContextHubClient$finalize(), 0, this);
    }

    public /* synthetic */ ContextHubClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextHubClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

