/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ProgramList
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Object mLock;
    private Map<ProgramSelector.Identifier, RadioManager.ProgramInfo> mPrograms;
    private List<ListCallback> mListCallbacks;
    private List<OnCompleteListener> mOnCompleteListeners;
    private OnCloseListener mOnCloseListener;
    private boolean mIsClosed;
    private boolean mIsComplete;

    private void $$robo$$android_hardware_radio_ProgramList$__constructor__() {
        this.mLock = new Object();
        this.mPrograms = new HashMap<ProgramSelector.Identifier, RadioManager.ProgramInfo>();
        this.mListCallbacks = new ArrayList<ListCallback>();
        this.mOnCompleteListeners = new ArrayList<OnCompleteListener>();
        this.mIsClosed = false;
        this.mIsComplete = false;
    }

    private final void $$robo$$android_hardware_radio_ProgramList$registerListCallback(Executor executor, ListCallback callback) {
        this.registerListCallback((ListCallback)new ShadowedObject(this, executor, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Executor val$executor;
            /* synthetic */ ListCallback val$callback;
            /* synthetic */ ProgramList this$0;

            private void $$robo$$android_hardware_radio_ProgramList_1$__constructor__(ProgramList this$0, Executor executor, ListCallback listCallback) {
            }

            private final void $$robo$$android_hardware_radio_ProgramList_1$onItemChanged(ProgramSelector.Identifier id2) {
                this.val$executor.execute(() -> this.val$callback.onItemChanged(id2));
            }

            private final void $$robo$$android_hardware_radio_ProgramList_1$onItemRemoved(ProgramSelector.Identifier id2) {
                this.val$executor.execute(() -> this.val$callback.onItemRemoved(id2));
            }

            private void __constructor__(ProgramList programList, Executor executor, ListCallback listCallback) {
                this.$$robo$$android_hardware_radio_ProgramList_1$__constructor__(programList, executor, listCallback);
            }
            {
                this.this$0 = programList;
                this.val$executor = executor;
                this.val$callback = listCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_1$__constructor__(android.hardware.radio.ProgramList java.util.concurrent.Executor android.hardware.radio.ProgramList$ListCallback ), 0, this, programList, executor, listCallback);
            }

            @Override
            public void onItemChanged(ProgramSelector.Identifier identifier) {
                InvokeDynamicSupport.bootstrap("onItemChanged", $$robo$$android_hardware_radio_ProgramList_1$onItemChanged(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
            }

            @Override
            public void onItemRemoved(ProgramSelector.Identifier identifier) {
                InvokeDynamicSupport.bootstrap("onItemRemoved", $$robo$$android_hardware_radio_ProgramList_1$onItemRemoved(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$registerListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.add(Objects.requireNonNull(callback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$unregisterListCallback(ListCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mListCallbacks.remove(Objects.requireNonNull(callback));
        }
    }

    private final void $$robo$$android_hardware_radio_ProgramList$addOnCompleteListener(Executor executor, OnCompleteListener listener) {
        this.addOnCompleteListener(() -> executor.execute(listener::onComplete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$addOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.add(Objects.requireNonNull(listener));
            if (this.mIsComplete) {
                listener.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$removeOnCompleteListener(OnCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mOnCompleteListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$setOnCloseListener(OnCloseListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOnCloseListener != null) {
                throw new IllegalStateException("Close callback is already set");
            }
            this.mOnCloseListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mPrograms.clear();
            this.mListCallbacks.clear();
            this.mOnCompleteListeners.clear();
            if (this.mOnCloseListener != null) {
                this.mOnCloseListener.onClose();
                this.mOnCloseListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_ProgramList$apply(Chunk chunk) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsComplete = false;
            if (chunk.isPurge()) {
                new HashSet<ProgramSelector.Identifier>(this.mPrograms.keySet()).stream().forEach(id2 -> this.removeLocked((ProgramSelector.Identifier)id2));
            }
            chunk.getRemoved().stream().forEach(id2 -> this.removeLocked((ProgramSelector.Identifier)id2));
            chunk.getModified().stream().forEach(info -> this.putLocked((RadioManager.ProgramInfo)info));
            if (chunk.isComplete()) {
                this.mIsComplete = true;
                this.mOnCompleteListeners.forEach(cb -> cb.onComplete());
            }
        }
    }

    private final void $$robo$$android_hardware_radio_ProgramList$putLocked(RadioManager.ProgramInfo value) {
        ProgramSelector.Identifier key = value.getSelector().getPrimaryId();
        this.mPrograms.put(Objects.requireNonNull(key), value);
        ProgramSelector.Identifier sel = value.getSelector().getPrimaryId();
        this.mListCallbacks.forEach(cb -> cb.onItemChanged(sel));
    }

    private final void $$robo$$android_hardware_radio_ProgramList$removeLocked(ProgramSelector.Identifier key) {
        RadioManager.ProgramInfo removed = this.mPrograms.remove(Objects.requireNonNull(key));
        if (removed == null) {
            return;
        }
        ProgramSelector.Identifier sel = removed.getSelector().getPrimaryId();
        this.mListCallbacks.forEach(cb -> cb.onItemRemoved(sel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<RadioManager.ProgramInfo> $$robo$$android_hardware_radio_ProgramList$toList() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.values().stream().collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RadioManager.ProgramInfo $$robo$$android_hardware_radio_ProgramList$get(ProgramSelector.Identifier id2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrograms.get(Objects.requireNonNull(id2));
        }
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_radio_ProgramList$__constructor__();
    }

    ProgramList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList$__constructor__(), 0, this);
    }

    public void registerListCallback(Executor executor, ListCallback listCallback) {
        InvokeDynamicSupport.bootstrap("registerListCallback", $$robo$$android_hardware_radio_ProgramList$registerListCallback(java.util.concurrent.Executor android.hardware.radio.ProgramList$ListCallback ), 0, this, executor, listCallback);
    }

    public void registerListCallback(ListCallback listCallback) {
        InvokeDynamicSupport.bootstrap("registerListCallback", $$robo$$android_hardware_radio_ProgramList$registerListCallback(android.hardware.radio.ProgramList$ListCallback ), 0, this, listCallback);
    }

    public void unregisterListCallback(ListCallback listCallback) {
        InvokeDynamicSupport.bootstrap("unregisterListCallback", $$robo$$android_hardware_radio_ProgramList$unregisterListCallback(android.hardware.radio.ProgramList$ListCallback ), 0, this, listCallback);
    }

    public void addOnCompleteListener(Executor executor, OnCompleteListener onCompleteListener) {
        InvokeDynamicSupport.bootstrap("addOnCompleteListener", $$robo$$android_hardware_radio_ProgramList$addOnCompleteListener(java.util.concurrent.Executor android.hardware.radio.ProgramList$OnCompleteListener ), 0, this, executor, onCompleteListener);
    }

    public void addOnCompleteListener(OnCompleteListener onCompleteListener) {
        InvokeDynamicSupport.bootstrap("addOnCompleteListener", $$robo$$android_hardware_radio_ProgramList$addOnCompleteListener(android.hardware.radio.ProgramList$OnCompleteListener ), 0, this, onCompleteListener);
    }

    public void removeOnCompleteListener(OnCompleteListener onCompleteListener) {
        InvokeDynamicSupport.bootstrap("removeOnCompleteListener", $$robo$$android_hardware_radio_ProgramList$removeOnCompleteListener(android.hardware.radio.ProgramList$OnCompleteListener ), 0, this, onCompleteListener);
    }

    void setOnCloseListener(OnCloseListener onCloseListener) {
        InvokeDynamicSupport.bootstrap("setOnCloseListener", $$robo$$android_hardware_radio_ProgramList$setOnCloseListener(android.hardware.radio.ProgramList$OnCloseListener ), 0, this, onCloseListener);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_radio_ProgramList$close(), 0, this);
    }

    void apply(Chunk chunk) {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_hardware_radio_ProgramList$apply(android.hardware.radio.ProgramList$Chunk ), 0, this, chunk);
    }

    private void putLocked(RadioManager.ProgramInfo programInfo) {
        InvokeDynamicSupport.bootstrap("putLocked", $$robo$$android_hardware_radio_ProgramList$putLocked(android.hardware.radio.RadioManager$ProgramInfo ), 0, this, programInfo);
    }

    private void removeLocked(ProgramSelector.Identifier identifier) {
        InvokeDynamicSupport.bootstrap("removeLocked", $$robo$$android_hardware_radio_ProgramList$removeLocked(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
    }

    public List<RadioManager.ProgramInfo> toList() {
        return InvokeDynamicSupport.bootstrap("toList", $$robo$$android_hardware_radio_ProgramList$toList(), 0, this);
    }

    public RadioManager.ProgramInfo get(ProgramSelector.Identifier identifier) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_hardware_radio_ProgramList$get(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgramList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Chunk
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mPurge;
        private boolean mComplete;
        private Set<RadioManager.ProgramInfo> mModified;
        private Set<ProgramSelector.Identifier> mRemoved;
        public static Parcelable.Creator<Chunk> CREATOR;

        private void $$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(boolean purge, boolean complete, Set<RadioManager.ProgramInfo> modified, Set<ProgramSelector.Identifier> removed) {
            this.mPurge = purge;
            this.mComplete = complete;
            this.mModified = modified != null ? modified : Collections.emptySet();
            this.mRemoved = removed != null ? removed : Collections.emptySet();
        }

        private void $$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(Parcel in) {
            this.mPurge = in.readByte() != 0;
            this.mComplete = in.readByte() != 0;
            this.mModified = Utils.createSet(in, RadioManager.ProgramInfo.CREATOR);
            this.mRemoved = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
        }

        private final void $$robo$$android_hardware_radio_ProgramList_Chunk$writeToParcel(Parcel dest, int flags) {
            dest.writeByte((byte)(this.mPurge ? 1 : 0));
            dest.writeByte((byte)(this.mComplete ? 1 : 0));
            Utils.writeSet(dest, this.mModified);
            Utils.writeSet(dest, this.mRemoved);
        }

        private final int $$robo$$android_hardware_radio_ProgramList_Chunk$describeContents() {
            return 0;
        }

        private final boolean $$robo$$android_hardware_radio_ProgramList_Chunk$isPurge() {
            return this.mPurge;
        }

        private final boolean $$robo$$android_hardware_radio_ProgramList_Chunk$isComplete() {
            return this.mComplete;
        }

        private final Set<RadioManager.ProgramInfo> $$robo$$android_hardware_radio_ProgramList_Chunk$getModified() {
            return this.mModified;
        }

        private final Set<ProgramSelector.Identifier> $$robo$$android_hardware_radio_ProgramList_Chunk$getRemoved() {
            return this.mRemoved;
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Chunk>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_ProgramList_Chunk_1$__constructor__() {
                }

                private final Chunk $$robo$$android_hardware_radio_ProgramList_Chunk_1$createFromParcel(Parcel in) {
                    return new Chunk(in);
                }

                private final Chunk[] $$robo$$android_hardware_radio_ProgramList_Chunk_1$newArray(int size) {
                    return new Chunk[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_ProgramList_Chunk_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Chunk_1$__constructor__(), 0, this);
                }

                @Override
                public Chunk createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_ProgramList_Chunk_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Chunk[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_ProgramList_Chunk_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(boolean bl, boolean bl2, Set<RadioManager.ProgramInfo> set, Set<ProgramSelector.Identifier> set2) {
            this.$$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(bl, bl2, set, set2);
        }

        public Chunk(boolean bl, boolean bl2, Set<RadioManager.ProgramInfo> set, Set<ProgramSelector.Identifier> set2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(boolean boolean java.util.Set<android.hardware.radio.RadioManager$ProgramInfo> java.util.Set<android.hardware.radio.ProgramSelector$Identifier> ), 0, this, bl, bl2, set, set2);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(parcel);
        }

        private Chunk(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_ProgramList_Chunk$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_ProgramList_Chunk$describeContents(), 0, this);
        }

        public boolean isPurge() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPurge", $$robo$$android_hardware_radio_ProgramList_Chunk$isPurge(), 0, this);
        }

        public boolean isComplete() {
            return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$android_hardware_radio_ProgramList_Chunk$isComplete(), 0, this);
        }

        public Set<RadioManager.ProgramInfo> getModified() {
            return InvokeDynamicSupport.bootstrap("getModified", $$robo$$android_hardware_radio_ProgramList_Chunk$getModified(), 0, this);
        }

        public Set<ProgramSelector.Identifier> getRemoved() {
            return InvokeDynamicSupport.bootstrap("getRemoved", $$robo$$android_hardware_radio_ProgramList_Chunk$getRemoved(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_ProgramList_Chunk$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Chunk.class);
        }

        public /* synthetic */ Chunk() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Chunk)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Filter
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Set<Integer> mIdentifierTypes;
        private Set<ProgramSelector.Identifier> mIdentifiers;
        private boolean mIncludeCategories;
        private boolean mExcludeModifications;
        private Map<String, String> mVendorFilter;
        public static Parcelable.Creator<Filter> CREATOR;

        private void $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(Set<Integer> identifierTypes, Set<ProgramSelector.Identifier> identifiers, boolean includeCategories, boolean excludeModifications) {
            this.mIdentifierTypes = Objects.requireNonNull(identifierTypes);
            this.mIdentifiers = Objects.requireNonNull(identifiers);
            this.mIncludeCategories = includeCategories;
            this.mExcludeModifications = excludeModifications;
            this.mVendorFilter = null;
        }

        private void $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__() {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = null;
        }

        private void $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(Map<String, String> vendorFilter) {
            this.mIdentifierTypes = Collections.emptySet();
            this.mIdentifiers = Collections.emptySet();
            this.mIncludeCategories = false;
            this.mExcludeModifications = false;
            this.mVendorFilter = vendorFilter;
        }

        private void $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(Parcel in) {
            this.mIdentifierTypes = Utils.createIntSet(in);
            this.mIdentifiers = Utils.createSet(in, ProgramSelector.Identifier.CREATOR);
            this.mIncludeCategories = in.readByte() != 0;
            this.mExcludeModifications = in.readByte() != 0;
            this.mVendorFilter = Utils.readStringMap(in);
        }

        private final void $$robo$$android_hardware_radio_ProgramList_Filter$writeToParcel(Parcel dest, int flags) {
            Utils.writeIntSet(dest, this.mIdentifierTypes);
            Utils.writeSet(dest, this.mIdentifiers);
            dest.writeByte((byte)(this.mIncludeCategories ? 1 : 0));
            dest.writeByte((byte)(this.mExcludeModifications ? 1 : 0));
            Utils.writeStringMap(dest, this.mVendorFilter);
        }

        private final int $$robo$$android_hardware_radio_ProgramList_Filter$describeContents() {
            return 0;
        }

        private final Map<String, String> $$robo$$android_hardware_radio_ProgramList_Filter$getVendorFilter() {
            return this.mVendorFilter;
        }

        private final Set<Integer> $$robo$$android_hardware_radio_ProgramList_Filter$getIdentifierTypes() {
            return this.mIdentifierTypes;
        }

        private final Set<ProgramSelector.Identifier> $$robo$$android_hardware_radio_ProgramList_Filter$getIdentifiers() {
            return this.mIdentifiers;
        }

        private final boolean $$robo$$android_hardware_radio_ProgramList_Filter$areCategoriesIncluded() {
            return this.mIncludeCategories;
        }

        private final boolean $$robo$$android_hardware_radio_ProgramList_Filter$areModificationsExcluded() {
            return this.mExcludeModifications;
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Filter>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_ProgramList_Filter_1$__constructor__() {
                }

                private final Filter $$robo$$android_hardware_radio_ProgramList_Filter_1$createFromParcel(Parcel in) {
                    return new Filter(in);
                }

                private final Filter[] $$robo$$android_hardware_radio_ProgramList_Filter_1$newArray(int size) {
                    return new Filter[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_ProgramList_Filter_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Filter_1$__constructor__(), 0, this);
                }

                @Override
                public Filter createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_ProgramList_Filter_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Filter[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_ProgramList_Filter_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Set<Integer> set, Set<ProgramSelector.Identifier> set2, boolean bl, boolean bl2) {
            this.$$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(set, set2, bl, bl2);
        }

        public Filter(Set<Integer> set, Set<ProgramSelector.Identifier> set2, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(java.util.Set<java.lang.Integer> java.util.Set<android.hardware.radio.ProgramSelector$Identifier> boolean boolean ), 0, this, set, set2, bl, bl2);
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_radio_ProgramList_Filter$__constructor__();
        }

        public Filter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(), 0, this);
        }

        private void __constructor__(Map<String, String> map) {
            this.$$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(map);
        }

        public Filter(Map<String, String> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(java.util.Map<java.lang.String, java.lang.String> ), 0, this, map);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(parcel);
        }

        private Filter(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_ProgramList_Filter$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_ProgramList_Filter$describeContents(), 0, this);
        }

        public Map<String, String> getVendorFilter() {
            return InvokeDynamicSupport.bootstrap("getVendorFilter", $$robo$$android_hardware_radio_ProgramList_Filter$getVendorFilter(), 0, this);
        }

        public Set<Integer> getIdentifierTypes() {
            return InvokeDynamicSupport.bootstrap("getIdentifierTypes", $$robo$$android_hardware_radio_ProgramList_Filter$getIdentifierTypes(), 0, this);
        }

        public Set<ProgramSelector.Identifier> getIdentifiers() {
            return InvokeDynamicSupport.bootstrap("getIdentifiers", $$robo$$android_hardware_radio_ProgramList_Filter$getIdentifiers(), 0, this);
        }

        public boolean areCategoriesIncluded() {
            return (boolean)InvokeDynamicSupport.bootstrap("areCategoriesIncluded", $$robo$$android_hardware_radio_ProgramList_Filter$areCategoriesIncluded(), 0, this);
        }

        public boolean areModificationsExcluded() {
            return (boolean)InvokeDynamicSupport.bootstrap("areModificationsExcluded", $$robo$$android_hardware_radio_ProgramList_Filter$areModificationsExcluded(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_ProgramList_Filter$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Filter.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Filter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface OnCloseListener
    extends InstrumentedInterface {
        public void onClose();
    }

    public static interface OnCompleteListener
    extends InstrumentedInterface {
        public void onComplete();
    }

    public static abstract class ListCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_radio_ProgramList_ListCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_radio_ProgramList_ListCallback$onItemChanged(ProgramSelector.Identifier id2) {
        }

        private final void $$robo$$android_hardware_radio_ProgramList_ListCallback$onItemRemoved(ProgramSelector.Identifier id2) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_radio_ProgramList_ListCallback$__constructor__();
        }

        public ListCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramList_ListCallback$__constructor__(), 0, this);
        }

        public void onItemChanged(ProgramSelector.Identifier identifier) {
            InvokeDynamicSupport.bootstrap("onItemChanged", $$robo$$android_hardware_radio_ProgramList_ListCallback$onItemChanged(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
        }

        public void onItemRemoved(ProgramSelector.Identifier identifier) {
            InvokeDynamicSupport.bootstrap("onItemRemoved", $$robo$$android_hardware_radio_ProgramList_ListCallback$onItemRemoved(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

