/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ProgramSelector
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static int PROGRAM_TYPE_INVALID = 0;
    @Deprecated
    public static int PROGRAM_TYPE_AM = 1;
    @Deprecated
    public static int PROGRAM_TYPE_FM = 2;
    @Deprecated
    public static int PROGRAM_TYPE_AM_HD = 3;
    @Deprecated
    public static int PROGRAM_TYPE_FM_HD = 4;
    @Deprecated
    public static int PROGRAM_TYPE_DAB = 5;
    @Deprecated
    public static int PROGRAM_TYPE_DRMO = 6;
    @Deprecated
    public static int PROGRAM_TYPE_SXM = 7;
    @Deprecated
    public static int PROGRAM_TYPE_VENDOR_START = 1000;
    @Deprecated
    public static int PROGRAM_TYPE_VENDOR_END = 1999;
    public static int IDENTIFIER_TYPE_INVALID = 0;
    public static int IDENTIFIER_TYPE_AMFM_FREQUENCY = 1;
    public static int IDENTIFIER_TYPE_RDS_PI = 2;
    public static int IDENTIFIER_TYPE_HD_STATION_ID_EXT = 3;
    @Deprecated
    public static int IDENTIFIER_TYPE_HD_SUBCHANNEL = 4;
    public static int IDENTIFIER_TYPE_HD_STATION_NAME = 10004;
    public static int IDENTIFIER_TYPE_DAB_SIDECC = 5;
    public static int IDENTIFIER_TYPE_DAB_SID_EXT = 5;
    public static int IDENTIFIER_TYPE_DAB_ENSEMBLE = 6;
    public static int IDENTIFIER_TYPE_DAB_SCID = 7;
    public static int IDENTIFIER_TYPE_DAB_FREQUENCY = 8;
    public static int IDENTIFIER_TYPE_DRMO_SERVICE_ID = 9;
    public static int IDENTIFIER_TYPE_DRMO_FREQUENCY = 10;
    @Deprecated
    public static int IDENTIFIER_TYPE_DRMO_MODULATION = 11;
    public static int IDENTIFIER_TYPE_SXM_SERVICE_ID = 12;
    public static int IDENTIFIER_TYPE_SXM_CHANNEL = 13;
    public static int IDENTIFIER_TYPE_VENDOR_START = 1000;
    public static int IDENTIFIER_TYPE_VENDOR_END = 1999;
    @Deprecated
    public static int IDENTIFIER_TYPE_VENDOR_PRIMARY_START = 1000;
    @Deprecated
    public static int IDENTIFIER_TYPE_VENDOR_PRIMARY_END = 1999;
    private int mProgramType;
    private Identifier mPrimaryId;
    private Identifier[] mSecondaryIds;
    private long[] mVendorIds;
    public static Parcelable.Creator<ProgramSelector> CREATOR;

    private void $$robo$$android_hardware_radio_ProgramSelector$__constructor__(int programType, Identifier primaryId, Identifier[] secondaryIds, long[] vendorIds) {
        if (secondaryIds == null) {
            secondaryIds = new Identifier[]{};
        }
        if (vendorIds == null) {
            vendorIds = new long[]{};
        }
        if (Stream.of(secondaryIds).anyMatch(id2 -> id2 == null)) {
            throw new IllegalArgumentException("secondaryIds list must not contain nulls");
        }
        this.mProgramType = programType;
        this.mPrimaryId = Objects.requireNonNull(primaryId);
        this.mSecondaryIds = secondaryIds;
        this.mVendorIds = vendorIds;
    }

    @Deprecated
    private final int $$robo$$android_hardware_radio_ProgramSelector$getProgramType() {
        return this.mProgramType;
    }

    private final Identifier $$robo$$android_hardware_radio_ProgramSelector$getPrimaryId() {
        return this.mPrimaryId;
    }

    private final Identifier[] $$robo$$android_hardware_radio_ProgramSelector$getSecondaryIds() {
        return this.mSecondaryIds;
    }

    private final long $$robo$$android_hardware_radio_ProgramSelector$getFirstId(int type) {
        if (this.mPrimaryId.getType() == type) {
            return this.mPrimaryId.getValue();
        }
        for (Identifier id2 : this.mSecondaryIds) {
            if (id2.getType() != type) continue;
            return id2.getValue();
        }
        throw new IllegalArgumentException("Identifier " + type + " not found");
    }

    private final Identifier[] $$robo$$android_hardware_radio_ProgramSelector$getAllIds(int type) {
        ArrayList<Identifier> out = new ArrayList<Identifier>();
        if (this.mPrimaryId.getType() == type) {
            out.add(this.mPrimaryId);
        }
        for (Identifier id2 : this.mSecondaryIds) {
            if (id2.getType() != type) continue;
            out.add(id2);
        }
        return out.toArray(new Identifier[out.size()]);
    }

    @Deprecated
    private final long[] $$robo$$android_hardware_radio_ProgramSelector$getVendorIds() {
        return this.mVendorIds;
    }

    private final ProgramSelector $$robo$$android_hardware_radio_ProgramSelector$withSecondaryPreferred(Identifier preferred) {
        int preferredType = preferred.getType();
        Identifier[] secondaryIds = (Identifier[])Stream.concat(Arrays.stream(this.mSecondaryIds).filter(id2 -> id2.getType() != preferredType), Stream.of(preferred)).toArray(Identifier[]::new);
        return new ProgramSelector(this.mProgramType, this.mPrimaryId, secondaryIds, this.mVendorIds);
    }

    private static final ProgramSelector $$robo$$android_hardware_radio_ProgramSelector$createAmFmSelector(int band, int frequencyKhz) {
        return ProgramSelector.createAmFmSelector(band, frequencyKhz, 0);
    }

    private static final boolean $$robo$$android_hardware_radio_ProgramSelector$isValidAmFmFrequency(boolean isAm, int frequencyKhz) {
        if (isAm) {
            return frequencyKhz > 150 && frequencyKhz <= 30000;
        }
        return frequencyKhz > 60000 && frequencyKhz < 110000;
    }

    private static final ProgramSelector $$robo$$android_hardware_radio_ProgramSelector$createAmFmSelector(int band, int frequencyKhz, int subChannel) {
        boolean isDigital;
        if (band == -1) {
            band = frequencyKhz < 50000 ? (subChannel <= 0 ? 0 : 3) : (subChannel <= 0 ? 1 : 2);
        }
        boolean isAm = band == 0 || band == 3;
        boolean bl = isDigital = band == 3 || band == 2;
        if (!isAm && !isDigital && band != 1) {
            throw new IllegalArgumentException("Unknown band: " + band);
        }
        if (subChannel < 0 || subChannel > 8) {
            throw new IllegalArgumentException("Invalid subchannel: " + subChannel);
        }
        if (subChannel > 0 && !isDigital) {
            throw new IllegalArgumentException("Subchannels are not supported for non-HD radio");
        }
        if (!ProgramSelector.isValidAmFmFrequency(isAm, frequencyKhz)) {
            throw new IllegalArgumentException("Provided value is not a valid AM/FM frequency: " + frequencyKhz);
        }
        int programType = isAm ? 1 : 2;
        Identifier primary = new Identifier(1, frequencyKhz);
        Identifier[] secondary = null;
        if (subChannel > 0) {
            secondary = new Identifier[]{new Identifier(4, subChannel - 1)};
        }
        return new ProgramSelector(programType, primary, secondary, null);
    }

    private final String $$robo$$android_hardware_radio_ProgramSelector$toString() {
        StringBuilder sb = new StringBuilder("ProgramSelector(type=").append(this.mProgramType).append(", primary=").append(this.mPrimaryId);
        if (this.mSecondaryIds.length > 0) {
            sb.append(", secondary=").append(this.mSecondaryIds);
        }
        if (this.mVendorIds.length > 0) {
            sb.append(", vendor=").append(this.mVendorIds);
        }
        sb.append(")");
        return sb.toString();
    }

    private final int $$robo$$android_hardware_radio_ProgramSelector$hashCode() {
        return this.mPrimaryId.hashCode();
    }

    private final boolean $$robo$$android_hardware_radio_ProgramSelector$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProgramSelector)) {
            return false;
        }
        ProgramSelector other = (ProgramSelector)obj;
        return this.mPrimaryId.equals(other.getPrimaryId());
    }

    private void $$robo$$android_hardware_radio_ProgramSelector$__constructor__(Parcel in) {
        this.mProgramType = in.readInt();
        this.mPrimaryId = in.readTypedObject(Identifier.CREATOR);
        this.mSecondaryIds = in.createTypedArray(Identifier.CREATOR);
        if (Stream.of(this.mSecondaryIds).anyMatch(id2 -> id2 == null)) {
            throw new IllegalArgumentException("secondaryIds list must not contain nulls");
        }
        this.mVendorIds = in.createLongArray();
    }

    private final void $$robo$$android_hardware_radio_ProgramSelector$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProgramType);
        dest.writeTypedObject(this.mPrimaryId, 0);
        dest.writeTypedArray(this.mSecondaryIds, 0);
        dest.writeLongArray(this.mVendorIds);
    }

    private final int $$robo$$android_hardware_radio_ProgramSelector$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_hardware_radio_ProgramSelector$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ProgramSelector>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_radio_ProgramSelector_1$__constructor__() {
            }

            private final ProgramSelector $$robo$$android_hardware_radio_ProgramSelector_1$createFromParcel(Parcel in) {
                return new ProgramSelector(in);
            }

            private final ProgramSelector[] $$robo$$android_hardware_radio_ProgramSelector_1$newArray(int size) {
                return new ProgramSelector[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_radio_ProgramSelector_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector_1$__constructor__(), 0, this);
            }

            @Override
            public ProgramSelector createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_ProgramSelector_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ProgramSelector[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_ProgramSelector_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, Identifier identifier, Identifier[] identifierArray, long[] lArray) {
        this.$$robo$$android_hardware_radio_ProgramSelector$__constructor__(n, identifier, identifierArray, lArray);
    }

    public ProgramSelector(int n, Identifier identifier, Identifier[] identifierArray, long[] lArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector$__constructor__(int android.hardware.radio.ProgramSelector$Identifier android.hardware.radio.ProgramSelector$Identifier[] long[] ), 0, this, n, identifier, identifierArray, lArray);
    }

    @Deprecated
    public int getProgramType() {
        return (int)InvokeDynamicSupport.bootstrap("getProgramType", $$robo$$android_hardware_radio_ProgramSelector$getProgramType(), 0, this);
    }

    public Identifier getPrimaryId() {
        return InvokeDynamicSupport.bootstrap("getPrimaryId", $$robo$$android_hardware_radio_ProgramSelector$getPrimaryId(), 0, this);
    }

    public Identifier[] getSecondaryIds() {
        return InvokeDynamicSupport.bootstrap("getSecondaryIds", $$robo$$android_hardware_radio_ProgramSelector$getSecondaryIds(), 0, this);
    }

    public long getFirstId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getFirstId", $$robo$$android_hardware_radio_ProgramSelector$getFirstId(int ), 0, this, n);
    }

    public Identifier[] getAllIds(int n) {
        return InvokeDynamicSupport.bootstrap("getAllIds", $$robo$$android_hardware_radio_ProgramSelector$getAllIds(int ), 0, this, n);
    }

    @Deprecated
    public long[] getVendorIds() {
        return InvokeDynamicSupport.bootstrap("getVendorIds", $$robo$$android_hardware_radio_ProgramSelector$getVendorIds(), 0, this);
    }

    public ProgramSelector withSecondaryPreferred(Identifier identifier) {
        return InvokeDynamicSupport.bootstrap("withSecondaryPreferred", $$robo$$android_hardware_radio_ProgramSelector$withSecondaryPreferred(android.hardware.radio.ProgramSelector$Identifier ), 0, this, identifier);
    }

    public static ProgramSelector createAmFmSelector(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createAmFmSelector", $$robo$$android_hardware_radio_ProgramSelector$createAmFmSelector(int int ), 0, (int)n, (int)n2);
    }

    private static boolean isValidAmFmFrequency(boolean bl, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidAmFmFrequency", $$robo$$android_hardware_radio_ProgramSelector$isValidAmFmFrequency(boolean int ), 0, (boolean)bl, (int)n);
    }

    public static ProgramSelector createAmFmSelector(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("createAmFmSelector", $$robo$$android_hardware_radio_ProgramSelector$createAmFmSelector(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_ProgramSelector$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_ProgramSelector$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_ProgramSelector$equals(java.lang.Object ), 0, this, object);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_radio_ProgramSelector$__constructor__(parcel);
    }

    private ProgramSelector(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_ProgramSelector$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_ProgramSelector$describeContents(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_radio_ProgramSelector$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ProgramSelector.class);
    }

    public /* synthetic */ ProgramSelector() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgramSelector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Identifier
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mType;
        private long mValue;
        public static Parcelable.Creator<Identifier> CREATOR;

        private void $$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(int type, long value) {
            if (type == 10004) {
                type = 4;
            }
            this.mType = type;
            this.mValue = value;
        }

        private final int $$robo$$android_hardware_radio_ProgramSelector_Identifier$getType() {
            if (this.mType == 4 && this.mValue > 10L) {
                return 10004;
            }
            return this.mType;
        }

        private final long $$robo$$android_hardware_radio_ProgramSelector_Identifier$getValue() {
            return this.mValue;
        }

        private final String $$robo$$android_hardware_radio_ProgramSelector_Identifier$toString() {
            return "Identifier(" + this.mType + ", " + this.mValue + ")";
        }

        private final int $$robo$$android_hardware_radio_ProgramSelector_Identifier$hashCode() {
            return Objects.hash(this.mType, this.mValue);
        }

        private final boolean $$robo$$android_hardware_radio_ProgramSelector_Identifier$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)obj;
            return other.getType() == this.mType && other.getValue() == this.mValue;
        }

        private void $$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(Parcel in) {
            this.mType = in.readInt();
            this.mValue = in.readLong();
        }

        private final void $$robo$$android_hardware_radio_ProgramSelector_Identifier$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeLong(this.mValue);
        }

        private final int $$robo$$android_hardware_radio_ProgramSelector_Identifier$describeContents() {
            return 0;
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Identifier>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$__constructor__() {
                }

                private final Identifier $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$createFromParcel(Parcel in) {
                    return new Identifier(in);
                }

                private final Identifier[] $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$newArray(int size) {
                    return new Identifier[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_ProgramSelector_Identifier_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$__constructor__(), 0, this);
                }

                @Override
                public Identifier createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Identifier[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_ProgramSelector_Identifier_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, long l) {
            this.$$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(n, l);
        }

        public Identifier(int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(int long ), 0, this, n, l);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_hardware_radio_ProgramSelector_Identifier$getType(), 0, this);
        }

        public long getValue() {
            return (long)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_hardware_radio_ProgramSelector_Identifier$getValue(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_radio_ProgramSelector_Identifier$toString(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_radio_ProgramSelector_Identifier$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_radio_ProgramSelector_Identifier$equals(java.lang.Object ), 0, this, object);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(parcel);
        }

        private Identifier(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_ProgramSelector_Identifier$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_ProgramSelector_Identifier$describeContents(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_ProgramSelector_Identifier$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Identifier.class);
        }

        public /* synthetic */ Identifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Identifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IdentifierType {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgramType {
    }
}

