/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UsbPort
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mId;
    private int mSupportedModes;
    public static int MODE_NONE = 0;
    public static int MODE_DFP = 2;
    public static int MODE_UFP = 1;
    public static int MODE_DUAL = 3;
    public static int MODE_AUDIO_ACCESSORY = 4;
    public static int MODE_DEBUG_ACCESSORY = 8;
    public static int POWER_ROLE_NONE = 0;
    public static int POWER_ROLE_SOURCE = 1;
    public static int POWER_ROLE_SINK = 2;
    public static int DATA_ROLE_NONE = 0;
    public static int DATA_ROLE_HOST = 1;
    public static int DATA_ROLE_DEVICE = 2;
    private static int NUM_DATA_ROLES = 3;
    private static int POWER_ROLE_OFFSET = 0;
    public static Parcelable.Creator<UsbPort> CREATOR;

    private void $$robo$$android_hardware_usb_UsbPort$__constructor__(String id2, int supportedModes) {
        this.mId = id2;
        this.mSupportedModes = supportedModes;
    }

    private final String $$robo$$android_hardware_usb_UsbPort$getId() {
        return this.mId;
    }

    private final int $$robo$$android_hardware_usb_UsbPort$getSupportedModes() {
        return this.mSupportedModes;
    }

    private static final int $$robo$$android_hardware_usb_UsbPort$combineRolesAsBit(int powerRole, int dataRole) {
        UsbPort.checkRoles(powerRole, dataRole);
        int index = (powerRole - 0) * 3 + dataRole;
        return 1 << index;
    }

    private static final String $$robo$$android_hardware_usb_UsbPort$modeToString(int mode) {
        StringBuilder modeString = new StringBuilder();
        if (mode == 0) {
            return "none";
        }
        if ((mode & 3) == 3) {
            modeString.append("dual, ");
        } else if ((mode & 2) == 2) {
            modeString.append("dfp, ");
        } else if ((mode & 1) == 1) {
            modeString.append("ufp, ");
        }
        if ((mode & 4) == 4) {
            modeString.append("audio_acc, ");
        }
        if ((mode & 8) == 8) {
            modeString.append("debug_acc, ");
        }
        if (modeString.length() == 0) {
            return Integer.toString(mode);
        }
        return modeString.substring(0, modeString.length() - 2);
    }

    private static final String $$robo$$android_hardware_usb_UsbPort$powerRoleToString(int role) {
        switch (role) {
            case 0: {
                return "no-power";
            }
            case 1: {
                return "source";
            }
            case 2: {
                return "sink";
            }
        }
        return Integer.toString(role);
    }

    private static final String $$robo$$android_hardware_usb_UsbPort$dataRoleToString(int role) {
        switch (role) {
            case 0: {
                return "no-data";
            }
            case 1: {
                return "host";
            }
            case 2: {
                return "device";
            }
        }
        return Integer.toString(role);
    }

    private static final String $$robo$$android_hardware_usb_UsbPort$roleCombinationsToString(int combo) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        boolean first = true;
        while (combo != 0) {
            int index = Integer.numberOfTrailingZeros(combo);
            combo &= ~(1 << index);
            int powerRole = index / 3 + 0;
            int dataRole = index % 3;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(UsbPort.powerRoleToString(powerRole));
            result.append(':');
            result.append(UsbPort.dataRoleToString(dataRole));
        }
        result.append("]");
        return result.toString();
    }

    private static final void $$robo$$android_hardware_usb_UsbPort$checkMode(int powerRole) {
        Preconditions.checkArgumentInRange(powerRole, 0, 3, "portMode");
    }

    private static final void $$robo$$android_hardware_usb_UsbPort$checkPowerRole(int dataRole) {
        Preconditions.checkArgumentInRange(dataRole, 0, 2, "powerRole");
    }

    private static final void $$robo$$android_hardware_usb_UsbPort$checkDataRole(int mode) {
        Preconditions.checkArgumentInRange(mode, 0, 2, "powerRole");
    }

    private static final void $$robo$$android_hardware_usb_UsbPort$checkRoles(int powerRole, int dataRole) {
        Preconditions.checkArgumentInRange(powerRole, 0, 2, "powerRole");
        Preconditions.checkArgumentInRange(dataRole, 0, 2, "dataRole");
    }

    private final boolean $$robo$$android_hardware_usb_UsbPort$isModeSupported(int mode) {
        return (this.mSupportedModes & mode) == mode;
    }

    private final String $$robo$$android_hardware_usb_UsbPort$toString() {
        return "UsbPort{id=" + this.mId + ", supportedModes=" + UsbPort.modeToString(this.mSupportedModes) + "}";
    }

    private final int $$robo$$android_hardware_usb_UsbPort$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_usb_UsbPort$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mSupportedModes);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<UsbPort>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_usb_UsbPort_1$__constructor__() {
            }

            private final UsbPort $$robo$$android_hardware_usb_UsbPort_1$createFromParcel(Parcel in) {
                String id2 = in.readString();
                int supportedModes = in.readInt();
                return new UsbPort(id2, supportedModes);
            }

            private final UsbPort[] $$robo$$android_hardware_usb_UsbPort_1$newArray(int size) {
                return new UsbPort[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_usb_UsbPort_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbPort_1$__constructor__(), 0, this);
            }

            @Override
            public UsbPort createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_usb_UsbPort_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public UsbPort[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_usb_UsbPort_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_hardware_usb_UsbPort$__constructor__(string2, n);
    }

    public UsbPort(String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbPort$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_hardware_usb_UsbPort$getId(), 0, this);
    }

    public int getSupportedModes() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedModes", $$robo$$android_hardware_usb_UsbPort$getSupportedModes(), 0, this);
    }

    public static int combineRolesAsBit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("combineRolesAsBit", $$robo$$android_hardware_usb_UsbPort$combineRolesAsBit(int int ), 0, (int)n, (int)n2);
    }

    public static String modeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("modeToString", $$robo$$android_hardware_usb_UsbPort$modeToString(int ), 0, (int)n);
    }

    public static String powerRoleToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("powerRoleToString", $$robo$$android_hardware_usb_UsbPort$powerRoleToString(int ), 0, (int)n);
    }

    public static String dataRoleToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("dataRoleToString", $$robo$$android_hardware_usb_UsbPort$dataRoleToString(int ), 0, (int)n);
    }

    public static String roleCombinationsToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("roleCombinationsToString", $$robo$$android_hardware_usb_UsbPort$roleCombinationsToString(int ), 0, (int)n);
    }

    public static void checkMode(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkMode", $$robo$$android_hardware_usb_UsbPort$checkMode(int ), 0, (int)n);
    }

    public static void checkPowerRole(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkPowerRole", $$robo$$android_hardware_usb_UsbPort$checkPowerRole(int ), 0, (int)n);
    }

    public static void checkDataRole(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkDataRole", $$robo$$android_hardware_usb_UsbPort$checkDataRole(int ), 0, (int)n);
    }

    public static void checkRoles(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("checkRoles", $$robo$$android_hardware_usb_UsbPort$checkRoles(int int ), 0, (int)n, (int)n2);
    }

    public boolean isModeSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isModeSupported", $$robo$$android_hardware_usb_UsbPort$isModeSupported(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_usb_UsbPort$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_usb_UsbPort$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_usb_UsbPort$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(UsbPort.class);
    }

    public /* synthetic */ UsbPort() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbPort)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

