/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsbRequest
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "UsbRequest";
    static int MAX_USBFS_BUFFER_SIZE = 16384;
    private long mNativeContext;
    private UsbEndpoint mEndpoint;
    private ByteBuffer mBuffer;
    private int mLength;
    private Object mClientData;
    private UsbDeviceConnection mConnection;
    private boolean mIsUsingNewQueue;
    private ByteBuffer mTempBuffer;
    private CloseGuard mCloseGuard;
    private Object mLock;

    private void $$robo$$android_hardware_usb_UsbRequest$__constructor__() {
        this.mCloseGuard = CloseGuard.get();
        this.mLock = new Object();
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        this.mEndpoint = endpoint;
        this.mConnection = Preconditions.checkNotNull(connection, "connection");
        boolean wasInitialized = this.native_init(connection, endpoint.getAddress(), endpoint.getAttributes(), endpoint.getMaxPacketSize(), endpoint.getInterval());
        if (wasInitialized) {
            this.mCloseGuard.open("close");
        }
        return wasInitialized;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$close() {
        if (this.mNativeContext != 0L) {
            this.mEndpoint = null;
            this.mConnection = null;
            this.native_close();
            this.mCloseGuard.close();
        }
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final UsbEndpoint $$robo$$android_hardware_usb_UsbRequest$getEndpoint() {
        return this.mEndpoint;
    }

    private final Object $$robo$$android_hardware_usb_UsbRequest$getClientData() {
        return this.mClientData;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$setClientData(Object data) {
        this.mClientData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final boolean $$robo$$android_hardware_usb_UsbRequest$queue(ByteBuffer buffer, int length) {
        boolean result;
        boolean out;
        boolean bl = out = this.mEndpoint.getDirection() == 0;
        if (this.mConnection.getContext().getApplicationInfo().targetSdkVersion < 28 && length > 16384) {
            length = 16384;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            this.mLength = length;
            if (buffer.isDirect()) {
                result = this.native_queue_direct(buffer, length, out);
            } else if (buffer.hasArray()) {
                result = this.native_queue_array(buffer.array(), length, out);
            } else {
                throw new IllegalArgumentException("buffer is not direct and has no array");
            }
            if (!result) {
                this.mBuffer = null;
                this.mLength = 0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_usb_UsbRequest$queue(ByteBuffer buffer) {
        boolean wasQueued;
        Preconditions.checkState(this.mNativeContext != 0L, "request is not initialized");
        Preconditions.checkState(!this.mIsUsingNewQueue, "this request is currently queued");
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mBuffer = buffer;
            if (buffer == null) {
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(null, 0, 0);
            } else {
                if (this.mConnection.getContext().getApplicationInfo().targetSdkVersion < 28) {
                    Preconditions.checkArgumentInRange(buffer.remaining(), 0, 16384, "number of remaining bytes");
                }
                Preconditions.checkArgument(!buffer.isReadOnly() || isSend, "buffer can not be read-only when receiving data");
                if (!buffer.isDirect()) {
                    this.mTempBuffer = ByteBuffer.allocateDirect(this.mBuffer.remaining());
                    if (isSend) {
                        this.mBuffer.mark();
                        this.mTempBuffer.put(this.mBuffer);
                        this.mTempBuffer.flip();
                        this.mBuffer.reset();
                    }
                    buffer = this.mTempBuffer;
                }
                this.mIsUsingNewQueue = true;
                wasQueued = this.native_queue(buffer, buffer.position(), buffer.remaining());
            }
        }
        if (!wasQueued) {
            this.mIsUsingNewQueue = false;
            this.mTempBuffer = null;
            this.mBuffer = null;
        }
        return wasQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_usb_UsbRequest$dequeue(boolean useBufferOverflowInsteadOfIllegalArg) {
        boolean isSend = this.mEndpoint.getDirection() == 0;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsUsingNewQueue) {
                int bytesTransferred = this.native_dequeue_direct();
                this.mIsUsingNewQueue = false;
                if (this.mBuffer != null) {
                    if (this.mTempBuffer == null) {
                        this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                    } else {
                        this.mTempBuffer.limit(bytesTransferred);
                        try {
                            if (isSend) {
                                this.mBuffer.position(this.mBuffer.position() + bytesTransferred);
                            }
                            this.mBuffer.put(this.mTempBuffer);
                        }
                        finally {
                            this.mTempBuffer = null;
                        }
                    }
                }
            } else {
                int bytesTransferred = this.mBuffer.isDirect() ? this.native_dequeue_direct() : this.native_dequeue_array(this.mBuffer.array(), this.mLength, isSend);
                if (bytesTransferred >= 0) {
                    int bytesToStore = Math.min(bytesTransferred, this.mLength);
                    try {
                        this.mBuffer.position(bytesToStore);
                    }
                    catch (IllegalArgumentException e) {
                        if (useBufferOverflowInsteadOfIllegalArg) {
                            Log.e("UsbRequest", "Buffer " + this.mBuffer + " does not have enough space to read " + bytesToStore + " bytes", e);
                            throw new BufferOverflowException();
                        }
                        throw e;
                    }
                }
            }
            this.mBuffer = null;
            this.mLength = 0;
        }
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$cancel() {
        return this.native_cancel();
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return false;
    }

    private final void $$robo$$android_hardware_usb_UsbRequest$native_close() {
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_queue(ByteBuffer byteBuffer, int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_queue_array(byte[] byArray, int n, boolean bl) {
        return false;
    }

    private final int $$robo$$android_hardware_usb_UsbRequest$native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return 0;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return false;
    }

    private final int $$robo$$android_hardware_usb_UsbRequest$native_dequeue_direct() {
        return 0;
    }

    private final boolean $$robo$$android_hardware_usb_UsbRequest$native_cancel() {
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_usb_UsbRequest$__constructor__();
    }

    public UsbRequest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_usb_UsbRequest$__constructor__(), 0, this);
    }

    public boolean initialize(UsbDeviceConnection usbDeviceConnection, UsbEndpoint usbEndpoint) {
        return (boolean)InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_hardware_usb_UsbRequest$initialize(android.hardware.usb.UsbDeviceConnection android.hardware.usb.UsbEndpoint ), 0, this, usbDeviceConnection, usbEndpoint);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_usb_UsbRequest$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_usb_UsbRequest$finalize(), 0, this);
    }

    public UsbEndpoint getEndpoint() {
        return InvokeDynamicSupport.bootstrap("getEndpoint", $$robo$$android_hardware_usb_UsbRequest$getEndpoint(), 0, this);
    }

    public Object getClientData() {
        return InvokeDynamicSupport.bootstrap("getClientData", $$robo$$android_hardware_usb_UsbRequest$getClientData(), 0, this);
    }

    public void setClientData(Object object) {
        InvokeDynamicSupport.bootstrap("setClientData", $$robo$$android_hardware_usb_UsbRequest$setClientData(java.lang.Object ), 0, this, object);
    }

    @Deprecated
    public boolean queue(ByteBuffer byteBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("queue", $$robo$$android_hardware_usb_UsbRequest$queue(java.nio.ByteBuffer int ), 0, this, byteBuffer, n);
    }

    public boolean queue(ByteBuffer byteBuffer) {
        return (boolean)InvokeDynamicSupport.bootstrap("queue", $$robo$$android_hardware_usb_UsbRequest$queue(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    void dequeue(boolean bl) {
        InvokeDynamicSupport.bootstrap("dequeue", $$robo$$android_hardware_usb_UsbRequest$dequeue(boolean ), 0, this, bl);
    }

    public boolean cancel() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_usb_UsbRequest$cancel(), 0, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_init$nativeBinding(UsbDeviceConnection var1, int var2, int var3, int var4, int var5);

    private boolean native_init(UsbDeviceConnection usbDeviceConnection, int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_init", $$robo$$android_hardware_usb_UsbRequest$native_init(android.hardware.usb.UsbDeviceConnection int int int int ), 1, this, usbDeviceConnection, n, n2, n3, n4);
    }

    private final native /* synthetic */ void $$robo$$native_close$nativeBinding();

    private void native_close() {
        InvokeDynamicSupport.bootstrap("native_close", $$robo$$android_hardware_usb_UsbRequest$native_close(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_queue$nativeBinding(ByteBuffer var1, int var2, int var3);

    private boolean native_queue(ByteBuffer byteBuffer, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_queue", $$robo$$android_hardware_usb_UsbRequest$native_queue(java.nio.ByteBuffer int int ), 1, this, byteBuffer, n, n2);
    }

    private final native /* synthetic */ boolean $$robo$$native_queue_array$nativeBinding(byte[] var1, int var2, boolean var3);

    private boolean native_queue_array(byte[] byArray, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_queue_array", $$robo$$android_hardware_usb_UsbRequest$native_queue_array(byte[] int boolean ), 1, this, byArray, n, bl);
    }

    private final native /* synthetic */ int $$robo$$native_dequeue_array$nativeBinding(byte[] var1, int var2, boolean var3);

    private int native_dequeue_array(byte[] byArray, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeue_array", $$robo$$android_hardware_usb_UsbRequest$native_dequeue_array(byte[] int boolean ), 1, this, byArray, n, bl);
    }

    private final native /* synthetic */ boolean $$robo$$native_queue_direct$nativeBinding(ByteBuffer var1, int var2, boolean var3);

    private boolean native_queue_direct(ByteBuffer byteBuffer, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_queue_direct", $$robo$$android_hardware_usb_UsbRequest$native_queue_direct(java.nio.ByteBuffer int boolean ), 1, this, byteBuffer, n, bl);
    }

    private final native /* synthetic */ int $$robo$$native_dequeue_direct$nativeBinding();

    private int native_dequeue_direct() {
        return (int)InvokeDynamicSupport.bootstrap("native_dequeue_direct", $$robo$$android_hardware_usb_UsbRequest$native_dequeue_direct(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$native_cancel$nativeBinding();

    private boolean native_cancel() {
        return (boolean)InvokeDynamicSupport.bootstrap("native_cancel", $$robo$$android_hardware_usb_UsbRequest$native_cancel(), 1, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsbRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

