/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CalendarCache
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int[] primes;
    private int pIndex;
    private int size;
    private int arraySize;
    private int threshold;
    private long[] keys;
    private long[] values;
    public static long EMPTY;

    private void $$robo$$android_icu_impl_CalendarCache$__constructor__() {
        this.pIndex = 0;
        this.size = 0;
        this.arraySize = primes[this.pIndex];
        this.threshold = this.arraySize * 3 / 4;
        this.keys = new long[this.arraySize];
        this.values = new long[this.arraySize];
        this.makeArrays(this.arraySize);
    }

    private final void $$robo$$android_icu_impl_CalendarCache$makeArrays(int newSize) {
        this.keys = new long[newSize];
        this.values = new long[newSize];
        for (int i = 0; i < newSize; ++i) {
            this.values[i] = EMPTY;
        }
        this.arraySize = newSize;
        this.threshold = (int)((double)this.arraySize * 0.75);
        this.size = 0;
    }

    private final synchronized long $$robo$$android_icu_impl_CalendarCache$get(long key) {
        return this.values[this.findIndex(key)];
    }

    private final synchronized void $$robo$$android_icu_impl_CalendarCache$put(long key, long value) {
        if (this.size >= this.threshold) {
            this.rehash();
        }
        int index = this.findIndex(key);
        this.keys[index] = key;
        this.values[index] = value;
        ++this.size;
    }

    private final int $$robo$$android_icu_impl_CalendarCache$findIndex(long key) {
        int index = this.hash(key);
        int delta = 0;
        while (this.values[index] != EMPTY && this.keys[index] != key) {
            if (delta == 0) {
                delta = this.hash2(key);
            }
            index = (index + delta) % this.arraySize;
        }
        return index;
    }

    private final void $$robo$$android_icu_impl_CalendarCache$rehash() {
        int oldSize = this.arraySize;
        long[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.arraySize = this.pIndex < primes.length - 1 ? primes[++this.pIndex] : this.arraySize * 2 + 1;
        this.size = 0;
        this.makeArrays(this.arraySize);
        for (int i = 0; i < oldSize; ++i) {
            if (oldValues[i] == EMPTY) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private final int $$robo$$android_icu_impl_CalendarCache$hash(long key) {
        int h = (int)((key * 15821L + 1L) % (long)this.arraySize);
        if (h < 0) {
            h += this.arraySize;
        }
        return h;
    }

    private final int $$robo$$android_icu_impl_CalendarCache$hash2(long key) {
        return this.arraySize - 2 - (int)(key % (long)(this.arraySize - 2));
    }

    static void __staticInitializer__() {
        primes = new int[]{61, 127, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139};
        EMPTY = Long.MIN_VALUE;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_CalendarCache$__constructor__();
    }

    public CalendarCache() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarCache$__constructor__(), 0, this);
    }

    private void makeArrays(int n) {
        InvokeDynamicSupport.bootstrap("makeArrays", $$robo$$android_icu_impl_CalendarCache$makeArrays(int ), 0, this, n);
    }

    public synchronized long get(long l) {
        return (long)InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_CalendarCache$get(long ), 0, this, l);
    }

    public synchronized void put(long l, long l2) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_CalendarCache$put(long long ), 0, this, l, l2);
    }

    private int findIndex(long l) {
        return (int)InvokeDynamicSupport.bootstrap("findIndex", $$robo$$android_icu_impl_CalendarCache$findIndex(long ), 0, this, l);
    }

    private void rehash() {
        InvokeDynamicSupport.bootstrap("rehash", $$robo$$android_icu_impl_CalendarCache$rehash(), 0, this);
    }

    private int hash(long l) {
        return (int)InvokeDynamicSupport.bootstrap("hash", $$robo$$android_icu_impl_CalendarCache$hash(long ), 0, this, l);
    }

    private int hash2(long l) {
        return (int)InvokeDynamicSupport.bootstrap("hash2", $$robo$$android_icu_impl_CalendarCache$hash2(long ), 0, this, l);
    }

    static {
        RobolectricInternals.classInitializing(CalendarCache.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

