/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ClassLoaderUtil;
import android.icu.impl.ICUConfig;
import android.icu.impl.ICUData;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ICUBinary
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static List<DataFile> icuDataFiles;
    private static byte MAGIC1 = -38;
    private static byte MAGIC2 = 39;
    private static byte CHAR_SET_ = 0;
    private static byte CHAR_SIZE_ = 2;
    private static String MAGIC_NUMBER_AUTHENTICATION_FAILED_ = "ICU data file error: Not an ICU data file";
    private static String HEADER_AUTHENTICATION_FAILED_ = "ICU data file error: Header authentication failed, please check if you have a valid ICU data file";
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_ICUBinary$__constructor__() {
    }

    private static final void $$robo$$android_icu_impl_ICUBinary$addDataFilesFromPath(String dataPath, List<DataFile> files) {
        int pathStart = 0;
        while (pathStart < dataPath.length()) {
            int sepIndex = dataPath.indexOf(File.pathSeparatorChar, pathStart);
            int pathLimit = sepIndex >= 0 ? sepIndex : dataPath.length();
            String path = dataPath.substring(pathStart, pathLimit).trim();
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() != 0) {
                ICUBinary.addDataFilesFromFolder(new File(path), new StringBuilder(), icuDataFiles);
            }
            if (sepIndex < 0) break;
            pathStart = sepIndex + 1;
        }
    }

    private static final void $$robo$$android_icu_impl_ICUBinary$addDataFilesFromFolder(File folder, StringBuilder itemPath, List<DataFile> dataFiles) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        int folderPathLength = itemPath.length();
        if (folderPathLength > 0) {
            itemPath.append('/');
            ++folderPathLength;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(".txt")) continue;
            itemPath.append(fileName);
            if (file.isDirectory()) {
                ICUBinary.addDataFilesFromFolder(file, itemPath, dataFiles);
            } else if (fileName.endsWith(".dat")) {
                ByteBuffer pkgBytes = ICUBinary.mapFile(file);
                if (pkgBytes != null && DatPackageReader.validate(pkgBytes)) {
                    dataFiles.add(new PackageDataFile(itemPath.toString(), pkgBytes));
                }
            } else {
                dataFiles.add(new SingleDataFile(itemPath.toString(), file));
            }
            itemPath.setLength(folderPathLength);
        }
    }

    private static final int $$robo$$android_icu_impl_ICUBinary$compareKeys(CharSequence key, ByteBuffer bytes, int offset) {
        int i = 0;
        while (true) {
            byte c2;
            if ((c2 = bytes.get(offset)) == 0) {
                if (i == key.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == key.length()) {
                return -1;
            }
            int diff = key.charAt(i) - c2;
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++offset;
        }
    }

    private static final int $$robo$$android_icu_impl_ICUBinary$compareKeys(CharSequence key, byte[] bytes, int offset) {
        int i = 0;
        while (true) {
            byte c2;
            if ((c2 = bytes[offset]) == 0) {
                if (i == key.length()) {
                    return 0;
                }
                return 1;
            }
            if (i == key.length()) {
                return -1;
            }
            int diff = key.charAt(i) - c2;
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++offset;
        }
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getData(String itemPath) {
        return ICUBinary.getData(null, null, itemPath, false);
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getData(ClassLoader loader, String resourceName, String itemPath) {
        return ICUBinary.getData(loader, resourceName, itemPath, false);
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getRequiredData(String itemPath) {
        return ICUBinary.getData(null, null, itemPath, true);
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getData(ClassLoader loader, String resourceName, String itemPath, boolean required) {
        ByteBuffer bytes = ICUBinary.getDataFromFile(itemPath);
        if (bytes != null) {
            return bytes;
        }
        if (loader == null) {
            loader = ClassLoaderUtil.getClassLoader(ICUData.class);
        }
        if (resourceName == null) {
            resourceName = "android/icu/impl/data/icudt60b/" + itemPath;
        }
        ByteBuffer buffer = null;
        try {
            InputStream is = ICUData.getStream(loader, resourceName, required);
            if (is == null) {
                return null;
            }
            buffer = ICUBinary.getByteBufferFromInputStreamAndCloseStream(is);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
        return buffer;
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getDataFromFile(String itemPath) {
        for (DataFile dataFile : icuDataFiles) {
            ByteBuffer data = dataFile.getData(itemPath);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$mapFile(File path) {
        try {
            FileInputStream file = new FileInputStream(path);
            FileChannel channel = file.getChannel();
            MappedByteBuffer bytes = null;
            try {
                bytes = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            }
            finally {
                file.close();
            }
            return bytes;
        }
        catch (FileNotFoundException ignored) {
            System.err.println(ignored);
        }
        catch (IOException ignored) {
            System.err.println(ignored);
        }
        return null;
    }

    private static final void $$robo$$android_icu_impl_ICUBinary$addBaseNamesInFileFolder(String folder, String suffix, Set<String> names) {
        for (DataFile dataFile : icuDataFiles) {
            dataFile.addBaseNamesInFolder(folder, suffix, names);
        }
    }

    private static final VersionInfo $$robo$$android_icu_impl_ICUBinary$readHeaderAndDataVersion(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        return ICUBinary.getVersionInfoFromCompactInt(ICUBinary.readHeader(bytes, dataFormat, authenticate));
    }

    private static final int $$robo$$android_icu_impl_ICUBinary$readHeader(ByteBuffer bytes, int dataFormat, Authenticate authenticate) throws IOException {
        if (!($assertionsDisabled || bytes != null && bytes.position() == 0)) {
            throw new AssertionError();
        }
        byte magic1 = bytes.get(2);
        byte magic2 = bytes.get(3);
        if (magic1 != -38 || magic2 != 39) {
            throw new IOException("ICU data file error: Not an ICU data file");
        }
        byte isBigEndian = bytes.get(8);
        byte charsetFamily = bytes.get(9);
        byte sizeofUChar = bytes.get(10);
        if (isBigEndian < 0 || 1 < isBigEndian || charsetFamily != 0 || sizeofUChar != 2) {
            throw new IOException("ICU data file error: Header authentication failed, please check if you have a valid ICU data file");
        }
        bytes.order(isBigEndian != 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        char headerSize = bytes.getChar(0);
        char sizeofUDataInfo = bytes.getChar(4);
        if (sizeofUDataInfo < '\u0014' || headerSize < sizeofUDataInfo + 4) {
            throw new IOException("Internal Error: Header size error");
        }
        byte[] formatVersion = new byte[]{bytes.get(16), bytes.get(17), bytes.get(18), bytes.get(19)};
        if (bytes.get(12) != (byte)(dataFormat >> 24) || bytes.get(13) != (byte)(dataFormat >> 16) || bytes.get(14) != (byte)(dataFormat >> 8) || bytes.get(15) != (byte)dataFormat || authenticate != null && !authenticate.isDataVersionAcceptable(formatVersion)) {
            throw new IOException("ICU data file error: Header authentication failed, please check if you have a valid ICU data file" + String.format("; data format %02x%02x%02x%02x, format version %d.%d.%d.%d", bytes.get(12), bytes.get(13), bytes.get(14), bytes.get(15), formatVersion[0] & 0xFF, formatVersion[1] & 0xFF, formatVersion[2] & 0xFF, formatVersion[3] & 0xFF));
        }
        bytes.position(headerSize);
        return bytes.get(20) << 24 | (bytes.get(21) & 0xFF) << 16 | (bytes.get(22) & 0xFF) << 8 | bytes.get(23) & 0xFF;
    }

    private static final int $$robo$$android_icu_impl_ICUBinary$writeHeader(int dataFormat, int formatVersion, int dataVersion, DataOutputStream dos) throws IOException {
        dos.writeChar(32);
        dos.writeByte(-38);
        dos.writeByte(39);
        dos.writeChar(20);
        dos.writeChar(0);
        dos.writeByte(1);
        dos.writeByte(0);
        dos.writeByte(2);
        dos.writeByte(0);
        dos.writeInt(dataFormat);
        dos.writeInt(formatVersion);
        dos.writeInt(dataVersion);
        dos.writeLong(0L);
        if (!$assertionsDisabled && dos.size() != 32) {
            throw new AssertionError();
        }
        return 32;
    }

    private static final void $$robo$$android_icu_impl_ICUBinary$skipBytes(ByteBuffer bytes, int skipLength) {
        if (skipLength > 0) {
            bytes.position(bytes.position() + skipLength);
        }
    }

    private static final String $$robo$$android_icu_impl_ICUBinary$getString(ByteBuffer bytes, int length, int additionalSkipLength) {
        CharBuffer cs = bytes.asCharBuffer();
        String s = cs.subSequence(0, length).toString();
        ICUBinary.skipBytes(bytes, length * 2 + additionalSkipLength);
        return s;
    }

    private static final char[] $$robo$$android_icu_impl_ICUBinary$getChars(ByteBuffer bytes, int length, int additionalSkipLength) {
        char[] dest = new char[length];
        bytes.asCharBuffer().get(dest);
        ICUBinary.skipBytes(bytes, length * 2 + additionalSkipLength);
        return dest;
    }

    private static final short[] $$robo$$android_icu_impl_ICUBinary$getShorts(ByteBuffer bytes, int length, int additionalSkipLength) {
        short[] dest = new short[length];
        bytes.asShortBuffer().get(dest);
        ICUBinary.skipBytes(bytes, length * 2 + additionalSkipLength);
        return dest;
    }

    private static final int[] $$robo$$android_icu_impl_ICUBinary$getInts(ByteBuffer bytes, int length, int additionalSkipLength) {
        int[] dest = new int[length];
        bytes.asIntBuffer().get(dest);
        ICUBinary.skipBytes(bytes, length * 4 + additionalSkipLength);
        return dest;
    }

    private static final long[] $$robo$$android_icu_impl_ICUBinary$getLongs(ByteBuffer bytes, int length, int additionalSkipLength) {
        long[] dest = new long[length];
        bytes.asLongBuffer().get(dest);
        ICUBinary.skipBytes(bytes, length * 8 + additionalSkipLength);
        return dest;
    }

    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$sliceWithOrder(ByteBuffer bytes) {
        ByteBuffer b = bytes.slice();
        return b.order(bytes.order());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary$getByteBufferFromInputStreamAndCloseStream(InputStream is) throws IOException {
        try {
            int avail = is.available();
            byte[] bytes = avail > 32 ? new byte[avail] : new byte[128];
            int length = 0;
            while (true) {
                if (length < bytes.length) {
                    int numRead = is.read(bytes, length, bytes.length - length);
                    if (numRead < 0) break;
                    length += numRead;
                    continue;
                }
                int nextByte = is.read();
                if (nextByte < 0) break;
                int capacity = 2 * bytes.length;
                if (capacity < 128) {
                    capacity = 128;
                } else if (capacity < 16384) {
                    capacity *= 2;
                }
                byte[] newBytes = new byte[capacity];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])bytes, (int)0, (byte[])newBytes, (int)0, (int)length);
                bytes = newBytes;
                bytes[length++] = (byte)nextByte;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, length);
            return byteBuffer;
        }
        finally {
            is.close();
        }
    }

    private static final VersionInfo $$robo$$android_icu_impl_ICUBinary$getVersionInfoFromCompactInt(int version) {
        return VersionInfo.getInstance(version >>> 24, version >> 16 & 0xFF, version >> 8 & 0xFF, version & 0xFF);
    }

    private static final byte[] $$robo$$android_icu_impl_ICUBinary$getVersionByteArrayFromCompactInt(int version) {
        return new byte[]{(byte)(version >> 24), (byte)(version >> 16), (byte)(version >> 8), (byte)version};
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !ICUBinary.class.desiredAssertionStatus();
        icuDataFiles = new ArrayList<DataFile>();
        String dataPath = ICUConfig.get(ICUBinary.class.getName() + ".dataPath");
        if (dataPath != null) {
            ICUBinary.addDataFilesFromPath(dataPath, icuDataFiles);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICUBinary$__constructor__();
    }

    public ICUBinary() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary$__constructor__(), 0, this);
    }

    private static void addDataFilesFromPath(String string2, List<DataFile> list) {
        InvokeDynamicSupport.bootstrapStatic("addDataFilesFromPath", $$robo$$android_icu_impl_ICUBinary$addDataFilesFromPath(java.lang.String java.util.List<android.icu.impl.ICUBinary$DataFile> ), 0, (String)string2, list);
    }

    private static void addDataFilesFromFolder(File file, StringBuilder stringBuilder, List<DataFile> list) {
        InvokeDynamicSupport.bootstrapStatic("addDataFilesFromFolder", $$robo$$android_icu_impl_ICUBinary$addDataFilesFromFolder(java.io.File java.lang.StringBuilder java.util.List<android.icu.impl.ICUBinary$DataFile> ), 0, (File)file, (StringBuilder)stringBuilder, list);
    }

    static int compareKeys(CharSequence charSequence, ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareKeys", $$robo$$android_icu_impl_ICUBinary$compareKeys(java.lang.CharSequence java.nio.ByteBuffer int ), 0, (CharSequence)charSequence, (ByteBuffer)byteBuffer, (int)n);
    }

    static int compareKeys(CharSequence charSequence, byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareKeys", $$robo$$android_icu_impl_ICUBinary$compareKeys(java.lang.CharSequence byte[] int ), 0, (CharSequence)charSequence, (byte[])byArray, (int)n);
    }

    public static ByteBuffer getData(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getData", $$robo$$android_icu_impl_ICUBinary$getData(java.lang.String ), 0, (String)string2);
    }

    public static ByteBuffer getData(ClassLoader classLoader, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getData", $$robo$$android_icu_impl_ICUBinary$getData(java.lang.ClassLoader java.lang.String java.lang.String ), 0, (ClassLoader)classLoader, (String)string2, (String)string3);
    }

    public static ByteBuffer getRequiredData(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getRequiredData", $$robo$$android_icu_impl_ICUBinary$getRequiredData(java.lang.String ), 0, (String)string2);
    }

    private static ByteBuffer getData(ClassLoader classLoader, String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getData", $$robo$$android_icu_impl_ICUBinary$getData(java.lang.ClassLoader java.lang.String java.lang.String boolean ), 0, (ClassLoader)classLoader, (String)string2, (String)string3, (boolean)bl);
    }

    private static ByteBuffer getDataFromFile(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDataFromFile", $$robo$$android_icu_impl_ICUBinary$getDataFromFile(java.lang.String ), 0, (String)string2);
    }

    private static ByteBuffer mapFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("mapFile", $$robo$$android_icu_impl_ICUBinary$mapFile(java.io.File ), 0, (File)file);
    }

    public static void addBaseNamesInFileFolder(String string2, String string3, Set<String> set) {
        InvokeDynamicSupport.bootstrapStatic("addBaseNamesInFileFolder", $$robo$$android_icu_impl_ICUBinary$addBaseNamesInFileFolder(java.lang.String java.lang.String java.util.Set<java.lang.String> ), 0, (String)string2, (String)string3, set);
    }

    public static VersionInfo readHeaderAndDataVersion(ByteBuffer byteBuffer, int n, Authenticate authenticate) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readHeaderAndDataVersion", $$robo$$android_icu_impl_ICUBinary$readHeaderAndDataVersion(java.nio.ByteBuffer int android.icu.impl.ICUBinary$Authenticate ), 0, (ByteBuffer)byteBuffer, (int)n, (Authenticate)authenticate);
    }

    public static int readHeader(ByteBuffer byteBuffer, int n, Authenticate authenticate) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("readHeader", $$robo$$android_icu_impl_ICUBinary$readHeader(java.nio.ByteBuffer int android.icu.impl.ICUBinary$Authenticate ), 0, (ByteBuffer)byteBuffer, (int)n, (Authenticate)authenticate);
    }

    public static int writeHeader(int n, int n2, int n3, DataOutputStream dataOutputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeHeader", $$robo$$android_icu_impl_ICUBinary$writeHeader(int int int java.io.DataOutputStream ), 0, (int)n, (int)n2, (int)n3, (DataOutputStream)dataOutputStream);
    }

    public static void skipBytes(ByteBuffer byteBuffer, int n) {
        InvokeDynamicSupport.bootstrapStatic("skipBytes", $$robo$$android_icu_impl_ICUBinary$skipBytes(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static String getString(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getString", $$robo$$android_icu_impl_ICUBinary$getString(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static char[] getChars(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getChars", $$robo$$android_icu_impl_ICUBinary$getChars(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static short[] getShorts(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getShorts", $$robo$$android_icu_impl_ICUBinary$getShorts(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static int[] getInts(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getInts", $$robo$$android_icu_impl_ICUBinary$getInts(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static long[] getLongs(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getLongs", $$robo$$android_icu_impl_ICUBinary$getLongs(java.nio.ByteBuffer int int ), 0, (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    public static ByteBuffer sliceWithOrder(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("sliceWithOrder", $$robo$$android_icu_impl_ICUBinary$sliceWithOrder(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    public static ByteBuffer getByteBufferFromInputStreamAndCloseStream(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getByteBufferFromInputStreamAndCloseStream", $$robo$$android_icu_impl_ICUBinary$getByteBufferFromInputStreamAndCloseStream(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static VersionInfo getVersionInfoFromCompactInt(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getVersionInfoFromCompactInt", $$robo$$android_icu_impl_ICUBinary$getVersionInfoFromCompactInt(int ), 0, (int)n);
    }

    public static byte[] getVersionByteArrayFromCompactInt(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getVersionByteArrayFromCompactInt", $$robo$$android_icu_impl_ICUBinary$getVersionByteArrayFromCompactInt(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ICUBinary.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUBinary)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Authenticate
    extends InstrumentedInterface {
        public boolean isDataVersionAcceptable(byte[] var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class PackageDataFile
    extends DataFile
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ByteBuffer pkgBytes;

        private void $$robo$$android_icu_impl_ICUBinary_PackageDataFile$__constructor__(String item, ByteBuffer bytes) {
            this.pkgBytes = bytes;
        }

        private final ByteBuffer $$robo$$android_icu_impl_ICUBinary_PackageDataFile$getData(String requestedPath) {
            return DatPackageReader.getData(this.pkgBytes, requestedPath);
        }

        private final void $$robo$$android_icu_impl_ICUBinary_PackageDataFile$addBaseNamesInFolder(String folder, String suffix, Set<String> names) {
            DatPackageReader.addBaseNamesInFolder(this.pkgBytes, folder, suffix, names);
        }

        private void __constructor__(String string2, ByteBuffer byteBuffer) {
            this.$$robo$$android_icu_impl_ICUBinary_PackageDataFile$__constructor__(string2, byteBuffer);
        }

        PackageDataFile(String string2, ByteBuffer byteBuffer) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary_PackageDataFile$__constructor__(java.lang.String java.nio.ByteBuffer ), 0, this, string2, byteBuffer);
        }

        @Override
        ByteBuffer getData(String string2) {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_icu_impl_ICUBinary_PackageDataFile$getData(java.lang.String ), 0, this, string2);
        }

        @Override
        void addBaseNamesInFolder(String string2, String string3, Set<String> set) {
            InvokeDynamicSupport.bootstrap("addBaseNamesInFolder", $$robo$$android_icu_impl_ICUBinary_PackageDataFile$addBaseNamesInFolder(java.lang.String java.lang.String java.util.Set<java.lang.String> ), 0, this, string2, string3, set);
        }

        public /* synthetic */ PackageDataFile() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageDataFile)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SingleDataFile
    extends DataFile
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File path;

        private void $$robo$$android_icu_impl_ICUBinary_SingleDataFile$__constructor__(String item, File path) {
            this.path = path;
        }

        private final String $$robo$$android_icu_impl_ICUBinary_SingleDataFile$toString() {
            return this.path.toString();
        }

        private final ByteBuffer $$robo$$android_icu_impl_ICUBinary_SingleDataFile$getData(String requestedPath) {
            if (requestedPath.equals(this.itemPath)) {
                return ICUBinary.mapFile(this.path);
            }
            return null;
        }

        private final void $$robo$$android_icu_impl_ICUBinary_SingleDataFile$addBaseNamesInFolder(String folder, String suffix, Set<String> names) {
            if (this.itemPath.length() > folder.length() + suffix.length() && this.itemPath.startsWith(folder) && this.itemPath.endsWith(suffix) && this.itemPath.charAt(folder.length()) == '/' && this.itemPath.indexOf(47, folder.length() + 1) < 0) {
                names.add(this.itemPath.substring(folder.length() + 1, this.itemPath.length() - suffix.length()));
            }
        }

        private void __constructor__(String string2, File file) {
            this.$$robo$$android_icu_impl_ICUBinary_SingleDataFile$__constructor__(string2, file);
        }

        SingleDataFile(String string2, File file) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary_SingleDataFile$__constructor__(java.lang.String java.io.File ), 0, this, string2, file);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICUBinary_SingleDataFile$toString(), 0, this);
        }

        @Override
        ByteBuffer getData(String string2) {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_icu_impl_ICUBinary_SingleDataFile$getData(java.lang.String ), 0, this, string2);
        }

        @Override
        void addBaseNamesInFolder(String string2, String string3, Set<String> set) {
            InvokeDynamicSupport.bootstrap("addBaseNamesInFolder", $$robo$$android_icu_impl_ICUBinary_SingleDataFile$addBaseNamesInFolder(java.lang.String java.lang.String java.util.Set<java.lang.String> ), 0, this, string2, string3, set);
        }

        public /* synthetic */ SingleDataFile() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SingleDataFile)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class DataFile
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected String itemPath;

        private void $$robo$$android_icu_impl_ICUBinary_DataFile$__constructor__(String item) {
            this.itemPath = item;
        }

        private final String $$robo$$android_icu_impl_ICUBinary_DataFile$toString() {
            return this.itemPath;
        }

        abstract ByteBuffer getData(String var1);

        abstract void addBaseNamesInFolder(String var1, String var2, Set<String> var3);

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_ICUBinary_DataFile$__constructor__(string2);
        }

        DataFile(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary_DataFile$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICUBinary_DataFile$toString(), 0, this);
        }

        public /* synthetic */ DataFile() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataFile)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DatPackageReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DATA_FORMAT = 1131245124;
        private static IsAcceptable IS_ACCEPTABLE;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_ICUBinary_DatPackageReader$__constructor__() {
        }

        private static final boolean $$robo$$android_icu_impl_ICUBinary_DatPackageReader$validate(ByteBuffer bytes) {
            try {
                ICUBinary.readHeader(bytes, 1131245124, IS_ACCEPTABLE);
            }
            catch (IOException ignored) {
                return false;
            }
            int count = bytes.getInt(bytes.position());
            if (count <= 0) {
                return false;
            }
            if (bytes.position() + 4 + count * 24 > bytes.capacity()) {
                return false;
            }
            return DatPackageReader.startsWithPackageName(bytes, DatPackageReader.getNameOffset(bytes, 0)) && DatPackageReader.startsWithPackageName(bytes, DatPackageReader.getNameOffset(bytes, count - 1));
        }

        private static final boolean $$robo$$android_icu_impl_ICUBinary_DatPackageReader$startsWithPackageName(ByteBuffer bytes, int start) {
            byte c;
            int length = "icudt60b".length() - 1;
            for (int i = 0; i < length; ++i) {
                if (bytes.get(start + i) == "icudt60b".charAt(i)) continue;
                return false;
            }
            return ((c = bytes.get(start + length++)) == 98 || c == 108) && bytes.get(start + length) == 47;
        }

        private static final ByteBuffer $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getData(ByteBuffer bytes, CharSequence key) {
            int index = DatPackageReader.binarySearch(bytes, key);
            if (index >= 0) {
                ByteBuffer data = bytes.duplicate();
                data.position(DatPackageReader.getDataOffset(bytes, index));
                data.limit(DatPackageReader.getDataOffset(bytes, index + 1));
                return ICUBinary.sliceWithOrder(data);
            }
            return null;
        }

        private static final void $$robo$$android_icu_impl_ICUBinary_DatPackageReader$addBaseNamesInFolder(ByteBuffer bytes, String folder, String suffix, Set<String> names) {
            int index = DatPackageReader.binarySearch(bytes, folder);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
            int base = bytes.position();
            int count = bytes.getInt(base);
            StringBuilder sb = new StringBuilder();
            while (index < count && DatPackageReader.addBaseName(bytes, index, folder, suffix, sb, names)) {
                ++index;
            }
        }

        private static final int $$robo$$android_icu_impl_ICUBinary_DatPackageReader$binarySearch(ByteBuffer bytes, CharSequence key) {
            int base = bytes.position();
            int count = bytes.getInt(base);
            int start = 0;
            int limit = count;
            while (start < limit) {
                int mid = start + limit >>> 1;
                int nameOffset = DatPackageReader.getNameOffset(bytes, mid);
                int result = ICUBinary.compareKeys(key, bytes, nameOffset += "icudt60b".length() + 1);
                if (result < 0) {
                    limit = mid;
                    continue;
                }
                if (result > 0) {
                    start = mid + 1;
                    continue;
                }
                return mid;
            }
            return ~start;
        }

        private static final int $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getNameOffset(ByteBuffer bytes, int index) {
            int base = bytes.position();
            if (!($assertionsDisabled || 0 <= index && index < bytes.getInt(base))) {
                throw new AssertionError();
            }
            return base + bytes.getInt(base + 4 + index * 8);
        }

        private static final int $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getDataOffset(ByteBuffer bytes, int index) {
            int base = bytes.position();
            int count = bytes.getInt(base);
            if (index == count) {
                return bytes.capacity();
            }
            if (!($assertionsDisabled || 0 <= index && index < count)) {
                throw new AssertionError();
            }
            return base + bytes.getInt(base + 4 + 4 + index * 8);
        }

        private static final boolean $$robo$$android_icu_impl_ICUBinary_DatPackageReader$addBaseName(ByteBuffer bytes, int index, String folder, String suffix, StringBuilder sb, Set<String> names) {
            byte b;
            int offset = DatPackageReader.getNameOffset(bytes, index);
            offset += "icudt60b".length() + 1;
            if (folder.length() != 0) {
                int i = 0;
                while (i < folder.length()) {
                    if (bytes.get(offset) != folder.charAt(i)) {
                        return false;
                    }
                    ++i;
                    ++offset;
                }
                if (bytes.get(offset++) != 47) {
                    return false;
                }
            }
            sb.setLength(0);
            while ((b = bytes.get(offset++)) != 0) {
                char c = (char)b;
                if (c == '/') {
                    return true;
                }
                sb.append(c);
            }
            int nameLimit = sb.length() - suffix.length();
            if (sb.lastIndexOf(suffix, nameLimit) >= 0) {
                names.add(sb.substring(0, nameLimit));
            }
            return true;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ICUBinary.class.desiredAssertionStatus();
            IS_ACCEPTABLE = new IsAcceptable();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUBinary_DatPackageReader$__constructor__();
        }

        private DatPackageReader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$__constructor__(), 0, this);
        }

        static boolean validate(ByteBuffer byteBuffer) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("validate", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$validate(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
        }

        private static boolean startsWithPackageName(ByteBuffer byteBuffer, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("startsWithPackageName", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$startsWithPackageName(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
        }

        static ByteBuffer getData(ByteBuffer byteBuffer, CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrapStatic("getData", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getData(java.nio.ByteBuffer java.lang.CharSequence ), 0, (ByteBuffer)byteBuffer, (CharSequence)charSequence);
        }

        static void addBaseNamesInFolder(ByteBuffer byteBuffer, String string2, String string3, Set<String> set) {
            InvokeDynamicSupport.bootstrapStatic("addBaseNamesInFolder", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$addBaseNamesInFolder(java.nio.ByteBuffer java.lang.String java.lang.String java.util.Set<java.lang.String> ), 0, (ByteBuffer)byteBuffer, (String)string2, (String)string3, set);
        }

        private static int binarySearch(ByteBuffer byteBuffer, CharSequence charSequence) {
            return (int)InvokeDynamicSupport.bootstrapStatic("binarySearch", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$binarySearch(java.nio.ByteBuffer java.lang.CharSequence ), 0, (ByteBuffer)byteBuffer, (CharSequence)charSequence);
        }

        private static int getNameOffset(ByteBuffer byteBuffer, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getNameOffset", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getNameOffset(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
        }

        private static int getDataOffset(ByteBuffer byteBuffer, int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getDataOffset", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$getDataOffset(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
        }

        static boolean addBaseName(ByteBuffer byteBuffer, int n, String string2, String string3, StringBuilder stringBuilder, Set<String> set) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("addBaseName", $$robo$$android_icu_impl_ICUBinary_DatPackageReader$addBaseName(java.nio.ByteBuffer int java.lang.String java.lang.String java.lang.StringBuilder java.util.Set<java.lang.String> ), 0, (ByteBuffer)byteBuffer, (int)n, (String)string2, (String)string3, (StringBuilder)stringBuilder, set);
        }

        static {
            RobolectricInternals.classInitializing(DatPackageReader.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatPackageReader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class IsAcceptable
        implements Authenticate,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$__constructor__() {
            }

            private final boolean $$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$isDataVersionAcceptable(byte[] version) {
                return version[0] == 1;
            }

            private /* synthetic */ void $$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$__constructor__();
            }

            private IsAcceptable() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$__constructor__(), 0, this);
            }

            @Override
            public boolean isDataVersionAcceptable(byte[] byArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_impl_ICUBinary_DatPackageReader_IsAcceptable$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

