/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.text.CurrencyMetaInfo;
import android.icu.util.Currency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ICUCurrencyMetaInfo
extends CurrencyMetaInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ICUResourceBundle regionInfo;
    private ICUResourceBundle digitInfo;
    private static long MASK = 0xFFFFFFFFL;
    private static int Region = 1;
    private static int Currency = 2;
    private static int Date = 4;
    private static int Tender = 8;
    private static int Everything = Integer.MAX_VALUE;

    private void $$robo$$android_icu_impl_ICUCurrencyMetaInfo$__constructor__() {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/curr", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        this.regionInfo = bundle.findTopLevel("CurrencyMap");
        this.digitInfo = bundle.findTopLevel("CurrencyMeta");
    }

    private final List<CurrencyMetaInfo.CurrencyInfo> $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyInfo(CurrencyMetaInfo.CurrencyFilter filter) {
        return this.collect(new InfoCollector(), filter);
    }

    private final List<String> $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencies(CurrencyMetaInfo.CurrencyFilter filter) {
        return this.collect(new CurrencyCollector(), filter);
    }

    private final List<String> $$robo$$android_icu_impl_ICUCurrencyMetaInfo$regions(CurrencyMetaInfo.CurrencyFilter filter) {
        return this.collect(new RegionCollector(), filter);
    }

    private final CurrencyMetaInfo.CurrencyDigits $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyDigits(String isoCode) {
        return this.currencyDigits(isoCode, Currency.CurrencyUsage.STANDARD);
    }

    private final CurrencyMetaInfo.CurrencyDigits $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyDigits(String isoCode, Currency.CurrencyUsage currencyPurpose) {
        ICUResourceBundle b = this.digitInfo.findWithFallback(isoCode);
        if (b == null) {
            b = this.digitInfo.findWithFallback("DEFAULT");
        }
        int[] data = b.getIntVector();
        if (currencyPurpose == Currency.CurrencyUsage.CASH) {
            return new CurrencyMetaInfo.CurrencyDigits(data[2], data[3]);
        }
        if (currencyPurpose == Currency.CurrencyUsage.STANDARD) {
            return new CurrencyMetaInfo.CurrencyDigits(data[0], data[1]);
        }
        return new CurrencyMetaInfo.CurrencyDigits(data[0], data[1]);
    }

    private final <T> List<T> $$robo$$android_icu_impl_ICUCurrencyMetaInfo$collect(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter filter) {
        if (filter == null) {
            filter = CurrencyMetaInfo.CurrencyFilter.all();
        }
        int needed = collector.collects();
        if (filter.region != null) {
            needed |= 1;
        }
        if (filter.currency != null) {
            needed |= 2;
        }
        if (filter.from != Long.MIN_VALUE || filter.to != Long.MAX_VALUE) {
            needed |= 4;
        }
        if (filter.tenderOnly) {
            needed |= 8;
        }
        if (needed != 0) {
            if (filter.region != null) {
                ICUResourceBundle b = this.regionInfo.findWithFallback(filter.region);
                if (b != null) {
                    this.collectRegion(collector, filter, needed, b);
                }
            } else {
                for (int i = 0; i < this.regionInfo.getSize(); ++i) {
                    this.collectRegion(collector, filter, needed, this.regionInfo.at(i));
                }
            }
        }
        return collector.getList();
    }

    private final <T> void $$robo$$android_icu_impl_ICUCurrencyMetaInfo$collectRegion(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter filter, int needed, ICUResourceBundle b) {
        String region = b.getKey();
        if (needed == 1) {
            collector.collect(b.getKey(), null, 0L, 0L, -1, false);
            return;
        }
        for (int i = 0; i < b.getSize(); ++i) {
            ICUResourceBundle r = b.at(i);
            if (r.getSize() == 0) continue;
            String currency = null;
            long from = Long.MIN_VALUE;
            long to = Long.MAX_VALUE;
            boolean tender = true;
            if ((needed & 2) != 0) {
                ICUResourceBundle currBundle = r.at("id");
                currency = currBundle.getString();
                if (filter.currency != null && !filter.currency.equals(currency)) continue;
            }
            if ((needed & 4) != 0) {
                from = this.getDate(r.at("from"), Long.MIN_VALUE, false);
                to = this.getDate(r.at("to"), Long.MAX_VALUE, true);
                if (filter.from > to || filter.to < from) continue;
            }
            if ((needed & 8) != 0) {
                ICUResourceBundle tenderBundle = r.at("tender");
                boolean bl = tender = tenderBundle == null || "true".equals(tenderBundle.getString());
                if (filter.tenderOnly && !tender) continue;
            }
            collector.collect(region, currency, from, to, i, tender);
        }
    }

    private final long $$robo$$android_icu_impl_ICUCurrencyMetaInfo$getDate(ICUResourceBundle b, long defaultValue, boolean endOfDay) {
        if (b == null) {
            return defaultValue;
        }
        int[] values = b.getIntVector();
        return (long)values[0] << 32 | (long)values[1] & 0xFFFFFFFFL;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo$__constructor__();
    }

    public ICUCurrencyMetaInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$__constructor__(), 0, this);
    }

    @Override
    public List<CurrencyMetaInfo.CurrencyInfo> currencyInfo(CurrencyMetaInfo.CurrencyFilter currencyFilter) {
        return InvokeDynamicSupport.bootstrap("currencyInfo", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyInfo(android.icu.text.CurrencyMetaInfo$CurrencyFilter ), 0, this, currencyFilter);
    }

    @Override
    public List<String> currencies(CurrencyMetaInfo.CurrencyFilter currencyFilter) {
        return InvokeDynamicSupport.bootstrap("currencies", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencies(android.icu.text.CurrencyMetaInfo$CurrencyFilter ), 0, this, currencyFilter);
    }

    @Override
    public List<String> regions(CurrencyMetaInfo.CurrencyFilter currencyFilter) {
        return InvokeDynamicSupport.bootstrap("regions", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$regions(android.icu.text.CurrencyMetaInfo$CurrencyFilter ), 0, this, currencyFilter);
    }

    @Override
    public CurrencyMetaInfo.CurrencyDigits currencyDigits(String string2) {
        return InvokeDynamicSupport.bootstrap("currencyDigits", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyDigits(java.lang.String ), 0, this, string2);
    }

    @Override
    public CurrencyMetaInfo.CurrencyDigits currencyDigits(String string2, Currency.CurrencyUsage currencyUsage) {
        return InvokeDynamicSupport.bootstrap("currencyDigits", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$currencyDigits(java.lang.String android.icu.util.Currency$CurrencyUsage ), 0, this, string2, currencyUsage);
    }

    private <T> List<T> collect(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter currencyFilter) {
        return InvokeDynamicSupport.bootstrap("collect", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$collect(android.icu.impl.ICUCurrencyMetaInfo$Collector<T> android.icu.text.CurrencyMetaInfo$CurrencyFilter ), 0, this, collector, currencyFilter);
    }

    private <T> void collectRegion(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter currencyFilter, int n, ICUResourceBundle iCUResourceBundle) {
        InvokeDynamicSupport.bootstrap("collectRegion", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$collectRegion(android.icu.impl.ICUCurrencyMetaInfo$Collector<T> android.icu.text.CurrencyMetaInfo$CurrencyFilter int android.icu.impl.ICUResourceBundle ), 0, this, collector, currencyFilter, n, iCUResourceBundle);
    }

    private long getDate(ICUResourceBundle iCUResourceBundle, long l, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_icu_impl_ICUCurrencyMetaInfo$getDate(android.icu.impl.ICUResourceBundle long boolean ), 0, this, iCUResourceBundle, l, bl);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUCurrencyMetaInfo)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface Collector<T> {
        public int collects();

        public void collect(String var1, String var2, long var3, long var5, int var7, boolean var8);

        public List<T> getList();
    }

    private static class CurrencyCollector
    implements Collector<String> {
        public transient /* synthetic */ Object __robo_data__;
        private UniqueList<String> result;

        private void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$__constructor__() {
            this.result = UniqueList.create();
        }

        private final void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$collect(String region, String currency, long from, long to, int priority, boolean tender) {
            this.result.add(currency);
        }

        private final int $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$collects() {
            return 2;
        }

        private final List<String> $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$getList() {
            return this.result.list();
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$__constructor__();
        }

        private CurrencyCollector() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$__constructor__(), 0, this);
        }

        @Override
        public void collect(String string2, String string3, long l, long l2, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("collect", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$collect(java.lang.String java.lang.String long long int boolean ), 0, this, string2, string3, l, l2, n, bl);
        }

        @Override
        public int collects() {
            return (int)InvokeDynamicSupport.bootstrap("collects", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$collects(), 0, this);
        }

        @Override
        public List<String> getList() {
            return InvokeDynamicSupport.bootstrap("getList", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$getList(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_CurrencyCollector$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyCollector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class RegionCollector
    implements Collector<String> {
        public transient /* synthetic */ Object __robo_data__;
        private UniqueList<String> result;

        private void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$__constructor__() {
            this.result = UniqueList.create();
        }

        private final void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$collect(String region, String currency, long from, long to, int priority, boolean tender) {
            this.result.add(region);
        }

        private final int $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$collects() {
            return 1;
        }

        private final List<String> $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$getList() {
            return this.result.list();
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$__constructor__();
        }

        private RegionCollector() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$__constructor__(), 0, this);
        }

        @Override
        public void collect(String string2, String string3, long l, long l2, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("collect", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$collect(java.lang.String java.lang.String long long int boolean ), 0, this, string2, string3, l, l2, n, bl);
        }

        @Override
        public int collects() {
            return (int)InvokeDynamicSupport.bootstrap("collects", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$collects(), 0, this);
        }

        @Override
        public List<String> getList() {
            return InvokeDynamicSupport.bootstrap("getList", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$getList(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_RegionCollector$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegionCollector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InfoCollector
    implements Collector<CurrencyMetaInfo.CurrencyInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private List<CurrencyMetaInfo.CurrencyInfo> result;

        private void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$__constructor__() {
            this.result = new ArrayList<CurrencyMetaInfo.CurrencyInfo>();
        }

        private final void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$collect(String region, String currency, long from, long to, int priority, boolean tender) {
            this.result.add(new CurrencyMetaInfo.CurrencyInfo(region, currency, from, to, priority, tender));
        }

        private final List<CurrencyMetaInfo.CurrencyInfo> $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$getList() {
            return Collections.unmodifiableList(this.result);
        }

        private final int $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$collects() {
            return Integer.MAX_VALUE;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$__constructor__();
        }

        private InfoCollector() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$__constructor__(), 0, this);
        }

        @Override
        public void collect(String string2, String string3, long l, long l2, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("collect", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$collect(java.lang.String java.lang.String long long int boolean ), 0, this, string2, string3, l, l2, n, bl);
        }

        @Override
        public List<CurrencyMetaInfo.CurrencyInfo> getList() {
            return InvokeDynamicSupport.bootstrap("getList", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$getList(), 0, this);
        }

        @Override
        public int collects() {
            return (int)InvokeDynamicSupport.bootstrap("collects", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$collects(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_InfoCollector$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InfoCollector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class UniqueList<T> {
        public transient /* synthetic */ Object __robo_data__;
        private Set<T> seen;
        private List<T> list;

        private void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$__constructor__() {
            this.seen = new HashSet<T>();
            this.list = new ArrayList<T>();
        }

        private static final <T> UniqueList<T> $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$create() {
            return new UniqueList<T>();
        }

        private final void $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$add(T value) {
            if (!this.seen.contains(value)) {
                this.list.add(value);
                this.seen.add(value);
            }
        }

        private final List<T> $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$list() {
            return Collections.unmodifiableList(this.list);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$__constructor__();
        }

        private UniqueList() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$__constructor__(), 0, this);
        }

        private static <T> UniqueList<T> create() {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$create(), 0);
        }

        void add(T t) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$add(T ), 0, this, t);
        }

        List<T> list() {
            return InvokeDynamicSupport.bootstrap("list", $$robo$$android_icu_impl_ICUCurrencyMetaInfo_UniqueList$list(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UniqueList)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

