/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUBinary;
import android.icu.impl.Trie2;
import android.icu.impl.Trie2_16;
import android.icu.text.UTF16;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UCaseProps
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte[] flagsOffset;
    public static int MAX_STRING_LENGTH = 31;
    public static int LOC_ROOT = 1;
    private static int LOC_TURKISH = 2;
    private static int LOC_LITHUANIAN = 3;
    static int LOC_GREEK = 4;
    public static int LOC_DUTCH = 5;
    private static String iDot = "i\u0307";
    private static String jDot = "j\u0307";
    private static String iOgonekDot = "\u012f\u0307";
    private static String iDotGrave = "i\u0307\u0300";
    private static String iDotAcute = "i\u0307\u0301";
    private static String iDotTilde = "i\u0307\u0303";
    private static int FOLD_CASE_OPTIONS_MASK = 7;
    public static StringBuilder dummyStringBuilder;
    private int[] indexes;
    private String exceptions;
    private char[] unfold;
    private Trie2_16 trie;
    private static String DATA_NAME = "ucase";
    private static String DATA_TYPE = "icu";
    private static String DATA_FILE_NAME = "ucase.icu";
    private static int FMT = 1665225541;
    private static int IX_TRIE_SIZE = 2;
    private static int IX_EXC_LENGTH = 3;
    private static int IX_UNFOLD_LENGTH = 4;
    private static int IX_TOP = 16;
    public static int TYPE_MASK = 3;
    public static int NONE = 0;
    public static int LOWER = 1;
    public static int UPPER = 2;
    public static int TITLE = 3;
    static int IGNORABLE = 4;
    private static int SENSITIVE = 8;
    private static int EXCEPTION = 16;
    private static int DOT_MASK = 96;
    private static int SOFT_DOTTED = 32;
    private static int ABOVE = 64;
    private static int OTHER_ACCENT = 96;
    private static int DELTA_SHIFT = 7;
    private static int EXC_SHIFT = 5;
    private static int EXC_LOWER = 0;
    private static int EXC_FOLD = 1;
    private static int EXC_UPPER = 2;
    private static int EXC_TITLE = 3;
    private static int EXC_CLOSURE = 6;
    private static int EXC_FULL_MAPPINGS = 7;
    private static int EXC_DOUBLE_SLOTS = 256;
    private static int EXC_DOT_SHIFT = 7;
    private static int EXC_CONDITIONAL_SPECIAL = 16384;
    private static int EXC_CONDITIONAL_FOLD = 32768;
    private static int FULL_LOWER = 15;
    private static int CLOSURE_MAX_LENGTH = 15;
    private static int UNFOLD_ROWS = 0;
    private static int UNFOLD_ROW_WIDTH = 1;
    private static int UNFOLD_STRING_WIDTH = 2;
    public static UCaseProps INSTANCE;

    private void $$robo$$android_icu_impl_UCaseProps$__constructor__() throws IOException {
        ByteBuffer bytes = ICUBinary.getRequiredData("ucase.icu");
        this.readData(bytes);
    }

    private final void $$robo$$android_icu_impl_UCaseProps$readData(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1665225541, new IsAcceptable());
        int count = bytes.getInt();
        if (count < 16) {
            throw new IOException("indexes[0] too small in ucase.icu");
        }
        this.indexes = new int[count];
        this.indexes[0] = count;
        for (int i = 1; i < count; ++i) {
            this.indexes[i] = bytes.getInt();
        }
        this.trie = Trie2_16.createFromSerialized(bytes);
        int expectedTrieLength = this.indexes[2];
        int trieLength = this.trie.getSerializedLength();
        if (trieLength > expectedTrieLength) {
            throw new IOException("ucase.icu: not enough bytes for the trie");
        }
        ICUBinary.skipBytes(bytes, expectedTrieLength - trieLength);
        count = this.indexes[3];
        if (count > 0) {
            this.exceptions = ICUBinary.getString(bytes, count, 0);
        }
        if ((count = this.indexes[4]) > 0) {
            this.unfold = ICUBinary.getChars(bytes, count, 0);
        }
    }

    private final void $$robo$$android_icu_impl_UCaseProps$addPropertyStarts(UnicodeSet set) {
        for (Trie2.Range range : this.trie) {
            if (range.leadSurrogate) break;
            set.add(range.startCodePoint);
        }
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getExceptionsOffset(int props) {
        return props >> 5;
    }

    private static final boolean $$robo$$android_icu_impl_UCaseProps$propsHasException(int props) {
        return (props & 0x10) != 0;
    }

    private static final boolean $$robo$$android_icu_impl_UCaseProps$hasSlot(int flags, int index) {
        return (flags & 1 << index) != 0;
    }

    private static final byte $$robo$$android_icu_impl_UCaseProps$slotOffset(int flags, int index) {
        return flagsOffset[flags & (1 << index) - 1];
    }

    private final long $$robo$$android_icu_impl_UCaseProps$getSlotValueAndOffset(int excWord, int index, int excOffset) {
        long value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            excOffset += 2 * UCaseProps.slotOffset(excWord, index);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | (long)this.exceptions.charAt(excOffset);
        }
        return value | (long)excOffset << 32;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$getSlotValue(int excWord, int index, int excOffset) {
        int value;
        if ((excWord & 0x100) == 0) {
            value = this.exceptions.charAt(excOffset += UCaseProps.slotOffset(excWord, index));
        } else {
            excOffset += 2 * UCaseProps.slotOffset(excWord, index);
            value = this.exceptions.charAt(excOffset++);
            value = value << 16 | this.exceptions.charAt(excOffset);
        }
        return value;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$tolower(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) >= 2) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 0)) {
                c = this.getSlotValue(excWord, 0, excOffset);
            }
        }
        return c;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toupper(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 2)) {
                c = this.getSlotValue(excWord, 2, excOffset);
            }
        }
        return c;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$totitle(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            int index;
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (UCaseProps.hasSlot(excWord = this.exceptions.charAt(excOffset++), 3)) {
                index = 3;
            } else if (UCaseProps.hasSlot(excWord, 2)) {
                index = 2;
            } else {
                return c;
            }
            c = this.getSlotValue(excWord, index, excOffset);
        }
        return c;
    }

    private final void $$robo$$android_icu_impl_UCaseProps$addCaseClosure(int c, UnicodeSet set) {
        switch (c) {
            case 73: {
                set.add(105);
                return;
            }
            case 105: {
                set.add(73);
                return;
            }
            case 304: {
                set.add("i\u0307");
                return;
            }
            case 305: {
                return;
            }
        }
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            int delta;
            if (UCaseProps.getTypeFromProps(props) != 0 && (delta = UCaseProps.getDelta(props)) != 0) {
                set.add(c + delta);
            }
        } else {
            int closureOffset;
            int closureLength;
            long value;
            int index;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset0 = excOffset;
            for (index = 0; index <= 3; ++index) {
                if (!UCaseProps.hasSlot(excWord, index)) continue;
                excOffset = excOffset0;
                c = this.getSlotValue(excWord, index, excOffset);
                set.add(c);
            }
            if (UCaseProps.hasSlot(excWord, 6)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 6, excOffset);
                closureLength = (int)value & 0xF;
                closureOffset = (int)(value >> 32) + 1;
            } else {
                closureLength = 0;
                closureOffset = 0;
            }
            if (UCaseProps.hasSlot(excWord, 7)) {
                excOffset = excOffset0;
                value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int fullLength = (int)value;
                excOffset = (int)(value >> 32) + 1;
                excOffset += (fullLength &= 0xFFFF) & 0xF;
                int length = (fullLength >>= 4) & 0xF;
                if (length != 0) {
                    set.add(this.exceptions.substring(excOffset, excOffset + length));
                    excOffset += length;
                }
                excOffset += (fullLength >>= 4) & 0xF;
                closureOffset = excOffset += (fullLength >>= 4);
            }
            int limit = closureOffset + closureLength;
            for (index = closureOffset; index < limit; index += UTF16.getCharCount(c)) {
                c = this.exceptions.codePointAt(index);
                set.add(c);
            }
        }
    }

    private final int $$robo$$android_icu_impl_UCaseProps$strcmpMax(String s, int unfoldOffset, int max) {
        int length = s.length();
        max -= length;
        int i1 = 0;
        do {
            char c2;
            int c1 = s.charAt(i1++);
            if ((c2 = this.unfold[unfoldOffset++]) == '\u0000') {
                return 1;
            }
            if ((c1 -= c2) == 0) continue;
            return c1;
        } while (--length > 0);
        if (max == 0 || this.unfold[unfoldOffset] == '\u0000') {
            return 0;
        }
        return -max;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$addStringCaseClosure(String s, UnicodeSet set) {
        if (this.unfold == null || s == null) {
            return false;
        }
        int length = s.length();
        if (length <= 1) {
            return false;
        }
        int unfoldRows = this.unfold[0];
        char unfoldRowWidth = this.unfold[1];
        int unfoldStringWidth = this.unfold[2];
        if (length > unfoldStringWidth) {
            return false;
        }
        int start = 0;
        int limit = unfoldRows;
        while (start < limit) {
            int i = (start + limit) / 2;
            int unfoldOffset = (i + 1) * unfoldRowWidth;
            int result = this.strcmpMax(s, unfoldOffset, unfoldStringWidth);
            if (result == 0) {
                int c;
                for (i = unfoldStringWidth; i < unfoldRowWidth && this.unfold[unfoldOffset + i] != '\u0000'; i += UTF16.getCharCount(c)) {
                    c = UTF16.charAt(this.unfold, unfoldOffset, this.unfold.length, i);
                    set.add(c);
                    this.addCaseClosure(c, set);
                }
                return true;
            }
            if (result < 0) {
                limit = i;
                continue;
            }
            start = i + 1;
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$getType(int c) {
        return UCaseProps.getTypeFromProps(this.trie.get(c));
    }

    private final int $$robo$$android_icu_impl_UCaseProps$getTypeOrIgnorable(int c) {
        return UCaseProps.getTypeAndIgnorableFromProps(this.trie.get(c));
    }

    private final int $$robo$$android_icu_impl_UCaseProps$getDotType(int c) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            return props & 0x60;
        }
        return this.exceptions.charAt(UCaseProps.getExceptionsOffset(props)) >> 7 & 0x60;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isSoftDotted(int c) {
        return this.getDotType(c) == 32;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isCaseSensitive(int c) {
        return (this.trie.get(c) & 8) != 0;
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getCaseLocale(Locale locale) {
        return UCaseProps.getCaseLocale(locale.getLanguage());
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getCaseLocale(ULocale locale) {
        return UCaseProps.getCaseLocale(locale.getLanguage());
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getCaseLocale(String language) {
        if (language.length() == 2) {
            if (language.equals("en") || language.charAt(0) > 't') {
                return 1;
            }
            if (language.equals("tr") || language.equals("az")) {
                return 2;
            }
            if (language.equals("el")) {
                return 4;
            }
            if (language.equals("lt")) {
                return 3;
            }
            if (language.equals("nl")) {
                return 5;
            }
        } else if (language.length() == 3) {
            if (language.equals("tur") || language.equals("aze")) {
                return 2;
            }
            if (language.equals("ell")) {
                return 4;
            }
            if (language.equals("lit")) {
                return 3;
            }
            if (language.equals("nld")) {
                return 5;
            }
        }
        return 1;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isFollowedByCasedLetter(ContextIterator iter, int dir) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(dir);
        while ((c = iter.next()) >= 0) {
            int type = this.getTypeOrIgnorable(c);
            if ((type & 4) != 0) continue;
            return type != 0;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isPrecededBySoftDotted(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(-1);
        while ((c = iter.next()) >= 0) {
            int dotType = this.getDotType(c);
            if (dotType == 32) {
                return true;
            }
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isPrecededBy_I(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(-1);
        while ((c = iter.next()) >= 0) {
            if (c == 73) {
                return true;
            }
            int dotType = this.getDotType(c);
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isFollowedByMoreAbove(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(1);
        while ((c = iter.next()) >= 0) {
            int dotType = this.getDotType(c);
            if (dotType == 64) {
                return true;
            }
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$isFollowedByDotAbove(ContextIterator iter) {
        int c;
        if (iter == null) {
            return false;
        }
        iter.reset(1);
        while ((c = iter.next()) >= 0) {
            if (c == 775) {
                return true;
            }
            int dotType = this.getDotType(c);
            if (dotType == 96) continue;
            return false;
        }
        return false;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toFullLower(int c, ContextIterator iter, Appendable out, int caseLocale) {
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) >= 2) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            long value;
            int full;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x4000) != 0) {
                if (caseLocale == 3 && ((c == 73 || c == 74 || c == 302) && this.isFollowedByMoreAbove(iter) || c == 204 || c == 205 || c == 296)) {
                    try {
                        switch (c) {
                            case 73: {
                                out.append("i\u0307");
                                return 2;
                            }
                            case 74: {
                                out.append("j\u0307");
                                return 2;
                            }
                            case 302: {
                                out.append("\u012f\u0307");
                                return 2;
                            }
                            case 204: {
                                out.append("i\u0307\u0300");
                                return 3;
                            }
                            case 205: {
                                out.append("i\u0307\u0301");
                                return 3;
                            }
                            case 296: {
                                out.append("i\u0307\u0303");
                                return 3;
                            }
                        }
                        return 0;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
                if (caseLocale == 2 && c == 304) {
                    return 105;
                }
                if (caseLocale == 2 && c == 775 && this.isPrecededBy_I(iter)) {
                    return 0;
                }
                if (caseLocale == 2 && c == 73 && !this.isFollowedByDotAbove(iter)) {
                    return 305;
                }
                if (c == 304) {
                    try {
                        out.append("i\u0307");
                        return 2;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
                if (c == 931 && !this.isFollowedByCasedLetter(iter, 1) && this.isFollowedByCasedLetter(iter, -1)) {
                    return 962;
                }
            } else if (UCaseProps.hasSlot(excWord, 7) && (full = (int)(value = this.getSlotValueAndOffset(excWord, 7, excOffset)) & 0xF) != 0) {
                excOffset = (int)(value >> 32) + 1;
                try {
                    out.append(this.exceptions, excOffset, excOffset + full);
                    return full;
                }
                catch (IOException e) {
                    throw new ICUUncheckedIOException(e);
                }
            }
            if (UCaseProps.hasSlot(excWord, 0)) {
                result = this.getSlotValue(excWord, 0, excOffset2);
            }
        }
        return result == c ? ~result : result;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toUpperOrTitle(int c, ContextIterator iter, Appendable out, int loc, boolean upperNotTitle) {
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) == 1) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            int index;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x4000) != 0) {
                if (loc == 2 && c == 105) {
                    return 304;
                }
                if (loc == 3 && c == 775 && this.isPrecededBySoftDotted(iter)) {
                    return 0;
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int full = (int)value & 0xFFFF;
                excOffset = (int)(value >> 32) + 1;
                excOffset += full & 0xF;
                excOffset += (full >>= 4) & 0xF;
                full >>= 4;
                if (upperNotTitle) {
                    full &= 0xF;
                } else {
                    excOffset += full & 0xF;
                    full = full >> 4 & 0xF;
                }
                if (full != 0) {
                    try {
                        out.append(this.exceptions, excOffset, excOffset + full);
                        return full;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            }
            if (!upperNotTitle && UCaseProps.hasSlot(excWord, 3)) {
                index = 3;
            } else if (UCaseProps.hasSlot(excWord, 2)) {
                index = 2;
            } else {
                return ~c;
            }
            result = this.getSlotValue(excWord, index, excOffset2);
        }
        return result == c ? ~result : result;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toFullUpper(int c, ContextIterator iter, Appendable out, int caseLocale) {
        return this.toUpperOrTitle(c, iter, out, caseLocale, true);
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toFullTitle(int c, ContextIterator iter, Appendable out, int caseLocale) {
        return this.toUpperOrTitle(c, iter, out, caseLocale, false);
    }

    private final int $$robo$$android_icu_impl_UCaseProps$fold(int c, int options) {
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) >= 2) {
                c += UCaseProps.getDelta(props);
            }
        } else {
            int index;
            char excWord;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            if (((excWord = this.exceptions.charAt(excOffset++)) & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        return c;
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = 1;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = 0;
            } else {
                return c;
            }
            c = this.getSlotValue(excWord, index, excOffset);
        }
        return c;
    }

    private final int $$robo$$android_icu_impl_UCaseProps$toFullFolding(int c, Appendable out, int options) {
        int result = c;
        int props = this.trie.get(c);
        if (!UCaseProps.propsHasException(props)) {
            if (UCaseProps.getTypeFromProps(props) >= 2) {
                result = c + UCaseProps.getDelta(props);
            }
        } else {
            int index;
            int excOffset = UCaseProps.getExceptionsOffset(props);
            char excWord = this.exceptions.charAt(excOffset++);
            int excOffset2 = excOffset;
            if ((excWord & 0x8000) != 0) {
                if ((options & 7) == 0) {
                    if (c == 73) {
                        return 105;
                    }
                    if (c == 304) {
                        try {
                            out.append("i\u0307");
                            return 2;
                        }
                        catch (IOException e) {
                            throw new ICUUncheckedIOException(e);
                        }
                    }
                } else {
                    if (c == 73) {
                        return 305;
                    }
                    if (c == 304) {
                        return 105;
                    }
                }
            } else if (UCaseProps.hasSlot(excWord, 7)) {
                long value = this.getSlotValueAndOffset(excWord, 7, excOffset);
                int full = (int)value & 0xFFFF;
                excOffset = (int)(value >> 32) + 1;
                excOffset += full & 0xF;
                if ((full = full >> 4 & 0xF) != 0) {
                    try {
                        out.append(this.exceptions, excOffset, excOffset + full);
                        return full;
                    }
                    catch (IOException e) {
                        throw new ICUUncheckedIOException(e);
                    }
                }
            }
            if (UCaseProps.hasSlot(excWord, 1)) {
                index = 1;
            } else if (UCaseProps.hasSlot(excWord, 0)) {
                index = 0;
            } else {
                return ~c;
            }
            result = this.getSlotValue(excWord, index, excOffset2);
        }
        return result == c ? ~result : result;
    }

    private final boolean $$robo$$android_icu_impl_UCaseProps$hasBinaryProperty(int c, int which) {
        switch (which) {
            case 22: {
                return 1 == this.getType(c);
            }
            case 30: {
                return 2 == this.getType(c);
            }
            case 27: {
                return this.isSoftDotted(c);
            }
            case 34: {
                return this.isCaseSensitive(c);
            }
            case 49: {
                return 0 != this.getType(c);
            }
            case 50: {
                return this.getTypeOrIgnorable(c) >> 2 != 0;
            }
            case 51: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 52: {
                dummyStringBuilder.setLength(0);
                return this.toFullUpper(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 53: {
                dummyStringBuilder.setLength(0);
                return this.toFullTitle(c, null, dummyStringBuilder, 1) >= 0;
            }
            case 55: {
                dummyStringBuilder.setLength(0);
                return this.toFullLower(c, null, dummyStringBuilder, 1) >= 0 || this.toFullUpper(c, null, dummyStringBuilder, 1) >= 0 || this.toFullTitle(c, null, dummyStringBuilder, 1) >= 0;
            }
        }
        return false;
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getTypeFromProps(int props) {
        return props & 3;
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getTypeAndIgnorableFromProps(int props) {
        return props & 7;
    }

    private static final int $$robo$$android_icu_impl_UCaseProps$getDelta(int props) {
        return (short)props >> 7;
    }

    static void __staticInitializer__() {
        flagsOffset = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
        dummyStringBuilder = new StringBuilder();
        try {
            INSTANCE = new UCaseProps();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void __constructor__() throws IOException {
        this.$$robo$$android_icu_impl_UCaseProps$__constructor__();
    }

    private UCaseProps() throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UCaseProps$__constructor__(), 0, this);
    }

    private void readData(ByteBuffer byteBuffer) throws IOException {
        InvokeDynamicSupport.bootstrap("readData", $$robo$$android_icu_impl_UCaseProps$readData(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    public void addPropertyStarts(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addPropertyStarts", $$robo$$android_icu_impl_UCaseProps$addPropertyStarts(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    private static int getExceptionsOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getExceptionsOffset", $$robo$$android_icu_impl_UCaseProps$getExceptionsOffset(int ), 0, (int)n);
    }

    private static boolean propsHasException(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("propsHasException", $$robo$$android_icu_impl_UCaseProps$propsHasException(int ), 0, (int)n);
    }

    private static boolean hasSlot(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSlot", $$robo$$android_icu_impl_UCaseProps$hasSlot(int int ), 0, (int)n, (int)n2);
    }

    private static byte slotOffset(int n, int n2) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("slotOffset", $$robo$$android_icu_impl_UCaseProps$slotOffset(int int ), 0, (int)n, (int)n2);
    }

    private long getSlotValueAndOffset(int n, int n2, int n3) {
        return (long)InvokeDynamicSupport.bootstrap("getSlotValueAndOffset", $$robo$$android_icu_impl_UCaseProps$getSlotValueAndOffset(int int int ), 0, this, n, n2, n3);
    }

    private int getSlotValue(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getSlotValue", $$robo$$android_icu_impl_UCaseProps$getSlotValue(int int int ), 0, this, n, n2, n3);
    }

    public int tolower(int n) {
        return (int)InvokeDynamicSupport.bootstrap("tolower", $$robo$$android_icu_impl_UCaseProps$tolower(int ), 0, this, n);
    }

    public int toupper(int n) {
        return (int)InvokeDynamicSupport.bootstrap("toupper", $$robo$$android_icu_impl_UCaseProps$toupper(int ), 0, this, n);
    }

    public int totitle(int n) {
        return (int)InvokeDynamicSupport.bootstrap("totitle", $$robo$$android_icu_impl_UCaseProps$totitle(int ), 0, this, n);
    }

    public void addCaseClosure(int n, UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addCaseClosure", $$robo$$android_icu_impl_UCaseProps$addCaseClosure(int android.icu.text.UnicodeSet ), 0, this, n, unicodeSet);
    }

    private int strcmpMax(String string2, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("strcmpMax", $$robo$$android_icu_impl_UCaseProps$strcmpMax(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public boolean addStringCaseClosure(String string2, UnicodeSet unicodeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("addStringCaseClosure", $$robo$$android_icu_impl_UCaseProps$addStringCaseClosure(java.lang.String android.icu.text.UnicodeSet ), 0, this, string2, unicodeSet);
    }

    public int getType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_impl_UCaseProps$getType(int ), 0, this, n);
    }

    public int getTypeOrIgnorable(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTypeOrIgnorable", $$robo$$android_icu_impl_UCaseProps$getTypeOrIgnorable(int ), 0, this, n);
    }

    public int getDotType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDotType", $$robo$$android_icu_impl_UCaseProps$getDotType(int ), 0, this, n);
    }

    public boolean isSoftDotted(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSoftDotted", $$robo$$android_icu_impl_UCaseProps$isSoftDotted(int ), 0, this, n);
    }

    public boolean isCaseSensitive(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCaseSensitive", $$robo$$android_icu_impl_UCaseProps$isCaseSensitive(int ), 0, this, n);
    }

    public static int getCaseLocale(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCaseLocale", $$robo$$android_icu_impl_UCaseProps$getCaseLocale(java.util.Locale ), 0, (Locale)locale);
    }

    public static int getCaseLocale(ULocale uLocale) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCaseLocale", $$robo$$android_icu_impl_UCaseProps$getCaseLocale(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static int getCaseLocale(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCaseLocale", $$robo$$android_icu_impl_UCaseProps$getCaseLocale(java.lang.String ), 0, (String)string2);
    }

    private boolean isFollowedByCasedLetter(ContextIterator contextIterator, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFollowedByCasedLetter", $$robo$$android_icu_impl_UCaseProps$isFollowedByCasedLetter(android.icu.impl.UCaseProps$ContextIterator int ), 0, this, contextIterator, n);
    }

    private boolean isPrecededBySoftDotted(ContextIterator contextIterator) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrecededBySoftDotted", $$robo$$android_icu_impl_UCaseProps$isPrecededBySoftDotted(android.icu.impl.UCaseProps$ContextIterator ), 0, this, contextIterator);
    }

    private boolean isPrecededBy_I(ContextIterator contextIterator) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrecededBy_I", $$robo$$android_icu_impl_UCaseProps$isPrecededBy_I(android.icu.impl.UCaseProps$ContextIterator ), 0, this, contextIterator);
    }

    private boolean isFollowedByMoreAbove(ContextIterator contextIterator) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFollowedByMoreAbove", $$robo$$android_icu_impl_UCaseProps$isFollowedByMoreAbove(android.icu.impl.UCaseProps$ContextIterator ), 0, this, contextIterator);
    }

    private boolean isFollowedByDotAbove(ContextIterator contextIterator) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFollowedByDotAbove", $$robo$$android_icu_impl_UCaseProps$isFollowedByDotAbove(android.icu.impl.UCaseProps$ContextIterator ), 0, this, contextIterator);
    }

    public int toFullLower(int n, ContextIterator contextIterator, Appendable appendable, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("toFullLower", $$robo$$android_icu_impl_UCaseProps$toFullLower(int android.icu.impl.UCaseProps$ContextIterator java.lang.Appendable int ), 0, this, n, contextIterator, appendable, n2);
    }

    private int toUpperOrTitle(int n, ContextIterator contextIterator, Appendable appendable, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("toUpperOrTitle", $$robo$$android_icu_impl_UCaseProps$toUpperOrTitle(int android.icu.impl.UCaseProps$ContextIterator java.lang.Appendable int boolean ), 0, this, n, contextIterator, appendable, n2, bl);
    }

    public int toFullUpper(int n, ContextIterator contextIterator, Appendable appendable, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("toFullUpper", $$robo$$android_icu_impl_UCaseProps$toFullUpper(int android.icu.impl.UCaseProps$ContextIterator java.lang.Appendable int ), 0, this, n, contextIterator, appendable, n2);
    }

    public int toFullTitle(int n, ContextIterator contextIterator, Appendable appendable, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("toFullTitle", $$robo$$android_icu_impl_UCaseProps$toFullTitle(int android.icu.impl.UCaseProps$ContextIterator java.lang.Appendable int ), 0, this, n, contextIterator, appendable, n2);
    }

    public int fold(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("fold", $$robo$$android_icu_impl_UCaseProps$fold(int int ), 0, this, n, n2);
    }

    public int toFullFolding(int n, Appendable appendable, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("toFullFolding", $$robo$$android_icu_impl_UCaseProps$toFullFolding(int java.lang.Appendable int ), 0, this, n, appendable, n2);
    }

    public boolean hasBinaryProperty(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasBinaryProperty", $$robo$$android_icu_impl_UCaseProps$hasBinaryProperty(int int ), 0, this, n, n2);
    }

    private static int getTypeFromProps(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTypeFromProps", $$robo$$android_icu_impl_UCaseProps$getTypeFromProps(int ), 0, (int)n);
    }

    private static int getTypeAndIgnorableFromProps(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTypeAndIgnorableFromProps", $$robo$$android_icu_impl_UCaseProps$getTypeAndIgnorableFromProps(int ), 0, (int)n);
    }

    private static int getDelta(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDelta", $$robo$$android_icu_impl_UCaseProps$getDelta(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(UCaseProps.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UCaseProps)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ContextIterator
    extends InstrumentedInterface {
        public void reset(int var1);

        public int next();
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_UCaseProps_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_UCaseProps_IsAcceptable$isDataVersionAcceptable(byte[] version) {
            return version[0] == 3;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_UCaseProps_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_UCaseProps_IsAcceptable$__constructor__();
        }

        private IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_UCaseProps_IsAcceptable$__constructor__(), 0, this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_UCaseProps_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_UCaseProps_IsAcceptable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

