/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.Normalizer2Impl;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationFCD;
import android.icu.impl.coll.CollationIterator;
import android.icu.impl.coll.UTF16CollationIterator;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FCDUTF16CollationIterator
extends UTF16CollationIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CharSequence rawSeq;
    private static int rawStart = 0;
    private int segmentStart;
    private int segmentLimit;
    private int rawLimit;
    private Normalizer2Impl nfcImpl;
    private StringBuilder normalized;
    private int checkDir;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(CollationData d) {
        this.nfcImpl = d.nfcImpl;
    }

    private void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(CollationData data, boolean numeric, CharSequence s, int p) {
        this.rawSeq = s;
        this.segmentStart = p;
        this.rawLimit = s.length();
        this.nfcImpl = data.nfcImpl;
        this.checkDir = 1;
    }

    private final boolean $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$equals(Object other) {
        if (!(other instanceof CollationIterator && ((CollationIterator)this).equals(other) && other instanceof FCDUTF16CollationIterator)) {
            return false;
        }
        FCDUTF16CollationIterator o = (FCDUTF16CollationIterator)other;
        if (this.checkDir != o.checkDir) {
            return false;
        }
        if (this.checkDir == 0 && this.seq == this.rawSeq != (o.seq == o.rawSeq)) {
            return false;
        }
        if (this.checkDir != 0 || this.seq == this.rawSeq) {
            return this.pos - 0 == o.pos - 0;
        }
        return this.segmentStart - 0 == o.segmentStart - 0 && this.pos - this.start == o.pos - o.start;
    }

    private final int $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 42;
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$resetToOffset(int newOffset) {
        this.reset();
        this.seq = this.rawSeq;
        this.segmentStart = this.pos = 0 + newOffset;
        this.start = this.pos;
        this.limit = this.rawLimit;
        this.checkDir = 1;
    }

    private final int $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$getOffset() {
        if (this.checkDir != 0 || this.seq == this.rawSeq) {
            return this.pos - 0;
        }
        if (this.pos == this.start) {
            return this.segmentStart - 0;
        }
        return this.segmentLimit - 0;
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$setText(boolean numeric, CharSequence s, int p) {
        super.setText(numeric, s, p);
        this.rawSeq = s;
        this.segmentStart = p;
        this.rawLimit = this.limit = s.length();
        this.checkDir = 1;
    }

    private final int $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$nextCodePoint() {
        char trail;
        char c;
        while (true) {
            if (this.checkDir > 0) {
                if (this.pos == this.limit) {
                    return -1;
                }
                if (!CollationFCD.hasTccc(c = this.seq.charAt(this.pos++)) || !CollationFCD.maybeTibetanCompositeVowel(c) && (this.pos == this.limit || !CollationFCD.hasLccc(this.seq.charAt(this.pos)))) break;
                --this.pos;
                this.nextSegment();
                c = this.seq.charAt(this.pos++);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.limit) {
                c = this.seq.charAt(this.pos++);
                break;
            }
            this.switchToForward();
        }
        if (Character.isHighSurrogate(c) && this.pos != this.limit && Character.isLowSurrogate(trail = this.seq.charAt(this.pos))) {
            ++this.pos;
            return Character.toCodePoint(c, trail);
        }
        return c;
    }

    private final int $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$previousCodePoint() {
        char lead;
        char c;
        while (true) {
            if (this.checkDir < 0) {
                if (this.pos == this.start) {
                    return -1;
                }
                if (!CollationFCD.hasLccc(c = this.seq.charAt(--this.pos)) || !CollationFCD.maybeTibetanCompositeVowel(c) && (this.pos == this.start || !CollationFCD.hasTccc(this.seq.charAt(this.pos - 1)))) break;
                ++this.pos;
                this.previousSegment();
                c = this.seq.charAt(--this.pos);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.start) {
                c = this.seq.charAt(--this.pos);
                break;
            }
            this.switchToBackward();
        }
        if (Character.isLowSurrogate(c) && this.pos != this.start && Character.isHighSurrogate(lead = this.seq.charAt(this.pos - 1))) {
            --this.pos;
            return Character.toCodePoint(lead, c);
        }
        return c;
    }

    private final long $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$handleNextCE32() {
        char c;
        while (true) {
            if (this.checkDir > 0) {
                if (this.pos == this.limit) {
                    return -4294967104L;
                }
                if (!CollationFCD.hasTccc(c = this.seq.charAt(this.pos++)) || !CollationFCD.maybeTibetanCompositeVowel(c) && (this.pos == this.limit || !CollationFCD.hasLccc(this.seq.charAt(this.pos)))) break;
                --this.pos;
                this.nextSegment();
                c = this.seq.charAt(this.pos++);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.limit) {
                c = this.seq.charAt(this.pos++);
                break;
            }
            this.switchToForward();
        }
        return this.makeCodePointAndCE32Pair(c, this.trie.getFromU16SingleLead(c));
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$forwardNumCodePoints(int num) {
        while (num > 0 && this.nextCodePoint() >= 0) {
            --num;
        }
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$backwardNumCodePoints(int num) {
        while (num > 0 && this.previousCodePoint() >= 0) {
            --num;
        }
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$switchToForward() {
        if (!($assertionsDisabled || this.checkDir < 0 && this.seq == this.rawSeq || this.checkDir == 0 && this.pos == this.limit)) {
            throw new AssertionError();
        }
        if (this.checkDir < 0) {
            this.start = this.segmentStart = this.pos;
            if (this.pos == this.segmentLimit) {
                this.limit = this.rawLimit;
                this.checkDir = 1;
            } else {
                this.checkDir = 0;
            }
        } else {
            if (this.seq != this.rawSeq) {
                this.seq = this.rawSeq;
                this.start = this.segmentStart = this.segmentLimit;
                this.pos = this.segmentStart;
            }
            this.limit = this.rawLimit;
            this.checkDir = 1;
        }
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$nextSegment() {
        block6: {
            if (!($assertionsDisabled || this.checkDir > 0 && this.seq == this.rawSeq && this.pos != this.limit)) {
                throw new AssertionError();
            }
            int p = this.pos;
            int prevCC = 0;
            do {
                int q = p;
                int c = Character.codePointAt(this.seq, p);
                p += Character.charCount(c);
                int fcd16 = this.nfcImpl.getFCD16(c);
                int leadCC = fcd16 >> 8;
                if (leadCC == 0 && q != this.pos) {
                    this.limit = this.segmentLimit = q;
                    break block6;
                }
                if (leadCC != 0 && (prevCC > leadCC || CollationFCD.isFCD16OfTibetanCompositeVowel(fcd16))) {
                    do {
                        q = p;
                        if (p == this.rawLimit) break;
                        c = Character.codePointAt(this.seq, p);
                        p += Character.charCount(c);
                    } while (this.nfcImpl.getFCD16(c) > 255);
                    this.normalize(this.pos, q);
                    this.pos = this.start;
                    break block6;
                }
                prevCC = fcd16 & 0xFF;
            } while (p != this.rawLimit && prevCC != 0);
            this.limit = this.segmentLimit = p;
        }
        if (!$assertionsDisabled && this.pos == this.limit) {
            throw new AssertionError();
        }
        this.checkDir = 0;
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$switchToBackward() {
        if (!($assertionsDisabled || this.checkDir > 0 && this.seq == this.rawSeq || this.checkDir == 0 && this.pos == this.start)) {
            throw new AssertionError();
        }
        if (this.checkDir > 0) {
            this.limit = this.segmentLimit = this.pos;
            if (this.pos == this.segmentStart) {
                this.start = 0;
                this.checkDir = -1;
            } else {
                this.checkDir = 0;
            }
        } else {
            if (this.seq != this.rawSeq) {
                this.seq = this.rawSeq;
                this.limit = this.segmentLimit = this.segmentStart;
                this.pos = this.segmentLimit;
            }
            this.start = 0;
            this.checkDir = -1;
        }
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$previousSegment() {
        block6: {
            if (!($assertionsDisabled || this.checkDir < 0 && this.seq == this.rawSeq && this.pos != this.start)) {
                throw new AssertionError();
            }
            int p = this.pos;
            int nextCC = 0;
            do {
                int q = p;
                int c = Character.codePointBefore(this.seq, p);
                p -= Character.charCount(c);
                int fcd16 = this.nfcImpl.getFCD16(c);
                int trailCC = fcd16 & 0xFF;
                if (trailCC == 0 && q != this.pos) {
                    this.start = this.segmentStart = q;
                    break block6;
                }
                if (trailCC != 0 && (nextCC != 0 && trailCC > nextCC || CollationFCD.isFCD16OfTibetanCompositeVowel(fcd16))) {
                    do {
                        q = p;
                        if (fcd16 <= 255 || p == 0) break;
                        c = Character.codePointBefore(this.seq, p);
                        p -= Character.charCount(c);
                    } while ((fcd16 = this.nfcImpl.getFCD16(c)) != 0);
                    this.normalize(q, this.pos);
                    this.pos = this.limit;
                    break block6;
                }
                nextCC = fcd16 >> 8;
            } while (p != 0 && nextCC != 0);
            this.start = this.segmentStart = p;
        }
        if (!$assertionsDisabled && this.pos == this.start) {
            throw new AssertionError();
        }
        this.checkDir = 0;
    }

    private final void $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$normalize(int from, int to) {
        if (this.normalized == null) {
            this.normalized = new StringBuilder();
        }
        this.nfcImpl.decompose(this.rawSeq, from, to, this.normalized, to - from);
        this.segmentStart = from;
        this.segmentLimit = to;
        this.seq = this.normalized;
        this.start = 0;
        this.limit = this.start + this.normalized.length();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !FCDUTF16CollationIterator.class.desiredAssertionStatus();
    }

    private void __constructor__(CollationData collationData) {
        this.$$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(collationData);
    }

    public FCDUTF16CollationIterator(CollationData collationData) {
        super(collationData);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(android.icu.impl.coll.CollationData ), 0, this, collationData);
    }

    private void __constructor__(CollationData collationData, boolean bl, CharSequence charSequence, int n) {
        this.$$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(collationData, bl, charSequence, n);
    }

    public FCDUTF16CollationIterator(CollationData collationData, boolean bl, CharSequence charSequence, int n) {
        super(collationData, bl, charSequence, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$__constructor__(android.icu.impl.coll.CollationData boolean java.lang.CharSequence int ), 0, this, collationData, bl, charSequence, n);
    }

    @Override
    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$hashCode(), 0, this);
    }

    @Override
    public void resetToOffset(int n) {
        InvokeDynamicSupport.bootstrap("resetToOffset", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$resetToOffset(int ), 0, this, n);
    }

    @Override
    public int getOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$getOffset(), 0, this);
    }

    @Override
    public void setText(boolean bl, CharSequence charSequence, int n) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$setText(boolean java.lang.CharSequence int ), 0, this, bl, charSequence, n);
    }

    @Override
    public int nextCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("nextCodePoint", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$nextCodePoint(), 0, this);
    }

    @Override
    public int previousCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("previousCodePoint", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$previousCodePoint(), 0, this);
    }

    @Override
    protected long handleNextCE32() {
        return (long)InvokeDynamicSupport.bootstrap("handleNextCE32", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$handleNextCE32(), 0, this);
    }

    @Override
    protected void forwardNumCodePoints(int n) {
        InvokeDynamicSupport.bootstrap("forwardNumCodePoints", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$forwardNumCodePoints(int ), 0, this, n);
    }

    @Override
    protected void backwardNumCodePoints(int n) {
        InvokeDynamicSupport.bootstrap("backwardNumCodePoints", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$backwardNumCodePoints(int ), 0, this, n);
    }

    private void switchToForward() {
        InvokeDynamicSupport.bootstrap("switchToForward", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$switchToForward(), 0, this);
    }

    private void nextSegment() {
        InvokeDynamicSupport.bootstrap("nextSegment", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$nextSegment(), 0, this);
    }

    private void switchToBackward() {
        InvokeDynamicSupport.bootstrap("switchToBackward", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$switchToBackward(), 0, this);
    }

    private void previousSegment() {
        InvokeDynamicSupport.bootstrap("previousSegment", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$previousSegment(), 0, this);
    }

    private void normalize(int n, int n2) {
        InvokeDynamicSupport.bootstrap("normalize", $$robo$$android_icu_impl_coll_FCDUTF16CollationIterator$normalize(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(FCDUTF16CollationIterator.class);
    }

    public /* synthetic */ FCDUTF16CollationIterator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FCDUTF16CollationIterator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

