/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.locale;

import android.icu.impl.ValidIdentifiers;
import android.icu.impl.locale.AsciiUtil;
import android.icu.impl.locale.KeyTypeData;
import android.icu.util.IllformedLocaleException;
import android.icu.util.Output;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleValidityChecker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Set<ValidIdentifiers.Datasubtype> datasubtypes;
    private boolean allowsDeprecated;
    static Pattern SEPARATOR;
    private static Pattern VALID_X;
    static Set<String> REORDERING_INCLUDE;
    static Set<String> REORDERING_EXCLUDE;
    static Set<ValidIdentifiers.Datasubtype> REGULAR_ONLY;

    private void $$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(Set<ValidIdentifiers.Datasubtype> datasubtypes) {
        this.datasubtypes = EnumSet.copyOf(datasubtypes);
        this.allowsDeprecated = datasubtypes.contains((Object)ValidIdentifiers.Datasubtype.deprecated);
    }

    private void $$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(ValidIdentifiers.Datasubtype ... datasubtypes) {
        this.datasubtypes = EnumSet.copyOf(Arrays.asList(datasubtypes));
        this.allowsDeprecated = this.datasubtypes.contains((Object)ValidIdentifiers.Datasubtype.deprecated);
    }

    private final Set<ValidIdentifiers.Datasubtype> $$robo$$android_icu_impl_locale_LocaleValidityChecker$getDatasubtypes() {
        return EnumSet.copyOf(this.datasubtypes);
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValid(ULocale locale, Where where) {
        where.set(null, null);
        String language = locale.getLanguage();
        String script = locale.getScript();
        String region = locale.getCountry();
        String variantString = locale.getVariant();
        Set<Character> extensionKeys = locale.getExtensionKeys();
        if (!this.isValid(ValidIdentifiers.Datatype.language, language, where)) {
            if (language.equals("x")) {
                where.set(null, null);
                return true;
            }
            return false;
        }
        if (!this.isValid(ValidIdentifiers.Datatype.script, script, where)) {
            return false;
        }
        if (!this.isValid(ValidIdentifiers.Datatype.region, region, where)) {
            return false;
        }
        if (!variantString.isEmpty()) {
            for (String variant : SEPARATOR.split(variantString)) {
                if (this.isValid(ValidIdentifiers.Datatype.variant, variant, where)) continue;
                return false;
            }
        }
        for (Character c : extensionKeys) {
            try {
                ValidIdentifiers.Datatype datatype = ValidIdentifiers.Datatype.valueOf(c + "");
                switch (1.$SwitchMap$android$icu$impl$ValidIdentifiers$Datatype[datatype.ordinal()]) {
                    case 1: {
                        return true;
                    }
                    case 2: 
                    case 3: {
                        if (this.isValidU(locale, datatype, locale.getExtension(c.charValue()), where)) break;
                        return false;
                    }
                }
            }
            catch (Exception e) {
                return where.set(ValidIdentifiers.Datatype.illegal, c + "");
            }
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValidU(ULocale locale, ValidIdentifiers.Datatype datatype, String extensionString, Where where) {
        String key = "";
        int typeCount = 0;
        Enum valueType = null;
        Enum specialCase = null;
        StringBuilder prefix = new StringBuilder();
        HashSet<String> seen = new HashSet<String>();
        StringBuilder tBuffer = datatype == ValidIdentifiers.Datatype.t ? new StringBuilder() : null;
        block14: for (String subtag : SEPARATOR.split(extensionString)) {
            if (subtag.length() == 2 && (tBuffer == null || subtag.charAt(1) <= '9')) {
                if (tBuffer != null) {
                    if (tBuffer.length() != 0 && !this.isValidLocale(tBuffer.toString(), where)) {
                        return false;
                    }
                    tBuffer = null;
                }
                if ((key = KeyTypeData.toBcpKey(subtag)) == null) {
                    return where.set(datatype, subtag);
                }
                if (!this.allowsDeprecated && KeyTypeData.isDeprecated(key)) {
                    return where.set(datatype, key);
                }
                valueType = KeyTypeData.getValueType(key);
                specialCase = SpecialCase.get(key);
                typeCount = 0;
                continue;
            }
            if (tBuffer != null) {
                if (tBuffer.length() != 0) {
                    tBuffer.append('-');
                }
                tBuffer.append(subtag);
                continue;
            }
            ++typeCount;
            switch (1.$SwitchMap$android$icu$impl$locale$KeyTypeData$ValueType[valueType.ordinal()]) {
                case 1: {
                    if (typeCount <= 1) break;
                    return where.set(datatype, key + "-" + subtag);
                }
                case 2: {
                    if (typeCount == 1) {
                        prefix.setLength(0);
                        prefix.append(subtag);
                        break;
                    }
                    prefix.append('-').append(subtag);
                    subtag = prefix.toString();
                    break;
                }
                case 3: {
                    if (typeCount != 1) break;
                    seen.clear();
                    break;
                }
            }
            switch (1.$SwitchMap$android$icu$impl$locale$LocaleValidityChecker$SpecialCase[specialCase.ordinal()]) {
                case 1: {
                    continue block14;
                }
                case 2: {
                    try {
                        if (Integer.parseInt(subtag, 16) <= 0x10FFFF) continue block14;
                        return where.set(datatype, key + "-" + subtag);
                    }
                    catch (NumberFormatException e) {
                        return where.set(datatype, key + "-" + subtag);
                    }
                }
                case 3: {
                    boolean newlyAdded = seen.add(subtag.equals("zzzz") ? "others" : subtag);
                    if (newlyAdded && this.isScriptReorder(subtag)) continue block14;
                    return where.set(datatype, key + "-" + subtag);
                }
                case 4: {
                    if (this.isSubdivision(locale, subtag)) continue block14;
                    return where.set(datatype, key + "-" + subtag);
                }
                case 5: {
                    if (subtag.length() < 6 || !subtag.endsWith("zzzz")) {
                        return where.set(datatype, subtag);
                    }
                    if (this.isValid(ValidIdentifiers.Datatype.region, subtag.substring(0, subtag.length() - 4), where)) continue block14;
                    return false;
                }
                default: {
                    Output<Boolean> isKnownKey = new Output<Boolean>();
                    Output<Boolean> isSpecialType = new Output<Boolean>();
                    String type = KeyTypeData.toBcpType(key, subtag, isKnownKey, isSpecialType);
                    if (type == null) {
                        return where.set(datatype, key + "-" + subtag);
                    }
                    if (this.allowsDeprecated || !KeyTypeData.isDeprecated(key, subtag)) continue block14;
                    return where.set(datatype, key + "-" + subtag);
                }
            }
        }
        return tBuffer == null || tBuffer.length() == 0 || this.isValidLocale(tBuffer.toString(), where);
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isSubdivision(ULocale locale, String subtag) {
        String subdivision;
        if (subtag.length() < 3) {
            return false;
        }
        String region = subtag.substring(0, subtag.charAt(0) <= '9' ? 3 : 2);
        if (ValidIdentifiers.isValid(ValidIdentifiers.Datatype.subdivision, this.datasubtypes, region, subdivision = subtag.substring(region.length())) == null) {
            return false;
        }
        String localeRegion = locale.getCountry();
        if (localeRegion.isEmpty()) {
            ULocale max = ULocale.addLikelySubtags(locale);
            localeRegion = max.getCountry();
        }
        return region.equalsIgnoreCase(localeRegion);
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isScriptReorder(String subtag) {
        if (REORDERING_INCLUDE.contains(subtag = AsciiUtil.toLowerString(subtag))) {
            return true;
        }
        if (REORDERING_EXCLUDE.contains(subtag)) {
            return false;
        }
        return ValidIdentifiers.isValid(ValidIdentifiers.Datatype.script, REGULAR_ONLY, subtag) != null;
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValidLocale(String extensionString, Where where) {
        try {
            ULocale locale = new ULocale.Builder().setLanguageTag(extensionString).build();
            return this.isValid(locale, where);
        }
        catch (IllformedLocaleException e) {
            int startIndex = e.getErrorIndex();
            String[] list = SEPARATOR.split(extensionString.substring(startIndex));
            return where.set(ValidIdentifiers.Datatype.t, list[0]);
        }
        catch (Exception e) {
            return where.set(ValidIdentifiers.Datatype.t, e.getMessage());
        }
    }

    private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValid(ValidIdentifiers.Datatype datatype, String code, Where where) {
        if (code.isEmpty()) {
            return true;
        }
        if (datatype == ValidIdentifiers.Datatype.variant && "posix".equalsIgnoreCase(code)) {
            return true;
        }
        return ValidIdentifiers.isValid(datatype, this.datasubtypes, code) != null ? true : (where == null ? false : where.set(datatype, code));
    }

    static void __staticInitializer__() {
        SEPARATOR = Pattern.compile("[-_]");
        VALID_X = Pattern.compile("[a-zA-Z0-9]{2,8}(-[a-zA-Z0-9]{2,8})*");
        REORDERING_INCLUDE = new HashSet<String>(Arrays.asList("space", "punct", "symbol", "currency", "digit", "others", "zzzz"));
        REORDERING_EXCLUDE = new HashSet<String>(Arrays.asList("zinh", "zyyy"));
        REGULAR_ONLY = EnumSet.of(ValidIdentifiers.Datasubtype.regular);
    }

    private void __constructor__(Set<ValidIdentifiers.Datasubtype> set) {
        this.$$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(set);
    }

    public LocaleValidityChecker(Set<ValidIdentifiers.Datasubtype> set) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(java.util.Set<android.icu.impl.ValidIdentifiers$Datasubtype> ), 0, this, set);
    }

    private void __constructor__(ValidIdentifiers.Datasubtype ... datasubtypeArray) {
        this.$$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(datasubtypeArray);
    }

    public LocaleValidityChecker(ValidIdentifiers.Datasubtype ... datasubtypeArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleValidityChecker$__constructor__(android.icu.impl.ValidIdentifiers$Datasubtype[] ), 0, this, datasubtypeArray);
    }

    public Set<ValidIdentifiers.Datasubtype> getDatasubtypes() {
        return InvokeDynamicSupport.bootstrap("getDatasubtypes", $$robo$$android_icu_impl_locale_LocaleValidityChecker$getDatasubtypes(), 0, this);
    }

    public boolean isValid(ULocale uLocale, Where where) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValid(android.icu.util.ULocale android.icu.impl.locale.LocaleValidityChecker$Where ), 0, this, uLocale, where);
    }

    private boolean isValidU(ULocale uLocale, ValidIdentifiers.Datatype datatype, String string2, Where where) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidU", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValidU(android.icu.util.ULocale android.icu.impl.ValidIdentifiers$Datatype java.lang.String android.icu.impl.locale.LocaleValidityChecker$Where ), 0, this, uLocale, datatype, string2, where);
    }

    private boolean isSubdivision(ULocale uLocale, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSubdivision", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isSubdivision(android.icu.util.ULocale java.lang.String ), 0, this, uLocale, string2);
    }

    private boolean isScriptReorder(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isScriptReorder", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isScriptReorder(java.lang.String ), 0, this, string2);
    }

    private boolean isValidLocale(String string2, Where where) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidLocale", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValidLocale(java.lang.String android.icu.impl.locale.LocaleValidityChecker$Where ), 0, this, string2, where);
    }

    private boolean isValid(ValidIdentifiers.Datatype datatype, String string2, Where where) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_icu_impl_locale_LocaleValidityChecker$isValid(android.icu.impl.ValidIdentifiers$Datatype java.lang.String android.icu.impl.locale.LocaleValidityChecker$Where ), 0, this, datatype, string2, where);
    }

    static {
        RobolectricInternals.classInitializing(LocaleValidityChecker.class);
    }

    public /* synthetic */ LocaleValidityChecker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleValidityChecker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SpecialCase
    extends Enum<SpecialCase> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ SpecialCase normal;
        public static /* enum */ SpecialCase anything;
        public static /* enum */ SpecialCase reorder;
        public static /* enum */ SpecialCase codepoints;
        public static /* enum */ SpecialCase subdivision;
        public static /* enum */ SpecialCase rgKey;
        private static /* synthetic */ SpecialCase[] $VALUES;

        private static final SpecialCase[] $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$values() {
            return (SpecialCase[])$VALUES.clone();
        }

        private static final SpecialCase $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$valueOf(String name) {
            return Enum.valueOf(SpecialCase.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$__constructor__(String string2, int n) {
        }

        private static final SpecialCase $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$get(String key) {
            if (key.equals("kr")) {
                return reorder;
            }
            if (key.equals("vt")) {
                return codepoints;
            }
            if (key.equals("sd")) {
                return subdivision;
            }
            if (key.equals("rg")) {
                return rgKey;
            }
            if (key.equals("x0")) {
                return anything;
            }
            return normal;
        }

        static void __staticInitializer__() {
            normal = new SpecialCase();
            anything = new SpecialCase();
            reorder = new SpecialCase();
            codepoints = new SpecialCase();
            subdivision = new SpecialCase();
            rgKey = new SpecialCase();
            $VALUES = new SpecialCase[]{normal, anything, reorder, codepoints, subdivision, rgKey};
        }

        public static SpecialCase[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$values(), 0);
        }

        public static SpecialCase valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$__constructor__(string2, n);
        }

        private SpecialCase() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static SpecialCase get(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_icu_impl_locale_LocaleValidityChecker_SpecialCase$get(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(SpecialCase.class);
        }

        public /* synthetic */ SpecialCase() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpecialCase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Where
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ValidIdentifiers.Datatype fieldFailure;
        public String codeFailure;

        private void $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$set(ValidIdentifiers.Datatype datatype, String code) {
            this.fieldFailure = datatype;
            this.codeFailure = code;
            return false;
        }

        private final String $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$toString() {
            return this.fieldFailure == null ? "OK" : "{" + (Object)((Object)this.fieldFailure) + ", " + this.codeFailure + "}";
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$__constructor__();
        }

        public Where() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$__constructor__(), 0, this);
        }

        public boolean set(ValidIdentifiers.Datatype datatype, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$set(android.icu.impl.ValidIdentifiers$Datatype java.lang.String ), 0, this, datatype, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_locale_LocaleValidityChecker_Where$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Where)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

