/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.DecimalQuantity_AbstractBCD;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DecimalQuantity_DualStorageBCD
extends DecimalQuantity_AbstractBCD
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private byte[] bcdBytes;
    private long bcdLong;
    private boolean usingBytes;
    static /* synthetic */ boolean $assertionsDisabled;

    private final int $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$maxRepresentableDigits() {
        return Integer.MAX_VALUE;
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__() {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setBcdToZero();
        this.flags = 0;
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(long input) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setToLong(input);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(int input) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setToInt(input);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(double input) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setToDouble(input);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(BigInteger input) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setToBigInteger(input);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(BigDecimal input) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.setToBigDecimal(input);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(DecimalQuantity_DualStorageBCD other) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        this.copyFrom(other);
    }

    private void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(Number number) {
        this.bcdLong = 0L;
        this.usingBytes = false;
        if (number instanceof Long) {
            this.setToLong(number.longValue());
        } else if (number instanceof Integer) {
            this.setToInt(number.intValue());
        } else if (number instanceof Double) {
            this.setToDouble(number.doubleValue());
        } else if (number instanceof BigInteger) {
            this.setToBigInteger((BigInteger)number);
        } else if (number instanceof BigDecimal) {
            this.setToBigDecimal((BigDecimal)number);
        } else if (number instanceof android.icu.math.BigDecimal) {
            this.setToBigDecimal(((android.icu.math.BigDecimal)number).toBigDecimal());
        } else {
            throw new IllegalArgumentException("Number is of an unsupported type: " + number.getClass().getName());
        }
    }

    private final DecimalQuantity $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$createCopy() {
        return new DecimalQuantity_DualStorageBCD(this);
    }

    private final byte $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$getDigitPos(int position) {
        if (this.usingBytes) {
            if (position < 0 || position > this.precision) {
                return 0;
            }
            return this.bcdBytes[position];
        }
        if (position < 0 || position >= 16) {
            return 0;
        }
        return (byte)(this.bcdLong >>> position * 4 & 0xFL);
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$setDigitPos(int position, byte value) {
        if (!$assertionsDisabled && position < 0) {
            throw new AssertionError();
        }
        if (this.usingBytes) {
            this.ensureCapacity(position + 1);
            this.bcdBytes[position] = value;
        } else if (position >= 16) {
            this.switchStorage();
            this.ensureCapacity(position + 1);
            this.bcdBytes[position] = value;
        } else {
            int shift = position * 4;
            this.bcdLong = this.bcdLong & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << shift;
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$shiftLeft(int numDigits) {
        if (!this.usingBytes && this.precision + numDigits > 16) {
            this.switchStorage();
        }
        if (this.usingBytes) {
            int i;
            this.ensureCapacity(this.precision + numDigits);
            for (i = this.precision + numDigits - 1; i >= numDigits; --i) {
                this.bcdBytes[i] = this.bcdBytes[i - numDigits];
            }
            while (i >= 0) {
                this.bcdBytes[i] = 0;
                --i;
            }
        } else {
            this.bcdLong <<= numDigits * 4;
        }
        this.scale -= numDigits;
        this.precision += numDigits;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$shiftRight(int numDigits) {
        if (this.usingBytes) {
            int i;
            for (i = 0; i < this.precision - numDigits; ++i) {
                this.bcdBytes[i] = this.bcdBytes[i + numDigits];
            }
            while (i < this.precision) {
                this.bcdBytes[i] = 0;
                ++i;
            }
        } else {
            this.bcdLong >>>= numDigits * 4;
        }
        this.scale += numDigits;
        this.precision -= numDigits;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$setBcdToZero() {
        if (this.usingBytes) {
            this.bcdBytes = null;
            this.usingBytes = false;
        }
        this.bcdLong = 0L;
        this.scale = 0;
        this.precision = 0;
        this.isApproximate = false;
        this.origDouble = 0.0;
        this.origDelta = 0;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readIntToBcd(int n) {
        if (!$assertionsDisabled && n == 0) {
            throw new AssertionError();
        }
        long result = 0L;
        int i = 16;
        while (n != 0) {
            result = (result >>> 4) + ((long)n % 10L << 60);
            n /= 10;
            --i;
        }
        if (!$assertionsDisabled && this.usingBytes) {
            throw new AssertionError();
        }
        this.bcdLong = result >>> i * 4;
        this.scale = 0;
        this.precision = 16 - i;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readLongToBcd(long n) {
        if (!$assertionsDisabled && n == 0L) {
            throw new AssertionError();
        }
        if (n >= 10000000000000000L) {
            this.ensureCapacity();
            int i = 0;
            while (n != 0L) {
                this.bcdBytes[i] = (byte)(n % 10L);
                n /= 10L;
                ++i;
            }
            if (!$assertionsDisabled && !this.usingBytes) {
                throw new AssertionError();
            }
            this.scale = 0;
            this.precision = i;
        } else {
            long result = 0L;
            int i = 16;
            while (n != 0L) {
                result = (result >>> 4) + (n % 10L << 60);
                n /= 10L;
                --i;
            }
            if (!$assertionsDisabled && i < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.usingBytes) {
                throw new AssertionError();
            }
            this.bcdLong = result >>> i * 4;
            this.scale = 0;
            this.precision = 16 - i;
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readBigIntegerToBcd(BigInteger n) {
        if (!$assertionsDisabled && n.signum() == 0) {
            throw new AssertionError();
        }
        this.ensureCapacity();
        int i = 0;
        while (n.signum() != 0) {
            BigInteger[] temp = n.divideAndRemainder(BigInteger.TEN);
            this.ensureCapacity(i + 1);
            this.bcdBytes[i] = temp[1].byteValue();
            n = temp[0];
            ++i;
        }
        this.scale = 0;
        this.precision = i;
    }

    private final BigDecimal $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$bcdToBigDecimal() {
        if (this.usingBytes) {
            BigDecimal result = new BigDecimal(this.toNumberString());
            if (this.isNegative()) {
                result = result.negate();
            }
            return result;
        }
        long tempLong = 0L;
        for (int shift = this.precision - 1; shift >= 0; --shift) {
            tempLong = tempLong * 10L + (long)this.getDigitPos(shift);
        }
        BigDecimal result = BigDecimal.valueOf(tempLong);
        result = result.scaleByPowerOfTen(this.scale);
        if (this.isNegative()) {
            result = result.negate();
        }
        return result;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$compact() {
        if (this.usingBytes) {
            int leading;
            int delta;
            for (delta = 0; delta < this.precision && this.bcdBytes[delta] == 0; ++delta) {
            }
            if (delta == this.precision) {
                this.setBcdToZero();
                return;
            }
            this.shiftRight(delta);
            for (leading = this.precision - 1; leading >= 0 && this.bcdBytes[leading] == 0; --leading) {
            }
            this.precision = leading + 1;
            if (this.precision <= 16) {
                this.switchStorage();
            }
        } else {
            if (this.bcdLong == 0L) {
                this.setBcdToZero();
                return;
            }
            int delta = Long.numberOfTrailingZeros(this.bcdLong) / 4;
            this.bcdLong >>>= delta * 4;
            this.scale += delta;
            this.precision = 16 - Long.numberOfLeadingZeros(this.bcdLong) / 4;
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$ensureCapacity() {
        this.ensureCapacity(40);
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$ensureCapacity(int capacity) {
        int oldCapacity;
        if (capacity == 0) {
            return;
        }
        int n = oldCapacity = this.usingBytes ? this.bcdBytes.length : 0;
        if (!this.usingBytes) {
            this.bcdBytes = new byte[capacity];
        } else if (oldCapacity < capacity) {
            byte[] bcd1 = new byte[capacity * 2];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.bcdBytes, (int)0, (byte[])bcd1, (int)0, (int)oldCapacity);
            this.bcdBytes = bcd1;
        }
        this.usingBytes = true;
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$switchStorage() {
        if (this.usingBytes) {
            this.bcdLong = 0L;
            for (int i = this.precision - 1; i >= 0; --i) {
                this.bcdLong <<= 4;
                this.bcdLong |= (long)this.bcdBytes[i];
            }
            this.bcdBytes = null;
            this.usingBytes = false;
        } else {
            this.ensureCapacity();
            for (int i = 0; i < this.precision; ++i) {
                this.bcdBytes[i] = (byte)(this.bcdLong & 0xFL);
                this.bcdLong >>>= 4;
            }
            if (!$assertionsDisabled && !this.usingBytes) {
                throw new AssertionError();
            }
        }
    }

    private final void $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$copyBcdFrom(DecimalQuantity _other) {
        DecimalQuantity_DualStorageBCD other = (DecimalQuantity_DualStorageBCD)_other;
        this.setBcdToZero();
        if (other.usingBytes) {
            this.ensureCapacity(other.precision);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])other.bcdBytes, (int)0, (byte[])this.bcdBytes, (int)0, (int)other.precision);
        } else {
            this.bcdLong = other.bcdLong;
        }
    }

    @Deprecated
    private final String $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$checkHealth() {
        if (this.usingBytes) {
            int i;
            if (this.bcdLong != 0L) {
                return "Value in bcdLong but we are in byte mode";
            }
            if (this.precision == 0) {
                return "Zero precision but we are in byte mode";
            }
            if (this.precision > this.bcdBytes.length) {
                return "Precision exceeds length of byte array";
            }
            if (this.getDigitPos(this.precision - 1) == 0) {
                return "Most significant digit is zero in byte mode";
            }
            if (this.getDigitPos(0) == 0) {
                return "Least significant digit is zero in long mode";
            }
            for (i = 0; i < this.precision; ++i) {
                if (this.getDigitPos(i) >= 10) {
                    return "Digit exceeding 10 in byte array";
                }
                if (this.getDigitPos(i) >= 0) continue;
                return "Digit below 0 in byte array";
            }
            for (i = this.precision; i < this.bcdBytes.length; ++i) {
                if (this.getDigitPos(i) == 0) continue;
                return "Nonzero digits outside of range in byte array";
            }
        } else {
            int i;
            if (this.bcdBytes != null) {
                for (i = 0; i < this.bcdBytes.length; ++i) {
                    if (this.bcdBytes[i] == 0) continue;
                    return "Nonzero digits in byte array but we are in long mode";
                }
            }
            if (this.precision == 0 && this.bcdLong != 0L) {
                return "Value in bcdLong even though precision is zero";
            }
            if (this.precision > 16) {
                return "Precision exceeds length of long";
            }
            if (this.precision != 0 && this.getDigitPos(this.precision - 1) == 0) {
                return "Most significant digit is zero in long mode";
            }
            if (this.precision != 0 && this.getDigitPos(0) == 0) {
                return "Least significant digit is zero in long mode";
            }
            for (i = 0; i < this.precision; ++i) {
                if (this.getDigitPos(i) >= 10) {
                    return "Digit exceeding 10 in long";
                }
                if (this.getDigitPos(i) >= 0) continue;
                return "Digit below 0 in long (?!)";
            }
            for (i = this.precision; i < 16; ++i) {
                if (this.getDigitPos(i) == 0) continue;
                return "Nonzero digits outside of range in long";
            }
        }
        return null;
    }

    @Deprecated
    private final boolean $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$isUsingBytes() {
        return this.usingBytes;
    }

    private final String $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$toString() {
        return String.format("<DecimalQuantity %s:%d:%d:%s %s %s>", this.lOptPos > 1000 ? "999" : String.valueOf(this.lOptPos), this.lReqPos, this.rReqPos, this.rOptPos < -1000 ? "-999" : String.valueOf(this.rOptPos), this.usingBytes ? "bytes" : "long", this.toNumberString());
    }

    private final String $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$toNumberString() {
        StringBuilder sb = new StringBuilder();
        if (this.usingBytes) {
            for (int i = this.precision - 1; i >= 0; --i) {
                sb.append(this.bcdBytes[i]);
            }
        } else {
            sb.append(Long.toHexString(this.bcdLong));
        }
        sb.append("E");
        sb.append(this.scale);
        return sb.toString();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !DecimalQuantity_DualStorageBCD.class.desiredAssertionStatus();
    }

    @Override
    public int maxRepresentableDigits() {
        return (int)InvokeDynamicSupport.bootstrap("maxRepresentableDigits", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$maxRepresentableDigits(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__();
    }

    public DecimalQuantity_DualStorageBCD() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(), 0, this);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(l);
    }

    public DecimalQuantity_DualStorageBCD(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(long ), 0, this, l);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(n);
    }

    public DecimalQuantity_DualStorageBCD(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(double d) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(d);
    }

    public DecimalQuantity_DualStorageBCD(double d) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(double ), 0, this, d);
    }

    private void __constructor__(BigInteger bigInteger) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(bigInteger);
    }

    public DecimalQuantity_DualStorageBCD(BigInteger bigInteger) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(java.math.BigInteger ), 0, this, bigInteger);
    }

    private void __constructor__(BigDecimal bigDecimal) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(bigDecimal);
    }

    public DecimalQuantity_DualStorageBCD(BigDecimal bigDecimal) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(java.math.BigDecimal ), 0, this, bigDecimal);
    }

    private void __constructor__(DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(decimalQuantity_DualStorageBCD);
    }

    public DecimalQuantity_DualStorageBCD(DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(android.icu.impl.number.DecimalQuantity_DualStorageBCD ), 0, this, decimalQuantity_DualStorageBCD);
    }

    private void __constructor__(Number number) {
        this.$$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(number);
    }

    public DecimalQuantity_DualStorageBCD(Number number) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$__constructor__(java.lang.Number ), 0, this, number);
    }

    @Override
    public DecimalQuantity createCopy() {
        return InvokeDynamicSupport.bootstrap("createCopy", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$createCopy(), 0, this);
    }

    @Override
    protected byte getDigitPos(int n) {
        return (byte)InvokeDynamicSupport.bootstrap("getDigitPos", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$getDigitPos(int ), 0, this, n);
    }

    @Override
    protected void setDigitPos(int n, byte by) {
        InvokeDynamicSupport.bootstrap("setDigitPos", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$setDigitPos(int byte ), 0, this, n, by);
    }

    @Override
    protected void shiftLeft(int n) {
        InvokeDynamicSupport.bootstrap("shiftLeft", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$shiftLeft(int ), 0, this, n);
    }

    @Override
    protected void shiftRight(int n) {
        InvokeDynamicSupport.bootstrap("shiftRight", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$shiftRight(int ), 0, this, n);
    }

    @Override
    protected void setBcdToZero() {
        InvokeDynamicSupport.bootstrap("setBcdToZero", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$setBcdToZero(), 0, this);
    }

    @Override
    protected void readIntToBcd(int n) {
        InvokeDynamicSupport.bootstrap("readIntToBcd", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readIntToBcd(int ), 0, this, n);
    }

    @Override
    protected void readLongToBcd(long l) {
        InvokeDynamicSupport.bootstrap("readLongToBcd", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readLongToBcd(long ), 0, this, l);
    }

    @Override
    protected void readBigIntegerToBcd(BigInteger bigInteger) {
        InvokeDynamicSupport.bootstrap("readBigIntegerToBcd", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$readBigIntegerToBcd(java.math.BigInteger ), 0, this, bigInteger);
    }

    @Override
    protected BigDecimal bcdToBigDecimal() {
        return InvokeDynamicSupport.bootstrap("bcdToBigDecimal", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$bcdToBigDecimal(), 0, this);
    }

    @Override
    protected void compact() {
        InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$compact(), 0, this);
    }

    private void ensureCapacity() {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$ensureCapacity(), 0, this);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$ensureCapacity(int ), 0, this, n);
    }

    private void switchStorage() {
        InvokeDynamicSupport.bootstrap("switchStorage", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$switchStorage(), 0, this);
    }

    @Override
    protected void copyBcdFrom(DecimalQuantity decimalQuantity) {
        InvokeDynamicSupport.bootstrap("copyBcdFrom", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$copyBcdFrom(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
    }

    @Deprecated
    public String checkHealth() {
        return InvokeDynamicSupport.bootstrap("checkHealth", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$checkHealth(), 0, this);
    }

    @Deprecated
    public boolean isUsingBytes() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsingBytes", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$isUsingBytes(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$toString(), 0, this);
    }

    public String toNumberString() {
        return InvokeDynamicSupport.bootstrap("toNumberString", $$robo$$android_icu_impl_number_DecimalQuantity_DualStorageBCD$toNumberString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DecimalQuantity_DualStorageBCD.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecimalQuantity_DualStorageBCD)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

