/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.CurrencyData;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleFormatterImpl;
import android.icu.impl.StandardPlural;
import android.icu.impl.UResource;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.SimpleModifier;
import android.icu.number.NumberFormatter;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.util.Currency;
import android.icu.util.ICUException;
import android.icu.util.MeasureUnit;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.EnumMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LongNameHandler
implements MicroPropsGenerator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Map<StandardPlural, SimpleModifier> modifiers;
    private PluralRules rules;
    private MicroPropsGenerator parent;

    private static final void $$robo$$android_icu_impl_number_LongNameHandler$getMeasureData(ULocale locale, MeasureUnit unit, NumberFormatter.UnitWidth width, Map<StandardPlural, String> output) {
        PluralTableSink sink = new PluralTableSink(output);
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/unit", locale);
        StringBuilder key = new StringBuilder();
        key.append("units");
        if (width == NumberFormatter.UnitWidth.NARROW) {
            key.append("Narrow");
        } else if (width == NumberFormatter.UnitWidth.SHORT) {
            key.append("Short");
        }
        key.append("/");
        key.append(unit.getType());
        key.append("/");
        key.append(unit.getSubtype());
        resource.getAllItemsWithFallback(key.toString(), sink);
    }

    private static final void $$robo$$android_icu_impl_number_LongNameHandler$getCurrencyLongNameData(ULocale locale, Currency currency, Map<StandardPlural, String> output) {
        Map<String, String> data = CurrencyData.provider.getInstance(locale, true).getUnitPatterns();
        for (Map.Entry<String, String> e : data.entrySet()) {
            String pluralKeyword = e.getKey();
            StandardPlural plural = StandardPlural.fromString(e.getKey());
            String longName = currency.getName(locale, 2, pluralKeyword, null);
            String simpleFormat = e.getValue();
            simpleFormat = simpleFormat.replace("{1}", longName);
            output.put(plural, simpleFormat);
        }
    }

    private void $$robo$$android_icu_impl_number_LongNameHandler$__constructor__(Map<StandardPlural, SimpleModifier> modifiers, PluralRules rules, MicroPropsGenerator parent) {
        this.modifiers = modifiers;
        this.rules = rules;
        this.parent = parent;
    }

    private static final LongNameHandler $$robo$$android_icu_impl_number_LongNameHandler$forCurrencyLongNames(ULocale locale, Currency currency, PluralRules rules, MicroPropsGenerator parent) {
        EnumMap<StandardPlural, String> simpleFormats = new EnumMap<StandardPlural, String>(StandardPlural.class);
        LongNameHandler.getCurrencyLongNameData(locale, currency, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    private static final LongNameHandler $$robo$$android_icu_impl_number_LongNameHandler$forMeasureUnit(ULocale locale, MeasureUnit unit, NumberFormatter.UnitWidth width, PluralRules rules, MicroPropsGenerator parent) {
        EnumMap<StandardPlural, String> simpleFormats = new EnumMap<StandardPlural, String>(StandardPlural.class);
        LongNameHandler.getMeasureData(locale, unit, width, simpleFormats);
        EnumMap<StandardPlural, SimpleModifier> modifiers = new EnumMap<StandardPlural, SimpleModifier>(StandardPlural.class);
        LongNameHandler.simpleFormatsToModifiers(simpleFormats, null, modifiers);
        return new LongNameHandler(modifiers, rules, parent);
    }

    private static final void $$robo$$android_icu_impl_number_LongNameHandler$simpleFormatsToModifiers(Map<StandardPlural, String> simpleFormats, NumberFormat.Field field, Map<StandardPlural, SimpleModifier> output) {
        StringBuilder sb = new StringBuilder();
        for (StandardPlural plural : StandardPlural.VALUES) {
            String simpleFormat = simpleFormats.get((Object)plural);
            if (simpleFormat == null) {
                simpleFormat = simpleFormats.get((Object)StandardPlural.OTHER);
            }
            if (simpleFormat == null) {
                throw new ICUException("Could not find data in 'other' plural variant with field " + field);
            }
            String compiled = SimpleFormatterImpl.compileToStringMinMaxArguments(simpleFormat, sb, 1, 1);
            output.put(plural, new SimpleModifier(compiled, null, false));
        }
    }

    private final MicroProps $$robo$$android_icu_impl_number_LongNameHandler$processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.parent.processQuantity(quantity);
        DecimalQuantity copy = quantity.createCopy();
        micros.rounding.apply(copy);
        micros.modOuter = this.modifiers.get((Object)copy.getStandardPlural(this.rules));
        return micros;
    }

    private static void getMeasureData(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, Map<StandardPlural, String> map) {
        InvokeDynamicSupport.bootstrapStatic("getMeasureData", $$robo$$android_icu_impl_number_LongNameHandler$getMeasureData(android.icu.util.ULocale android.icu.util.MeasureUnit android.icu.number.NumberFormatter$UnitWidth java.util.Map<android.icu.impl.StandardPlural, java.lang.String> ), 0, (ULocale)uLocale, (MeasureUnit)measureUnit, (NumberFormatter.UnitWidth)unitWidth, map);
    }

    private static void getCurrencyLongNameData(ULocale uLocale, Currency currency, Map<StandardPlural, String> map) {
        InvokeDynamicSupport.bootstrapStatic("getCurrencyLongNameData", $$robo$$android_icu_impl_number_LongNameHandler$getCurrencyLongNameData(android.icu.util.ULocale android.icu.util.Currency java.util.Map<android.icu.impl.StandardPlural, java.lang.String> ), 0, (ULocale)uLocale, (Currency)currency, map);
    }

    private void __constructor__(Map<StandardPlural, SimpleModifier> map, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        this.$$robo$$android_icu_impl_number_LongNameHandler$__constructor__(map, pluralRules, microPropsGenerator);
    }

    private LongNameHandler(Map<StandardPlural, SimpleModifier> map, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_LongNameHandler$__constructor__(java.util.Map<android.icu.impl.StandardPlural, android.icu.impl.number.SimpleModifier> android.icu.text.PluralRules android.icu.impl.number.MicroPropsGenerator ), 0, this, map, pluralRules, microPropsGenerator);
    }

    public static LongNameHandler forCurrencyLongNames(ULocale uLocale, Currency currency, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        return InvokeDynamicSupport.bootstrapStatic("forCurrencyLongNames", $$robo$$android_icu_impl_number_LongNameHandler$forCurrencyLongNames(android.icu.util.ULocale android.icu.util.Currency android.icu.text.PluralRules android.icu.impl.number.MicroPropsGenerator ), 0, (ULocale)uLocale, (Currency)currency, (PluralRules)pluralRules, (MicroPropsGenerator)microPropsGenerator);
    }

    public static LongNameHandler forMeasureUnit(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        return InvokeDynamicSupport.bootstrapStatic("forMeasureUnit", $$robo$$android_icu_impl_number_LongNameHandler$forMeasureUnit(android.icu.util.ULocale android.icu.util.MeasureUnit android.icu.number.NumberFormatter$UnitWidth android.icu.text.PluralRules android.icu.impl.number.MicroPropsGenerator ), 0, (ULocale)uLocale, (MeasureUnit)measureUnit, (NumberFormatter.UnitWidth)unitWidth, (PluralRules)pluralRules, (MicroPropsGenerator)microPropsGenerator);
    }

    private static void simpleFormatsToModifiers(Map<StandardPlural, String> map, NumberFormat.Field field, Map<StandardPlural, SimpleModifier> map2) {
        InvokeDynamicSupport.bootstrapStatic("simpleFormatsToModifiers", $$robo$$android_icu_impl_number_LongNameHandler$simpleFormatsToModifiers(java.util.Map<android.icu.impl.StandardPlural, java.lang.String> android.icu.text.NumberFormat$Field java.util.Map<android.icu.impl.StandardPlural, android.icu.impl.number.SimpleModifier> ), 0, map, (NumberFormat.Field)field, map2);
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        return InvokeDynamicSupport.bootstrap("processQuantity", $$robo$$android_icu_impl_number_LongNameHandler$processQuantity(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
    }

    public /* synthetic */ LongNameHandler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongNameHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class PluralTableSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Map<StandardPlural, String> output;

        private void $$robo$$android_icu_impl_number_LongNameHandler_PluralTableSink$__constructor__(Map<StandardPlural, String> output) {
            this.output = output;
        }

        private final void $$robo$$android_icu_impl_number_LongNameHandler_PluralTableSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table pluralsTable = value.getTable();
            int i = 0;
            while (pluralsTable.getKeyAndValue(i, key, value)) {
                StandardPlural plural;
                if (!(key.contentEquals("dnam") || key.contentEquals("per") || this.output.containsKey((Object)(plural = StandardPlural.fromString(key))))) {
                    String formatString = value.getString();
                    this.output.put(plural, formatString);
                }
                ++i;
            }
        }

        private void __constructor__(Map<StandardPlural, String> map) {
            this.$$robo$$android_icu_impl_number_LongNameHandler_PluralTableSink$__constructor__(map);
        }

        public PluralTableSink(Map<StandardPlural, String> map) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_LongNameHandler_PluralTableSink$__constructor__(java.util.Map<android.icu.impl.StandardPlural, java.lang.String> ), 0, this, map);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_number_LongNameHandler_PluralTableSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        public /* synthetic */ PluralTableSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralTableSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

