/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.StandardPlural;
import android.icu.impl.number.AffixPatternProvider;
import android.icu.impl.number.AffixUtils;
import android.icu.impl.number.ConstantMultiFieldModifier;
import android.icu.impl.number.CurrencySpacingEnabledModifier;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.Modifier;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.ParameterizedModifier;
import android.icu.number.NumberFormatter;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.PluralRules;
import android.icu.util.Currency;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MutablePatternModifier
implements Modifier,
AffixUtils.SymbolProvider,
CharSequence,
MicroPropsGenerator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    boolean isStrong;
    AffixPatternProvider patternInfo;
    NumberFormatter.SignDisplay signDisplay;
    boolean perMilleReplacesPercent;
    DecimalFormatSymbols symbols;
    NumberFormatter.UnitWidth unitWidth;
    Currency currency;
    PluralRules rules;
    boolean isNegative;
    StandardPlural plural;
    MicroPropsGenerator parent;
    boolean inCharSequenceMode;
    int flags;
    int length;
    boolean prependSign;
    boolean plusReplacesMinusSign;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_MutablePatternModifier$__constructor__(boolean isStrong) {
        this.isStrong = isStrong;
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$setPatternInfo(AffixPatternProvider patternInfo) {
        this.patternInfo = patternInfo;
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$setPatternAttributes(NumberFormatter.SignDisplay signDisplay, boolean perMille) {
        this.signDisplay = signDisplay;
        this.perMilleReplacesPercent = perMille;
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$setSymbols(DecimalFormatSymbols symbols, Currency currency, NumberFormatter.UnitWidth unitWidth, PluralRules rules) {
        if (!$assertionsDisabled && rules != null != this.needsPlurals()) {
            throw new AssertionError();
        }
        this.symbols = symbols;
        this.currency = currency;
        this.unitWidth = unitWidth;
        this.rules = rules;
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$setNumberProperties(boolean isNegative, StandardPlural plural) {
        if (!$assertionsDisabled && plural != null != this.needsPlurals()) {
            throw new AssertionError();
        }
        this.isNegative = isNegative;
        this.plural = plural;
    }

    private final boolean $$robo$$android_icu_impl_number_MutablePatternModifier$needsPlurals() {
        return this.patternInfo.containsSymbolType(-7);
    }

    private final ImmutablePatternModifier $$robo$$android_icu_impl_number_MutablePatternModifier$createImmutable() {
        return this.createImmutableAndChain(null);
    }

    private final ImmutablePatternModifier $$robo$$android_icu_impl_number_MutablePatternModifier$createImmutableAndChain(MicroPropsGenerator parent) {
        NumberStringBuilder a = new NumberStringBuilder();
        NumberStringBuilder b = new NumberStringBuilder();
        if (this.needsPlurals()) {
            ParameterizedModifier pm = new ParameterizedModifier();
            for (StandardPlural plural : StandardPlural.VALUES) {
                this.setNumberProperties(false, plural);
                pm.setModifier(false, plural, this.createConstantModifier(a, b));
                this.setNumberProperties(true, plural);
                pm.setModifier(true, plural, this.createConstantModifier(a, b));
            }
            pm.freeze();
            return new ImmutablePatternModifier(pm, this.rules, parent);
        }
        this.setNumberProperties(false, null);
        ConstantMultiFieldModifier positive = this.createConstantModifier(a, b);
        this.setNumberProperties(true, null);
        ConstantMultiFieldModifier negative = this.createConstantModifier(a, b);
        ParameterizedModifier pm = new ParameterizedModifier(positive, negative);
        return new ImmutablePatternModifier(pm, null, parent);
    }

    private final ConstantMultiFieldModifier $$robo$$android_icu_impl_number_MutablePatternModifier$createConstantModifier(NumberStringBuilder a, NumberStringBuilder b) {
        this.insertPrefix(a.clear(), 0);
        this.insertSuffix(b.clear(), 0);
        if (this.patternInfo.hasCurrencySign()) {
            return new CurrencySpacingEnabledModifier(a, b, this.isStrong, this.symbols);
        }
        return new ConstantMultiFieldModifier(a, b, this.isStrong);
    }

    private final MicroPropsGenerator $$robo$$android_icu_impl_number_MutablePatternModifier$addToChain(MicroPropsGenerator parent) {
        this.parent = parent;
        return this;
    }

    private final MicroProps $$robo$$android_icu_impl_number_MutablePatternModifier$processQuantity(DecimalQuantity fq) {
        MicroProps micros = this.parent.processQuantity(fq);
        if (this.needsPlurals()) {
            DecimalQuantity copy = fq.createCopy();
            micros.rounding.apply(copy);
            this.setNumberProperties(fq.isNegative(), copy.getStandardPlural(this.rules));
        } else {
            this.setNumberProperties(fq.isNegative(), null);
        }
        micros.modMiddle = this;
        return micros;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
        int prefixLen = this.insertPrefix(output, leftIndex);
        int suffixLen = this.insertSuffix(output, rightIndex + prefixLen);
        CurrencySpacingEnabledModifier.applyCurrencySpacing(output, leftIndex, prefixLen, rightIndex + prefixLen, suffixLen, this.symbols);
        return prefixLen + suffixLen;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$getPrefixLength() {
        this.enterCharSequenceMode(true);
        int result = AffixUtils.unescapedCodePointCount(this, this);
        this.exitCharSequenceMode();
        return result;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$getCodePointCount() {
        this.enterCharSequenceMode(true);
        int result = AffixUtils.unescapedCodePointCount(this, this);
        this.exitCharSequenceMode();
        this.enterCharSequenceMode(false);
        this.exitCharSequenceMode();
        return result += AffixUtils.unescapedCodePointCount(this, this);
    }

    private final boolean $$robo$$android_icu_impl_number_MutablePatternModifier$isStrong() {
        return this.isStrong;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$insertPrefix(NumberStringBuilder sb, int position) {
        this.enterCharSequenceMode(true);
        int length = AffixUtils.unescape(this, sb, position, this);
        this.exitCharSequenceMode();
        return length;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$insertSuffix(NumberStringBuilder sb, int position) {
        this.enterCharSequenceMode(false);
        int length = AffixUtils.unescape(this, sb, position, this);
        this.exitCharSequenceMode();
        return length;
    }

    private final CharSequence $$robo$$android_icu_impl_number_MutablePatternModifier$getSymbol(int type) {
        switch (type) {
            case -1: {
                return this.symbols.getMinusSignString();
            }
            case -2: {
                return this.symbols.getPlusSignString();
            }
            case -3: {
                return this.symbols.getPercentString();
            }
            case -4: {
                return this.symbols.getPerMillString();
            }
            case -5: {
                if (this.unitWidth == NumberFormatter.UnitWidth.ISO_CODE) {
                    return this.currency.getCurrencyCode();
                }
                if (this.unitWidth == NumberFormatter.UnitWidth.HIDDEN) {
                    return "";
                }
                if (this.unitWidth == NumberFormatter.UnitWidth.NARROW) {
                    return this.currency.getName(this.symbols.getULocale(), 3, null);
                }
                return this.currency.getName(this.symbols.getULocale(), 0, null);
            }
            case -6: {
                return this.currency.getCurrencyCode();
            }
            case -7: {
                if (!$assertionsDisabled && this.plural == null) {
                    throw new AssertionError();
                }
                return this.currency.getName(this.symbols.getULocale(), 2, this.plural.getKeyword(), null);
            }
            case -8: {
                return "\ufffd";
            }
            case -9: {
                return this.currency.getName(this.symbols.getULocale(), 3, null);
            }
        }
        throw new AssertionError();
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$enterCharSequenceMode(boolean isPrefix) {
        if (!$assertionsDisabled && this.inCharSequenceMode) {
            throw new AssertionError();
        }
        this.inCharSequenceMode = true;
        this.plusReplacesMinusSign = !this.isNegative && (this.signDisplay == NumberFormatter.SignDisplay.ALWAYS || this.signDisplay == NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS) && !this.patternInfo.positiveHasPlusSign();
        boolean useNegativeAffixPattern = this.patternInfo.hasNegativeSubpattern() && (this.isNegative || this.patternInfo.negativeHasMinusSign() && this.plusReplacesMinusSign);
        this.flags = 0;
        if (useNegativeAffixPattern) {
            this.flags |= 0x200;
        }
        if (isPrefix) {
            this.flags |= 0x100;
        }
        if (this.plural != null) {
            if (!$assertionsDisabled && this.plural.ordinal() != (0xFF & this.plural.ordinal())) {
                throw new AssertionError();
            }
            this.flags |= this.plural.ordinal();
        }
        this.prependSign = !isPrefix || useNegativeAffixPattern ? false : (this.isNegative ? this.signDisplay != NumberFormatter.SignDisplay.NEVER : this.plusReplacesMinusSign);
        this.length = this.patternInfo.length(this.flags) + (this.prependSign ? 1 : 0);
    }

    private final void $$robo$$android_icu_impl_number_MutablePatternModifier$exitCharSequenceMode() {
        if (!$assertionsDisabled && !this.inCharSequenceMode) {
            throw new AssertionError();
        }
        this.inCharSequenceMode = false;
    }

    private final int $$robo$$android_icu_impl_number_MutablePatternModifier$length() {
        if (!$assertionsDisabled && !this.inCharSequenceMode) {
            throw new AssertionError();
        }
        return this.length;
    }

    private final char $$robo$$android_icu_impl_number_MutablePatternModifier$charAt(int index) {
        if (!$assertionsDisabled && !this.inCharSequenceMode) {
            throw new AssertionError();
        }
        char candidate = this.prependSign && index == 0 ? (char)'-' : (this.prependSign ? (char)this.patternInfo.charAt(this.flags, index - 1) : (char)this.patternInfo.charAt(this.flags, index));
        if (this.plusReplacesMinusSign && candidate == '-') {
            return '+';
        }
        if (this.perMilleReplacesPercent && candidate == '%') {
            return '\u2030';
        }
        return candidate;
    }

    private final CharSequence $$robo$$android_icu_impl_number_MutablePatternModifier$subSequence(int start, int end) {
        throw new AssertionError();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !MutablePatternModifier.class.desiredAssertionStatus();
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_icu_impl_number_MutablePatternModifier$__constructor__(bl);
    }

    public MutablePatternModifier(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_MutablePatternModifier$__constructor__(boolean ), 0, this, bl);
    }

    public void setPatternInfo(AffixPatternProvider affixPatternProvider) {
        InvokeDynamicSupport.bootstrap("setPatternInfo", $$robo$$android_icu_impl_number_MutablePatternModifier$setPatternInfo(android.icu.impl.number.AffixPatternProvider ), 0, this, affixPatternProvider);
    }

    public void setPatternAttributes(NumberFormatter.SignDisplay signDisplay, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPatternAttributes", $$robo$$android_icu_impl_number_MutablePatternModifier$setPatternAttributes(android.icu.number.NumberFormatter$SignDisplay boolean ), 0, this, signDisplay, bl);
    }

    public void setSymbols(DecimalFormatSymbols decimalFormatSymbols, Currency currency, NumberFormatter.UnitWidth unitWidth, PluralRules pluralRules) {
        InvokeDynamicSupport.bootstrap("setSymbols", $$robo$$android_icu_impl_number_MutablePatternModifier$setSymbols(android.icu.text.DecimalFormatSymbols android.icu.util.Currency android.icu.number.NumberFormatter$UnitWidth android.icu.text.PluralRules ), 0, this, decimalFormatSymbols, currency, unitWidth, pluralRules);
    }

    public void setNumberProperties(boolean bl, StandardPlural standardPlural) {
        InvokeDynamicSupport.bootstrap("setNumberProperties", $$robo$$android_icu_impl_number_MutablePatternModifier$setNumberProperties(boolean android.icu.impl.StandardPlural ), 0, this, bl, standardPlural);
    }

    public boolean needsPlurals() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsPlurals", $$robo$$android_icu_impl_number_MutablePatternModifier$needsPlurals(), 0, this);
    }

    public ImmutablePatternModifier createImmutable() {
        return InvokeDynamicSupport.bootstrap("createImmutable", $$robo$$android_icu_impl_number_MutablePatternModifier$createImmutable(), 0, this);
    }

    public ImmutablePatternModifier createImmutableAndChain(MicroPropsGenerator microPropsGenerator) {
        return InvokeDynamicSupport.bootstrap("createImmutableAndChain", $$robo$$android_icu_impl_number_MutablePatternModifier$createImmutableAndChain(android.icu.impl.number.MicroPropsGenerator ), 0, this, microPropsGenerator);
    }

    private ConstantMultiFieldModifier createConstantModifier(NumberStringBuilder numberStringBuilder, NumberStringBuilder numberStringBuilder2) {
        return InvokeDynamicSupport.bootstrap("createConstantModifier", $$robo$$android_icu_impl_number_MutablePatternModifier$createConstantModifier(android.icu.impl.number.NumberStringBuilder android.icu.impl.number.NumberStringBuilder ), 0, this, numberStringBuilder, numberStringBuilder2);
    }

    public MicroPropsGenerator addToChain(MicroPropsGenerator microPropsGenerator) {
        return InvokeDynamicSupport.bootstrap("addToChain", $$robo$$android_icu_impl_number_MutablePatternModifier$addToChain(android.icu.impl.number.MicroPropsGenerator ), 0, this, microPropsGenerator);
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        return InvokeDynamicSupport.bootstrap("processQuantity", $$robo$$android_icu_impl_number_MutablePatternModifier$processQuantity(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
    }

    @Override
    public int apply(NumberStringBuilder numberStringBuilder, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_impl_number_MutablePatternModifier$apply(android.icu.impl.number.NumberStringBuilder int int ), 0, this, numberStringBuilder, n, n2);
    }

    @Override
    public int getPrefixLength() {
        return (int)InvokeDynamicSupport.bootstrap("getPrefixLength", $$robo$$android_icu_impl_number_MutablePatternModifier$getPrefixLength(), 0, this);
    }

    @Override
    public int getCodePointCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCodePointCount", $$robo$$android_icu_impl_number_MutablePatternModifier$getCodePointCount(), 0, this);
    }

    @Override
    public boolean isStrong() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStrong", $$robo$$android_icu_impl_number_MutablePatternModifier$isStrong(), 0, this);
    }

    private int insertPrefix(NumberStringBuilder numberStringBuilder, int n) {
        return (int)InvokeDynamicSupport.bootstrap("insertPrefix", $$robo$$android_icu_impl_number_MutablePatternModifier$insertPrefix(android.icu.impl.number.NumberStringBuilder int ), 0, this, numberStringBuilder, n);
    }

    private int insertSuffix(NumberStringBuilder numberStringBuilder, int n) {
        return (int)InvokeDynamicSupport.bootstrap("insertSuffix", $$robo$$android_icu_impl_number_MutablePatternModifier$insertSuffix(android.icu.impl.number.NumberStringBuilder int ), 0, this, numberStringBuilder, n);
    }

    @Override
    public CharSequence getSymbol(int n) {
        return InvokeDynamicSupport.bootstrap("getSymbol", $$robo$$android_icu_impl_number_MutablePatternModifier$getSymbol(int ), 0, this, n);
    }

    private void enterCharSequenceMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("enterCharSequenceMode", $$robo$$android_icu_impl_number_MutablePatternModifier$enterCharSequenceMode(boolean ), 0, this, bl);
    }

    private void exitCharSequenceMode() {
        InvokeDynamicSupport.bootstrap("exitCharSequenceMode", $$robo$$android_icu_impl_number_MutablePatternModifier$exitCharSequenceMode(), 0, this);
    }

    @Override
    public int length() {
        return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_icu_impl_number_MutablePatternModifier$length(), 0, this);
    }

    @Override
    public char charAt(int n) {
        return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_icu_impl_number_MutablePatternModifier$charAt(int ), 0, this, n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("subSequence", $$robo$$android_icu_impl_number_MutablePatternModifier$subSequence(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(MutablePatternModifier.class);
    }

    public /* synthetic */ MutablePatternModifier() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MutablePatternModifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ImmutablePatternModifier
    implements MicroPropsGenerator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ParameterizedModifier pm;
        PluralRules rules;
        MicroPropsGenerator parent;

        private void $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$__constructor__(ParameterizedModifier pm, PluralRules rules, MicroPropsGenerator parent) {
            this.pm = pm;
            this.rules = rules;
            this.parent = parent;
        }

        private final MicroProps $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$processQuantity(DecimalQuantity quantity) {
            MicroProps micros = this.parent.processQuantity(quantity);
            this.applyToMicros(micros, quantity);
            return micros;
        }

        private final void $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$applyToMicros(MicroProps micros, DecimalQuantity quantity) {
            if (this.rules == null) {
                micros.modMiddle = this.pm.getModifier(quantity.isNegative());
            } else {
                DecimalQuantity copy = quantity.createCopy();
                copy.roundToInfinity();
                StandardPlural plural = copy.getStandardPlural(this.rules);
                micros.modMiddle = this.pm.getModifier(quantity.isNegative(), plural);
            }
        }

        private void __constructor__(ParameterizedModifier parameterizedModifier, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
            this.$$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$__constructor__(parameterizedModifier, pluralRules, microPropsGenerator);
        }

        ImmutablePatternModifier(ParameterizedModifier parameterizedModifier, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$__constructor__(android.icu.impl.number.ParameterizedModifier android.icu.text.PluralRules android.icu.impl.number.MicroPropsGenerator ), 0, this, parameterizedModifier, pluralRules, microPropsGenerator);
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
            return InvokeDynamicSupport.bootstrap("processQuantity", $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$processQuantity(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public void applyToMicros(MicroProps microProps, DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("applyToMicros", $$robo$$android_icu_impl_number_MutablePatternModifier_ImmutablePatternModifier$applyToMicros(android.icu.impl.number.MicroProps android.icu.impl.number.DecimalQuantity ), 0, this, microProps, decimalQuantity);
        }

        public /* synthetic */ ImmutablePatternModifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImmutablePatternModifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

