/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.AffixPatternProvider;
import android.icu.impl.number.AffixUtils;
import android.icu.impl.number.DecimalFormatProperties;
import android.icu.impl.number.DecimalQuantity_DualStorageBCD;
import android.icu.impl.number.Padder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PatternStringParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int IGNORE_ROUNDING_NEVER = 0;
    public static int IGNORE_ROUNDING_IF_CURRENCY = 1;
    public static int IGNORE_ROUNDING_ALWAYS = 2;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_number_PatternStringParser$__constructor__() {
    }

    private static final ParsedPatternInfo $$robo$$android_icu_impl_number_PatternStringParser$parseToPatternInfo(String patternString) {
        ParserState state = new ParserState(patternString);
        ParsedPatternInfo result = new ParsedPatternInfo(patternString);
        PatternStringParser.consumePattern(state, result);
        return result;
    }

    private static final DecimalFormatProperties $$robo$$android_icu_impl_number_PatternStringParser$parseToProperties(String pattern, int ignoreRounding) {
        DecimalFormatProperties properties = new DecimalFormatProperties();
        PatternStringParser.parseToExistingPropertiesImpl(pattern, properties, ignoreRounding);
        return properties;
    }

    private static final DecimalFormatProperties $$robo$$android_icu_impl_number_PatternStringParser$parseToProperties(String pattern) {
        return PatternStringParser.parseToProperties(pattern, 0);
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingProperties(String pattern, DecimalFormatProperties properties, int ignoreRounding) {
        PatternStringParser.parseToExistingPropertiesImpl(pattern, properties, ignoreRounding);
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingProperties(String pattern, DecimalFormatProperties properties) {
        PatternStringParser.parseToExistingProperties(pattern, properties, 0);
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumePattern(ParserState state, ParsedPatternInfo result) {
        result.positive = new ParsedSubpatternInfo();
        PatternStringParser.consumeSubpattern(state, result.positive);
        if (state.peek() == 59) {
            state.next();
            if (state.peek() != -1) {
                result.negative = new ParsedSubpatternInfo();
                PatternStringParser.consumeSubpattern(state, result.negative);
            }
        }
        if (state.peek() != -1) {
            throw state.toParseException("Found unquoted special character");
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeSubpattern(ParserState state, ParsedSubpatternInfo result) {
        PatternStringParser.consumePadding(state, result, Padder.PadPosition.BEFORE_PREFIX);
        result.prefixEndpoints = PatternStringParser.consumeAffix(state, result);
        PatternStringParser.consumePadding(state, result, Padder.PadPosition.AFTER_PREFIX);
        PatternStringParser.consumeFormat(state, result);
        PatternStringParser.consumeExponent(state, result);
        PatternStringParser.consumePadding(state, result, Padder.PadPosition.BEFORE_SUFFIX);
        result.suffixEndpoints = PatternStringParser.consumeAffix(state, result);
        PatternStringParser.consumePadding(state, result, Padder.PadPosition.AFTER_SUFFIX);
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumePadding(ParserState state, ParsedSubpatternInfo result, Padder.PadPosition paddingLocation) {
        if (state.peek() != 42) {
            return;
        }
        if (result.paddingLocation != null) {
            throw state.toParseException("Cannot have multiple pad specifiers");
        }
        result.paddingLocation = paddingLocation;
        state.next();
        result.paddingEndpoints |= (long)state.offset;
        PatternStringParser.consumeLiteral(state);
        result.paddingEndpoints |= (long)state.offset << 32;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final long $$robo$$android_icu_impl_number_PatternStringParser$consumeAffix(ParserState state, ParsedSubpatternInfo result) {
        long endpoints = state.offset;
        while (true) {
            switch (state.peek()) {
                case -1: 
                case 35: 
                case 42: 
                case 44: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 64: {
                    return endpoints |= (long)state.offset << 32;
                }
                case 37: {
                    result.hasPercentSign = true;
                    break;
                }
                case 8240: {
                    result.hasPerMilleSign = true;
                    break;
                }
                case 164: {
                    result.hasCurrencySign = true;
                    break;
                }
                case 45: {
                    result.hasMinusSign = true;
                    break;
                }
                case 43: {
                    result.hasPlusSign = true;
                }
            }
            PatternStringParser.consumeLiteral(state);
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeLiteral(ParserState state) {
        if (state.peek() == -1) {
            throw state.toParseException("Expected unquoted literal but found EOL");
        }
        if (state.peek() == 39) {
            state.next();
            while (state.peek() != 39) {
                if (state.peek() == -1) {
                    throw state.toParseException("Expected quoted literal but found EOL");
                }
                state.next();
            }
            state.next();
        } else {
            state.next();
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeFormat(ParserState state, ParsedSubpatternInfo result) {
        PatternStringParser.consumeIntegerFormat(state, result);
        if (state.peek() == 46) {
            state.next();
            result.hasDecimal = true;
            ++result.widthExceptAffixes;
            PatternStringParser.consumeFractionFormat(state, result);
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeIntegerFormat(ParserState state, ParsedSubpatternInfo result) {
        block6: while (true) {
            switch (state.peek()) {
                case 44: {
                    ++result.widthExceptAffixes;
                    result.groupingSizes <<= 16;
                    break;
                }
                case 35: {
                    if (result.integerNumerals > 0) {
                        throw state.toParseException("# cannot follow 0 before decimal point");
                    }
                    ++result.widthExceptAffixes;
                    ++result.groupingSizes;
                    if (result.integerAtSigns > 0) {
                        ++result.integerTrailingHashSigns;
                    } else {
                        ++result.integerLeadingHashSigns;
                    }
                    ++result.integerTotal;
                    break;
                }
                case 64: {
                    if (result.integerNumerals > 0) {
                        throw state.toParseException("Cannot mix 0 and @");
                    }
                    if (result.integerTrailingHashSigns > 0) {
                        throw state.toParseException("Cannot nest # inside of a run of @");
                    }
                    ++result.widthExceptAffixes;
                    ++result.groupingSizes;
                    ++result.integerAtSigns;
                    ++result.integerTotal;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (result.integerAtSigns > 0) {
                        throw state.toParseException("Cannot mix @ and 0");
                    }
                    ++result.widthExceptAffixes;
                    ++result.groupingSizes;
                    ++result.integerNumerals;
                    ++result.integerTotal;
                    if (state.peek() != 48 && result.rounding == null) {
                        result.rounding = new DecimalQuantity_DualStorageBCD();
                    }
                    if (result.rounding == null) break;
                    result.rounding.appendDigit((byte)(state.peek() - 48), 0, true);
                    break;
                }
                default: {
                    break block6;
                }
            }
            state.next();
        }
        short grouping1 = (short)(result.groupingSizes & 0xFFFFL);
        short grouping2 = (short)(result.groupingSizes >>> 16 & 0xFFFFL);
        short grouping3 = (short)(result.groupingSizes >>> 32 & 0xFFFFL);
        if (grouping1 == 0 && grouping2 != -1) {
            throw state.toParseException("Trailing grouping separator is invalid");
        }
        if (grouping2 == 0 && grouping3 != -1) {
            throw state.toParseException("Grouping width of zero is invalid");
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeFractionFormat(ParserState state, ParsedSubpatternInfo result) {
        int zeroCounter = 0;
        while (true) {
            switch (state.peek()) {
                case 35: {
                    ++result.widthExceptAffixes;
                    ++result.fractionHashSigns;
                    ++result.fractionTotal;
                    ++zeroCounter;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (result.fractionHashSigns > 0) {
                        throw state.toParseException("0 cannot follow # after decimal point");
                    }
                    ++result.widthExceptAffixes;
                    ++result.fractionNumerals;
                    ++result.fractionTotal;
                    if (state.peek() == 48) {
                        ++zeroCounter;
                        break;
                    }
                    if (result.rounding == null) {
                        result.rounding = new DecimalQuantity_DualStorageBCD();
                    }
                    result.rounding.appendDigit((byte)(state.peek() - 48), zeroCounter, false);
                    zeroCounter = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            state.next();
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$consumeExponent(ParserState state, ParsedSubpatternInfo result) {
        if (state.peek() != 69) {
            return;
        }
        if ((result.groupingSizes & 0xFFFF0000L) != 0xFFFF0000L) {
            throw state.toParseException("Cannot have grouping separator in scientific notation");
        }
        state.next();
        ++result.widthExceptAffixes;
        if (state.peek() == 43) {
            state.next();
            result.exponentHasPlusSign = true;
            ++result.widthExceptAffixes;
        }
        while (state.peek() == 48) {
            state.next();
            ++result.exponentZeros;
            ++result.widthExceptAffixes;
        }
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingPropertiesImpl(String pattern, DecimalFormatProperties properties, int ignoreRounding) {
        if (pattern == null || pattern.length() == 0) {
            properties.clear();
            return;
        }
        ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        PatternStringParser.patternInfoToProperties(properties, patternInfo, ignoreRounding);
    }

    private static final void $$robo$$android_icu_impl_number_PatternStringParser$patternInfoToProperties(DecimalFormatProperties properties, ParsedPatternInfo patternInfo, int _ignoreRounding) {
        int minFrac;
        int minInt;
        boolean ignoreRounding;
        ParsedSubpatternInfo positive = patternInfo.positive;
        if (_ignoreRounding == 0) {
            ignoreRounding = false;
        } else if (_ignoreRounding == 1) {
            ignoreRounding = positive.hasCurrencySign;
        } else {
            if (!$assertionsDisabled && _ignoreRounding != 2) {
                throw new AssertionError();
            }
            ignoreRounding = true;
        }
        short grouping1 = (short)(positive.groupingSizes & 0xFFFFL);
        short grouping2 = (short)(positive.groupingSizes >>> 16 & 0xFFFFL);
        short grouping3 = (short)(positive.groupingSizes >>> 32 & 0xFFFFL);
        if (grouping2 != -1) {
            properties.setGroupingSize(grouping1);
        } else {
            properties.setGroupingSize(-1);
        }
        if (grouping3 != -1) {
            properties.setSecondaryGroupingSize(grouping2);
        } else {
            properties.setSecondaryGroupingSize(-1);
        }
        if (positive.integerTotal == 0 && positive.fractionTotal > 0) {
            minInt = 0;
            minFrac = Math.max(1, positive.fractionNumerals);
        } else if (positive.integerNumerals == 0 && positive.fractionNumerals == 0) {
            minInt = 1;
            minFrac = 0;
        } else {
            minInt = positive.integerNumerals;
            minFrac = positive.fractionNumerals;
        }
        if (positive.integerAtSigns > 0) {
            properties.setMinimumFractionDigits(-1);
            properties.setMaximumFractionDigits(-1);
            properties.setRoundingIncrement(null);
            properties.setMinimumSignificantDigits(positive.integerAtSigns);
            properties.setMaximumSignificantDigits(positive.integerAtSigns + positive.integerTrailingHashSigns);
        } else if (positive.rounding != null) {
            if (!ignoreRounding) {
                properties.setMinimumFractionDigits(minFrac);
                properties.setMaximumFractionDigits(positive.fractionTotal);
                properties.setRoundingIncrement(positive.rounding.toBigDecimal().setScale(positive.fractionNumerals));
            } else {
                properties.setMinimumFractionDigits(-1);
                properties.setMaximumFractionDigits(-1);
                properties.setRoundingIncrement(null);
            }
            properties.setMinimumSignificantDigits(-1);
            properties.setMaximumSignificantDigits(-1);
        } else {
            if (!ignoreRounding) {
                properties.setMinimumFractionDigits(minFrac);
                properties.setMaximumFractionDigits(positive.fractionTotal);
                properties.setRoundingIncrement(null);
            } else {
                properties.setMinimumFractionDigits(-1);
                properties.setMaximumFractionDigits(-1);
                properties.setRoundingIncrement(null);
            }
            properties.setMinimumSignificantDigits(-1);
            properties.setMaximumSignificantDigits(-1);
        }
        if (positive.hasDecimal && positive.fractionTotal == 0) {
            properties.setDecimalSeparatorAlwaysShown(true);
        } else {
            properties.setDecimalSeparatorAlwaysShown(false);
        }
        if (positive.exponentZeros > 0) {
            properties.setExponentSignAlwaysShown(positive.exponentHasPlusSign);
            properties.setMinimumExponentDigits(positive.exponentZeros);
            if (positive.integerAtSigns == 0) {
                properties.setMinimumIntegerDigits(positive.integerNumerals);
                properties.setMaximumIntegerDigits(positive.integerTotal);
            } else {
                properties.setMinimumIntegerDigits(1);
                properties.setMaximumIntegerDigits(-1);
            }
        } else {
            properties.setExponentSignAlwaysShown(false);
            properties.setMinimumExponentDigits(-1);
            properties.setMinimumIntegerDigits(minInt);
            properties.setMaximumIntegerDigits(-1);
        }
        String posPrefix = patternInfo.getString(256);
        String posSuffix = patternInfo.getString(0);
        if (positive.paddingLocation != null) {
            int paddingWidth = positive.widthExceptAffixes + AffixUtils.estimateLength(posPrefix) + AffixUtils.estimateLength(posSuffix);
            properties.setFormatWidth(paddingWidth);
            String rawPaddingString = patternInfo.getString(1024);
            if (rawPaddingString.length() == 1) {
                properties.setPadString(rawPaddingString);
            } else if (rawPaddingString.length() == 2) {
                if (rawPaddingString.charAt(0) == '\'') {
                    properties.setPadString("'");
                } else {
                    properties.setPadString(rawPaddingString);
                }
            } else {
                properties.setPadString(rawPaddingString.substring(1, rawPaddingString.length() - 1));
            }
            if (!$assertionsDisabled && positive.paddingLocation == null) {
                throw new AssertionError();
            }
            properties.setPadPosition(positive.paddingLocation);
        } else {
            properties.setFormatWidth(-1);
            properties.setPadString(null);
            properties.setPadPosition(null);
        }
        properties.setPositivePrefixPattern(posPrefix);
        properties.setPositiveSuffixPattern(posSuffix);
        if (patternInfo.negative != null) {
            properties.setNegativePrefixPattern(patternInfo.getString(768));
            properties.setNegativeSuffixPattern(patternInfo.getString(512));
        } else {
            properties.setNegativePrefixPattern(null);
            properties.setNegativeSuffixPattern(null);
        }
        if (positive.hasPercentSign) {
            properties.setMagnitudeMultiplier(2);
        } else if (positive.hasPerMilleSign) {
            properties.setMagnitudeMultiplier(3);
        } else {
            properties.setMagnitudeMultiplier(0);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !PatternStringParser.class.desiredAssertionStatus();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_number_PatternStringParser$__constructor__();
    }

    public PatternStringParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_PatternStringParser$__constructor__(), 0, this);
    }

    public static ParsedPatternInfo parseToPatternInfo(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseToPatternInfo", $$robo$$android_icu_impl_number_PatternStringParser$parseToPatternInfo(java.lang.String ), 0, (String)string2);
    }

    public static DecimalFormatProperties parseToProperties(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("parseToProperties", $$robo$$android_icu_impl_number_PatternStringParser$parseToProperties(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static DecimalFormatProperties parseToProperties(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseToProperties", $$robo$$android_icu_impl_number_PatternStringParser$parseToProperties(java.lang.String ), 0, (String)string2);
    }

    public static void parseToExistingProperties(String string2, DecimalFormatProperties decimalFormatProperties, int n) {
        InvokeDynamicSupport.bootstrapStatic("parseToExistingProperties", $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingProperties(java.lang.String android.icu.impl.number.DecimalFormatProperties int ), 0, (String)string2, (DecimalFormatProperties)decimalFormatProperties, (int)n);
    }

    public static void parseToExistingProperties(String string2, DecimalFormatProperties decimalFormatProperties) {
        InvokeDynamicSupport.bootstrapStatic("parseToExistingProperties", $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingProperties(java.lang.String android.icu.impl.number.DecimalFormatProperties ), 0, (String)string2, (DecimalFormatProperties)decimalFormatProperties);
    }

    private static void consumePattern(ParserState parserState, ParsedPatternInfo parsedPatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumePattern", $$robo$$android_icu_impl_number_PatternStringParser$consumePattern(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedPatternInfo ), 0, (ParserState)parserState, (ParsedPatternInfo)parsedPatternInfo);
    }

    private static void consumeSubpattern(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumeSubpattern", $$robo$$android_icu_impl_number_PatternStringParser$consumeSubpattern(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void consumePadding(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo, Padder.PadPosition padPosition) {
        InvokeDynamicSupport.bootstrapStatic("consumePadding", $$robo$$android_icu_impl_number_PatternStringParser$consumePadding(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo android.icu.impl.number.Padder$PadPosition ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo, (Padder.PadPosition)padPosition);
    }

    private static long consumeAffix(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        return (long)InvokeDynamicSupport.bootstrapStatic("consumeAffix", $$robo$$android_icu_impl_number_PatternStringParser$consumeAffix(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void consumeLiteral(ParserState parserState) {
        InvokeDynamicSupport.bootstrapStatic("consumeLiteral", $$robo$$android_icu_impl_number_PatternStringParser$consumeLiteral(android.icu.impl.number.PatternStringParser$ParserState ), 0, (ParserState)parserState);
    }

    private static void consumeFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumeFormat", $$robo$$android_icu_impl_number_PatternStringParser$consumeFormat(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void consumeIntegerFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumeIntegerFormat", $$robo$$android_icu_impl_number_PatternStringParser$consumeIntegerFormat(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void consumeFractionFormat(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumeFractionFormat", $$robo$$android_icu_impl_number_PatternStringParser$consumeFractionFormat(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void consumeExponent(ParserState parserState, ParsedSubpatternInfo parsedSubpatternInfo) {
        InvokeDynamicSupport.bootstrapStatic("consumeExponent", $$robo$$android_icu_impl_number_PatternStringParser$consumeExponent(android.icu.impl.number.PatternStringParser$ParserState android.icu.impl.number.PatternStringParser$ParsedSubpatternInfo ), 0, (ParserState)parserState, (ParsedSubpatternInfo)parsedSubpatternInfo);
    }

    private static void parseToExistingPropertiesImpl(String string2, DecimalFormatProperties decimalFormatProperties, int n) {
        InvokeDynamicSupport.bootstrapStatic("parseToExistingPropertiesImpl", $$robo$$android_icu_impl_number_PatternStringParser$parseToExistingPropertiesImpl(java.lang.String android.icu.impl.number.DecimalFormatProperties int ), 0, (String)string2, (DecimalFormatProperties)decimalFormatProperties, (int)n);
    }

    private static void patternInfoToProperties(DecimalFormatProperties decimalFormatProperties, ParsedPatternInfo parsedPatternInfo, int n) {
        InvokeDynamicSupport.bootstrapStatic("patternInfoToProperties", $$robo$$android_icu_impl_number_PatternStringParser$patternInfoToProperties(android.icu.impl.number.DecimalFormatProperties android.icu.impl.number.PatternStringParser$ParsedPatternInfo int ), 0, (DecimalFormatProperties)decimalFormatProperties, (ParsedPatternInfo)parsedPatternInfo, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(PatternStringParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PatternStringParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ParserState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String pattern;
        int offset;

        private void $$robo$$android_icu_impl_number_PatternStringParser_ParserState$__constructor__(String pattern) {
            this.pattern = pattern;
            this.offset = 0;
        }

        private final int $$robo$$android_icu_impl_number_PatternStringParser_ParserState$peek() {
            if (this.offset == this.pattern.length()) {
                return -1;
            }
            return this.pattern.codePointAt(this.offset);
        }

        private final int $$robo$$android_icu_impl_number_PatternStringParser_ParserState$next() {
            int codePoint = this.peek();
            this.offset += Character.charCount(codePoint);
            return codePoint;
        }

        private final IllegalArgumentException $$robo$$android_icu_impl_number_PatternStringParser_ParserState$toParseException(String message) {
            StringBuilder sb = new StringBuilder();
            sb.append("Malformed pattern for ICU DecimalFormat: \"");
            sb.append(this.pattern);
            sb.append("\": ");
            sb.append(message);
            sb.append(" at position ");
            sb.append(this.offset);
            return new IllegalArgumentException(sb.toString());
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_number_PatternStringParser_ParserState$__constructor__(string2);
        }

        ParserState(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_PatternStringParser_ParserState$__constructor__(java.lang.String ), 0, this, string2);
        }

        int peek() {
            return (int)InvokeDynamicSupport.bootstrap("peek", $$robo$$android_icu_impl_number_PatternStringParser_ParserState$peek(), 0, this);
        }

        int next() {
            return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_number_PatternStringParser_ParserState$next(), 0, this);
        }

        IllegalArgumentException toParseException(String string2) {
            return InvokeDynamicSupport.bootstrap("toParseException", $$robo$$android_icu_impl_number_PatternStringParser_ParserState$toParseException(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ParserState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParserState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParsedSubpatternInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long groupingSizes;
        public int integerLeadingHashSigns;
        public int integerTrailingHashSigns;
        public int integerNumerals;
        public int integerAtSigns;
        public int integerTotal;
        public int fractionNumerals;
        public int fractionHashSigns;
        public int fractionTotal;
        public boolean hasDecimal;
        public int widthExceptAffixes;
        public Padder.PadPosition paddingLocation;
        public DecimalQuantity_DualStorageBCD rounding;
        public boolean exponentHasPlusSign;
        public int exponentZeros;
        public boolean hasPercentSign;
        public boolean hasPerMilleSign;
        public boolean hasCurrencySign;
        public boolean hasMinusSign;
        public boolean hasPlusSign;
        public long prefixEndpoints;
        public long suffixEndpoints;
        public long paddingEndpoints;

        private void $$robo$$android_icu_impl_number_PatternStringParser_ParsedSubpatternInfo$__constructor__() {
            this.groupingSizes = 0xFFFFFFFF0000L;
            this.integerLeadingHashSigns = 0;
            this.integerTrailingHashSigns = 0;
            this.integerNumerals = 0;
            this.integerAtSigns = 0;
            this.integerTotal = 0;
            this.fractionNumerals = 0;
            this.fractionHashSigns = 0;
            this.fractionTotal = 0;
            this.hasDecimal = false;
            this.widthExceptAffixes = 0;
            this.paddingLocation = null;
            this.rounding = null;
            this.exponentHasPlusSign = false;
            this.exponentZeros = 0;
            this.hasPercentSign = false;
            this.hasPerMilleSign = false;
            this.hasCurrencySign = false;
            this.hasMinusSign = false;
            this.hasPlusSign = false;
            this.prefixEndpoints = 0L;
            this.suffixEndpoints = 0L;
            this.paddingEndpoints = 0L;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_number_PatternStringParser_ParsedSubpatternInfo$__constructor__();
        }

        public ParsedSubpatternInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_PatternStringParser_ParsedSubpatternInfo$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsedSubpatternInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParsedPatternInfo
    implements AffixPatternProvider,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String pattern;
        public ParsedSubpatternInfo positive;
        public ParsedSubpatternInfo negative;

        private void $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$__constructor__(String pattern) {
            this.pattern = pattern;
        }

        private final char $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$charAt(int flags, int index) {
            long endpoints = this.getEndpoints(flags);
            int left = (int)(endpoints & 0xFFFFFFFFFFFFFFFFL);
            int right = (int)(endpoints >>> 32);
            if (index < 0 || index >= right - left) {
                throw new IndexOutOfBoundsException();
            }
            return this.pattern.charAt(left + index);
        }

        private final int $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$length(int flags) {
            return ParsedPatternInfo.getLengthFromEndpoints(this.getEndpoints(flags));
        }

        private static final int $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getLengthFromEndpoints(long endpoints) {
            int left = (int)(endpoints & 0xFFFFFFFFFFFFFFFFL);
            int right = (int)(endpoints >>> 32);
            return right - left;
        }

        private final String $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getString(int flags) {
            int right;
            long endpoints = this.getEndpoints(flags);
            int left = (int)(endpoints & 0xFFFFFFFFFFFFFFFFL);
            if (left == (right = (int)(endpoints >>> 32))) {
                return "";
            }
            return this.pattern.substring(left, right);
        }

        private final long $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getEndpoints(int flags) {
            boolean padding;
            boolean prefix = (flags & 0x100) != 0;
            boolean isNegative = (flags & 0x200) != 0;
            boolean bl = padding = (flags & 0x400) != 0;
            if (isNegative && padding) {
                return this.negative.paddingEndpoints;
            }
            if (padding) {
                return this.positive.paddingEndpoints;
            }
            if (prefix && isNegative) {
                return this.negative.prefixEndpoints;
            }
            if (prefix) {
                return this.positive.prefixEndpoints;
            }
            if (isNegative) {
                return this.negative.suffixEndpoints;
            }
            return this.positive.suffixEndpoints;
        }

        private final boolean $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$positiveHasPlusSign() {
            return this.positive.hasPlusSign;
        }

        private final boolean $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$hasNegativeSubpattern() {
            return this.negative != null;
        }

        private final boolean $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$negativeHasMinusSign() {
            return this.negative.hasMinusSign;
        }

        private final boolean $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$hasCurrencySign() {
            return this.positive.hasCurrencySign || this.negative != null && this.negative.hasCurrencySign;
        }

        private final boolean $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$containsSymbolType(int type) {
            return AffixUtils.containsType(this.pattern, type);
        }

        private /* synthetic */ void $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$__constructor__(String x0, 1 x1) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$__constructor__(string2);
        }

        private ParsedPatternInfo(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        public char charAt(int n, int n2) {
            return (char)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$charAt(int int ), 0, this, n, n2);
        }

        @Override
        public int length(int n) {
            return (int)InvokeDynamicSupport.bootstrap("length", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$length(int ), 0, this, n);
        }

        public static int getLengthFromEndpoints(long l) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getLengthFromEndpoints", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getLengthFromEndpoints(long ), 0, (long)l);
        }

        public String getString(int n) {
            return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getString(int ), 0, this, n);
        }

        private long getEndpoints(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getEndpoints", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$getEndpoints(int ), 0, this, n);
        }

        @Override
        public boolean positiveHasPlusSign() {
            return (boolean)InvokeDynamicSupport.bootstrap("positiveHasPlusSign", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$positiveHasPlusSign(), 0, this);
        }

        @Override
        public boolean hasNegativeSubpattern() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNegativeSubpattern", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$hasNegativeSubpattern(), 0, this);
        }

        @Override
        public boolean negativeHasMinusSign() {
            return (boolean)InvokeDynamicSupport.bootstrap("negativeHasMinusSign", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$negativeHasMinusSign(), 0, this);
        }

        @Override
        public boolean hasCurrencySign() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCurrencySign", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$hasCurrencySign(), 0, this);
        }

        @Override
        public boolean containsSymbolType(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsSymbolType", $$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$containsSymbolType(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$android_icu_impl_number_PatternStringParser_ParsedPatternInfo$__constructor__(string2, var2_2);
        }

        public /* synthetic */ ParsedPatternInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParsedPatternInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

