/*
 * Decompiled with CFR 0.152.
 */
package android.icu.math;

import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MathContext
implements Serializable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PLAIN = 0;
    public static int SCIENTIFIC = 1;
    public static int ENGINEERING = 2;
    public static int ROUND_CEILING = 2;
    public static int ROUND_DOWN = 1;
    public static int ROUND_FLOOR = 3;
    public static int ROUND_HALF_DOWN = 5;
    public static int ROUND_HALF_EVEN = 6;
    public static int ROUND_HALF_UP = 4;
    public static int ROUND_UNNECESSARY = 7;
    public static int ROUND_UP = 0;
    int digits;
    int form;
    boolean lostDigits;
    int roundingMode;
    private static int DEFAULT_FORM = 1;
    private static int DEFAULT_DIGITS = 9;
    private static boolean DEFAULT_LOSTDIGITS = false;
    private static int DEFAULT_ROUNDINGMODE = 4;
    private static int MIN_DIGITS = 0;
    private static int MAX_DIGITS = 999999999;
    private static int[] ROUNDS;
    private static String[] ROUNDWORDS;
    private static long serialVersionUID = 7163376998892515376L;
    public static MathContext DEFAULT;

    private void $$robo$$android_icu_math_MathContext$__constructor__(int setdigits) {
    }

    private void $$robo$$android_icu_math_MathContext$__constructor__(int setdigits, int setform) {
    }

    private void $$robo$$android_icu_math_MathContext$__constructor__(int setdigits, int setform, boolean setlostdigits) {
    }

    private void $$robo$$android_icu_math_MathContext$__constructor__(int setdigits, int setform, boolean setlostdigits, int setroundingmode) {
        if (setdigits != 9) {
            if (setdigits < 0) {
                throw new IllegalArgumentException("Digits too small: " + setdigits);
            }
            if (setdigits > 999999999) {
                throw new IllegalArgumentException("Digits too large: " + setdigits);
            }
        }
        if (setform != 1 && setform != 2 && setform != 0) {
            throw new IllegalArgumentException("Bad form value: " + setform);
        }
        if (!MathContext.isValidRound(setroundingmode)) {
            throw new IllegalArgumentException("Bad roundingMode value: " + setroundingmode);
        }
        this.digits = setdigits;
        this.form = setform;
        this.lostDigits = setlostdigits;
        this.roundingMode = setroundingmode;
    }

    private final int $$robo$$android_icu_math_MathContext$getDigits() {
        return this.digits;
    }

    private final int $$robo$$android_icu_math_MathContext$getForm() {
        return this.form;
    }

    private final boolean $$robo$$android_icu_math_MathContext$getLostDigits() {
        return this.lostDigits;
    }

    private final int $$robo$$android_icu_math_MathContext$getRoundingMode() {
        return this.roundingMode;
    }

    private final String $$robo$$android_icu_math_MathContext$toString() {
        String formstr = null;
        int r = 0;
        String roundword = null;
        formstr = this.form == 1 ? "SCIENTIFIC" : (this.form == 2 ? "ENGINEERING" : "PLAIN");
        int $1 = ROUNDS.length;
        r = 0;
        while ($1 > 0) {
            if (this.roundingMode == ROUNDS[r]) {
                roundword = ROUNDWORDS[r];
                break;
            }
            --$1;
            ++r;
        }
        return "digits=" + this.digits + " form=" + formstr + " lostDigits=" + (this.lostDigits ? "1" : "0") + " roundingMode=" + roundword;
    }

    private static final boolean $$robo$$android_icu_math_MathContext$isValidRound(int testround) {
        int r = 0;
        int $2 = ROUNDS.length;
        r = 0;
        while ($2 > 0) {
            if (testround == ROUNDS[r]) {
                return true;
            }
            --$2;
            ++r;
        }
        return false;
    }

    static void __staticInitializer__() {
        ROUNDS = new int[]{4, 7, 2, 1, 3, 5, 6, 0};
        ROUNDWORDS = new String[]{"ROUND_HALF_UP", "ROUND_UNNECESSARY", "ROUND_CEILING", "ROUND_DOWN", "ROUND_FLOOR", "ROUND_HALF_DOWN", "ROUND_HALF_EVEN", "ROUND_UP"};
        DEFAULT = new MathContext(9, 1, false, 4);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_icu_math_MathContext$__constructor__(n);
    }

    public MathContext(int n) {
        this(n, 1, false, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_math_MathContext$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_icu_math_MathContext$__constructor__(n, n2);
    }

    public MathContext(int n, int n2) {
        this(n, n2, false, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_math_MathContext$__constructor__(int int ), 0, this, n, n2);
    }

    private void __constructor__(int n, int n2, boolean bl) {
        this.$$robo$$android_icu_math_MathContext$__constructor__(n, n2, bl);
    }

    public MathContext(int n, int n2, boolean bl) {
        this(n, n2, bl, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_math_MathContext$__constructor__(int int boolean ), 0, this, n, n2, bl);
    }

    private void __constructor__(int n, int n2, boolean bl, int n3) {
        this.$$robo$$android_icu_math_MathContext$__constructor__(n, n2, bl, n3);
    }

    public MathContext(int n, int n2, boolean bl, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_math_MathContext$__constructor__(int int boolean int ), 0, this, n, n2, bl, n3);
    }

    public int getDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getDigits", $$robo$$android_icu_math_MathContext$getDigits(), 0, this);
    }

    public int getForm() {
        return (int)InvokeDynamicSupport.bootstrap("getForm", $$robo$$android_icu_math_MathContext$getForm(), 0, this);
    }

    public boolean getLostDigits() {
        return (boolean)InvokeDynamicSupport.bootstrap("getLostDigits", $$robo$$android_icu_math_MathContext$getLostDigits(), 0, this);
    }

    public int getRoundingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRoundingMode", $$robo$$android_icu_math_MathContext$getRoundingMode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_math_MathContext$toString(), 0, this);
    }

    private static boolean isValidRound(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidRound", $$robo$$android_icu_math_MathContext$isValidRound(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(MathContext.class);
    }

    public /* synthetic */ MathContext() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MathContext)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

