/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.number.CompactData;
import android.icu.impl.number.ConstantAffixModifier;
import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.LongNameHandler;
import android.icu.impl.number.MacroProps;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.MutablePatternModifier;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.impl.number.Padder;
import android.icu.impl.number.PatternStringParser;
import android.icu.number.CompactNotation;
import android.icu.number.Grouper;
import android.icu.number.IntegerWidth;
import android.icu.number.NumberFormatter;
import android.icu.number.Rounder;
import android.icu.number.ScientificNotation;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import android.icu.text.NumberingSystem;
import android.icu.text.PluralRules;
import android.icu.util.Currency;
import android.icu.util.MeasureUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NumberFormatterImpl
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Currency DEFAULT_CURRENCY;
    MicroPropsGenerator microPropsGenerator;

    private static final NumberFormatterImpl $$robo$$android_icu_number_NumberFormatterImpl$fromMacros(MacroProps macros) {
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macros, true);
        return new NumberFormatterImpl(microPropsGenerator);
    }

    private static final MicroProps $$robo$$android_icu_number_NumberFormatterImpl$applyStatic(MacroProps macros, DecimalQuantity inValue, NumberStringBuilder outString) {
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macros, false);
        MicroProps micros = microPropsGenerator.processQuantity(inValue);
        NumberFormatterImpl.microsToString(micros, inValue, outString);
        return micros;
    }

    private void $$robo$$android_icu_number_NumberFormatterImpl$__constructor__(MicroPropsGenerator microPropsGenerator) {
        this.microPropsGenerator = microPropsGenerator;
    }

    private final MicroProps $$robo$$android_icu_number_NumberFormatterImpl$apply(DecimalQuantity inValue, NumberStringBuilder outString) {
        MicroProps micros = this.microPropsGenerator.processQuantity(inValue);
        NumberFormatterImpl.microsToString(micros, inValue, outString);
        return micros;
    }

    private static final boolean $$robo$$android_icu_number_NumberFormatterImpl$unitIsCurrency(MeasureUnit unit) {
        return unit != null && "currency".equals(unit.getType());
    }

    private static final boolean $$robo$$android_icu_number_NumberFormatterImpl$unitIsNoUnit(MeasureUnit unit) {
        return unit == null || "none".equals(unit.getType());
    }

    private static final boolean $$robo$$android_icu_number_NumberFormatterImpl$unitIsPercent(MeasureUnit unit) {
        return unit != null && "percent".equals(unit.getSubtype());
    }

    private static final boolean $$robo$$android_icu_number_NumberFormatterImpl$unitIsPermille(MeasureUnit unit) {
        return unit != null && "permille".equals(unit.getSubtype());
    }

    private static final MicroPropsGenerator $$robo$$android_icu_number_NumberFormatterImpl$macrosToMicroGenerator(MacroProps macros, boolean safe) {
        MicroProps micros;
        MicroPropsGenerator chain = micros = new MicroProps(safe);
        boolean isCurrency = NumberFormatterImpl.unitIsCurrency(macros.unit);
        boolean isNoUnit = NumberFormatterImpl.unitIsNoUnit(macros.unit);
        boolean isPercent = isNoUnit && NumberFormatterImpl.unitIsPercent(macros.unit);
        boolean isPermille = isNoUnit && NumberFormatterImpl.unitIsPermille(macros.unit);
        boolean isCldrUnit = !isCurrency && !isNoUnit;
        boolean isAccounting = macros.sign == NumberFormatter.SignDisplay.ACCOUNTING || macros.sign == NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS;
        Currency currency = isCurrency ? (Currency)macros.unit : DEFAULT_CURRENCY;
        NumberFormatter.UnitWidth unitWidth = NumberFormatter.UnitWidth.SHORT;
        if (macros.unitWidth != null) {
            unitWidth = macros.unitWidth;
        }
        PluralRules rules = macros.rules;
        NumberingSystem ns = macros.symbols instanceof NumberingSystem ? (NumberingSystem)macros.symbols : NumberingSystem.getInstance(macros.loc);
        String nsName = ns.getName();
        int patternStyle = isPercent || isPermille ? 2 : (!isCurrency || unitWidth == NumberFormatter.UnitWidth.FULL_NAME ? 0 : (isAccounting ? 7 : 1));
        String pattern = NumberFormat.getPatternForStyleAndNumberingSystem(macros.loc, nsName, patternStyle);
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        micros.symbols = macros.symbols instanceof DecimalFormatSymbols ? (DecimalFormatSymbols)macros.symbols : DecimalFormatSymbols.forNumberingSystem(macros.loc, ns);
        if (macros.multiplier != null) {
            chain = macros.multiplier.copyAndChain(chain);
        }
        micros.rounding = macros.rounder != null ? macros.rounder : (macros.notation instanceof CompactNotation ? Rounder.COMPACT_STRATEGY : (isCurrency ? Rounder.MONETARY_STANDARD : Rounder.MAX_FRAC_6));
        micros.rounding = micros.rounding.withLocaleData(currency);
        micros.grouping = macros.grouper != null ? macros.grouper : (macros.notation instanceof CompactNotation ? Grouper.minTwoDigits() : Grouper.defaults());
        micros.grouping = micros.grouping.withLocaleData(patternInfo);
        micros.padding = macros.padder != null ? macros.padder : Padder.NONE;
        micros.integerWidth = macros.integerWidth != null ? macros.integerWidth : IntegerWidth.DEFAULT;
        micros.sign = macros.sign != null ? macros.sign : NumberFormatter.SignDisplay.AUTO;
        micros.decimal = macros.decimal != null ? macros.decimal : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        micros.useCurrency = isCurrency;
        if (macros.notation instanceof ScientificNotation) {
            chain = ((ScientificNotation)macros.notation).withLocaleData(micros.symbols, safe, chain);
        } else {
            micros.modInner = ConstantAffixModifier.EMPTY;
        }
        MutablePatternModifier patternMod = new MutablePatternModifier(false);
        patternMod.setPatternInfo(macros.affixProvider != null ? macros.affixProvider : patternInfo);
        patternMod.setPatternAttributes(micros.sign, isPermille);
        if (patternMod.needsPlurals()) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            patternMod.setSymbols(micros.symbols, currency, unitWidth, rules);
        } else {
            patternMod.setSymbols(micros.symbols, currency, unitWidth, null);
        }
        chain = safe ? patternMod.createImmutableAndChain(chain) : patternMod.addToChain(chain);
        if (isCldrUnit) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            chain = LongNameHandler.forMeasureUnit(macros.loc, macros.unit, unitWidth, rules, chain);
        } else if (isCurrency && unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            chain = LongNameHandler.forCurrencyLongNames(macros.loc, currency, rules, chain);
        } else {
            micros.modOuter = ConstantAffixModifier.EMPTY;
        }
        if (macros.notation instanceof CompactNotation) {
            if (rules == null) {
                rules = PluralRules.forLocale(macros.loc);
            }
            CompactData.CompactType compactType = macros.unit instanceof Currency && macros.unitWidth != NumberFormatter.UnitWidth.FULL_NAME ? CompactData.CompactType.CURRENCY : CompactData.CompactType.DECIMAL;
            chain = ((CompactNotation)macros.notation).withLocaleData(macros.loc, nsName, compactType, rules, safe ? patternMod : null, chain);
        }
        return chain;
    }

    private static final void $$robo$$android_icu_number_NumberFormatterImpl$microsToString(MicroProps micros, DecimalQuantity quantity, NumberStringBuilder string2) {
        micros.rounding.apply(quantity);
        if (micros.integerWidth.maxInt == -1) {
            quantity.setIntegerLength(micros.integerWidth.minInt, Integer.MAX_VALUE);
        } else {
            quantity.setIntegerLength(micros.integerWidth.minInt, micros.integerWidth.maxInt);
        }
        int length = NumberFormatterImpl.writeNumber(micros, quantity, string2);
        length += micros.modInner.apply(string2, 0, length);
        if (micros.padding.isValid()) {
            micros.padding.padAndApply(micros.modMiddle, micros.modOuter, string2, 0, length);
        } else {
            length += micros.modMiddle.apply(string2, 0, length);
            length += micros.modOuter.apply(string2, 0, length);
        }
    }

    private static final int $$robo$$android_icu_number_NumberFormatterImpl$writeNumber(MicroProps micros, DecimalQuantity quantity, NumberStringBuilder string2) {
        int length = 0;
        if (quantity.isInfinite()) {
            length += string2.insert(length, micros.symbols.getInfinity(), NumberFormat.Field.INTEGER);
        } else if (quantity.isNaN()) {
            length += string2.insert(length, micros.symbols.getNaN(), NumberFormat.Field.INTEGER);
        } else {
            length += NumberFormatterImpl.writeIntegerDigits(micros, quantity, string2);
            if (quantity.getLowerDisplayMagnitude() < 0 || micros.decimal == NumberFormatter.DecimalSeparatorDisplay.ALWAYS) {
                length += string2.insert(length, micros.useCurrency ? micros.symbols.getMonetaryDecimalSeparatorString() : micros.symbols.getDecimalSeparatorString(), NumberFormat.Field.DECIMAL_SEPARATOR);
            }
            length += NumberFormatterImpl.writeFractionDigits(micros, quantity, string2);
        }
        return length;
    }

    private static final int $$robo$$android_icu_number_NumberFormatterImpl$writeIntegerDigits(MicroProps micros, DecimalQuantity quantity, NumberStringBuilder string2) {
        int length = 0;
        int integerCount = quantity.getUpperDisplayMagnitude() + 1;
        for (int i = 0; i < integerCount; ++i) {
            if (micros.grouping.groupAtPosition(i, quantity)) {
                length += string2.insert(0, micros.useCurrency ? micros.symbols.getMonetaryGroupingSeparatorString() : micros.symbols.getGroupingSeparatorString(), NumberFormat.Field.GROUPING_SEPARATOR);
            }
            byte nextDigit = quantity.getDigit(i);
            if (micros.symbols.getCodePointZero() != -1) {
                length += string2.insertCodePoint(0, micros.symbols.getCodePointZero() + nextDigit, NumberFormat.Field.INTEGER);
                continue;
            }
            length += string2.insert(0, micros.symbols.getDigitStringsLocal()[nextDigit], NumberFormat.Field.INTEGER);
        }
        return length;
    }

    private static final int $$robo$$android_icu_number_NumberFormatterImpl$writeFractionDigits(MicroProps micros, DecimalQuantity quantity, NumberStringBuilder string2) {
        int length = 0;
        int fractionCount = -quantity.getLowerDisplayMagnitude();
        for (int i = 0; i < fractionCount; ++i) {
            byte nextDigit = quantity.getDigit(-i - 1);
            if (micros.symbols.getCodePointZero() != -1) {
                length += string2.appendCodePoint(micros.symbols.getCodePointZero() + nextDigit, NumberFormat.Field.FRACTION);
                continue;
            }
            length += string2.append(micros.symbols.getDigitStringsLocal()[nextDigit], NumberFormat.Field.FRACTION);
        }
        return length;
    }

    static void __staticInitializer__() {
        DEFAULT_CURRENCY = Currency.getInstance("XXX");
    }

    public static NumberFormatterImpl fromMacros(MacroProps macroProps) {
        return InvokeDynamicSupport.bootstrapStatic("fromMacros", $$robo$$android_icu_number_NumberFormatterImpl$fromMacros(android.icu.impl.number.MacroProps ), 0, (MacroProps)macroProps);
    }

    public static MicroProps applyStatic(MacroProps macroProps, DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        return InvokeDynamicSupport.bootstrapStatic("applyStatic", $$robo$$android_icu_number_NumberFormatterImpl$applyStatic(android.icu.impl.number.MacroProps android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, (MacroProps)macroProps, (DecimalQuantity)decimalQuantity, (NumberStringBuilder)numberStringBuilder);
    }

    private void __constructor__(MicroPropsGenerator microPropsGenerator) {
        this.$$robo$$android_icu_number_NumberFormatterImpl$__constructor__(microPropsGenerator);
    }

    private NumberFormatterImpl(MicroPropsGenerator microPropsGenerator) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_NumberFormatterImpl$__constructor__(android.icu.impl.number.MicroPropsGenerator ), 0, this, microPropsGenerator);
    }

    public MicroProps apply(DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_NumberFormatterImpl$apply(android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, this, decimalQuantity, numberStringBuilder);
    }

    private static boolean unitIsCurrency(MeasureUnit measureUnit) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unitIsCurrency", $$robo$$android_icu_number_NumberFormatterImpl$unitIsCurrency(android.icu.util.MeasureUnit ), 0, (MeasureUnit)measureUnit);
    }

    private static boolean unitIsNoUnit(MeasureUnit measureUnit) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unitIsNoUnit", $$robo$$android_icu_number_NumberFormatterImpl$unitIsNoUnit(android.icu.util.MeasureUnit ), 0, (MeasureUnit)measureUnit);
    }

    private static boolean unitIsPercent(MeasureUnit measureUnit) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unitIsPercent", $$robo$$android_icu_number_NumberFormatterImpl$unitIsPercent(android.icu.util.MeasureUnit ), 0, (MeasureUnit)measureUnit);
    }

    private static boolean unitIsPermille(MeasureUnit measureUnit) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unitIsPermille", $$robo$$android_icu_number_NumberFormatterImpl$unitIsPermille(android.icu.util.MeasureUnit ), 0, (MeasureUnit)measureUnit);
    }

    private static MicroPropsGenerator macrosToMicroGenerator(MacroProps macroProps, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("macrosToMicroGenerator", $$robo$$android_icu_number_NumberFormatterImpl$macrosToMicroGenerator(android.icu.impl.number.MacroProps boolean ), 0, (MacroProps)macroProps, (boolean)bl);
    }

    private static void microsToString(MicroProps microProps, DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("microsToString", $$robo$$android_icu_number_NumberFormatterImpl$microsToString(android.icu.impl.number.MicroProps android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, (MicroProps)microProps, (DecimalQuantity)decimalQuantity, (NumberStringBuilder)numberStringBuilder);
    }

    private static int writeNumber(MicroProps microProps, DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeNumber", $$robo$$android_icu_number_NumberFormatterImpl$writeNumber(android.icu.impl.number.MicroProps android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, (MicroProps)microProps, (DecimalQuantity)decimalQuantity, (NumberStringBuilder)numberStringBuilder);
    }

    private static int writeIntegerDigits(MicroProps microProps, DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeIntegerDigits", $$robo$$android_icu_number_NumberFormatterImpl$writeIntegerDigits(android.icu.impl.number.MicroProps android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, (MicroProps)microProps, (DecimalQuantity)decimalQuantity, (NumberStringBuilder)numberStringBuilder);
    }

    private static int writeFractionDigits(MicroProps microProps, DecimalQuantity decimalQuantity, NumberStringBuilder numberStringBuilder) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeFractionDigits", $$robo$$android_icu_number_NumberFormatterImpl$writeFractionDigits(android.icu.impl.number.MicroProps android.icu.impl.number.DecimalQuantity android.icu.impl.number.NumberStringBuilder ), 0, (MicroProps)microProps, (DecimalQuantity)decimalQuantity, (NumberStringBuilder)numberStringBuilder);
    }

    static {
        RobolectricInternals.classInitializing(NumberFormatterImpl.class);
    }

    public /* synthetic */ NumberFormatterImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberFormatterImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

