/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MultiplierProducer;
import android.icu.impl.number.RoundingUtils;
import android.icu.number.CurrencyRounder;
import android.icu.number.FractionRounder;
import android.icu.util.Currency;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Rounder
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    MathContext mathContext;
    static InfiniteRounderImpl NONE;
    static FractionRounderImpl FIXED_FRAC_0;
    static FractionRounderImpl FIXED_FRAC_2;
    static FractionRounderImpl MAX_FRAC_6;
    static SignificantRounderImpl FIXED_SIG_2;
    static SignificantRounderImpl FIXED_SIG_3;
    static SignificantRounderImpl RANGE_SIG_2_3;
    static FracSigRounderImpl COMPACT_STRATEGY;
    static IncrementRounderImpl NICKEL;
    static CurrencyRounderImpl MONETARY_STANDARD;
    static CurrencyRounderImpl MONETARY_CASH;
    static PassThroughRounderImpl PASS_THROUGH;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_number_Rounder$__constructor__() {
        this.mathContext = RoundingUtils.mathContextUnlimited(RoundingUtils.DEFAULT_ROUNDING_MODE);
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$unlimited() {
        return Rounder.constructInfinite();
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$integer() {
        return Rounder.constructFraction(0, 0);
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$fixedFraction(int minMaxFractionPlaces) {
        if (minMaxFractionPlaces >= 0 && minMaxFractionPlaces <= 100) {
            return Rounder.constructFraction(minMaxFractionPlaces, minMaxFractionPlaces);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 100");
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$minFraction(int minFractionPlaces) {
        if (minFractionPlaces >= 0 && minFractionPlaces < 100) {
            return Rounder.constructFraction(minFractionPlaces, -1);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 100");
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$maxFraction(int maxFractionPlaces) {
        if (maxFractionPlaces >= 0 && maxFractionPlaces < 100) {
            return Rounder.constructFraction(0, maxFractionPlaces);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 100");
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$minMaxFraction(int minFractionPlaces, int maxFractionPlaces) {
        if (minFractionPlaces >= 0 && maxFractionPlaces <= 100 && minFractionPlaces <= maxFractionPlaces) {
            return Rounder.constructFraction(minFractionPlaces, maxFractionPlaces);
        }
        throw new IllegalArgumentException("Fraction length must be between 0 and 100");
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$fixedDigits(int minMaxSignificantDigits) {
        if (minMaxSignificantDigits > 0 && minMaxSignificantDigits <= 100) {
            return Rounder.constructSignificant(minMaxSignificantDigits, minMaxSignificantDigits);
        }
        throw new IllegalArgumentException("Significant digits must be between 0 and 100");
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$minDigits(int minSignificantDigits) {
        if (minSignificantDigits > 0 && minSignificantDigits <= 100) {
            return Rounder.constructSignificant(minSignificantDigits, -1);
        }
        throw new IllegalArgumentException("Significant digits must be between 0 and 100");
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$maxDigits(int maxSignificantDigits) {
        if (maxSignificantDigits > 0 && maxSignificantDigits <= 100) {
            return Rounder.constructSignificant(0, maxSignificantDigits);
        }
        throw new IllegalArgumentException("Significant digits must be between 0 and 100");
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$minMaxDigits(int minSignificantDigits, int maxSignificantDigits) {
        if (minSignificantDigits > 0 && maxSignificantDigits <= 100 && minSignificantDigits <= maxSignificantDigits) {
            return Rounder.constructSignificant(minSignificantDigits, maxSignificantDigits);
        }
        throw new IllegalArgumentException("Significant digits must be between 0 and 100");
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$increment(BigDecimal roundingIncrement) {
        if (roundingIncrement != null && roundingIncrement.compareTo(BigDecimal.ZERO) > 0) {
            return Rounder.constructIncrement(roundingIncrement);
        }
        throw new IllegalArgumentException("Rounding increment must be positive and non-null");
    }

    private static final CurrencyRounder $$robo$$android_icu_number_Rounder$currency(Currency.CurrencyUsage currencyUsage) {
        if (currencyUsage != null) {
            return Rounder.constructCurrency(currencyUsage);
        }
        throw new IllegalArgumentException("CurrencyUsage must be non-null");
    }

    private final Rounder $$robo$$android_icu_number_Rounder$withMode(RoundingMode roundingMode) {
        return this.withMode(RoundingUtils.mathContextUnlimited(roundingMode));
    }

    @Deprecated
    private final Rounder $$robo$$android_icu_number_Rounder$withMode(MathContext mathContext) {
        if (this.mathContext.equals(mathContext)) {
            return this;
        }
        Rounder other = (Rounder)this.clone();
        other.mathContext = mathContext;
        return other;
    }

    @Deprecated
    private final Object $$robo$$android_icu_number_Rounder$clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public abstract void apply(DecimalQuantity var1);

    private static final Rounder $$robo$$android_icu_number_Rounder$constructInfinite() {
        return NONE;
    }

    private static final FractionRounder $$robo$$android_icu_number_Rounder$constructFraction(int minFrac, int maxFrac) {
        if (minFrac == 0 && maxFrac == 0) {
            return FIXED_FRAC_0;
        }
        if (minFrac == 2 && maxFrac == 2) {
            return FIXED_FRAC_2;
        }
        if (minFrac == 0 && maxFrac == 6) {
            return MAX_FRAC_6;
        }
        return new FractionRounderImpl(minFrac, maxFrac);
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$constructSignificant(int minSig, int maxSig) {
        if (minSig == 2 && maxSig == 2) {
            return FIXED_SIG_2;
        }
        if (minSig == 3 && maxSig == 3) {
            return FIXED_SIG_3;
        }
        if (minSig == 2 && maxSig == 3) {
            return RANGE_SIG_2_3;
        }
        return new SignificantRounderImpl(minSig, maxSig);
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$constructFractionSignificant(FractionRounder base_, int minSig, int maxSig) {
        if (!$assertionsDisabled && !(base_ instanceof FractionRounderImpl)) {
            throw new AssertionError();
        }
        FractionRounderImpl base = (FractionRounderImpl)base_;
        if (base.minFrac == 0 && base.maxFrac == 0 && minSig == 2) {
            return COMPACT_STRATEGY;
        }
        return new FracSigRounderImpl(base.minFrac, base.maxFrac, minSig, maxSig);
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$constructIncrement(BigDecimal increment) {
        if (increment.equals(Rounder.NICKEL.increment)) {
            return NICKEL;
        }
        return new IncrementRounderImpl(increment);
    }

    private static final CurrencyRounder $$robo$$android_icu_number_Rounder$constructCurrency(Currency.CurrencyUsage usage) {
        if (usage == Currency.CurrencyUsage.STANDARD) {
            return MONETARY_STANDARD;
        }
        if (usage == Currency.CurrencyUsage.CASH) {
            return MONETARY_CASH;
        }
        throw new AssertionError();
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$constructFromCurrency(CurrencyRounder base_, Currency currency) {
        if (!$assertionsDisabled && !(base_ instanceof CurrencyRounderImpl)) {
            throw new AssertionError();
        }
        CurrencyRounderImpl base = (CurrencyRounderImpl)base_;
        double incrementDouble = currency.getRoundingIncrement(base.usage);
        if (incrementDouble != 0.0) {
            BigDecimal increment = BigDecimal.valueOf(incrementDouble);
            return Rounder.constructIncrement(increment);
        }
        int minMaxFrac = currency.getDefaultFractionDigits(base.usage);
        return Rounder.constructFraction(minMaxFrac, minMaxFrac);
    }

    private static final Rounder $$robo$$android_icu_number_Rounder$constructPassThrough() {
        return PASS_THROUGH;
    }

    private final Rounder $$robo$$android_icu_number_Rounder$withLocaleData(Currency currency) {
        if (this instanceof CurrencyRounder) {
            return ((CurrencyRounder)this).withCurrency(currency);
        }
        return this;
    }

    private final int $$robo$$android_icu_number_Rounder$chooseMultiplierAndApply(DecimalQuantity input, MultiplierProducer producer) {
        DecimalQuantity copy = input.createCopy();
        if (!$assertionsDisabled && input.isZero()) {
            throw new AssertionError();
        }
        int magnitude = input.getMagnitude();
        int multiplier = producer.getMultiplier(magnitude);
        input.adjustMagnitude(multiplier);
        this.apply(input);
        if (!input.isZero() && input.getMagnitude() == magnitude + multiplier + 1) {
            input.copyFrom(copy);
            multiplier = producer.getMultiplier(++magnitude);
            input.adjustMagnitude(multiplier);
            if (!$assertionsDisabled && input.getMagnitude() != magnitude + multiplier - 1) {
                throw new AssertionError();
            }
            this.apply(input);
            if (!$assertionsDisabled && input.getMagnitude() != magnitude + multiplier) {
                throw new AssertionError();
            }
        }
        return multiplier;
    }

    private static final int $$robo$$android_icu_number_Rounder$getRoundingMagnitudeFraction(int maxFrac) {
        if (maxFrac == -1) {
            return Integer.MIN_VALUE;
        }
        return -maxFrac;
    }

    private static final int $$robo$$android_icu_number_Rounder$getRoundingMagnitudeSignificant(DecimalQuantity value, int maxSig) {
        if (maxSig == -1) {
            return Integer.MIN_VALUE;
        }
        int magnitude = value.isZero() ? 0 : value.getMagnitude();
        return magnitude - maxSig + 1;
    }

    private static final int $$robo$$android_icu_number_Rounder$getDisplayMagnitudeFraction(int minFrac) {
        if (minFrac == 0) {
            return Integer.MAX_VALUE;
        }
        return -minFrac;
    }

    private static final int $$robo$$android_icu_number_Rounder$getDisplayMagnitudeSignificant(DecimalQuantity value, int minSig) {
        int magnitude = value.isZero() ? 0 : value.getMagnitude();
        return magnitude - minSig + 1;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !Rounder.class.desiredAssertionStatus();
        NONE = new InfiniteRounderImpl();
        FIXED_FRAC_0 = new FractionRounderImpl(0, 0);
        FIXED_FRAC_2 = new FractionRounderImpl(2, 2);
        MAX_FRAC_6 = new FractionRounderImpl(0, 6);
        FIXED_SIG_2 = new SignificantRounderImpl(2, 2);
        FIXED_SIG_3 = new SignificantRounderImpl(3, 3);
        RANGE_SIG_2_3 = new SignificantRounderImpl(2, 3);
        COMPACT_STRATEGY = new FracSigRounderImpl(0, 0, 2, -1);
        NICKEL = new IncrementRounderImpl(BigDecimal.valueOf(0.05));
        MONETARY_STANDARD = new CurrencyRounderImpl(Currency.CurrencyUsage.STANDARD);
        MONETARY_CASH = new CurrencyRounderImpl(Currency.CurrencyUsage.CASH);
        PASS_THROUGH = new PassThroughRounderImpl();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_number_Rounder$__constructor__();
    }

    Rounder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder$__constructor__(), 0, this);
    }

    public static Rounder unlimited() {
        return InvokeDynamicSupport.bootstrapStatic("unlimited", $$robo$$android_icu_number_Rounder$unlimited(), 0);
    }

    public static FractionRounder integer() {
        return InvokeDynamicSupport.bootstrapStatic("integer", $$robo$$android_icu_number_Rounder$integer(), 0);
    }

    public static FractionRounder fixedFraction(int n) {
        return InvokeDynamicSupport.bootstrapStatic("fixedFraction", $$robo$$android_icu_number_Rounder$fixedFraction(int ), 0, (int)n);
    }

    public static FractionRounder minFraction(int n) {
        return InvokeDynamicSupport.bootstrapStatic("minFraction", $$robo$$android_icu_number_Rounder$minFraction(int ), 0, (int)n);
    }

    public static FractionRounder maxFraction(int n) {
        return InvokeDynamicSupport.bootstrapStatic("maxFraction", $$robo$$android_icu_number_Rounder$maxFraction(int ), 0, (int)n);
    }

    public static FractionRounder minMaxFraction(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("minMaxFraction", $$robo$$android_icu_number_Rounder$minMaxFraction(int int ), 0, (int)n, (int)n2);
    }

    public static Rounder fixedDigits(int n) {
        return InvokeDynamicSupport.bootstrapStatic("fixedDigits", $$robo$$android_icu_number_Rounder$fixedDigits(int ), 0, (int)n);
    }

    public static Rounder minDigits(int n) {
        return InvokeDynamicSupport.bootstrapStatic("minDigits", $$robo$$android_icu_number_Rounder$minDigits(int ), 0, (int)n);
    }

    public static Rounder maxDigits(int n) {
        return InvokeDynamicSupport.bootstrapStatic("maxDigits", $$robo$$android_icu_number_Rounder$maxDigits(int ), 0, (int)n);
    }

    public static Rounder minMaxDigits(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("minMaxDigits", $$robo$$android_icu_number_Rounder$minMaxDigits(int int ), 0, (int)n, (int)n2);
    }

    public static Rounder increment(BigDecimal bigDecimal) {
        return InvokeDynamicSupport.bootstrapStatic("increment", $$robo$$android_icu_number_Rounder$increment(java.math.BigDecimal ), 0, (BigDecimal)bigDecimal);
    }

    public static CurrencyRounder currency(Currency.CurrencyUsage currencyUsage) {
        return InvokeDynamicSupport.bootstrapStatic("currency", $$robo$$android_icu_number_Rounder$currency(android.icu.util.Currency$CurrencyUsage ), 0, (Currency.CurrencyUsage)currencyUsage);
    }

    public Rounder withMode(RoundingMode roundingMode) {
        return InvokeDynamicSupport.bootstrap("withMode", $$robo$$android_icu_number_Rounder$withMode(java.math.RoundingMode ), 0, this, roundingMode);
    }

    @Deprecated
    public Rounder withMode(MathContext mathContext) {
        return InvokeDynamicSupport.bootstrap("withMode", $$robo$$android_icu_number_Rounder$withMode(java.math.MathContext ), 0, this, mathContext);
    }

    @Deprecated
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_number_Rounder$clone(), 0, this);
    }

    static Rounder constructInfinite() {
        return InvokeDynamicSupport.bootstrapStatic("constructInfinite", $$robo$$android_icu_number_Rounder$constructInfinite(), 0);
    }

    static FractionRounder constructFraction(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("constructFraction", $$robo$$android_icu_number_Rounder$constructFraction(int int ), 0, (int)n, (int)n2);
    }

    static Rounder constructSignificant(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("constructSignificant", $$robo$$android_icu_number_Rounder$constructSignificant(int int ), 0, (int)n, (int)n2);
    }

    static Rounder constructFractionSignificant(FractionRounder fractionRounder, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("constructFractionSignificant", $$robo$$android_icu_number_Rounder$constructFractionSignificant(android.icu.number.FractionRounder int int ), 0, (FractionRounder)fractionRounder, (int)n, (int)n2);
    }

    static Rounder constructIncrement(BigDecimal bigDecimal) {
        return InvokeDynamicSupport.bootstrapStatic("constructIncrement", $$robo$$android_icu_number_Rounder$constructIncrement(java.math.BigDecimal ), 0, (BigDecimal)bigDecimal);
    }

    static CurrencyRounder constructCurrency(Currency.CurrencyUsage currencyUsage) {
        return InvokeDynamicSupport.bootstrapStatic("constructCurrency", $$robo$$android_icu_number_Rounder$constructCurrency(android.icu.util.Currency$CurrencyUsage ), 0, (Currency.CurrencyUsage)currencyUsage);
    }

    static Rounder constructFromCurrency(CurrencyRounder currencyRounder, Currency currency) {
        return InvokeDynamicSupport.bootstrapStatic("constructFromCurrency", $$robo$$android_icu_number_Rounder$constructFromCurrency(android.icu.number.CurrencyRounder android.icu.util.Currency ), 0, (CurrencyRounder)currencyRounder, (Currency)currency);
    }

    static Rounder constructPassThrough() {
        return InvokeDynamicSupport.bootstrapStatic("constructPassThrough", $$robo$$android_icu_number_Rounder$constructPassThrough(), 0);
    }

    Rounder withLocaleData(Currency currency) {
        return InvokeDynamicSupport.bootstrap("withLocaleData", $$robo$$android_icu_number_Rounder$withLocaleData(android.icu.util.Currency ), 0, this, currency);
    }

    int chooseMultiplierAndApply(DecimalQuantity decimalQuantity, MultiplierProducer multiplierProducer) {
        return (int)InvokeDynamicSupport.bootstrap("chooseMultiplierAndApply", $$robo$$android_icu_number_Rounder$chooseMultiplierAndApply(android.icu.impl.number.DecimalQuantity android.icu.impl.number.MultiplierProducer ), 0, this, decimalQuantity, multiplierProducer);
    }

    private static int getRoundingMagnitudeFraction(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRoundingMagnitudeFraction", $$robo$$android_icu_number_Rounder$getRoundingMagnitudeFraction(int ), 0, (int)n);
    }

    private static int getRoundingMagnitudeSignificant(DecimalQuantity decimalQuantity, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRoundingMagnitudeSignificant", $$robo$$android_icu_number_Rounder$getRoundingMagnitudeSignificant(android.icu.impl.number.DecimalQuantity int ), 0, (DecimalQuantity)decimalQuantity, (int)n);
    }

    private static int getDisplayMagnitudeFraction(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDisplayMagnitudeFraction", $$robo$$android_icu_number_Rounder$getDisplayMagnitudeFraction(int ), 0, (int)n);
    }

    private static int getDisplayMagnitudeSignificant(DecimalQuantity decimalQuantity, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDisplayMagnitudeSignificant", $$robo$$android_icu_number_Rounder$getDisplayMagnitudeSignificant(android.icu.impl.number.DecimalQuantity int ), 0, (DecimalQuantity)decimalQuantity, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(Rounder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rounder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PassThroughRounderImpl
    extends Rounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_number_Rounder_PassThroughRounderImpl$__constructor__() {
        }

        private final void $$robo$$android_icu_number_Rounder_PassThroughRounderImpl$apply(DecimalQuantity value) {
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_number_Rounder_PassThroughRounderImpl$__constructor__();
        }

        public PassThroughRounderImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_PassThroughRounderImpl$__constructor__(), 0, this);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_PassThroughRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PassThroughRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CurrencyRounderImpl
    extends CurrencyRounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Currency.CurrencyUsage usage;

        private void $$robo$$android_icu_number_Rounder_CurrencyRounderImpl$__constructor__(Currency.CurrencyUsage usage) {
            this.usage = usage;
        }

        private final void $$robo$$android_icu_number_Rounder_CurrencyRounderImpl$apply(DecimalQuantity value) {
            throw new AssertionError();
        }

        private void __constructor__(Currency.CurrencyUsage currencyUsage) {
            this.$$robo$$android_icu_number_Rounder_CurrencyRounderImpl$__constructor__(currencyUsage);
        }

        public CurrencyRounderImpl(Currency.CurrencyUsage currencyUsage) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_CurrencyRounderImpl$__constructor__(android.icu.util.Currency$CurrencyUsage ), 0, this, currencyUsage);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_CurrencyRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public /* synthetic */ CurrencyRounderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CurrencyRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class IncrementRounderImpl
    extends Rounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        BigDecimal increment;

        private void $$robo$$android_icu_number_Rounder_IncrementRounderImpl$__constructor__(BigDecimal increment) {
            this.increment = increment;
        }

        private final void $$robo$$android_icu_number_Rounder_IncrementRounderImpl$apply(DecimalQuantity value) {
            value.roundToIncrement(this.increment, this.mathContext);
            value.setFractionLength(this.increment.scale(), this.increment.scale());
        }

        private void __constructor__(BigDecimal bigDecimal) {
            this.$$robo$$android_icu_number_Rounder_IncrementRounderImpl$__constructor__(bigDecimal);
        }

        public IncrementRounderImpl(BigDecimal bigDecimal) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_IncrementRounderImpl$__constructor__(java.math.BigDecimal ), 0, this, bigDecimal);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_IncrementRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public /* synthetic */ IncrementRounderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IncrementRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FracSigRounderImpl
    extends Rounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int minFrac;
        int maxFrac;
        int minSig;
        int maxSig;

        private void $$robo$$android_icu_number_Rounder_FracSigRounderImpl$__constructor__(int minFrac, int maxFrac, int minSig, int maxSig) {
            this.minFrac = minFrac;
            this.maxFrac = maxFrac;
            this.minSig = minSig;
            this.maxSig = maxSig;
        }

        private final void $$robo$$android_icu_number_Rounder_FracSigRounderImpl$apply(DecimalQuantity value) {
            int displayMag = Rounder.getDisplayMagnitudeFraction(this.minFrac);
            int roundingMag = Rounder.getRoundingMagnitudeFraction(this.maxFrac);
            if (this.minSig == -1) {
                int candidate = Rounder.getRoundingMagnitudeSignificant(value, this.maxSig);
                roundingMag = Math.max(roundingMag, candidate);
            } else {
                int candidate = Rounder.getDisplayMagnitudeSignificant(value, this.minSig);
                roundingMag = Math.min(roundingMag, candidate);
            }
            value.roundToMagnitude(roundingMag, this.mathContext);
            value.setFractionLength(Math.max(0, -displayMag), Integer.MAX_VALUE);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_icu_number_Rounder_FracSigRounderImpl$__constructor__(n, n2, n3, n4);
        }

        public FracSigRounderImpl(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_FracSigRounderImpl$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_FracSigRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public /* synthetic */ FracSigRounderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FracSigRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SignificantRounderImpl
    extends Rounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int minSig;
        int maxSig;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_number_Rounder_SignificantRounderImpl$__constructor__(int minSig, int maxSig) {
            this.minSig = minSig;
            this.maxSig = maxSig;
        }

        private final void $$robo$$android_icu_number_Rounder_SignificantRounderImpl$apply(DecimalQuantity value) {
            value.roundToMagnitude(Rounder.getRoundingMagnitudeSignificant(value, this.maxSig), this.mathContext);
            value.setFractionLength(Math.max(0, -Rounder.getDisplayMagnitudeSignificant(value, this.minSig)), Integer.MAX_VALUE);
        }

        private final void $$robo$$android_icu_number_Rounder_SignificantRounderImpl$apply(DecimalQuantity quantity, int minInt) {
            if (!$assertionsDisabled && !quantity.isZero()) {
                throw new AssertionError();
            }
            quantity.setFractionLength(this.minSig - minInt, Integer.MAX_VALUE);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !Rounder.class.desiredAssertionStatus();
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_icu_number_Rounder_SignificantRounderImpl$__constructor__(n, n2);
        }

        public SignificantRounderImpl(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_SignificantRounderImpl$__constructor__(int int ), 0, this, n, n2);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_SignificantRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public void apply(DecimalQuantity decimalQuantity, int n) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_SignificantRounderImpl$apply(android.icu.impl.number.DecimalQuantity int ), 0, this, decimalQuantity, n);
        }

        static {
            RobolectricInternals.classInitializing(SignificantRounderImpl.class);
        }

        public /* synthetic */ SignificantRounderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignificantRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FractionRounderImpl
    extends FractionRounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int minFrac;
        int maxFrac;

        private void $$robo$$android_icu_number_Rounder_FractionRounderImpl$__constructor__(int minFrac, int maxFrac) {
            this.minFrac = minFrac;
            this.maxFrac = maxFrac;
        }

        private final void $$robo$$android_icu_number_Rounder_FractionRounderImpl$apply(DecimalQuantity value) {
            value.roundToMagnitude(Rounder.getRoundingMagnitudeFraction(this.maxFrac), this.mathContext);
            value.setFractionLength(Math.max(0, -Rounder.getDisplayMagnitudeFraction(this.minFrac)), Integer.MAX_VALUE);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_icu_number_Rounder_FractionRounderImpl$__constructor__(n, n2);
        }

        public FractionRounderImpl(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_FractionRounderImpl$__constructor__(int int ), 0, this, n, n2);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_FractionRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        public /* synthetic */ FractionRounderImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FractionRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InfiniteRounderImpl
    extends Rounder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_number_Rounder_InfiniteRounderImpl$__constructor__() {
        }

        private final void $$robo$$android_icu_number_Rounder_InfiniteRounderImpl$apply(DecimalQuantity value) {
            value.roundToInfinity();
            value.setFractionLength(0, Integer.MAX_VALUE);
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_icu_number_Rounder_InfiniteRounderImpl$__constructor__();
        }

        public InfiniteRounderImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_Rounder_InfiniteRounderImpl$__constructor__(), 0, this);
        }

        @Override
        public void apply(DecimalQuantity decimalQuantity) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_Rounder_InfiniteRounderImpl$apply(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InfiniteRounderImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

