/*
 * Decompiled with CFR 0.152.
 */
package android.icu.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.Modifier;
import android.icu.impl.number.MultiplierProducer;
import android.icu.impl.number.NumberStringBuilder;
import android.icu.number.Notation;
import android.icu.number.NumberFormatter;
import android.icu.number.Rounder;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScientificNotation
extends Notation
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    int engineeringInterval;
    boolean requireMinInt;
    int minExponentDigits;
    NumberFormatter.SignDisplay exponentSignDisplay;

    private void $$robo$$android_icu_number_ScientificNotation$__constructor__(int engineeringInterval, boolean requireMinInt, int minExponentDigits, NumberFormatter.SignDisplay exponentSignDisplay) {
        this.engineeringInterval = engineeringInterval;
        this.requireMinInt = requireMinInt;
        this.minExponentDigits = minExponentDigits;
        this.exponentSignDisplay = exponentSignDisplay;
    }

    private final ScientificNotation $$robo$$android_icu_number_ScientificNotation$withMinExponentDigits(int minExponentDigits) {
        if (minExponentDigits >= 0 && minExponentDigits < 100) {
            ScientificNotation other = (ScientificNotation)this.clone();
            other.minExponentDigits = minExponentDigits;
            return other;
        }
        throw new IllegalArgumentException("Integer digits must be between 0 and 100");
    }

    private final ScientificNotation $$robo$$android_icu_number_ScientificNotation$withExponentSignDisplay(NumberFormatter.SignDisplay exponentSignDisplay) {
        ScientificNotation other = (ScientificNotation)this.clone();
        other.exponentSignDisplay = exponentSignDisplay;
        return other;
    }

    @Deprecated
    private final Object $$robo$$android_icu_number_ScientificNotation$clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final MicroPropsGenerator $$robo$$android_icu_number_ScientificNotation$withLocaleData(DecimalFormatSymbols symbols, boolean build, MicroPropsGenerator parent) {
        return new ScientificHandler(this, symbols, build, parent);
    }

    private void __constructor__(int n, boolean bl, int n2, NumberFormatter.SignDisplay signDisplay) {
        this.$$robo$$android_icu_number_ScientificNotation$__constructor__(n, bl, n2, signDisplay);
    }

    ScientificNotation(int n, boolean bl, int n2, NumberFormatter.SignDisplay signDisplay) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_ScientificNotation$__constructor__(int boolean int android.icu.number.NumberFormatter$SignDisplay ), 0, this, n, bl, n2, signDisplay);
    }

    public ScientificNotation withMinExponentDigits(int n) {
        return InvokeDynamicSupport.bootstrap("withMinExponentDigits", $$robo$$android_icu_number_ScientificNotation$withMinExponentDigits(int ), 0, this, n);
    }

    public ScientificNotation withExponentSignDisplay(NumberFormatter.SignDisplay signDisplay) {
        return InvokeDynamicSupport.bootstrap("withExponentSignDisplay", $$robo$$android_icu_number_ScientificNotation$withExponentSignDisplay(android.icu.number.NumberFormatter$SignDisplay ), 0, this, signDisplay);
    }

    @Deprecated
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_number_ScientificNotation$clone(), 0, this);
    }

    MicroPropsGenerator withLocaleData(DecimalFormatSymbols decimalFormatSymbols, boolean bl, MicroPropsGenerator microPropsGenerator) {
        return InvokeDynamicSupport.bootstrap("withLocaleData", $$robo$$android_icu_number_ScientificNotation$withLocaleData(android.icu.text.DecimalFormatSymbols boolean android.icu.impl.number.MicroPropsGenerator ), 0, this, decimalFormatSymbols, bl, microPropsGenerator);
    }

    public /* synthetic */ ScientificNotation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScientificNotation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ScientificModifier
    implements Modifier,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int exponent;
        ScientificHandler handler;

        private void $$robo$$android_icu_number_ScientificNotation_ScientificModifier$__constructor__(int exponent, ScientificHandler handler) {
            this.exponent = exponent;
            this.handler = handler;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificModifier$apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
            return this.handler.doApply(this.exponent, output, rightIndex);
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificModifier$getPrefixLength() {
            return 0;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificModifier$getCodePointCount() {
            throw new AssertionError();
        }

        private final boolean $$robo$$android_icu_number_ScientificNotation_ScientificModifier$isStrong() {
            return true;
        }

        private void __constructor__(int n, ScientificHandler scientificHandler) {
            this.$$robo$$android_icu_number_ScientificNotation_ScientificModifier$__constructor__(n, scientificHandler);
        }

        ScientificModifier(int n, ScientificHandler scientificHandler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_ScientificNotation_ScientificModifier$__constructor__(int android.icu.number.ScientificNotation$ScientificHandler ), 0, this, n, scientificHandler);
        }

        @Override
        public int apply(NumberStringBuilder numberStringBuilder, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_ScientificNotation_ScientificModifier$apply(android.icu.impl.number.NumberStringBuilder int int ), 0, this, numberStringBuilder, n, n2);
        }

        @Override
        public int getPrefixLength() {
            return (int)InvokeDynamicSupport.bootstrap("getPrefixLength", $$robo$$android_icu_number_ScientificNotation_ScientificModifier$getPrefixLength(), 0, this);
        }

        @Override
        public int getCodePointCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCodePointCount", $$robo$$android_icu_number_ScientificNotation_ScientificModifier$getCodePointCount(), 0, this);
        }

        @Override
        public boolean isStrong() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStrong", $$robo$$android_icu_number_ScientificNotation_ScientificModifier$isStrong(), 0, this);
        }

        public /* synthetic */ ScientificModifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScientificModifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ScientificHandler
    implements MicroPropsGenerator,
    MultiplierProducer,
    Modifier,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ScientificNotation notation;
        DecimalFormatSymbols symbols;
        ScientificModifier[] precomputedMods;
        MicroPropsGenerator parent;
        int exponent;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_number_ScientificNotation_ScientificHandler$__constructor__(ScientificNotation notation, DecimalFormatSymbols symbols, boolean safe, MicroPropsGenerator parent) {
            this.notation = notation;
            this.symbols = symbols;
            this.parent = parent;
            if (safe) {
                this.precomputedMods = new ScientificModifier[25];
                for (int i = -12; i <= 12; ++i) {
                    this.precomputedMods[i + 12] = new ScientificModifier(i, this);
                }
            } else {
                this.precomputedMods = null;
            }
        }

        private final MicroProps $$robo$$android_icu_number_ScientificNotation_ScientificHandler$processQuantity(DecimalQuantity quantity) {
            int exponent;
            MicroProps micros = this.parent.processQuantity(quantity);
            if (!$assertionsDisabled && micros.rounding == null) {
                throw new AssertionError();
            }
            if (quantity.isZero()) {
                if (this.notation.requireMinInt && micros.rounding instanceof Rounder.SignificantRounderImpl) {
                    ((Rounder.SignificantRounderImpl)micros.rounding).apply(quantity, this.notation.engineeringInterval);
                    exponent = 0;
                } else {
                    micros.rounding.apply(quantity);
                    exponent = 0;
                }
            } else {
                exponent = -micros.rounding.chooseMultiplierAndApply(quantity, this);
            }
            if (this.precomputedMods != null && exponent >= -12 && exponent <= 12) {
                micros.modInner = this.precomputedMods[exponent + 12];
            } else if (this.precomputedMods != null) {
                micros.modInner = new ScientificModifier(exponent, this);
            } else {
                this.exponent = exponent;
                micros.modInner = this;
            }
            micros.rounding = Rounder.constructPassThrough();
            return micros;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getMultiplier(int magnitude) {
            int interval = this.notation.engineeringInterval;
            int digitsShown = this.notation.requireMinInt ? interval : (interval <= 1 ? 1 : (magnitude % interval + interval) % interval + 1);
            return digitsShown - magnitude - 1;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getPrefixLength() {
            return 0;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getCodePointCount() {
            throw new AssertionError();
        }

        private final boolean $$robo$$android_icu_number_ScientificNotation_ScientificHandler$isStrong() {
            return true;
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificHandler$apply(NumberStringBuilder output, int leftIndex, int rightIndex) {
            return this.doApply(this.exponent, output, rightIndex);
        }

        private final int $$robo$$android_icu_number_ScientificNotation_ScientificHandler$doApply(int exponent, NumberStringBuilder output, int rightIndex) {
            int i = rightIndex;
            i += output.insert(i, this.symbols.getExponentSeparator(), NumberFormat.Field.EXPONENT_SYMBOL);
            if (exponent < 0 && this.notation.exponentSignDisplay != NumberFormatter.SignDisplay.NEVER) {
                i += output.insert(i, this.symbols.getMinusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            } else if (exponent >= 0 && this.notation.exponentSignDisplay == NumberFormatter.SignDisplay.ALWAYS) {
                i += output.insert(i, this.symbols.getPlusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            }
            int disp = Math.abs(exponent);
            for (int j = 0; j < this.notation.minExponentDigits || disp > 0; ++j, disp /= 10) {
                int d = disp % 10;
                String digitString = this.symbols.getDigitStringsLocal()[d];
                i += output.insert(i - j, digitString, NumberFormat.Field.EXPONENT);
            }
            return i - rightIndex;
        }

        private /* synthetic */ void $$robo$$android_icu_number_ScientificNotation_ScientificHandler$__constructor__(ScientificNotation x0, DecimalFormatSymbols x1, boolean x2, MicroPropsGenerator x3, 1 x4) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ScientificNotation.class.desiredAssertionStatus();
        }

        private void __constructor__(ScientificNotation scientificNotation, DecimalFormatSymbols decimalFormatSymbols, boolean bl, MicroPropsGenerator microPropsGenerator) {
            this.$$robo$$android_icu_number_ScientificNotation_ScientificHandler$__constructor__(scientificNotation, decimalFormatSymbols, bl, microPropsGenerator);
        }

        private ScientificHandler(ScientificNotation scientificNotation, DecimalFormatSymbols decimalFormatSymbols, boolean bl, MicroPropsGenerator microPropsGenerator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$__constructor__(android.icu.number.ScientificNotation android.icu.text.DecimalFormatSymbols boolean android.icu.impl.number.MicroPropsGenerator ), 0, this, scientificNotation, decimalFormatSymbols, bl, microPropsGenerator);
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
            return InvokeDynamicSupport.bootstrap("processQuantity", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$processQuantity(android.icu.impl.number.DecimalQuantity ), 0, this, decimalQuantity);
        }

        @Override
        public int getMultiplier(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getMultiplier", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getMultiplier(int ), 0, this, n);
        }

        @Override
        public int getPrefixLength() {
            return (int)InvokeDynamicSupport.bootstrap("getPrefixLength", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getPrefixLength(), 0, this);
        }

        @Override
        public int getCodePointCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCodePointCount", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$getCodePointCount(), 0, this);
        }

        @Override
        public boolean isStrong() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStrong", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$isStrong(), 0, this);
        }

        @Override
        public int apply(NumberStringBuilder numberStringBuilder, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$apply(android.icu.impl.number.NumberStringBuilder int int ), 0, this, numberStringBuilder, n, n2);
        }

        private int doApply(int n, NumberStringBuilder numberStringBuilder, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("doApply", $$robo$$android_icu_number_ScientificNotation_ScientificHandler$doApply(int android.icu.impl.number.NumberStringBuilder int ), 0, this, n, numberStringBuilder, n2);
        }

        private /* synthetic */ void __constructor__(ScientificNotation scientificNotation, DecimalFormatSymbols decimalFormatSymbols, boolean bl, MicroPropsGenerator microPropsGenerator, 1 var5_5) {
            this.$$robo$$android_icu_number_ScientificNotation_ScientificHandler$__constructor__(scientificNotation, decimalFormatSymbols, bl, microPropsGenerator, var5_5);
        }

        static {
            RobolectricInternals.classInitializing(ScientificHandler.class);
        }

        public /* synthetic */ ScientificHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScientificHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

