/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.text.Replaceable;
import android.icu.text.Transliterator;
import android.icu.text.UTF16;
import android.icu.text.UnicodeFilter;
import android.icu.text.UnicodeSet;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.text.CharacterIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BreakTransliterator
extends Transliterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private BreakIterator bi;
    private String insertion;
    private int[] boundaries;
    private int boundaryCount;
    static int LETTER_OR_MARK_MASK = 510;

    private void $$robo$$android_icu_text_BreakTransliterator$__constructor__(String ID, UnicodeFilter filter, BreakIterator bi, String insertion) {
        this.boundaries = new int[50];
        this.boundaryCount = 0;
        this.bi = bi;
        this.insertion = insertion;
    }

    private void $$robo$$android_icu_text_BreakTransliterator$__constructor__(String ID, UnicodeFilter filter) {
    }

    private final String $$robo$$android_icu_text_BreakTransliterator$getInsertion() {
        return this.insertion;
    }

    private final void $$robo$$android_icu_text_BreakTransliterator$setInsertion(String insertion) {
        this.insertion = insertion;
    }

    private final BreakIterator $$robo$$android_icu_text_BreakTransliterator$getBreakIterator() {
        if (this.bi == null) {
            this.bi = BreakIterator.getWordInstance(new ULocale("th_TH"));
        }
        return this.bi;
    }

    private final void $$robo$$android_icu_text_BreakTransliterator$setBreakIterator(BreakIterator bi) {
        this.bi = bi;
    }

    private final synchronized void $$robo$$android_icu_text_BreakTransliterator$handleTransliterate(Replaceable text, Transliterator.Position pos, boolean incremental) {
        this.boundaryCount = 0;
        int boundary = 0;
        this.getBreakIterator();
        this.bi.setText(new ReplaceableCharacterIterator(text, pos.start, pos.limit, pos.start));
        boundary = this.bi.first();
        while (boundary != -1 && boundary < pos.limit) {
            int cp;
            int type;
            if (boundary != 0 && (1 << (type = UCharacter.getType(cp = UTF16.charAt(text, boundary - 1))) & 0x1FE) != 0 && (1 << (type = UCharacter.getType(cp = UTF16.charAt(text, boundary))) & 0x1FE) != 0) {
                if (this.boundaryCount >= this.boundaries.length) {
                    int[] temp = new int[this.boundaries.length * 2];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.boundaries, (int)0, (Object)temp, (int)0, (int)this.boundaries.length);
                    this.boundaries = temp;
                }
                this.boundaries[this.boundaryCount++] = boundary;
            }
            boundary = this.bi.next();
        }
        int delta = 0;
        int lastBoundary = 0;
        if (this.boundaryCount != 0) {
            delta = this.boundaryCount * this.insertion.length();
            lastBoundary = this.boundaries[this.boundaryCount - 1];
            while (this.boundaryCount > 0) {
                boundary = this.boundaries[--this.boundaryCount];
                text.replace(boundary, boundary, this.insertion);
            }
        }
        pos.contextLimit += delta;
        pos.limit += delta;
        pos.start = incremental ? lastBoundary + delta : pos.limit;
    }

    private static final void $$robo$$android_icu_text_BreakTransliterator$register() {
        BreakTransliterator trans = new BreakTransliterator("Any-BreakInternal", null);
        Transliterator.registerInstance(trans, false);
    }

    private final void $$robo$$android_icu_text_BreakTransliterator$addSourceTargetSet(UnicodeSet inputFilter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet myFilter = this.getFilterAsUnicodeSet(inputFilter);
        if (myFilter.size() != 0) {
            targetSet.addAll(this.insertion);
        }
    }

    private void __constructor__(String string2, UnicodeFilter unicodeFilter, BreakIterator breakIterator, String string3) {
        this.$$robo$$android_icu_text_BreakTransliterator$__constructor__(string2, unicodeFilter, breakIterator, string3);
    }

    public BreakTransliterator(String string2, UnicodeFilter unicodeFilter, BreakIterator breakIterator, String string3) {
        super(string2, unicodeFilter);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakTransliterator$__constructor__(java.lang.String android.icu.text.UnicodeFilter android.icu.text.BreakIterator java.lang.String ), 0, this, string2, unicodeFilter, breakIterator, string3);
    }

    private void __constructor__(String string2, UnicodeFilter unicodeFilter) {
        this.$$robo$$android_icu_text_BreakTransliterator$__constructor__(string2, unicodeFilter);
    }

    public BreakTransliterator(String string2, UnicodeFilter unicodeFilter) {
        this(string2, unicodeFilter, null, " ");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakTransliterator$__constructor__(java.lang.String android.icu.text.UnicodeFilter ), 0, this, string2, unicodeFilter);
    }

    public String getInsertion() {
        return InvokeDynamicSupport.bootstrap("getInsertion", $$robo$$android_icu_text_BreakTransliterator$getInsertion(), 0, this);
    }

    public void setInsertion(String string2) {
        InvokeDynamicSupport.bootstrap("setInsertion", $$robo$$android_icu_text_BreakTransliterator$setInsertion(java.lang.String ), 0, this, string2);
    }

    public BreakIterator getBreakIterator() {
        return InvokeDynamicSupport.bootstrap("getBreakIterator", $$robo$$android_icu_text_BreakTransliterator$getBreakIterator(), 0, this);
    }

    public void setBreakIterator(BreakIterator breakIterator) {
        InvokeDynamicSupport.bootstrap("setBreakIterator", $$robo$$android_icu_text_BreakTransliterator$setBreakIterator(android.icu.text.BreakIterator ), 0, this, breakIterator);
    }

    @Override
    protected synchronized void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl) {
        InvokeDynamicSupport.bootstrap("handleTransliterate", $$robo$$android_icu_text_BreakTransliterator$handleTransliterate(android.icu.text.Replaceable android.icu.text.Transliterator$Position boolean ), 0, this, replaceable, position, bl);
    }

    static void register() {
        InvokeDynamicSupport.bootstrapStatic("register", $$robo$$android_icu_text_BreakTransliterator$register(), 0);
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        InvokeDynamicSupport.bootstrap("addSourceTargetSet", $$robo$$android_icu_text_BreakTransliterator$addSourceTargetSet(android.icu.text.UnicodeSet android.icu.text.UnicodeSet android.icu.text.UnicodeSet ), 0, this, unicodeSet, unicodeSet2, unicodeSet3);
    }

    public /* synthetic */ BreakTransliterator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BreakTransliterator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ReplaceableCharacterIterator
    implements CharacterIterator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Replaceable text;
        private int begin;
        private int end;
        private int pos;

        private void $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$__constructor__(Replaceable text, int begin, int end, int pos) {
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
            if (begin < 0 || begin > end || end > text.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            if (pos < begin || pos > end) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.begin = begin;
            this.end = end;
            this.pos = pos;
        }

        private final void $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$setText(Replaceable text) {
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
            this.begin = 0;
            this.end = text.length();
            this.pos = 0;
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$first() {
            this.pos = this.begin;
            return this.current();
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$last() {
            this.pos = this.end != this.begin ? this.end - 1 : this.end;
            return this.current();
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$setIndex(int p) {
            if (p < this.begin || p > this.end) {
                throw new IllegalArgumentException("Invalid index");
            }
            this.pos = p;
            return this.current();
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$current() {
            if (this.pos >= this.begin && this.pos < this.end) {
                return this.text.charAt(this.pos);
            }
            return '\uffff';
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$next() {
            if (this.pos < this.end - 1) {
                ++this.pos;
                return this.text.charAt(this.pos);
            }
            this.pos = this.end;
            return '\uffff';
        }

        private final char $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$previous() {
            if (this.pos > this.begin) {
                --this.pos;
                return this.text.charAt(this.pos);
            }
            return '\uffff';
        }

        private final int $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getBeginIndex() {
            return this.begin;
        }

        private final int $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getEndIndex() {
            return this.end;
        }

        private final int $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getIndex() {
            return this.pos;
        }

        private final boolean $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReplaceableCharacterIterator)) {
                return false;
            }
            ReplaceableCharacterIterator that = (ReplaceableCharacterIterator)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (!this.text.equals(that.text)) {
                return false;
            }
            return this.pos == that.pos && this.begin == that.begin && this.end == that.end;
        }

        private final int $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$hashCode() {
            return this.text.hashCode() ^ this.pos ^ this.begin ^ this.end;
        }

        private final Object $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$clone() {
            try {
                ReplaceableCharacterIterator other = (ReplaceableCharacterIterator)super.clone();
                return other;
            }
            catch (CloneNotSupportedException e) {
                throw new ICUCloneNotSupportedException();
            }
        }

        private void __constructor__(Replaceable replaceable, int n, int n2, int n3) {
            this.$$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$__constructor__(replaceable, n, n2, n3);
        }

        public ReplaceableCharacterIterator(Replaceable replaceable, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$__constructor__(android.icu.text.Replaceable int int int ), 0, this, replaceable, n, n2, n3);
        }

        public void setText(Replaceable replaceable) {
            InvokeDynamicSupport.bootstrap("setText", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$setText(android.icu.text.Replaceable ), 0, this, replaceable);
        }

        @Override
        public char first() {
            return (char)InvokeDynamicSupport.bootstrap("first", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$first(), 0, this);
        }

        @Override
        public char last() {
            return (char)InvokeDynamicSupport.bootstrap("last", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$last(), 0, this);
        }

        @Override
        public char setIndex(int n) {
            return (char)InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$setIndex(int ), 0, this, n);
        }

        @Override
        public char current() {
            return (char)InvokeDynamicSupport.bootstrap("current", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$current(), 0, this);
        }

        @Override
        public char next() {
            return (char)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$next(), 0, this);
        }

        @Override
        public char previous() {
            return (char)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$previous(), 0, this);
        }

        @Override
        public int getBeginIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getBeginIndex", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getBeginIndex(), 0, this);
        }

        @Override
        public int getEndIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getEndIndex", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getEndIndex(), 0, this);
        }

        @Override
        public int getIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$getIndex(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$hashCode(), 0, this);
        }

        @Override
        public Object clone() {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_BreakTransliterator_ReplaceableCharacterIterator$clone(), 0, this);
        }

        public /* synthetic */ ReplaceableCharacterIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReplaceableCharacterIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

