/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.SimpleFormatterImpl;
import android.icu.text.DateFormat;
import android.icu.text.DateIntervalInfo;
import android.icu.text.DateTimePatternGenerator;
import android.icu.text.MessageFormat;
import android.icu.text.MessagePattern;
import android.icu.text.SimpleDateFormat;
import android.icu.text.UFormat;
import android.icu.util.Calendar;
import android.icu.util.DateInterval;
import android.icu.util.Output;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateIntervalFormat
extends UFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 1L;
    private static ICUCache<String, Map<String, DateIntervalInfo.PatternInfo>> LOCAL_PATTERN_CACHE;
    private DateIntervalInfo fInfo;
    private SimpleDateFormat fDateFormat;
    private Calendar fFromCalendar;
    private Calendar fToCalendar;
    private String fSkeleton;
    private boolean isDateIntervalInfoDefault;
    private transient Map<String, DateIntervalInfo.PatternInfo> fIntervalPatterns;
    private String fDatePattern;
    private String fTimePattern;
    private String fDateTimeFormat;

    private void $$robo$$android_icu_text_DateIntervalFormat$__constructor__() {
        this.fSkeleton = null;
        this.fIntervalPatterns = null;
        this.fDatePattern = null;
        this.fTimePattern = null;
        this.fDateTimeFormat = null;
    }

    @Deprecated
    private void $$robo$$android_icu_text_DateIntervalFormat$__constructor__(String skeleton, DateIntervalInfo dtItvInfo, SimpleDateFormat simpleDateFormat) {
        this.fSkeleton = null;
        this.fIntervalPatterns = null;
        this.fDatePattern = null;
        this.fTimePattern = null;
        this.fDateTimeFormat = null;
        this.fDateFormat = simpleDateFormat;
        dtItvInfo.freeze();
        this.fSkeleton = skeleton;
        this.fInfo = dtItvInfo;
        this.isDateIntervalInfoDefault = false;
        this.fFromCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.fToCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.initializePattern(null);
    }

    private void $$robo$$android_icu_text_DateIntervalFormat$__constructor__(String skeleton, ULocale locale, SimpleDateFormat simpleDateFormat) {
        this.fSkeleton = null;
        this.fIntervalPatterns = null;
        this.fDatePattern = null;
        this.fTimePattern = null;
        this.fDateTimeFormat = null;
        this.fDateFormat = simpleDateFormat;
        this.fSkeleton = skeleton;
        this.fInfo = new DateIntervalInfo(locale).freeze();
        this.isDateIntervalInfoDefault = true;
        this.fFromCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.fToCalendar = (Calendar)this.fDateFormat.getCalendar().clone();
        this.initializePattern(LOCAL_PATTERN_CACHE);
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton) {
        return DateIntervalFormat.getInstance(skeleton, ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton, Locale locale) {
        return DateIntervalFormat.getInstance(skeleton, ULocale.forLocale(locale));
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton, ULocale locale) {
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance(locale);
        return new DateIntervalFormat(skeleton, locale, new SimpleDateFormat(generator.getBestPattern(skeleton), locale));
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton, DateIntervalInfo dtitvinf) {
        return DateIntervalFormat.getInstance(skeleton, ULocale.getDefault(ULocale.Category.FORMAT), dtitvinf);
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton, Locale locale, DateIntervalInfo dtitvinf) {
        return DateIntervalFormat.getInstance(skeleton, ULocale.forLocale(locale), dtitvinf);
    }

    private static final DateIntervalFormat $$robo$$android_icu_text_DateIntervalFormat$getInstance(String skeleton, ULocale locale, DateIntervalInfo dtitvinf) {
        dtitvinf = (DateIntervalInfo)dtitvinf.clone();
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance(locale);
        return new DateIntervalFormat(skeleton, dtitvinf, new SimpleDateFormat(generator.getBestPattern(skeleton), locale));
    }

    private final synchronized Object $$robo$$android_icu_text_DateIntervalFormat$clone() {
        DateIntervalFormat other = (DateIntervalFormat)super.clone();
        other.fDateFormat = (SimpleDateFormat)this.fDateFormat.clone();
        other.fInfo = (DateIntervalInfo)this.fInfo.clone();
        other.fFromCalendar = (Calendar)this.fFromCalendar.clone();
        other.fToCalendar = (Calendar)this.fToCalendar.clone();
        other.fDatePattern = this.fDatePattern;
        other.fTimePattern = this.fTimePattern;
        other.fDateTimeFormat = this.fDateTimeFormat;
        return other;
    }

    private final StringBuffer $$robo$$android_icu_text_DateIntervalFormat$format(Object obj, StringBuffer appendTo, FieldPosition fieldPosition) {
        if (obj instanceof DateInterval) {
            return this.format((DateInterval)obj, appendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object (" + obj.getClass().getName() + ") as a DateInterval");
    }

    private final synchronized StringBuffer $$robo$$android_icu_text_DateIntervalFormat$format(DateInterval dtInterval, StringBuffer appendTo, FieldPosition fieldPosition) {
        this.fFromCalendar.setTimeInMillis(dtInterval.getFromDate());
        this.fToCalendar.setTimeInMillis(dtInterval.getToDate());
        return this.format(this.fFromCalendar, this.fToCalendar, appendTo, fieldPosition);
    }

    @Deprecated
    private final String $$robo$$android_icu_text_DateIntervalFormat$getPatterns(Calendar fromCalendar, Calendar toCalendar, Output<String> part2) {
        int field;
        if (fromCalendar.get(0) != toCalendar.get(0)) {
            field = 0;
        } else if (fromCalendar.get(1) != toCalendar.get(1)) {
            field = 1;
        } else if (fromCalendar.get(2) != toCalendar.get(2)) {
            field = 2;
        } else if (fromCalendar.get(5) != toCalendar.get(5)) {
            field = 5;
        } else if (fromCalendar.get(9) != toCalendar.get(9)) {
            field = 9;
        } else if (fromCalendar.get(10) != toCalendar.get(10)) {
            field = 10;
        } else if (fromCalendar.get(12) != toCalendar.get(12)) {
            field = 12;
        } else if (fromCalendar.get(13) != toCalendar.get(13)) {
            field = 13;
        } else {
            return null;
        }
        DateIntervalInfo.PatternInfo intervalPattern = this.fIntervalPatterns.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field]);
        part2.value = intervalPattern.getSecondPart();
        return intervalPattern.getFirstPart();
    }

    private final synchronized StringBuffer $$robo$$android_icu_text_DateIntervalFormat$format(Calendar fromCalendar, Calendar toCalendar, StringBuffer appendTo, FieldPosition pos) {
        Calendar secondCal;
        Calendar firstCal;
        if (!fromCalendar.isEquivalentTo(toCalendar)) {
            throw new IllegalArgumentException("can not format on two different calendars");
        }
        int field = -1;
        if (fromCalendar.get(0) != toCalendar.get(0)) {
            field = 0;
        } else if (fromCalendar.get(1) != toCalendar.get(1)) {
            field = 1;
        } else if (fromCalendar.get(2) != toCalendar.get(2)) {
            field = 2;
        } else if (fromCalendar.get(5) != toCalendar.get(5)) {
            field = 5;
        } else if (fromCalendar.get(9) != toCalendar.get(9)) {
            field = 9;
        } else if (fromCalendar.get(10) != toCalendar.get(10)) {
            field = 10;
        } else if (fromCalendar.get(12) != toCalendar.get(12)) {
            field = 12;
        } else if (fromCalendar.get(13) != toCalendar.get(13)) {
            field = 13;
        } else {
            return this.fDateFormat.format(fromCalendar, appendTo, pos);
        }
        boolean fromToOnSameDay = field == 9 || field == 10 || field == 12 || field == 13;
        DateIntervalInfo.PatternInfo intervalPattern = this.fIntervalPatterns.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field]);
        if (intervalPattern == null) {
            if (this.fDateFormat.isFieldUnitIgnored(field)) {
                return this.fDateFormat.format(fromCalendar, appendTo, pos);
            }
            return this.fallbackFormat(fromCalendar, toCalendar, fromToOnSameDay, appendTo, pos);
        }
        if (intervalPattern.getFirstPart() == null) {
            return this.fallbackFormat(fromCalendar, toCalendar, fromToOnSameDay, appendTo, pos, intervalPattern.getSecondPart());
        }
        if (intervalPattern.firstDateInPtnIsLaterDate()) {
            firstCal = toCalendar;
            secondCal = fromCalendar;
        } else {
            firstCal = fromCalendar;
            secondCal = toCalendar;
        }
        String originalPattern = this.fDateFormat.toPattern();
        this.fDateFormat.applyPattern(intervalPattern.getFirstPart());
        this.fDateFormat.format(firstCal, appendTo, pos);
        if (intervalPattern.getSecondPart() != null) {
            this.fDateFormat.applyPattern(intervalPattern.getSecondPart());
            FieldPosition otherPos = new FieldPosition(pos.getField());
            this.fDateFormat.format(secondCal, appendTo, otherPos);
            if (pos.getEndIndex() == 0 && otherPos.getEndIndex() > 0) {
                pos.setBeginIndex(otherPos.getBeginIndex());
                pos.setEndIndex(otherPos.getEndIndex());
            }
        }
        this.fDateFormat.applyPattern(originalPattern);
        return appendTo;
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$adjustPosition(String combiningPattern, String pat0, FieldPosition pos0, String pat1, FieldPosition pos1, FieldPosition posResult) {
        int index0 = combiningPattern.indexOf("{0}");
        int index1 = combiningPattern.indexOf("{1}");
        if (index0 < 0 || index1 < 0) {
            return;
        }
        int placeholderLen = 3;
        if (index0 < index1) {
            if (pos0.getEndIndex() > 0) {
                posResult.setBeginIndex(pos0.getBeginIndex() + index0);
                posResult.setEndIndex(pos0.getEndIndex() + index0);
            } else if (pos1.getEndIndex() > 0) {
                posResult.setBeginIndex(pos1.getBeginIndex() + (index1 += pat0.length() - placeholderLen));
                posResult.setEndIndex(pos1.getEndIndex() + index1);
            }
        } else if (pos1.getEndIndex() > 0) {
            posResult.setBeginIndex(pos1.getBeginIndex() + index1);
            posResult.setEndIndex(pos1.getEndIndex() + index1);
        } else if (pos0.getEndIndex() > 0) {
            posResult.setBeginIndex(pos0.getBeginIndex() + (index0 += pat1.length() - placeholderLen));
            posResult.setEndIndex(pos0.getEndIndex() + index0);
        }
    }

    private final StringBuffer $$robo$$android_icu_text_DateIntervalFormat$fallbackFormat(Calendar fromCalendar, Calendar toCalendar, boolean fromToOnSameDay, StringBuffer appendTo, FieldPosition pos) {
        boolean formatDatePlusTimeRange;
        String fullPattern = null;
        boolean bl = formatDatePlusTimeRange = fromToOnSameDay && this.fDatePattern != null && this.fTimePattern != null;
        if (formatDatePlusTimeRange) {
            fullPattern = this.fDateFormat.toPattern();
            this.fDateFormat.applyPattern(this.fTimePattern);
        }
        FieldPosition otherPos = new FieldPosition(pos.getField());
        StringBuffer earlierDate = new StringBuffer(64);
        earlierDate = this.fDateFormat.format(fromCalendar, earlierDate, pos);
        StringBuffer laterDate = new StringBuffer(64);
        laterDate = this.fDateFormat.format(toCalendar, laterDate, otherPos);
        String fallbackPattern = this.fInfo.getFallbackIntervalPattern();
        this.adjustPosition(fallbackPattern, earlierDate.toString(), pos, laterDate.toString(), otherPos, pos);
        String fallbackRange = SimpleFormatterImpl.formatRawPattern(fallbackPattern, 2, 2, earlierDate, laterDate);
        if (formatDatePlusTimeRange) {
            this.fDateFormat.applyPattern(this.fDatePattern);
            StringBuffer datePortion = new StringBuffer(64);
            otherPos.setBeginIndex(0);
            otherPos.setEndIndex(0);
            datePortion = this.fDateFormat.format(fromCalendar, datePortion, otherPos);
            this.adjustPosition(this.fDateTimeFormat, fallbackRange, pos, datePortion.toString(), otherPos, pos);
            MessageFormat msgFmt = new MessageFormat("");
            msgFmt.applyPattern(this.fDateTimeFormat, MessagePattern.ApostropheMode.DOUBLE_REQUIRED);
            StringBuffer fallbackRangeBuffer = new StringBuffer(128);
            fallbackRange = msgFmt.format(new Object[]{fallbackRange, datePortion}, fallbackRangeBuffer, new FieldPosition(0)).toString();
        }
        appendTo.append(fallbackRange);
        if (formatDatePlusTimeRange) {
            this.fDateFormat.applyPattern(fullPattern);
        }
        return appendTo;
    }

    private final StringBuffer $$robo$$android_icu_text_DateIntervalFormat$fallbackFormat(Calendar fromCalendar, Calendar toCalendar, boolean fromToOnSameDay, StringBuffer appendTo, FieldPosition pos, String fullPattern) {
        String originalPattern = this.fDateFormat.toPattern();
        this.fDateFormat.applyPattern(fullPattern);
        this.fallbackFormat(fromCalendar, toCalendar, fromToOnSameDay, appendTo, pos);
        this.fDateFormat.applyPattern(originalPattern);
        return appendTo;
    }

    @Deprecated
    private final Object $$robo$$android_icu_text_DateIntervalFormat$parseObject(String source, ParsePosition parse_pos) {
        throw new UnsupportedOperationException("parsing is not supported");
    }

    private final DateIntervalInfo $$robo$$android_icu_text_DateIntervalFormat$getDateIntervalInfo() {
        return (DateIntervalInfo)this.fInfo.clone();
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$setDateIntervalInfo(DateIntervalInfo newItvPattern) {
        this.fInfo = (DateIntervalInfo)newItvPattern.clone();
        this.isDateIntervalInfoDefault = false;
        this.fInfo.freeze();
        if (this.fDateFormat != null) {
            this.initializePattern(null);
        }
    }

    private final TimeZone $$robo$$android_icu_text_DateIntervalFormat$getTimeZone() {
        if (this.fDateFormat != null) {
            return (TimeZone)this.fDateFormat.getTimeZone().clone();
        }
        return TimeZone.getDefault();
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$setTimeZone(TimeZone zone) {
        TimeZone zoneToSet = (TimeZone)zone.clone();
        if (this.fDateFormat != null) {
            this.fDateFormat.setTimeZone(zoneToSet);
        }
        if (this.fFromCalendar != null) {
            this.fFromCalendar.setTimeZone(zoneToSet);
        }
        if (this.fToCalendar != null) {
            this.fToCalendar.setTimeZone(zoneToSet);
        }
    }

    private final synchronized DateFormat $$robo$$android_icu_text_DateIntervalFormat$getDateFormat() {
        return (DateFormat)this.fDateFormat.clone();
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$initializePattern(ICUCache<String, Map<String, DateIntervalInfo.PatternInfo>> cache) {
        String fullPattern = this.fDateFormat.toPattern();
        ULocale locale = this.fDateFormat.getLocale();
        String key = null;
        Map<String, DateIntervalInfo.PatternInfo> patterns = null;
        if (cache != null) {
            key = this.fSkeleton != null ? locale.toString() + "+" + fullPattern + "+" + this.fSkeleton : locale.toString() + "+" + fullPattern;
            patterns = cache.get(key);
        }
        if (patterns == null) {
            Map<String, DateIntervalInfo.PatternInfo> intervalPatterns = this.initializeIntervalPattern(fullPattern, locale);
            patterns = Collections.unmodifiableMap(intervalPatterns);
            if (cache != null) {
                cache.put(key, patterns);
            }
        }
        this.fIntervalPatterns = patterns;
    }

    private final Map<String, DateIntervalInfo.PatternInfo> $$robo$$android_icu_text_DateIntervalFormat$initializeIntervalPattern(String fullPattern, ULocale locale) {
        boolean found;
        DateTimePatternGenerator dtpng = DateTimePatternGenerator.getInstance(locale);
        if (this.fSkeleton == null) {
            this.fSkeleton = dtpng.getSkeleton(fullPattern);
        }
        String skeleton = this.fSkeleton;
        HashMap<String, DateIntervalInfo.PatternInfo> intervalPatterns = new HashMap<String, DateIntervalInfo.PatternInfo>();
        StringBuilder date = new StringBuilder(skeleton.length());
        StringBuilder normalizedDate = new StringBuilder(skeleton.length());
        StringBuilder time = new StringBuilder(skeleton.length());
        StringBuilder normalizedTime = new StringBuilder(skeleton.length());
        DateIntervalFormat.getDateTimeSkeleton(skeleton, date, normalizedDate, time, normalizedTime);
        String dateSkeleton = date.toString();
        String timeSkeleton = time.toString();
        String normalizedDateSkeleton = normalizedDate.toString();
        String normalizedTimeSkeleton = normalizedTime.toString();
        if (time.length() != 0 && date.length() != 0) {
            this.fDateTimeFormat = this.getConcatenationPattern(locale);
        }
        if (!(found = this.genSeparateDateTimePtn(normalizedDateSkeleton, normalizedTimeSkeleton, intervalPatterns, dtpng))) {
            if (time.length() != 0 && date.length() == 0) {
                timeSkeleton = "yMd" + timeSkeleton;
                String pattern = dtpng.getBestPattern(timeSkeleton);
                DateIntervalInfo.PatternInfo ptn = new DateIntervalInfo.PatternInfo(null, pattern, this.fInfo.getDefaultOrder());
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5], ptn);
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2], ptn);
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1], ptn);
            }
            return intervalPatterns;
        }
        if (time.length() != 0) {
            if (date.length() == 0) {
                timeSkeleton = "yMd" + timeSkeleton;
                String pattern = dtpng.getBestPattern(timeSkeleton);
                DateIntervalInfo.PatternInfo ptn = new DateIntervalInfo.PatternInfo(null, pattern, this.fInfo.getDefaultOrder());
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5], ptn);
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2], ptn);
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1], ptn);
            } else {
                if (!DateIntervalFormat.fieldExistsInSkeleton(5, dateSkeleton)) {
                    skeleton = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[5] + skeleton;
                    this.genFallbackPattern(5, skeleton, intervalPatterns, dtpng);
                }
                if (!DateIntervalFormat.fieldExistsInSkeleton(2, dateSkeleton)) {
                    skeleton = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[2] + skeleton;
                    this.genFallbackPattern(2, skeleton, intervalPatterns, dtpng);
                }
                if (!DateIntervalFormat.fieldExistsInSkeleton(1, dateSkeleton)) {
                    skeleton = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[1] + skeleton;
                    this.genFallbackPattern(1, skeleton, intervalPatterns, dtpng);
                }
                if (this.fDateTimeFormat == null) {
                    this.fDateTimeFormat = "{1} {0}";
                }
                String datePattern = dtpng.getBestPattern(dateSkeleton);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, datePattern, 9, intervalPatterns);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, datePattern, 10, intervalPatterns);
                this.concatSingleDate2TimeInterval(this.fDateTimeFormat, datePattern, 12, intervalPatterns);
            }
        }
        return intervalPatterns;
    }

    private final String $$robo$$android_icu_text_DateIntervalFormat$getConcatenationPattern(ULocale locale) {
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", locale);
        ICUResourceBundle dtPatternsRb = rb.getWithFallback("calendar/gregorian/DateTimePatterns");
        ICUResourceBundle concatenationPatternRb = (ICUResourceBundle)dtPatternsRb.get(8);
        if (concatenationPatternRb.getType() == 0) {
            return concatenationPatternRb.getString();
        }
        return concatenationPatternRb.getString(0);
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$genFallbackPattern(int field, String skeleton, Map<String, DateIntervalInfo.PatternInfo> intervalPatterns, DateTimePatternGenerator dtpng) {
        String pattern = dtpng.getBestPattern(skeleton);
        DateIntervalInfo.PatternInfo ptn = new DateIntervalInfo.PatternInfo(null, pattern, this.fInfo.getDefaultOrder());
        intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field], ptn);
    }

    private static final void $$robo$$android_icu_text_DateIntervalFormat$getDateTimeSkeleton(String skeleton, StringBuilder dateSkeleton, StringBuilder normalizedDateSkeleton, StringBuilder timeSkeleton, StringBuilder normalizedTimeSkeleton) {
        int i;
        int ECount = 0;
        int dCount = 0;
        int MCount = 0;
        int yCount = 0;
        int hCount = 0;
        int HCount = 0;
        int mCount = 0;
        int vCount = 0;
        int zCount = 0;
        block14: for (i = 0; i < skeleton.length(); ++i) {
            char ch = skeleton.charAt(i);
            switch (ch) {
                case 'E': {
                    dateSkeleton.append(ch);
                    ++ECount;
                    continue block14;
                }
                case 'd': {
                    dateSkeleton.append(ch);
                    ++dCount;
                    continue block14;
                }
                case 'M': {
                    dateSkeleton.append(ch);
                    ++MCount;
                    continue block14;
                }
                case 'y': {
                    dateSkeleton.append(ch);
                    ++yCount;
                    continue block14;
                }
                case 'D': 
                case 'F': 
                case 'G': 
                case 'L': 
                case 'Q': 
                case 'U': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'e': 
                case 'g': 
                case 'l': 
                case 'q': 
                case 'r': 
                case 'u': 
                case 'w': {
                    normalizedDateSkeleton.append(ch);
                    dateSkeleton.append(ch);
                    continue block14;
                }
                case 'a': {
                    timeSkeleton.append(ch);
                    continue block14;
                }
                case 'h': {
                    timeSkeleton.append(ch);
                    ++hCount;
                    continue block14;
                }
                case 'H': {
                    timeSkeleton.append(ch);
                    ++HCount;
                    continue block14;
                }
                case 'm': {
                    timeSkeleton.append(ch);
                    ++mCount;
                    continue block14;
                }
                case 'z': {
                    ++zCount;
                    timeSkeleton.append(ch);
                    continue block14;
                }
                case 'v': {
                    ++vCount;
                    timeSkeleton.append(ch);
                    continue block14;
                }
                case 'A': 
                case 'K': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case 'j': 
                case 'k': 
                case 's': {
                    timeSkeleton.append(ch);
                    normalizedTimeSkeleton.append(ch);
                }
            }
        }
        if (yCount != 0) {
            for (i = 0; i < yCount; ++i) {
                normalizedDateSkeleton.append('y');
            }
        }
        if (MCount != 0) {
            if (MCount < 3) {
                normalizedDateSkeleton.append('M');
            } else {
                for (i = 0; i < MCount && i < 5; ++i) {
                    normalizedDateSkeleton.append('M');
                }
            }
        }
        if (ECount != 0) {
            if (ECount <= 3) {
                normalizedDateSkeleton.append('E');
            } else {
                for (i = 0; i < ECount && i < 5; ++i) {
                    normalizedDateSkeleton.append('E');
                }
            }
        }
        if (dCount != 0) {
            normalizedDateSkeleton.append('d');
        }
        if (HCount != 0) {
            normalizedTimeSkeleton.append('H');
        } else if (hCount != 0) {
            normalizedTimeSkeleton.append('h');
        }
        if (mCount != 0) {
            normalizedTimeSkeleton.append('m');
        }
        if (zCount != 0) {
            normalizedTimeSkeleton.append('z');
        }
        if (vCount != 0) {
            normalizedTimeSkeleton.append('v');
        }
    }

    private final boolean $$robo$$android_icu_text_DateIntervalFormat$genSeparateDateTimePtn(String dateSkeleton, String timeSkeleton, Map<String, DateIntervalInfo.PatternInfo> intervalPatterns, DateTimePatternGenerator dtpng) {
        String skeleton = timeSkeleton.length() != 0 ? timeSkeleton : dateSkeleton;
        BestMatchInfo retValue = this.fInfo.getBestSkeleton(skeleton);
        String bestSkeleton = retValue.bestMatchSkeleton;
        int differenceInfo = retValue.bestMatchDistanceInfo;
        if (dateSkeleton.length() != 0) {
            this.fDatePattern = dtpng.getBestPattern(dateSkeleton);
        }
        if (timeSkeleton.length() != 0) {
            this.fTimePattern = dtpng.getBestPattern(timeSkeleton);
        }
        if (differenceInfo == -1) {
            return false;
        }
        if (timeSkeleton.length() == 0) {
            this.genIntervalPattern(5, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
            SkeletonAndItsBestMatch skeletons = this.genIntervalPattern(2, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
            if (skeletons != null) {
                bestSkeleton = skeletons.skeleton;
                skeleton = skeletons.bestMatchSkeleton;
            }
            this.genIntervalPattern(1, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
        } else {
            this.genIntervalPattern(12, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
            this.genIntervalPattern(10, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
            this.genIntervalPattern(9, skeleton, bestSkeleton, differenceInfo, intervalPatterns);
        }
        return true;
    }

    private final SkeletonAndItsBestMatch $$robo$$android_icu_text_DateIntervalFormat$genIntervalPattern(int field, String skeleton, String bestSkeleton, int differenceInfo, Map<String, DateIntervalInfo.PatternInfo> intervalPatterns) {
        SkeletonAndItsBestMatch retValue = null;
        DateIntervalInfo.PatternInfo pattern = this.fInfo.getIntervalPattern(bestSkeleton, field);
        if (pattern == null) {
            if (SimpleDateFormat.isFieldUnitIgnored(bestSkeleton, field)) {
                DateIntervalInfo.PatternInfo ptnInfo = new DateIntervalInfo.PatternInfo(this.fDateFormat.toPattern(), null, this.fInfo.getDefaultOrder());
                intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field], ptnInfo);
                return null;
            }
            if (field == 9) {
                pattern = this.fInfo.getIntervalPattern(bestSkeleton, 10);
                if (pattern != null) {
                    intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field], pattern);
                }
                return null;
            }
            String fieldLetter = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field];
            bestSkeleton = fieldLetter + bestSkeleton;
            skeleton = fieldLetter + skeleton;
            pattern = this.fInfo.getIntervalPattern(bestSkeleton, field);
            if (pattern == null && differenceInfo == 0) {
                BestMatchInfo tmpRetValue = this.fInfo.getBestSkeleton(skeleton);
                String tmpBestSkeleton = tmpRetValue.bestMatchSkeleton;
                differenceInfo = tmpRetValue.bestMatchDistanceInfo;
                if (tmpBestSkeleton.length() != 0 && differenceInfo != -1) {
                    pattern = this.fInfo.getIntervalPattern(tmpBestSkeleton, field);
                    bestSkeleton = tmpBestSkeleton;
                }
            }
            if (pattern != null) {
                retValue = new SkeletonAndItsBestMatch(skeleton, bestSkeleton);
            }
        }
        if (pattern != null) {
            if (differenceInfo != 0) {
                String part1 = DateIntervalFormat.adjustFieldWidth(skeleton, bestSkeleton, pattern.getFirstPart(), differenceInfo);
                String part2 = DateIntervalFormat.adjustFieldWidth(skeleton, bestSkeleton, pattern.getSecondPart(), differenceInfo);
                pattern = new DateIntervalInfo.PatternInfo(part1, part2, pattern.firstDateInPtnIsLaterDate());
            }
            intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field], pattern);
        }
        return retValue;
    }

    private static final String $$robo$$android_icu_text_DateIntervalFormat$adjustFieldWidth(String inputSkeleton, String bestMatchSkeleton, String bestMatchIntervalPattern, int differenceInfo) {
        if (bestMatchIntervalPattern == null) {
            return null;
        }
        int[] inputSkeletonFieldWidth = new int[58];
        int[] bestMatchSkeletonFieldWidth = new int[58];
        DateIntervalInfo.parseSkeleton(inputSkeleton, inputSkeletonFieldWidth);
        DateIntervalInfo.parseSkeleton(bestMatchSkeleton, bestMatchSkeletonFieldWidth);
        if (differenceInfo == 2) {
            bestMatchIntervalPattern = bestMatchIntervalPattern.replace('v', 'z');
        }
        StringBuilder adjustedPtn = new StringBuilder(bestMatchIntervalPattern);
        boolean inQuote = false;
        int prevCh = 0;
        int count = 0;
        int PATTERN_CHAR_BASE = 65;
        int adjustedPtnLength = adjustedPtn.length();
        for (int i = 0; i < adjustedPtnLength; ++i) {
            int ch = adjustedPtn.charAt(i);
            if (ch != prevCh && count > 0) {
                int skeletonChar = prevCh;
                if (skeletonChar == 76) {
                    skeletonChar = 77;
                }
                int fieldCount = bestMatchSkeletonFieldWidth[skeletonChar - PATTERN_CHAR_BASE];
                int inputFieldCount = inputSkeletonFieldWidth[skeletonChar - PATTERN_CHAR_BASE];
                if (fieldCount == count && inputFieldCount > fieldCount) {
                    count = inputFieldCount - fieldCount;
                    for (int j = 0; j < count; ++j) {
                        adjustedPtn.insert(i, (char)prevCh);
                    }
                    i += count;
                    adjustedPtnLength += count;
                }
                count = 0;
            }
            if (ch == 39) {
                if (i + 1 < adjustedPtn.length() && adjustedPtn.charAt(i + 1) == '\'') {
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (inQuote || (ch < 97 || ch > 122) && (ch < 65 || ch > 90)) continue;
            prevCh = ch;
            ++count;
        }
        if (count > 0) {
            int skeletonChar = prevCh;
            if (skeletonChar == 76) {
                skeletonChar = 77;
            }
            int fieldCount = bestMatchSkeletonFieldWidth[skeletonChar - PATTERN_CHAR_BASE];
            int inputFieldCount = inputSkeletonFieldWidth[skeletonChar - PATTERN_CHAR_BASE];
            if (fieldCount == count && inputFieldCount > fieldCount) {
                count = inputFieldCount - fieldCount;
                for (int j = 0; j < count; ++j) {
                    adjustedPtn.append((char)prevCh);
                }
            }
        }
        return adjustedPtn.toString();
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$concatSingleDate2TimeInterval(String dtfmt, String datePattern, int field, Map<String, DateIntervalInfo.PatternInfo> intervalPatterns) {
        DateIntervalInfo.PatternInfo timeItvPtnInfo = intervalPatterns.get(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field]);
        if (timeItvPtnInfo != null) {
            String timeIntervalPattern = timeItvPtnInfo.getFirstPart() + timeItvPtnInfo.getSecondPart();
            String pattern = SimpleFormatterImpl.formatRawPattern(dtfmt, 2, 2, timeIntervalPattern, datePattern);
            timeItvPtnInfo = DateIntervalInfo.genPatternInfo(pattern, timeItvPtnInfo.firstDateInPtnIsLaterDate());
            intervalPatterns.put(DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field], timeItvPtnInfo);
        }
    }

    private static final boolean $$robo$$android_icu_text_DateIntervalFormat$fieldExistsInSkeleton(int field, String skeleton) {
        String fieldChar = DateIntervalInfo.CALENDAR_FIELD_TO_PATTERN_LETTER[field];
        return skeleton.indexOf(fieldChar) != -1;
    }

    private final void $$robo$$android_icu_text_DateIntervalFormat$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializePattern(this.isDateIntervalInfoDefault ? LOCAL_PATTERN_CACHE : null);
    }

    @Deprecated
    private final Map<String, DateIntervalInfo.PatternInfo> $$robo$$android_icu_text_DateIntervalFormat$getRawPatterns() {
        return this.fIntervalPatterns;
    }

    static void __staticInitializer__() {
        LOCAL_PATTERN_CACHE = new SimpleCache<String, Map<String, DateIntervalInfo.PatternInfo>>();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DateIntervalFormat$__constructor__();
    }

    private DateIntervalFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalFormat$__constructor__(), 0, this);
    }

    private void __constructor__(String string2, DateIntervalInfo dateIntervalInfo, SimpleDateFormat simpleDateFormat) {
        this.$$robo$$android_icu_text_DateIntervalFormat$__constructor__(string2, dateIntervalInfo, simpleDateFormat);
    }

    public DateIntervalFormat(String string2, DateIntervalInfo dateIntervalInfo, SimpleDateFormat simpleDateFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalFormat$__constructor__(java.lang.String android.icu.text.DateIntervalInfo android.icu.text.SimpleDateFormat ), 0, this, string2, dateIntervalInfo, simpleDateFormat);
    }

    private void __constructor__(String string2, ULocale uLocale, SimpleDateFormat simpleDateFormat) {
        this.$$robo$$android_icu_text_DateIntervalFormat$__constructor__(string2, uLocale, simpleDateFormat);
    }

    private DateIntervalFormat(String string2, ULocale uLocale, SimpleDateFormat simpleDateFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalFormat$__constructor__(java.lang.String android.icu.util.ULocale android.icu.text.SimpleDateFormat ), 0, this, string2, uLocale, simpleDateFormat);
    }

    public static DateIntervalFormat getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String ), 0, (String)string2);
    }

    public static DateIntervalFormat getInstance(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String java.util.Locale ), 0, (String)string2, (Locale)locale);
    }

    public static DateIntervalFormat getInstance(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String android.icu.util.ULocale ), 0, (String)string2, (ULocale)uLocale);
    }

    public static DateIntervalFormat getInstance(String string2, DateIntervalInfo dateIntervalInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String android.icu.text.DateIntervalInfo ), 0, (String)string2, (DateIntervalInfo)dateIntervalInfo);
    }

    public static DateIntervalFormat getInstance(String string2, Locale locale, DateIntervalInfo dateIntervalInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String java.util.Locale android.icu.text.DateIntervalInfo ), 0, (String)string2, (Locale)locale, (DateIntervalInfo)dateIntervalInfo);
    }

    public static DateIntervalFormat getInstance(String string2, ULocale uLocale, DateIntervalInfo dateIntervalInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateIntervalFormat$getInstance(java.lang.String android.icu.util.ULocale android.icu.text.DateIntervalInfo ), 0, (String)string2, (ULocale)uLocale, (DateIntervalInfo)dateIntervalInfo);
    }

    @Override
    public synchronized Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DateIntervalFormat$clone(), 0, this);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateIntervalFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    public synchronized StringBuffer format(DateInterval dateInterval, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateIntervalFormat$format(android.icu.util.DateInterval java.lang.StringBuffer java.text.FieldPosition ), 0, this, dateInterval, stringBuffer, fieldPosition);
    }

    @Deprecated
    public String getPatterns(Calendar calendar, Calendar calendar2, Output<String> output) {
        return InvokeDynamicSupport.bootstrap("getPatterns", $$robo$$android_icu_text_DateIntervalFormat$getPatterns(android.icu.util.Calendar android.icu.util.Calendar android.icu.util.Output<java.lang.String> ), 0, this, calendar, calendar2, output);
    }

    public synchronized StringBuffer format(Calendar calendar, Calendar calendar2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DateIntervalFormat$format(android.icu.util.Calendar android.icu.util.Calendar java.lang.StringBuffer java.text.FieldPosition ), 0, this, calendar, calendar2, stringBuffer, fieldPosition);
    }

    private void adjustPosition(String string2, String string3, FieldPosition fieldPosition, String string4, FieldPosition fieldPosition2, FieldPosition fieldPosition3) {
        InvokeDynamicSupport.bootstrap("adjustPosition", $$robo$$android_icu_text_DateIntervalFormat$adjustPosition(java.lang.String java.lang.String java.text.FieldPosition java.lang.String java.text.FieldPosition java.text.FieldPosition ), 0, this, string2, string3, fieldPosition, string4, fieldPosition2, fieldPosition3);
    }

    private StringBuffer fallbackFormat(Calendar calendar, Calendar calendar2, boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("fallbackFormat", $$robo$$android_icu_text_DateIntervalFormat$fallbackFormat(android.icu.util.Calendar android.icu.util.Calendar boolean java.lang.StringBuffer java.text.FieldPosition ), 0, this, calendar, calendar2, bl, stringBuffer, fieldPosition);
    }

    private StringBuffer fallbackFormat(Calendar calendar, Calendar calendar2, boolean bl, StringBuffer stringBuffer, FieldPosition fieldPosition, String string2) {
        return InvokeDynamicSupport.bootstrap("fallbackFormat", $$robo$$android_icu_text_DateIntervalFormat$fallbackFormat(android.icu.util.Calendar android.icu.util.Calendar boolean java.lang.StringBuffer java.text.FieldPosition java.lang.String ), 0, this, calendar, calendar2, bl, stringBuffer, fieldPosition, string2);
    }

    @Override
    @Deprecated
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_DateIntervalFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public DateIntervalInfo getDateIntervalInfo() {
        return InvokeDynamicSupport.bootstrap("getDateIntervalInfo", $$robo$$android_icu_text_DateIntervalFormat$getDateIntervalInfo(), 0, this);
    }

    public void setDateIntervalInfo(DateIntervalInfo dateIntervalInfo) {
        InvokeDynamicSupport.bootstrap("setDateIntervalInfo", $$robo$$android_icu_text_DateIntervalFormat$setDateIntervalInfo(android.icu.text.DateIntervalInfo ), 0, this, dateIntervalInfo);
    }

    public TimeZone getTimeZone() {
        return InvokeDynamicSupport.bootstrap("getTimeZone", $$robo$$android_icu_text_DateIntervalFormat$getTimeZone(), 0, this);
    }

    public void setTimeZone(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_icu_text_DateIntervalFormat$setTimeZone(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    public synchronized DateFormat getDateFormat() {
        return InvokeDynamicSupport.bootstrap("getDateFormat", $$robo$$android_icu_text_DateIntervalFormat$getDateFormat(), 0, this);
    }

    private void initializePattern(ICUCache<String, Map<String, DateIntervalInfo.PatternInfo>> iCUCache) {
        InvokeDynamicSupport.bootstrap("initializePattern", $$robo$$android_icu_text_DateIntervalFormat$initializePattern(android.icu.impl.ICUCache<java.lang.String, java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo>> ), 0, this, iCUCache);
    }

    private Map<String, DateIntervalInfo.PatternInfo> initializeIntervalPattern(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("initializeIntervalPattern", $$robo$$android_icu_text_DateIntervalFormat$initializeIntervalPattern(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
    }

    private String getConcatenationPattern(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getConcatenationPattern", $$robo$$android_icu_text_DateIntervalFormat$getConcatenationPattern(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void genFallbackPattern(int n, String string2, Map<String, DateIntervalInfo.PatternInfo> map, DateTimePatternGenerator dateTimePatternGenerator) {
        InvokeDynamicSupport.bootstrap("genFallbackPattern", $$robo$$android_icu_text_DateIntervalFormat$genFallbackPattern(int java.lang.String java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo> android.icu.text.DateTimePatternGenerator ), 0, this, n, string2, map, dateTimePatternGenerator);
    }

    private static void getDateTimeSkeleton(String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, StringBuilder stringBuilder3, StringBuilder stringBuilder4) {
        InvokeDynamicSupport.bootstrapStatic("getDateTimeSkeleton", $$robo$$android_icu_text_DateIntervalFormat$getDateTimeSkeleton(java.lang.String java.lang.StringBuilder java.lang.StringBuilder java.lang.StringBuilder java.lang.StringBuilder ), 0, (String)string2, (StringBuilder)stringBuilder, (StringBuilder)stringBuilder2, (StringBuilder)stringBuilder3, (StringBuilder)stringBuilder4);
    }

    private boolean genSeparateDateTimePtn(String string2, String string3, Map<String, DateIntervalInfo.PatternInfo> map, DateTimePatternGenerator dateTimePatternGenerator) {
        return (boolean)InvokeDynamicSupport.bootstrap("genSeparateDateTimePtn", $$robo$$android_icu_text_DateIntervalFormat$genSeparateDateTimePtn(java.lang.String java.lang.String java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo> android.icu.text.DateTimePatternGenerator ), 0, this, string2, string3, map, dateTimePatternGenerator);
    }

    private SkeletonAndItsBestMatch genIntervalPattern(int n, String string2, String string3, int n2, Map<String, DateIntervalInfo.PatternInfo> map) {
        return InvokeDynamicSupport.bootstrap("genIntervalPattern", $$robo$$android_icu_text_DateIntervalFormat$genIntervalPattern(int java.lang.String java.lang.String int java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo> ), 0, this, n, string2, string3, n2, map);
    }

    private static String adjustFieldWidth(String string2, String string3, String string4, int n) {
        return InvokeDynamicSupport.bootstrapStatic("adjustFieldWidth", $$robo$$android_icu_text_DateIntervalFormat$adjustFieldWidth(java.lang.String java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (String)string4, (int)n);
    }

    private void concatSingleDate2TimeInterval(String string2, String string3, int n, Map<String, DateIntervalInfo.PatternInfo> map) {
        InvokeDynamicSupport.bootstrap("concatSingleDate2TimeInterval", $$robo$$android_icu_text_DateIntervalFormat$concatSingleDate2TimeInterval(java.lang.String java.lang.String int java.util.Map<java.lang.String, android.icu.text.DateIntervalInfo$PatternInfo> ), 0, this, string2, string3, n, map);
    }

    private static boolean fieldExistsInSkeleton(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fieldExistsInSkeleton", $$robo$$android_icu_text_DateIntervalFormat$fieldExistsInSkeleton(int java.lang.String ), 0, (int)n, (String)string2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DateIntervalFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    @Deprecated
    public Map<String, DateIntervalInfo.PatternInfo> getRawPatterns() {
        return InvokeDynamicSupport.bootstrap("getRawPatterns", $$robo$$android_icu_text_DateIntervalFormat$getRawPatterns(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DateIntervalFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateIntervalFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SkeletonAndItsBestMatch
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String skeleton;
        String bestMatchSkeleton;

        private void $$robo$$android_icu_text_DateIntervalFormat_SkeletonAndItsBestMatch$__constructor__(String skeleton, String bestMatch) {
            this.skeleton = skeleton;
            this.bestMatchSkeleton = bestMatch;
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_icu_text_DateIntervalFormat_SkeletonAndItsBestMatch$__constructor__(string2, string3);
        }

        SkeletonAndItsBestMatch(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalFormat_SkeletonAndItsBestMatch$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public /* synthetic */ SkeletonAndItsBestMatch() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SkeletonAndItsBestMatch)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BestMatchInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String bestMatchSkeleton;
        int bestMatchDistanceInfo;

        private void $$robo$$android_icu_text_DateIntervalFormat_BestMatchInfo$__constructor__(String bestSkeleton, int difference) {
            this.bestMatchSkeleton = bestSkeleton;
            this.bestMatchDistanceInfo = difference;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_DateIntervalFormat_BestMatchInfo$__constructor__(string2, n);
        }

        BestMatchInfo(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateIntervalFormat_BestMatchInfo$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ BestMatchInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BestMatchInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

