/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.number.AffixUtils;
import android.icu.impl.number.DecimalFormatProperties;
import android.icu.impl.number.Padder;
import android.icu.impl.number.Parse;
import android.icu.impl.number.PatternStringParser;
import android.icu.impl.number.PatternStringUtils;
import android.icu.impl.number.Properties;
import android.icu.math.BigDecimal;
import android.icu.number.FormattedNumber;
import android.icu.number.LocalizedNumberFormatter;
import android.icu.number.NumberFormatter;
import android.icu.text.CurrencyPluralInfo;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.NumberFormat;
import android.icu.text.PluralRules;
import android.icu.util.Currency;
import android.icu.util.CurrencyAmount;
import android.icu.util.ULocale;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DecimalFormat
extends NumberFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = 864413376551465018L;
    private int serialVersionOnStream = 5;
    transient DecimalFormatProperties properties;
    volatile transient DecimalFormatSymbols symbols;
    volatile transient LocalizedNumberFormatter formatter;
    volatile transient DecimalFormatProperties exportedProperties;
    private transient int icuMathContextForm;
    private static ThreadLocal<DecimalFormatProperties> threadLocalProperties;
    public static int PAD_BEFORE_PREFIX = 0;
    public static int PAD_AFTER_PREFIX = 1;
    public static int PAD_BEFORE_SUFFIX = 2;
    public static int PAD_AFTER_SUFFIX = 3;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_DecimalFormat$__constructor__() {
        this.serialVersionOnStream = 5;
        this.icuMathContextForm = 0;
        ULocale def = ULocale.getDefault(ULocale.Category.FORMAT);
        String pattern = DecimalFormat.getPattern(def, 0);
        this.symbols = DecimalFormat.getDefaultSymbols();
        this.properties = new DecimalFormatProperties();
        this.exportedProperties = new DecimalFormatProperties();
        this.setPropertiesFromPattern(pattern, 1);
        this.refreshFormatter();
    }

    private void $$robo$$android_icu_text_DecimalFormat$__constructor__(String pattern) {
        this.serialVersionOnStream = 5;
        this.icuMathContextForm = 0;
        this.symbols = DecimalFormat.getDefaultSymbols();
        this.properties = new DecimalFormatProperties();
        this.exportedProperties = new DecimalFormatProperties();
        this.setPropertiesFromPattern(pattern, 1);
        this.refreshFormatter();
    }

    private void $$robo$$android_icu_text_DecimalFormat$__constructor__(String pattern, DecimalFormatSymbols symbols) {
        this.serialVersionOnStream = 5;
        this.icuMathContextForm = 0;
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.properties = new DecimalFormatProperties();
        this.exportedProperties = new DecimalFormatProperties();
        this.setPropertiesFromPattern(pattern, 1);
        this.refreshFormatter();
    }

    private void $$robo$$android_icu_text_DecimalFormat$__constructor__(String pattern, DecimalFormatSymbols symbols, CurrencyPluralInfo infoInput, int style2) {
        this.properties.setCurrencyPluralInfo(infoInput);
        this.refreshFormatter();
    }

    private void $$robo$$android_icu_text_DecimalFormat$__constructor__(String pattern, DecimalFormatSymbols symbols, int choice) {
        this.serialVersionOnStream = 5;
        this.icuMathContextForm = 0;
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.properties = new DecimalFormatProperties();
        this.exportedProperties = new DecimalFormatProperties();
        if (choice == 1 || choice == 5 || choice == 7 || choice == 8 || choice == 9 || choice == 6) {
            this.setPropertiesFromPattern(pattern, 2);
        } else {
            this.setPropertiesFromPattern(pattern, 1);
        }
        this.refreshFormatter();
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormat$getDefaultSymbols() {
        return DecimalFormatSymbols.getInstance();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$applyPattern(String pattern) {
        this.setPropertiesFromPattern(pattern, 0);
        this.properties.setPositivePrefix(null);
        this.properties.setNegativePrefix(null);
        this.properties.setPositiveSuffix(null);
        this.properties.setNegativeSuffix(null);
        this.properties.setCurrencyPluralInfo(null);
        this.refreshFormatter();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$applyLocalizedPattern(String localizedPattern) {
        String pattern = PatternStringUtils.convertLocalized(localizedPattern, this.symbols, false);
        this.applyPattern(pattern);
    }

    private final Object $$robo$$android_icu_text_DecimalFormat$clone() {
        DecimalFormat other = (DecimalFormat)super.clone();
        other.symbols = (DecimalFormatSymbols)this.symbols.clone();
        other.properties = this.properties.clone();
        other.exportedProperties = new DecimalFormatProperties();
        other.refreshFormatter();
        return other;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(0);
        oos.writeObject(this.properties);
        oos.writeObject(this.symbols);
    }

    private final void $$robo$$android_icu_text_DecimalFormat$readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fieldGetter = ois.readFields();
        ObjectStreamField[] serializedFields = fieldGetter.getObjectStreamClass().getFields();
        int serialVersion = fieldGetter.get("serialVersionOnStream", -1);
        if (serialVersion > 5) {
            throw new IOException("Cannot deserialize newer android.icu.text.DecimalFormat (v" + serialVersion + ")");
        }
        if (serialVersion == 5) {
            if (serializedFields.length > 1) {
                throw new IOException("Too many fields when reading serial version 5");
            }
            ois.readInt();
            Object serializedProperties = ois.readObject();
            this.properties = serializedProperties instanceof DecimalFormatProperties ? (DecimalFormatProperties)serializedProperties : ((Properties)serializedProperties).getInstance();
            this.symbols = (DecimalFormatSymbols)ois.readObject();
            this.exportedProperties = new DecimalFormatProperties();
            this.refreshFormatter();
        } else {
            this.properties = new DecimalFormatProperties();
            String pp = null;
            String ppp = null;
            String ps = null;
            String psp = null;
            String np = null;
            String npp = null;
            String ns = null;
            String nsp = null;
            for (ObjectStreamField field : serializedFields) {
                String name = field.getName();
                if (name.equals("decimalSeparatorAlwaysShown")) {
                    this.setDecimalSeparatorAlwaysShown(fieldGetter.get("decimalSeparatorAlwaysShown", false));
                    continue;
                }
                if (name.equals("exponentSignAlwaysShown")) {
                    this.setExponentSignAlwaysShown(fieldGetter.get("exponentSignAlwaysShown", false));
                    continue;
                }
                if (name.equals("formatWidth")) {
                    this.setFormatWidth(fieldGetter.get("formatWidth", 0));
                    continue;
                }
                if (name.equals("groupingSize")) {
                    this.setGroupingSize(fieldGetter.get("groupingSize", (byte)3));
                    continue;
                }
                if (name.equals("groupingSize2")) {
                    this.setSecondaryGroupingSize(fieldGetter.get("groupingSize2", (byte)0));
                    continue;
                }
                if (name.equals("maxSignificantDigits")) {
                    this.setMaximumSignificantDigits(fieldGetter.get("maxSignificantDigits", 6));
                    continue;
                }
                if (name.equals("minExponentDigits")) {
                    this.setMinimumExponentDigits(fieldGetter.get("minExponentDigits", (byte)0));
                    continue;
                }
                if (name.equals("minSignificantDigits")) {
                    this.setMinimumSignificantDigits(fieldGetter.get("minSignificantDigits", 1));
                    continue;
                }
                if (name.equals("multiplier")) {
                    this.setMultiplier(fieldGetter.get("multiplier", 1));
                    continue;
                }
                if (name.equals("pad")) {
                    this.setPadCharacter(fieldGetter.get("pad", ' '));
                    continue;
                }
                if (name.equals("padPosition")) {
                    this.setPadPosition(fieldGetter.get("padPosition", 0));
                    continue;
                }
                if (name.equals("parseBigDecimal")) {
                    this.setParseBigDecimal(fieldGetter.get("parseBigDecimal", false));
                    continue;
                }
                if (name.equals("parseRequireDecimalPoint")) {
                    this.setDecimalPatternMatchRequired(fieldGetter.get("parseRequireDecimalPoint", false));
                    continue;
                }
                if (name.equals("roundingMode")) {
                    this.setRoundingMode(fieldGetter.get("roundingMode", 0));
                    continue;
                }
                if (name.equals("useExponentialNotation")) {
                    this.setScientificNotation(fieldGetter.get("useExponentialNotation", false));
                    continue;
                }
                if (name.equals("useSignificantDigits")) {
                    this.setSignificantDigitsUsed(fieldGetter.get("useSignificantDigits", false));
                    continue;
                }
                if (name.equals("currencyPluralInfo")) {
                    this.setCurrencyPluralInfo((CurrencyPluralInfo)fieldGetter.get("currencyPluralInfo", null));
                    continue;
                }
                if (name.equals("mathContext")) {
                    this.setMathContextICU((android.icu.math.MathContext)fieldGetter.get("mathContext", null));
                    continue;
                }
                if (name.equals("negPrefixPattern")) {
                    npp = (String)fieldGetter.get("negPrefixPattern", null);
                    continue;
                }
                if (name.equals("negSuffixPattern")) {
                    nsp = (String)fieldGetter.get("negSuffixPattern", null);
                    continue;
                }
                if (name.equals("negativePrefix")) {
                    np = (String)fieldGetter.get("negativePrefix", null);
                    continue;
                }
                if (name.equals("negativeSuffix")) {
                    ns = (String)fieldGetter.get("negativeSuffix", null);
                    continue;
                }
                if (name.equals("posPrefixPattern")) {
                    ppp = (String)fieldGetter.get("posPrefixPattern", null);
                    continue;
                }
                if (name.equals("posSuffixPattern")) {
                    psp = (String)fieldGetter.get("posSuffixPattern", null);
                    continue;
                }
                if (name.equals("positivePrefix")) {
                    pp = (String)fieldGetter.get("positivePrefix", null);
                    continue;
                }
                if (name.equals("positiveSuffix")) {
                    ps = (String)fieldGetter.get("positiveSuffix", null);
                    continue;
                }
                if (name.equals("roundingIncrement")) {
                    this.setRoundingIncrement((java.math.BigDecimal)fieldGetter.get("roundingIncrement", null));
                    continue;
                }
                if (!name.equals("symbols")) continue;
                this.setDecimalFormatSymbols((DecimalFormatSymbols)fieldGetter.get("symbols", null));
            }
            if (npp == null) {
                this.properties.setNegativePrefix(np);
            } else {
                this.properties.setNegativePrefixPattern(npp);
            }
            if (nsp == null) {
                this.properties.setNegativeSuffix(ns);
            } else {
                this.properties.setNegativeSuffixPattern(nsp);
            }
            if (ppp == null) {
                this.properties.setPositivePrefix(pp);
            } else {
                this.properties.setPositivePrefixPattern(ppp);
            }
            if (psp == null) {
                this.properties.setPositiveSuffix(ps);
            } else {
                this.properties.setPositiveSuffixPattern(psp);
            }
            try {
                Field getter = NumberFormat.class.getDeclaredField("groupingUsed");
                getter.setAccessible(true);
                this.setGroupingUsed((Boolean)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("parseIntegerOnly");
                getter.setAccessible(true);
                this.setParseIntegerOnly((Boolean)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("maximumIntegerDigits");
                getter.setAccessible(true);
                this.setMaximumIntegerDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("minimumIntegerDigits");
                getter.setAccessible(true);
                this.setMinimumIntegerDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("maximumFractionDigits");
                getter.setAccessible(true);
                this.setMaximumFractionDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("minimumFractionDigits");
                getter.setAccessible(true);
                this.setMinimumFractionDigits((Integer)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("currency");
                getter.setAccessible(true);
                this.setCurrency((Currency)getter.get(this));
                getter = NumberFormat.class.getDeclaredField("parseStrict");
                getter.setAccessible(true);
                this.setParseStrict((Boolean)getter.get(this));
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (NoSuchFieldException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            if (this.symbols == null) {
                this.symbols = DecimalFormat.getDefaultSymbols();
            }
            this.exportedProperties = new DecimalFormatProperties();
            this.refreshFormatter();
        }
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(double number, StringBuffer result, FieldPosition fieldPosition) {
        FormattedNumber output = this.formatter.format(number);
        output.populateFieldPosition(fieldPosition, result.length());
        output.appendTo(result);
        return result;
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(long number, StringBuffer result, FieldPosition fieldPosition) {
        FormattedNumber output = this.formatter.format(number);
        output.populateFieldPosition(fieldPosition, result.length());
        output.appendTo(result);
        return result;
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(BigInteger number, StringBuffer result, FieldPosition fieldPosition) {
        FormattedNumber output = this.formatter.format(number);
        output.populateFieldPosition(fieldPosition, result.length());
        output.appendTo(result);
        return result;
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(java.math.BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        FormattedNumber output = this.formatter.format(number);
        output.populateFieldPosition(fieldPosition, result.length());
        output.appendTo(result);
        return result;
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        FormattedNumber output = this.formatter.format(number);
        output.populateFieldPosition(fieldPosition, result.length());
        output.appendTo(result);
        return result;
    }

    private final AttributedCharacterIterator $$robo$$android_icu_text_DecimalFormat$formatToCharacterIterator(Object obj) {
        if (!(obj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        Number number = (Number)obj;
        FormattedNumber output = this.formatter.format(number);
        return output.getFieldIterator();
    }

    private final StringBuffer $$robo$$android_icu_text_DecimalFormat$format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        FormattedNumber output = this.formatter.format(currAmt);
        output.populateFieldPosition(pos, toAppendTo.length());
        output.appendTo(toAppendTo);
        return toAppendTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Number $$robo$$android_icu_text_DecimalFormat$parse(String text, ParsePosition parsePosition) {
        DecimalFormatProperties pprops = threadLocalProperties.get();
        DecimalFormat decimalFormat = this;
        synchronized (decimalFormat) {
            pprops.copyFrom(this.properties);
        }
        Number result = Parse.parse(text, parsePosition, pprops, this.symbols);
        if (result instanceof java.math.BigDecimal) {
            result = this.safeConvertBigDecimal((java.math.BigDecimal)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CurrencyAmount $$robo$$android_icu_text_DecimalFormat$parseCurrency(CharSequence text, ParsePosition parsePosition) {
        try {
            DecimalFormatProperties pprops = threadLocalProperties.get();
            DecimalFormat decimalFormat = this;
            synchronized (decimalFormat) {
                pprops.copyFrom(this.properties);
            }
            CurrencyAmount result = Parse.parseCurrency(text, parsePosition, pprops, this.symbols);
            if (result == null) {
                return null;
            }
            Number number = result.getNumber();
            if (number instanceof java.math.BigDecimal) {
                number = this.safeConvertBigDecimal((java.math.BigDecimal)number);
                result = new CurrencyAmount(number, result.getCurrency());
            }
            return result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private final synchronized DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormat$getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = (DecimalFormatSymbols)newSymbols.clone();
        this.refreshFormatter();
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$getPositivePrefix() {
        return this.formatter.format(1L).getPrefix();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setPositivePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        this.properties.setPositivePrefix(prefix);
        this.refreshFormatter();
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$getNegativePrefix() {
        return this.formatter.format(-1L).getPrefix();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setNegativePrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        this.properties.setNegativePrefix(prefix);
        this.refreshFormatter();
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$getPositiveSuffix() {
        return this.formatter.format(1L).getSuffix();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setPositiveSuffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        this.properties.setPositiveSuffix(suffix);
        this.refreshFormatter();
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$getNegativeSuffix() {
        return this.formatter.format(-1L).getSuffix();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setNegativeSuffix(String suffix) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        this.properties.setNegativeSuffix(suffix);
        this.refreshFormatter();
    }

    @Deprecated
    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$getSignAlwaysShown() {
        return this.properties.getSignAlwaysShown();
    }

    @Deprecated
    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setSignAlwaysShown(boolean value) {
        this.properties.setSignAlwaysShown(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMultiplier() {
        if (this.properties.getMultiplier() != null) {
            return this.properties.getMultiplier().intValue();
        }
        return (int)Math.pow(10.0, this.properties.getMagnitudeMultiplier());
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMultiplier(int multiplier) {
        if (multiplier == 0) {
            throw new IllegalArgumentException("Multiplier must be nonzero.");
        }
        int delta = 0;
        int value = multiplier;
        while (multiplier != 1) {
            ++delta;
            int temp = value / 10;
            if (temp * 10 != value) {
                delta = -1;
                break;
            }
            value = temp;
        }
        if (delta != -1) {
            this.properties.setMagnitudeMultiplier(delta);
        } else {
            this.properties.setMultiplier(java.math.BigDecimal.valueOf(multiplier));
        }
        this.refreshFormatter();
    }

    private final synchronized java.math.BigDecimal $$robo$$android_icu_text_DecimalFormat$getRoundingIncrement() {
        return this.exportedProperties.getRoundingIncrement();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(java.math.BigDecimal increment) {
        if (increment != null && increment.compareTo(java.math.BigDecimal.ZERO) == 0) {
            this.properties.setMaximumFractionDigits(Integer.MAX_VALUE);
            return;
        }
        this.properties.setRoundingIncrement(increment);
        this.refreshFormatter();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(BigDecimal increment) {
        java.math.BigDecimal javaBigDecimal = increment == null ? null : increment.toBigDecimal();
        this.setRoundingIncrement(javaBigDecimal);
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(double increment) {
        if (increment == 0.0) {
            this.setRoundingIncrement((java.math.BigDecimal)null);
        } else {
            java.math.BigDecimal javaBigDecimal = java.math.BigDecimal.valueOf(increment);
            this.setRoundingIncrement(javaBigDecimal);
        }
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getRoundingMode() {
        RoundingMode mode = this.exportedProperties.getRoundingMode();
        return mode == null ? 0 : mode.ordinal();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setRoundingMode(int roundingMode) {
        this.properties.setRoundingMode(RoundingMode.valueOf(roundingMode));
        this.refreshFormatter();
    }

    private final synchronized MathContext $$robo$$android_icu_text_DecimalFormat$getMathContext() {
        MathContext mathContext = this.exportedProperties.getMathContext();
        if (!$assertionsDisabled && mathContext == null) {
            throw new AssertionError();
        }
        return mathContext;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMathContext(MathContext mathContext) {
        this.properties.setMathContext(mathContext);
        this.refreshFormatter();
    }

    private final synchronized android.icu.math.MathContext $$robo$$android_icu_text_DecimalFormat$getMathContextICU() {
        MathContext mathContext = this.getMathContext();
        return new android.icu.math.MathContext(mathContext.getPrecision(), this.icuMathContextForm, false, mathContext.getRoundingMode().ordinal());
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMathContextICU(android.icu.math.MathContext mathContextICU) {
        this.icuMathContextForm = mathContextICU.getForm();
        MathContext mathContext = mathContextICU.getLostDigits() ? new MathContext(mathContextICU.getDigits(), RoundingMode.UNNECESSARY) : new MathContext(mathContextICU.getDigits(), RoundingMode.valueOf(mathContextICU.getRoundingMode()));
        this.setMathContext(mathContext);
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMinimumIntegerDigits() {
        return this.exportedProperties.getMinimumIntegerDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMinimumIntegerDigits(int value) {
        int max = this.properties.getMaximumIntegerDigits();
        if (max >= 0 && max < value) {
            this.properties.setMaximumIntegerDigits(value);
        }
        this.properties.setMinimumIntegerDigits(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMaximumIntegerDigits() {
        return this.exportedProperties.getMaximumIntegerDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMaximumIntegerDigits(int value) {
        int min = this.properties.getMinimumIntegerDigits();
        if (min >= 0 && min > value) {
            this.properties.setMinimumIntegerDigits(value);
        }
        this.properties.setMaximumIntegerDigits(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMinimumFractionDigits() {
        return this.exportedProperties.getMinimumFractionDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMinimumFractionDigits(int value) {
        int max = this.properties.getMaximumFractionDigits();
        if (max >= 0 && max < value) {
            this.properties.setMaximumFractionDigits(value);
        }
        this.properties.setMinimumFractionDigits(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMaximumFractionDigits() {
        return this.exportedProperties.getMaximumFractionDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMaximumFractionDigits(int value) {
        int min = this.properties.getMinimumFractionDigits();
        if (min >= 0 && min > value) {
            this.properties.setMinimumFractionDigits(value);
        }
        this.properties.setMaximumFractionDigits(value);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$areSignificantDigitsUsed() {
        return this.properties.getMinimumSignificantDigits() != -1 || this.properties.getMaximumSignificantDigits() != -1;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setSignificantDigitsUsed(boolean useSignificantDigits) {
        if (useSignificantDigits) {
            this.properties.setMinimumSignificantDigits(1);
            this.properties.setMaximumSignificantDigits(6);
        } else {
            this.properties.setMinimumSignificantDigits(-1);
            this.properties.setMaximumSignificantDigits(-1);
        }
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMinimumSignificantDigits() {
        return this.exportedProperties.getMinimumSignificantDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMinimumSignificantDigits(int value) {
        int max = this.properties.getMaximumSignificantDigits();
        if (max >= 0 && max < value) {
            this.properties.setMaximumSignificantDigits(value);
        }
        this.properties.setMinimumSignificantDigits(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMaximumSignificantDigits() {
        return this.exportedProperties.getMaximumSignificantDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMaximumSignificantDigits(int value) {
        int min = this.properties.getMinimumSignificantDigits();
        if (min >= 0 && min > value) {
            this.properties.setMinimumSignificantDigits(value);
        }
        this.properties.setMaximumSignificantDigits(value);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getFormatWidth() {
        return this.properties.getFormatWidth();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setFormatWidth(int width) {
        this.properties.setFormatWidth(width);
        this.refreshFormatter();
    }

    private final synchronized char $$robo$$android_icu_text_DecimalFormat$getPadCharacter() {
        String paddingString = this.properties.getPadString();
        if (paddingString == null) {
            return '.';
        }
        return paddingString.charAt(0);
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setPadCharacter(char padChar) {
        this.properties.setPadString(Character.toString(padChar));
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getPadPosition() {
        Padder.PadPosition loc = this.properties.getPadPosition();
        return loc == null ? 0 : loc.toOld();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setPadPosition(int padPos) {
        this.properties.setPadPosition(Padder.PadPosition.fromOld(padPos));
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isScientificNotation() {
        return this.properties.getMinimumExponentDigits() != -1;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setScientificNotation(boolean useScientific) {
        if (useScientific) {
            this.properties.setMinimumExponentDigits(1);
        } else {
            this.properties.setMinimumExponentDigits(-1);
        }
        this.refreshFormatter();
    }

    private final synchronized byte $$robo$$android_icu_text_DecimalFormat$getMinimumExponentDigits() {
        return (byte)this.properties.getMinimumExponentDigits();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMinimumExponentDigits(byte minExpDig) {
        this.properties.setMinimumExponentDigits(minExpDig);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isExponentSignAlwaysShown() {
        return this.properties.getExponentSignAlwaysShown();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setExponentSignAlwaysShown(boolean expSignAlways) {
        this.properties.setExponentSignAlwaysShown(expSignAlways);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isGroupingUsed() {
        return this.properties.getGroupingSize() > 0 || this.properties.getSecondaryGroupingSize() > 0;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setGroupingUsed(boolean enabled) {
        if (enabled) {
            this.properties.setGroupingSize(3);
        } else {
            this.properties.setGroupingSize(0);
            this.properties.setSecondaryGroupingSize(0);
        }
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getGroupingSize() {
        return this.properties.getGroupingSize();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setGroupingSize(int width) {
        this.properties.setGroupingSize(width);
        this.refreshFormatter();
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getSecondaryGroupingSize() {
        int grouping2;
        int grouping1 = this.properties.getGroupingSize();
        if (grouping1 == (grouping2 = this.properties.getSecondaryGroupingSize()) || grouping2 < 0) {
            return 0;
        }
        return this.properties.getSecondaryGroupingSize();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setSecondaryGroupingSize(int width) {
        this.properties.setSecondaryGroupingSize(width);
        this.refreshFormatter();
    }

    @Deprecated
    private final synchronized int $$robo$$android_icu_text_DecimalFormat$getMinimumGroupingDigits() {
        if (this.properties.getMinimumGroupingDigits() == 2) {
            return 2;
        }
        return 1;
    }

    @Deprecated
    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setMinimumGroupingDigits(int number) {
        this.properties.setMinimumGroupingDigits(number);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isDecimalSeparatorAlwaysShown() {
        return this.properties.getDecimalSeparatorAlwaysShown();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setDecimalSeparatorAlwaysShown(boolean value) {
        this.properties.setDecimalSeparatorAlwaysShown(value);
        this.refreshFormatter();
    }

    private final synchronized Currency $$robo$$android_icu_text_DecimalFormat$getCurrency() {
        return this.properties.getCurrency();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setCurrency(Currency currency) {
        this.properties.setCurrency(currency);
        if (currency != null) {
            this.symbols.setCurrency(currency);
            String symbol = currency.getName(this.symbols.getULocale(), 0, null);
            this.symbols.setCurrencySymbol(symbol);
        }
        this.refreshFormatter();
    }

    private final synchronized Currency.CurrencyUsage $$robo$$android_icu_text_DecimalFormat$getCurrencyUsage() {
        Currency.CurrencyUsage usage = this.properties.getCurrencyUsage();
        if (usage == null) {
            usage = Currency.CurrencyUsage.STANDARD;
        }
        return usage;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setCurrencyUsage(Currency.CurrencyUsage usage) {
        this.properties.setCurrencyUsage(usage);
        this.refreshFormatter();
    }

    private final synchronized CurrencyPluralInfo $$robo$$android_icu_text_DecimalFormat$getCurrencyPluralInfo() {
        return this.properties.getCurrencyPluralInfo();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setCurrencyPluralInfo(CurrencyPluralInfo newInfo) {
        this.properties.setCurrencyPluralInfo(newInfo);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isParseBigDecimal() {
        return this.properties.getParseToBigDecimal();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setParseBigDecimal(boolean value) {
        this.properties.setParseToBigDecimal(value);
    }

    @Deprecated
    private final int $$robo$$android_icu_text_DecimalFormat$getParseMaxDigits() {
        return 1000;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_DecimalFormat$setParseMaxDigits(int maxDigits) {
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isParseStrict() {
        return this.properties.getParseMode() == Parse.ParseMode.STRICT;
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setParseStrict(boolean parseStrict) {
        Parse.ParseMode mode = parseStrict ? Parse.ParseMode.STRICT : Parse.ParseMode.LENIENT;
        this.properties.setParseMode(mode);
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isParseIntegerOnly() {
        return this.properties.getParseIntegerOnly();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setParseIntegerOnly(boolean parseIntegerOnly) {
        this.properties.setParseIntegerOnly(parseIntegerOnly);
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$isDecimalPatternMatchRequired() {
        return this.properties.getDecimalPatternMatchRequired();
    }

    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setDecimalPatternMatchRequired(boolean value) {
        this.properties.setDecimalPatternMatchRequired(value);
        this.refreshFormatter();
    }

    @Deprecated
    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$getParseNoExponent() {
        return this.properties.getParseNoExponent();
    }

    @Deprecated
    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setParseNoExponent(boolean value) {
        this.properties.setParseNoExponent(value);
        this.refreshFormatter();
    }

    @Deprecated
    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$getParseCaseSensitive() {
        return this.properties.getParseCaseSensitive();
    }

    @Deprecated
    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setParseCaseSensitive(boolean value) {
        this.properties.setParseCaseSensitive(value);
        this.refreshFormatter();
    }

    private final synchronized boolean $$robo$$android_icu_text_DecimalFormat$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)obj;
        return this.properties.equals(other.properties) && this.symbols.equals(other.symbols);
    }

    private final synchronized int $$robo$$android_icu_text_DecimalFormat$hashCode() {
        return this.properties.hashCode() ^ this.symbols.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_text_DecimalFormat$toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append("@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" { symbols@");
        result.append(Integer.toHexString(this.symbols.hashCode()));
        DecimalFormat decimalFormat = this;
        synchronized (decimalFormat) {
            this.properties.toStringBare(result);
        }
        result.append(" }");
        return result.toString();
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$toPattern() {
        DecimalFormatProperties tprops = threadLocalProperties.get().copyFrom(this.properties);
        if (DecimalFormat.useCurrency(this.properties)) {
            tprops.setMinimumFractionDigits(this.exportedProperties.getMinimumFractionDigits());
            tprops.setMaximumFractionDigits(this.exportedProperties.getMaximumFractionDigits());
            tprops.setRoundingIncrement(this.exportedProperties.getRoundingIncrement());
        }
        return PatternStringUtils.propertiesToPatternString(tprops);
    }

    private final synchronized String $$robo$$android_icu_text_DecimalFormat$toLocalizedPattern() {
        String pattern = this.toPattern();
        return PatternStringUtils.convertLocalized(pattern, this.symbols, true);
    }

    private final LocalizedNumberFormatter $$robo$$android_icu_text_DecimalFormat$toNumberFormatter() {
        return this.formatter;
    }

    @Deprecated
    private final PluralRules.IFixedDecimal $$robo$$android_icu_text_DecimalFormat$getFixedDecimal(double number) {
        return this.formatter.format(number).getFixedDecimal();
    }

    private final void $$robo$$android_icu_text_DecimalFormat$refreshFormatter() {
        if (this.exportedProperties == null) {
            return;
        }
        ULocale locale = this.getLocale(ULocale.ACTUAL_LOCALE);
        if (locale == null) {
            locale = this.symbols.getLocale(ULocale.ACTUAL_LOCALE);
        }
        if (locale == null) {
            locale = this.symbols.getULocale();
        }
        if (!$assertionsDisabled && locale == null) {
            throw new AssertionError();
        }
        this.formatter = NumberFormatter.fromDecimalFormat(this.properties, this.symbols, this.exportedProperties).locale(locale);
    }

    private final Number $$robo$$android_icu_text_DecimalFormat$safeConvertBigDecimal(java.math.BigDecimal number) {
        try {
            return new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            if (number.signum() > 0 && number.scale() < 0) {
                return Double.POSITIVE_INFINITY;
            }
            if (number.scale() < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (number.signum() < 0) {
                return -0.0;
            }
            return 0.0;
        }
    }

    private static final boolean $$robo$$android_icu_text_DecimalFormat$useCurrency(DecimalFormatProperties properties) {
        return properties.getCurrency() != null || properties.getCurrencyPluralInfo() != null || properties.getCurrencyUsage() != null || AffixUtils.hasCurrencySymbols(properties.getPositivePrefixPattern()) || AffixUtils.hasCurrencySymbols(properties.getPositiveSuffixPattern()) || AffixUtils.hasCurrencySymbols(properties.getNegativePrefixPattern()) || AffixUtils.hasCurrencySymbols(properties.getNegativeSuffixPattern());
    }

    private final void $$robo$$android_icu_text_DecimalFormat$setPropertiesFromPattern(String pattern, int ignoreRounding) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        PatternStringParser.parseToExistingProperties(pattern, this.properties, ignoreRounding);
    }

    @Deprecated
    private final synchronized void $$robo$$android_icu_text_DecimalFormat$setProperties(PropertySetter func) {
        func.set(this.properties);
        this.refreshFormatter();
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !DecimalFormat.class.desiredAssertionStatus();
        threadLocalProperties = new ThreadLocal<DecimalFormatProperties>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_DecimalFormat_1$__constructor__() {
            }

            private final DecimalFormatProperties $$robo$$android_icu_text_DecimalFormat_1$initialValue() {
                return new DecimalFormatProperties();
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_DecimalFormat_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat_1$__constructor__(), 0, this);
            }

            @Override
            protected DecimalFormatProperties initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_icu_text_DecimalFormat_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DecimalFormat$__constructor__();
    }

    public DecimalFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_DecimalFormat$__constructor__(string2);
    }

    public DecimalFormat(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, DecimalFormatSymbols decimalFormatSymbols) {
        this.$$robo$$android_icu_text_DecimalFormat$__constructor__(string2, decimalFormatSymbols);
    }

    public DecimalFormat(String string2, DecimalFormatSymbols decimalFormatSymbols) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat$__constructor__(java.lang.String android.icu.text.DecimalFormatSymbols ), 0, this, string2, decimalFormatSymbols);
    }

    private void __constructor__(String string2, DecimalFormatSymbols decimalFormatSymbols, CurrencyPluralInfo currencyPluralInfo, int n) {
        this.$$robo$$android_icu_text_DecimalFormat$__constructor__(string2, decimalFormatSymbols, currencyPluralInfo, n);
    }

    public DecimalFormat(String string2, DecimalFormatSymbols decimalFormatSymbols, CurrencyPluralInfo currencyPluralInfo, int n) {
        this(string2, decimalFormatSymbols, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat$__constructor__(java.lang.String android.icu.text.DecimalFormatSymbols android.icu.text.CurrencyPluralInfo int ), 0, this, string2, decimalFormatSymbols, currencyPluralInfo, n);
    }

    private void __constructor__(String string2, DecimalFormatSymbols decimalFormatSymbols, int n) {
        this.$$robo$$android_icu_text_DecimalFormat$__constructor__(string2, decimalFormatSymbols, n);
    }

    DecimalFormat(String string2, DecimalFormatSymbols decimalFormatSymbols, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormat$__constructor__(java.lang.String android.icu.text.DecimalFormatSymbols int ), 0, this, string2, decimalFormatSymbols, n);
    }

    private static DecimalFormatSymbols getDefaultSymbols() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSymbols", $$robo$$android_icu_text_DecimalFormat$getDefaultSymbols(), 0);
    }

    public synchronized void applyPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_DecimalFormat$applyPattern(java.lang.String ), 0, this, string2);
    }

    public synchronized void applyLocalizedPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyLocalizedPattern", $$robo$$android_icu_text_DecimalFormat$applyLocalizedPattern(java.lang.String ), 0, this, string2);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DecimalFormat$clone(), 0, this);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_DecimalFormat$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DecimalFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(double java.lang.StringBuffer java.text.FieldPosition ), 0, this, d, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(long java.lang.StringBuffer java.text.FieldPosition ), 0, this, l, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(java.math.BigInteger java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigInteger, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(java.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(android.icu.math.BigDecimal java.lang.StringBuffer java.text.FieldPosition ), 0, this, bigDecimal, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return InvokeDynamicSupport.bootstrap("formatToCharacterIterator", $$robo$$android_icu_text_DecimalFormat$formatToCharacterIterator(java.lang.Object ), 0, this, object);
    }

    @Override
    public StringBuffer format(CurrencyAmount currencyAmount, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_DecimalFormat$format(android.icu.util.CurrencyAmount java.lang.StringBuffer java.text.FieldPosition ), 0, this, currencyAmount, stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_DecimalFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    @Override
    public CurrencyAmount parseCurrency(CharSequence charSequence, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseCurrency", $$robo$$android_icu_text_DecimalFormat$parseCurrency(java.lang.CharSequence java.text.ParsePosition ), 0, this, charSequence, parsePosition);
    }

    public synchronized DecimalFormatSymbols getDecimalFormatSymbols() {
        return InvokeDynamicSupport.bootstrap("getDecimalFormatSymbols", $$robo$$android_icu_text_DecimalFormat$getDecimalFormatSymbols(), 0, this);
    }

    public synchronized void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        InvokeDynamicSupport.bootstrap("setDecimalFormatSymbols", $$robo$$android_icu_text_DecimalFormat$setDecimalFormatSymbols(android.icu.text.DecimalFormatSymbols ), 0, this, decimalFormatSymbols);
    }

    public synchronized String getPositivePrefix() {
        return InvokeDynamicSupport.bootstrap("getPositivePrefix", $$robo$$android_icu_text_DecimalFormat$getPositivePrefix(), 0, this);
    }

    public synchronized void setPositivePrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setPositivePrefix", $$robo$$android_icu_text_DecimalFormat$setPositivePrefix(java.lang.String ), 0, this, string2);
    }

    public synchronized String getNegativePrefix() {
        return InvokeDynamicSupport.bootstrap("getNegativePrefix", $$robo$$android_icu_text_DecimalFormat$getNegativePrefix(), 0, this);
    }

    public synchronized void setNegativePrefix(String string2) {
        InvokeDynamicSupport.bootstrap("setNegativePrefix", $$robo$$android_icu_text_DecimalFormat$setNegativePrefix(java.lang.String ), 0, this, string2);
    }

    public synchronized String getPositiveSuffix() {
        return InvokeDynamicSupport.bootstrap("getPositiveSuffix", $$robo$$android_icu_text_DecimalFormat$getPositiveSuffix(), 0, this);
    }

    public synchronized void setPositiveSuffix(String string2) {
        InvokeDynamicSupport.bootstrap("setPositiveSuffix", $$robo$$android_icu_text_DecimalFormat$setPositiveSuffix(java.lang.String ), 0, this, string2);
    }

    public synchronized String getNegativeSuffix() {
        return InvokeDynamicSupport.bootstrap("getNegativeSuffix", $$robo$$android_icu_text_DecimalFormat$getNegativeSuffix(), 0, this);
    }

    public synchronized void setNegativeSuffix(String string2) {
        InvokeDynamicSupport.bootstrap("setNegativeSuffix", $$robo$$android_icu_text_DecimalFormat$setNegativeSuffix(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public synchronized boolean getSignAlwaysShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSignAlwaysShown", $$robo$$android_icu_text_DecimalFormat$getSignAlwaysShown(), 0, this);
    }

    @Deprecated
    public synchronized void setSignAlwaysShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSignAlwaysShown", $$robo$$android_icu_text_DecimalFormat$setSignAlwaysShown(boolean ), 0, this, bl);
    }

    public synchronized int getMultiplier() {
        return (int)InvokeDynamicSupport.bootstrap("getMultiplier", $$robo$$android_icu_text_DecimalFormat$getMultiplier(), 0, this);
    }

    public synchronized void setMultiplier(int n) {
        InvokeDynamicSupport.bootstrap("setMultiplier", $$robo$$android_icu_text_DecimalFormat$setMultiplier(int ), 0, this, n);
    }

    public synchronized java.math.BigDecimal getRoundingIncrement() {
        return InvokeDynamicSupport.bootstrap("getRoundingIncrement", $$robo$$android_icu_text_DecimalFormat$getRoundingIncrement(), 0, this);
    }

    public synchronized void setRoundingIncrement(java.math.BigDecimal bigDecimal) {
        InvokeDynamicSupport.bootstrap("setRoundingIncrement", $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(java.math.BigDecimal ), 0, this, bigDecimal);
    }

    public synchronized void setRoundingIncrement(BigDecimal bigDecimal) {
        InvokeDynamicSupport.bootstrap("setRoundingIncrement", $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(android.icu.math.BigDecimal ), 0, this, bigDecimal);
    }

    public synchronized void setRoundingIncrement(double d) {
        InvokeDynamicSupport.bootstrap("setRoundingIncrement", $$robo$$android_icu_text_DecimalFormat$setRoundingIncrement(double ), 0, this, d);
    }

    @Override
    public synchronized int getRoundingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRoundingMode", $$robo$$android_icu_text_DecimalFormat$getRoundingMode(), 0, this);
    }

    @Override
    public synchronized void setRoundingMode(int n) {
        InvokeDynamicSupport.bootstrap("setRoundingMode", $$robo$$android_icu_text_DecimalFormat$setRoundingMode(int ), 0, this, n);
    }

    public synchronized MathContext getMathContext() {
        return InvokeDynamicSupport.bootstrap("getMathContext", $$robo$$android_icu_text_DecimalFormat$getMathContext(), 0, this);
    }

    public synchronized void setMathContext(MathContext mathContext) {
        InvokeDynamicSupport.bootstrap("setMathContext", $$robo$$android_icu_text_DecimalFormat$setMathContext(java.math.MathContext ), 0, this, mathContext);
    }

    public synchronized android.icu.math.MathContext getMathContextICU() {
        return InvokeDynamicSupport.bootstrap("getMathContextICU", $$robo$$android_icu_text_DecimalFormat$getMathContextICU(), 0, this);
    }

    public synchronized void setMathContextICU(android.icu.math.MathContext mathContext) {
        InvokeDynamicSupport.bootstrap("setMathContextICU", $$robo$$android_icu_text_DecimalFormat$setMathContextICU(android.icu.math.MathContext ), 0, this, mathContext);
    }

    @Override
    public synchronized int getMinimumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumIntegerDigits", $$robo$$android_icu_text_DecimalFormat$getMinimumIntegerDigits(), 0, this);
    }

    @Override
    public synchronized void setMinimumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumIntegerDigits", $$robo$$android_icu_text_DecimalFormat$setMinimumIntegerDigits(int ), 0, this, n);
    }

    @Override
    public synchronized int getMaximumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumIntegerDigits", $$robo$$android_icu_text_DecimalFormat$getMaximumIntegerDigits(), 0, this);
    }

    @Override
    public synchronized void setMaximumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumIntegerDigits", $$robo$$android_icu_text_DecimalFormat$setMaximumIntegerDigits(int ), 0, this, n);
    }

    @Override
    public synchronized int getMinimumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumFractionDigits", $$robo$$android_icu_text_DecimalFormat$getMinimumFractionDigits(), 0, this);
    }

    @Override
    public synchronized void setMinimumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumFractionDigits", $$robo$$android_icu_text_DecimalFormat$setMinimumFractionDigits(int ), 0, this, n);
    }

    @Override
    public synchronized int getMaximumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFractionDigits", $$robo$$android_icu_text_DecimalFormat$getMaximumFractionDigits(), 0, this);
    }

    @Override
    public synchronized void setMaximumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumFractionDigits", $$robo$$android_icu_text_DecimalFormat$setMaximumFractionDigits(int ), 0, this, n);
    }

    public synchronized boolean areSignificantDigitsUsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("areSignificantDigitsUsed", $$robo$$android_icu_text_DecimalFormat$areSignificantDigitsUsed(), 0, this);
    }

    public synchronized void setSignificantDigitsUsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSignificantDigitsUsed", $$robo$$android_icu_text_DecimalFormat$setSignificantDigitsUsed(boolean ), 0, this, bl);
    }

    public synchronized int getMinimumSignificantDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumSignificantDigits", $$robo$$android_icu_text_DecimalFormat$getMinimumSignificantDigits(), 0, this);
    }

    public synchronized void setMinimumSignificantDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumSignificantDigits", $$robo$$android_icu_text_DecimalFormat$setMinimumSignificantDigits(int ), 0, this, n);
    }

    public synchronized int getMaximumSignificantDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumSignificantDigits", $$robo$$android_icu_text_DecimalFormat$getMaximumSignificantDigits(), 0, this);
    }

    public synchronized void setMaximumSignificantDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumSignificantDigits", $$robo$$android_icu_text_DecimalFormat$setMaximumSignificantDigits(int ), 0, this, n);
    }

    public synchronized int getFormatWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getFormatWidth", $$robo$$android_icu_text_DecimalFormat$getFormatWidth(), 0, this);
    }

    public synchronized void setFormatWidth(int n) {
        InvokeDynamicSupport.bootstrap("setFormatWidth", $$robo$$android_icu_text_DecimalFormat$setFormatWidth(int ), 0, this, n);
    }

    public synchronized char getPadCharacter() {
        return (char)InvokeDynamicSupport.bootstrap("getPadCharacter", $$robo$$android_icu_text_DecimalFormat$getPadCharacter(), 0, this);
    }

    public synchronized void setPadCharacter(char c) {
        InvokeDynamicSupport.bootstrap("setPadCharacter", $$robo$$android_icu_text_DecimalFormat$setPadCharacter(char ), 0, this, c);
    }

    public synchronized int getPadPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPadPosition", $$robo$$android_icu_text_DecimalFormat$getPadPosition(), 0, this);
    }

    public synchronized void setPadPosition(int n) {
        InvokeDynamicSupport.bootstrap("setPadPosition", $$robo$$android_icu_text_DecimalFormat$setPadPosition(int ), 0, this, n);
    }

    public synchronized boolean isScientificNotation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScientificNotation", $$robo$$android_icu_text_DecimalFormat$isScientificNotation(), 0, this);
    }

    public synchronized void setScientificNotation(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScientificNotation", $$robo$$android_icu_text_DecimalFormat$setScientificNotation(boolean ), 0, this, bl);
    }

    public synchronized byte getMinimumExponentDigits() {
        return (byte)InvokeDynamicSupport.bootstrap("getMinimumExponentDigits", $$robo$$android_icu_text_DecimalFormat$getMinimumExponentDigits(), 0, this);
    }

    public synchronized void setMinimumExponentDigits(byte by) {
        InvokeDynamicSupport.bootstrap("setMinimumExponentDigits", $$robo$$android_icu_text_DecimalFormat$setMinimumExponentDigits(byte ), 0, this, by);
    }

    public synchronized boolean isExponentSignAlwaysShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExponentSignAlwaysShown", $$robo$$android_icu_text_DecimalFormat$isExponentSignAlwaysShown(), 0, this);
    }

    public synchronized void setExponentSignAlwaysShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExponentSignAlwaysShown", $$robo$$android_icu_text_DecimalFormat$setExponentSignAlwaysShown(boolean ), 0, this, bl);
    }

    @Override
    public synchronized boolean isGroupingUsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupingUsed", $$robo$$android_icu_text_DecimalFormat$isGroupingUsed(), 0, this);
    }

    @Override
    public synchronized void setGroupingUsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupingUsed", $$robo$$android_icu_text_DecimalFormat$setGroupingUsed(boolean ), 0, this, bl);
    }

    public synchronized int getGroupingSize() {
        return (int)InvokeDynamicSupport.bootstrap("getGroupingSize", $$robo$$android_icu_text_DecimalFormat$getGroupingSize(), 0, this);
    }

    public synchronized void setGroupingSize(int n) {
        InvokeDynamicSupport.bootstrap("setGroupingSize", $$robo$$android_icu_text_DecimalFormat$setGroupingSize(int ), 0, this, n);
    }

    public synchronized int getSecondaryGroupingSize() {
        return (int)InvokeDynamicSupport.bootstrap("getSecondaryGroupingSize", $$robo$$android_icu_text_DecimalFormat$getSecondaryGroupingSize(), 0, this);
    }

    public synchronized void setSecondaryGroupingSize(int n) {
        InvokeDynamicSupport.bootstrap("setSecondaryGroupingSize", $$robo$$android_icu_text_DecimalFormat$setSecondaryGroupingSize(int ), 0, this, n);
    }

    @Deprecated
    public synchronized int getMinimumGroupingDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumGroupingDigits", $$robo$$android_icu_text_DecimalFormat$getMinimumGroupingDigits(), 0, this);
    }

    @Deprecated
    public synchronized void setMinimumGroupingDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumGroupingDigits", $$robo$$android_icu_text_DecimalFormat$setMinimumGroupingDigits(int ), 0, this, n);
    }

    public synchronized boolean isDecimalSeparatorAlwaysShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecimalSeparatorAlwaysShown", $$robo$$android_icu_text_DecimalFormat$isDecimalSeparatorAlwaysShown(), 0, this);
    }

    public synchronized void setDecimalSeparatorAlwaysShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDecimalSeparatorAlwaysShown", $$robo$$android_icu_text_DecimalFormat$setDecimalSeparatorAlwaysShown(boolean ), 0, this, bl);
    }

    @Override
    public synchronized Currency getCurrency() {
        return InvokeDynamicSupport.bootstrap("getCurrency", $$robo$$android_icu_text_DecimalFormat$getCurrency(), 0, this);
    }

    @Override
    public synchronized void setCurrency(Currency currency) {
        InvokeDynamicSupport.bootstrap("setCurrency", $$robo$$android_icu_text_DecimalFormat$setCurrency(android.icu.util.Currency ), 0, this, currency);
    }

    public synchronized Currency.CurrencyUsage getCurrencyUsage() {
        return InvokeDynamicSupport.bootstrap("getCurrencyUsage", $$robo$$android_icu_text_DecimalFormat$getCurrencyUsage(), 0, this);
    }

    public synchronized void setCurrencyUsage(Currency.CurrencyUsage currencyUsage) {
        InvokeDynamicSupport.bootstrap("setCurrencyUsage", $$robo$$android_icu_text_DecimalFormat$setCurrencyUsage(android.icu.util.Currency$CurrencyUsage ), 0, this, currencyUsage);
    }

    public synchronized CurrencyPluralInfo getCurrencyPluralInfo() {
        return InvokeDynamicSupport.bootstrap("getCurrencyPluralInfo", $$robo$$android_icu_text_DecimalFormat$getCurrencyPluralInfo(), 0, this);
    }

    public synchronized void setCurrencyPluralInfo(CurrencyPluralInfo currencyPluralInfo) {
        InvokeDynamicSupport.bootstrap("setCurrencyPluralInfo", $$robo$$android_icu_text_DecimalFormat$setCurrencyPluralInfo(android.icu.text.CurrencyPluralInfo ), 0, this, currencyPluralInfo);
    }

    public synchronized boolean isParseBigDecimal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseBigDecimal", $$robo$$android_icu_text_DecimalFormat$isParseBigDecimal(), 0, this);
    }

    public synchronized void setParseBigDecimal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseBigDecimal", $$robo$$android_icu_text_DecimalFormat$setParseBigDecimal(boolean ), 0, this, bl);
    }

    @Deprecated
    public int getParseMaxDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getParseMaxDigits", $$robo$$android_icu_text_DecimalFormat$getParseMaxDigits(), 0, this);
    }

    @Deprecated
    public void setParseMaxDigits(int n) {
        InvokeDynamicSupport.bootstrap("setParseMaxDigits", $$robo$$android_icu_text_DecimalFormat$setParseMaxDigits(int ), 0, this, n);
    }

    @Override
    public synchronized boolean isParseStrict() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseStrict", $$robo$$android_icu_text_DecimalFormat$isParseStrict(), 0, this);
    }

    @Override
    public synchronized void setParseStrict(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseStrict", $$robo$$android_icu_text_DecimalFormat$setParseStrict(boolean ), 0, this, bl);
    }

    @Override
    public synchronized boolean isParseIntegerOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseIntegerOnly", $$robo$$android_icu_text_DecimalFormat$isParseIntegerOnly(), 0, this);
    }

    @Override
    public synchronized void setParseIntegerOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseIntegerOnly", $$robo$$android_icu_text_DecimalFormat$setParseIntegerOnly(boolean ), 0, this, bl);
    }

    public synchronized boolean isDecimalPatternMatchRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDecimalPatternMatchRequired", $$robo$$android_icu_text_DecimalFormat$isDecimalPatternMatchRequired(), 0, this);
    }

    public synchronized void setDecimalPatternMatchRequired(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDecimalPatternMatchRequired", $$robo$$android_icu_text_DecimalFormat$setDecimalPatternMatchRequired(boolean ), 0, this, bl);
    }

    @Deprecated
    public synchronized boolean getParseNoExponent() {
        return (boolean)InvokeDynamicSupport.bootstrap("getParseNoExponent", $$robo$$android_icu_text_DecimalFormat$getParseNoExponent(), 0, this);
    }

    @Deprecated
    public synchronized void setParseNoExponent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseNoExponent", $$robo$$android_icu_text_DecimalFormat$setParseNoExponent(boolean ), 0, this, bl);
    }

    @Deprecated
    public synchronized boolean getParseCaseSensitive() {
        return (boolean)InvokeDynamicSupport.bootstrap("getParseCaseSensitive", $$robo$$android_icu_text_DecimalFormat$getParseCaseSensitive(), 0, this);
    }

    @Deprecated
    public synchronized void setParseCaseSensitive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseCaseSensitive", $$robo$$android_icu_text_DecimalFormat$setParseCaseSensitive(boolean ), 0, this, bl);
    }

    @Override
    public synchronized boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DecimalFormat$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public synchronized int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DecimalFormat$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DecimalFormat$toString(), 0, this);
    }

    public synchronized String toPattern() {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$android_icu_text_DecimalFormat$toPattern(), 0, this);
    }

    public synchronized String toLocalizedPattern() {
        return InvokeDynamicSupport.bootstrap("toLocalizedPattern", $$robo$$android_icu_text_DecimalFormat$toLocalizedPattern(), 0, this);
    }

    public LocalizedNumberFormatter toNumberFormatter() {
        return InvokeDynamicSupport.bootstrap("toNumberFormatter", $$robo$$android_icu_text_DecimalFormat$toNumberFormatter(), 0, this);
    }

    @Deprecated
    public PluralRules.IFixedDecimal getFixedDecimal(double d) {
        return InvokeDynamicSupport.bootstrap("getFixedDecimal", $$robo$$android_icu_text_DecimalFormat$getFixedDecimal(double ), 0, this, d);
    }

    void refreshFormatter() {
        InvokeDynamicSupport.bootstrap("refreshFormatter", $$robo$$android_icu_text_DecimalFormat$refreshFormatter(), 0, this);
    }

    private Number safeConvertBigDecimal(java.math.BigDecimal bigDecimal) {
        return InvokeDynamicSupport.bootstrap("safeConvertBigDecimal", $$robo$$android_icu_text_DecimalFormat$safeConvertBigDecimal(java.math.BigDecimal ), 0, this, bigDecimal);
    }

    private static boolean useCurrency(DecimalFormatProperties decimalFormatProperties) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("useCurrency", $$robo$$android_icu_text_DecimalFormat$useCurrency(android.icu.impl.number.DecimalFormatProperties ), 0, (DecimalFormatProperties)decimalFormatProperties);
    }

    void setPropertiesFromPattern(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPropertiesFromPattern", $$robo$$android_icu_text_DecimalFormat$setPropertiesFromPattern(java.lang.String int ), 0, this, string2, n);
    }

    @Deprecated
    public synchronized void setProperties(PropertySetter propertySetter) {
        InvokeDynamicSupport.bootstrap("setProperties", $$robo$$android_icu_text_DecimalFormat$setProperties(android.icu.text.DecimalFormat$PropertySetter ), 0, this, propertySetter);
    }

    static {
        RobolectricInternals.classInitializing(DecimalFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecimalFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static interface PropertySetter
    extends InstrumentedInterface {
        @Deprecated
        public void set(DecimalFormatProperties var1);
    }
}

