/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import com.google.errorprone.annotations.DoNotMock;
import java.nio.BufferOverflowException;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Edits
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_UNCHANGED_LENGTH = 4096;
    private static int MAX_UNCHANGED = 4095;
    private static int MAX_SHORT_CHANGE_OLD_LENGTH = 6;
    private static int MAX_SHORT_CHANGE_NEW_LENGTH = 7;
    private static int SHORT_CHANGE_NUM_MASK = 511;
    private static int MAX_SHORT_CHANGE = 28671;
    private static int LENGTH_IN_1TRAIL = 61;
    private static int LENGTH_IN_2TRAIL = 62;
    private static int STACK_CAPACITY = 100;
    private char[] array;
    private int length;
    private int delta;
    private int numChanges;

    private void $$robo$$android_icu_text_Edits$__constructor__() {
        this.array = new char[100];
    }

    private final void $$robo$$android_icu_text_Edits$reset() {
        this.numChanges = 0;
        this.delta = 0;
        this.length = 0;
    }

    private final void $$robo$$android_icu_text_Edits$setLastUnit(int last) {
        this.array[this.length - 1] = (char)last;
    }

    private final int $$robo$$android_icu_text_Edits$lastUnit() {
        return this.length > 0 ? this.array[this.length - 1] : 65535;
    }

    private final void $$robo$$android_icu_text_Edits$addUnchanged(int unchangedLength) {
        if (unchangedLength < 0) {
            throw new IllegalArgumentException("addUnchanged(" + unchangedLength + "): length must not be negative");
        }
        int last = this.lastUnit();
        if (last < 4095) {
            int remaining = 4095 - last;
            if (remaining >= unchangedLength) {
                this.setLastUnit(last + unchangedLength);
                return;
            }
            this.setLastUnit(4095);
            unchangedLength -= remaining;
        }
        while (unchangedLength >= 4096) {
            this.append(4095);
            unchangedLength -= 4096;
        }
        if (unchangedLength > 0) {
            this.append(unchangedLength - 1);
        }
    }

    private final void $$robo$$android_icu_text_Edits$addReplace(int oldLength, int newLength) {
        if (oldLength < 0 || newLength < 0) {
            throw new IllegalArgumentException("addReplace(" + oldLength + ", " + newLength + "): both lengths must be non-negative");
        }
        if (oldLength == 0 && newLength == 0) {
            return;
        }
        ++this.numChanges;
        int newDelta = newLength - oldLength;
        if (newDelta != 0) {
            if (newDelta > 0 && this.delta >= 0 && newDelta > Integer.MAX_VALUE - this.delta || newDelta < 0 && this.delta < 0 && newDelta < Integer.MIN_VALUE - this.delta) {
                throw new IndexOutOfBoundsException();
            }
            this.delta += newDelta;
        }
        if (0 < oldLength && oldLength <= 6 && newLength <= 7) {
            int u = oldLength << 12 | newLength << 9;
            int last = this.lastUnit();
            if (4095 < last && last < 28671 && (last & 0xFFFFFE00) == u && (last & 0x1FF) < 511) {
                this.setLastUnit(last + 1);
                return;
            }
            this.append(u);
            return;
        }
        int head = 28672;
        if (oldLength < 61 && newLength < 61) {
            head |= oldLength << 6;
            this.append(head |= newLength);
        } else if (this.array.length - this.length >= 5 || this.growArray()) {
            int limit = this.length + 1;
            if (oldLength < 61) {
                head |= oldLength << 6;
            } else if (oldLength <= Short.MAX_VALUE) {
                head |= 0xF40;
                this.array[limit++] = (char)(0x8000 | oldLength);
            } else {
                head |= 62 + (oldLength >> 30) << 6;
                this.array[limit++] = (char)(0x8000 | oldLength >> 15);
                this.array[limit++] = (char)(0x8000 | oldLength);
            }
            if (newLength < 61) {
                head |= newLength;
            } else if (newLength <= Short.MAX_VALUE) {
                head |= 0x3D;
                this.array[limit++] = (char)(0x8000 | newLength);
            } else {
                head |= 62 + (newLength >> 30);
                this.array[limit++] = (char)(0x8000 | newLength >> 15);
                this.array[limit++] = (char)(0x8000 | newLength);
            }
            this.array[this.length] = (char)head;
            this.length = limit;
        }
    }

    private final void $$robo$$android_icu_text_Edits$append(int r) {
        if (this.length < this.array.length || this.growArray()) {
            this.array[this.length++] = (char)r;
        }
    }

    private final boolean $$robo$$android_icu_text_Edits$growArray() {
        int newCapacity;
        if (this.array.length == 100) {
            newCapacity = 2000;
        } else {
            if (this.array.length == Integer.MAX_VALUE) {
                throw new BufferOverflowException();
            }
            newCapacity = this.array.length >= 0x3FFFFFFF ? Integer.MAX_VALUE : 2 * this.array.length;
        }
        if (newCapacity - this.array.length < 5) {
            throw new BufferOverflowException();
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
        return true;
    }

    private final int $$robo$$android_icu_text_Edits$lengthDelta() {
        return this.delta;
    }

    private final boolean $$robo$$android_icu_text_Edits$hasChanges() {
        return this.numChanges != 0;
    }

    private final int $$robo$$android_icu_text_Edits$numberOfChanges() {
        return this.numChanges;
    }

    private final Iterator $$robo$$android_icu_text_Edits$getCoarseChangesIterator() {
        return new Iterator(this.array, this.length, true, true);
    }

    private final Iterator $$robo$$android_icu_text_Edits$getCoarseIterator() {
        return new Iterator(this.array, this.length, false, true);
    }

    private final Iterator $$robo$$android_icu_text_Edits$getFineChangesIterator() {
        return new Iterator(this.array, this.length, true, false);
    }

    private final Iterator $$robo$$android_icu_text_Edits$getFineIterator() {
        return new Iterator(this.array, this.length, false, false);
    }

    private final Edits $$robo$$android_icu_text_Edits$mergeAndAppend(Edits ab, Edits bc) {
        Iterator abIter = ab.getFineIterator();
        Iterator bcIter = bc.getFineIterator();
        boolean abHasNext = true;
        boolean bcHasNext = true;
        int aLength = 0;
        int ab_bLength = 0;
        int bc_bLength = 0;
        int cLength = 0;
        int pending_aLength = 0;
        int pending_cLength = 0;
        while (true) {
            if (bc_bLength == 0 && bcHasNext && (bcHasNext = bcIter.next())) {
                bc_bLength = bcIter.oldLength();
                cLength = bcIter.newLength();
                if (bc_bLength == 0) {
                    if (ab_bLength == 0 || !abIter.hasChange()) {
                        this.addReplace(pending_aLength, pending_cLength + cLength);
                        pending_cLength = 0;
                        pending_aLength = 0;
                        continue;
                    }
                    pending_cLength += cLength;
                    continue;
                }
            }
            if (ab_bLength == 0) {
                if (abHasNext && (abHasNext = abIter.next())) {
                    aLength = abIter.oldLength();
                    ab_bLength = abIter.newLength();
                    if (ab_bLength == 0) {
                        if (bc_bLength == bcIter.oldLength() || !bcIter.hasChange()) {
                            this.addReplace(pending_aLength + aLength, pending_cLength);
                            pending_cLength = 0;
                            pending_aLength = 0;
                            continue;
                        }
                        pending_aLength += aLength;
                        continue;
                    }
                } else {
                    if (bc_bLength == 0) break;
                    throw new IllegalArgumentException("The ab output string is shorter than the bc input string.");
                }
            }
            if (bc_bLength == 0) {
                throw new IllegalArgumentException("The bc input string is shorter than the ab output string.");
            }
            if (!abIter.hasChange() && !bcIter.hasChange()) {
                if (pending_aLength != 0 || pending_cLength != 0) {
                    this.addReplace(pending_aLength, pending_cLength);
                    pending_cLength = 0;
                    pending_aLength = 0;
                }
                int unchangedLength = aLength <= cLength ? aLength : cLength;
                this.addUnchanged(unchangedLength);
                ab_bLength = aLength -= unchangedLength;
                bc_bLength = cLength -= unchangedLength;
                continue;
            }
            if (!abIter.hasChange() && bcIter.hasChange()) {
                if (ab_bLength >= bc_bLength) {
                    this.addReplace(pending_aLength + bc_bLength, pending_cLength + cLength);
                    pending_cLength = 0;
                    pending_aLength = 0;
                    aLength = ab_bLength -= bc_bLength;
                    bc_bLength = 0;
                    continue;
                }
            } else if (abIter.hasChange() && !bcIter.hasChange()) {
                if (ab_bLength <= bc_bLength) {
                    this.addReplace(pending_aLength + aLength, pending_cLength + ab_bLength);
                    pending_cLength = 0;
                    pending_aLength = 0;
                    cLength = bc_bLength -= ab_bLength;
                    ab_bLength = 0;
                    continue;
                }
            } else if (ab_bLength == bc_bLength) {
                this.addReplace(pending_aLength + aLength, pending_cLength + cLength);
                pending_cLength = 0;
                pending_aLength = 0;
                bc_bLength = 0;
                ab_bLength = 0;
                continue;
            }
            pending_aLength += aLength;
            pending_cLength += cLength;
            if (ab_bLength < bc_bLength) {
                bc_bLength -= ab_bLength;
                ab_bLength = 0;
                cLength = 0;
                continue;
            }
            ab_bLength -= bc_bLength;
            bc_bLength = 0;
            aLength = 0;
        }
        if (pending_aLength != 0 || pending_cLength != 0) {
            this.addReplace(pending_aLength, pending_cLength);
        }
        return this;
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_Edits$__constructor__();
    }

    public Edits() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Edits$__constructor__(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_Edits$reset(), 0, this);
    }

    private void setLastUnit(int n) {
        InvokeDynamicSupport.bootstrap("setLastUnit", $$robo$$android_icu_text_Edits$setLastUnit(int ), 0, this, n);
    }

    private int lastUnit() {
        return (int)InvokeDynamicSupport.bootstrap("lastUnit", $$robo$$android_icu_text_Edits$lastUnit(), 0, this);
    }

    public void addUnchanged(int n) {
        InvokeDynamicSupport.bootstrap("addUnchanged", $$robo$$android_icu_text_Edits$addUnchanged(int ), 0, this, n);
    }

    public void addReplace(int n, int n2) {
        InvokeDynamicSupport.bootstrap("addReplace", $$robo$$android_icu_text_Edits$addReplace(int int ), 0, this, n, n2);
    }

    private void append(int n) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_Edits$append(int ), 0, this, n);
    }

    private boolean growArray() {
        return (boolean)InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_icu_text_Edits$growArray(), 0, this);
    }

    public int lengthDelta() {
        return (int)InvokeDynamicSupport.bootstrap("lengthDelta", $$robo$$android_icu_text_Edits$lengthDelta(), 0, this);
    }

    public boolean hasChanges() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasChanges", $$robo$$android_icu_text_Edits$hasChanges(), 0, this);
    }

    public int numberOfChanges() {
        return (int)InvokeDynamicSupport.bootstrap("numberOfChanges", $$robo$$android_icu_text_Edits$numberOfChanges(), 0, this);
    }

    public Iterator getCoarseChangesIterator() {
        return InvokeDynamicSupport.bootstrap("getCoarseChangesIterator", $$robo$$android_icu_text_Edits$getCoarseChangesIterator(), 0, this);
    }

    public Iterator getCoarseIterator() {
        return InvokeDynamicSupport.bootstrap("getCoarseIterator", $$robo$$android_icu_text_Edits$getCoarseIterator(), 0, this);
    }

    public Iterator getFineChangesIterator() {
        return InvokeDynamicSupport.bootstrap("getFineChangesIterator", $$robo$$android_icu_text_Edits$getFineChangesIterator(), 0, this);
    }

    public Iterator getFineIterator() {
        return InvokeDynamicSupport.bootstrap("getFineIterator", $$robo$$android_icu_text_Edits$getFineIterator(), 0, this);
    }

    public Edits mergeAndAppend(Edits edits, Edits edits2) {
        return InvokeDynamicSupport.bootstrap("mergeAndAppend", $$robo$$android_icu_text_Edits$mergeAndAppend(android.icu.text.Edits android.icu.text.Edits ), 0, this, edits, edits2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Edits)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Iterator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private char[] array;
        private int index;
        private int length;
        private int remaining;
        private boolean onlyChanges_;
        private boolean coarse;
        private int dir;
        private boolean changed;
        private int oldLength_;
        private int newLength_;
        private int srcIndex;
        private int replIndex;
        private int destIndex;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_Edits_Iterator$__constructor__(char[] a, int len, boolean oc, boolean crs) {
            this.array = a;
            this.length = len;
            this.onlyChanges_ = oc;
            this.coarse = crs;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$readLength(int head) {
            if (head < 61) {
                return head;
            }
            if (head < 62) {
                if (!$assertionsDisabled && this.index >= this.length) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.array[this.index] < '\u8000') {
                    throw new AssertionError();
                }
                return this.array[this.index++] & Short.MAX_VALUE;
            }
            if (!$assertionsDisabled && this.index + 2 > this.length) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.array[this.index] < '\u8000') {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.array[this.index + 1] < '\u8000') {
                throw new AssertionError();
            }
            int len = (head & 1) << 30 | (this.array[this.index] & Short.MAX_VALUE) << 15 | this.array[this.index + 1] & Short.MAX_VALUE;
            this.index += 2;
            return len;
        }

        private final void $$robo$$android_icu_text_Edits_Iterator$updateNextIndexes() {
            this.srcIndex += this.oldLength_;
            if (this.changed) {
                this.replIndex += this.newLength_;
            }
            this.destIndex += this.newLength_;
        }

        private final void $$robo$$android_icu_text_Edits_Iterator$updatePreviousIndexes() {
            this.srcIndex -= this.oldLength_;
            if (this.changed) {
                this.replIndex -= this.newLength_;
            }
            this.destIndex -= this.newLength_;
        }

        private final boolean $$robo$$android_icu_text_Edits_Iterator$noNext() {
            this.dir = 0;
            this.changed = false;
            this.newLength_ = 0;
            this.oldLength_ = 0;
            return false;
        }

        private final boolean $$robo$$android_icu_text_Edits_Iterator$next() {
            return this.next(this.onlyChanges_);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final boolean $$robo$$android_icu_text_Edits_Iterator$next(boolean onlyChanges) {
            char u;
            block19: {
                if (this.dir > 0) {
                    this.updateNextIndexes();
                } else {
                    if (this.dir < 0 && this.remaining > 0) {
                        ++this.index;
                        this.dir = 1;
                        return true;
                    }
                    this.dir = 1;
                }
                if (this.remaining >= 1) {
                    if (this.remaining > 1) {
                        --this.remaining;
                        return true;
                    }
                    this.remaining = 0;
                }
                if (this.index >= this.length) {
                    return this.noNext();
                }
                if ((u = this.array[this.index++]) <= '\u0fff') {
                    this.changed = false;
                    this.oldLength_ = u + '\u0001';
                    while (this.index < this.length && (u = this.array[this.index]) <= '\u0fff') {
                        ++this.index;
                        this.oldLength_ += u + '\u0001';
                    }
                    this.newLength_ = this.oldLength_;
                    if (!onlyChanges) {
                        return true;
                    }
                    this.updateNextIndexes();
                    if (this.index >= this.length) {
                        return this.noNext();
                    }
                    ++this.index;
                }
                this.changed = true;
                if (u <= '\u6fff') {
                    int oldLen = u >> 12;
                    int newLen = u >> 9 & 7;
                    int num = (u & 0x1FF) + 1;
                    if (this.coarse) {
                        this.oldLength_ = num * oldLen;
                        this.newLength_ = num * newLen;
                        break block19;
                    } else {
                        this.oldLength_ = oldLen;
                        this.newLength_ = newLen;
                        if (num > 1) {
                            this.remaining = num;
                        }
                        return true;
                    }
                }
                if (!$assertionsDisabled && u > Short.MAX_VALUE) {
                    throw new AssertionError();
                }
                this.oldLength_ = this.readLength(u >> 6 & 0x3F);
                this.newLength_ = this.readLength(u & 0x3F);
                if (!this.coarse) {
                    return true;
                }
            }
            while (this.index < this.length && (u = this.array[this.index]) > '\u0fff') {
                ++this.index;
                if (u <= '\u6fff') {
                    int num = (u & 0x1FF) + 1;
                    this.oldLength_ += (u >> 12) * num;
                    this.newLength_ += (u >> 9 & 7) * num;
                    continue;
                }
                if (!$assertionsDisabled && u > Short.MAX_VALUE) {
                    throw new AssertionError();
                }
                this.oldLength_ += this.readLength(u >> 6 & 0x3F);
                this.newLength_ += this.readLength(u & 0x3F);
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final boolean $$robo$$android_icu_text_Edits_Iterator$previous() {
            int headIndex;
            char u;
            block21: {
                if (this.dir >= 0) {
                    if (this.dir > 0) {
                        if (this.remaining > 0) {
                            --this.index;
                            this.dir = -1;
                            return true;
                        }
                        this.updateNextIndexes();
                    }
                    this.dir = -1;
                }
                if (this.remaining > 0) {
                    u = this.array[this.index];
                    if (!($assertionsDisabled || '\u0fff' < u && u <= '\u6fff')) {
                        throw new AssertionError();
                    }
                    if (this.remaining <= (u & 0x1FF)) {
                        ++this.remaining;
                        this.updatePreviousIndexes();
                        return true;
                    }
                    this.remaining = 0;
                }
                if (this.index <= 0) {
                    return this.noNext();
                }
                if ((u = this.array[--this.index]) <= '\u0fff') {
                    this.changed = false;
                    this.oldLength_ = u + '\u0001';
                    while (this.index > 0 && (u = this.array[this.index - 1]) <= '\u0fff') {
                        --this.index;
                        this.oldLength_ += u + '\u0001';
                    }
                    this.newLength_ = this.oldLength_;
                    this.updatePreviousIndexes();
                    return true;
                }
                this.changed = true;
                if (u <= '\u6fff') {
                    int oldLen = u >> 12;
                    int newLen = u >> 9 & 7;
                    int num = (u & 0x1FF) + 1;
                    if (this.coarse) {
                        this.oldLength_ = num * oldLen;
                        this.newLength_ = num * newLen;
                        break block21;
                    } else {
                        this.oldLength_ = oldLen;
                        this.newLength_ = newLen;
                        if (num > 1) {
                            this.remaining = 1;
                        }
                        this.updatePreviousIndexes();
                        return true;
                    }
                }
                if (u <= Short.MAX_VALUE) {
                    this.oldLength_ = this.readLength(u >> 6 & 0x3F);
                    this.newLength_ = this.readLength(u & 0x3F);
                } else {
                    if (!$assertionsDisabled && this.index <= 0) {
                        throw new AssertionError();
                    }
                    while ((u = this.array[--this.index]) > Short.MAX_VALUE) {
                    }
                    if (!$assertionsDisabled && u <= '\u6fff') {
                        throw new AssertionError();
                    }
                    headIndex = this.index++;
                    this.oldLength_ = this.readLength(u >> 6 & 0x3F);
                    this.newLength_ = this.readLength(u & 0x3F);
                    this.index = headIndex;
                }
                if (!this.coarse) {
                    this.updatePreviousIndexes();
                    return true;
                }
            }
            while (this.index > 0 && (u = this.array[this.index - 1]) > '\u0fff') {
                --this.index;
                if (u <= '\u6fff') {
                    int num = (u & 0x1FF) + 1;
                    this.oldLength_ += (u >> 12) * num;
                    this.newLength_ += (u >> 9 & 7) * num;
                    continue;
                }
                if (u > Short.MAX_VALUE) continue;
                ++this.index;
                this.oldLength_ += this.readLength(u >> 6 & 0x3F);
                this.newLength_ += this.readLength(u & 0x3F);
                this.index = headIndex;
            }
            this.updatePreviousIndexes();
            return true;
        }

        private final boolean $$robo$$android_icu_text_Edits_Iterator$findSourceIndex(int i) {
            return this.findIndex(i, true) == 0;
        }

        private final boolean $$robo$$android_icu_text_Edits_Iterator$findDestinationIndex(int i) {
            return this.findIndex(i, false) == 0;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$findIndex(int i, boolean findSource) {
            int spanLength;
            int spanStart;
            if (i < 0) {
                return -1;
            }
            if (findSource) {
                spanStart = this.srcIndex;
                spanLength = this.oldLength_;
            } else {
                spanStart = this.destIndex;
                spanLength = this.newLength_;
            }
            if (i < spanStart) {
                if (i >= spanStart / 2) {
                    while (true) {
                        boolean hasPrevious = this.previous();
                        if (!$assertionsDisabled && !hasPrevious) {
                            throw new AssertionError();
                        }
                        int n = spanStart = findSource ? this.srcIndex : this.destIndex;
                        if (i >= spanStart) {
                            return 0;
                        }
                        if (this.remaining <= 0) continue;
                        spanLength = findSource ? this.oldLength_ : this.newLength_;
                        char u = this.array[this.index];
                        if (!($assertionsDisabled || '\u0fff' < u && u <= '\u6fff')) {
                            throw new AssertionError();
                        }
                        int num = (u & 0x1FF) + 1 - this.remaining;
                        int len = num * spanLength;
                        if (i >= spanStart - len) {
                            int n2 = (spanStart - i - 1) / spanLength + 1;
                            this.srcIndex -= n2 * this.oldLength_;
                            this.replIndex -= n2 * this.newLength_;
                            this.destIndex -= n2 * this.newLength_;
                            this.remaining += n2;
                            return 0;
                        }
                        this.srcIndex -= num * this.oldLength_;
                        this.replIndex -= num * this.newLength_;
                        this.destIndex -= num * this.newLength_;
                        this.remaining = 0;
                    }
                }
                this.dir = 0;
                this.destIndex = 0;
                this.replIndex = 0;
                this.srcIndex = 0;
                this.newLength_ = 0;
                this.oldLength_ = 0;
                this.remaining = 0;
                this.index = 0;
            } else if (i < spanStart + spanLength) {
                return 0;
            }
            while (this.next(false)) {
                if (findSource) {
                    spanStart = this.srcIndex;
                    spanLength = this.oldLength_;
                } else {
                    spanStart = this.destIndex;
                    spanLength = this.newLength_;
                }
                if (i < spanStart + spanLength) {
                    return 0;
                }
                if (this.remaining <= 1) continue;
                int len = this.remaining * spanLength;
                if (i < spanStart + len) {
                    int n = (i - spanStart) / spanLength;
                    this.srcIndex += n * this.oldLength_;
                    this.replIndex += n * this.newLength_;
                    this.destIndex += n * this.newLength_;
                    this.remaining -= n;
                    return 0;
                }
                this.oldLength_ *= this.remaining;
                this.newLength_ *= this.remaining;
                this.remaining = 0;
            }
            return 1;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$destinationIndexFromSourceIndex(int i) {
            int where = this.findIndex(i, true);
            if (where < 0) {
                return 0;
            }
            if (where > 0 || i == this.srcIndex) {
                return this.destIndex;
            }
            if (this.changed) {
                return this.destIndex + this.newLength_;
            }
            return this.destIndex + (i - this.srcIndex);
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$sourceIndexFromDestinationIndex(int i) {
            int where = this.findIndex(i, false);
            if (where < 0) {
                return 0;
            }
            if (where > 0 || i == this.destIndex) {
                return this.srcIndex;
            }
            if (this.changed) {
                return this.srcIndex + this.oldLength_;
            }
            return this.srcIndex + (i - this.destIndex);
        }

        private final boolean $$robo$$android_icu_text_Edits_Iterator$hasChange() {
            return this.changed;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$oldLength() {
            return this.oldLength_;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$newLength() {
            return this.newLength_;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$sourceIndex() {
            return this.srcIndex;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$replacementIndex() {
            return this.replIndex;
        }

        private final int $$robo$$android_icu_text_Edits_Iterator$destinationIndex() {
            return this.destIndex;
        }

        private /* synthetic */ void $$robo$$android_icu_text_Edits_Iterator$__constructor__(char[] x0, int x1, boolean x2, boolean x3, 1 x4) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !Edits.class.desiredAssertionStatus();
        }

        private void __constructor__(char[] cArray, int n, boolean bl, boolean bl2) {
            this.$$robo$$android_icu_text_Edits_Iterator$__constructor__(cArray, n, bl, bl2);
        }

        private Iterator(char[] cArray, int n, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_Edits_Iterator$__constructor__(char[] int boolean boolean ), 0, this, cArray, n, bl, bl2);
        }

        private int readLength(int n) {
            return (int)InvokeDynamicSupport.bootstrap("readLength", $$robo$$android_icu_text_Edits_Iterator$readLength(int ), 0, this, n);
        }

        private void updateNextIndexes() {
            InvokeDynamicSupport.bootstrap("updateNextIndexes", $$robo$$android_icu_text_Edits_Iterator$updateNextIndexes(), 0, this);
        }

        private void updatePreviousIndexes() {
            InvokeDynamicSupport.bootstrap("updatePreviousIndexes", $$robo$$android_icu_text_Edits_Iterator$updatePreviousIndexes(), 0, this);
        }

        private boolean noNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("noNext", $$robo$$android_icu_text_Edits_Iterator$noNext(), 0, this);
        }

        public boolean next() {
            return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_Edits_Iterator$next(), 0, this);
        }

        private boolean next(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_Edits_Iterator$next(boolean ), 0, this, bl);
        }

        private boolean previous() {
            return (boolean)InvokeDynamicSupport.bootstrap("previous", $$robo$$android_icu_text_Edits_Iterator$previous(), 0, this);
        }

        public boolean findSourceIndex(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("findSourceIndex", $$robo$$android_icu_text_Edits_Iterator$findSourceIndex(int ), 0, this, n);
        }

        public boolean findDestinationIndex(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("findDestinationIndex", $$robo$$android_icu_text_Edits_Iterator$findDestinationIndex(int ), 0, this, n);
        }

        private int findIndex(int n, boolean bl) {
            return (int)InvokeDynamicSupport.bootstrap("findIndex", $$robo$$android_icu_text_Edits_Iterator$findIndex(int boolean ), 0, this, n, bl);
        }

        public int destinationIndexFromSourceIndex(int n) {
            return (int)InvokeDynamicSupport.bootstrap("destinationIndexFromSourceIndex", $$robo$$android_icu_text_Edits_Iterator$destinationIndexFromSourceIndex(int ), 0, this, n);
        }

        public int sourceIndexFromDestinationIndex(int n) {
            return (int)InvokeDynamicSupport.bootstrap("sourceIndexFromDestinationIndex", $$robo$$android_icu_text_Edits_Iterator$sourceIndexFromDestinationIndex(int ), 0, this, n);
        }

        public boolean hasChange() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasChange", $$robo$$android_icu_text_Edits_Iterator$hasChange(), 0, this);
        }

        public int oldLength() {
            return (int)InvokeDynamicSupport.bootstrap("oldLength", $$robo$$android_icu_text_Edits_Iterator$oldLength(), 0, this);
        }

        public int newLength() {
            return (int)InvokeDynamicSupport.bootstrap("newLength", $$robo$$android_icu_text_Edits_Iterator$newLength(), 0, this);
        }

        public int sourceIndex() {
            return (int)InvokeDynamicSupport.bootstrap("sourceIndex", $$robo$$android_icu_text_Edits_Iterator$sourceIndex(), 0, this);
        }

        public int replacementIndex() {
            return (int)InvokeDynamicSupport.bootstrap("replacementIndex", $$robo$$android_icu_text_Edits_Iterator$replacementIndex(), 0, this);
        }

        public int destinationIndex() {
            return (int)InvokeDynamicSupport.bootstrap("destinationIndex", $$robo$$android_icu_text_Edits_Iterator$destinationIndex(), 0, this);
        }

        private /* synthetic */ void __constructor__(char[] cArray, int n, boolean bl, boolean bl2, 1 var5_5) {
            this.$$robo$$android_icu_text_Edits_Iterator$__constructor__(cArray, n, bl, bl2, var5_5);
        }

        static {
            RobolectricInternals.classInitializing(Iterator.class);
        }

        public /* synthetic */ Iterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Iterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

