/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.MessagePattern;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MessagePatternUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_icu_text_MessagePatternUtil$__constructor__() {
    }

    private static final MessageNode $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(String patternString) {
        return MessagePatternUtil.buildMessageNode(new MessagePattern(patternString));
    }

    private static final MessageNode $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(MessagePattern pattern) {
        int limit = pattern.countParts() - 1;
        if (limit < 0) {
            throw new IllegalArgumentException("The MessagePattern is empty");
        }
        if (pattern.getPartType(0) != MessagePattern.Part.Type.MSG_START) {
            throw new IllegalArgumentException("The MessagePattern does not represent a MessageFormat pattern");
        }
        return MessagePatternUtil.buildMessageNode(pattern, 0, limit);
    }

    private static final MessageNode $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(MessagePattern pattern, int start, int limit) {
        int prevPatternIndex = pattern.getPart(start).getLimit();
        MessageNode node = new MessageNode();
        int i = start + 1;
        while (true) {
            MessagePattern.Part part;
            int patternIndex;
            if (prevPatternIndex < (patternIndex = (part = pattern.getPart(i)).getIndex())) {
                node.addContentsNode(new TextNode(pattern.getPatternString().substring(prevPatternIndex, patternIndex)));
            }
            if (i == limit) break;
            MessagePattern.Part.Type partType = part.getType();
            if (partType == MessagePattern.Part.Type.ARG_START) {
                int argLimit = pattern.getLimitPartIndex(i);
                node.addContentsNode(MessagePatternUtil.buildArgNode(pattern, i, argLimit));
                i = argLimit;
                part = pattern.getPart(i);
            } else if (partType == MessagePattern.Part.Type.REPLACE_NUMBER) {
                node.addContentsNode(MessageContentsNode.createReplaceNumberNode());
            }
            prevPatternIndex = part.getLimit();
            ++i;
        }
        return node.freeze();
    }

    private static final ArgNode $$robo$$android_icu_text_MessagePatternUtil$buildArgNode(MessagePattern pattern, int start, int limit) {
        ArgNode node = ArgNode.createArgNode();
        MessagePattern.Part part = pattern.getPart(start);
        MessagePattern.ArgType argType = node.argType = part.getArgType();
        part = pattern.getPart(++start);
        node.name = pattern.getSubstring(part);
        if (part.getType() == MessagePattern.Part.Type.ARG_NUMBER) {
            node.number = part.getValue();
        }
        ++start;
        switch (1.$SwitchMap$android$icu$text$MessagePattern$ArgType[argType.ordinal()]) {
            case 1: {
                node.typeName = pattern.getSubstring(pattern.getPart(start++));
                if (start >= limit) break;
                node.style = pattern.getSubstring(pattern.getPart(start));
                break;
            }
            case 2: {
                node.typeName = "choice";
                node.complexStyle = MessagePatternUtil.buildChoiceStyleNode(pattern, start, limit);
                break;
            }
            case 3: {
                node.typeName = "plural";
                node.complexStyle = MessagePatternUtil.buildPluralStyleNode(pattern, start, limit, argType);
                break;
            }
            case 4: {
                node.typeName = "select";
                node.complexStyle = MessagePatternUtil.buildSelectStyleNode(pattern, start, limit);
                break;
            }
            case 5: {
                node.typeName = "selectordinal";
                node.complexStyle = MessagePatternUtil.buildPluralStyleNode(pattern, start, limit, argType);
                break;
            }
        }
        return node;
    }

    private static final ComplexArgStyleNode $$robo$$android_icu_text_MessagePatternUtil$buildChoiceStyleNode(MessagePattern pattern, int start, int limit) {
        ComplexArgStyleNode node = new ComplexArgStyleNode(MessagePattern.ArgType.CHOICE);
        while (start < limit) {
            int valueIndex = start;
            MessagePattern.Part part = pattern.getPart(start);
            double value = pattern.getNumericValue(part);
            int msgLimit = pattern.getLimitPartIndex(start += 2);
            VariantNode variant = new VariantNode();
            variant.selector = pattern.getSubstring(pattern.getPart(valueIndex + 1));
            variant.numericValue = value;
            variant.msgNode = MessagePatternUtil.buildMessageNode(pattern, start, msgLimit);
            node.addVariant(variant);
            start = msgLimit + 1;
        }
        return node.freeze();
    }

    private static final ComplexArgStyleNode $$robo$$android_icu_text_MessagePatternUtil$buildPluralStyleNode(MessagePattern pattern, int start, int limit, MessagePattern.ArgType argType) {
        ComplexArgStyleNode node = new ComplexArgStyleNode(argType);
        MessagePattern.Part offset = pattern.getPart(start);
        if (offset.getType().hasNumericValue()) {
            node.explicitOffset = true;
            node.offset = pattern.getNumericValue(offset);
            ++start;
        }
        while (start < limit) {
            MessagePattern.Part selector = pattern.getPart(start++);
            double value = -1.23456789E8;
            MessagePattern.Part part = pattern.getPart(start);
            if (part.getType().hasNumericValue()) {
                value = pattern.getNumericValue(part);
                ++start;
            }
            int msgLimit = pattern.getLimitPartIndex(start);
            VariantNode variant = new VariantNode();
            variant.selector = pattern.getSubstring(selector);
            variant.numericValue = value;
            variant.msgNode = MessagePatternUtil.buildMessageNode(pattern, start, msgLimit);
            node.addVariant(variant);
            start = msgLimit + 1;
        }
        return node.freeze();
    }

    private static final ComplexArgStyleNode $$robo$$android_icu_text_MessagePatternUtil$buildSelectStyleNode(MessagePattern pattern, int start, int limit) {
        ComplexArgStyleNode node = new ComplexArgStyleNode(MessagePattern.ArgType.SELECT);
        while (start < limit) {
            MessagePattern.Part selector = pattern.getPart(start++);
            int msgLimit = pattern.getLimitPartIndex(start);
            VariantNode variant = new VariantNode();
            variant.selector = pattern.getSubstring(selector);
            variant.msgNode = MessagePatternUtil.buildMessageNode(pattern, start, msgLimit);
            node.addVariant(variant);
            start = msgLimit + 1;
        }
        return node.freeze();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_MessagePatternUtil$__constructor__();
    }

    private MessagePatternUtil() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil$__constructor__(), 0, this);
    }

    public static MessageNode buildMessageNode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessageNode", $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(java.lang.String ), 0, (String)string2);
    }

    public static MessageNode buildMessageNode(MessagePattern messagePattern) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessageNode", $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(android.icu.text.MessagePattern ), 0, (MessagePattern)messagePattern);
    }

    private static MessageNode buildMessageNode(MessagePattern messagePattern, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessageNode", $$robo$$android_icu_text_MessagePatternUtil$buildMessageNode(android.icu.text.MessagePattern int int ), 0, (MessagePattern)messagePattern, (int)n, (int)n2);
    }

    private static ArgNode buildArgNode(MessagePattern messagePattern, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("buildArgNode", $$robo$$android_icu_text_MessagePatternUtil$buildArgNode(android.icu.text.MessagePattern int int ), 0, (MessagePattern)messagePattern, (int)n, (int)n2);
    }

    private static ComplexArgStyleNode buildChoiceStyleNode(MessagePattern messagePattern, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("buildChoiceStyleNode", $$robo$$android_icu_text_MessagePatternUtil$buildChoiceStyleNode(android.icu.text.MessagePattern int int ), 0, (MessagePattern)messagePattern, (int)n, (int)n2);
    }

    private static ComplexArgStyleNode buildPluralStyleNode(MessagePattern messagePattern, int n, int n2, MessagePattern.ArgType argType) {
        return InvokeDynamicSupport.bootstrapStatic("buildPluralStyleNode", $$robo$$android_icu_text_MessagePatternUtil$buildPluralStyleNode(android.icu.text.MessagePattern int int android.icu.text.MessagePattern$ArgType ), 0, (MessagePattern)messagePattern, (int)n, (int)n2, (MessagePattern.ArgType)argType);
    }

    private static ComplexArgStyleNode buildSelectStyleNode(MessagePattern messagePattern, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("buildSelectStyleNode", $$robo$$android_icu_text_MessagePatternUtil$buildSelectStyleNode(android.icu.text.MessagePattern int int ), 0, (MessagePattern)messagePattern, (int)n, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessagePatternUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class VariantNode
    extends Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String selector;
        private double numericValue;
        private MessageNode msgNode;

        private final String $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getSelector() {
            return this.selector;
        }

        private final boolean $$robo$$android_icu_text_MessagePatternUtil_VariantNode$isSelectorNumeric() {
            return this.numericValue != -1.23456789E8;
        }

        private final double $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getSelectorValue() {
            return this.numericValue;
        }

        private final MessageNode $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getMessage() {
            return this.msgNode;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_VariantNode$toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isSelectorNumeric()) {
                sb.append(this.numericValue).append(" (").append(this.selector).append(") {");
            } else {
                sb.append(this.selector).append(" {");
            }
            return sb.append(this.msgNode.toString()).append('}').toString();
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_VariantNode$__constructor__() {
            this.numericValue = -1.23456789E8;
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_VariantNode$__constructor__(1 x0) {
        }

        public String getSelector() {
            return InvokeDynamicSupport.bootstrap("getSelector", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getSelector(), 0, this);
        }

        public boolean isSelectorNumeric() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSelectorNumeric", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$isSelectorNumeric(), 0, this);
        }

        public double getSelectorValue() {
            return (double)InvokeDynamicSupport.bootstrap("getSelectorValue", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getSelectorValue(), 0, this);
        }

        public MessageNode getMessage() {
            return InvokeDynamicSupport.bootstrap("getMessage", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$getMessage(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$toString(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MessagePatternUtil_VariantNode$__constructor__();
        }

        private VariantNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_VariantNode$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_MessagePatternUtil_VariantNode$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VariantNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ComplexArgStyleNode
    extends Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MessagePattern.ArgType argType;
        private double offset;
        private boolean explicitOffset;
        private volatile List<VariantNode> list;

        private final MessagePattern.ArgType $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getArgType() {
            return this.argType;
        }

        private final boolean $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$hasExplicitOffset() {
            return this.explicitOffset;
        }

        private final double $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getOffset() {
            return this.offset;
        }

        private final List<VariantNode> $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getVariants() {
            return this.list;
        }

        private final VariantNode $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getVariantsByType(List<VariantNode> numericVariants, List<VariantNode> keywordVariants) {
            if (numericVariants != null) {
                numericVariants.clear();
            }
            keywordVariants.clear();
            VariantNode other = null;
            for (VariantNode variant : this.list) {
                if (variant.isSelectorNumeric()) {
                    numericVariants.add(variant);
                    continue;
                }
                if ("other".equals(variant.getSelector())) {
                    if (other != null) continue;
                    other = variant;
                    continue;
                }
                keywordVariants.add(variant);
            }
            return other;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(this.argType.toString()).append(" style) ");
            if (this.hasExplicitOffset()) {
                sb.append("offset:").append(this.offset).append(' ');
            }
            return sb.append(this.list.toString()).toString();
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$__constructor__(MessagePattern.ArgType argType) {
            this.list = new ArrayList<VariantNode>();
            this.argType = argType;
        }

        private final void $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$addVariant(VariantNode variant) {
            this.list.add(variant);
        }

        private final ComplexArgStyleNode $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$freeze() {
            this.list = Collections.unmodifiableList(this.list);
            return this;
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$__constructor__(MessagePattern.ArgType x0, 1 x1) {
        }

        public MessagePattern.ArgType getArgType() {
            return InvokeDynamicSupport.bootstrap("getArgType", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getArgType(), 0, this);
        }

        public boolean hasExplicitOffset() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasExplicitOffset", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$hasExplicitOffset(), 0, this);
        }

        public double getOffset() {
            return (double)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getOffset(), 0, this);
        }

        public List<VariantNode> getVariants() {
            return InvokeDynamicSupport.bootstrap("getVariants", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getVariants(), 0, this);
        }

        public VariantNode getVariantsByType(List<VariantNode> list, List<VariantNode> list2) {
            return InvokeDynamicSupport.bootstrap("getVariantsByType", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$getVariantsByType(java.util.List<android.icu.text.MessagePatternUtil$VariantNode> java.util.List<android.icu.text.MessagePatternUtil$VariantNode> ), 0, this, list, list2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$toString(), 0, this);
        }

        private void __constructor__(MessagePattern.ArgType argType) {
            this.$$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$__constructor__(argType);
        }

        private ComplexArgStyleNode(MessagePattern.ArgType argType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$__constructor__(android.icu.text.MessagePattern$ArgType ), 0, this, argType);
        }

        private void addVariant(VariantNode variantNode) {
            InvokeDynamicSupport.bootstrap("addVariant", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$addVariant(android.icu.text.MessagePatternUtil$VariantNode ), 0, this, variantNode);
        }

        private ComplexArgStyleNode freeze() {
            return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$freeze(), 0, this);
        }

        private /* synthetic */ void __constructor__(MessagePattern.ArgType argType, 1 var2_2) {
            this.$$robo$$android_icu_text_MessagePatternUtil_ComplexArgStyleNode$__constructor__(argType, var2_2);
        }

        public /* synthetic */ ComplexArgStyleNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ComplexArgStyleNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ArgNode
    extends MessageContentsNode
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MessagePattern.ArgType argType;
        private String name;
        private int number;
        private String typeName;
        private String style;
        private ComplexArgStyleNode complexStyle;

        private final MessagePattern.ArgType $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getArgType() {
            return this.argType;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getName() {
            return this.name;
        }

        private final int $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getNumber() {
            return this.number;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getTypeName() {
            return this.typeName;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getSimpleStyle() {
            return this.style;
        }

        private final ComplexArgStyleNode $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getComplexStyle() {
            return this.complexStyle;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_ArgNode$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{').append(this.name);
            if (this.argType != MessagePattern.ArgType.NONE) {
                sb.append(',').append(this.typeName);
                if (this.argType == MessagePattern.ArgType.SIMPLE) {
                    if (this.style != null) {
                        sb.append(',').append(this.style);
                    }
                } else {
                    sb.append(',').append(this.complexStyle.toString());
                }
            }
            return sb.append('}').toString();
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_ArgNode$__constructor__() {
            this.number = -1;
        }

        private static final ArgNode $$robo$$android_icu_text_MessagePatternUtil_ArgNode$createArgNode() {
            return new ArgNode();
        }

        public MessagePattern.ArgType getArgType() {
            return InvokeDynamicSupport.bootstrap("getArgType", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getArgType(), 0, this);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getName(), 0, this);
        }

        public int getNumber() {
            return (int)InvokeDynamicSupport.bootstrap("getNumber", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getNumber(), 0, this);
        }

        public String getTypeName() {
            return InvokeDynamicSupport.bootstrap("getTypeName", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getTypeName(), 0, this);
        }

        public String getSimpleStyle() {
            return InvokeDynamicSupport.bootstrap("getSimpleStyle", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getSimpleStyle(), 0, this);
        }

        public ComplexArgStyleNode getComplexStyle() {
            return InvokeDynamicSupport.bootstrap("getComplexStyle", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$getComplexStyle(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$toString(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MessagePatternUtil_ArgNode$__constructor__();
        }

        private ArgNode() {
            super(MessageContentsNode.Type.ARG);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$__constructor__(), 0, this);
        }

        private static ArgNode createArgNode() {
            return InvokeDynamicSupport.bootstrapStatic("createArgNode", $$robo$$android_icu_text_MessagePatternUtil_ArgNode$createArgNode(), 0);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArgNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TextNode
    extends MessageContentsNode
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String text;

        private final String $$robo$$android_icu_text_MessagePatternUtil_TextNode$getText() {
            return this.text;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_TextNode$toString() {
            return "\u00ab" + this.text + "\u00bb";
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_TextNode$__constructor__(String text) {
            this.text = text;
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_TextNode$__constructor__(String x0, 1 x1) {
        }

        public String getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_MessagePatternUtil_TextNode$getText(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_TextNode$toString(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_MessagePatternUtil_TextNode$__constructor__(string2);
        }

        private TextNode(String string2) {
            super(MessageContentsNode.Type.TEXT);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_TextNode$__constructor__(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$android_icu_text_MessagePatternUtil_TextNode$__constructor__(string2, var2_2);
        }

        public /* synthetic */ TextNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MessageContentsNode
    extends Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Type type;

        private final Type $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$getType() {
            return this.type;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$toString() {
            return "{REPLACE_NUMBER}";
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$__constructor__(Type type) {
            this.type = type;
        }

        private static final MessageContentsNode $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$createReplaceNumberNode() {
            return new MessageContentsNode(Type.REPLACE_NUMBER);
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$__constructor__(Type x0, 1 x1) {
        }

        public Type getType() {
            return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$getType(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$toString(), 0, this);
        }

        private void __constructor__(Type type) {
            this.$$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$__constructor__(type);
        }

        private MessageContentsNode(Type type) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$__constructor__(android.icu.text.MessagePatternUtil$MessageContentsNode$Type ), 0, this, type);
        }

        private static MessageContentsNode createReplaceNumberNode() {
            return InvokeDynamicSupport.bootstrapStatic("createReplaceNumberNode", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$createReplaceNumberNode(), 0);
        }

        private /* synthetic */ void __constructor__(Type type, 1 var2_2) {
            this.$$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode$__constructor__(type, var2_2);
        }

        public /* synthetic */ MessageContentsNode() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageContentsNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Type
        extends Enum<Type> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ Type TEXT;
            public static /* enum */ Type ARG;
            public static /* enum */ Type REPLACE_NUMBER;
            private static /* synthetic */ Type[] $VALUES;

            private static final Type[] $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$values() {
                return (Type[])$VALUES.clone();
            }

            private static final Type $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$valueOf(String name) {
                return Enum.valueOf(Type.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$__constructor__(String string2, int n) {
            }

            static void __staticInitializer__() {
                TEXT = new Type();
                ARG = new Type();
                REPLACE_NUMBER = new Type();
                $VALUES = new Type[]{TEXT, ARG, REPLACE_NUMBER};
            }

            public static Type[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$values(), 0);
            }

            public static Type valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n) {
                this.$$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$__constructor__(string2, n);
            }

            private Type() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_MessageContentsNode_Type$__constructor__(java.lang.String int ), 0, this, string2, n);
            }

            static {
                RobolectricInternals.classInitializing(Type.class);
            }

            public /* synthetic */ Type() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Type)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class MessageNode
    extends Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private volatile List<MessageContentsNode> list;

        private final List<MessageContentsNode> $$robo$$android_icu_text_MessagePatternUtil_MessageNode$getContents() {
            return this.list;
        }

        private final String $$robo$$android_icu_text_MessagePatternUtil_MessageNode$toString() {
            return this.list.toString();
        }

        private void $$robo$$android_icu_text_MessagePatternUtil_MessageNode$__constructor__() {
            this.list = new ArrayList<MessageContentsNode>();
        }

        private final void $$robo$$android_icu_text_MessagePatternUtil_MessageNode$addContentsNode(MessageContentsNode node) {
            MessageContentsNode lastNode;
            if (node instanceof TextNode && !this.list.isEmpty() && (lastNode = this.list.get(this.list.size() - 1)) instanceof TextNode) {
                TextNode textNode = (TextNode)lastNode;
                textNode.text = textNode.text + ((TextNode)node).text;
                return;
            }
            this.list.add(node);
        }

        private final MessageNode $$robo$$android_icu_text_MessagePatternUtil_MessageNode$freeze() {
            this.list = Collections.unmodifiableList(this.list);
            return this;
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_MessageNode$__constructor__(1 x0) {
        }

        public List<MessageContentsNode> getContents() {
            return InvokeDynamicSupport.bootstrap("getContents", $$robo$$android_icu_text_MessagePatternUtil_MessageNode$getContents(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessagePatternUtil_MessageNode$toString(), 0, this);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MessagePatternUtil_MessageNode$__constructor__();
        }

        private MessageNode() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_MessageNode$__constructor__(), 0, this);
        }

        private void addContentsNode(MessageContentsNode messageContentsNode) {
            InvokeDynamicSupport.bootstrap("addContentsNode", $$robo$$android_icu_text_MessagePatternUtil_MessageNode$addContentsNode(android.icu.text.MessagePatternUtil$MessageContentsNode ), 0, this, messageContentsNode);
        }

        private MessageNode freeze() {
            return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_MessagePatternUtil_MessageNode$freeze(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_MessagePatternUtil_MessageNode$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageNode)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_MessagePatternUtil_Node$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessagePatternUtil_Node$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_MessagePatternUtil_Node$__constructor__();
        }

        private Node() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessagePatternUtil_Node$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_MessagePatternUtil_Node$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

