/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUResourceBundle;
import android.icu.math.BigDecimal;
import android.icu.text.CurrencyPluralInfo;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.DisplayContext;
import android.icu.text.NumberingSystem;
import android.icu.text.RuleBasedNumberFormat;
import android.icu.text.UFormat;
import android.icu.util.Currency;
import android.icu.util.CurrencyAmount;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NumberFormat
extends UFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int NUMBERSTYLE = 0;
    public static int CURRENCYSTYLE = 1;
    public static int PERCENTSTYLE = 2;
    public static int SCIENTIFICSTYLE = 3;
    public static int INTEGERSTYLE = 4;
    public static int ISOCURRENCYSTYLE = 5;
    public static int PLURALCURRENCYSTYLE = 6;
    public static int ACCOUNTINGCURRENCYSTYLE = 7;
    public static int CASHCURRENCYSTYLE = 8;
    public static int STANDARDCURRENCYSTYLE = 9;
    public static int INTEGER_FIELD = 0;
    public static int FRACTION_FIELD = 1;
    private static NumberFormatShim shim;
    private static char[] doubleCurrencySign;
    private static String doubleCurrencyStr;
    private boolean groupingUsed;
    private byte maxIntegerDigits;
    private byte minIntegerDigits;
    private byte maxFractionDigits;
    private byte minFractionDigits;
    private boolean parseIntegerOnly;
    private int maximumIntegerDigits;
    private int minimumIntegerDigits;
    private int maximumFractionDigits;
    private int minimumFractionDigits;
    private Currency currency;
    static int currentSerialVersion = 2;
    private int serialVersionOnStream;
    private static long serialVersionUID = -2308460125733713944L;
    private boolean parseStrict;
    private DisplayContext capitalizationSetting;
    static /* synthetic */ boolean $assertionsDisabled;

    private final StringBuffer $$robo$$android_icu_text_NumberFormat$format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number instanceof Long) {
            return this.format((Long)number, toAppendTo, pos);
        }
        if (number instanceof BigInteger) {
            return this.format((BigInteger)number, toAppendTo, pos);
        }
        if (number instanceof java.math.BigDecimal) {
            return this.format((java.math.BigDecimal)number, toAppendTo, pos);
        }
        if (number instanceof BigDecimal) {
            return this.format((BigDecimal)number, toAppendTo, pos);
        }
        if (number instanceof CurrencyAmount) {
            return this.format((CurrencyAmount)number, toAppendTo, pos);
        }
        if (number instanceof Number) {
            return this.format(((Number)number).doubleValue(), toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    private final Object $$robo$$android_icu_text_NumberFormat$parseObject(String source, ParsePosition parsePosition) {
        return this.parse(source, parsePosition);
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(double number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(long number) {
        StringBuffer buf = new StringBuffer(19);
        FieldPosition pos = new FieldPosition(0);
        this.format(number, buf, pos);
        return buf.toString();
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(BigInteger number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(java.math.BigDecimal number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(BigDecimal number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private final String $$robo$$android_icu_text_NumberFormat$format(CurrencyAmount currAmt) {
        return this.format(currAmt, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(BigInteger var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(java.math.BigDecimal var1, StringBuffer var2, FieldPosition var3);

    public abstract StringBuffer format(BigDecimal var1, StringBuffer var2, FieldPosition var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final StringBuffer $$robo$$android_icu_text_NumberFormat$format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        NumberFormat numberFormat = this;
        synchronized (numberFormat) {
            Currency save = this.getCurrency();
            Currency curr = currAmt.getCurrency();
            boolean same = curr.equals(save);
            if (!same) {
                this.setCurrency(curr);
            }
            this.format(currAmt.getNumber(), toAppendTo, pos);
            if (!same) {
                this.setCurrency(save);
            }
        }
        return toAppendTo;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    private final Number $$robo$$android_icu_text_NumberFormat$parse(String text) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parse(text, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable number: \"" + text + '\"', parsePosition.getErrorIndex());
        }
        return result;
    }

    private final CurrencyAmount $$robo$$android_icu_text_NumberFormat$parseCurrency(CharSequence text, ParsePosition pos) {
        Number n = this.parse(text.toString(), pos);
        return n == null ? null : new CurrencyAmount(n, this.getEffectiveCurrency());
    }

    private final boolean $$robo$$android_icu_text_NumberFormat$isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setParseStrict(boolean value) {
        this.parseStrict = value;
    }

    private final boolean $$robo$$android_icu_text_NumberFormat$isParseStrict() {
        return this.parseStrict;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setContext(DisplayContext context) {
        if (context.type() == DisplayContext.Type.CAPITALIZATION) {
            this.capitalizationSetting = context;
        }
    }

    private final DisplayContext $$robo$$android_icu_text_NumberFormat$getContext(DisplayContext.Type type) {
        return type == DisplayContext.Type.CAPITALIZATION && this.capitalizationSetting != null ? this.capitalizationSetting : DisplayContext.CAPITALIZATION_NONE;
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance(int style2) {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), style2);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance(Locale inLocale, int style2) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), style2);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getNumberInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getNumberInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getNumberInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getIntegerInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 4);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getIntegerInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 4);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getIntegerInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 4);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getCurrencyInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 1);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getCurrencyInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 1);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getCurrencyInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 1);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getPercentInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 2);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getPercentInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 2);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getPercentInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 2);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getScientificInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 3);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getScientificInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 3);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getScientificInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 3);
    }

    private static final NumberFormatShim $$robo$$android_icu_text_NumberFormat$getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("android.icu.text.NumberFormatServiceShim");
                shim = (NumberFormatShim)cls.newInstance();
            }
            catch (MissingResourceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    private static final Locale[] $$robo$$android_icu_text_NumberFormat$getAvailableLocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableLocales();
        }
        return NumberFormat.getShim().getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_NumberFormat$getAvailableULocales() {
        if (shim == null) {
            return ICUResourceBundle.getAvailableULocales();
        }
        return NumberFormat.getShim().getAvailableULocales();
    }

    private static final Object $$robo$$android_icu_text_NumberFormat$registerFactory(NumberFormatFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        return NumberFormat.getShim().registerFactory(factory);
    }

    private static final boolean $$robo$$android_icu_text_NumberFormat$unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    private final int $$robo$$android_icu_text_NumberFormat$hashCode() {
        return this.maximumIntegerDigits * 37 + this.maxFractionDigits;
    }

    private final boolean $$robo$$android_icu_text_NumberFormat$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberFormat other = (NumberFormat)obj;
        return this.maximumIntegerDigits == other.maximumIntegerDigits && this.minimumIntegerDigits == other.minimumIntegerDigits && this.maximumFractionDigits == other.maximumFractionDigits && this.minimumFractionDigits == other.minimumFractionDigits && this.groupingUsed == other.groupingUsed && this.parseIntegerOnly == other.parseIntegerOnly && this.parseStrict == other.parseStrict && this.capitalizationSetting == other.capitalizationSetting;
    }

    private final Object $$robo$$android_icu_text_NumberFormat$clone() {
        NumberFormat other = (NumberFormat)super.clone();
        return other;
    }

    private final boolean $$robo$$android_icu_text_NumberFormat$isGroupingUsed() {
        return this.groupingUsed;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setGroupingUsed(boolean newValue) {
        this.groupingUsed = newValue;
    }

    private final int $$robo$$android_icu_text_NumberFormat$getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = Math.max(0, newValue);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
        }
    }

    private final int $$robo$$android_icu_text_NumberFormat$getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = Math.max(0, newValue);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
        }
    }

    private final int $$robo$$android_icu_text_NumberFormat$getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = Math.max(0, newValue);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
        }
    }

    private final int $$robo$$android_icu_text_NumberFormat$getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    private final void $$robo$$android_icu_text_NumberFormat$setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = Math.max(0, newValue);
        if (this.maximumFractionDigits < this.minimumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
        }
    }

    private final void $$robo$$android_icu_text_NumberFormat$setCurrency(Currency theCurrency) {
        this.currency = theCurrency;
    }

    private final Currency $$robo$$android_icu_text_NumberFormat$getCurrency() {
        return this.currency;
    }

    @Deprecated
    private final Currency $$robo$$android_icu_text_NumberFormat$getEffectiveCurrency() {
        Currency c = this.getCurrency();
        if (c == null) {
            ULocale uloc = this.getLocale(ULocale.VALID_LOCALE);
            if (uloc == null) {
                uloc = ULocale.getDefault(ULocale.Category.FORMAT);
            }
            c = Currency.getInstance(uloc);
        }
        return c;
    }

    private final int $$robo$$android_icu_text_NumberFormat$getRoundingMode() {
        throw new UnsupportedOperationException("getRoundingMode must be implemented by the subclass implementation.");
    }

    private final void $$robo$$android_icu_text_NumberFormat$setRoundingMode(int roundingMode) {
        throw new UnsupportedOperationException("setRoundingMode must be implemented by the subclass implementation.");
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$getInstance(ULocale desiredLocale, int choice) {
        if (choice < 0 || choice > 9) {
            throw new IllegalArgumentException("choice should be from NUMBERSTYLE to STANDARDCURRENCYSTYLE");
        }
        return NumberFormat.getShim().createInstance(desiredLocale, choice);
    }

    private static final NumberFormat $$robo$$android_icu_text_NumberFormat$createInstance(ULocale desiredLocale, int choice) {
        NumberFormat format;
        NumberingSystem ns;
        String temp;
        String pattern = NumberFormat.getPattern(desiredLocale, choice);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(desiredLocale);
        if ((choice == 1 || choice == 5 || choice == 7 || choice == 8 || choice == 9) && (temp = symbols.getCurrencyPattern()) != null) {
            pattern = temp;
        }
        if (choice == 5) {
            pattern = pattern.replace("\u00a4", doubleCurrencyStr);
        }
        if ((ns = NumberingSystem.getInstance(desiredLocale)) == null) {
            return null;
        }
        if (ns != null && ns.isAlgorithmic()) {
            ULocale nsLoc;
            String nsRuleSetName;
            int desiredRulesType = 4;
            String nsDesc = ns.getDescription();
            int firstSlash = nsDesc.indexOf("/");
            int lastSlash = nsDesc.lastIndexOf("/");
            if (lastSlash > firstSlash) {
                String nsLocID = nsDesc.substring(0, firstSlash);
                String nsRuleSetGroup = nsDesc.substring(firstSlash + 1, lastSlash);
                nsRuleSetName = nsDesc.substring(lastSlash + 1);
                nsLoc = new ULocale(nsLocID);
                if (nsRuleSetGroup.equals("SpelloutRules")) {
                    desiredRulesType = 1;
                }
            } else {
                nsLoc = desiredLocale;
                nsRuleSetName = nsDesc;
            }
            RuleBasedNumberFormat r = new RuleBasedNumberFormat(nsLoc, desiredRulesType);
            r.setDefaultRuleSet(nsRuleSetName);
            format = r;
        } else {
            DecimalFormat f = new DecimalFormat(pattern, symbols, choice);
            if (choice == 4) {
                f.setMaximumFractionDigits(0);
                f.setDecimalSeparatorAlwaysShown(false);
                f.setParseIntegerOnly(true);
            }
            if (choice == 8) {
                f.setCurrencyUsage(Currency.CurrencyUsage.CASH);
            }
            if (choice == 6) {
                f.setCurrencyPluralInfo(CurrencyPluralInfo.getInstance(desiredLocale));
            }
            format = f;
        }
        ULocale valid = symbols.getLocale(ULocale.VALID_LOCALE);
        ULocale actual = symbols.getLocale(ULocale.ACTUAL_LOCALE);
        format.setLocale(valid, actual);
        return format;
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_NumberFormat$getPattern(Locale forLocale, int choice) {
        return NumberFormat.getPattern(ULocale.forLocale(forLocale), choice);
    }

    private static final String $$robo$$android_icu_text_NumberFormat$getPattern(ULocale forLocale, int choice) {
        return NumberFormat.getPatternForStyle(forLocale, choice);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_NumberFormat$getPatternForStyle(ULocale forLocale, int choice) {
        NumberingSystem ns = NumberingSystem.getInstance(forLocale);
        String nsName = ns.getName();
        return NumberFormat.getPatternForStyleAndNumberingSystem(forLocale, nsName, choice);
    }

    @Deprecated
    private static final String $$robo$$android_icu_text_NumberFormat$getPatternForStyleAndNumberingSystem(ULocale forLocale, String nsName, int choice) {
        String patternKey = null;
        switch (choice) {
            case 0: 
            case 4: 
            case 6: {
                patternKey = "decimalFormat";
                break;
            }
            case 1: {
                String cfKeyValue = forLocale.getKeywordValue("cf");
                patternKey = cfKeyValue != null && cfKeyValue.equals("account") ? "accountingFormat" : "currencyFormat";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                patternKey = "currencyFormat";
                break;
            }
            case 2: {
                patternKey = "percentFormat";
                break;
            }
            case 3: {
                patternKey = "scientificFormat";
                break;
            }
            case 7: {
                patternKey = "accountingFormat";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                patternKey = "decimalFormat";
            }
        }
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", forLocale);
        String result = rb.findStringWithFallback("NumberElements/" + nsName + "/patterns/" + patternKey);
        if (result == null) {
            result = rb.getStringWithFallback("NumberElements/latn/patterns/" + patternKey);
        }
        return result;
    }

    private final void $$robo$$android_icu_text_NumberFormat$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
            this.maximumFractionDigits = this.maxFractionDigits;
            this.minimumFractionDigits = this.minFractionDigits;
        }
        if (this.serialVersionOnStream < 2) {
            this.capitalizationSetting = DisplayContext.CAPITALIZATION_NONE;
        }
        if (this.minimumIntegerDigits > this.maximumIntegerDigits || this.minimumFractionDigits > this.maximumFractionDigits || this.minimumIntegerDigits < 0 || this.minimumFractionDigits < 0) {
            throw new InvalidObjectException("Digit count range invalid");
        }
        this.serialVersionOnStream = 2;
    }

    private final void $$robo$$android_icu_text_NumberFormat$writeObject(ObjectOutputStream stream) throws IOException {
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits > 127 ? 127 : (byte)this.maximumIntegerDigits);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits > 127 ? 127 : (byte)this.minimumIntegerDigits);
        this.maxFractionDigits = (byte)(this.maximumFractionDigits > 127 ? 127 : (byte)this.maximumFractionDigits);
        this.minFractionDigits = (byte)(this.minimumFractionDigits > 127 ? 127 : (byte)this.minimumFractionDigits);
        stream.defaultWriteObject();
    }

    private void $$robo$$android_icu_text_NumberFormat$__constructor__() {
        this.groupingUsed = true;
        this.maxIntegerDigits = (byte)40;
        this.minIntegerDigits = 1;
        this.maxFractionDigits = (byte)3;
        this.minFractionDigits = 0;
        this.parseIntegerOnly = false;
        this.maximumIntegerDigits = 40;
        this.minimumIntegerDigits = 1;
        this.maximumFractionDigits = 3;
        this.minimumFractionDigits = 0;
        this.serialVersionOnStream = 2;
        this.capitalizationSetting = DisplayContext.CAPITALIZATION_NONE;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !NumberFormat.class.desiredAssertionStatus();
        doubleCurrencySign = new char[]{'\u00a4', '\u00a4'};
        doubleCurrencyStr = new String(doubleCurrencySign);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_NumberFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public String format(double d) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(double ), 0, this, d);
    }

    public String format(long l) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(long ), 0, this, l);
    }

    public String format(BigInteger bigInteger) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(java.math.BigInteger ), 0, this, bigInteger);
    }

    public String format(java.math.BigDecimal bigDecimal) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(java.math.BigDecimal ), 0, this, bigDecimal);
    }

    public String format(BigDecimal bigDecimal) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(android.icu.math.BigDecimal ), 0, this, bigDecimal);
    }

    public String format(CurrencyAmount currencyAmount) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(android.icu.util.CurrencyAmount ), 0, this, currencyAmount);
    }

    public StringBuffer format(CurrencyAmount currencyAmount, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_NumberFormat$format(android.icu.util.CurrencyAmount java.lang.StringBuffer java.text.FieldPosition ), 0, this, currencyAmount, stringBuffer, fieldPosition);
    }

    public Number parse(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_NumberFormat$parse(java.lang.String ), 0, this, string2);
    }

    public CurrencyAmount parseCurrency(CharSequence charSequence, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseCurrency", $$robo$$android_icu_text_NumberFormat$parseCurrency(java.lang.CharSequence java.text.ParsePosition ), 0, this, charSequence, parsePosition);
    }

    public boolean isParseIntegerOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseIntegerOnly", $$robo$$android_icu_text_NumberFormat$isParseIntegerOnly(), 0, this);
    }

    public void setParseIntegerOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseIntegerOnly", $$robo$$android_icu_text_NumberFormat$setParseIntegerOnly(boolean ), 0, this, bl);
    }

    public void setParseStrict(boolean bl) {
        InvokeDynamicSupport.bootstrap("setParseStrict", $$robo$$android_icu_text_NumberFormat$setParseStrict(boolean ), 0, this, bl);
    }

    public boolean isParseStrict() {
        return (boolean)InvokeDynamicSupport.bootstrap("isParseStrict", $$robo$$android_icu_text_NumberFormat$isParseStrict(), 0, this);
    }

    public void setContext(DisplayContext displayContext) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_icu_text_NumberFormat$setContext(android.icu.text.DisplayContext ), 0, this, displayContext);
    }

    public DisplayContext getContext(DisplayContext.Type type) {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_icu_text_NumberFormat$getContext(android.icu.text.DisplayContext$Type ), 0, this, type);
    }

    public static NumberFormat getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(), 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberFormat getInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(int ), 0, (int)n);
    }

    public static NumberFormat getInstance(Locale locale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(java.util.Locale int ), 0, (Locale)locale, (int)n);
    }

    public static NumberFormat getNumberInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getNumberInstance", $$robo$$android_icu_text_NumberFormat$getNumberInstance(), 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getNumberInstance", $$robo$$android_icu_text_NumberFormat$getNumberInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getNumberInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getNumberInstance", $$robo$$android_icu_text_NumberFormat$getNumberInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberFormat getIntegerInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getIntegerInstance", $$robo$$android_icu_text_NumberFormat$getIntegerInstance(), 0);
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getIntegerInstance", $$robo$$android_icu_text_NumberFormat$getIntegerInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getIntegerInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getIntegerInstance", $$robo$$android_icu_text_NumberFormat$getIntegerInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberFormat getCurrencyInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyInstance", $$robo$$android_icu_text_NumberFormat$getCurrencyInstance(), 0);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyInstance", $$robo$$android_icu_text_NumberFormat$getCurrencyInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getCurrencyInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrencyInstance", $$robo$$android_icu_text_NumberFormat$getCurrencyInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberFormat getPercentInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getPercentInstance", $$robo$$android_icu_text_NumberFormat$getPercentInstance(), 0);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getPercentInstance", $$robo$$android_icu_text_NumberFormat$getPercentInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getPercentInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getPercentInstance", $$robo$$android_icu_text_NumberFormat$getPercentInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static NumberFormat getScientificInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getScientificInstance", $$robo$$android_icu_text_NumberFormat$getScientificInstance(), 0);
    }

    public static NumberFormat getScientificInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getScientificInstance", $$robo$$android_icu_text_NumberFormat$getScientificInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static NumberFormat getScientificInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getScientificInstance", $$robo$$android_icu_text_NumberFormat$getScientificInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private static NumberFormatShim getShim() {
        return InvokeDynamicSupport.bootstrapStatic("getShim", $$robo$$android_icu_text_NumberFormat$getShim(), 0);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_NumberFormat$getAvailableLocales(), 0);
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_NumberFormat$getAvailableULocales(), 0);
    }

    public static Object registerFactory(NumberFormatFactory numberFormatFactory) {
        return InvokeDynamicSupport.bootstrapStatic("registerFactory", $$robo$$android_icu_text_NumberFormat$registerFactory(android.icu.text.NumberFormat$NumberFormatFactory ), 0, (NumberFormatFactory)numberFormatFactory);
    }

    public static boolean unregister(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unregister", $$robo$$android_icu_text_NumberFormat$unregister(java.lang.Object ), 0, (Object)object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_NumberFormat$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_NumberFormat$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_NumberFormat$clone(), 0, this);
    }

    public boolean isGroupingUsed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGroupingUsed", $$robo$$android_icu_text_NumberFormat$isGroupingUsed(), 0, this);
    }

    public void setGroupingUsed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupingUsed", $$robo$$android_icu_text_NumberFormat$setGroupingUsed(boolean ), 0, this, bl);
    }

    public int getMaximumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumIntegerDigits", $$robo$$android_icu_text_NumberFormat$getMaximumIntegerDigits(), 0, this);
    }

    public void setMaximumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumIntegerDigits", $$robo$$android_icu_text_NumberFormat$setMaximumIntegerDigits(int ), 0, this, n);
    }

    public int getMinimumIntegerDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumIntegerDigits", $$robo$$android_icu_text_NumberFormat$getMinimumIntegerDigits(), 0, this);
    }

    public void setMinimumIntegerDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumIntegerDigits", $$robo$$android_icu_text_NumberFormat$setMinimumIntegerDigits(int ), 0, this, n);
    }

    public int getMaximumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumFractionDigits", $$robo$$android_icu_text_NumberFormat$getMaximumFractionDigits(), 0, this);
    }

    public void setMaximumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMaximumFractionDigits", $$robo$$android_icu_text_NumberFormat$setMaximumFractionDigits(int ), 0, this, n);
    }

    public int getMinimumFractionDigits() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumFractionDigits", $$robo$$android_icu_text_NumberFormat$getMinimumFractionDigits(), 0, this);
    }

    public void setMinimumFractionDigits(int n) {
        InvokeDynamicSupport.bootstrap("setMinimumFractionDigits", $$robo$$android_icu_text_NumberFormat$setMinimumFractionDigits(int ), 0, this, n);
    }

    public void setCurrency(Currency currency) {
        InvokeDynamicSupport.bootstrap("setCurrency", $$robo$$android_icu_text_NumberFormat$setCurrency(android.icu.util.Currency ), 0, this, currency);
    }

    public Currency getCurrency() {
        return InvokeDynamicSupport.bootstrap("getCurrency", $$robo$$android_icu_text_NumberFormat$getCurrency(), 0, this);
    }

    @Deprecated
    protected Currency getEffectiveCurrency() {
        return InvokeDynamicSupport.bootstrap("getEffectiveCurrency", $$robo$$android_icu_text_NumberFormat$getEffectiveCurrency(), 0, this);
    }

    public int getRoundingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRoundingMode", $$robo$$android_icu_text_NumberFormat$getRoundingMode(), 0, this);
    }

    public void setRoundingMode(int n) {
        InvokeDynamicSupport.bootstrap("setRoundingMode", $$robo$$android_icu_text_NumberFormat$setRoundingMode(int ), 0, this, n);
    }

    public static NumberFormat getInstance(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_NumberFormat$getInstance(android.icu.util.ULocale int ), 0, (ULocale)uLocale, (int)n);
    }

    static NumberFormat createInstance(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createInstance", $$robo$$android_icu_text_NumberFormat$createInstance(android.icu.util.ULocale int ), 0, (ULocale)uLocale, (int)n);
    }

    @Deprecated
    protected static String getPattern(Locale locale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPattern", $$robo$$android_icu_text_NumberFormat$getPattern(java.util.Locale int ), 0, (Locale)locale, (int)n);
    }

    protected static String getPattern(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPattern", $$robo$$android_icu_text_NumberFormat$getPattern(android.icu.util.ULocale int ), 0, (ULocale)uLocale, (int)n);
    }

    @Deprecated
    public static String getPatternForStyle(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternForStyle", $$robo$$android_icu_text_NumberFormat$getPatternForStyle(android.icu.util.ULocale int ), 0, (ULocale)uLocale, (int)n);
    }

    @Deprecated
    public static String getPatternForStyleAndNumberingSystem(ULocale uLocale, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPatternForStyleAndNumberingSystem", $$robo$$android_icu_text_NumberFormat$getPatternForStyleAndNumberingSystem(android.icu.util.ULocale java.lang.String int ), 0, (ULocale)uLocale, (String)string2, (int)n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_NumberFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_NumberFormat$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_NumberFormat$__constructor__();
    }

    public NumberFormat() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(NumberFormat.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Field
    extends Format.Field
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static long serialVersionUID = -4516273749929385842L;
        public static Field SIGN;
        public static Field INTEGER;
        public static Field FRACTION;
        public static Field EXPONENT;
        public static Field EXPONENT_SIGN;
        public static Field EXPONENT_SYMBOL;
        public static Field DECIMAL_SEPARATOR;
        public static Field GROUPING_SEPARATOR;
        public static Field PERCENT;
        public static Field PERMILLE;
        public static Field CURRENCY;

        private void $$robo$$android_icu_text_NumberFormat_Field$__constructor__(String fieldName) {
        }

        private final Object $$robo$$android_icu_text_NumberFormat_Field$readResolve() throws InvalidObjectException {
            if (this.getName().equals(INTEGER.getName())) {
                return INTEGER;
            }
            if (this.getName().equals(FRACTION.getName())) {
                return FRACTION;
            }
            if (this.getName().equals(EXPONENT.getName())) {
                return EXPONENT;
            }
            if (this.getName().equals(EXPONENT_SIGN.getName())) {
                return EXPONENT_SIGN;
            }
            if (this.getName().equals(EXPONENT_SYMBOL.getName())) {
                return EXPONENT_SYMBOL;
            }
            if (this.getName().equals(CURRENCY.getName())) {
                return CURRENCY;
            }
            if (this.getName().equals(DECIMAL_SEPARATOR.getName())) {
                return DECIMAL_SEPARATOR;
            }
            if (this.getName().equals(GROUPING_SEPARATOR.getName())) {
                return GROUPING_SEPARATOR;
            }
            if (this.getName().equals(PERCENT.getName())) {
                return PERCENT;
            }
            if (this.getName().equals(PERMILLE.getName())) {
                return PERMILLE;
            }
            if (this.getName().equals(SIGN.getName())) {
                return SIGN;
            }
            throw new InvalidObjectException("An invalid object.");
        }

        static void __staticInitializer__() {
            SIGN = new Field("sign");
            INTEGER = new Field("integer");
            FRACTION = new Field("fraction");
            EXPONENT = new Field("exponent");
            EXPONENT_SIGN = new Field("exponent sign");
            EXPONENT_SYMBOL = new Field("exponent symbol");
            DECIMAL_SEPARATOR = new Field("decimal separator");
            GROUPING_SEPARATOR = new Field("grouping separator");
            PERCENT = new Field("percent");
            PERMILLE = new Field("per mille");
            CURRENCY = new Field("currency");
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_NumberFormat_Field$__constructor__(string2);
        }

        protected Field(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_Field$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            return InvokeDynamicSupport.bootstrap("readResolve", $$robo$$android_icu_text_NumberFormat_Field$readResolve(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Field.class);
        }

        public /* synthetic */ Field() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Field)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class NumberFormatShim
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_NumberFormat_NumberFormatShim$__constructor__() {
        }

        abstract Locale[] getAvailableLocales();

        abstract ULocale[] getAvailableULocales();

        abstract Object registerFactory(NumberFormatFactory var1);

        abstract boolean unregister(Object var1);

        abstract NumberFormat createInstance(ULocale var1, int var2);

        private void __constructor__() {
            this.$$robo$$android_icu_text_NumberFormat_NumberFormatShim$__constructor__();
        }

        NumberFormatShim() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_NumberFormatShim$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberFormatShim)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SimpleNumberFormatFactory
    extends NumberFormatFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Set<String> localeNames;
        boolean visible;

        private void $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(Locale locale) {
        }

        private void $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(Locale locale, boolean visible) {
            this.localeNames = Collections.singleton(ULocale.forLocale(locale).getBaseName());
            this.visible = visible;
        }

        private void $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(ULocale locale) {
        }

        private void $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(ULocale locale, boolean visible) {
            this.localeNames = Collections.singleton(locale.getBaseName());
            this.visible = visible;
        }

        private final boolean $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$visible() {
            return this.visible;
        }

        private final Set<String> $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$getSupportedLocaleNames() {
            return this.localeNames;
        }

        private void __constructor__(Locale locale) {
            this.$$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(locale);
        }

        public SimpleNumberFormatFactory(Locale locale) {
            this(locale, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(java.util.Locale ), 0, this, locale);
        }

        private void __constructor__(Locale locale, boolean bl) {
            this.$$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(locale, bl);
        }

        public SimpleNumberFormatFactory(Locale locale, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(java.util.Locale boolean ), 0, this, locale, bl);
        }

        private void __constructor__(ULocale uLocale) {
            this.$$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(uLocale);
        }

        public SimpleNumberFormatFactory(ULocale uLocale) {
            this(uLocale, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
        }

        private void __constructor__(ULocale uLocale, boolean bl) {
            this.$$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(uLocale, bl);
        }

        public SimpleNumberFormatFactory(ULocale uLocale, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$__constructor__(android.icu.util.ULocale boolean ), 0, this, uLocale, bl);
        }

        @Override
        public boolean visible() {
            return (boolean)InvokeDynamicSupport.bootstrap("visible", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$visible(), 0, this);
        }

        @Override
        public Set<String> getSupportedLocaleNames() {
            return InvokeDynamicSupport.bootstrap("getSupportedLocaleNames", $$robo$$android_icu_text_NumberFormat_SimpleNumberFormatFactory$getSupportedLocaleNames(), 0, this);
        }

        public /* synthetic */ SimpleNumberFormatFactory() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleNumberFormatFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class NumberFormatFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int FORMAT_NUMBER = 0;
        public static int FORMAT_CURRENCY = 1;
        public static int FORMAT_PERCENT = 2;
        public static int FORMAT_SCIENTIFIC = 3;
        public static int FORMAT_INTEGER = 4;

        private final boolean $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$visible() {
            return true;
        }

        public abstract Set<String> getSupportedLocaleNames();

        private final NumberFormat $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$createFormat(ULocale loc, int formatType) {
            return this.createFormat(loc.toLocale(), formatType);
        }

        private final NumberFormat $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$createFormat(Locale loc, int formatType) {
            return this.createFormat(ULocale.forLocale(loc), formatType);
        }

        private void $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$__constructor__() {
        }

        public boolean visible() {
            return (boolean)InvokeDynamicSupport.bootstrap("visible", $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$visible(), 0, this);
        }

        public NumberFormat createFormat(ULocale uLocale, int n) {
            return InvokeDynamicSupport.bootstrap("createFormat", $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$createFormat(android.icu.util.ULocale int ), 0, this, uLocale, n);
        }

        public NumberFormat createFormat(Locale locale, int n) {
            return InvokeDynamicSupport.bootstrap("createFormat", $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$createFormat(java.util.Locale int ), 0, this, locale, n);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_NumberFormat_NumberFormatFactory$__constructor__();
        }

        protected NumberFormatFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_NumberFormat_NumberFormatFactory$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumberFormatFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

