/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.Assert;
import android.icu.impl.Trie2Writable;
import android.icu.impl.Trie2_16;
import android.icu.text.RBBINode;
import android.icu.text.RBBIRuleBuilder;
import android.icu.text.UnicodeSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RBBISetBuilder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    RBBIRuleBuilder fRB;
    RangeDescriptor fRangeList;
    Trie2Writable fTrie;
    Trie2_16 fFrozenTrie;
    int fGroupCount;
    boolean fSawBOF;

    private void $$robo$$android_icu_text_RBBISetBuilder$__constructor__(RBBIRuleBuilder rb) {
        this.fRB = rb;
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$build() {
        RangeDescriptor rlRange;
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("usets") >= 0) {
            this.printSets();
        }
        this.fRangeList = new RangeDescriptor();
        this.fRangeList.fStartChar = 0;
        this.fRangeList.fEndChar = 0x10FFFF;
        for (RBBINode usetNode : this.fRB.fUSetNodes) {
            UnicodeSet inputSet = usetNode.fInputSet;
            int inputSetRangeCount = inputSet.getRangeCount();
            int inputSetRangeIndex = 0;
            rlRange = this.fRangeList;
            while (inputSetRangeIndex < inputSetRangeCount) {
                int inputSetRangeBegin = inputSet.getRangeStart(inputSetRangeIndex);
                int inputSetRangeEnd = inputSet.getRangeEnd(inputSetRangeIndex);
                while (rlRange.fEndChar < inputSetRangeBegin) {
                    rlRange = rlRange.fNext;
                }
                if (rlRange.fStartChar < inputSetRangeBegin) {
                    rlRange.split(inputSetRangeBegin);
                    continue;
                }
                if (rlRange.fEndChar > inputSetRangeEnd) {
                    rlRange.split(inputSetRangeEnd + 1);
                }
                if (rlRange.fIncludesSets.indexOf(usetNode) == -1) {
                    rlRange.fIncludesSets.add(usetNode);
                }
                if (inputSetRangeEnd == rlRange.fEndChar) {
                    ++inputSetRangeIndex;
                }
                rlRange = rlRange.fNext;
            }
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("range") >= 0) {
            this.printRanges();
        }
        rlRange = this.fRangeList;
        while (rlRange != null) {
            RangeDescriptor rlSearchRange = this.fRangeList;
            while (rlSearchRange != rlRange) {
                if (rlRange.fIncludesSets.equals(rlSearchRange.fIncludesSets)) {
                    rlRange.fNum = rlSearchRange.fNum;
                    break;
                }
                rlSearchRange = rlSearchRange.fNext;
            }
            if (rlRange.fNum == 0) {
                ++this.fGroupCount;
                rlRange.fNum = this.fGroupCount + 2;
                rlRange.setDictionaryFlag();
                this.addValToSets(rlRange.fIncludesSets, this.fGroupCount + 2);
            }
            rlRange = rlRange.fNext;
        }
        String eofString = "eof";
        String bofString = "bof";
        for (RBBINode usetNode : this.fRB.fUSetNodes) {
            UnicodeSet inputSet = usetNode.fInputSet;
            if (inputSet.contains(eofString)) {
                this.addValToSet(usetNode, 1);
            }
            if (!inputSet.contains(bofString)) continue;
            this.addValToSet(usetNode, 2);
            this.fSawBOF = true;
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("rgroup") >= 0) {
            this.printRangeGroups();
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("esets") >= 0) {
            this.printSets();
        }
        this.fTrie = new Trie2Writable(0, 0);
        rlRange = this.fRangeList;
        while (rlRange != null) {
            this.fTrie.setRange(rlRange.fStartChar, rlRange.fEndChar, rlRange.fNum, true);
            rlRange = rlRange.fNext;
        }
    }

    private final int $$robo$$android_icu_text_RBBISetBuilder$getTrieSize() {
        if (this.fFrozenTrie == null) {
            this.fFrozenTrie = this.fTrie.toTrie2_16();
            this.fTrie = null;
        }
        return this.fFrozenTrie.getSerializedLength();
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$serializeTrie(OutputStream os) throws IOException {
        if (this.fFrozenTrie == null) {
            this.fFrozenTrie = this.fTrie.toTrie2_16();
            this.fTrie = null;
        }
        this.fFrozenTrie.serialize(os);
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$addValToSets(List<RBBINode> sets, int val) {
        for (RBBINode usetNode : sets) {
            this.addValToSet(usetNode, val);
        }
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$addValToSet(RBBINode usetNode, int val) {
        RBBINode leafNode = new RBBINode(3);
        leafNode.fVal = val;
        if (usetNode.fLeftChild == null) {
            usetNode.fLeftChild = leafNode;
            leafNode.fParent = usetNode;
        } else {
            RBBINode orNode = new RBBINode(9);
            orNode.fLeftChild = usetNode.fLeftChild;
            orNode.fRightChild = leafNode;
            orNode.fLeftChild.fParent = orNode;
            orNode.fRightChild.fParent = orNode;
            usetNode.fLeftChild = orNode;
            orNode.fParent = usetNode;
        }
    }

    private final int $$robo$$android_icu_text_RBBISetBuilder$getNumCharCategories() {
        return this.fGroupCount + 3;
    }

    private final boolean $$robo$$android_icu_text_RBBISetBuilder$sawBOF() {
        return this.fSawBOF;
    }

    private final int $$robo$$android_icu_text_RBBISetBuilder$getFirstChar(int category) {
        int retVal = -1;
        RangeDescriptor rlRange = this.fRangeList;
        while (rlRange != null) {
            if (rlRange.fNum == category) {
                retVal = rlRange.fStartChar;
                break;
            }
            rlRange = rlRange.fNext;
        }
        return retVal;
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$printRanges() {
        System.out.print("\n\n Nonoverlapping Ranges ...\n");
        RangeDescriptor rlRange = this.fRangeList;
        while (rlRange != null) {
            System.out.print(" " + rlRange.fNum + "   " + rlRange.fStartChar + "-" + rlRange.fEndChar);
            for (int i = 0; i < rlRange.fIncludesSets.size(); ++i) {
                RBBINode varRef;
                RBBINode usetNode = rlRange.fIncludesSets.get(i);
                String setName = "anon";
                RBBINode setRef = usetNode.fParent;
                if (setRef != null && (varRef = setRef.fParent) != null && varRef.fType == 2) {
                    setName = varRef.fText;
                }
                System.out.print(setName);
                System.out.print("  ");
            }
            System.out.println("");
            rlRange = rlRange.fNext;
        }
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$printRangeGroups() {
        int lastPrintedGroupNum = 0;
        System.out.print("\nRanges grouped by Unicode Set Membership...\n");
        RangeDescriptor rlRange = this.fRangeList;
        while (rlRange != null) {
            int groupNum = rlRange.fNum & 0xBFFF;
            if (groupNum > lastPrintedGroupNum) {
                int i;
                lastPrintedGroupNum = groupNum;
                if (groupNum < 10) {
                    System.out.print(" ");
                }
                System.out.print(groupNum + " ");
                if ((rlRange.fNum & 0x4000) != 0) {
                    System.out.print(" <DICT> ");
                }
                for (i = 0; i < rlRange.fIncludesSets.size(); ++i) {
                    RBBINode varRef;
                    RBBINode usetNode = rlRange.fIncludesSets.get(i);
                    String setName = "anon";
                    RBBINode setRef = usetNode.fParent;
                    if (setRef != null && (varRef = setRef.fParent) != null && varRef.fType == 2) {
                        setName = varRef.fText;
                    }
                    System.out.print(setName);
                    System.out.print(" ");
                }
                i = 0;
                RangeDescriptor tRange = rlRange;
                while (tRange != null) {
                    if (tRange.fNum == rlRange.fNum) {
                        if (i++ % 5 == 0) {
                            System.out.print("\n    ");
                        }
                        RBBINode.printHex(tRange.fStartChar, -1);
                        System.out.print("-");
                        RBBINode.printHex(tRange.fEndChar, 0);
                    }
                    tRange = tRange.fNext;
                }
                System.out.print("\n");
            }
            rlRange = rlRange.fNext;
        }
        System.out.print("\n");
    }

    private final void $$robo$$android_icu_text_RBBISetBuilder$printSets() {
        System.out.print("\n\nUnicode Sets List\n------------------\n");
        for (int i = 0; i < this.fRB.fUSetNodes.size(); ++i) {
            RBBINode varRef;
            RBBINode usetNode = this.fRB.fUSetNodes.get(i);
            RBBINode.printInt(2, i);
            String setName = "anonymous";
            RBBINode setRef = usetNode.fParent;
            if (setRef != null && (varRef = setRef.fParent) != null && varRef.fType == 2) {
                setName = varRef.fText;
            }
            System.out.print("  " + setName);
            System.out.print("   ");
            System.out.print(usetNode.fText);
            System.out.print("\n");
            if (usetNode.fLeftChild == null) continue;
            usetNode.fLeftChild.printTree(true);
        }
        System.out.print("\n");
    }

    private void __constructor__(RBBIRuleBuilder rBBIRuleBuilder) {
        this.$$robo$$android_icu_text_RBBISetBuilder$__constructor__(rBBIRuleBuilder);
    }

    RBBISetBuilder(RBBIRuleBuilder rBBIRuleBuilder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBISetBuilder$__constructor__(android.icu.text.RBBIRuleBuilder ), 0, this, rBBIRuleBuilder);
    }

    void build() {
        InvokeDynamicSupport.bootstrap("build", $$robo$$android_icu_text_RBBISetBuilder$build(), 0, this);
    }

    int getTrieSize() {
        return (int)InvokeDynamicSupport.bootstrap("getTrieSize", $$robo$$android_icu_text_RBBISetBuilder$getTrieSize(), 0, this);
    }

    void serializeTrie(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("serializeTrie", $$robo$$android_icu_text_RBBISetBuilder$serializeTrie(java.io.OutputStream ), 0, this, outputStream);
    }

    void addValToSets(List<RBBINode> list, int n) {
        InvokeDynamicSupport.bootstrap("addValToSets", $$robo$$android_icu_text_RBBISetBuilder$addValToSets(java.util.List<android.icu.text.RBBINode> int ), 0, this, list, n);
    }

    void addValToSet(RBBINode rBBINode, int n) {
        InvokeDynamicSupport.bootstrap("addValToSet", $$robo$$android_icu_text_RBBISetBuilder$addValToSet(android.icu.text.RBBINode int ), 0, this, rBBINode, n);
    }

    int getNumCharCategories() {
        return (int)InvokeDynamicSupport.bootstrap("getNumCharCategories", $$robo$$android_icu_text_RBBISetBuilder$getNumCharCategories(), 0, this);
    }

    boolean sawBOF() {
        return (boolean)InvokeDynamicSupport.bootstrap("sawBOF", $$robo$$android_icu_text_RBBISetBuilder$sawBOF(), 0, this);
    }

    int getFirstChar(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getFirstChar", $$robo$$android_icu_text_RBBISetBuilder$getFirstChar(int ), 0, this, n);
    }

    void printRanges() {
        InvokeDynamicSupport.bootstrap("printRanges", $$robo$$android_icu_text_RBBISetBuilder$printRanges(), 0, this);
    }

    void printRangeGroups() {
        InvokeDynamicSupport.bootstrap("printRangeGroups", $$robo$$android_icu_text_RBBISetBuilder$printRangeGroups(), 0, this);
    }

    void printSets() {
        InvokeDynamicSupport.bootstrap("printSets", $$robo$$android_icu_text_RBBISetBuilder$printSets(), 0, this);
    }

    public /* synthetic */ RBBISetBuilder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RBBISetBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RangeDescriptor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int fStartChar;
        int fEndChar;
        int fNum;
        List<RBBINode> fIncludesSets;
        RangeDescriptor fNext;

        private void $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__() {
            this.fIncludesSets = new ArrayList<RBBINode>();
        }

        private void $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__(RangeDescriptor other) {
            this.fStartChar = other.fStartChar;
            this.fEndChar = other.fEndChar;
            this.fNum = other.fNum;
            this.fIncludesSets = new ArrayList<RBBINode>(other.fIncludesSets);
        }

        private final void $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$split(int where) {
            Assert.assrt(where > this.fStartChar && where <= this.fEndChar);
            RangeDescriptor nr = new RangeDescriptor(this);
            nr.fStartChar = where;
            this.fEndChar = where - 1;
            nr.fNext = this.fNext;
            this.fNext = nr;
        }

        private final void $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$setDictionaryFlag() {
            for (int i = 0; i < this.fIncludesSets.size(); ++i) {
                RBBINode varRef;
                RBBINode usetNode = this.fIncludesSets.get(i);
                String setName = "";
                RBBINode setRef = usetNode.fParent;
                if (setRef != null && (varRef = setRef.fParent) != null && varRef.fType == 2) {
                    setName = varRef.fText;
                }
                if (!setName.equals("dictionary")) continue;
                this.fNum |= 0x4000;
                break;
            }
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__();
        }

        RangeDescriptor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__(), 0, this);
        }

        private void __constructor__(RangeDescriptor rangeDescriptor) {
            this.$$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__(rangeDescriptor);
        }

        RangeDescriptor(RangeDescriptor rangeDescriptor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$__constructor__(android.icu.text.RBBISetBuilder$RangeDescriptor ), 0, this, rangeDescriptor);
        }

        void split(int n) {
            InvokeDynamicSupport.bootstrap("split", $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$split(int ), 0, this, n);
        }

        void setDictionaryFlag() {
            InvokeDynamicSupport.bootstrap("setDictionaryFlag", $$robo$$android_icu_text_RBBISetBuilder_RangeDescriptor$setDictionaryFlag(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RangeDescriptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

