/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.LocaleUtility;
import android.icu.impl.Utility;
import android.icu.lang.UScript;
import android.icu.text.AnyTransliterator;
import android.icu.text.CompoundTransliterator;
import android.icu.text.RuleBasedTransliterator;
import android.icu.text.Transliterator;
import android.icu.text.TransliteratorIDParser;
import android.icu.text.TransliteratorParser;
import android.icu.text.UnicodeSet;
import android.icu.util.CaseInsensitiveString;
import android.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TransliteratorRegistry
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static char LOCALE_SEP = '_';
    private static String NO_VARIANT = "";
    private static String ANY = "Any";
    private Map<CaseInsensitiveString, Object[]> registry;
    private Map<CaseInsensitiveString, Map<CaseInsensitiveString, List<CaseInsensitiveString>>> specDAG;
    private List<CaseInsensitiveString> availableIDs;
    private static boolean DEBUG = false;

    private void $$robo$$android_icu_text_TransliteratorRegistry$__constructor__() {
        this.registry = Collections.synchronizedMap(new HashMap());
        this.specDAG = Collections.synchronizedMap(new HashMap());
        this.availableIDs = new ArrayList<CaseInsensitiveString>();
    }

    private final Transliterator $$robo$$android_icu_text_TransliteratorRegistry$get(String ID, StringBuffer aliasReturn) {
        Object[] entry = this.find(ID);
        return entry == null ? null : this.instantiateEntry(ID, entry, aliasReturn);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$put(String ID, Class<? extends Transliterator> transliteratorSubclass, boolean visible) {
        this.registerEntry(ID, transliteratorSubclass, visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$put(String ID, Transliterator.Factory factory, boolean visible) {
        this.registerEntry(ID, factory, visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$put(String ID, String resourceName, int dir, boolean visible) {
        this.registerEntry(ID, new ResourceEntry(resourceName, dir), visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$put(String ID, String alias, boolean visible) {
        this.registerEntry(ID, new AliasEntry(alias), visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$put(String ID, Transliterator trans, boolean visible) {
        this.registerEntry(ID, trans, visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$remove(String ID) {
        String[] stv = TransliteratorIDParser.IDtoSTV(ID);
        String id2 = TransliteratorIDParser.STVtoID(stv[0], stv[1], stv[2]);
        this.registry.remove(new CaseInsensitiveString(id2));
        this.removeSTV(stv[0], stv[1], stv[2]);
        this.availableIDs.remove(new CaseInsensitiveString(id2));
    }

    private final Enumeration<String> $$robo$$android_icu_text_TransliteratorRegistry$getAvailableIDs() {
        return new IDEnumeration(Collections.enumeration(this.availableIDs));
    }

    private final Enumeration<String> $$robo$$android_icu_text_TransliteratorRegistry$getAvailableSources() {
        return new IDEnumeration(Collections.enumeration(this.specDAG.keySet()));
    }

    private final Enumeration<String> $$robo$$android_icu_text_TransliteratorRegistry$getAvailableTargets(String source) {
        CaseInsensitiveString cisrc = new CaseInsensitiveString(source);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> targets = this.specDAG.get(cisrc);
        if (targets == null) {
            return new IDEnumeration(null);
        }
        return new IDEnumeration(Collections.enumeration(targets.keySet()));
    }

    private final Enumeration<String> $$robo$$android_icu_text_TransliteratorRegistry$getAvailableVariants(String source, String target) {
        CaseInsensitiveString cisrc = new CaseInsensitiveString(source);
        CaseInsensitiveString citrg = new CaseInsensitiveString(target);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> targets = this.specDAG.get(cisrc);
        if (targets == null) {
            return new IDEnumeration(null);
        }
        List<CaseInsensitiveString> variants = targets.get(citrg);
        if (variants == null) {
            return new IDEnumeration(null);
        }
        return new IDEnumeration(Collections.enumeration(variants));
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(String source, String target, String variant, Object entry, boolean visible) {
        String s = source;
        if (s.length() == 0) {
            s = "Any";
        }
        String ID = TransliteratorIDParser.STVtoID(source, target, variant);
        this.registerEntry(ID, s, target, variant, entry, visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(String ID, Object entry, boolean visible) {
        String[] stv = TransliteratorIDParser.IDtoSTV(ID);
        String id2 = TransliteratorIDParser.STVtoID(stv[0], stv[1], stv[2]);
        this.registerEntry(id2, stv[0], stv[1], stv[2], entry, visible);
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(String ID, String source, String target, String variant, Object entry, boolean visible) {
        CaseInsensitiveString ciID = new CaseInsensitiveString(ID);
        Object[] arrayOfObj = entry instanceof Object[] ? (Object[])entry : new Object[]{entry};
        this.registry.put(ciID, arrayOfObj);
        if (visible) {
            this.registerSTV(source, target, variant);
            if (!this.availableIDs.contains(ciID)) {
                this.availableIDs.add(ciID);
            }
        } else {
            this.removeSTV(source, target, variant);
            this.availableIDs.remove(ciID);
        }
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$registerSTV(String source, String target, String variant) {
        List<CaseInsensitiveString> variants;
        CaseInsensitiveString cisrc = new CaseInsensitiveString(source);
        CaseInsensitiveString citrg = new CaseInsensitiveString(target);
        CaseInsensitiveString civar = new CaseInsensitiveString(variant);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> targets = this.specDAG.get(cisrc);
        if (targets == null) {
            targets = Collections.synchronizedMap(new HashMap());
            this.specDAG.put(cisrc, targets);
        }
        if ((variants = targets.get(citrg)) == null) {
            variants = new ArrayList<CaseInsensitiveString>();
            targets.put(citrg, variants);
        }
        if (!variants.contains(civar)) {
            if (variant.length() > 0) {
                variants.add(civar);
            } else {
                variants.add(0, civar);
            }
        }
    }

    private final void $$robo$$android_icu_text_TransliteratorRegistry$removeSTV(String source, String target, String variant) {
        CaseInsensitiveString cisrc = new CaseInsensitiveString(source);
        CaseInsensitiveString citrg = new CaseInsensitiveString(target);
        CaseInsensitiveString civar = new CaseInsensitiveString(variant);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> targets = this.specDAG.get(cisrc);
        if (targets == null) {
            return;
        }
        List<CaseInsensitiveString> variants = targets.get(citrg);
        if (variants == null) {
            return;
        }
        variants.remove(civar);
        if (variants.size() == 0) {
            targets.remove(citrg);
            if (targets.size() == 0) {
                this.specDAG.remove(cisrc);
            }
        }
    }

    private final Object[] $$robo$$android_icu_text_TransliteratorRegistry$findInDynamicStore(Spec src, Spec trg, String variant) {
        String ID = TransliteratorIDParser.STVtoID(src.get(), trg.get(), variant);
        return this.registry.get(new CaseInsensitiveString(ID));
    }

    private final Object[] $$robo$$android_icu_text_TransliteratorRegistry$findInStaticStore(Spec src, Spec trg, String variant) {
        Object[] entry = null;
        if (src.isLocale()) {
            entry = this.findInBundle(src, trg, variant, 0);
        } else if (trg.isLocale()) {
            entry = this.findInBundle(trg, src, variant, 1);
        }
        if (entry != null) {
            this.registerEntry(src.getTop(), trg.getTop(), variant, entry, false);
        }
        return entry;
    }

    private final Object[] $$robo$$android_icu_text_TransliteratorRegistry$findInBundle(Spec specToOpen, Spec specToFind, String variant, int direction) {
        ResourceBundle res = specToOpen.getBundle();
        if (res == null) {
            return null;
        }
        for (int pass = 0; pass < 2; ++pass) {
            StringBuilder tag = new StringBuilder();
            if (pass == 0) {
                tag.append(direction == 0 ? "TransliterateTo" : "TransliterateFrom");
            } else {
                tag.append("Transliterate");
            }
            tag.append(specToFind.get().toUpperCase(Locale.ENGLISH));
            try {
                String[] subres = res.getStringArray(tag.toString());
                int i = 0;
                if (variant.length() != 0) {
                    for (i = 0; i < subres.length && !subres[i].equalsIgnoreCase(variant); i += 2) {
                    }
                }
                if (i >= subres.length) continue;
                int dir = pass == 0 ? 0 : direction;
                return new Object[]{new LocaleEntry(subres[i + 1], dir)};
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private final Object[] $$robo$$android_icu_text_TransliteratorRegistry$find(String ID) {
        String[] stv = TransliteratorIDParser.IDtoSTV(ID);
        return this.find(stv[0], stv[1], stv[2]);
    }

    private final Object[] $$robo$$android_icu_text_TransliteratorRegistry$find(String source, String target, String variant) {
        Spec src = new Spec(source);
        Spec trg = new Spec(target);
        Object[] entry = null;
        if (variant.length() != 0) {
            entry = this.findInDynamicStore(src, trg, variant);
            if (entry != null) {
                return entry;
            }
            entry = this.findInStaticStore(src, trg, variant);
            if (entry != null) {
                return entry;
            }
        }
        while (true) {
            src.reset();
            while (true) {
                if ((entry = this.findInDynamicStore(src, trg, "")) != null) {
                    return entry;
                }
                entry = this.findInStaticStore(src, trg, "");
                if (entry != null) {
                    return entry;
                }
                if (!src.hasFallback()) break;
                src.next();
            }
            if (!trg.hasFallback()) break;
            trg.next();
        }
        return null;
    }

    private final Transliterator $$robo$$android_icu_text_TransliteratorRegistry$instantiateEntry(String ID, Object[] entryWrapper, StringBuffer aliasReturn) {
        while (true) {
            Transliterator temp;
            Object entry;
            if ((entry = entryWrapper[0]) instanceof RuleBasedTransliterator.Data) {
                RuleBasedTransliterator.Data data = (RuleBasedTransliterator.Data)entry;
                return new RuleBasedTransliterator(ID, data, null);
            }
            if (entry instanceof Class) {
                try {
                    return (Transliterator)((Class)entry).newInstance();
                }
                catch (InstantiationException data) {
                }
                catch (IllegalAccessException data) {
                    // empty catch block
                }
                return null;
            }
            if (entry instanceof AliasEntry) {
                aliasReturn.append(((AliasEntry)entry).alias);
                return null;
            }
            if (entry instanceof Transliterator.Factory) {
                return ((Transliterator.Factory)entry).getInstance(ID);
            }
            if (entry instanceof CompoundRBTEntry) {
                return ((CompoundRBTEntry)entry).getInstance();
            }
            if (entry instanceof AnyTransliterator) {
                temp = (AnyTransliterator)entry;
                return ((AnyTransliterator)temp).safeClone();
            }
            if (entry instanceof RuleBasedTransliterator) {
                temp = (RuleBasedTransliterator)entry;
                return ((RuleBasedTransliterator)temp).safeClone();
            }
            if (entry instanceof CompoundTransliterator) {
                temp = (CompoundTransliterator)entry;
                return ((CompoundTransliterator)temp).safeClone();
            }
            if (entry instanceof Transliterator) {
                return (Transliterator)entry;
            }
            TransliteratorParser parser = new TransliteratorParser();
            try {
                ResourceEntry re = (ResourceEntry)entry;
                parser.parse(re.resource, re.direction);
            }
            catch (ClassCastException e) {
                LocaleEntry le = (LocaleEntry)entry;
                parser.parse(le.rule, le.direction);
            }
            if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 0) {
                entryWrapper[0] = new AliasEntry("Any-Null");
                continue;
            }
            if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 1) {
                entryWrapper[0] = parser.dataVector.get(0);
                continue;
            }
            if (parser.idBlockVector.size() == 1 && parser.dataVector.size() == 0) {
                if (parser.compoundFilter != null) {
                    entryWrapper[0] = new AliasEntry(parser.compoundFilter.toPattern(false) + ";" + parser.idBlockVector.get(0));
                    continue;
                }
                entryWrapper[0] = new AliasEntry(parser.idBlockVector.get(0));
                continue;
            }
            entryWrapper[0] = new CompoundRBTEntry(ID, parser.idBlockVector, parser.dataVector, parser.compoundFilter);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_TransliteratorRegistry$__constructor__();
    }

    public TransliteratorRegistry() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry$__constructor__(), 0, this);
    }

    public Transliterator get(String string2, StringBuffer stringBuffer) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_TransliteratorRegistry$get(java.lang.String java.lang.StringBuffer ), 0, this, string2, stringBuffer);
    }

    public void put(String string2, Class<? extends Transliterator> clazz, boolean bl) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_TransliteratorRegistry$put(java.lang.String java.lang.Class<? extends android.icu.text.Transliterator> boolean ), 0, this, string2, clazz, bl);
    }

    public void put(String string2, Transliterator.Factory factory, boolean bl) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_TransliteratorRegistry$put(java.lang.String android.icu.text.Transliterator$Factory boolean ), 0, this, string2, factory, bl);
    }

    public void put(String string2, String string3, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_TransliteratorRegistry$put(java.lang.String java.lang.String int boolean ), 0, this, string2, string3, n, bl);
    }

    public void put(String string2, String string3, boolean bl) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_TransliteratorRegistry$put(java.lang.String java.lang.String boolean ), 0, this, string2, string3, bl);
    }

    public void put(String string2, Transliterator transliterator, boolean bl) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_TransliteratorRegistry$put(java.lang.String android.icu.text.Transliterator boolean ), 0, this, string2, transliterator, bl);
    }

    public void remove(String string2) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_TransliteratorRegistry$remove(java.lang.String ), 0, this, string2);
    }

    public Enumeration<String> getAvailableIDs() {
        return InvokeDynamicSupport.bootstrap("getAvailableIDs", $$robo$$android_icu_text_TransliteratorRegistry$getAvailableIDs(), 0, this);
    }

    public Enumeration<String> getAvailableSources() {
        return InvokeDynamicSupport.bootstrap("getAvailableSources", $$robo$$android_icu_text_TransliteratorRegistry$getAvailableSources(), 0, this);
    }

    public Enumeration<String> getAvailableTargets(String string2) {
        return InvokeDynamicSupport.bootstrap("getAvailableTargets", $$robo$$android_icu_text_TransliteratorRegistry$getAvailableTargets(java.lang.String ), 0, this, string2);
    }

    public Enumeration<String> getAvailableVariants(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getAvailableVariants", $$robo$$android_icu_text_TransliteratorRegistry$getAvailableVariants(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void registerEntry(String string2, String string3, String string4, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("registerEntry", $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(java.lang.String java.lang.String java.lang.String java.lang.Object boolean ), 0, this, string2, string3, string4, object, bl);
    }

    private void registerEntry(String string2, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("registerEntry", $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(java.lang.String java.lang.Object boolean ), 0, this, string2, object, bl);
    }

    private void registerEntry(String string2, String string3, String string4, String string5, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("registerEntry", $$robo$$android_icu_text_TransliteratorRegistry$registerEntry(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.Object boolean ), 0, this, string2, string3, string4, string5, object, bl);
    }

    private void registerSTV(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("registerSTV", $$robo$$android_icu_text_TransliteratorRegistry$registerSTV(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private void removeSTV(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("removeSTV", $$robo$$android_icu_text_TransliteratorRegistry$removeSTV(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private Object[] findInDynamicStore(Spec spec, Spec spec2, String string2) {
        return InvokeDynamicSupport.bootstrap("findInDynamicStore", $$robo$$android_icu_text_TransliteratorRegistry$findInDynamicStore(android.icu.text.TransliteratorRegistry$Spec android.icu.text.TransliteratorRegistry$Spec java.lang.String ), 0, this, spec, spec2, string2);
    }

    private Object[] findInStaticStore(Spec spec, Spec spec2, String string2) {
        return InvokeDynamicSupport.bootstrap("findInStaticStore", $$robo$$android_icu_text_TransliteratorRegistry$findInStaticStore(android.icu.text.TransliteratorRegistry$Spec android.icu.text.TransliteratorRegistry$Spec java.lang.String ), 0, this, spec, spec2, string2);
    }

    private Object[] findInBundle(Spec spec, Spec spec2, String string2, int n) {
        return InvokeDynamicSupport.bootstrap("findInBundle", $$robo$$android_icu_text_TransliteratorRegistry$findInBundle(android.icu.text.TransliteratorRegistry$Spec android.icu.text.TransliteratorRegistry$Spec java.lang.String int ), 0, this, spec, spec2, string2, n);
    }

    private Object[] find(String string2) {
        return InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_text_TransliteratorRegistry$find(java.lang.String ), 0, this, string2);
    }

    private Object[] find(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_text_TransliteratorRegistry$find(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private Transliterator instantiateEntry(String string2, Object[] objectArray, StringBuffer stringBuffer) {
        return InvokeDynamicSupport.bootstrap("instantiateEntry", $$robo$$android_icu_text_TransliteratorRegistry$instantiateEntry(java.lang.String java.lang.Object[] java.lang.StringBuffer ), 0, this, string2, objectArray, stringBuffer);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransliteratorRegistry)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class IDEnumeration
    implements Enumeration<String> {
        public transient /* synthetic */ Object __robo_data__;
        Enumeration<CaseInsensitiveString> en;

        private void $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$__constructor__(Enumeration<CaseInsensitiveString> e) {
            this.en = e;
        }

        private final boolean $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$hasMoreElements() {
            return this.en != null && this.en.hasMoreElements();
        }

        private final String $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$nextElement() {
            return this.en.nextElement().getString();
        }

        private void __constructor__(Enumeration<CaseInsensitiveString> enumeration) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$__constructor__(enumeration);
        }

        public IDEnumeration(Enumeration<CaseInsensitiveString> enumeration) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$__constructor__(java.util.Enumeration<android.icu.util.CaseInsensitiveString> ), 0, this, enumeration);
        }

        @Override
        public boolean hasMoreElements() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasMoreElements", $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$hasMoreElements(), 0, this);
        }

        @Override
        public String nextElement() {
            return InvokeDynamicSupport.bootstrap("nextElement", $$robo$$android_icu_text_TransliteratorRegistry_IDEnumeration$nextElement(), 0, this);
        }

        public /* synthetic */ IDEnumeration() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IDEnumeration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CompoundRBTEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String ID;
        private List<String> idBlockVector;
        private List<RuleBasedTransliterator.Data> dataVector;
        private UnicodeSet compoundFilter;

        private void $$robo$$android_icu_text_TransliteratorRegistry_CompoundRBTEntry$__constructor__(String theID, List<String> theIDBlockVector, List<RuleBasedTransliterator.Data> theDataVector, UnicodeSet theCompoundFilter) {
            this.ID = theID;
            this.idBlockVector = theIDBlockVector;
            this.dataVector = theDataVector;
            this.compoundFilter = theCompoundFilter;
        }

        private final Transliterator $$robo$$android_icu_text_TransliteratorRegistry_CompoundRBTEntry$getInstance() {
            ArrayList<Transliterator> transliterators = new ArrayList<Transliterator>();
            int passNumber = 1;
            int limit = Math.max(this.idBlockVector.size(), this.dataVector.size());
            for (int i = 0; i < limit; ++i) {
                String idBlock;
                if (i < this.idBlockVector.size() && (idBlock = this.idBlockVector.get(i)).length() > 0) {
                    transliterators.add(Transliterator.getInstance(idBlock));
                }
                if (i >= this.dataVector.size()) continue;
                RuleBasedTransliterator.Data data = this.dataVector.get(i);
                transliterators.add(new RuleBasedTransliterator("%Pass" + passNumber++, data, null));
            }
            CompoundTransliterator t = new CompoundTransliterator(transliterators, passNumber - 1);
            t.setID(this.ID);
            if (this.compoundFilter != null) {
                t.setFilter(this.compoundFilter);
            }
            return t;
        }

        private void __constructor__(String string2, List<String> list, List<RuleBasedTransliterator.Data> list2, UnicodeSet unicodeSet) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_CompoundRBTEntry$__constructor__(string2, list, list2, unicodeSet);
        }

        public CompoundRBTEntry(String string2, List<String> list, List<RuleBasedTransliterator.Data> list2, UnicodeSet unicodeSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_CompoundRBTEntry$__constructor__(java.lang.String java.util.List<java.lang.String> java.util.List<android.icu.text.RuleBasedTransliterator$Data> android.icu.text.UnicodeSet ), 0, this, string2, list, list2, unicodeSet);
        }

        public Transliterator getInstance() {
            return InvokeDynamicSupport.bootstrap("getInstance", $$robo$$android_icu_text_TransliteratorRegistry_CompoundRBTEntry$getInstance(), 0, this);
        }

        public /* synthetic */ CompoundRBTEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompoundRBTEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AliasEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String alias;

        private void $$robo$$android_icu_text_TransliteratorRegistry_AliasEntry$__constructor__(String a) {
            this.alias = a;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_AliasEntry$__constructor__(string2);
        }

        public AliasEntry(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_AliasEntry$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ AliasEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AliasEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LocaleEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String rule;
        public int direction;

        private void $$robo$$android_icu_text_TransliteratorRegistry_LocaleEntry$__constructor__(String r, int d) {
            this.rule = r;
            this.direction = d;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_LocaleEntry$__constructor__(string2, n);
        }

        public LocaleEntry(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_LocaleEntry$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ LocaleEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ResourceEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String resource;
        public int direction;

        private void $$robo$$android_icu_text_TransliteratorRegistry_ResourceEntry$__constructor__(String n, int d) {
            this.resource = n;
            this.direction = d;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_ResourceEntry$__constructor__(string2, n);
        }

        public ResourceEntry(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_ResourceEntry$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ ResourceEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Spec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String top;
        private String spec;
        private String nextSpec;
        private String scriptName;
        private boolean isSpecLocale;
        private boolean isNextLocale;
        private ICUResourceBundle res;

        private void $$robo$$android_icu_text_TransliteratorRegistry_Spec$__constructor__(String theSpec) {
            this.top = theSpec;
            this.spec = null;
            this.scriptName = null;
            try {
                int script = UScript.getCodeFromName(this.top);
                int[] s = UScript.getCode(this.top);
                if (s != null) {
                    this.scriptName = UScript.getName(s[0]);
                    if (this.scriptName.equalsIgnoreCase(this.top)) {
                        this.scriptName = null;
                    }
                }
                this.isSpecLocale = false;
                this.res = null;
                if (script == -1) {
                    Locale toploc = LocaleUtility.getLocaleFromName(this.top);
                    this.res = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b/translit", toploc);
                    if (this.res != null && LocaleUtility.isFallbackOf(this.res.getULocale().toString(), this.top)) {
                        this.isSpecLocale = true;
                    }
                }
            }
            catch (MissingResourceException e) {
                this.scriptName = null;
            }
            this.reset();
        }

        private final boolean $$robo$$android_icu_text_TransliteratorRegistry_Spec$hasFallback() {
            return this.nextSpec != null;
        }

        private final void $$robo$$android_icu_text_TransliteratorRegistry_Spec$reset() {
            if (!Utility.sameObjects(this.spec, this.top)) {
                this.spec = this.top;
                this.isSpecLocale = this.res != null;
                this.setupNext();
            }
        }

        private final void $$robo$$android_icu_text_TransliteratorRegistry_Spec$setupNext() {
            this.isNextLocale = false;
            if (this.isSpecLocale) {
                this.nextSpec = this.spec;
                int i = this.nextSpec.lastIndexOf(95);
                if (i > 0) {
                    this.nextSpec = this.spec.substring(0, i);
                    this.isNextLocale = true;
                } else {
                    this.nextSpec = this.scriptName;
                }
            } else {
                this.nextSpec = !Utility.sameObjects(this.nextSpec, this.scriptName) ? this.scriptName : null;
            }
        }

        private final String $$robo$$android_icu_text_TransliteratorRegistry_Spec$next() {
            this.spec = this.nextSpec;
            this.isSpecLocale = this.isNextLocale;
            this.setupNext();
            return this.spec;
        }

        private final String $$robo$$android_icu_text_TransliteratorRegistry_Spec$get() {
            return this.spec;
        }

        private final boolean $$robo$$android_icu_text_TransliteratorRegistry_Spec$isLocale() {
            return this.isSpecLocale;
        }

        private final ResourceBundle $$robo$$android_icu_text_TransliteratorRegistry_Spec$getBundle() {
            if (this.res != null && this.res.getULocale().toString().equals(this.spec)) {
                return this.res;
            }
            return null;
        }

        private final String $$robo$$android_icu_text_TransliteratorRegistry_Spec$getTop() {
            return this.top;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_TransliteratorRegistry_Spec$__constructor__(string2);
        }

        public Spec(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_TransliteratorRegistry_Spec$__constructor__(java.lang.String ), 0, this, string2);
        }

        public boolean hasFallback() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFallback", $$robo$$android_icu_text_TransliteratorRegistry_Spec$hasFallback(), 0, this);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_TransliteratorRegistry_Spec$reset(), 0, this);
        }

        private void setupNext() {
            InvokeDynamicSupport.bootstrap("setupNext", $$robo$$android_icu_text_TransliteratorRegistry_Spec$setupNext(), 0, this);
        }

        public String next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_TransliteratorRegistry_Spec$next(), 0, this);
        }

        public String get() {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_TransliteratorRegistry_Spec$get(), 0, this);
        }

        public boolean isLocale() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLocale", $$robo$$android_icu_text_TransliteratorRegistry_Spec$isLocale(), 0, this);
        }

        public ResourceBundle getBundle() {
            return InvokeDynamicSupport.bootstrap("getBundle", $$robo$$android_icu_text_TransliteratorRegistry_Spec$getBundle(), 0, this);
        }

        public String getTop() {
            return InvokeDynamicSupport.bootstrap("getTop", $$robo$$android_icu_text_TransliteratorRegistry_Spec$getTop(), 0, this);
        }

        public /* synthetic */ Spec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Spec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

