/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.Grego;
import android.icu.impl.ICUConfig;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.JavaTimeZone;
import android.icu.impl.OlsonTimeZone;
import android.icu.impl.TimeZoneAdapter;
import android.icu.impl.ZoneMeta;
import android.icu.text.TimeZoneFormat;
import android.icu.text.TimeZoneNames;
import android.icu.util.BasicTimeZone;
import android.icu.util.Freezable;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.Output;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Logger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class TimeZone
implements Serializable,
Cloneable,
Freezable<TimeZone> {
    public transient /* synthetic */ Object __robo_data__;
    private static Logger LOGGER;
    private static long serialVersionUID = -744942128318337471L;
    public static int TIMEZONE_ICU = 0;
    public static int TIMEZONE_JDK = 1;
    public static int SHORT = 0;
    public static int LONG = 1;
    public static int SHORT_GENERIC = 2;
    public static int LONG_GENERIC = 3;
    public static int SHORT_GMT = 4;
    public static int LONG_GMT = 5;
    public static int SHORT_COMMONLY_USED = 6;
    public static int GENERIC_LOCATION = 7;
    public static String UNKNOWN_ZONE_ID = "Etc/Unknown";
    static String GMT_ZONE_ID = "Etc/GMT";
    public static TimeZone UNKNOWN_ZONE;
    public static TimeZone GMT_ZONE;
    private String ID;
    private static volatile TimeZone defaultZone;
    private static int TZ_IMPL;
    private static String TZIMPL_CONFIG_KEY = "android.icu.util.TimeZone.DefaultTimeZoneType";
    private static String TZIMPL_CONFIG_ICU = "ICU";
    private static String TZIMPL_CONFIG_JDK = "JDK";
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_util_TimeZone$__constructor__() {
    }

    @Deprecated
    private void $$robo$$android_icu_util_TimeZone$__constructor__(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    private final int $$robo$$android_icu_util_TimeZone$getOffset(long date) {
        int[] result = new int[2];
        this.getOffset(date, false, result);
        return result[0] + result[1];
    }

    private final void $$robo$$android_icu_util_TimeZone$getOffset(long date, boolean local, int[] offsets) {
        offsets[0] = this.getRawOffset();
        if (!local) {
            date += (long)offsets[0];
        }
        int[] fields = new int[6];
        int pass = 0;
        while (true) {
            Grego.timeToFields(date, fields);
            offsets[1] = this.getOffset(1, fields[0], fields[1], fields[2], fields[3], fields[5]) - offsets[0];
            if (pass != 0 || !local || offsets[1] == 0) break;
            date -= (long)offsets[1];
            ++pass;
        }
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    private final String $$robo$$android_icu_util_TimeZone$getID() {
        return this.ID;
    }

    private final void $$robo$$android_icu_util_TimeZone$setID(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
        }
        this.ID = ID;
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName() {
        return this._getDisplayName(3, false, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName(Locale locale) {
        return this._getDisplayName(3, false, ULocale.forLocale(locale));
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName(ULocale locale) {
        return this._getDisplayName(3, false, locale);
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName(boolean daylight, int style2) {
        return this.getDisplayName(daylight, style2, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName(boolean daylight, int style2, Locale locale) {
        return this.getDisplayName(daylight, style2, ULocale.forLocale(locale));
    }

    private final String $$robo$$android_icu_util_TimeZone$getDisplayName(boolean daylight, int style2, ULocale locale) {
        if (style2 < 0 || style2 > 7) {
            throw new IllegalArgumentException("Illegal style: " + style2);
        }
        return this._getDisplayName(style2, daylight, locale);
    }

    private final String $$robo$$android_icu_util_TimeZone$_getDisplayName(int style2, boolean daylight, ULocale locale) {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        String result = null;
        if (style2 == 7 || style2 == 3 || style2 == 2) {
            TimeZoneFormat tzfmt = TimeZoneFormat.getInstance(locale);
            CallSite date = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            Output<TimeZoneFormat.TimeType> timeType = new Output<TimeZoneFormat.TimeType>(TimeZoneFormat.TimeType.UNKNOWN);
            switch (style2) {
                case 7: {
                    result = tzfmt.format(TimeZoneFormat.Style.GENERIC_LOCATION, this, (long)date, timeType);
                    break;
                }
                case 3: {
                    result = tzfmt.format(TimeZoneFormat.Style.GENERIC_LONG, this, (long)date, timeType);
                    break;
                }
                case 2: {
                    result = tzfmt.format(TimeZoneFormat.Style.GENERIC_SHORT, this, (long)date, timeType);
                }
            }
            if (daylight && timeType.value == TimeZoneFormat.TimeType.STANDARD || !daylight && timeType.value == TimeZoneFormat.TimeType.DAYLIGHT) {
                int offset = daylight ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
                result = style2 == 2 ? tzfmt.formatOffsetShortLocalizedGMT(offset) : tzfmt.formatOffsetLocalizedGMT(offset);
            }
        } else if (style2 == 5 || style2 == 4) {
            TimeZoneFormat tzfmt = TimeZoneFormat.getInstance(locale);
            int offset = daylight && this.useDaylightTime() ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
            switch (style2) {
                case 5: {
                    result = tzfmt.formatOffsetLocalizedGMT(offset);
                    break;
                }
                case 4: {
                    result = tzfmt.formatOffsetISO8601Basic(offset, false, false, false);
                }
            }
        } else {
            if (!$assertionsDisabled && style2 != 1 && style2 != 0 && style2 != 6) {
                throw new AssertionError();
            }
            CallSite date = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            TimeZoneNames tznames = TimeZoneNames.getInstance(locale);
            TimeZoneNames.NameType nameType = null;
            switch (style2) {
                case 1: {
                    nameType = daylight ? TimeZoneNames.NameType.LONG_DAYLIGHT : TimeZoneNames.NameType.LONG_STANDARD;
                    break;
                }
                case 0: 
                case 6: {
                    nameType = daylight ? TimeZoneNames.NameType.SHORT_DAYLIGHT : TimeZoneNames.NameType.SHORT_STANDARD;
                }
            }
            result = tznames.getDisplayName(ZoneMeta.getCanonicalCLDRID(this), nameType, (long)date);
            if (result == null) {
                TimeZoneFormat tzfmt = TimeZoneFormat.getInstance(locale);
                int offset = daylight && this.useDaylightTime() ? this.getRawOffset() + this.getDSTSavings() : this.getRawOffset();
                String string2 = result = style2 == 1 ? tzfmt.formatOffsetLocalizedGMT(offset) : tzfmt.formatOffsetShortLocalizedGMT(offset);
            }
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        return result;
    }

    private final int $$robo$$android_icu_util_TimeZone$getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    private final boolean $$robo$$android_icu_util_TimeZone$observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    private static final TimeZone $$robo$$android_icu_util_TimeZone$getTimeZone(String ID) {
        return TimeZone.getTimeZone(ID, TZ_IMPL, false);
    }

    private static final TimeZone $$robo$$android_icu_util_TimeZone$getFrozenTimeZone(String ID) {
        return TimeZone.getTimeZone(ID, TZ_IMPL, true);
    }

    private static final TimeZone $$robo$$android_icu_util_TimeZone$getTimeZone(String ID, int type) {
        return TimeZone.getTimeZone(ID, type, false);
    }

    private static final TimeZone $$robo$$android_icu_util_TimeZone$getTimeZone(String id2, int type, boolean frozen) {
        TimeZone result;
        if (type == 1) {
            result = JavaTimeZone.createTimeZone(id2);
            if (result != null) {
                return frozen ? result.freeze() : result;
            }
            result = TimeZone.getFrozenICUTimeZone(id2, false);
        } else {
            result = TimeZone.getFrozenICUTimeZone(id2, true);
        }
        if (result == null) {
            LOGGER.fine("\"" + id2 + "\" is a bogus id so timezone is falling back to Etc/Unknown(GMT).");
            result = UNKNOWN_ZONE;
        }
        return frozen ? result : result.cloneAsThawed();
    }

    private static final BasicTimeZone $$robo$$android_icu_util_TimeZone$getFrozenICUTimeZone(String id2, boolean trySystem) {
        BasicTimeZone result = null;
        if (trySystem) {
            result = ZoneMeta.getSystemTimeZone(id2);
        }
        if (result == null) {
            result = ZoneMeta.getCustomTimeZone(id2);
        }
        return result;
    }

    private static final synchronized void $$robo$$android_icu_util_TimeZone$setDefaultTimeZoneType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid timezone type");
        }
        TZ_IMPL = type;
    }

    private static final int $$robo$$android_icu_util_TimeZone$getDefaultTimeZoneType() {
        return TZ_IMPL;
    }

    private static final Set<String> $$robo$$android_icu_util_TimeZone$getAvailableIDs(SystemTimeZoneType zoneType, String region, Integer rawOffset) {
        return ZoneMeta.getAvailableIDs(zoneType, region, rawOffset);
    }

    private static final String[] $$robo$$android_icu_util_TimeZone$getAvailableIDs(int rawOffset) {
        Set<String> ids = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, null, rawOffset);
        return ids.toArray(new String[0]);
    }

    private static final String[] $$robo$$android_icu_util_TimeZone$getAvailableIDs(String country) {
        Set<String> ids = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, country, null);
        return ids.toArray(new String[0]);
    }

    private static final String[] $$robo$$android_icu_util_TimeZone$getAvailableIDs() {
        Set<String> ids = TimeZone.getAvailableIDs(SystemTimeZoneType.ANY, null, null);
        return ids.toArray(new String[0]);
    }

    private static final int $$robo$$android_icu_util_TimeZone$countEquivalentIDs(String id2) {
        return ZoneMeta.countEquivalentIDs(id2);
    }

    private static final String $$robo$$android_icu_util_TimeZone$getEquivalentID(String id2, int index) {
        return ZoneMeta.getEquivalentID(id2, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TimeZone $$robo$$android_icu_util_TimeZone$getDefault() {
        TimeZone tmpDefaultZone = defaultZone;
        if (tmpDefaultZone != null) return tmpDefaultZone.cloneAsThawed();
        Class<java.util.TimeZone> clazz = java.util.TimeZone.class;
        synchronized (java.util.TimeZone.class) {
            Class<TimeZone> clazz2 = TimeZone.class;
            synchronized (TimeZone.class) {
                tmpDefaultZone = defaultZone;
                if (tmpDefaultZone != null) return tmpDefaultZone.cloneAsThawed();
                if (TZ_IMPL == 1) {
                    tmpDefaultZone = new JavaTimeZone();
                } else {
                    java.util.TimeZone temp = java.util.TimeZone.getDefault();
                    tmpDefaultZone = TimeZone.getFrozenTimeZone(temp.getID());
                }
                defaultZone = tmpDefaultZone;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tmpDefaultZone.cloneAsThawed();
            }
        }
    }

    private static final synchronized void $$robo$$android_icu_util_TimeZone$setDefault(TimeZone tz) {
        TimeZone.setICUDefault(tz);
        if (tz != null) {
            String icuID;
            java.util.TimeZone jdkZone = null;
            if (tz instanceof JavaTimeZone) {
                jdkZone = ((JavaTimeZone)tz).unwrap();
            } else if (tz instanceof OlsonTimeZone && !(icuID = tz.getID()).equals((jdkZone = java.util.TimeZone.getTimeZone(icuID)).getID()) && !(icuID = TimeZone.getCanonicalID(icuID)).equals((jdkZone = java.util.TimeZone.getTimeZone(icuID)).getID())) {
                jdkZone = null;
            }
            if (jdkZone == null) {
                jdkZone = TimeZoneAdapter.wrap(tz);
            }
            java.util.TimeZone.setDefault(jdkZone);
        }
    }

    @Deprecated
    private static final synchronized void $$robo$$android_icu_util_TimeZone$setICUDefault(TimeZone tz) {
        defaultZone = tz == null ? null : (tz.isFrozen() ? tz : ((TimeZone)tz.clone()).freeze());
    }

    private final boolean $$robo$$android_icu_util_TimeZone$hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    private final Object $$robo$$android_icu_util_TimeZone$clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneAsThawed();
    }

    private final boolean $$robo$$android_icu_util_TimeZone$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.ID.equals(((TimeZone)obj).ID);
    }

    private final int $$robo$$android_icu_util_TimeZone$hashCode() {
        return this.ID.hashCode();
    }

    private static final String $$robo$$android_icu_util_TimeZone$getTZDataVersion() {
        return VersionInfo.getTZDataVersion();
    }

    private static final String $$robo$$android_icu_util_TimeZone$getCanonicalID(String id2) {
        return TimeZone.getCanonicalID(id2, null);
    }

    private static final String $$robo$$android_icu_util_TimeZone$getCanonicalID(String id2, boolean[] isSystemID) {
        String canonicalID = null;
        boolean systemTzid = false;
        if (id2 != null && id2.length() != 0) {
            if (id2.equals("Etc/Unknown")) {
                canonicalID = "Etc/Unknown";
                systemTzid = false;
            } else {
                canonicalID = ZoneMeta.getCanonicalCLDRID(id2);
                if (canonicalID != null) {
                    systemTzid = true;
                } else {
                    canonicalID = ZoneMeta.getCustomID(id2);
                }
            }
        }
        if (isSystemID != null) {
            isSystemID[0] = systemTzid;
        }
        return canonicalID;
    }

    private static final String $$robo$$android_icu_util_TimeZone$getRegion(String id2) {
        String region = null;
        if (!id2.equals("Etc/Unknown")) {
            region = ZoneMeta.getRegion(id2);
        }
        if (region == null) {
            throw new IllegalArgumentException("Unknown system zone id: " + id2);
        }
        return region;
    }

    private static final String $$robo$$android_icu_util_TimeZone$getWindowsID(String id2) {
        boolean[] isSystemID = new boolean[]{false};
        id2 = TimeZone.getCanonicalID(id2, isSystemID);
        if (!isSystemID[0]) {
            return null;
        }
        UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", "windowsZones", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle mapTimezones = top.get("mapTimezones");
        UResourceBundleIterator resitr = mapTimezones.getIterator();
        while (resitr.hasNext()) {
            UResourceBundle winzone = resitr.next();
            if (winzone.getType() != 2) continue;
            UResourceBundleIterator rgitr = winzone.getIterator();
            while (rgitr.hasNext()) {
                String[] tzids;
                UResourceBundle regionalData = rgitr.next();
                if (regionalData.getType() != 0) continue;
                for (String tzid : tzids = regionalData.getString().split(" ")) {
                    if (!tzid.equals(id2)) continue;
                    return winzone.getKey();
                }
            }
        }
        return null;
    }

    private static final String $$robo$$android_icu_util_TimeZone$getIDForWindowsID(String winid, String region) {
        String id2 = null;
        UResourceBundle top = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt60b", "windowsZones", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle mapTimezones = top.get("mapTimezones");
        try {
            UResourceBundle zones = mapTimezones.get(winid);
            if (region != null) {
                try {
                    int endIdx;
                    id2 = zones.getString(region);
                    if (id2 != null && (endIdx = id2.indexOf(32)) > 0) {
                        id2 = id2.substring(0, endIdx);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (id2 == null) {
                id2 = zones.getString("001");
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return id2;
    }

    private final boolean $$robo$$android_icu_util_TimeZone$isFrozen() {
        return false;
    }

    private final TimeZone $$robo$$android_icu_util_TimeZone$freeze() {
        throw new UnsupportedOperationException("Needs to be implemented by the subclass.");
    }

    private final TimeZone $$robo$$android_icu_util_TimeZone$cloneAsThawed() {
        try {
            TimeZone other = (TimeZone)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !TimeZone.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("android.icu.util.TimeZone");
        UNKNOWN_ZONE = new ConstantZone(0, "Etc/Unknown").freeze();
        GMT_ZONE = new ConstantZone(0, "Etc/GMT").freeze();
        defaultZone = null;
        TZ_IMPL = 0;
        String type = ICUConfig.get("android.icu.util.TimeZone.DefaultTimeZoneType", "ICU");
        if (type.equalsIgnoreCase("JDK")) {
            TZ_IMPL = 1;
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_TimeZone$__constructor__();
    }

    public TimeZone() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_TimeZone$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_util_TimeZone$__constructor__(string2);
    }

    protected TimeZone(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_TimeZone$__constructor__(java.lang.String ), 0, this, string2);
    }

    public int getOffset(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_TimeZone$getOffset(long ), 0, this, l);
    }

    public void getOffset(long l, boolean bl, int[] nArray) {
        InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_TimeZone$getOffset(long boolean int[] ), 0, this, l, bl, nArray);
    }

    public String getID() {
        return InvokeDynamicSupport.bootstrap("getID", $$robo$$android_icu_util_TimeZone$getID(), 0, this);
    }

    public void setID(String string2) {
        InvokeDynamicSupport.bootstrap("setID", $$robo$$android_icu_util_TimeZone$setID(java.lang.String ), 0, this, string2);
    }

    public String getDisplayName() {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(), 0, this);
    }

    public String getDisplayName(Locale locale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(java.util.Locale ), 0, this, locale);
    }

    public String getDisplayName(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public String getDisplayName(boolean bl, int n) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(boolean int ), 0, this, bl, n);
    }

    public String getDisplayName(boolean bl, int n, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(boolean int java.util.Locale ), 0, this, bl, n, locale);
    }

    public String getDisplayName(boolean bl, int n, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_util_TimeZone$getDisplayName(boolean int android.icu.util.ULocale ), 0, this, bl, n, uLocale);
    }

    private String _getDisplayName(int n, boolean bl, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("_getDisplayName", $$robo$$android_icu_util_TimeZone$_getDisplayName(int boolean android.icu.util.ULocale ), 0, this, n, bl, uLocale);
    }

    public int getDSTSavings() {
        return (int)InvokeDynamicSupport.bootstrap("getDSTSavings", $$robo$$android_icu_util_TimeZone$getDSTSavings(), 0, this);
    }

    public boolean observesDaylightTime() {
        return (boolean)InvokeDynamicSupport.bootstrap("observesDaylightTime", $$robo$$android_icu_util_TimeZone$observesDaylightTime(), 0, this);
    }

    public static TimeZone getTimeZone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZone", $$robo$$android_icu_util_TimeZone$getTimeZone(java.lang.String ), 0, (String)string2);
    }

    public static TimeZone getFrozenTimeZone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getFrozenTimeZone", $$robo$$android_icu_util_TimeZone$getFrozenTimeZone(java.lang.String ), 0, (String)string2);
    }

    public static TimeZone getTimeZone(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZone", $$robo$$android_icu_util_TimeZone$getTimeZone(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static TimeZone getTimeZone(String string2, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getTimeZone", $$robo$$android_icu_util_TimeZone$getTimeZone(java.lang.String int boolean ), 0, (String)string2, (int)n, (boolean)bl);
    }

    static BasicTimeZone getFrozenICUTimeZone(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getFrozenICUTimeZone", $$robo$$android_icu_util_TimeZone$getFrozenICUTimeZone(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    public static synchronized void setDefaultTimeZoneType(int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultTimeZoneType", $$robo$$android_icu_util_TimeZone$setDefaultTimeZoneType(int ), 0, (int)n);
    }

    public static int getDefaultTimeZoneType() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultTimeZoneType", $$robo$$android_icu_util_TimeZone$getDefaultTimeZoneType(), 0);
    }

    public static Set<String> getAvailableIDs(SystemTimeZoneType systemTimeZoneType, String string2, Integer n) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_util_TimeZone$getAvailableIDs(android.icu.util.TimeZone$SystemTimeZoneType java.lang.String java.lang.Integer ), 0, (SystemTimeZoneType)systemTimeZoneType, (String)string2, (Integer)n);
    }

    public static String[] getAvailableIDs(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_util_TimeZone$getAvailableIDs(int ), 0, (int)n);
    }

    public static String[] getAvailableIDs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_util_TimeZone$getAvailableIDs(java.lang.String ), 0, (String)string2);
    }

    public static String[] getAvailableIDs() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableIDs", $$robo$$android_icu_util_TimeZone$getAvailableIDs(), 0);
    }

    public static int countEquivalentIDs(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countEquivalentIDs", $$robo$$android_icu_util_TimeZone$countEquivalentIDs(java.lang.String ), 0, (String)string2);
    }

    public static String getEquivalentID(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEquivalentID", $$robo$$android_icu_util_TimeZone$getEquivalentID(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static TimeZone getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_icu_util_TimeZone$getDefault(), 0);
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_icu_util_TimeZone$setDefault(android.icu.util.TimeZone ), 0, (TimeZone)timeZone);
    }

    @Deprecated
    public static synchronized void setICUDefault(TimeZone timeZone) {
        InvokeDynamicSupport.bootstrapStatic("setICUDefault", $$robo$$android_icu_util_TimeZone$setICUDefault(android.icu.util.TimeZone ), 0, (TimeZone)timeZone);
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSameRules", $$robo$$android_icu_util_TimeZone$hasSameRules(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_util_TimeZone$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_util_TimeZone$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_util_TimeZone$hashCode(), 0, this);
    }

    public static String getTZDataVersion() {
        return InvokeDynamicSupport.bootstrapStatic("getTZDataVersion", $$robo$$android_icu_util_TimeZone$getTZDataVersion(), 0);
    }

    public static String getCanonicalID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalID", $$robo$$android_icu_util_TimeZone$getCanonicalID(java.lang.String ), 0, (String)string2);
    }

    public static String getCanonicalID(String string2, boolean[] blArray) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalID", $$robo$$android_icu_util_TimeZone$getCanonicalID(java.lang.String boolean[] ), 0, (String)string2, (boolean[])blArray);
    }

    public static String getRegion(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getRegion", $$robo$$android_icu_util_TimeZone$getRegion(java.lang.String ), 0, (String)string2);
    }

    public static String getWindowsID(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getWindowsID", $$robo$$android_icu_util_TimeZone$getWindowsID(java.lang.String ), 0, (String)string2);
    }

    public static String getIDForWindowsID(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getIDForWindowsID", $$robo$$android_icu_util_TimeZone$getIDForWindowsID(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_util_TimeZone$isFrozen(), 0, this);
    }

    @Override
    public TimeZone freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_util_TimeZone$freeze(), 0, this);
    }

    @Override
    public TimeZone cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_util_TimeZone$cloneAsThawed(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TimeZone.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZone)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ConstantZone
    extends TimeZone
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 1L;
        private int rawOffset;
        private volatile transient boolean isFrozen;

        private void $$robo$$android_icu_util_TimeZone_ConstantZone$__constructor__(int rawOffset, String ID) {
            this.isFrozen = false;
            this.rawOffset = rawOffset;
        }

        private final int $$robo$$android_icu_util_TimeZone_ConstantZone$getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
            return this.rawOffset;
        }

        private final void $$robo$$android_icu_util_TimeZone_ConstantZone$setRawOffset(int offsetMillis) {
            if (this.isFrozen()) {
                throw new UnsupportedOperationException("Attempt to modify a frozen TimeZone instance.");
            }
            this.rawOffset = offsetMillis;
        }

        private final int $$robo$$android_icu_util_TimeZone_ConstantZone$getRawOffset() {
            return this.rawOffset;
        }

        private final boolean $$robo$$android_icu_util_TimeZone_ConstantZone$useDaylightTime() {
            return false;
        }

        private final boolean $$robo$$android_icu_util_TimeZone_ConstantZone$inDaylightTime(Date date) {
            return false;
        }

        private final boolean $$robo$$android_icu_util_TimeZone_ConstantZone$isFrozen() {
            return this.isFrozen;
        }

        private final TimeZone $$robo$$android_icu_util_TimeZone_ConstantZone$freeze() {
            this.isFrozen = true;
            return this;
        }

        private final TimeZone $$robo$$android_icu_util_TimeZone_ConstantZone$cloneAsThawed() {
            ConstantZone tz = (ConstantZone)super.cloneAsThawed();
            tz.isFrozen = false;
            return tz;
        }

        private /* synthetic */ void $$robo$$android_icu_util_TimeZone_ConstantZone$__constructor__(int x0, String x1, 1 x2) {
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_icu_util_TimeZone_ConstantZone$__constructor__(n, string2);
        }

        private ConstantZone(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_TimeZone_ConstantZone$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
            return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_icu_util_TimeZone_ConstantZone$getOffset(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
        }

        @Override
        public void setRawOffset(int n) {
            InvokeDynamicSupport.bootstrap("setRawOffset", $$robo$$android_icu_util_TimeZone_ConstantZone$setRawOffset(int ), 0, this, n);
        }

        @Override
        public int getRawOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getRawOffset", $$robo$$android_icu_util_TimeZone_ConstantZone$getRawOffset(), 0, this);
        }

        @Override
        public boolean useDaylightTime() {
            return (boolean)InvokeDynamicSupport.bootstrap("useDaylightTime", $$robo$$android_icu_util_TimeZone_ConstantZone$useDaylightTime(), 0, this);
        }

        @Override
        public boolean inDaylightTime(Date date) {
            return (boolean)InvokeDynamicSupport.bootstrap("inDaylightTime", $$robo$$android_icu_util_TimeZone_ConstantZone$inDaylightTime(java.util.Date ), 0, this, date);
        }

        @Override
        public boolean isFrozen() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_util_TimeZone_ConstantZone$isFrozen(), 0, this);
        }

        @Override
        public TimeZone freeze() {
            return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_util_TimeZone_ConstantZone$freeze(), 0, this);
        }

        @Override
        public TimeZone cloneAsThawed() {
            return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_util_TimeZone_ConstantZone$cloneAsThawed(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, String string2, 1 var3_3) {
            this.$$robo$$android_icu_util_TimeZone_ConstantZone$__constructor__(n, string2, var3_3);
        }

        public /* synthetic */ ConstantZone() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConstantZone)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SystemTimeZoneType
    extends Enum<SystemTimeZoneType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ SystemTimeZoneType ANY;
        public static /* enum */ SystemTimeZoneType CANONICAL;
        public static /* enum */ SystemTimeZoneType CANONICAL_LOCATION;
        private static /* synthetic */ SystemTimeZoneType[] $VALUES;

        private static final SystemTimeZoneType[] $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$values() {
            return (SystemTimeZoneType[])$VALUES.clone();
        }

        private static final SystemTimeZoneType $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$valueOf(String name) {
            return Enum.valueOf(SystemTimeZoneType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ANY = new SystemTimeZoneType();
            CANONICAL = new SystemTimeZoneType();
            CANONICAL_LOCATION = new SystemTimeZoneType();
            $VALUES = new SystemTimeZoneType[]{ANY, CANONICAL, CANONICAL_LOCATION};
        }

        public static SystemTimeZoneType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$values(), 0);
        }

        public static SystemTimeZoneType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_util_TimeZone_SystemTimeZoneType$__constructor__(string2, n);
        }

        private SystemTimeZoneType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_TimeZone_SystemTimeZoneType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SystemTimeZoneType.class);
        }

        public /* synthetic */ SystemTimeZoneType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemTimeZoneType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

