/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Context;
import android.location.BatchedLocationCallback;
import android.location.BatchedLocationCallbackTransport;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GnssMeasurementCallbackTransport;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.GnssNavigationMessageCallbackTransport;
import android.location.GnssStatus;
import android.location.GpsMeasurementsEvent;
import android.location.GpsNavigationMessageEvent;
import android.location.GpsStatus;
import android.location.IGnssStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.location.OnNmeaMessageListener;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.location.ProviderProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocationManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LocationManager";
    private Context mContext;
    private ILocationManager mService;
    private GnssMeasurementCallbackTransport mGnssMeasurementCallbackTransport;
    private GnssNavigationMessageCallbackTransport mGnssNavigationMessageCallbackTransport;
    private BatchedLocationCallbackTransport mBatchedLocationCallbackTransport;
    private HashMap<GpsStatus.Listener, GnssStatusListenerTransport> mGpsStatusListeners;
    private HashMap<GpsStatus.NmeaListener, GnssStatusListenerTransport> mGpsNmeaListeners;
    private HashMap<GnssStatus.Callback, GnssStatusListenerTransport> mGnssStatusListeners;
    private HashMap<OnNmeaMessageListener, GnssStatusListenerTransport> mGnssNmeaListeners;
    private volatile GnssStatus mGnssStatus;
    private int mTimeToFirstFix;
    public static String NETWORK_PROVIDER = "network";
    public static String GPS_PROVIDER = "gps";
    public static String PASSIVE_PROVIDER = "passive";
    public static String FUSED_PROVIDER = "fused";
    public static String KEY_PROXIMITY_ENTERING = "entering";
    public static String KEY_STATUS_CHANGED = "status";
    public static String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static String KEY_LOCATION_CHANGED = "location";
    public static String GPS_ENABLED_CHANGE_ACTION = "android.location.GPS_ENABLED_CHANGE";
    public static String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    public static String MODE_CHANGED_ACTION = "android.location.MODE_CHANGED";
    public static String MODE_CHANGING_ACTION = "com.android.settings.location.MODE_CHANGING";
    public static String GPS_FIX_CHANGE_ACTION = "android.location.GPS_FIX_CHANGE";
    public static String EXTRA_GPS_ENABLED = "enabled";
    public static String HIGH_POWER_REQUEST_CHANGE_ACTION = "android.location.HIGH_POWER_REQUEST_CHANGE";
    public static String SETTINGS_FOOTER_DISPLAYED_ACTION = "com.android.settings.location.DISPLAYED_FOOTER";
    public static String SETTINGS_FOOTER_REMOVED_ACTION = "com.android.settings.location.REMOVED_FOOTER";
    public static String METADATA_SETTINGS_FOOTER_STRING = "com.android.settings.location.FOOTER_STRING";
    private HashMap<LocationListener, ListenerTransport> mListeners;

    private final String[] $$robo$$android_location_LocationManager$getBackgroundThrottlingWhitelist() {
        try {
            return this.mService.getBackgroundThrottlingWhitelist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void $$robo$$android_location_LocationManager$__constructor__(Context context, ILocationManager service) {
        this.mGpsStatusListeners = new HashMap();
        this.mGpsNmeaListeners = new HashMap();
        this.mGnssStatusListeners = new HashMap();
        this.mGnssNmeaListeners = new HashMap();
        this.mListeners = new HashMap();
        this.mService = service;
        this.mContext = context;
        this.mGnssMeasurementCallbackTransport = new GnssMeasurementCallbackTransport(this.mContext, this.mService);
        this.mGnssNavigationMessageCallbackTransport = new GnssNavigationMessageCallbackTransport(this.mContext, this.mService);
        this.mBatchedLocationCallbackTransport = new BatchedLocationCallbackTransport(this.mContext, this.mService);
    }

    private final LocationProvider $$robo$$android_location_LocationManager$createProvider(String name, ProviderProperties properties) {
        return new LocationProvider(name, properties);
    }

    private final List<String> $$robo$$android_location_LocationManager$getAllProviders() {
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<String> $$robo$$android_location_LocationManager$getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(null, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final LocationProvider $$robo$$android_location_LocationManager$getProvider(String name) {
        LocationManager.checkProvider(name);
        try {
            ProviderProperties properties = this.mService.getProviderProperties(name);
            if (properties == null) {
                return null;
            }
            return this.createProvider(name, properties);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<String> $$robo$$android_location_LocationManager$getProviders(Criteria criteria, boolean enabledOnly) {
        LocationManager.checkCriteria(criteria);
        try {
            return this.mService.getProviders(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_location_LocationManager$getBestProvider(Criteria criteria, boolean enabledOnly) {
        LocationManager.checkCriteria(criteria);
        try {
            return this.mService.getBestProvider(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, null, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, Looper looper) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        LocationManager.checkProvider(provider);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent intent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(String provider, LocationListener listener, Looper looper) {
        LocationManager.checkProvider(provider);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(Criteria criteria, LocationListener listener, Looper looper) {
        LocationManager.checkCriteria(criteria);
        LocationManager.checkListener(listener);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(String provider, PendingIntent intent) {
        LocationManager.checkProvider(provider);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final void $$robo$$android_location_LocationManager$requestSingleUpdate(Criteria criteria, PendingIntent intent) {
        LocationManager.checkCriteria(criteria);
        this.checkPendingIntent(intent);
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    @SystemApi
    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        LocationManager.checkListener(listener);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    @SystemApi
    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, PendingIntent intent) {
        this.checkPendingIntent(intent);
        this.requestLocationUpdates(request, null, null, intent);
    }

    private final boolean $$robo$$android_location_LocationManager$injectLocation(Location newLocation) {
        try {
            return this.mService.injectLocation(newLocation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ListenerTransport $$robo$$android_location_LocationManager$wrapListener(LocationListener listener, Looper looper) {
        if (listener == null) {
            return null;
        }
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            ListenerTransport transport = this.mListeners.get(listener);
            if (transport == null) {
                transport = new ListenerTransport(this, listener, looper);
            }
            this.mListeners.put(listener, transport);
            return transport;
        }
    }

    private final void $$robo$$android_location_LocationManager$requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper, PendingIntent intent) {
        String packageName = this.mContext.getPackageName();
        ListenerTransport transport = this.wrapListener(listener, looper);
        try {
            this.mService.requestLocationUpdates(request, transport, intent, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_location_LocationManager$removeUpdates(LocationListener listener) {
        ListenerTransport transport;
        LocationManager.checkListener(listener);
        String packageName = this.mContext.getPackageName();
        HashMap<LocationListener, ListenerTransport> hashMap = this.mListeners;
        synchronized (hashMap) {
            transport = this.mListeners.remove(listener);
        }
        if (transport == null) {
            return;
        }
        try {
            this.mService.removeUpdates(transport, null, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$removeUpdates(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeUpdates(null, intent, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        this.checkPendingIntent(intent);
        if (expiration < 0L) {
            expiration = Long.MAX_VALUE;
        }
        Geofence fence = Geofence.createCircle(latitude, longitude, radius);
        LocationRequest request = new LocationRequest().setExpireIn(expiration);
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$addGeofence(LocationRequest request, Geofence fence, PendingIntent intent) {
        this.checkPendingIntent(intent);
        LocationManager.checkGeofence(fence);
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$removeProximityAlert(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, intent, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$removeGeofence(Geofence fence, PendingIntent intent) {
        this.checkPendingIntent(intent);
        LocationManager.checkGeofence(fence);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(fence, intent, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$removeAllGeofences(PendingIntent intent) {
        this.checkPendingIntent(intent);
        String packageName = this.mContext.getPackageName();
        try {
            this.mService.removeGeofence(null, intent, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$isLocationEnabled() {
        return this.isLocationEnabledForUser(Process.myUserHandle());
    }

    @SystemApi
    private final void $$robo$$android_location_LocationManager$setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        try {
            this.mService.setLocationEnabledForUser(enabled, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_location_LocationManager$isLocationEnabledForUser(UserHandle userHandle) {
        try {
            return this.mService.isLocationEnabledForUser(userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$isProviderEnabled(String provider) {
        return this.isProviderEnabledForUser(provider, Process.myUserHandle());
    }

    @SystemApi
    private final boolean $$robo$$android_location_LocationManager$isProviderEnabledForUser(String provider, UserHandle userHandle) {
        LocationManager.checkProvider(provider);
        try {
            return this.mService.isProviderEnabledForUser(provider, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_location_LocationManager$setProviderEnabledForUser(String provider, boolean enabled, UserHandle userHandle) {
        LocationManager.checkProvider(provider);
        try {
            return this.mService.setProviderEnabledForUser(provider, enabled, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Location $$robo$$android_location_LocationManager$getLastLocation() {
        String packageName = this.mContext.getPackageName();
        try {
            return this.mService.getLastLocation(null, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Location $$robo$$android_location_LocationManager$getLastKnownLocation(String provider) {
        LocationManager.checkProvider(provider);
        String packageName = this.mContext.getPackageName();
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        try {
            return this.mService.getLastLocation(request, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$addTestProvider(String name, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        ProviderProperties properties = new ProviderProperties(requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        if (name.matches("[^a-zA-Z0-9]")) {
            throw new IllegalArgumentException("provider name contains illegal character: " + name);
        }
        try {
            this.mService.addTestProvider(name, properties, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$removeTestProvider(String provider) {
        try {
            this.mService.removeTestProvider(provider, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderLocation(String provider, Location loc) {
        if (!loc.isComplete()) {
            IllegalArgumentException e = new IllegalArgumentException("Incomplete location object, missing timestamp or accuracy? " + loc);
            if (this.mContext.getApplicationInfo().targetSdkVersion <= 16) {
                Log.w("LocationManager", e);
                loc.makeComplete();
            } else {
                throw e;
            }
        }
        try {
            this.mService.setTestProviderLocation(provider, loc, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderLocation(String provider) {
        try {
            this.mService.clearTestProviderLocation(provider, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderEnabled(String provider, boolean enabled) {
        try {
            this.mService.setTestProviderEnabled(provider, enabled, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderEnabled(String provider) {
        try {
            this.mService.clearTestProviderEnabled(provider, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
        try {
            this.mService.setTestProviderStatus(provider, status, extras, updateTime, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_location_LocationManager$clearTestProviderStatus(String provider) {
        try {
            this.mService.clearTestProviderStatus(provider, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_location_LocationManager$addGpsStatusListener(GpsStatus.Listener listener) {
        boolean result;
        if (this.mGpsStatusListeners.get(listener) != null) {
            return true;
        }
        try {
            GnssStatusListenerTransport transport = new GnssStatusListenerTransport(this, listener);
            result = this.mService.registerGnssStatusCallback(transport, this.mContext.getPackageName());
            if (result) {
                this.mGpsStatusListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    @Deprecated
    private final void $$robo$$android_location_LocationManager$removeGpsStatusListener(GpsStatus.Listener listener) {
        try {
            GnssStatusListenerTransport transport = this.mGpsStatusListeners.remove(listener);
            if (transport != null) {
                this.mService.unregisterGnssStatusCallback(transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssStatusCallback(GnssStatus.Callback callback) {
        return this.registerGnssStatusCallback(callback, null);
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        boolean result;
        if (this.mGnssStatusListeners.get(callback) != null) {
            return true;
        }
        try {
            GnssStatusListenerTransport transport = new GnssStatusListenerTransport(this, callback, handler);
            result = this.mService.registerGnssStatusCallback(transport, this.mContext.getPackageName());
            if (result) {
                this.mGnssStatusListeners.put(callback, transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    private final void $$robo$$android_location_LocationManager$unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        try {
            GnssStatusListenerTransport transport = this.mGnssStatusListeners.remove(callback);
            if (transport != null) {
                this.mService.unregisterGnssStatusCallback(transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_location_LocationManager$addNmeaListener(GpsStatus.NmeaListener listener) {
        boolean result;
        if (this.mGpsNmeaListeners.get(listener) != null) {
            return true;
        }
        try {
            GnssStatusListenerTransport transport = new GnssStatusListenerTransport(this, listener);
            result = this.mService.registerGnssStatusCallback(transport, this.mContext.getPackageName());
            if (result) {
                this.mGpsNmeaListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    @Deprecated
    private final void $$robo$$android_location_LocationManager$removeNmeaListener(GpsStatus.NmeaListener listener) {
        try {
            GnssStatusListenerTransport transport = this.mGpsNmeaListeners.remove(listener);
            if (transport != null) {
                this.mService.unregisterGnssStatusCallback(transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$addNmeaListener(OnNmeaMessageListener listener) {
        return this.addNmeaListener(listener, null);
    }

    private final boolean $$robo$$android_location_LocationManager$addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        boolean result;
        if (this.mGpsNmeaListeners.get(listener) != null) {
            return true;
        }
        try {
            GnssStatusListenerTransport transport = new GnssStatusListenerTransport(this, listener, handler);
            result = this.mService.registerGnssStatusCallback(transport, this.mContext.getPackageName());
            if (result) {
                this.mGnssNmeaListeners.put(listener, transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return result;
    }

    private final void $$robo$$android_location_LocationManager$removeNmeaListener(OnNmeaMessageListener listener) {
        try {
            GnssStatusListenerTransport transport = this.mGnssNmeaListeners.remove(listener);
            if (transport != null) {
                this.mService.unregisterGnssStatusCallback(transport);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final boolean $$robo$$android_location_LocationManager$addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return false;
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        return this.registerGnssMeasurementsCallback(callback, null);
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback, Handler handler) {
        return this.mGnssMeasurementCallbackTransport.add(callback, handler);
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_location_LocationManager$removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
    }

    private final void $$robo$$android_location_LocationManager$unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        this.mGnssMeasurementCallbackTransport.remove(callback);
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final boolean $$robo$$android_location_LocationManager$addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return false;
    }

    @Deprecated
    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_location_LocationManager$removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        return this.registerGnssNavigationMessageCallback(callback, null);
    }

    private final boolean $$robo$$android_location_LocationManager$registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback, Handler handler) {
        return this.mGnssNavigationMessageCallbackTransport.add(callback, handler);
    }

    private final void $$robo$$android_location_LocationManager$unregisterGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        this.mGnssNavigationMessageCallbackTransport.remove(callback);
    }

    @Deprecated
    private final GpsStatus $$robo$$android_location_LocationManager$getGpsStatus(GpsStatus status) {
        if (status == null) {
            status = new GpsStatus();
        }
        if (this.mGnssStatus != null) {
            status.setStatus(this.mGnssStatus, this.mTimeToFirstFix);
        }
        return status;
    }

    private final int $$robo$$android_location_LocationManager$getGnssYearOfHardware() {
        try {
            return this.mService.getGnssYearOfHardware();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_location_LocationManager$getGnssHardwareModelName() {
        try {
            return this.mService.getGnssHardwareModelName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final int $$robo$$android_location_LocationManager$getGnssBatchSize() {
        try {
            return this.mService.getGnssBatchSize(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_location_LocationManager$registerGnssBatchedLocationCallback(long periodNanos, boolean wakeOnFifoFull, BatchedLocationCallback callback, Handler handler) {
        this.mBatchedLocationCallbackTransport.add(callback, handler);
        try {
            return this.mService.startGnssBatch(periodNanos, wakeOnFifoFull, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_location_LocationManager$flushGnssBatch() {
        try {
            this.mService.flushGnssBatch(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_location_LocationManager$unregisterGnssBatchedLocationCallback(BatchedLocationCallback callback) {
        this.mBatchedLocationCallbackTransport.remove(callback);
        try {
            return this.mService.stopGnssBatch();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$sendExtraCommand(String provider, String command, Bundle extras) {
        try {
            return this.mService.sendExtraCommand(provider, command, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_location_LocationManager$sendNiResponse(int notifId, int userResponse) {
        try {
            return this.mService.sendNiResponse(notifId, userResponse);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkProvider(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("invalid provider: " + provider);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkCriteria(Criteria criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("invalid criteria: " + criteria);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkListener(LocationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("invalid listener: " + listener);
        }
    }

    private final void $$robo$$android_location_LocationManager$checkPendingIntent(PendingIntent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("invalid pending intent: " + intent);
        }
        if (!intent.isTargetedToPackage()) {
            IllegalArgumentException e = new IllegalArgumentException("pending intent must be targeted to package");
            if (this.mContext.getApplicationInfo().targetSdkVersion > 16) {
                throw e;
            }
            Log.w("LocationManager", e);
        }
    }

    private static final void $$robo$$android_location_LocationManager$checkGeofence(Geofence fence) {
        if (fence == null) {
            throw new IllegalArgumentException("invalid geofence: " + fence);
        }
    }

    public String[] getBackgroundThrottlingWhitelist() {
        return InvokeDynamicSupport.bootstrap("getBackgroundThrottlingWhitelist", $$robo$$android_location_LocationManager$getBackgroundThrottlingWhitelist(), 0, this);
    }

    private void __constructor__(Context context, ILocationManager iLocationManager) {
        this.$$robo$$android_location_LocationManager$__constructor__(context, iLocationManager);
    }

    public LocationManager(Context context, ILocationManager iLocationManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager$__constructor__(android.content.Context android.location.ILocationManager ), 0, this, context, iLocationManager);
    }

    private LocationProvider createProvider(String string2, ProviderProperties providerProperties) {
        return InvokeDynamicSupport.bootstrap("createProvider", $$robo$$android_location_LocationManager$createProvider(java.lang.String com.android.internal.location.ProviderProperties ), 0, this, string2, providerProperties);
    }

    public List<String> getAllProviders() {
        return InvokeDynamicSupport.bootstrap("getAllProviders", $$robo$$android_location_LocationManager$getAllProviders(), 0, this);
    }

    public List<String> getProviders(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getProviders", $$robo$$android_location_LocationManager$getProviders(boolean ), 0, this, bl);
    }

    public LocationProvider getProvider(String string2) {
        return InvokeDynamicSupport.bootstrap("getProvider", $$robo$$android_location_LocationManager$getProvider(java.lang.String ), 0, this, string2);
    }

    public List<String> getProviders(Criteria criteria, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getProviders", $$robo$$android_location_LocationManager$getProviders(android.location.Criteria boolean ), 0, this, criteria, bl);
    }

    public String getBestProvider(Criteria criteria, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBestProvider", $$robo$$android_location_LocationManager$getBestProvider(android.location.Criteria boolean ), 0, this, criteria, bl);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.location.LocationListener ), 0, this, string2, l, f, locationListener);
    }

    public void requestLocationUpdates(String string2, long l, float f, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.location.LocationListener android.os.Looper ), 0, this, string2, l, f, locationListener, looper);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(long float android.location.Criteria android.location.LocationListener android.os.Looper ), 0, this, l, f, criteria, locationListener, looper);
    }

    public void requestLocationUpdates(String string2, long l, float f, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(java.lang.String long float android.app.PendingIntent ), 0, this, string2, l, f, pendingIntent);
    }

    public void requestLocationUpdates(long l, float f, Criteria criteria, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(long float android.location.Criteria android.app.PendingIntent ), 0, this, l, f, criteria, pendingIntent);
    }

    public void requestSingleUpdate(String string2, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(java.lang.String android.location.LocationListener android.os.Looper ), 0, this, string2, locationListener, looper);
    }

    public void requestSingleUpdate(Criteria criteria, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(android.location.Criteria android.location.LocationListener android.os.Looper ), 0, this, criteria, locationListener, looper);
    }

    public void requestSingleUpdate(String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(java.lang.String android.app.PendingIntent ), 0, this, string2, pendingIntent);
    }

    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestSingleUpdate", $$robo$$android_location_LocationManager$requestSingleUpdate(android.location.Criteria android.app.PendingIntent ), 0, this, criteria, pendingIntent);
    }

    @SystemApi
    public void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.location.LocationListener android.os.Looper ), 0, this, locationRequest, locationListener, looper);
    }

    @SystemApi
    public void requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.app.PendingIntent ), 0, this, locationRequest, pendingIntent);
    }

    public boolean injectLocation(Location location) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectLocation", $$robo$$android_location_LocationManager$injectLocation(android.location.Location ), 0, this, location);
    }

    private ListenerTransport wrapListener(LocationListener locationListener, Looper looper) {
        return InvokeDynamicSupport.bootstrap("wrapListener", $$robo$$android_location_LocationManager$wrapListener(android.location.LocationListener android.os.Looper ), 0, this, locationListener, looper);
    }

    private void requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("requestLocationUpdates", $$robo$$android_location_LocationManager$requestLocationUpdates(android.location.LocationRequest android.location.LocationListener android.os.Looper android.app.PendingIntent ), 0, this, locationRequest, locationListener, looper, pendingIntent);
    }

    public void removeUpdates(LocationListener locationListener) {
        InvokeDynamicSupport.bootstrap("removeUpdates", $$robo$$android_location_LocationManager$removeUpdates(android.location.LocationListener ), 0, this, locationListener);
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeUpdates", $$robo$$android_location_LocationManager$removeUpdates(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("addProximityAlert", $$robo$$android_location_LocationManager$addProximityAlert(double double float long android.app.PendingIntent ), 0, this, d, d2, f, l, pendingIntent);
    }

    public void addGeofence(LocationRequest locationRequest, Geofence geofence, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("addGeofence", $$robo$$android_location_LocationManager$addGeofence(android.location.LocationRequest android.location.Geofence android.app.PendingIntent ), 0, this, locationRequest, geofence, pendingIntent);
    }

    public void removeProximityAlert(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeProximityAlert", $$robo$$android_location_LocationManager$removeProximityAlert(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void removeGeofence(Geofence geofence, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeGeofence", $$robo$$android_location_LocationManager$removeGeofence(android.location.Geofence android.app.PendingIntent ), 0, this, geofence, pendingIntent);
    }

    public void removeAllGeofences(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("removeAllGeofences", $$robo$$android_location_LocationManager$removeAllGeofences(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public boolean isLocationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocationEnabled", $$robo$$android_location_LocationManager$isLocationEnabled(), 0, this);
    }

    @SystemApi
    public void setLocationEnabledForUser(boolean bl, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setLocationEnabledForUser", $$robo$$android_location_LocationManager$setLocationEnabledForUser(boolean android.os.UserHandle ), 0, this, bl, userHandle);
    }

    @SystemApi
    public boolean isLocationEnabledForUser(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocationEnabledForUser", $$robo$$android_location_LocationManager$isLocationEnabledForUser(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isProviderEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProviderEnabled", $$robo$$android_location_LocationManager$isProviderEnabled(java.lang.String ), 0, this, string2);
    }

    @SystemApi
    public boolean isProviderEnabledForUser(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isProviderEnabledForUser", $$robo$$android_location_LocationManager$isProviderEnabledForUser(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    @SystemApi
    public boolean setProviderEnabledForUser(String string2, boolean bl, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProviderEnabledForUser", $$robo$$android_location_LocationManager$setProviderEnabledForUser(java.lang.String boolean android.os.UserHandle ), 0, this, string2, bl, userHandle);
    }

    public Location getLastLocation() {
        return InvokeDynamicSupport.bootstrap("getLastLocation", $$robo$$android_location_LocationManager$getLastLocation(), 0, this);
    }

    public Location getLastKnownLocation(String string2) {
        return InvokeDynamicSupport.bootstrap("getLastKnownLocation", $$robo$$android_location_LocationManager$getLastKnownLocation(java.lang.String ), 0, this, string2);
    }

    public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addTestProvider", $$robo$$android_location_LocationManager$addTestProvider(java.lang.String boolean boolean boolean boolean boolean boolean boolean int int ), 0, this, string2, bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2);
    }

    public void removeTestProvider(String string2) {
        InvokeDynamicSupport.bootstrap("removeTestProvider", $$robo$$android_location_LocationManager$removeTestProvider(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderLocation(String string2, Location location) {
        InvokeDynamicSupport.bootstrap("setTestProviderLocation", $$robo$$android_location_LocationManager$setTestProviderLocation(java.lang.String android.location.Location ), 0, this, string2, location);
    }

    public void clearTestProviderLocation(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderLocation", $$robo$$android_location_LocationManager$clearTestProviderLocation(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderEnabled(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTestProviderEnabled", $$robo$$android_location_LocationManager$setTestProviderEnabled(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void clearTestProviderEnabled(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderEnabled", $$robo$$android_location_LocationManager$clearTestProviderEnabled(java.lang.String ), 0, this, string2);
    }

    public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) {
        InvokeDynamicSupport.bootstrap("setTestProviderStatus", $$robo$$android_location_LocationManager$setTestProviderStatus(java.lang.String int android.os.Bundle long ), 0, this, string2, n, bundle, l);
    }

    public void clearTestProviderStatus(String string2) {
        InvokeDynamicSupport.bootstrap("clearTestProviderStatus", $$robo$$android_location_LocationManager$clearTestProviderStatus(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsStatusListener", $$robo$$android_location_LocationManager$addGpsStatusListener(android.location.GpsStatus$Listener ), 0, this, listener);
    }

    @Deprecated
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsStatusListener", $$robo$$android_location_LocationManager$removeGpsStatusListener(android.location.GpsStatus$Listener ), 0, this, listener);
    }

    public boolean registerGnssStatusCallback(GnssStatus.Callback callback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssStatusCallback", $$robo$$android_location_LocationManager$registerGnssStatusCallback(android.location.GnssStatus$Callback ), 0, this, callback);
    }

    public boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssStatusCallback", $$robo$$android_location_LocationManager$registerGnssStatusCallback(android.location.GnssStatus$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterGnssStatusCallback", $$robo$$android_location_LocationManager$unregisterGnssStatusCallback(android.location.GnssStatus$Callback ), 0, this, callback);
    }

    @Deprecated
    public boolean addNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addNmeaListener", $$robo$$android_location_LocationManager$addNmeaListener(android.location.GpsStatus$NmeaListener ), 0, this, nmeaListener);
    }

    @Deprecated
    public void removeNmeaListener(GpsStatus.NmeaListener nmeaListener) {
        InvokeDynamicSupport.bootstrap("removeNmeaListener", $$robo$$android_location_LocationManager$removeNmeaListener(android.location.GpsStatus$NmeaListener ), 0, this, nmeaListener);
    }

    public boolean addNmeaListener(OnNmeaMessageListener onNmeaMessageListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addNmeaListener", $$robo$$android_location_LocationManager$addNmeaListener(android.location.OnNmeaMessageListener ), 0, this, onNmeaMessageListener);
    }

    public boolean addNmeaListener(OnNmeaMessageListener onNmeaMessageListener, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("addNmeaListener", $$robo$$android_location_LocationManager$addNmeaListener(android.location.OnNmeaMessageListener android.os.Handler ), 0, this, onNmeaMessageListener, handler);
    }

    public void removeNmeaListener(OnNmeaMessageListener onNmeaMessageListener) {
        InvokeDynamicSupport.bootstrap("removeNmeaListener", $$robo$$android_location_LocationManager$removeNmeaListener(android.location.OnNmeaMessageListener ), 0, this, onNmeaMessageListener);
    }

    @Deprecated
    @SystemApi
    public boolean addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsMeasurementListener", $$robo$$android_location_LocationManager$addGpsMeasurementListener(android.location.GpsMeasurementsEvent$Listener ), 0, this, listener);
    }

    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssMeasurementsCallback", $$robo$$android_location_LocationManager$registerGnssMeasurementsCallback(android.location.GnssMeasurementsEvent$Callback ), 0, this, callback);
    }

    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssMeasurementsCallback", $$robo$$android_location_LocationManager$registerGnssMeasurementsCallback(android.location.GnssMeasurementsEvent$Callback android.os.Handler ), 0, this, callback, handler);
    }

    @Deprecated
    @SystemApi
    public void removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsMeasurementListener", $$robo$$android_location_LocationManager$removeGpsMeasurementListener(android.location.GpsMeasurementsEvent$Listener ), 0, this, listener);
    }

    public void unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterGnssMeasurementsCallback", $$robo$$android_location_LocationManager$unregisterGnssMeasurementsCallback(android.location.GnssMeasurementsEvent$Callback ), 0, this, callback);
    }

    @Deprecated
    @SystemApi
    public boolean addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addGpsNavigationMessageListener", $$robo$$android_location_LocationManager$addGpsNavigationMessageListener(android.location.GpsNavigationMessageEvent$Listener ), 0, this, listener);
    }

    @Deprecated
    @SystemApi
    public void removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        InvokeDynamicSupport.bootstrap("removeGpsNavigationMessageListener", $$robo$$android_location_LocationManager$removeGpsNavigationMessageListener(android.location.GpsNavigationMessageEvent$Listener ), 0, this, listener);
    }

    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssNavigationMessageCallback", $$robo$$android_location_LocationManager$registerGnssNavigationMessageCallback(android.location.GnssNavigationMessage$Callback ), 0, this, callback);
    }

    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssNavigationMessageCallback", $$robo$$android_location_LocationManager$registerGnssNavigationMessageCallback(android.location.GnssNavigationMessage$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterGnssNavigationMessageCallback", $$robo$$android_location_LocationManager$unregisterGnssNavigationMessageCallback(android.location.GnssNavigationMessage$Callback ), 0, this, callback);
    }

    @Deprecated
    public GpsStatus getGpsStatus(GpsStatus gpsStatus) {
        return InvokeDynamicSupport.bootstrap("getGpsStatus", $$robo$$android_location_LocationManager$getGpsStatus(android.location.GpsStatus ), 0, this, gpsStatus);
    }

    public int getGnssYearOfHardware() {
        return (int)InvokeDynamicSupport.bootstrap("getGnssYearOfHardware", $$robo$$android_location_LocationManager$getGnssYearOfHardware(), 0, this);
    }

    public String getGnssHardwareModelName() {
        return InvokeDynamicSupport.bootstrap("getGnssHardwareModelName", $$robo$$android_location_LocationManager$getGnssHardwareModelName(), 0, this);
    }

    @SystemApi
    public int getGnssBatchSize() {
        return (int)InvokeDynamicSupport.bootstrap("getGnssBatchSize", $$robo$$android_location_LocationManager$getGnssBatchSize(), 0, this);
    }

    @SystemApi
    public boolean registerGnssBatchedLocationCallback(long l, boolean bl, BatchedLocationCallback batchedLocationCallback, Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerGnssBatchedLocationCallback", $$robo$$android_location_LocationManager$registerGnssBatchedLocationCallback(long boolean android.location.BatchedLocationCallback android.os.Handler ), 0, this, l, bl, batchedLocationCallback, handler);
    }

    @SystemApi
    public void flushGnssBatch() {
        InvokeDynamicSupport.bootstrap("flushGnssBatch", $$robo$$android_location_LocationManager$flushGnssBatch(), 0, this);
    }

    @SystemApi
    public boolean unregisterGnssBatchedLocationCallback(BatchedLocationCallback batchedLocationCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterGnssBatchedLocationCallback", $$robo$$android_location_LocationManager$unregisterGnssBatchedLocationCallback(android.location.BatchedLocationCallback ), 0, this, batchedLocationCallback);
    }

    public boolean sendExtraCommand(String string2, String string3, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendExtraCommand", $$robo$$android_location_LocationManager$sendExtraCommand(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    public boolean sendNiResponse(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendNiResponse", $$robo$$android_location_LocationManager$sendNiResponse(int int ), 0, this, n, n2);
    }

    private static void checkProvider(String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkProvider", $$robo$$android_location_LocationManager$checkProvider(java.lang.String ), 0, (String)string2);
    }

    private static void checkCriteria(Criteria criteria) {
        InvokeDynamicSupport.bootstrapStatic("checkCriteria", $$robo$$android_location_LocationManager$checkCriteria(android.location.Criteria ), 0, (Criteria)criteria);
    }

    private static void checkListener(LocationListener locationListener) {
        InvokeDynamicSupport.bootstrapStatic("checkListener", $$robo$$android_location_LocationManager$checkListener(android.location.LocationListener ), 0, (LocationListener)locationListener);
    }

    private void checkPendingIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("checkPendingIntent", $$robo$$android_location_LocationManager$checkPendingIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private static void checkGeofence(Geofence geofence) {
        InvokeDynamicSupport.bootstrapStatic("checkGeofence", $$robo$$android_location_LocationManager$checkGeofence(android.location.Geofence ), 0, (Geofence)geofence);
    }

    public /* synthetic */ LocationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class GnssStatusListenerTransport
    extends IGnssStatusListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private GpsStatus.Listener mGpsListener;
        private GpsStatus.NmeaListener mGpsNmeaListener;
        private GnssStatus.Callback mGnssCallback;
        private OnNmeaMessageListener mGnssNmeaListener;
        private Handler mGnssHandler;
        private static int NMEA_RECEIVED = 1000;
        private ArrayList<Nmea> mNmeaBuffer;
        /* synthetic */ LocationManager this$0;

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.Listener listener) {
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.Listener listener, Handler handler) {
            this.mGpsListener = listener;
            this.mGnssHandler = new GnssHandler(this, handler);
            this.mGpsNmeaListener = null;
            this.mNmeaBuffer = null;
            this.mGnssCallback = this.mGpsListener != null ? new ShadowedObject(this, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ GnssStatusListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$__constructor__(GnssStatusListenerTransport this$1, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onStarted() {
                    this.this$1.mGpsListener.onGpsStatusChanged(1);
                }

                private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onStopped() {
                    this.this$1.mGpsListener.onGpsStatusChanged(2);
                }

                private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onFirstFix(int ttff) {
                    this.this$1.mGpsListener.onGpsStatusChanged(3);
                }

                private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onSatelliteStatusChanged(GnssStatus status) {
                    this.this$1.mGpsListener.onGpsStatusChanged(4);
                }

                private void __constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$__constructor__(gnssStatusListenerTransport, locationManager);
                }
                {
                    this.this$1 = gnssStatusListenerTransport;
                    this.val$this$0 = locationManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$__constructor__(android.location.LocationManager$GnssStatusListenerTransport android.location.LocationManager ), 0, this, gnssStatusListenerTransport, locationManager);
                }

                @Override
                public void onStarted() {
                    InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onStarted(), 0, this);
                }

                @Override
                public void onStopped() {
                    InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onStopped(), 0, this);
                }

                @Override
                public void onFirstFix(int n) {
                    InvokeDynamicSupport.bootstrap("onFirstFix", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onFirstFix(int ), 0, this, n);
                }

                @Override
                public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
                    InvokeDynamicSupport.bootstrap("onSatelliteStatusChanged", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_1$onSatelliteStatusChanged(android.location.GnssStatus ), 0, this, gnssStatus);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
            this.mGnssNmeaListener = null;
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.NmeaListener listener) {
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GpsStatus.NmeaListener listener, Handler handler) {
            this.mGpsListener = null;
            this.mGnssHandler = new GnssHandler(this, handler);
            this.mGpsNmeaListener = listener;
            this.mNmeaBuffer = new ArrayList();
            this.mGnssCallback = null;
            this.mGnssNmeaListener = this.mGpsNmeaListener != null ? new OnNmeaMessageListener(this, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ GnssStatusListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_2$__constructor__(GnssStatusListenerTransport this$1, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_2$onNmeaMessage(String nmea, long timestamp) {
                    this.this$1.mGpsNmeaListener.onNmeaReceived(timestamp, nmea);
                }

                private void __constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport_2$__constructor__(gnssStatusListenerTransport, locationManager);
                }
                {
                    this.this$1 = gnssStatusListenerTransport;
                    this.val$this$0 = locationManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_2$__constructor__(android.location.LocationManager$GnssStatusListenerTransport android.location.LocationManager ), 0, this, gnssStatusListenerTransport, locationManager);
                }

                @Override
                public void onNmeaMessage(String string2, long l) {
                    InvokeDynamicSupport.bootstrap("onNmeaMessage", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_2$onNmeaMessage(java.lang.String long ), 0, this, string2, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GnssStatus.Callback callback) {
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, GnssStatus.Callback callback, Handler handler) {
            this.mGnssCallback = callback;
            this.mGnssHandler = new GnssHandler(this, handler);
            this.mGnssNmeaListener = null;
            this.mNmeaBuffer = null;
            this.mGpsListener = null;
            this.mGpsNmeaListener = null;
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, OnNmeaMessageListener listener) {
        }

        private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(LocationManager locationManager, OnNmeaMessageListener listener, Handler handler) {
            this.mGnssCallback = null;
            this.mGnssHandler = new GnssHandler(this, handler);
            this.mGnssNmeaListener = listener;
            this.mGpsListener = null;
            this.mGpsNmeaListener = null;
            this.mNmeaBuffer = new ArrayList();
        }

        private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onGnssStarted() {
            if (this.mGnssCallback != null) {
                Message msg = Message.obtain();
                msg.what = 1;
                this.mGnssHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onGnssStopped() {
            if (this.mGnssCallback != null) {
                Message msg = Message.obtain();
                msg.what = 2;
                this.mGnssHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onFirstFix(int ttff) {
            if (this.mGnssCallback != null) {
                this.this$0.mTimeToFirstFix = ttff;
                Message msg = Message.obtain();
                msg.what = 3;
                this.mGnssHandler.sendMessage(msg);
            }
        }

        private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onSvStatusChanged(int svCount, int[] prnWithFlags, float[] cn0s, float[] elevations, float[] azimuths, float[] carrierFreqs) {
            if (this.mGnssCallback != null) {
                this.this$0.mGnssStatus = new GnssStatus(svCount, prnWithFlags, cn0s, elevations, azimuths, carrierFreqs);
                Message msg = Message.obtain();
                msg.what = 4;
                this.mGnssHandler.removeMessages(4);
                this.mGnssHandler.sendMessage(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onNmeaReceived(long timestamp, String nmea) {
            if (this.mGnssNmeaListener != null) {
                ArrayList<Nmea> arrayList = this.mNmeaBuffer;
                synchronized (arrayList) {
                    this.mNmeaBuffer.add(new Nmea(this, timestamp, nmea));
                }
                Message msg = Message.obtain();
                msg.what = 1000;
                this.mGnssHandler.removeMessages(1000);
                this.mGnssHandler.sendMessage(msg);
            }
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.Listener listener) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, listener);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GpsStatus.Listener listener) {
            this(locationManager, listener, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$Listener ), 0, this, locationManager, listener);
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.Listener listener, Handler handler) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, listener, handler);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GpsStatus.Listener listener, Handler handler) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$Listener android.os.Handler ), 0, this, locationManager, listener, handler);
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, nmeaListener);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener) {
            this(locationManager, nmeaListener, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$NmeaListener ), 0, this, locationManager, nmeaListener);
        }

        private void __constructor__(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener, Handler handler) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, nmeaListener, handler);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GpsStatus.NmeaListener nmeaListener, Handler handler) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GpsStatus$NmeaListener android.os.Handler ), 0, this, locationManager, nmeaListener, handler);
        }

        private void __constructor__(LocationManager locationManager, GnssStatus.Callback callback) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, callback);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GnssStatus.Callback callback) {
            this(locationManager, callback, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GnssStatus$Callback ), 0, this, locationManager, callback);
        }

        private void __constructor__(LocationManager locationManager, GnssStatus.Callback callback, Handler handler) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, callback, handler);
        }

        GnssStatusListenerTransport(LocationManager locationManager, GnssStatus.Callback callback, Handler handler) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.GnssStatus$Callback android.os.Handler ), 0, this, locationManager, callback, handler);
        }

        private void __constructor__(LocationManager locationManager, OnNmeaMessageListener onNmeaMessageListener) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, onNmeaMessageListener);
        }

        GnssStatusListenerTransport(LocationManager locationManager, OnNmeaMessageListener onNmeaMessageListener) {
            this(locationManager, onNmeaMessageListener, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.OnNmeaMessageListener ), 0, this, locationManager, onNmeaMessageListener);
        }

        private void __constructor__(LocationManager locationManager, OnNmeaMessageListener onNmeaMessageListener, Handler handler) {
            this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(locationManager, onNmeaMessageListener, handler);
        }

        GnssStatusListenerTransport(LocationManager locationManager, OnNmeaMessageListener onNmeaMessageListener, Handler handler) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$__constructor__(android.location.LocationManager android.location.OnNmeaMessageListener android.os.Handler ), 0, this, locationManager, onNmeaMessageListener, handler);
        }

        @Override
        public void onGnssStarted() {
            InvokeDynamicSupport.bootstrap("onGnssStarted", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onGnssStarted(), 0, this);
        }

        @Override
        public void onGnssStopped() {
            InvokeDynamicSupport.bootstrap("onGnssStopped", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onGnssStopped(), 0, this);
        }

        @Override
        public void onFirstFix(int n) {
            InvokeDynamicSupport.bootstrap("onFirstFix", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onFirstFix(int ), 0, this, n);
        }

        @Override
        public void onSvStatusChanged(int n, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
            InvokeDynamicSupport.bootstrap("onSvStatusChanged", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onSvStatusChanged(int int[] float[] float[] float[] float[] ), 0, this, n, nArray, fArray, fArray2, fArray3, fArray4);
        }

        @Override
        public void onNmeaReceived(long l, String string2) {
            InvokeDynamicSupport.bootstrap("onNmeaReceived", $$robo$$android_location_LocationManager_GnssStatusListenerTransport$onNmeaReceived(long java.lang.String ), 0, this, l, string2);
        }

        public /* synthetic */ GnssStatusListenerTransport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GnssStatusListenerTransport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class Nmea
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            long mTimestamp;
            String mNmea;
            /* synthetic */ GnssStatusListenerTransport this$1;

            private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_Nmea$__constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, long timestamp, String nmea) {
                this.mTimestamp = timestamp;
                this.mNmea = nmea;
            }

            private void __constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, long l, String string2) {
                this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport_Nmea$__constructor__(gnssStatusListenerTransport, l, string2);
            }

            Nmea(GnssStatusListenerTransport gnssStatusListenerTransport, long l, String string2) {
                this.this$1 = gnssStatusListenerTransport;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_Nmea$__constructor__(android.location.LocationManager$GnssStatusListenerTransport long java.lang.String ), 0, this, gnssStatusListenerTransport, l, string2);
            }

            public /* synthetic */ Nmea() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Nmea)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class GnssHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GnssStatusListenerTransport this$1;

            private void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_GnssHandler$__constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, Handler handler) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_location_LocationManager_GnssStatusListenerTransport_GnssHandler$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1000: {
                        ArrayList arrayList = this.this$1.mNmeaBuffer;
                        synchronized (arrayList) {
                            int length = this.this$1.mNmeaBuffer.size();
                            for (int i = 0; i < length; ++i) {
                                Nmea nmea = (Nmea)this.this$1.mNmeaBuffer.get(i);
                                this.this$1.mGnssNmeaListener.onNmeaMessage(nmea.mNmea, nmea.mTimestamp);
                            }
                            this.this$1.mNmeaBuffer.clear();
                            break;
                        }
                    }
                    case 1: {
                        this.this$1.mGnssCallback.onStarted();
                        break;
                    }
                    case 2: {
                        this.this$1.mGnssCallback.onStopped();
                        break;
                    }
                    case 3: {
                        this.this$1.mGnssCallback.onFirstFix(this.this$1.this$0.mTimeToFirstFix);
                        break;
                    }
                    case 4: {
                        this.this$1.mGnssCallback.onSatelliteStatusChanged(this.this$1.this$0.mGnssStatus);
                        break;
                    }
                }
            }

            private void __constructor__(GnssStatusListenerTransport gnssStatusListenerTransport, Handler handler) {
                this.$$robo$$android_location_LocationManager_GnssStatusListenerTransport_GnssHandler$__constructor__(gnssStatusListenerTransport, handler);
            }

            public GnssHandler(GnssStatusListenerTransport gnssStatusListenerTransport, Handler handler) {
                this.this$1 = gnssStatusListenerTransport;
                super(handler != null ? handler.getLooper() : Looper.myLooper());
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_GnssHandler$__constructor__(android.location.LocationManager$GnssStatusListenerTransport android.os.Handler ), 0, this, gnssStatusListenerTransport, handler);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_GnssStatusListenerTransport_GnssHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ GnssHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GnssHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class ListenerTransport
    extends ILocationListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int TYPE_LOCATION_CHANGED = 1;
        private static int TYPE_STATUS_CHANGED = 2;
        private static int TYPE_PROVIDER_ENABLED = 3;
        private static int TYPE_PROVIDER_DISABLED = 4;
        private LocationListener mListener;
        private Handler mListenerHandler;
        /* synthetic */ LocationManager this$0;

        private void $$robo$$android_location_LocationManager_ListenerTransport$__constructor__(LocationManager locationManager, LocationListener listener, Looper looper) {
            this.mListener = listener;
            this.mListenerHandler = looper == null ? new ShadowedObject(this, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ ListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(ListenerTransport this$1, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_ListenerTransport_1$handleMessage(Message msg) {
                    this.this$1._handleMessage(msg);
                }

                private void __constructor__(ListenerTransport listenerTransport, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(listenerTransport, locationManager);
                }
                {
                    this.this$1 = listenerTransport;
                    this.val$this$0 = locationManager;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport_1$__constructor__(android.location.LocationManager$ListenerTransport android.location.LocationManager ), 0, this, listenerTransport, locationManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_ListenerTransport_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : new ShadowedObject(this, looper, locationManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocationManager val$this$0;
                /* synthetic */ ListenerTransport this$1;

                private void $$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(ListenerTransport this$1, Looper x0, LocationManager locationManager) {
                }

                private final void $$robo$$android_location_LocationManager_ListenerTransport_2$handleMessage(Message msg) {
                    this.this$1._handleMessage(msg);
                }

                private void __constructor__(ListenerTransport listenerTransport, Looper looper, LocationManager locationManager) {
                    this.$$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(listenerTransport, looper, locationManager);
                }
                {
                    this.this$1 = listenerTransport;
                    this.val$this$0 = locationManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport_2$__constructor__(android.location.LocationManager$ListenerTransport android.os.Looper android.location.LocationManager ), 0, this, listenerTransport, looper, locationManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_location_LocationManager_ListenerTransport_2$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onLocationChanged(Location location) {
            Message msg = Message.obtain();
            msg.what = 1;
            msg.obj = location;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onStatusChanged(String provider, int status, Bundle extras) {
            Message msg = Message.obtain();
            msg.what = 2;
            Bundle b = new Bundle();
            b.putString("provider", provider);
            b.putInt("status", status);
            if (extras != null) {
                b.putBundle("extras", extras);
            }
            msg.obj = b;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onProviderEnabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 3;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$onProviderDisabled(String provider) {
            Message msg = Message.obtain();
            msg.what = 4;
            msg.obj = provider;
            this.mListenerHandler.sendMessage(msg);
        }

        private final void $$robo$$android_location_LocationManager_ListenerTransport$_handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.mListener.onLocationChanged(location);
                    break;
                }
                case 2: {
                    Bundle b = (Bundle)msg.obj;
                    String provider = b.getString("provider");
                    int status = b.getInt("status");
                    Bundle extras = b.getBundle("extras");
                    this.mListener.onStatusChanged(provider, status, extras);
                    break;
                }
                case 3: {
                    this.mListener.onProviderEnabled((String)msg.obj);
                    break;
                }
                case 4: {
                    this.mListener.onProviderDisabled((String)msg.obj);
                }
            }
            try {
                this.this$0.mService.locationCallbackFinished(this);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void __constructor__(LocationManager locationManager, LocationListener locationListener, Looper looper) {
            this.$$robo$$android_location_LocationManager_ListenerTransport$__constructor__(locationManager, locationListener, looper);
        }

        ListenerTransport(LocationManager locationManager, LocationListener locationListener, Looper looper) {
            this.this$0 = locationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_location_LocationManager_ListenerTransport$__constructor__(android.location.LocationManager android.location.LocationListener android.os.Looper ), 0, this, locationManager, locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            InvokeDynamicSupport.bootstrap("onLocationChanged", $$robo$$android_location_LocationManager_ListenerTransport$onLocationChanged(android.location.Location ), 0, this, location);
        }

        @Override
        public void onStatusChanged(String string2, int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onStatusChanged", $$robo$$android_location_LocationManager_ListenerTransport$onStatusChanged(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
        }

        @Override
        public void onProviderEnabled(String string2) {
            InvokeDynamicSupport.bootstrap("onProviderEnabled", $$robo$$android_location_LocationManager_ListenerTransport$onProviderEnabled(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onProviderDisabled(String string2) {
            InvokeDynamicSupport.bootstrap("onProviderDisabled", $$robo$$android_location_LocationManager_ListenerTransport$onProviderDisabled(java.lang.String ), 0, this, string2);
        }

        private void _handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("_handleMessage", $$robo$$android_location_LocationManager_ListenerTransport$_handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ListenerTransport() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerTransport)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

