/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AmrInputStream
extends InputStream
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AmrInputStream";
    private static int SAMPLES_PER_FRAME = 160;
    MediaCodec mCodec;
    MediaCodec.BufferInfo mInfo;
    boolean mSawOutputEOS;
    boolean mSawInputEOS;
    private InputStream mInputStream;
    private byte[] mBuf;
    private int mBufIn;
    private int mBufOut;
    private byte[] mOneByte;

    private void $$robo$$android_media_AmrInputStream$__constructor__(InputStream inputStream) {
        this.mBuf = new byte[320];
        this.mBufIn = 0;
        this.mBufOut = 0;
        this.mOneByte = new byte[1];
        Log.w("AmrInputStream", "@@@@ AmrInputStream is not a public API @@@@");
        this.mInputStream = inputStream;
        MediaFormat format = new MediaFormat();
        format.setString("mime", "audio/3gpp");
        format.setInteger("sample-rate", 8000);
        format.setInteger("channel-count", 1);
        format.setInteger("bitrate", 12200);
        MediaCodecList mcl = new MediaCodecList(0);
        String name = mcl.findEncoderForFormat(format);
        if (name != null) {
            try {
                this.mCodec = MediaCodec.createByCodecName(name);
                this.mCodec.configure(format, null, null, 1);
                this.mCodec.start();
            }
            catch (IOException e) {
                if (this.mCodec != null) {
                    this.mCodec.release();
                }
                this.mCodec = null;
            }
        }
        this.mInfo = new MediaCodec.BufferInfo();
    }

    private final int $$robo$$android_media_AmrInputStream$read() throws IOException {
        int rtn = this.read(this.mOneByte, 0, 1);
        return rtn == 1 ? 0xFF & this.mOneByte[0] : -1;
    }

    private final int $$robo$$android_media_AmrInputStream$read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private final int $$robo$$android_media_AmrInputStream$read(byte[] b, int offset, int length) throws IOException {
        if (this.mCodec == null) {
            throw new IllegalStateException("not open");
        }
        if (this.mBufOut >= this.mBufIn && !this.mSawOutputEOS) {
            int index;
            this.mBufOut = 0;
            this.mBufIn = 0;
            while (!this.mSawInputEOS && (index = this.mCodec.dequeueInputBuffer(0L)) >= 0) {
                int numRead;
                int n;
                for (numRead = 0; numRead < 320; numRead += n) {
                    n = this.mInputStream.read(this.mBuf, numRead, 320 - numRead);
                    if (n != -1) continue;
                    this.mSawInputEOS = true;
                    break;
                }
                ByteBuffer buf = this.mCodec.getInputBuffer(index);
                buf.put(this.mBuf, 0, numRead);
                this.mCodec.queueInputBuffer(index, 0, numRead, 0L, this.mSawInputEOS ? 4 : 0);
            }
            index = this.mCodec.dequeueOutputBuffer(this.mInfo, 0L);
            if (index >= 0) {
                this.mBufIn = this.mInfo.size;
                ByteBuffer out = this.mCodec.getOutputBuffer(index);
                out.get(this.mBuf, 0, this.mBufIn);
                this.mCodec.releaseOutputBuffer(index, false);
                if ((this.mInfo.flags & 4) != 0) {
                    this.mSawOutputEOS = true;
                }
            }
        }
        if (this.mBufOut < this.mBufIn) {
            if (length > this.mBufIn - this.mBufOut) {
                length = this.mBufIn - this.mBufOut;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mBuf, (int)this.mBufOut, (byte[])b, (int)offset, (int)length);
            this.mBufOut += length;
            return length;
        }
        if (this.mSawInputEOS && this.mSawOutputEOS) {
            return -1;
        }
        return 0;
    }

    private final void $$robo$$android_media_AmrInputStream$close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        finally {
            this.mInputStream = null;
            try {
                if (this.mCodec != null) {
                    this.mCodec.release();
                }
            }
            finally {
                this.mCodec = null;
            }
        }
    }

    private final void $$robo$$android_media_AmrInputStream$finalize() throws Throwable {
        if (this.mCodec != null) {
            Log.w("AmrInputStream", "AmrInputStream wasn't closed");
            this.mCodec.release();
        }
    }

    private void __constructor__(InputStream inputStream) {
        this.$$robo$$android_media_AmrInputStream$__constructor__(inputStream);
    }

    public AmrInputStream(InputStream inputStream) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AmrInputStream$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    @Override
    public int read() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AmrInputStream$read(), 0, this);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AmrInputStream$read(byte[] ), 0, this, byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AmrInputStream$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_AmrInputStream$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_AmrInputStream$finalize(), 0, this);
    }

    public /* synthetic */ AmrInputStream() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AmrInputStream)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

