/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioDevicePort;
import android.media.AudioFocusInfo;
import android.media.AudioFocusRequest;
import android.media.AudioFormat;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioPatch;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.AudioPortEventHandler;
import android.media.AudioRecordingConfiguration;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioServerStateDispatcher;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.media.IRecordingConfigDispatcher;
import android.media.IRingtonePlayer;
import android.media.IVolumeController;
import android.media.MicrophoneInfo;
import android.media.PlayerBase;
import android.media.RemoteControlClient;
import android.media.RemoteController;
import android.media.VolumePolicy;
import android.media.audiopolicy.AudioPolicy;
import android.media.session.MediaSessionLegacyHelper;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mOriginalContext;
    private Context mApplicationContext;
    private long mVolumeKeyUpTime;
    private boolean mUseVolumeKeySounds;
    private boolean mUseFixedVolume;
    private static String TAG = "AudioManager";
    private static boolean DEBUG = false;
    private static AudioPortEventHandler sAudioPortEventHandler;
    public static String ACTION_AUDIO_BECOMING_NOISY = "android.media.AUDIO_BECOMING_NOISY";
    public static String RINGER_MODE_CHANGED_ACTION = "android.media.RINGER_MODE_CHANGED";
    public static String INTERNAL_RINGER_MODE_CHANGED_ACTION = "android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION";
    public static String EXTRA_RINGER_MODE = "android.media.EXTRA_RINGER_MODE";
    public static String VIBRATE_SETTING_CHANGED_ACTION = "android.media.VIBRATE_SETTING_CHANGED";
    public static String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static String STREAM_DEVICES_CHANGED_ACTION = "android.media.STREAM_DEVICES_CHANGED_ACTION";
    public static String STREAM_MUTE_CHANGED_ACTION = "android.media.STREAM_MUTE_CHANGED_ACTION";
    public static String MASTER_MUTE_CHANGED_ACTION = "android.media.MASTER_MUTE_CHANGED_ACTION";
    public static String EXTRA_VIBRATE_SETTING = "android.media.EXTRA_VIBRATE_SETTING";
    public static String EXTRA_VIBRATE_TYPE = "android.media.EXTRA_VIBRATE_TYPE";
    public static String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public static String EXTRA_VOLUME_STREAM_TYPE_ALIAS = "android.media.EXTRA_VOLUME_STREAM_TYPE_ALIAS";
    public static String EXTRA_VOLUME_STREAM_VALUE = "android.media.EXTRA_VOLUME_STREAM_VALUE";
    public static String EXTRA_PREV_VOLUME_STREAM_VALUE = "android.media.EXTRA_PREV_VOLUME_STREAM_VALUE";
    public static String EXTRA_VOLUME_STREAM_DEVICES = "android.media.EXTRA_VOLUME_STREAM_DEVICES";
    public static String EXTRA_PREV_VOLUME_STREAM_DEVICES = "android.media.EXTRA_PREV_VOLUME_STREAM_DEVICES";
    public static String EXTRA_MASTER_VOLUME_MUTED = "android.media.EXTRA_MASTER_VOLUME_MUTED";
    public static String EXTRA_STREAM_VOLUME_MUTED = "android.media.EXTRA_STREAM_VOLUME_MUTED";
    public static String ACTION_HEADSET_PLUG = "android.intent.action.HEADSET_PLUG";
    public static String ACTION_HDMI_AUDIO_PLUG = "android.media.action.HDMI_AUDIO_PLUG";
    public static String EXTRA_AUDIO_PLUG_STATE = "android.media.extra.AUDIO_PLUG_STATE";
    public static String EXTRA_MAX_CHANNEL_COUNT = "android.media.extra.MAX_CHANNEL_COUNT";
    public static String EXTRA_ENCODINGS = "android.media.extra.ENCODINGS";
    public static int STREAM_VOICE_CALL = 0;
    public static int STREAM_SYSTEM = 1;
    public static int STREAM_RING = 2;
    public static int STREAM_MUSIC = 3;
    public static int STREAM_ALARM = 4;
    public static int STREAM_NOTIFICATION = 5;
    public static int STREAM_BLUETOOTH_SCO = 6;
    public static int STREAM_SYSTEM_ENFORCED = 7;
    public static int STREAM_DTMF = 8;
    public static int STREAM_TTS = 9;
    public static int STREAM_ACCESSIBILITY = 10;
    @Deprecated
    public static int NUM_STREAMS = 5;
    public static int ADJUST_RAISE = 1;
    public static int ADJUST_LOWER = -1;
    public static int ADJUST_SAME = 0;
    public static int ADJUST_MUTE = -100;
    public static int ADJUST_UNMUTE = 100;
    public static int ADJUST_TOGGLE_MUTE = 101;
    public static int FLAG_SHOW_UI = 1;
    public static int FLAG_ALLOW_RINGER_MODES = 2;
    public static int FLAG_PLAY_SOUND = 4;
    public static int FLAG_REMOVE_SOUND_AND_VIBRATE = 8;
    public static int FLAG_VIBRATE = 16;
    public static int FLAG_FIXED_VOLUME = 32;
    public static int FLAG_BLUETOOTH_ABS_VOLUME = 64;
    public static int FLAG_SHOW_SILENT_HINT = 128;
    public static int FLAG_HDMI_SYSTEM_AUDIO_VOLUME = 256;
    public static int FLAG_ACTIVE_MEDIA_ONLY = 512;
    public static int FLAG_SHOW_UI_WARNINGS = 1024;
    public static int FLAG_SHOW_VIBRATE_HINT = 2048;
    public static int FLAG_FROM_KEY = 4096;
    private static String[] FLAG_NAMES;
    public static int RINGER_MODE_SILENT = 0;
    public static int RINGER_MODE_VIBRATE = 1;
    public static int RINGER_MODE_NORMAL = 2;
    public static int RINGER_MODE_MAX = 2;
    public static int VIBRATE_TYPE_RINGER = 0;
    public static int VIBRATE_TYPE_NOTIFICATION = 1;
    public static int VIBRATE_SETTING_OFF = 0;
    public static int VIBRATE_SETTING_ON = 1;
    public static int VIBRATE_SETTING_ONLY_SILENT = 2;
    public static int USE_DEFAULT_STREAM_TYPE = Integer.MIN_VALUE;
    private static IAudioService sService;
    private static float VOLUME_MIN_DB = -758.0f;
    @Deprecated
    public static String ACTION_SCO_AUDIO_STATE_CHANGED = "android.media.SCO_AUDIO_STATE_CHANGED";
    public static String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    public static String EXTRA_SCO_AUDIO_STATE = "android.media.extra.SCO_AUDIO_STATE";
    public static String EXTRA_SCO_AUDIO_PREVIOUS_STATE = "android.media.extra.SCO_AUDIO_PREVIOUS_STATE";
    public static int SCO_AUDIO_STATE_DISCONNECTED = 0;
    public static int SCO_AUDIO_STATE_CONNECTED = 1;
    public static int SCO_AUDIO_STATE_CONNECTING = 2;
    public static int SCO_AUDIO_STATE_ERROR = -1;
    public static String ACTION_MICROPHONE_MUTE_CHANGED = "android.media.action.MICROPHONE_MUTE_CHANGED";
    public static int MODE_INVALID = -2;
    public static int MODE_CURRENT = -1;
    public static int MODE_NORMAL = 0;
    public static int MODE_RINGTONE = 1;
    public static int MODE_IN_CALL = 2;
    public static int MODE_IN_COMMUNICATION = 3;
    @Deprecated
    public static int ROUTE_EARPIECE = 1;
    @Deprecated
    public static int ROUTE_SPEAKER = 2;
    @Deprecated
    public static int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static int ROUTE_HEADSET = 8;
    @Deprecated
    public static int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static int ROUTE_ALL = -1;
    public static int AUDIO_SESSION_ID_GENERATE = 0;
    public static int FX_KEY_CLICK = 0;
    public static int FX_FOCUS_NAVIGATION_UP = 1;
    public static int FX_FOCUS_NAVIGATION_DOWN = 2;
    public static int FX_FOCUS_NAVIGATION_LEFT = 3;
    public static int FX_FOCUS_NAVIGATION_RIGHT = 4;
    public static int FX_KEYPRESS_STANDARD = 5;
    public static int FX_KEYPRESS_SPACEBAR = 6;
    public static int FX_KEYPRESS_DELETE = 7;
    public static int FX_KEYPRESS_RETURN = 8;
    public static int FX_KEYPRESS_INVALID = 9;
    public static int NUM_SOUND_EFFECTS = 10;
    public static int AUDIOFOCUS_NONE = 0;
    public static int AUDIOFOCUS_GAIN = 1;
    public static int AUDIOFOCUS_GAIN_TRANSIENT = 2;
    public static int AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK = 3;
    public static int AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE = 4;
    public static int AUDIOFOCUS_LOSS = -1;
    public static int AUDIOFOCUS_LOSS_TRANSIENT = -2;
    public static int AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK = -3;
    private ConcurrentHashMap<String, FocusRequestInfo> mAudioFocusIdListenerMap;
    private ServiceEventHandlerDelegate mServiceEventHandlerDelegate;
    private static int MSSG_FOCUS_CHANGE = 0;
    private static int MSSG_RECORDING_CONFIG_CHANGE = 1;
    private static int MSSG_PLAYBACK_CONFIG_CHANGE = 2;
    private IAudioFocusDispatcher mAudioFocusDispatcher;
    public static int AUDIOFOCUS_REQUEST_FAILED = 0;
    public static int AUDIOFOCUS_REQUEST_GRANTED = 1;
    public static int AUDIOFOCUS_REQUEST_DELAYED = 2;
    public static int AUDIOFOCUS_REQUEST_WAITING_FOR_EXT_POLICY = 100;
    private static int EXT_FOCUS_POLICY_TIMEOUT_MS = 200;
    private static String FOCUS_CLIENT_ID_STRING = "android_audio_focus_client_id";
    private Object mFocusRequestsLock;
    @GuardedBy(value="mFocusRequestsLock")
    private HashMap<String, BlockingFocusResultReceiver> mFocusRequestsAwaitingResult;
    @SystemApi
    public static int AUDIOFOCUS_FLAG_DELAY_OK = 1;
    @SystemApi
    public static int AUDIOFOCUS_FLAG_PAUSES_ON_DUCKABLE_LOSS = 2;
    @SystemApi
    public static int AUDIOFOCUS_FLAG_LOCK = 4;
    public static int AUDIOFOCUS_FLAGS_APPS = 3;
    public static int AUDIOFOCUS_FLAGS_SYSTEM = 7;
    private List<AudioPlaybackCallbackInfo> mPlaybackCallbackList;
    private Object mPlaybackCallbackLock;
    private IPlaybackConfigDispatcher mPlayCb;
    public static int RECORD_CONFIG_EVENT_START = 1;
    public static int RECORD_CONFIG_EVENT_STOP = 0;
    private List<AudioRecordingCallbackInfo> mRecordCallbackList;
    private Object mRecordCallbackLock;
    private IRecordingConfigDispatcher mRecCb;
    private IBinder mICallBack;
    public static int DEVICE_NONE = 0;
    public static int DEVICE_OUT_EARPIECE = 1;
    public static int DEVICE_OUT_SPEAKER = 2;
    public static int DEVICE_OUT_WIRED_HEADSET = 4;
    public static int DEVICE_OUT_WIRED_HEADPHONE = 8;
    public static int DEVICE_OUT_USB_HEADSET = 0x4000000;
    public static int DEVICE_OUT_BLUETOOTH_SCO = 16;
    public static int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    public static int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    public static int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    public static int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    public static int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static int DEVICE_OUT_HDMI = 1024;
    public static int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    public static int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    public static int DEVICE_OUT_USB_ACCESSORY = 8192;
    public static int DEVICE_OUT_USB_DEVICE = 16384;
    public static int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    public static int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static int DEVICE_OUT_LINE = 131072;
    public static int DEVICE_OUT_HDMI_ARC = 262144;
    public static int DEVICE_OUT_SPDIF = 524288;
    public static int DEVICE_OUT_FM = 0x100000;
    public static int DEVICE_OUT_DEFAULT = 0x40000000;
    public static int DEVICE_IN_BUILTIN_MIC = -2147483644;
    public static int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    public static int DEVICE_IN_WIRED_HEADSET = -2147483632;
    public static int DEVICE_IN_HDMI = -2147483616;
    public static int DEVICE_IN_TELEPHONY_RX = -2147483584;
    public static int DEVICE_IN_BACK_MIC = -2147483520;
    public static int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    public static int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    public static int DEVICE_IN_USB_ACCESSORY = -2147481600;
    public static int DEVICE_IN_USB_DEVICE = -2147479552;
    public static int DEVICE_IN_FM_TUNER = -2147475456;
    public static int DEVICE_IN_TV_TUNER = -2147467264;
    public static int DEVICE_IN_LINE = -2147450880;
    public static int DEVICE_IN_SPDIF = -2147418112;
    public static int DEVICE_IN_LOOPBACK = -2147221504;
    public static String PROPERTY_OUTPUT_SAMPLE_RATE = "android.media.property.OUTPUT_SAMPLE_RATE";
    public static String PROPERTY_OUTPUT_FRAMES_PER_BUFFER = "android.media.property.OUTPUT_FRAMES_PER_BUFFER";
    public static String PROPERTY_SUPPORT_MIC_NEAR_ULTRASOUND = "android.media.property.SUPPORT_MIC_NEAR_ULTRASOUND";
    public static String PROPERTY_SUPPORT_SPEAKER_NEAR_ULTRASOUND = "android.media.property.SUPPORT_SPEAKER_NEAR_ULTRASOUND";
    public static String PROPERTY_SUPPORT_AUDIO_SOURCE_UNPROCESSED = "android.media.property.SUPPORT_AUDIO_SOURCE_UNPROCESSED";
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    public static int ERROR_PERMISSION_DENIED = -4;
    public static int ERROR_NO_INIT = -5;
    public static int ERROR_DEAD_OBJECT = -6;
    static int AUDIOPORT_GENERATION_INIT = 0;
    static Integer sAudioPortGeneration;
    static ArrayList<AudioPort> sAudioPortsCached;
    static ArrayList<AudioPort> sPreviousAudioPortsCached;
    static ArrayList<AudioPatch> sAudioPatchesCached;
    private OnAmPortUpdateListener mPortListener;
    private static int MSG_DEVICES_CALLBACK_REGISTERED = 0;
    private static int MSG_DEVICES_DEVICES_ADDED = 1;
    private static int MSG_DEVICES_DEVICES_REMOVED = 2;
    private ArrayMap<AudioDeviceCallback, NativeEventHandlerDelegate> mDeviceCallbacks;
    public static int GET_DEVICES_INPUTS = 1;
    public static int GET_DEVICES_OUTPUTS = 2;
    public static int GET_DEVICES_ALL = 3;
    private ArrayList<AudioDevicePort> mPreviousPorts;
    private Executor mAudioServerStateExec;
    private AudioServerStateCallback mAudioServerStateCb;
    private Object mAudioServerStateCbLock;
    private IAudioServerStateDispatcher mAudioServerStateDispatcher;

    private static final String $$robo$$android_media_AudioManager$adjustToString(int adj) {
        switch (adj) {
            case 1: {
                return "ADJUST_RAISE";
            }
            case -1: {
                return "ADJUST_LOWER";
            }
            case 0: {
                return "ADJUST_SAME";
            }
            case -100: {
                return "ADJUST_MUTE";
            }
            case 100: {
                return "ADJUST_UNMUTE";
            }
            case 101: {
                return "ADJUST_TOGGLE_MUTE";
            }
        }
        return "unknown adjust mode " + adj;
    }

    private static final String $$robo$$android_media_AudioManager$flagsToString(int flags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < FLAG_NAMES.length; ++i) {
            int flag = 1 << i;
            if ((flags & flag) == 0) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(FLAG_NAMES[i]);
            flags &= ~flag;
        }
        if (flags != 0) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(flags);
        }
        return sb.toString();
    }

    private void $$robo$$android_media_AudioManager$__constructor__() {
        this.mAudioFocusIdListenerMap = new ConcurrentHashMap();
        this.mServiceEventHandlerDelegate = new ServiceEventHandlerDelegate(this, null);
        this.mAudioFocusDispatcher = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioManager this$0;

            private void $$robo$$android_media_AudioManager_1$__constructor__(AudioManager this$0) {
            }

            private final void $$robo$$android_media_AudioManager_1$dispatchAudioFocusChange(int focusChange, String id2) {
                OnAudioFocusChangeListener listener;
                FocusRequestInfo fri = this.this$0.findFocusRequestInfo(id2);
                if (fri != null && (listener = fri.mRequest.getOnAudioFocusChangeListener()) != null) {
                    Handler h = fri.mHandler == null ? this.this$0.mServiceEventHandlerDelegate.getHandler() : fri.mHandler;
                    Message m = h.obtainMessage(0, focusChange, 0, id2);
                    h.sendMessage(m);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioManager_1$dispatchFocusResultFromExtPolicy(int requestResult, String clientId) {
                Object object = this.this$0.mFocusRequestsLock;
                synchronized (object) {
                    BlockingFocusResultReceiver focusReceiver = (BlockingFocusResultReceiver)this.this$0.mFocusRequestsAwaitingResult.remove(clientId);
                    if (focusReceiver != null) {
                        focusReceiver.notifyResult(requestResult);
                    } else {
                        Log.e("AudioManager", "dispatchFocusResultFromExtPolicy found no result receiver");
                    }
                }
            }

            private void __constructor__(AudioManager audioManager) {
                this.$$robo$$android_media_AudioManager_1$__constructor__(audioManager);
            }
            {
                this.this$0 = audioManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_1$__constructor__(android.media.AudioManager ), 0, this, audioManager);
            }

            @Override
            public void dispatchAudioFocusChange(int n, String string2) {
                InvokeDynamicSupport.bootstrap("dispatchAudioFocusChange", $$robo$$android_media_AudioManager_1$dispatchAudioFocusChange(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public void dispatchFocusResultFromExtPolicy(int n, String string2) {
                InvokeDynamicSupport.bootstrap("dispatchFocusResultFromExtPolicy", $$robo$$android_media_AudioManager_1$dispatchFocusResultFromExtPolicy(int java.lang.String ), 0, this, n, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFocusRequestsLock = new Object();
        this.mPlaybackCallbackLock = new Object();
        this.mPlayCb = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioManager this$0;

            private void $$robo$$android_media_AudioManager_2$__constructor__(AudioManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioManager_2$dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) {
                if (flush) {
                    Binder.flushPendingCommands();
                }
                Object object = this.this$0.mPlaybackCallbackLock;
                synchronized (object) {
                    if (this.this$0.mPlaybackCallbackList != null) {
                        for (int i = 0; i < this.this$0.mPlaybackCallbackList.size(); ++i) {
                            AudioPlaybackCallbackInfo arci = (AudioPlaybackCallbackInfo)this.this$0.mPlaybackCallbackList.get(i);
                            if (arci.mHandler == null) continue;
                            Message m = arci.mHandler.obtainMessage(2, new PlaybackConfigChangeCallbackData(arci.mCb, configs));
                            arci.mHandler.sendMessage(m);
                        }
                    }
                }
            }

            private void __constructor__(AudioManager audioManager) {
                this.$$robo$$android_media_AudioManager_2$__constructor__(audioManager);
            }
            {
                this.this$0 = audioManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_2$__constructor__(android.media.AudioManager ), 0, this, audioManager);
            }

            @Override
            public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> list, boolean bl) {
                InvokeDynamicSupport.bootstrap("dispatchPlaybackConfigChange", $$robo$$android_media_AudioManager_2$dispatchPlaybackConfigChange(java.util.List<android.media.AudioPlaybackConfiguration> boolean ), 0, this, list, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRecordCallbackLock = new Object();
        this.mRecCb = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioManager this$0;

            private void $$robo$$android_media_AudioManager_3$__constructor__(AudioManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioManager_3$dispatchRecordingConfigChange(List<AudioRecordingConfiguration> configs) {
                Object object = this.this$0.mRecordCallbackLock;
                synchronized (object) {
                    if (this.this$0.mRecordCallbackList != null) {
                        for (int i = 0; i < this.this$0.mRecordCallbackList.size(); ++i) {
                            AudioRecordingCallbackInfo arci = (AudioRecordingCallbackInfo)this.this$0.mRecordCallbackList.get(i);
                            if (arci.mHandler == null) continue;
                            Message m = arci.mHandler.obtainMessage(1, new RecordConfigChangeCallbackData(arci.mCb, configs));
                            arci.mHandler.sendMessage(m);
                        }
                    }
                }
            }

            private void __constructor__(AudioManager audioManager) {
                this.$$robo$$android_media_AudioManager_3$__constructor__(audioManager);
            }
            {
                this.this$0 = audioManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_3$__constructor__(android.media.AudioManager ), 0, this, audioManager);
            }

            @Override
            public void dispatchRecordingConfigChange(List<AudioRecordingConfiguration> list) {
                InvokeDynamicSupport.bootstrap("dispatchRecordingConfigChange", $$robo$$android_media_AudioManager_3$dispatchRecordingConfigChange(java.util.List<android.media.AudioRecordingConfiguration> ), 0, this, list);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mICallBack = new Binder();
        this.mPortListener = null;
        this.mDeviceCallbacks = new ArrayMap();
        this.mPreviousPorts = new ArrayList();
        this.mAudioServerStateCbLock = new Object();
        this.mAudioServerStateDispatcher = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioManager this$0;

            private void $$robo$$android_media_AudioManager_4$__constructor__(AudioManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_AudioManager_4$dispatchAudioServerStateChange(boolean state) {
                AudioServerStateCallback cb;
                Executor exec;
                Object object = this.this$0.mAudioServerStateCbLock;
                synchronized (object) {
                    exec = this.this$0.mAudioServerStateExec;
                    cb = this.this$0.mAudioServerStateCb;
                }
                if (exec == null || cb == null) {
                    return;
                }
                if (state) {
                    exec.execute(() -> cb.onAudioServerUp());
                } else {
                    exec.execute(() -> cb.onAudioServerDown());
                }
            }

            private void __constructor__(AudioManager audioManager) {
                this.$$robo$$android_media_AudioManager_4$__constructor__(audioManager);
            }
            {
                this.this$0 = audioManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_4$__constructor__(android.media.AudioManager ), 0, this, audioManager);
            }

            @Override
            public void dispatchAudioServerStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("dispatchAudioServerStateChange", $$robo$$android_media_AudioManager_4$dispatchAudioServerStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mUseVolumeKeySounds = true;
        this.mUseFixedVolume = false;
    }

    private void $$robo$$android_media_AudioManager$__constructor__(Context context) {
        this.mAudioFocusIdListenerMap = new ConcurrentHashMap();
        this.mServiceEventHandlerDelegate = new ServiceEventHandlerDelegate(this, null);
        this.mAudioFocusDispatcher = new /* invalid duplicate definition of identical inner class */;
        this.mFocusRequestsLock = new Object();
        this.mPlaybackCallbackLock = new Object();
        this.mPlayCb = new /* invalid duplicate definition of identical inner class */;
        this.mRecordCallbackLock = new Object();
        this.mRecCb = new /* invalid duplicate definition of identical inner class */;
        this.mICallBack = new Binder();
        this.mPortListener = null;
        this.mDeviceCallbacks = new ArrayMap();
        this.mPreviousPorts = new ArrayList();
        this.mAudioServerStateCbLock = new Object();
        this.mAudioServerStateDispatcher = new /* invalid duplicate definition of identical inner class */;
        this.setContext(context);
        this.mUseVolumeKeySounds = this.getContext().getResources().getBoolean(17957066);
        this.mUseFixedVolume = this.getContext().getResources().getBoolean(17957063);
    }

    private final Context $$robo$$android_media_AudioManager$getContext() {
        if (this.mApplicationContext == null) {
            this.setContext(this.mOriginalContext);
        }
        if (this.mApplicationContext != null) {
            return this.mApplicationContext;
        }
        return this.mOriginalContext;
    }

    private final void $$robo$$android_media_AudioManager$setContext(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.mOriginalContext = this.mApplicationContext != null ? null : context;
    }

    private static final IAudioService $$robo$$android_media_AudioManager$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private final void $$robo$$android_media_AudioManager$dispatchMediaKeyEvent(KeyEvent keyEvent) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.getContext());
        helper.sendMediaButtonEvent(keyEvent, false);
    }

    private final void $$robo$$android_media_AudioManager$preDispatchKeyEvent(KeyEvent event, int stream) {
        int keyCode = event.getKeyCode();
        if (keyCode != 25 && keyCode != 24 && keyCode != 164 && this.mVolumeKeyUpTime + 300L > SystemClock.uptimeMillis()) {
            this.adjustSuggestedStreamVolume(0, stream, 8);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isVolumeFixed() {
        return this.mUseFixedVolume;
    }

    private final void $$robo$$android_media_AudioManager$adjustStreamVolume(int streamType, int direction, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.adjustStreamVolume(streamType, direction, flags, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$adjustVolume(int direction, int flags) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.getContext());
        helper.sendAdjustVolumeBy(Integer.MIN_VALUE, direction, flags);
    }

    private final void $$robo$$android_media_AudioManager$adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.getContext());
        helper.sendAdjustVolumeBy(suggestedStreamType, direction, flags);
    }

    private final void $$robo$$android_media_AudioManager$setMasterMute(boolean mute, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMasterMute(mute, flags, this.getContext().getOpPackageName(), UserHandle.getCallingUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getRingerMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getRingerModeExternal();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final boolean $$robo$$android_media_AudioManager$isValidRingerMode(int ringerMode) {
        if (ringerMode < 0 || ringerMode > 2) {
            return false;
        }
        IAudioService service = AudioManager.getService();
        try {
            return service.isValidRingerMode(ringerMode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getStreamMaxVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamMaxVolume(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getStreamMinVolume(int streamType) {
        if (!AudioManager.isPublicStreamType(streamType)) {
            throw new IllegalArgumentException("Invalid stream type " + streamType);
        }
        return this.getStreamMinVolumeInt(streamType);
    }

    private final int $$robo$$android_media_AudioManager$getStreamMinVolumeInt(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamMinVolume(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getStreamVolume(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final float $$robo$$android_media_AudioManager$getStreamVolumeDb(int streamType, int index, int deviceType) {
        if (!AudioManager.isPublicStreamType(streamType)) {
            throw new IllegalArgumentException("Invalid stream type " + streamType);
        }
        if (index > this.getStreamMaxVolume(streamType) || index < this.getStreamMinVolume(streamType)) {
            throw new IllegalArgumentException("Invalid stream volume index " + index);
        }
        if (!AudioDeviceInfo.isValidAudioDeviceTypeOut(deviceType)) {
            throw new IllegalArgumentException("Invalid audio output device type " + deviceType);
        }
        float gain = AudioSystem.getStreamVolumeDB(streamType, index, AudioDeviceInfo.convertDeviceTypeToInternalDevice(deviceType));
        if (gain <= -758.0f) {
            return Float.NEGATIVE_INFINITY;
        }
        return gain;
    }

    private static final boolean $$robo$$android_media_AudioManager$isPublicStreamType(int streamType) {
        switch (streamType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$android_media_AudioManager$getLastAudibleStreamVolume(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getLastAudibleStreamVolume(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getUiSoundsStreamType() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getUiSoundsStreamType();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.setRingerModeExternal(ringerMode, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setStreamVolume(int streamType, int index, int flags) {
        IAudioService service = AudioManager.getService();
        try {
            service.setStreamVolume(streamType, index, flags, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setStreamSolo(int streamType, boolean state) {
        Log.w("AudioManager", "setStreamSolo has been deprecated. Do not use.");
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setStreamMute(int streamType, boolean state) {
        int direction;
        Log.w("AudioManager", "setStreamMute is deprecated. adjustStreamVolume should be used instead.");
        int n = direction = state ? -100 : 100;
        if (streamType == Integer.MIN_VALUE) {
            this.adjustSuggestedStreamVolume(direction, streamType, 0);
        } else {
            this.adjustStreamVolume(streamType, direction, 0);
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isStreamMute(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.isStreamMute(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isMasterMute() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isMasterMute();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$forceVolumeControlStream(int streamType) {
        IAudioService service = AudioManager.getService();
        try {
            service.forceVolumeControlStream(streamType, this.mICallBack);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$shouldVibrate(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.shouldVibrate(vibrateType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getVibrateSetting(int vibrateType) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getVibrateSetting(vibrateType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setVibrateSetting(int vibrateType, int vibrateSetting) {
        IAudioService service = AudioManager.getService();
        try {
            service.setVibrateSetting(vibrateType, vibrateSetting);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setSpeakerphoneOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setSpeakerphoneOn(on);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isSpeakerphoneOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isSpeakerphoneOn();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isOffloadedPlaybackSupported(AudioFormat format) {
        return AudioSystem.isOffloadSupported(format);
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothScoAvailableOffCall() {
        return this.getContext().getResources().getBoolean(17956905);
    }

    private final void $$robo$$android_media_AudioManager$startBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.startBluetoothSco(this.mICallBack, this.getContext().getApplicationInfo().targetSdkVersion);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$startBluetoothScoVirtualCall() {
        IAudioService service = AudioManager.getService();
        try {
            service.startBluetoothScoVirtualCall(this.mICallBack);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$stopBluetoothSco() {
        IAudioService service = AudioManager.getService();
        try {
            service.stopBluetoothSco(this.mICallBack);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setBluetoothScoOn(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setBluetoothScoOn(on);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothScoOn() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isBluetoothScoOn();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setBluetoothA2dpOn(boolean on) {
    }

    private final boolean $$robo$$android_media_AudioManager$isBluetoothA2dpOn() {
        if (AudioSystem.getDeviceConnectionState(128, "") == 1) {
            return true;
        }
        if (AudioSystem.getDeviceConnectionState(256, "") == 1) {
            return true;
        }
        return AudioSystem.getDeviceConnectionState(512, "") == 1;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setWiredHeadsetOn(boolean on) {
    }

    private final boolean $$robo$$android_media_AudioManager$isWiredHeadsetOn() {
        return AudioSystem.getDeviceConnectionState(4, "") != 0 || AudioSystem.getDeviceConnectionState(8, "") != 0 || AudioSystem.getDeviceConnectionState(0x4000000, "") != 0;
    }

    private final void $$robo$$android_media_AudioManager$setMicrophoneMute(boolean on) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMicrophoneMute(on, this.getContext().getOpPackageName(), UserHandle.getCallingUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isMicrophoneMute() {
        return AudioSystem.isMicrophoneMuted();
    }

    private final void $$robo$$android_media_AudioManager$setMode(int mode) {
        IAudioService service = AudioManager.getService();
        try {
            service.setMode(mode, this.mICallBack, this.mApplicationContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getMode() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setRouting(int mode, int routes, int mask) {
    }

    @Deprecated
    private final int $$robo$$android_media_AudioManager$getRouting(int mode) {
        return -1;
    }

    private final boolean $$robo$$android_media_AudioManager$isMusicActive() {
        return AudioSystem.isStreamActive(3, 0);
    }

    private final boolean $$robo$$android_media_AudioManager$isMusicActiveRemotely() {
        return AudioSystem.isStreamActiveRemotely(3, 0);
    }

    private final boolean $$robo$$android_media_AudioManager$isAudioFocusExclusive() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getCurrentAudioFocus() == 4;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$generateAudioSessionId() {
        int session = AudioSystem.newAudioSessionId();
        if (session > 0) {
            return session;
        }
        Log.e("AudioManager", "Failure to generate a new audio session ID");
        return -1;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$setParameter(String key, String value) {
        this.setParameters(key + "=" + value);
    }

    private final void $$robo$$android_media_AudioManager$setParameters(String keyValuePairs) {
        AudioSystem.setParameters(keyValuePairs);
    }

    private final String $$robo$$android_media_AudioManager$getParameters(String keys) {
        return AudioSystem.getParameters(keys);
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        if (!this.querySoundEffectsEnabled(Process.myUserHandle().getIdentifier())) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType, int userId) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        if (!this.querySoundEffectsEnabled(userId)) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffect(effectType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$playSoundEffect(int effectType, float volume) {
        if (effectType < 0 || effectType >= 10) {
            return;
        }
        IAudioService service = AudioManager.getService();
        try {
            service.playSoundEffectVolume(effectType, volume);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$querySoundEffectsEnabled(int user) {
        return Settings.System.getIntForUser(this.getContext().getContentResolver(), "sound_effects_enabled", 0, user) != 0;
    }

    private final void $$robo$$android_media_AudioManager$loadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.loadSoundEffects();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$unloadSoundEffects() {
        IAudioService service = AudioManager.getService();
        try {
            service.unloadSoundEffects();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final FocusRequestInfo $$robo$$android_media_AudioManager$findFocusRequestInfo(String id2) {
        return this.mAudioFocusIdListenerMap.get(id2);
    }

    private final String $$robo$$android_media_AudioManager$getIdForAudioFocusListener(OnAudioFocusChangeListener l) {
        if (l == null) {
            return new String(this.toString());
        }
        return new String(this.toString() + l.toString());
    }

    private final void $$robo$$android_media_AudioManager$registerAudioFocusRequest(AudioFocusRequest afr) {
        Handler h = afr.getOnAudioFocusChangeListenerHandler();
        FocusRequestInfo fri = new FocusRequestInfo(afr, h == null ? null : new ServiceEventHandlerDelegate(this, h).getHandler());
        String key = this.getIdForAudioFocusListener(afr.getOnAudioFocusChangeListener());
        this.mAudioFocusIdListenerMap.put(key, fri);
    }

    private final void $$robo$$android_media_AudioManager$unregisterAudioFocusRequest(OnAudioFocusChangeListener l) {
        this.mAudioFocusIdListenerMap.remove(this.getIdForAudioFocusListener(l));
    }

    private final int $$robo$$android_media_AudioManager$requestAudioFocus(OnAudioFocusChangeListener l, int streamType, int durationHint) {
        PlayerBase.deprecateStreamTypeForPlayback(streamType, "AudioManager", "requestAudioFocus()");
        int status = 0;
        try {
            status = this.requestAudioFocus(l, new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build(), durationHint, 0);
        }
        catch (IllegalArgumentException e) {
            Log.e("AudioManager", "Audio focus request denied due to ", e);
        }
        return status;
    }

    private final int $$robo$$android_media_AudioManager$requestAudioFocus(AudioFocusRequest focusRequest) {
        return this.requestAudioFocus(focusRequest, null);
    }

    private final int $$robo$$android_media_AudioManager$abandonAudioFocusRequest(AudioFocusRequest focusRequest) {
        if (focusRequest == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusRequest");
        }
        return this.abandonAudioFocus(focusRequest.getOnAudioFocusChangeListener(), focusRequest.getAudioAttributes());
    }

    @SystemApi
    private final int $$robo$$android_media_AudioManager$requestAudioFocus(OnAudioFocusChangeListener l, AudioAttributes requestAttributes, int durationHint, int flags) throws IllegalArgumentException {
        if (flags != (flags & 3)) {
            throw new IllegalArgumentException("Invalid flags 0x" + Integer.toHexString(flags).toUpperCase());
        }
        return this.requestAudioFocus(l, requestAttributes, durationHint, flags & 3, null);
    }

    @SystemApi
    private final int $$robo$$android_media_AudioManager$requestAudioFocus(OnAudioFocusChangeListener l, AudioAttributes requestAttributes, int durationHint, int flags, AudioPolicy ap) throws IllegalArgumentException {
        if (requestAttributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes argument");
        }
        if (!AudioFocusRequest.isValidFocusGain(durationHint)) {
            throw new IllegalArgumentException("Invalid duration hint");
        }
        if (flags != (flags & 7)) {
            throw new IllegalArgumentException("Illegal flags 0x" + Integer.toHexString(flags).toUpperCase());
        }
        if ((flags & 1) == 1 && l == null) {
            throw new IllegalArgumentException("Illegal null focus listener when flagged as accepting delayed focus grant");
        }
        if ((flags & 2) == 2 && l == null) {
            throw new IllegalArgumentException("Illegal null focus listener when flagged as pausing instead of ducking");
        }
        if ((flags & 4) == 4 && ap == null) {
            throw new IllegalArgumentException("Illegal null audio policy when locking audio focus");
        }
        AudioFocusRequest afr = new AudioFocusRequest.Builder(durationHint).setOnAudioFocusChangeListenerInt(l, null).setAudioAttributes(requestAttributes).setAcceptsDelayedFocusGain((flags & 1) == 1).setWillPauseWhenDucked((flags & 2) == 2).setLocksFocus((flags & 4) == 4).build();
        return this.requestAudioFocus(afr, ap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final int $$robo$$android_media_AudioManager$requestAudioFocus(AudioFocusRequest afr, AudioPolicy ap) {
        BlockingFocusResultReceiver focusReceiver;
        int sdk;
        if (afr == null) {
            throw new NullPointerException("Illegal null AudioFocusRequest");
        }
        if (afr.locksFocus() && ap == null) {
            throw new IllegalArgumentException("Illegal null audio policy when locking audio focus");
        }
        this.registerAudioFocusRequest(afr);
        IAudioService service = AudioManager.getService();
        try {
            sdk = this.getContext().getApplicationInfo().targetSdkVersion;
        }
        catch (NullPointerException e) {
            sdk = Build.VERSION.SDK_INT;
        }
        String clientId = this.getIdForAudioFocusListener(afr.getOnAudioFocusChangeListener());
        Object object = this.mFocusRequestsLock;
        synchronized (object) {
            int status;
            try {
                status = service.requestAudioFocus(afr.getAudioAttributes(), afr.getFocusGain(), this.mICallBack, this.mAudioFocusDispatcher, clientId, this.getContext().getOpPackageName(), afr.getFlags(), ap != null ? ap.cb() : null, sdk);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (status != 100) {
                return status;
            }
            if (this.mFocusRequestsAwaitingResult == null) {
                this.mFocusRequestsAwaitingResult = new HashMap(1);
            }
            focusReceiver = new BlockingFocusResultReceiver(clientId);
            this.mFocusRequestsAwaitingResult.put(clientId, focusReceiver);
        }
        focusReceiver.waitForResult(200L);
        object = this.mFocusRequestsLock;
        synchronized (object) {
            this.mFocusRequestsAwaitingResult.remove(clientId);
        }
        return focusReceiver.requestResult();
    }

    private final void $$robo$$android_media_AudioManager$requestAudioFocusForCall(int streamType, int durationHint) {
        IAudioService service = AudioManager.getService();
        try {
            service.requestAudioFocus(new AudioAttributes.Builder().setInternalLegacyStreamType(streamType).build(), durationHint, this.mICallBack, null, "AudioFocus_For_Phone_Ring_And_Calls", this.getContext().getOpPackageName(), 4, null, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getFocusRampTimeMs(int focusGain, AudioAttributes attr2) {
        IAudioService service = AudioManager.getService();
        try {
            return service.getFocusRampTimeMs(focusGain, attr2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_media_AudioManager$setFocusRequestResult(AudioFocusInfo afi, int requestResult, AudioPolicy ap) {
        if (afi == null) {
            throw new IllegalArgumentException("Illegal null AudioFocusInfo");
        }
        if (ap == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy");
        }
        IAudioService service = AudioManager.getService();
        try {
            service.setFocusRequestResultFromExtPolicy(afi, requestResult, ap.cb());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final int $$robo$$android_media_AudioManager$dispatchAudioFocusChange(AudioFocusInfo afi, int focusChange, AudioPolicy ap) {
        if (afi == null) {
            throw new NullPointerException("Illegal null AudioFocusInfo");
        }
        if (ap == null) {
            throw new NullPointerException("Illegal null AudioPolicy");
        }
        IAudioService service = AudioManager.getService();
        try {
            return service.dispatchFocusChange(afi, focusChange, ap.cb());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$abandonAudioFocusForCall() {
        IAudioService service = AudioManager.getService();
        try {
            service.abandonAudioFocus(null, "AudioFocus_For_Phone_Ring_And_Calls", null, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$abandonAudioFocus(OnAudioFocusChangeListener l) {
        return this.abandonAudioFocus(l, null);
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_media_AudioManager$abandonAudioFocus(OnAudioFocusChangeListener l, AudioAttributes aa) {
        int status = 0;
        this.unregisterAudioFocusRequest(l);
        IAudioService service = AudioManager.getService();
        try {
            status = service.abandonAudioFocus(this.mAudioFocusDispatcher, this.getIdForAudioFocusListener(l), aa, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return status;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(ComponentName eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        if (!eventReceiver.getPackageName().equals(this.getContext().getPackageName())) {
            Log.e("AudioManager", "registerMediaButtonEventReceiver() error: receiver and context package names don't match");
            return;
        }
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setComponent(eventReceiver);
        PendingIntent pi = PendingIntent.getBroadcast(this.getContext(), 0, mediaButtonIntent, 0);
        this.registerMediaButtonIntent(pi, eventReceiver);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(PendingIntent eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        this.registerMediaButtonIntent(eventReceiver, null);
    }

    private final void $$robo$$android_media_AudioManager$registerMediaButtonIntent(PendingIntent pi, ComponentName eventReceiver) {
        if (pi == null) {
            Log.e("AudioManager", "Cannot call registerMediaButtonIntent() with a null parameter");
            return;
        }
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.getContext());
        helper.addMediaButtonListener(pi, eventReceiver, this.getContext());
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(ComponentName eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
        mediaButtonIntent.setComponent(eventReceiver);
        PendingIntent pi = PendingIntent.getBroadcast(this.getContext(), 0, mediaButtonIntent, 0);
        this.unregisterMediaButtonIntent(pi);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(PendingIntent eventReceiver) {
        if (eventReceiver == null) {
            return;
        }
        this.unregisterMediaButtonIntent(eventReceiver);
    }

    private final void $$robo$$android_media_AudioManager$unregisterMediaButtonIntent(PendingIntent pi) {
        MediaSessionLegacyHelper helper = MediaSessionLegacyHelper.getHelper(this.getContext());
        helper.removeMediaButtonListener(pi);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$registerRemoteControlClient(RemoteControlClient rcClient) {
        if (rcClient == null || rcClient.getRcMediaIntent() == null) {
            return;
        }
        rcClient.registerWithSession(MediaSessionLegacyHelper.getHelper(this.getContext()));
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterRemoteControlClient(RemoteControlClient rcClient) {
        if (rcClient == null || rcClient.getRcMediaIntent() == null) {
            return;
        }
        rcClient.unregisterWithSession(MediaSessionLegacyHelper.getHelper(this.getContext()));
    }

    @Deprecated
    private final boolean $$robo$$android_media_AudioManager$registerRemoteController(RemoteController rctlr) {
        if (rctlr == null) {
            return false;
        }
        rctlr.startListeningToSessions();
        return true;
    }

    @Deprecated
    private final void $$robo$$android_media_AudioManager$unregisterRemoteController(RemoteController rctlr) {
        if (rctlr == null) {
            return;
        }
        rctlr.stopListeningToSessions();
    }

    @SystemApi
    private final int $$robo$$android_media_AudioManager$registerAudioPolicy(AudioPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService service = AudioManager.getService();
        try {
            String regId = service.registerAudioPolicy(policy.getConfig(), policy.cb(), policy.hasFocusListener(), policy.isFocusPolicy(), policy.isVolumeController());
            if (regId == null) {
                return -1;
            }
            policy.setRegistration(regId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return 0;
    }

    @SystemApi
    private final void $$robo$$android_media_AudioManager$unregisterAudioPolicyAsync(AudioPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Illegal null AudioPolicy argument");
        }
        IAudioService service = AudioManager.getService();
        try {
            service.unregisterAudioPolicyAsync(policy.cb());
            policy.setRegistration(null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$registerAudioPlaybackCallback(AudioPlaybackCallback cb, Handler handler) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioPlaybackCallback argument");
        }
        Object object = this.mPlaybackCallbackLock;
        synchronized (object) {
            if (this.mPlaybackCallbackList == null) {
                this.mPlaybackCallbackList = new ArrayList<AudioPlaybackCallbackInfo>();
            }
            int oldCbCount = this.mPlaybackCallbackList.size();
            if (!this.hasPlaybackCallback_sync(cb)) {
                this.mPlaybackCallbackList.add(new AudioPlaybackCallbackInfo(cb, new ServiceEventHandlerDelegate(this, handler).getHandler()));
                int newCbCount = this.mPlaybackCallbackList.size();
                if (oldCbCount == 0 && newCbCount > 0) {
                    try {
                        AudioManager.getService().registerPlaybackCallback(this.mPlayCb);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            } else {
                Log.w("AudioManager", "attempt to call registerAudioPlaybackCallback() on a previouslyregistered callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$unregisterAudioPlaybackCallback(AudioPlaybackCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioPlaybackCallback argument");
        }
        Object object = this.mPlaybackCallbackLock;
        synchronized (object) {
            if (this.mPlaybackCallbackList == null) {
                Log.w("AudioManager", "attempt to call unregisterAudioPlaybackCallback() on a callback that was never registered");
                return;
            }
            int oldCbCount = this.mPlaybackCallbackList.size();
            if (this.removePlaybackCallback_sync(cb)) {
                int newCbCount = this.mPlaybackCallbackList.size();
                if (oldCbCount > 0 && newCbCount == 0) {
                    try {
                        AudioManager.getService().unregisterPlaybackCallback(this.mPlayCb);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            } else {
                Log.w("AudioManager", "attempt to call unregisterAudioPlaybackCallback() on a callback already unregistered or never registered");
            }
        }
    }

    private final List<AudioPlaybackConfiguration> $$robo$$android_media_AudioManager$getActivePlaybackConfigurations() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getActivePlaybackConfigurations();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$hasPlaybackCallback_sync(AudioPlaybackCallback cb) {
        if (this.mPlaybackCallbackList != null) {
            for (int i = 0; i < this.mPlaybackCallbackList.size(); ++i) {
                if (!cb.equals(this.mPlaybackCallbackList.get((int)i).mCb)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_media_AudioManager$removePlaybackCallback_sync(AudioPlaybackCallback cb) {
        if (this.mPlaybackCallbackList != null) {
            for (int i = 0; i < this.mPlaybackCallbackList.size(); ++i) {
                if (!cb.equals(this.mPlaybackCallbackList.get((int)i).mCb)) continue;
                this.mPlaybackCallbackList.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$registerAudioRecordingCallback(AudioRecordingCallback cb, Handler handler) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioRecordingCallback argument");
        }
        Object object = this.mRecordCallbackLock;
        synchronized (object) {
            if (this.mRecordCallbackList == null) {
                this.mRecordCallbackList = new ArrayList<AudioRecordingCallbackInfo>();
            }
            int oldCbCount = this.mRecordCallbackList.size();
            if (!this.hasRecordCallback_sync(cb)) {
                this.mRecordCallbackList.add(new AudioRecordingCallbackInfo(cb, new ServiceEventHandlerDelegate(this, handler).getHandler()));
                int newCbCount = this.mRecordCallbackList.size();
                if (oldCbCount == 0 && newCbCount > 0) {
                    IAudioService service = AudioManager.getService();
                    try {
                        service.registerRecordingCallback(this.mRecCb);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            } else {
                Log.w("AudioManager", "attempt to call registerAudioRecordingCallback() on a previouslyregistered callback");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$unregisterAudioRecordingCallback(AudioRecordingCallback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("Illegal null AudioRecordingCallback argument");
        }
        Object object = this.mRecordCallbackLock;
        synchronized (object) {
            if (this.mRecordCallbackList == null) {
                return;
            }
            int oldCbCount = this.mRecordCallbackList.size();
            if (this.removeRecordCallback_sync(cb)) {
                int newCbCount = this.mRecordCallbackList.size();
                if (oldCbCount > 0 && newCbCount == 0) {
                    IAudioService service = AudioManager.getService();
                    try {
                        service.unregisterRecordingCallback(this.mRecCb);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            } else {
                Log.w("AudioManager", "attempt to call unregisterAudioRecordingCallback() on a callback already unregistered or never registered");
            }
        }
    }

    private final List<AudioRecordingConfiguration> $$robo$$android_media_AudioManager$getActiveRecordingConfigurations() {
        IAudioService service = AudioManager.getService();
        try {
            return service.getActiveRecordingConfigurations();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$hasRecordCallback_sync(AudioRecordingCallback cb) {
        if (this.mRecordCallbackList != null) {
            for (int i = 0; i < this.mRecordCallbackList.size(); ++i) {
                if (!cb.equals(this.mRecordCallbackList.get((int)i).mCb)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_media_AudioManager$removeRecordCallback_sync(AudioRecordingCallback cb) {
        if (this.mRecordCallbackList != null) {
            for (int i = 0; i < this.mRecordCallbackList.size(); ++i) {
                if (!cb.equals(this.mRecordCallbackList.get((int)i).mCb)) continue;
                this.mRecordCallbackList.remove(i);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_media_AudioManager$reloadAudioSettings() {
        IAudioService service = AudioManager.getService();
        try {
            service.reloadAudioSettings();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$avrcpSupportsAbsoluteVolume(String address, boolean support) {
        IAudioService service = AudioManager.getService();
        try {
            service.avrcpSupportsAbsoluteVolume(address, support);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isSilentMode() {
        int ringerMode = this.getRingerMode();
        boolean silentMode = ringerMode == 0 || ringerMode == 1;
        return silentMode;
    }

    private static final boolean $$robo$$android_media_AudioManager$isOutputDevice(int device) {
        return (device & Integer.MIN_VALUE) == 0;
    }

    private static final boolean $$robo$$android_media_AudioManager$isInputDevice(int device) {
        return (device & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    private final int $$robo$$android_media_AudioManager$getDevicesForStream(int streamType) {
        switch (streamType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                return AudioSystem.getDevicesForStream(streamType);
            }
        }
        return 0;
    }

    private final void $$robo$$android_media_AudioManager$setWiredDeviceConnectionState(int type, int state, String address, String name) {
        IAudioService service = AudioManager.getService();
        try {
            service.setWiredDeviceConnectionState(type, state, address, name, this.mApplicationContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setHearingAidDeviceConnectionState(BluetoothDevice device, int state) {
        IAudioService service = AudioManager.getService();
        try {
            service.setHearingAidDeviceConnectionState(device, state);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state, int profile) {
        IAudioService service = AudioManager.getService();
        int delay = 0;
        try {
            delay = service.setBluetoothA2dpDeviceConnectionState(device, state, profile);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return delay;
    }

    private final int $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(BluetoothDevice device, int state, int profile, boolean suppressNoisyIntent, int a2dpVolume) {
        IAudioService service = AudioManager.getService();
        int delay = 0;
        try {
            delay = service.setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(device, state, profile, suppressNoisyIntent, a2dpVolume);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return delay;
    }

    private final void $$robo$$android_media_AudioManager$handleBluetoothA2dpDeviceConfigChange(BluetoothDevice device) {
        IAudioService service = AudioManager.getService();
        try {
            service.handleBluetoothA2dpDeviceConfigChange(device);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final IRingtonePlayer $$robo$$android_media_AudioManager$getRingtonePlayer() {
        try {
            return AudioManager.getService().getRingtonePlayer();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_media_AudioManager$getProperty(String key) {
        if ("android.media.property.OUTPUT_SAMPLE_RATE".equals(key)) {
            int outputSampleRate = AudioSystem.getPrimaryOutputSamplingRate();
            return outputSampleRate > 0 ? Integer.toString(outputSampleRate) : null;
        }
        if ("android.media.property.OUTPUT_FRAMES_PER_BUFFER".equals(key)) {
            int outputFramesPerBuffer = AudioSystem.getPrimaryOutputFrameCount();
            return outputFramesPerBuffer > 0 ? Integer.toString(outputFramesPerBuffer) : null;
        }
        if ("android.media.property.SUPPORT_MIC_NEAR_ULTRASOUND".equals(key)) {
            return String.valueOf(this.getContext().getResources().getBoolean(17957040));
        }
        if ("android.media.property.SUPPORT_SPEAKER_NEAR_ULTRASOUND".equals(key)) {
            return String.valueOf(this.getContext().getResources().getBoolean(17957042));
        }
        if ("android.media.property.SUPPORT_AUDIO_SOURCE_UNPROCESSED".equals(key)) {
            return String.valueOf(this.getContext().getResources().getBoolean(17957035));
        }
        return null;
    }

    private final int $$robo$$android_media_AudioManager$getOutputLatency(int streamType) {
        return AudioSystem.getOutputLatency(streamType);
    }

    private final void $$robo$$android_media_AudioManager$setVolumeController(IVolumeController controller) {
        try {
            AudioManager.getService().setVolumeController(controller);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$notifyVolumeControllerVisible(IVolumeController controller, boolean visible) {
        try {
            AudioManager.getService().notifyVolumeControllerVisible(controller, visible);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isStreamAffectedByRingerMode(int streamType) {
        try {
            return AudioManager.getService().isStreamAffectedByRingerMode(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_media_AudioManager$isStreamAffectedByMute(int streamType) {
        try {
            return AudioManager.getService().isStreamAffectedByMute(streamType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$disableSafeMediaVolume() {
        try {
            AudioManager.getService().disableSafeMediaVolume(this.mApplicationContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setRingerModeInternal(int ringerMode) {
        try {
            AudioManager.getService().setRingerModeInternal(ringerMode, this.getContext().getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$getRingerModeInternal() {
        try {
            return AudioManager.getService().getRingerModeInternal();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_media_AudioManager$setVolumePolicy(VolumePolicy policy) {
        try {
            AudioManager.getService().setVolumePolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_media_AudioManager$setHdmiSystemAudioSupported(boolean on) {
        try {
            return AudioManager.getService().setHdmiSystemAudioSupported(on);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    private final boolean $$robo$$android_media_AudioManager$isHdmiSystemAudioSupported() {
        try {
            return AudioManager.getService().isHdmiSystemAudioSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_media_AudioManager$listAudioPorts(ArrayList<AudioPort> ports) {
        return AudioManager.updateAudioPortCache(ports, null, null);
    }

    private static final int $$robo$$android_media_AudioManager$listPreviousAudioPorts(ArrayList<AudioPort> ports) {
        return AudioManager.updateAudioPortCache(null, null, ports);
    }

    private static final int $$robo$$android_media_AudioManager$listAudioDevicePorts(ArrayList<AudioDevicePort> devices) {
        if (devices == null) {
            return -2;
        }
        ArrayList<AudioPort> ports = new ArrayList<AudioPort>();
        int status = AudioManager.updateAudioPortCache(ports, null, null);
        if (status == 0) {
            AudioManager.filterDevicePorts(ports, devices);
        }
        return status;
    }

    private static final int $$robo$$android_media_AudioManager$listPreviousAudioDevicePorts(ArrayList<AudioDevicePort> devices) {
        if (devices == null) {
            return -2;
        }
        ArrayList<AudioPort> ports = new ArrayList<AudioPort>();
        int status = AudioManager.updateAudioPortCache(null, null, ports);
        if (status == 0) {
            AudioManager.filterDevicePorts(ports, devices);
        }
        return status;
    }

    private static final void $$robo$$android_media_AudioManager$filterDevicePorts(ArrayList<AudioPort> ports, ArrayList<AudioDevicePort> devices) {
        devices.clear();
        for (int i = 0; i < ports.size(); ++i) {
            if (!(ports.get(i) instanceof AudioDevicePort)) continue;
            devices.add((AudioDevicePort)ports.get(i));
        }
    }

    private static final int $$robo$$android_media_AudioManager$createAudioPatch(AudioPatch[] patch, AudioPortConfig[] sources, AudioPortConfig[] sinks) {
        return AudioSystem.createAudioPatch(patch, sources, sinks);
    }

    private static final int $$robo$$android_media_AudioManager$releaseAudioPatch(AudioPatch patch) {
        return AudioSystem.releaseAudioPatch(patch);
    }

    private static final int $$robo$$android_media_AudioManager$listAudioPatches(ArrayList<AudioPatch> patches) {
        return AudioManager.updateAudioPortCache(null, patches, null);
    }

    private static final int $$robo$$android_media_AudioManager$setAudioPortGain(AudioPort port, AudioGainConfig gain) {
        if (port == null || gain == null) {
            return -2;
        }
        AudioPortConfig activeConfig = port.activeConfig();
        AudioPortConfig config = new AudioPortConfig(port, activeConfig.samplingRate(), activeConfig.channelMask(), activeConfig.format(), gain);
        config.mConfigMask = 8;
        return AudioSystem.setAudioPortConfig(config);
    }

    private final void $$robo$$android_media_AudioManager$registerAudioPortUpdateListener(OnAudioPortUpdateListener l) {
        sAudioPortEventHandler.init();
        sAudioPortEventHandler.registerListener(l);
    }

    private final void $$robo$$android_media_AudioManager$unregisterAudioPortUpdateListener(OnAudioPortUpdateListener l) {
        sAudioPortEventHandler.unregisterListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_media_AudioManager$resetAudioPortGeneration() {
        int generation;
        Integer n = sAudioPortGeneration;
        synchronized (n) {
            generation = sAudioPortGeneration;
            sAudioPortGeneration = 0;
        }
        return generation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_media_AudioManager$updateAudioPortCache(ArrayList<AudioPort> ports, ArrayList<AudioPatch> patches, ArrayList<AudioPort> previousPorts) {
        sAudioPortEventHandler.init();
        Integer n = sAudioPortGeneration;
        synchronized (n) {
            if (sAudioPortGeneration == 0) {
                int[] patchGeneration = new int[1];
                int[] portGeneration = new int[1];
                ArrayList<AudioPort> newPorts = new ArrayList<AudioPort>();
                ArrayList<AudioPatch> newPatches = new ArrayList<AudioPatch>();
                do {
                    newPorts.clear();
                    int status = AudioSystem.listAudioPorts(newPorts, portGeneration);
                    if (status != 0) {
                        Log.w("AudioManager", "updateAudioPortCache: listAudioPorts failed");
                        return status;
                    }
                    newPatches.clear();
                    status = AudioSystem.listAudioPatches(newPatches, patchGeneration);
                    if (status == 0) continue;
                    Log.w("AudioManager", "updateAudioPortCache: listAudioPatches failed");
                    return status;
                } while (patchGeneration[0] != portGeneration[0] && (ports == null || patches == null));
                if (patchGeneration[0] != portGeneration[0]) {
                    return -1;
                }
                for (int i = 0; i < newPatches.size(); ++i) {
                    AudioPortConfig portCfg;
                    int j;
                    for (j = 0; j < newPatches.get(i).sources().length; ++j) {
                        newPatches.get((int)i).sources()[j] = portCfg = AudioManager.updatePortConfig(newPatches.get(i).sources()[j], newPorts);
                    }
                    for (j = 0; j < newPatches.get(i).sinks().length; ++j) {
                        newPatches.get((int)i).sinks()[j] = portCfg = AudioManager.updatePortConfig(newPatches.get(i).sinks()[j], newPorts);
                    }
                }
                Iterator<AudioPatch> i = newPatches.iterator();
                while (i.hasNext()) {
                    AudioPatch newPatch = i.next();
                    boolean hasInvalidPort = false;
                    for (AudioPortConfig portCfg : newPatch.sources()) {
                        if (portCfg != null) continue;
                        hasInvalidPort = true;
                        break;
                    }
                    for (AudioPortConfig portCfg : newPatch.sinks()) {
                        if (portCfg != null) continue;
                        hasInvalidPort = true;
                        break;
                    }
                    if (!hasInvalidPort) continue;
                    i.remove();
                }
                sPreviousAudioPortsCached = sAudioPortsCached;
                sAudioPortsCached = newPorts;
                sAudioPatchesCached = newPatches;
                sAudioPortGeneration = portGeneration[0];
            }
            if (ports != null) {
                ports.clear();
                ports.addAll(sAudioPortsCached);
            }
            if (patches != null) {
                patches.clear();
                patches.addAll(sAudioPatchesCached);
            }
            if (previousPorts != null) {
                previousPorts.clear();
                previousPorts.addAll(sPreviousAudioPortsCached);
            }
        }
        return 0;
    }

    private static final AudioPortConfig $$robo$$android_media_AudioManager$updatePortConfig(AudioPortConfig portCfg, ArrayList<AudioPort> ports) {
        int k;
        AudioPort port = portCfg.port();
        for (k = 0; k < ports.size(); ++k) {
            if (!ports.get(k).handle().equals(port.handle())) continue;
            port = ports.get(k);
            break;
        }
        if (k == ports.size()) {
            Log.e("AudioManager", "updatePortConfig port not found for handle: " + port.handle().id());
            return null;
        }
        AudioGainConfig gainCfg = portCfg.gain();
        if (gainCfg != null) {
            AudioGain gain = port.gain(gainCfg.index());
            gainCfg = gain.buildConfig(gainCfg.mode(), gainCfg.channelMask(), gainCfg.values(), gainCfg.rampDurationMs());
        }
        return port.buildConfig(portCfg.samplingRate(), portCfg.channelMask(), portCfg.format(), gainCfg);
    }

    private static final boolean $$robo$$android_media_AudioManager$checkFlags(AudioDevicePort port, int flags) {
        return port.role() == 2 && (flags & 2) != 0 || port.role() == 1 && (flags & 1) != 0;
    }

    private static final boolean $$robo$$android_media_AudioManager$checkTypes(AudioDevicePort port) {
        return AudioDeviceInfo.convertInternalDeviceToDeviceType(port.type()) != 0;
    }

    private final AudioDeviceInfo[] $$robo$$android_media_AudioManager$getDevices(int flags) {
        return AudioManager.getDevicesStatic(flags);
    }

    private static final AudioDeviceInfo[] $$robo$$android_media_AudioManager$infoListFromPortList(ArrayList<AudioDevicePort> ports, int flags) {
        int numRecs = 0;
        for (AudioDevicePort port : ports) {
            if (!AudioManager.checkTypes(port) || !AudioManager.checkFlags(port, flags)) continue;
            ++numRecs;
        }
        AudioDeviceInfo[] deviceList = new AudioDeviceInfo[numRecs];
        int slot = 0;
        for (AudioDevicePort port : ports) {
            if (!AudioManager.checkTypes(port) || !AudioManager.checkFlags(port, flags)) continue;
            deviceList[slot++] = new AudioDeviceInfo(port);
        }
        return deviceList;
    }

    private static final AudioDeviceInfo[] $$robo$$android_media_AudioManager$calcListDeltas(ArrayList<AudioDevicePort> ports_A, ArrayList<AudioDevicePort> ports_B, int flags) {
        ArrayList<AudioDevicePort> delta_ports = new ArrayList<AudioDevicePort>();
        AudioDevicePort cur_port = null;
        for (int cur_index = 0; cur_index < ports_B.size(); ++cur_index) {
            boolean cur_port_found = false;
            cur_port = ports_B.get(cur_index);
            for (int prev_index = 0; prev_index < ports_A.size() && !cur_port_found; ++prev_index) {
                cur_port_found = cur_port.id() == ports_A.get(prev_index).id();
            }
            if (cur_port_found) continue;
            delta_ports.add(cur_port);
        }
        return AudioManager.infoListFromPortList(delta_ports, flags);
    }

    private static final AudioDeviceInfo[] $$robo$$android_media_AudioManager$getDevicesStatic(int flags) {
        ArrayList<AudioDevicePort> ports = new ArrayList<AudioDevicePort>();
        int status = AudioManager.listAudioDevicePorts(ports);
        if (status != 0) {
            return new AudioDeviceInfo[0];
        }
        return AudioManager.infoListFromPortList(ports, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$registerAudioDeviceCallback(AudioDeviceCallback callback, Handler handler) {
        ArrayMap<AudioDeviceCallback, NativeEventHandlerDelegate> arrayMap = this.mDeviceCallbacks;
        synchronized (arrayMap) {
            if (callback != null && !this.mDeviceCallbacks.containsKey(callback)) {
                if (this.mDeviceCallbacks.size() == 0) {
                    if (this.mPortListener == null) {
                        this.mPortListener = new OnAmPortUpdateListener(this);
                    }
                    this.registerAudioPortUpdateListener(this.mPortListener);
                }
                NativeEventHandlerDelegate delegate = new NativeEventHandlerDelegate(this, callback, handler);
                this.mDeviceCallbacks.put(callback, delegate);
                this.broadcastDeviceListChange_sync(delegate.getHandler());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioManager$unregisterAudioDeviceCallback(AudioDeviceCallback callback) {
        ArrayMap<AudioDeviceCallback, NativeEventHandlerDelegate> arrayMap = this.mDeviceCallbacks;
        synchronized (arrayMap) {
            if (this.mDeviceCallbacks.containsKey(callback)) {
                this.mDeviceCallbacks.remove(callback);
                if (this.mDeviceCallbacks.size() == 0) {
                    this.unregisterAudioPortUpdateListener(this.mPortListener);
                }
            }
        }
    }

    private static final void $$robo$$android_media_AudioManager$setPortIdForMicrophones(ArrayList<MicrophoneInfo> microphones) {
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
        for (int i = microphones.size() - 1; i >= 0; --i) {
            boolean foundPortId = false;
            for (AudioDeviceInfo device : devices) {
                if (device.getPort().type() != microphones.get(i).getInternalDeviceType() || !TextUtils.equals(device.getAddress(), microphones.get(i).getAddress())) continue;
                microphones.get(i).setId(device.getId());
                foundPortId = true;
                break;
            }
            if (foundPortId) continue;
            Log.i("AudioManager", "Failed to find port id for device with type:" + microphones.get(i).getType() + " address:" + microphones.get(i).getAddress());
            microphones.remove(i);
        }
    }

    private static final MicrophoneInfo $$robo$$android_media_AudioManager$microphoneInfoFromAudioDeviceInfo(AudioDeviceInfo deviceInfo) {
        int deviceType = deviceInfo.getType();
        int micLocation = deviceType == 15 || deviceType == 18 ? 1 : (deviceType == 0 ? 0 : 3);
        MicrophoneInfo microphone = new MicrophoneInfo(deviceInfo.getPort().name() + deviceInfo.getId(), deviceInfo.getPort().type(), deviceInfo.getAddress(), micLocation, -1, -1, MicrophoneInfo.POSITION_UNKNOWN, MicrophoneInfo.ORIENTATION_UNKNOWN, new ArrayList<Pair<Float, Float>>(), new ArrayList<Pair<Integer, Integer>>(), -3.4028235E38f, -3.4028235E38f, -3.4028235E38f, 0);
        microphone.setId(deviceInfo.getId());
        return microphone;
    }

    private final void $$robo$$android_media_AudioManager$addMicrophonesFromAudioDeviceInfo(ArrayList<MicrophoneInfo> microphones, HashSet<Integer> filterTypes) {
        AudioDeviceInfo[] devices;
        for (AudioDeviceInfo device : devices = AudioManager.getDevicesStatic(1)) {
            if (filterTypes.contains(device.getType())) continue;
            MicrophoneInfo microphone = AudioManager.microphoneInfoFromAudioDeviceInfo(device);
            microphones.add(microphone);
        }
    }

    private final List<MicrophoneInfo> $$robo$$android_media_AudioManager$getMicrophones() throws IOException {
        ArrayList<MicrophoneInfo> microphones = new ArrayList<MicrophoneInfo>();
        int status = AudioSystem.getMicrophones(microphones);
        HashSet<Integer> filterTypes = new HashSet<Integer>();
        filterTypes.add(18);
        if (status != 0) {
            if (status != -3) {
                Log.e("AudioManager", "getMicrophones failed:" + status);
            }
            Log.i("AudioManager", "fallback on device info");
            this.addMicrophonesFromAudioDeviceInfo(microphones, filterTypes);
            return microphones;
        }
        AudioManager.setPortIdForMicrophones(microphones);
        filterTypes.add(15);
        this.addMicrophonesFromAudioDeviceInfo(microphones, filterTypes);
        return microphones;
    }

    private final void $$robo$$android_media_AudioManager$broadcastDeviceListChange_sync(Handler handler) {
        ArrayList<AudioDevicePort> current_ports = new ArrayList<AudioDevicePort>();
        int status = AudioManager.listAudioDevicePorts(current_ports);
        if (status != 0) {
            return;
        }
        if (handler != null) {
            AudioDeviceInfo[] deviceList = AudioManager.infoListFromPortList(current_ports, 3);
            handler.sendMessage(Message.obtain(handler, 0, deviceList));
        } else {
            AudioDeviceInfo[] added_devices = AudioManager.calcListDeltas(this.mPreviousPorts, current_ports, 3);
            AudioDeviceInfo[] removed_devices = AudioManager.calcListDeltas(current_ports, this.mPreviousPorts, 3);
            if (added_devices.length != 0 || removed_devices.length != 0) {
                for (int i = 0; i < this.mDeviceCallbacks.size(); ++i) {
                    handler = this.mDeviceCallbacks.valueAt(i).getHandler();
                    if (handler == null) continue;
                    if (removed_devices.length != 0) {
                        handler.sendMessage(Message.obtain(handler, 2, removed_devices));
                    }
                    if (added_devices.length == 0) continue;
                    handler.sendMessage(Message.obtain(handler, 1, added_devices));
                }
            }
        }
        this.mPreviousPorts = current_ports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_media_AudioManager$setAudioServerStateCallback(Executor executor, AudioServerStateCallback stateCallback) {
        if (stateCallback == null) {
            throw new IllegalArgumentException("Illegal null AudioServerStateCallback");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Illegal null Executor for the AudioServerStateCallback");
        }
        Object object = this.mAudioServerStateCbLock;
        synchronized (object) {
            if (this.mAudioServerStateCb != null) {
                throw new IllegalStateException("setAudioServerStateCallback called with already registered callabck");
            }
            IAudioService service = AudioManager.getService();
            try {
                service.registerAudioServerStateDispatcher(this.mAudioServerStateDispatcher);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mAudioServerStateExec = executor;
            this.mAudioServerStateCb = stateCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_media_AudioManager$clearAudioServerStateCallback() {
        Object object = this.mAudioServerStateCbLock;
        synchronized (object) {
            if (this.mAudioServerStateCb != null) {
                IAudioService service = AudioManager.getService();
                try {
                    service.unregisterAudioServerStateDispatcher(this.mAudioServerStateDispatcher);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            this.mAudioServerStateExec = null;
            this.mAudioServerStateCb = null;
        }
    }

    @SystemApi
    private final boolean $$robo$$android_media_AudioManager$isAudioServerRunning() {
        IAudioService service = AudioManager.getService();
        try {
            return service.isAudioServerRunning();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Map<Integer, Boolean> $$robo$$android_media_AudioManager$getSurroundFormats() {
        HashMap<Integer, Boolean> surroundFormats = new HashMap<Integer, Boolean>();
        int status = AudioSystem.getSurroundFormats(surroundFormats, false);
        if (status != 0) {
            Log.e("AudioManager", "getSurroundFormats failed:" + status);
            return new HashMap<Integer, Boolean>();
        }
        return surroundFormats;
    }

    private final boolean $$robo$$android_media_AudioManager$setSurroundFormatEnabled(int audioFormat, boolean enabled) {
        int status = AudioSystem.setSurroundFormatEnabled(audioFormat, enabled);
        return status == 0;
    }

    private final Map<Integer, Boolean> $$robo$$android_media_AudioManager$getReportedSurroundFormats() {
        HashMap<Integer, Boolean> reportedSurroundFormats = new HashMap<Integer, Boolean>();
        int status = AudioSystem.getSurroundFormats(reportedSurroundFormats, true);
        if (status != 0) {
            Log.e("AudioManager", "getReportedSurroundFormats failed:" + status);
            return new HashMap<Integer, Boolean>();
        }
        return reportedSurroundFormats;
    }

    static void __staticInitializer__() {
        sAudioPortEventHandler = new AudioPortEventHandler();
        FLAG_NAMES = new String[]{"FLAG_SHOW_UI", "FLAG_ALLOW_RINGER_MODES", "FLAG_PLAY_SOUND", "FLAG_REMOVE_SOUND_AND_VIBRATE", "FLAG_VIBRATE", "FLAG_FIXED_VOLUME", "FLAG_BLUETOOTH_ABS_VOLUME", "FLAG_SHOW_SILENT_HINT", "FLAG_HDMI_SYSTEM_AUDIO_VOLUME", "FLAG_ACTIVE_MEDIA_ONLY", "FLAG_SHOW_UI_WARNINGS", "FLAG_SHOW_VIBRATE_HINT", "FLAG_FROM_KEY"};
        sAudioPortGeneration = new Integer(0);
        sAudioPortsCached = new ArrayList();
        sPreviousAudioPortsCached = new ArrayList();
        sAudioPatchesCached = new ArrayList();
    }

    public static String adjustToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("adjustToString", $$robo$$android_media_AudioManager$adjustToString(int ), 0, (int)n);
    }

    public static String flagsToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("flagsToString", $$robo$$android_media_AudioManager$flagsToString(int ), 0, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$android_media_AudioManager$__constructor__();
    }

    public AudioManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager$__constructor__(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_AudioManager$__constructor__(context);
    }

    public AudioManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_media_AudioManager$getContext(), 0, this);
    }

    private void setContext(Context context) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_media_AudioManager$setContext(android.content.Context ), 0, this, context);
    }

    private static IAudioService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_AudioManager$getService(), 0);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_AudioManager$dispatchMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public void preDispatchKeyEvent(KeyEvent keyEvent, int n) {
        InvokeDynamicSupport.bootstrap("preDispatchKeyEvent", $$robo$$android_media_AudioManager$preDispatchKeyEvent(android.view.KeyEvent int ), 0, this, keyEvent, n);
    }

    public boolean isVolumeFixed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolumeFixed", $$robo$$android_media_AudioManager$isVolumeFixed(), 0, this);
    }

    public void adjustStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("adjustStreamVolume", $$robo$$android_media_AudioManager$adjustStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    public void adjustVolume(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustVolume", $$robo$$android_media_AudioManager$adjustVolume(int int ), 0, this, n, n2);
    }

    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("adjustSuggestedStreamVolume", $$robo$$android_media_AudioManager$adjustSuggestedStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    public void setMasterMute(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setMasterMute", $$robo$$android_media_AudioManager$setMasterMute(boolean int ), 0, this, bl, n);
    }

    public int getRingerMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRingerMode", $$robo$$android_media_AudioManager$getRingerMode(), 0, this);
    }

    public static boolean isValidRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidRingerMode", $$robo$$android_media_AudioManager$isValidRingerMode(int ), 0, (int)n);
    }

    public int getStreamMaxVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamMaxVolume", $$robo$$android_media_AudioManager$getStreamMaxVolume(int ), 0, this, n);
    }

    public int getStreamMinVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamMinVolume", $$robo$$android_media_AudioManager$getStreamMinVolume(int ), 0, this, n);
    }

    public int getStreamMinVolumeInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamMinVolumeInt", $$robo$$android_media_AudioManager$getStreamMinVolumeInt(int ), 0, this, n);
    }

    public int getStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStreamVolume", $$robo$$android_media_AudioManager$getStreamVolume(int ), 0, this, n);
    }

    public float getStreamVolumeDb(int n, int n2, int n3) {
        return (float)InvokeDynamicSupport.bootstrap("getStreamVolumeDb", $$robo$$android_media_AudioManager$getStreamVolumeDb(int int int ), 0, this, n, n2, n3);
    }

    private static boolean isPublicStreamType(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPublicStreamType", $$robo$$android_media_AudioManager$isPublicStreamType(int ), 0, (int)n);
    }

    public int getLastAudibleStreamVolume(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLastAudibleStreamVolume", $$robo$$android_media_AudioManager$getLastAudibleStreamVolume(int ), 0, this, n);
    }

    public int getUiSoundsStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getUiSoundsStreamType", $$robo$$android_media_AudioManager$getUiSoundsStreamType(), 0, this);
    }

    public void setRingerMode(int n) {
        InvokeDynamicSupport.bootstrap("setRingerMode", $$robo$$android_media_AudioManager$setRingerMode(int ), 0, this, n);
    }

    public void setStreamVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setStreamVolume", $$robo$$android_media_AudioManager$setStreamVolume(int int int ), 0, this, n, n2, n3);
    }

    @Deprecated
    public void setStreamSolo(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStreamSolo", $$robo$$android_media_AudioManager$setStreamSolo(int boolean ), 0, this, n, bl);
    }

    @Deprecated
    public void setStreamMute(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setStreamMute", $$robo$$android_media_AudioManager$setStreamMute(int boolean ), 0, this, n, bl);
    }

    public boolean isStreamMute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamMute", $$robo$$android_media_AudioManager$isStreamMute(int ), 0, this, n);
    }

    public boolean isMasterMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMasterMute", $$robo$$android_media_AudioManager$isMasterMute(), 0, this);
    }

    public void forceVolumeControlStream(int n) {
        InvokeDynamicSupport.bootstrap("forceVolumeControlStream", $$robo$$android_media_AudioManager$forceVolumeControlStream(int ), 0, this, n);
    }

    public boolean shouldVibrate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldVibrate", $$robo$$android_media_AudioManager$shouldVibrate(int ), 0, this, n);
    }

    public int getVibrateSetting(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVibrateSetting", $$robo$$android_media_AudioManager$getVibrateSetting(int ), 0, this, n);
    }

    public void setVibrateSetting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVibrateSetting", $$robo$$android_media_AudioManager$setVibrateSetting(int int ), 0, this, n, n2);
    }

    public void setSpeakerphoneOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpeakerphoneOn", $$robo$$android_media_AudioManager$setSpeakerphoneOn(boolean ), 0, this, bl);
    }

    public boolean isSpeakerphoneOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpeakerphoneOn", $$robo$$android_media_AudioManager$isSpeakerphoneOn(), 0, this);
    }

    public boolean isOffloadedPlaybackSupported(AudioFormat audioFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffloadedPlaybackSupported", $$robo$$android_media_AudioManager$isOffloadedPlaybackSupported(android.media.AudioFormat ), 0, this, audioFormat);
    }

    public boolean isBluetoothScoAvailableOffCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothScoAvailableOffCall", $$robo$$android_media_AudioManager$isBluetoothScoAvailableOffCall(), 0, this);
    }

    public void startBluetoothSco() {
        InvokeDynamicSupport.bootstrap("startBluetoothSco", $$robo$$android_media_AudioManager$startBluetoothSco(), 0, this);
    }

    public void startBluetoothScoVirtualCall() {
        InvokeDynamicSupport.bootstrap("startBluetoothScoVirtualCall", $$robo$$android_media_AudioManager$startBluetoothScoVirtualCall(), 0, this);
    }

    public void stopBluetoothSco() {
        InvokeDynamicSupport.bootstrap("stopBluetoothSco", $$robo$$android_media_AudioManager$stopBluetoothSco(), 0, this);
    }

    public void setBluetoothScoOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothScoOn", $$robo$$android_media_AudioManager$setBluetoothScoOn(boolean ), 0, this, bl);
    }

    public boolean isBluetoothScoOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothScoOn", $$robo$$android_media_AudioManager$isBluetoothScoOn(), 0, this);
    }

    @Deprecated
    public void setBluetoothA2dpOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothA2dpOn", $$robo$$android_media_AudioManager$setBluetoothA2dpOn(boolean ), 0, this, bl);
    }

    public boolean isBluetoothA2dpOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothA2dpOn", $$robo$$android_media_AudioManager$isBluetoothA2dpOn(), 0, this);
    }

    @Deprecated
    public void setWiredHeadsetOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWiredHeadsetOn", $$robo$$android_media_AudioManager$setWiredHeadsetOn(boolean ), 0, this, bl);
    }

    public boolean isWiredHeadsetOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWiredHeadsetOn", $$robo$$android_media_AudioManager$isWiredHeadsetOn(), 0, this);
    }

    public void setMicrophoneMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMicrophoneMute", $$robo$$android_media_AudioManager$setMicrophoneMute(boolean ), 0, this, bl);
    }

    public boolean isMicrophoneMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMicrophoneMute", $$robo$$android_media_AudioManager$isMicrophoneMute(), 0, this);
    }

    public void setMode(int n) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_media_AudioManager$setMode(int ), 0, this, n);
    }

    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_media_AudioManager$getMode(), 0, this);
    }

    @Deprecated
    public void setRouting(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setRouting", $$robo$$android_media_AudioManager$setRouting(int int int ), 0, this, n, n2, n3);
    }

    @Deprecated
    public int getRouting(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRouting", $$robo$$android_media_AudioManager$getRouting(int ), 0, this, n);
    }

    public boolean isMusicActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMusicActive", $$robo$$android_media_AudioManager$isMusicActive(), 0, this);
    }

    public boolean isMusicActiveRemotely() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMusicActiveRemotely", $$robo$$android_media_AudioManager$isMusicActiveRemotely(), 0, this);
    }

    public boolean isAudioFocusExclusive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioFocusExclusive", $$robo$$android_media_AudioManager$isAudioFocusExclusive(), 0, this);
    }

    public int generateAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("generateAudioSessionId", $$robo$$android_media_AudioManager$generateAudioSessionId(), 0, this);
    }

    @Deprecated
    public void setParameter(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_AudioManager$setParameter(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setParameters(String string2) {
        InvokeDynamicSupport.bootstrap("setParameters", $$robo$$android_media_AudioManager$setParameters(java.lang.String ), 0, this, string2);
    }

    public String getParameters(String string2) {
        return InvokeDynamicSupport.bootstrap("getParameters", $$robo$$android_media_AudioManager$getParameters(java.lang.String ), 0, this, string2);
    }

    public void playSoundEffect(int n) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int ), 0, this, n);
    }

    public void playSoundEffect(int n, int n2) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int int ), 0, this, n, n2);
    }

    public void playSoundEffect(int n, float f) {
        InvokeDynamicSupport.bootstrap("playSoundEffect", $$robo$$android_media_AudioManager$playSoundEffect(int float ), 0, this, n, f);
    }

    private boolean querySoundEffectsEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("querySoundEffectsEnabled", $$robo$$android_media_AudioManager$querySoundEffectsEnabled(int ), 0, this, n);
    }

    public void loadSoundEffects() {
        InvokeDynamicSupport.bootstrap("loadSoundEffects", $$robo$$android_media_AudioManager$loadSoundEffects(), 0, this);
    }

    public void unloadSoundEffects() {
        InvokeDynamicSupport.bootstrap("unloadSoundEffects", $$robo$$android_media_AudioManager$unloadSoundEffects(), 0, this);
    }

    private FocusRequestInfo findFocusRequestInfo(String string2) {
        return InvokeDynamicSupport.bootstrap("findFocusRequestInfo", $$robo$$android_media_AudioManager$findFocusRequestInfo(java.lang.String ), 0, this, string2);
    }

    private String getIdForAudioFocusListener(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        return InvokeDynamicSupport.bootstrap("getIdForAudioFocusListener", $$robo$$android_media_AudioManager$getIdForAudioFocusListener(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    public void registerAudioFocusRequest(AudioFocusRequest audioFocusRequest) {
        InvokeDynamicSupport.bootstrap("registerAudioFocusRequest", $$robo$$android_media_AudioManager$registerAudioFocusRequest(android.media.AudioFocusRequest ), 0, this, audioFocusRequest);
    }

    public void unregisterAudioFocusRequest(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        InvokeDynamicSupport.bootstrap("unregisterAudioFocusRequest", $$robo$$android_media_AudioManager$unregisterAudioFocusRequest(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener int int ), 0, this, onAudioFocusChangeListener, n, n2);
    }

    public int requestAudioFocus(AudioFocusRequest audioFocusRequest) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioFocusRequest ), 0, this, audioFocusRequest);
    }

    public int abandonAudioFocusRequest(AudioFocusRequest audioFocusRequest) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocusRequest", $$robo$$android_media_AudioManager$abandonAudioFocusRequest(android.media.AudioFocusRequest ), 0, this, audioFocusRequest);
    }

    @SystemApi
    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, AudioAttributes audioAttributes, int n, int n2) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener android.media.AudioAttributes int int ), 0, this, onAudioFocusChangeListener, audioAttributes, n, n2);
    }

    @SystemApi
    public int requestAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, AudioAttributes audioAttributes, int n, int n2, AudioPolicy audioPolicy) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener android.media.AudioAttributes int int android.media.audiopolicy.AudioPolicy ), 0, this, onAudioFocusChangeListener, audioAttributes, n, n2, audioPolicy);
    }

    @SystemApi
    public int requestAudioFocus(AudioFocusRequest audioFocusRequest, AudioPolicy audioPolicy) {
        return (int)InvokeDynamicSupport.bootstrap("requestAudioFocus", $$robo$$android_media_AudioManager$requestAudioFocus(android.media.AudioFocusRequest android.media.audiopolicy.AudioPolicy ), 0, this, audioFocusRequest, audioPolicy);
    }

    public void requestAudioFocusForCall(int n, int n2) {
        InvokeDynamicSupport.bootstrap("requestAudioFocusForCall", $$robo$$android_media_AudioManager$requestAudioFocusForCall(int int ), 0, this, n, n2);
    }

    public int getFocusRampTimeMs(int n, AudioAttributes audioAttributes) {
        return (int)InvokeDynamicSupport.bootstrap("getFocusRampTimeMs", $$robo$$android_media_AudioManager$getFocusRampTimeMs(int android.media.AudioAttributes ), 0, this, n, audioAttributes);
    }

    @SystemApi
    public void setFocusRequestResult(AudioFocusInfo audioFocusInfo, int n, AudioPolicy audioPolicy) {
        InvokeDynamicSupport.bootstrap("setFocusRequestResult", $$robo$$android_media_AudioManager$setFocusRequestResult(android.media.AudioFocusInfo int android.media.audiopolicy.AudioPolicy ), 0, this, audioFocusInfo, n, audioPolicy);
    }

    @SystemApi
    public int dispatchAudioFocusChange(AudioFocusInfo audioFocusInfo, int n, AudioPolicy audioPolicy) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchAudioFocusChange", $$robo$$android_media_AudioManager$dispatchAudioFocusChange(android.media.AudioFocusInfo int android.media.audiopolicy.AudioPolicy ), 0, this, audioFocusInfo, n, audioPolicy);
    }

    public void abandonAudioFocusForCall() {
        InvokeDynamicSupport.bootstrap("abandonAudioFocusForCall", $$robo$$android_media_AudioManager$abandonAudioFocusForCall(), 0, this);
    }

    public int abandonAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocus", $$robo$$android_media_AudioManager$abandonAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener ), 0, this, onAudioFocusChangeListener);
    }

    @SystemApi
    public int abandonAudioFocus(OnAudioFocusChangeListener onAudioFocusChangeListener, AudioAttributes audioAttributes) {
        return (int)InvokeDynamicSupport.bootstrap("abandonAudioFocus", $$robo$$android_media_AudioManager$abandonAudioFocus(android.media.AudioManager$OnAudioFocusChangeListener android.media.AudioAttributes ), 0, this, onAudioFocusChangeListener, audioAttributes);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonEventReceiver", $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(android.content.ComponentName ), 0, this, componentName);
    }

    @Deprecated
    public void registerMediaButtonEventReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonEventReceiver", $$robo$$android_media_AudioManager$registerMediaButtonEventReceiver(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void registerMediaButtonIntent(PendingIntent pendingIntent, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("registerMediaButtonIntent", $$robo$$android_media_AudioManager$registerMediaButtonIntent(android.app.PendingIntent android.content.ComponentName ), 0, this, pendingIntent, componentName);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonEventReceiver", $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(android.content.ComponentName ), 0, this, componentName);
    }

    @Deprecated
    public void unregisterMediaButtonEventReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonEventReceiver", $$robo$$android_media_AudioManager$unregisterMediaButtonEventReceiver(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void unregisterMediaButtonIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("unregisterMediaButtonIntent", $$robo$$android_media_AudioManager$unregisterMediaButtonIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    @Deprecated
    public void registerRemoteControlClient(RemoteControlClient remoteControlClient) {
        InvokeDynamicSupport.bootstrap("registerRemoteControlClient", $$robo$$android_media_AudioManager$registerRemoteControlClient(android.media.RemoteControlClient ), 0, this, remoteControlClient);
    }

    @Deprecated
    public void unregisterRemoteControlClient(RemoteControlClient remoteControlClient) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteControlClient", $$robo$$android_media_AudioManager$unregisterRemoteControlClient(android.media.RemoteControlClient ), 0, this, remoteControlClient);
    }

    @Deprecated
    public boolean registerRemoteController(RemoteController remoteController) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerRemoteController", $$robo$$android_media_AudioManager$registerRemoteController(android.media.RemoteController ), 0, this, remoteController);
    }

    @Deprecated
    public void unregisterRemoteController(RemoteController remoteController) {
        InvokeDynamicSupport.bootstrap("unregisterRemoteController", $$robo$$android_media_AudioManager$unregisterRemoteController(android.media.RemoteController ), 0, this, remoteController);
    }

    @SystemApi
    public int registerAudioPolicy(AudioPolicy audioPolicy) {
        return (int)InvokeDynamicSupport.bootstrap("registerAudioPolicy", $$robo$$android_media_AudioManager$registerAudioPolicy(android.media.audiopolicy.AudioPolicy ), 0, this, audioPolicy);
    }

    @SystemApi
    public void unregisterAudioPolicyAsync(AudioPolicy audioPolicy) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPolicyAsync", $$robo$$android_media_AudioManager$unregisterAudioPolicyAsync(android.media.audiopolicy.AudioPolicy ), 0, this, audioPolicy);
    }

    public void registerAudioPlaybackCallback(AudioPlaybackCallback audioPlaybackCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAudioPlaybackCallback", $$robo$$android_media_AudioManager$registerAudioPlaybackCallback(android.media.AudioManager$AudioPlaybackCallback android.os.Handler ), 0, this, audioPlaybackCallback, handler);
    }

    public void unregisterAudioPlaybackCallback(AudioPlaybackCallback audioPlaybackCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPlaybackCallback", $$robo$$android_media_AudioManager$unregisterAudioPlaybackCallback(android.media.AudioManager$AudioPlaybackCallback ), 0, this, audioPlaybackCallback);
    }

    public List<AudioPlaybackConfiguration> getActivePlaybackConfigurations() {
        return InvokeDynamicSupport.bootstrap("getActivePlaybackConfigurations", $$robo$$android_media_AudioManager$getActivePlaybackConfigurations(), 0, this);
    }

    private boolean hasPlaybackCallback_sync(AudioPlaybackCallback audioPlaybackCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPlaybackCallback_sync", $$robo$$android_media_AudioManager$hasPlaybackCallback_sync(android.media.AudioManager$AudioPlaybackCallback ), 0, this, audioPlaybackCallback);
    }

    private boolean removePlaybackCallback_sync(AudioPlaybackCallback audioPlaybackCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("removePlaybackCallback_sync", $$robo$$android_media_AudioManager$removePlaybackCallback_sync(android.media.AudioManager$AudioPlaybackCallback ), 0, this, audioPlaybackCallback);
    }

    public void registerAudioRecordingCallback(AudioRecordingCallback audioRecordingCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAudioRecordingCallback", $$robo$$android_media_AudioManager$registerAudioRecordingCallback(android.media.AudioManager$AudioRecordingCallback android.os.Handler ), 0, this, audioRecordingCallback, handler);
    }

    public void unregisterAudioRecordingCallback(AudioRecordingCallback audioRecordingCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAudioRecordingCallback", $$robo$$android_media_AudioManager$unregisterAudioRecordingCallback(android.media.AudioManager$AudioRecordingCallback ), 0, this, audioRecordingCallback);
    }

    public List<AudioRecordingConfiguration> getActiveRecordingConfigurations() {
        return InvokeDynamicSupport.bootstrap("getActiveRecordingConfigurations", $$robo$$android_media_AudioManager$getActiveRecordingConfigurations(), 0, this);
    }

    private boolean hasRecordCallback_sync(AudioRecordingCallback audioRecordingCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRecordCallback_sync", $$robo$$android_media_AudioManager$hasRecordCallback_sync(android.media.AudioManager$AudioRecordingCallback ), 0, this, audioRecordingCallback);
    }

    private boolean removeRecordCallback_sync(AudioRecordingCallback audioRecordingCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeRecordCallback_sync", $$robo$$android_media_AudioManager$removeRecordCallback_sync(android.media.AudioManager$AudioRecordingCallback ), 0, this, audioRecordingCallback);
    }

    public void reloadAudioSettings() {
        InvokeDynamicSupport.bootstrap("reloadAudioSettings", $$robo$$android_media_AudioManager$reloadAudioSettings(), 0, this);
    }

    public void avrcpSupportsAbsoluteVolume(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("avrcpSupportsAbsoluteVolume", $$robo$$android_media_AudioManager$avrcpSupportsAbsoluteVolume(java.lang.String boolean ), 0, this, string2, bl);
    }

    public boolean isSilentMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSilentMode", $$robo$$android_media_AudioManager$isSilentMode(), 0, this);
    }

    public static boolean isOutputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOutputDevice", $$robo$$android_media_AudioManager$isOutputDevice(int ), 0, (int)n);
    }

    public static boolean isInputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInputDevice", $$robo$$android_media_AudioManager$isInputDevice(int ), 0, (int)n);
    }

    public int getDevicesForStream(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDevicesForStream", $$robo$$android_media_AudioManager$getDevicesForStream(int ), 0, this, n);
    }

    public void setWiredDeviceConnectionState(int n, int n2, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setWiredDeviceConnectionState", $$robo$$android_media_AudioManager$setWiredDeviceConnectionState(int int java.lang.String java.lang.String ), 0, this, n, n2, string2, string3);
    }

    public void setHearingAidDeviceConnectionState(BluetoothDevice bluetoothDevice, int n) {
        InvokeDynamicSupport.bootstrap("setHearingAidDeviceConnectionState", $$robo$$android_media_AudioManager$setHearingAidDeviceConnectionState(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice bluetoothDevice, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setBluetoothA2dpDeviceConnectionState", $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionState(android.bluetooth.BluetoothDevice int int ), 0, this, bluetoothDevice, n, n2);
    }

    public int setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(BluetoothDevice bluetoothDevice, int n, int n2, boolean bl, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent", $$robo$$android_media_AudioManager$setBluetoothA2dpDeviceConnectionStateSuppressNoisyIntent(android.bluetooth.BluetoothDevice int int boolean int ), 0, this, bluetoothDevice, n, n2, bl, n3);
    }

    public void handleBluetoothA2dpDeviceConfigChange(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("handleBluetoothA2dpDeviceConfigChange", $$robo$$android_media_AudioManager$handleBluetoothA2dpDeviceConfigChange(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public IRingtonePlayer getRingtonePlayer() {
        return InvokeDynamicSupport.bootstrap("getRingtonePlayer", $$robo$$android_media_AudioManager$getRingtonePlayer(), 0, this);
    }

    public String getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$android_media_AudioManager$getProperty(java.lang.String ), 0, this, string2);
    }

    public int getOutputLatency(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOutputLatency", $$robo$$android_media_AudioManager$getOutputLatency(int ), 0, this, n);
    }

    public void setVolumeController(IVolumeController iVolumeController) {
        InvokeDynamicSupport.bootstrap("setVolumeController", $$robo$$android_media_AudioManager$setVolumeController(android.media.IVolumeController ), 0, this, iVolumeController);
    }

    public void notifyVolumeControllerVisible(IVolumeController iVolumeController, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyVolumeControllerVisible", $$robo$$android_media_AudioManager$notifyVolumeControllerVisible(android.media.IVolumeController boolean ), 0, this, iVolumeController, bl);
    }

    public boolean isStreamAffectedByRingerMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamAffectedByRingerMode", $$robo$$android_media_AudioManager$isStreamAffectedByRingerMode(int ), 0, this, n);
    }

    public boolean isStreamAffectedByMute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreamAffectedByMute", $$robo$$android_media_AudioManager$isStreamAffectedByMute(int ), 0, this, n);
    }

    public void disableSafeMediaVolume() {
        InvokeDynamicSupport.bootstrap("disableSafeMediaVolume", $$robo$$android_media_AudioManager$disableSafeMediaVolume(), 0, this);
    }

    public void setRingerModeInternal(int n) {
        InvokeDynamicSupport.bootstrap("setRingerModeInternal", $$robo$$android_media_AudioManager$setRingerModeInternal(int ), 0, this, n);
    }

    public int getRingerModeInternal() {
        return (int)InvokeDynamicSupport.bootstrap("getRingerModeInternal", $$robo$$android_media_AudioManager$getRingerModeInternal(), 0, this);
    }

    public void setVolumePolicy(VolumePolicy volumePolicy) {
        InvokeDynamicSupport.bootstrap("setVolumePolicy", $$robo$$android_media_AudioManager$setVolumePolicy(android.media.VolumePolicy ), 0, this, volumePolicy);
    }

    public int setHdmiSystemAudioSupported(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setHdmiSystemAudioSupported", $$robo$$android_media_AudioManager$setHdmiSystemAudioSupported(boolean ), 0, this, bl);
    }

    @SystemApi
    public boolean isHdmiSystemAudioSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHdmiSystemAudioSupported", $$robo$$android_media_AudioManager$isHdmiSystemAudioSupported(), 0, this);
    }

    public static int listAudioPorts(ArrayList<AudioPort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listAudioPorts", $$robo$$android_media_AudioManager$listAudioPorts(java.util.ArrayList<android.media.AudioPort> ), 0, arrayList);
    }

    public static int listPreviousAudioPorts(ArrayList<AudioPort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listPreviousAudioPorts", $$robo$$android_media_AudioManager$listPreviousAudioPorts(java.util.ArrayList<android.media.AudioPort> ), 0, arrayList);
    }

    public static int listAudioDevicePorts(ArrayList<AudioDevicePort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listAudioDevicePorts", $$robo$$android_media_AudioManager$listAudioDevicePorts(java.util.ArrayList<android.media.AudioDevicePort> ), 0, arrayList);
    }

    public static int listPreviousAudioDevicePorts(ArrayList<AudioDevicePort> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listPreviousAudioDevicePorts", $$robo$$android_media_AudioManager$listPreviousAudioDevicePorts(java.util.ArrayList<android.media.AudioDevicePort> ), 0, arrayList);
    }

    private static void filterDevicePorts(ArrayList<AudioPort> arrayList, ArrayList<AudioDevicePort> arrayList2) {
        InvokeDynamicSupport.bootstrapStatic("filterDevicePorts", $$robo$$android_media_AudioManager$filterDevicePorts(java.util.ArrayList<android.media.AudioPort> java.util.ArrayList<android.media.AudioDevicePort> ), 0, arrayList, arrayList2);
    }

    public static int createAudioPatch(AudioPatch[] audioPatchArray, AudioPortConfig[] audioPortConfigArray, AudioPortConfig[] audioPortConfigArray2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("createAudioPatch", $$robo$$android_media_AudioManager$createAudioPatch(android.media.AudioPatch[] android.media.AudioPortConfig[] android.media.AudioPortConfig[] ), 0, (AudioPatch[])audioPatchArray, (AudioPortConfig[])audioPortConfigArray, (AudioPortConfig[])audioPortConfigArray2);
    }

    public static int releaseAudioPatch(AudioPatch audioPatch) {
        return (int)InvokeDynamicSupport.bootstrapStatic("releaseAudioPatch", $$robo$$android_media_AudioManager$releaseAudioPatch(android.media.AudioPatch ), 0, (AudioPatch)audioPatch);
    }

    public static int listAudioPatches(ArrayList<AudioPatch> arrayList) {
        return (int)InvokeDynamicSupport.bootstrapStatic("listAudioPatches", $$robo$$android_media_AudioManager$listAudioPatches(java.util.ArrayList<android.media.AudioPatch> ), 0, arrayList);
    }

    public static int setAudioPortGain(AudioPort audioPort, AudioGainConfig audioGainConfig) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setAudioPortGain", $$robo$$android_media_AudioManager$setAudioPortGain(android.media.AudioPort android.media.AudioGainConfig ), 0, (AudioPort)audioPort, (AudioGainConfig)audioGainConfig);
    }

    public void registerAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        InvokeDynamicSupport.bootstrap("registerAudioPortUpdateListener", $$robo$$android_media_AudioManager$registerAudioPortUpdateListener(android.media.AudioManager$OnAudioPortUpdateListener ), 0, this, onAudioPortUpdateListener);
    }

    public void unregisterAudioPortUpdateListener(OnAudioPortUpdateListener onAudioPortUpdateListener) {
        InvokeDynamicSupport.bootstrap("unregisterAudioPortUpdateListener", $$robo$$android_media_AudioManager$unregisterAudioPortUpdateListener(android.media.AudioManager$OnAudioPortUpdateListener ), 0, this, onAudioPortUpdateListener);
    }

    static int resetAudioPortGeneration() {
        return (int)InvokeDynamicSupport.bootstrapStatic("resetAudioPortGeneration", $$robo$$android_media_AudioManager$resetAudioPortGeneration(), 0);
    }

    static int updateAudioPortCache(ArrayList<AudioPort> arrayList, ArrayList<AudioPatch> arrayList2, ArrayList<AudioPort> arrayList3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("updateAudioPortCache", $$robo$$android_media_AudioManager$updateAudioPortCache(java.util.ArrayList<android.media.AudioPort> java.util.ArrayList<android.media.AudioPatch> java.util.ArrayList<android.media.AudioPort> ), 0, arrayList, arrayList2, arrayList3);
    }

    static AudioPortConfig updatePortConfig(AudioPortConfig audioPortConfig, ArrayList<AudioPort> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("updatePortConfig", $$robo$$android_media_AudioManager$updatePortConfig(android.media.AudioPortConfig java.util.ArrayList<android.media.AudioPort> ), 0, (AudioPortConfig)audioPortConfig, arrayList);
    }

    private static boolean checkFlags(AudioDevicePort audioDevicePort, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkFlags", $$robo$$android_media_AudioManager$checkFlags(android.media.AudioDevicePort int ), 0, (AudioDevicePort)audioDevicePort, (int)n);
    }

    private static boolean checkTypes(AudioDevicePort audioDevicePort) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkTypes", $$robo$$android_media_AudioManager$checkTypes(android.media.AudioDevicePort ), 0, (AudioDevicePort)audioDevicePort);
    }

    public AudioDeviceInfo[] getDevices(int n) {
        return InvokeDynamicSupport.bootstrap("getDevices", $$robo$$android_media_AudioManager$getDevices(int ), 0, this, n);
    }

    private static AudioDeviceInfo[] infoListFromPortList(ArrayList<AudioDevicePort> arrayList, int n) {
        return InvokeDynamicSupport.bootstrapStatic("infoListFromPortList", $$robo$$android_media_AudioManager$infoListFromPortList(java.util.ArrayList<android.media.AudioDevicePort> int ), 0, arrayList, (int)n);
    }

    private static AudioDeviceInfo[] calcListDeltas(ArrayList<AudioDevicePort> arrayList, ArrayList<AudioDevicePort> arrayList2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("calcListDeltas", $$robo$$android_media_AudioManager$calcListDeltas(java.util.ArrayList<android.media.AudioDevicePort> java.util.ArrayList<android.media.AudioDevicePort> int ), 0, arrayList, arrayList2, (int)n);
    }

    public static AudioDeviceInfo[] getDevicesStatic(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDevicesStatic", $$robo$$android_media_AudioManager$getDevicesStatic(int ), 0, (int)n);
    }

    public void registerAudioDeviceCallback(AudioDeviceCallback audioDeviceCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAudioDeviceCallback", $$robo$$android_media_AudioManager$registerAudioDeviceCallback(android.media.AudioDeviceCallback android.os.Handler ), 0, this, audioDeviceCallback, handler);
    }

    public void unregisterAudioDeviceCallback(AudioDeviceCallback audioDeviceCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAudioDeviceCallback", $$robo$$android_media_AudioManager$unregisterAudioDeviceCallback(android.media.AudioDeviceCallback ), 0, this, audioDeviceCallback);
    }

    public static void setPortIdForMicrophones(ArrayList<MicrophoneInfo> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("setPortIdForMicrophones", $$robo$$android_media_AudioManager$setPortIdForMicrophones(java.util.ArrayList<android.media.MicrophoneInfo> ), 0, arrayList);
    }

    public static MicrophoneInfo microphoneInfoFromAudioDeviceInfo(AudioDeviceInfo audioDeviceInfo) {
        return InvokeDynamicSupport.bootstrapStatic("microphoneInfoFromAudioDeviceInfo", $$robo$$android_media_AudioManager$microphoneInfoFromAudioDeviceInfo(android.media.AudioDeviceInfo ), 0, (AudioDeviceInfo)audioDeviceInfo);
    }

    private void addMicrophonesFromAudioDeviceInfo(ArrayList<MicrophoneInfo> arrayList, HashSet<Integer> hashSet) {
        InvokeDynamicSupport.bootstrap("addMicrophonesFromAudioDeviceInfo", $$robo$$android_media_AudioManager$addMicrophonesFromAudioDeviceInfo(java.util.ArrayList<android.media.MicrophoneInfo> java.util.HashSet<java.lang.Integer> ), 0, this, arrayList, hashSet);
    }

    public List<MicrophoneInfo> getMicrophones() throws IOException {
        return InvokeDynamicSupport.bootstrap("getMicrophones", $$robo$$android_media_AudioManager$getMicrophones(), 0, this);
    }

    private void broadcastDeviceListChange_sync(Handler handler) {
        InvokeDynamicSupport.bootstrap("broadcastDeviceListChange_sync", $$robo$$android_media_AudioManager$broadcastDeviceListChange_sync(android.os.Handler ), 0, this, handler);
    }

    @SystemApi
    public void setAudioServerStateCallback(Executor executor, AudioServerStateCallback audioServerStateCallback) {
        InvokeDynamicSupport.bootstrap("setAudioServerStateCallback", $$robo$$android_media_AudioManager$setAudioServerStateCallback(java.util.concurrent.Executor android.media.AudioManager$AudioServerStateCallback ), 0, this, executor, audioServerStateCallback);
    }

    @SystemApi
    public void clearAudioServerStateCallback() {
        InvokeDynamicSupport.bootstrap("clearAudioServerStateCallback", $$robo$$android_media_AudioManager$clearAudioServerStateCallback(), 0, this);
    }

    @SystemApi
    public boolean isAudioServerRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioServerRunning", $$robo$$android_media_AudioManager$isAudioServerRunning(), 0, this);
    }

    public Map<Integer, Boolean> getSurroundFormats() {
        return InvokeDynamicSupport.bootstrap("getSurroundFormats", $$robo$$android_media_AudioManager$getSurroundFormats(), 0, this);
    }

    public boolean setSurroundFormatEnabled(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setSurroundFormatEnabled", $$robo$$android_media_AudioManager$setSurroundFormatEnabled(int boolean ), 0, this, n, bl);
    }

    public Map<Integer, Boolean> getReportedSurroundFormats() {
        return InvokeDynamicSupport.bootstrap("getReportedSurroundFormats", $$robo$$android_media_AudioManager$getReportedSurroundFormats(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AudioManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NativeEventHandlerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ AudioManager this$0;

        private void $$robo$$android_media_AudioManager_NativeEventHandlerDelegate$__constructor__(AudioManager audioManager, AudioDeviceCallback callback, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.getMainLooper();
            this.mHandler = looper != null ? new ShadowedObject(this, looper, audioManager, callback){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioManager val$this$0;
                /* synthetic */ AudioDeviceCallback val$callback;
                /* synthetic */ NativeEventHandlerDelegate this$1;

                private void $$robo$$android_media_AudioManager_NativeEventHandlerDelegate_1$__constructor__(NativeEventHandlerDelegate this$1, Looper x0, AudioManager audioManager, AudioDeviceCallback audioDeviceCallback) {
                }

                private final void $$robo$$android_media_AudioManager_NativeEventHandlerDelegate_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: 
                        case 1: {
                            if (this.val$callback == null) break;
                            this.val$callback.onAudioDevicesAdded((AudioDeviceInfo[])msg.obj);
                            break;
                        }
                        case 2: {
                            if (this.val$callback == null) break;
                            this.val$callback.onAudioDevicesRemoved((AudioDeviceInfo[])msg.obj);
                            break;
                        }
                        default: {
                            Log.e("AudioManager", "Unknown native event type: " + msg.what);
                        }
                    }
                }

                private void __constructor__(NativeEventHandlerDelegate nativeEventHandlerDelegate, Looper looper, AudioManager audioManager, AudioDeviceCallback audioDeviceCallback) {
                    this.$$robo$$android_media_AudioManager_NativeEventHandlerDelegate_1$__constructor__(nativeEventHandlerDelegate, looper, audioManager, audioDeviceCallback);
                }
                {
                    this.this$1 = nativeEventHandlerDelegate;
                    this.val$this$0 = audioManager;
                    this.val$callback = audioDeviceCallback;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_NativeEventHandlerDelegate_1$__constructor__(android.media.AudioManager$NativeEventHandlerDelegate android.os.Looper android.media.AudioManager android.media.AudioDeviceCallback ), 0, this, nativeEventHandlerDelegate, looper, audioManager, audioDeviceCallback);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioManager_NativeEventHandlerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private final Handler $$robo$$android_media_AudioManager_NativeEventHandlerDelegate$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(AudioManager audioManager, AudioDeviceCallback audioDeviceCallback, Handler handler) {
            this.$$robo$$android_media_AudioManager_NativeEventHandlerDelegate$__constructor__(audioManager, audioDeviceCallback, handler);
        }

        NativeEventHandlerDelegate(AudioManager audioManager, AudioDeviceCallback audioDeviceCallback, Handler handler) {
            this.this$0 = audioManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_NativeEventHandlerDelegate$__constructor__(android.media.AudioManager android.media.AudioDeviceCallback android.os.Handler ), 0, this, audioManager, audioDeviceCallback, handler);
        }

        Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_media_AudioManager_NativeEventHandlerDelegate$getHandler(), 0, this);
        }

        public /* synthetic */ NativeEventHandlerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandlerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static abstract class AudioServerStateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_AudioManager_AudioServerStateCallback$__constructor__() {
        }

        private final void $$robo$$android_media_AudioManager_AudioServerStateCallback$onAudioServerDown() {
        }

        private final void $$robo$$android_media_AudioManager_AudioServerStateCallback$onAudioServerUp() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioManager_AudioServerStateCallback$__constructor__();
        }

        public AudioServerStateCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_AudioServerStateCallback$__constructor__(), 0, this);
        }

        public void onAudioServerDown() {
            InvokeDynamicSupport.bootstrap("onAudioServerDown", $$robo$$android_media_AudioManager_AudioServerStateCallback$onAudioServerDown(), 0, this);
        }

        public void onAudioServerUp() {
            InvokeDynamicSupport.bootstrap("onAudioServerUp", $$robo$$android_media_AudioManager_AudioServerStateCallback$onAudioServerUp(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioServerStateCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OnAmPortUpdateListener
    implements OnAudioPortUpdateListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static String TAG = "OnAmPortUpdateListener";
        /* synthetic */ AudioManager this$0;

        private void $$robo$$android_media_AudioManager_OnAmPortUpdateListener$__constructor__(AudioManager audioManager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onAudioPortListUpdate(AudioPort[] portList) {
            ArrayMap arrayMap = this.this$0.mDeviceCallbacks;
            synchronized (arrayMap) {
                this.this$0.broadcastDeviceListChange_sync(null);
            }
        }

        private final void $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onAudioPatchListUpdate(AudioPatch[] patchList) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onServiceDied() {
            ArrayMap arrayMap = this.this$0.mDeviceCallbacks;
            synchronized (arrayMap) {
                this.this$0.broadcastDeviceListChange_sync(null);
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioManager_OnAmPortUpdateListener$__constructor__(AudioManager x0, 1 x1) {
        }

        private void __constructor__(AudioManager audioManager) {
            this.$$robo$$android_media_AudioManager_OnAmPortUpdateListener$__constructor__(audioManager);
        }

        private OnAmPortUpdateListener(AudioManager audioManager) {
            this.this$0 = audioManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_OnAmPortUpdateListener$__constructor__(android.media.AudioManager ), 0, this, audioManager);
        }

        @Override
        public void onAudioPortListUpdate(AudioPort[] audioPortArray) {
            InvokeDynamicSupport.bootstrap("onAudioPortListUpdate", $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onAudioPortListUpdate(android.media.AudioPort[] ), 0, this, audioPortArray);
        }

        @Override
        public void onAudioPatchListUpdate(AudioPatch[] audioPatchArray) {
            InvokeDynamicSupport.bootstrap("onAudioPatchListUpdate", $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onAudioPatchListUpdate(android.media.AudioPatch[] ), 0, this, audioPatchArray);
        }

        @Override
        public void onServiceDied() {
            InvokeDynamicSupport.bootstrap("onServiceDied", $$robo$$android_media_AudioManager_OnAmPortUpdateListener$onServiceDied(), 0, this);
        }

        private /* synthetic */ void __constructor__(AudioManager audioManager, 1 var2_2) {
            this.$$robo$$android_media_AudioManager_OnAmPortUpdateListener$__constructor__(audioManager, var2_2);
        }

        public /* synthetic */ OnAmPortUpdateListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnAmPortUpdateListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnAudioPortUpdateListener
    extends InstrumentedInterface {
        public void onAudioPortListUpdate(AudioPort[] var1);

        public void onAudioPatchListUpdate(AudioPatch[] var1);

        public void onServiceDied();
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RecordConfigChangeCallbackData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AudioRecordingCallback mCb;
        List<AudioRecordingConfiguration> mConfigs;

        private void $$robo$$android_media_AudioManager_RecordConfigChangeCallbackData$__constructor__(AudioRecordingCallback cb, List<AudioRecordingConfiguration> configs) {
            this.mCb = cb;
            this.mConfigs = configs;
        }

        private void __constructor__(AudioRecordingCallback audioRecordingCallback, List<AudioRecordingConfiguration> list) {
            this.$$robo$$android_media_AudioManager_RecordConfigChangeCallbackData$__constructor__(audioRecordingCallback, list);
        }

        RecordConfigChangeCallbackData(AudioRecordingCallback audioRecordingCallback, List<AudioRecordingConfiguration> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_RecordConfigChangeCallbackData$__constructor__(android.media.AudioManager$AudioRecordingCallback java.util.List<android.media.AudioRecordingConfiguration> ), 0, this, audioRecordingCallback, list);
        }

        public /* synthetic */ RecordConfigChangeCallbackData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecordConfigChangeCallbackData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AudioRecordingCallbackInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AudioRecordingCallback mCb;
        Handler mHandler;

        private void $$robo$$android_media_AudioManager_AudioRecordingCallbackInfo$__constructor__(AudioRecordingCallback cb, Handler handler) {
            this.mCb = cb;
            this.mHandler = handler;
        }

        private void __constructor__(AudioRecordingCallback audioRecordingCallback, Handler handler) {
            this.$$robo$$android_media_AudioManager_AudioRecordingCallbackInfo$__constructor__(audioRecordingCallback, handler);
        }

        AudioRecordingCallbackInfo(AudioRecordingCallback audioRecordingCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_AudioRecordingCallbackInfo$__constructor__(android.media.AudioManager$AudioRecordingCallback android.os.Handler ), 0, this, audioRecordingCallback, handler);
        }

        public /* synthetic */ AudioRecordingCallbackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecordingCallbackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AudioRecordingCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_AudioManager_AudioRecordingCallback$__constructor__() {
        }

        private final void $$robo$$android_media_AudioManager_AudioRecordingCallback$onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioManager_AudioRecordingCallback$__constructor__();
        }

        public AudioRecordingCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_AudioRecordingCallback$__constructor__(), 0, this);
        }

        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> list) {
            InvokeDynamicSupport.bootstrap("onRecordingConfigChanged", $$robo$$android_media_AudioManager_AudioRecordingCallback$onRecordingConfigChanged(java.util.List<android.media.AudioRecordingConfiguration> ), 0, this, list);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecordingCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class PlaybackConfigChangeCallbackData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AudioPlaybackCallback mCb;
        List<AudioPlaybackConfiguration> mConfigs;

        private void $$robo$$android_media_AudioManager_PlaybackConfigChangeCallbackData$__constructor__(AudioPlaybackCallback cb, List<AudioPlaybackConfiguration> configs) {
            this.mCb = cb;
            this.mConfigs = configs;
        }

        private void __constructor__(AudioPlaybackCallback audioPlaybackCallback, List<AudioPlaybackConfiguration> list) {
            this.$$robo$$android_media_AudioManager_PlaybackConfigChangeCallbackData$__constructor__(audioPlaybackCallback, list);
        }

        PlaybackConfigChangeCallbackData(AudioPlaybackCallback audioPlaybackCallback, List<AudioPlaybackConfiguration> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_PlaybackConfigChangeCallbackData$__constructor__(android.media.AudioManager$AudioPlaybackCallback java.util.List<android.media.AudioPlaybackConfiguration> ), 0, this, audioPlaybackCallback, list);
        }

        public /* synthetic */ PlaybackConfigChangeCallbackData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlaybackConfigChangeCallbackData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AudioPlaybackCallbackInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AudioPlaybackCallback mCb;
        Handler mHandler;

        private void $$robo$$android_media_AudioManager_AudioPlaybackCallbackInfo$__constructor__(AudioPlaybackCallback cb, Handler handler) {
            this.mCb = cb;
            this.mHandler = handler;
        }

        private void __constructor__(AudioPlaybackCallback audioPlaybackCallback, Handler handler) {
            this.$$robo$$android_media_AudioManager_AudioPlaybackCallbackInfo$__constructor__(audioPlaybackCallback, handler);
        }

        AudioPlaybackCallbackInfo(AudioPlaybackCallback audioPlaybackCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_AudioPlaybackCallbackInfo$__constructor__(android.media.AudioManager$AudioPlaybackCallback android.os.Handler ), 0, this, audioPlaybackCallback, handler);
        }

        public /* synthetic */ AudioPlaybackCallbackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPlaybackCallbackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AudioPlaybackCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_AudioManager_AudioPlaybackCallback$__constructor__() {
        }

        private final void $$robo$$android_media_AudioManager_AudioPlaybackCallback$onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioManager_AudioPlaybackCallback$__constructor__();
        }

        public AudioPlaybackCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_AudioPlaybackCallback$__constructor__(), 0, this);
        }

        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> list) {
            InvokeDynamicSupport.bootstrap("onPlaybackConfigChanged", $$robo$$android_media_AudioManager_AudioPlaybackCallback$onPlaybackConfigChanged(java.util.List<android.media.AudioPlaybackConfiguration> ), 0, this, list);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPlaybackCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class BlockingFocusResultReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SafeWaitObject mLock;
        @GuardedBy(value="mLock")
        private boolean mResultReceived;
        private int mFocusRequestResult;
        private String mFocusClientId;

        private void $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$__constructor__(String clientId) {
            this.mLock = new SafeWaitObject();
            this.mResultReceived = false;
            this.mFocusRequestResult = 0;
            this.mFocusClientId = clientId;
        }

        private final boolean $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$receivedResult() {
            return this.mResultReceived;
        }

        private final int $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$requestResult() {
            return this.mFocusRequestResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$notifyResult(int requestResult) {
            SafeWaitObject safeWaitObject = this.mLock;
            synchronized (safeWaitObject) {
                this.mResultReceived = true;
                this.mFocusRequestResult = requestResult;
                this.mLock.safeNotify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$waitForResult(long timeOutMs) {
            SafeWaitObject safeWaitObject = this.mLock;
            synchronized (safeWaitObject) {
                if (this.mResultReceived) {
                    return;
                }
                try {
                    this.mLock.safeWait(timeOutMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_media_AudioManager_BlockingFocusResultReceiver$__constructor__(string2);
        }

        BlockingFocusResultReceiver(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$__constructor__(java.lang.String ), 0, this, string2);
        }

        boolean receivedResult() {
            return (boolean)InvokeDynamicSupport.bootstrap("receivedResult", $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$receivedResult(), 0, this);
        }

        int requestResult() {
            return (int)InvokeDynamicSupport.bootstrap("requestResult", $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$requestResult(), 0, this);
        }

        void notifyResult(int n) {
            InvokeDynamicSupport.bootstrap("notifyResult", $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$notifyResult(int ), 0, this, n);
        }

        public void waitForResult(long l) {
            InvokeDynamicSupport.bootstrap("waitForResult", $$robo$$android_media_AudioManager_BlockingFocusResultReceiver$waitForResult(long ), 0, this, l);
        }

        public /* synthetic */ BlockingFocusResultReceiver() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockingFocusResultReceiver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SafeWaitObject
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mQuit;

        private void $$robo$$android_media_AudioManager_SafeWaitObject$__constructor__() {
            this.mQuit = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_SafeWaitObject$safeNotify() {
            SafeWaitObject safeWaitObject = this;
            synchronized (safeWaitObject) {
                this.mQuit = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioManager_SafeWaitObject$safeWait(long millis) throws InterruptedException {
            reference var3_2 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") + millis;
            SafeWaitObject safeWaitObject = this;
            synchronized (safeWaitObject) {
                reference var6_4;
                while (!this.mQuit && (var6_4 = var3_2 - InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")) >= 0L) {
                    this.wait((long)var6_4);
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_AudioManager_SafeWaitObject$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioManager_SafeWaitObject$__constructor__();
        }

        private SafeWaitObject() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_SafeWaitObject$__constructor__(), 0, this);
        }

        public void safeNotify() {
            InvokeDynamicSupport.bootstrap("safeNotify", $$robo$$android_media_AudioManager_SafeWaitObject$safeNotify(), 0, this);
        }

        public void safeWait(long l) throws InterruptedException {
            InvokeDynamicSupport.bootstrap("safeWait", $$robo$$android_media_AudioManager_SafeWaitObject$safeWait(long ), 0, this, l);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_media_AudioManager_SafeWaitObject$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SafeWaitObject)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FocusRequestResult {
    }

    private class ServiceEventHandlerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        /* synthetic */ AudioManager this$0;

        private void $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate$__constructor__(AudioManager audioManager, Handler handler) {
            Looper looper;
            if (handler == null) {
                looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
            } else {
                looper = handler.getLooper();
            }
            this.mHandler = looper != null ? new ShadowedObject(this, looper, audioManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioManager val$this$0;
                /* synthetic */ ServiceEventHandlerDelegate this$1;

                private void $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate_1$__constructor__(ServiceEventHandlerDelegate this$1, Looper x0, AudioManager audioManager) {
                }

                private final void $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            OnAudioFocusChangeListener listener;
                            FocusRequestInfo fri = this.this$1.this$0.findFocusRequestInfo((String)msg.obj);
                            if (fri == null || (listener = fri.mRequest.getOnAudioFocusChangeListener()) == null) break;
                            Log.d("AudioManager", "dispatching onAudioFocusChange(" + msg.arg1 + ") to " + msg.obj);
                            listener.onAudioFocusChange(msg.arg1);
                            break;
                        }
                        case 1: {
                            RecordConfigChangeCallbackData cbData = (RecordConfigChangeCallbackData)msg.obj;
                            if (cbData.mCb == null) break;
                            cbData.mCb.onRecordingConfigChanged(cbData.mConfigs);
                            break;
                        }
                        case 2: {
                            PlaybackConfigChangeCallbackData cbData = (PlaybackConfigChangeCallbackData)msg.obj;
                            if (cbData.mCb == null) break;
                            cbData.mCb.onPlaybackConfigChanged(cbData.mConfigs);
                            break;
                        }
                        default: {
                            Log.e("AudioManager", "Unknown event " + msg.what);
                        }
                    }
                }

                private void __constructor__(ServiceEventHandlerDelegate serviceEventHandlerDelegate, Looper looper, AudioManager audioManager) {
                    this.$$robo$$android_media_AudioManager_ServiceEventHandlerDelegate_1$__constructor__(serviceEventHandlerDelegate, looper, audioManager);
                }
                {
                    this.this$1 = serviceEventHandlerDelegate;
                    this.val$this$0 = audioManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate_1$__constructor__(android.media.AudioManager$ServiceEventHandlerDelegate android.os.Looper android.media.AudioManager ), 0, this, serviceEventHandlerDelegate, looper, audioManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            } : null;
        }

        private final Handler $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate$getHandler() {
            return this.mHandler;
        }

        private void __constructor__(AudioManager audioManager, Handler handler) {
            this.$$robo$$android_media_AudioManager_ServiceEventHandlerDelegate$__constructor__(audioManager, handler);
        }

        ServiceEventHandlerDelegate(AudioManager audioManager, Handler handler) {
            this.this$0 = audioManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate$__constructor__(android.media.AudioManager android.os.Handler ), 0, this, audioManager, handler);
        }

        Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_media_AudioManager_ServiceEventHandlerDelegate$getHandler(), 0, this);
        }

        public /* synthetic */ ServiceEventHandlerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceEventHandlerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FocusRequestInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AudioFocusRequest mRequest;
        Handler mHandler;

        private void $$robo$$android_media_AudioManager_FocusRequestInfo$__constructor__(AudioFocusRequest afr, Handler handler) {
            this.mRequest = afr;
            this.mHandler = handler;
        }

        private void __constructor__(AudioFocusRequest audioFocusRequest, Handler handler) {
            this.$$robo$$android_media_AudioManager_FocusRequestInfo$__constructor__(audioFocusRequest, handler);
        }

        FocusRequestInfo(AudioFocusRequest audioFocusRequest, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioManager_FocusRequestInfo$__constructor__(android.media.AudioFocusRequest android.os.Handler ), 0, this, audioFocusRequest, handler);
        }

        public /* synthetic */ FocusRequestInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusRequestInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnAudioFocusChangeListener
    extends InstrumentedInterface {
        public void onAudioFocusChange(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PublicStreamTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VolumeAdjustment {
    }
}

