/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.AudioTimestamp;
import android.media.IAudioService;
import android.media.MediaRecorder;
import android.media.MediaSyncEvent;
import android.media.MicrophoneInfo;
import android.media.NativeRoutingEventHandlerDelegate;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioRecord
implements AudioRouting,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_UNINITIALIZED = 0;
    public static int STATE_INITIALIZED = 1;
    public static int RECORDSTATE_STOPPED = 1;
    public static int RECORDSTATE_RECORDING = 3;
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int ERROR_BAD_VALUE = -2;
    public static int ERROR_INVALID_OPERATION = -3;
    public static int ERROR_DEAD_OBJECT = -6;
    private static int AUDIORECORD_ERROR_SETUP_ZEROFRAMECOUNT = -16;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDCHANNELMASK = -17;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDFORMAT = -18;
    private static int AUDIORECORD_ERROR_SETUP_INVALIDSOURCE = -19;
    private static int AUDIORECORD_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static int NATIVE_EVENT_MARKER = 2;
    private static int NATIVE_EVENT_NEW_POS = 3;
    private static String TAG = "android.media.AudioRecord";
    public static String SUBMIX_FIXED_VOLUME = "fixedVolume";
    public static int READ_BLOCKING = 0;
    public static int READ_NON_BLOCKING = 1;
    private long mNativeRecorderInJavaObj;
    private long mNativeCallbackCookie;
    private long mNativeDeviceCallback;
    private int mSampleRate;
    private int mChannelCount;
    private int mChannelMask;
    private int mChannelIndexMask;
    private int mAudioFormat;
    private int mRecordSource;
    private int mState;
    private int mRecordingState;
    private Object mRecordingStateLock;
    private OnRecordPositionUpdateListener mPositionListener;
    private Object mPositionListenerLock;
    private NativeEventHandler mEventHandler;
    private Looper mInitializationLooper;
    private int mNativeBufferSizeInBytes;
    private int mSessionId;
    private AudioAttributes mAudioAttributes;
    private boolean mIsSubmixFullVolume;
    private IBinder mICallBack;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners;
    private AudioDeviceInfo mPreferredDevice;

    private void $$robo$$android_media_AudioRecord$__constructor__(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws IllegalArgumentException {
    }

    @SystemApi
    private void $$robo$$android_media_AudioRecord$__constructor__(AudioAttributes attributes, AudioFormat format, int bufferSizeInBytes, int sessionId) throws IllegalArgumentException {
        this.mState = 0;
        this.mRecordingState = 1;
        this.mRecordingStateLock = new Object();
        this.mPositionListener = null;
        this.mPositionListenerLock = new Object();
        this.mEventHandler = null;
        this.mInitializationLooper = null;
        this.mNativeBufferSizeInBytes = 0;
        this.mSessionId = 0;
        this.mIsSubmixFullVolume = false;
        this.mICallBack = new Binder();
        this.mRoutingChangeListeners = new ArrayMap();
        this.mPreferredDevice = null;
        this.mRecordingState = 1;
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        if (format == null) {
            throw new IllegalArgumentException("Illegal null AudioFormat");
        }
        this.mInitializationLooper = Looper.myLooper();
        if (this.mInitializationLooper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        if (attributes.getCapturePreset() == 8) {
            AudioAttributes.Builder filteredAttr = new AudioAttributes.Builder();
            for (String tag : attributes.getTags()) {
                if (tag.equalsIgnoreCase("fixedVolume")) {
                    this.mIsSubmixFullVolume = true;
                    Log.v("android.media.AudioRecord", "Will record from REMOTE_SUBMIX at full fixed volume");
                    continue;
                }
                filteredAttr.addTag(tag);
            }
            filteredAttr.setInternalCapturePreset(attributes.getCapturePreset());
            this.mAudioAttributes = filteredAttr.build();
        } else {
            this.mAudioAttributes = attributes;
        }
        int rate = format.getSampleRate();
        if (rate == 0) {
            rate = 0;
        }
        int encoding = 1;
        if ((format.getPropertySetMask() & 1) != 0) {
            encoding = format.getEncoding();
        }
        this.audioParamCheck(attributes.getCapturePreset(), rate, encoding);
        if ((format.getPropertySetMask() & 8) != 0) {
            this.mChannelIndexMask = format.getChannelIndexMask();
            this.mChannelCount = format.getChannelCount();
        }
        if ((format.getPropertySetMask() & 4) != 0) {
            this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(format.getChannelMask(), false);
            this.mChannelCount = format.getChannelCount();
        } else if (this.mChannelIndexMask == 0) {
            this.mChannelMask = AudioRecord.getChannelMaskFromLegacyConfig(1, false);
            this.mChannelCount = AudioFormat.channelCountFromInChannelMask(this.mChannelMask);
        }
        this.audioBuffSizeCheck(bufferSizeInBytes);
        int[] sampleRate = new int[]{this.mSampleRate};
        int[] session = new int[]{sessionId};
        int initResult = this.native_setup(new WeakReference<AudioRecord>(this), this.mAudioAttributes, sampleRate, this.mChannelMask, this.mChannelIndexMask, this.mAudioFormat, this.mNativeBufferSizeInBytes, session, ActivityThread.currentOpPackageName(), 0L);
        if (initResult != 0) {
            AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
            return;
        }
        this.mSampleRate = sampleRate[0];
        this.mSessionId = session[0];
        this.mState = 1;
    }

    private void $$robo$$android_media_AudioRecord$__constructor__(long nativeRecordInJavaObj) {
        this.mState = 0;
        this.mRecordingState = 1;
        this.mRecordingStateLock = new Object();
        this.mPositionListener = null;
        this.mPositionListenerLock = new Object();
        this.mEventHandler = null;
        this.mInitializationLooper = null;
        this.mNativeBufferSizeInBytes = 0;
        this.mSessionId = 0;
        this.mIsSubmixFullVolume = false;
        this.mICallBack = new Binder();
        this.mRoutingChangeListeners = new ArrayMap();
        this.mPreferredDevice = null;
        this.mNativeRecorderInJavaObj = 0L;
        this.mNativeCallbackCookie = 0L;
        this.mNativeDeviceCallback = 0L;
        if (nativeRecordInJavaObj != 0L) {
            this.deferred_connect(nativeRecordInJavaObj);
        } else {
            this.mState = 0;
        }
    }

    private final void $$robo$$android_media_AudioRecord$deferred_connect(long nativeRecordInJavaObj) {
        if (this.mState != 1) {
            int[] session = new int[]{0};
            int[] rates = new int[]{0};
            int initResult = this.native_setup(new WeakReference<AudioRecord>(this), null, rates, 0, 0, 0, 0, session, ActivityThread.currentOpPackageName(), nativeRecordInJavaObj);
            if (initResult != 0) {
                AudioRecord.loge("Error code " + initResult + " when initializing native AudioRecord object.");
                return;
            }
            this.mSessionId = session[0];
            this.mState = 1;
        }
    }

    private static final int $$robo$$android_media_AudioRecord$getChannelMaskFromLegacyConfig(int inChannelConfig, boolean allowLegacyConfig) {
        int mask;
        switch (inChannelConfig) {
            case 1: 
            case 2: 
            case 16: {
                mask = 16;
                break;
            }
            case 3: 
            case 12: {
                mask = 12;
                break;
            }
            case 48: {
                mask = inChannelConfig;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel configuration.");
            }
        }
        if (!(allowLegacyConfig || inChannelConfig != 2 && inChannelConfig != 3)) {
            throw new IllegalArgumentException("Unsupported deprecated configuration.");
        }
        return mask;
    }

    private final void $$robo$$android_media_AudioRecord$audioParamCheck(int audioSource, int sampleRateInHz, int audioFormat) throws IllegalArgumentException {
        if (audioSource < 0 || audioSource > MediaRecorder.getAudioSourceMax() && audioSource != 1998 && audioSource != 1999) {
            throw new IllegalArgumentException("Invalid audio source " + audioSource);
        }
        this.mRecordSource = audioSource;
        if ((sampleRateInHz < 4000 || sampleRateInHz > 192000) && sampleRateInHz != 0) {
            throw new IllegalArgumentException(sampleRateInHz + "Hz is not a supported sample rate.");
        }
        this.mSampleRate = sampleRateInHz;
        switch (audioFormat) {
            case 1: {
                this.mAudioFormat = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.mAudioFormat = audioFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sample encoding " + audioFormat + ". Should be ENCODING_PCM_8BIT, ENCODING_PCM_16BIT, or ENCODING_PCM_FLOAT.");
            }
        }
    }

    private final void $$robo$$android_media_AudioRecord$audioBuffSizeCheck(int audioBufferSize) throws IllegalArgumentException {
        int frameSizeInBytes = this.mChannelCount * AudioFormat.getBytesPerSample(this.mAudioFormat);
        if (audioBufferSize % frameSizeInBytes != 0 || audioBufferSize < 1) {
            throw new IllegalArgumentException("Invalid audio buffer size " + audioBufferSize + " (frame size " + frameSizeInBytes + ")");
        }
        this.mNativeBufferSizeInBytes = audioBufferSize;
    }

    private final void $$robo$$android_media_AudioRecord$release() {
        try {
            this.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.native_release();
        this.mState = 0;
    }

    private final void $$robo$$android_media_AudioRecord$finalize() {
        this.release();
    }

    private final int $$robo$$android_media_AudioRecord$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioSource() {
        return this.mRecordSource;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioFormat() {
        return this.mAudioFormat;
    }

    private final int $$robo$$android_media_AudioRecord$getChannelConfiguration() {
        return this.mChannelMask;
    }

    private final AudioFormat $$robo$$android_media_AudioRecord$getFormat() {
        AudioFormat.Builder builder = new AudioFormat.Builder().setSampleRate(this.mSampleRate).setEncoding(this.mAudioFormat);
        if (this.mChannelMask != 0) {
            builder.setChannelMask(this.mChannelMask);
        }
        if (this.mChannelIndexMask != 0) {
            builder.setChannelIndexMask(this.mChannelIndexMask);
        }
        return builder.build();
    }

    private final int $$robo$$android_media_AudioRecord$getChannelCount() {
        return this.mChannelCount;
    }

    private final int $$robo$$android_media_AudioRecord$getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_media_AudioRecord$getRecordingState() {
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            return this.mRecordingState;
        }
    }

    private final int $$robo$$android_media_AudioRecord$getBufferSizeInFrames() {
        return this.native_get_buffer_size_in_frames();
    }

    private final int $$robo$$android_media_AudioRecord$getNotificationMarkerPosition() {
        return this.native_get_marker_pos();
    }

    private final int $$robo$$android_media_AudioRecord$getPositionNotificationPeriod() {
        return this.native_get_pos_update_period();
    }

    private final int $$robo$$android_media_AudioRecord$getTimestamp(AudioTimestamp outTimestamp, int timebase) {
        if (outTimestamp == null || timebase != 1 && timebase != 0) {
            throw new IllegalArgumentException();
        }
        return this.native_get_timestamp(outTimestamp, timebase);
    }

    private static final int $$robo$$android_media_AudioRecord$getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        int channelCount = 0;
        switch (channelConfig) {
            case 1: 
            case 2: 
            case 16: {
                channelCount = 1;
                break;
            }
            case 3: 
            case 12: 
            case 48: {
                channelCount = 2;
                break;
            }
            default: {
                AudioRecord.loge("getMinBufferSize(): Invalid channel configuration.");
                return -2;
            }
        }
        int size = AudioRecord.native_get_min_buff_size(sampleRateInHz, channelCount, audioFormat);
        if (size == 0) {
            return -2;
        }
        if (size == -1) {
            return -1;
        }
        return size;
    }

    private final int $$robo$$android_media_AudioRecord$getAudioSessionId() {
        return this.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$startRecording() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(0, 0) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$startRecording(MediaSyncEvent syncEvent) throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("startRecording() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            if (this.native_start(syncEvent.getType(), syncEvent.getAudioSessionId()) == 0) {
                this.handleFullVolumeRec(true);
                this.mRecordingState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$stop() throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("stop() called on an uninitialized AudioRecord.");
        }
        Object object = this.mRecordingStateLock;
        synchronized (object) {
            this.handleFullVolumeRec(false);
            this.native_stop();
            this.mRecordingState = 1;
        }
    }

    private final void $$robo$$android_media_AudioRecord$handleFullVolumeRec(boolean starting) {
        if (!this.mIsSubmixFullVolume) {
            return;
        }
        IBinder b = ServiceManager.getService("audio");
        IAudioService ias = IAudioService.Stub.asInterface(b);
        try {
            ias.forceRemoteSubmixFullVolume(starting, this.mICallBack);
        }
        catch (RemoteException e) {
            Log.e("android.media.AudioRecord", "Error talking to AudioService when handling full submix volume", e);
        }
    }

    private final int $$robo$$android_media_AudioRecord$read(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        return this.read(audioData, offsetInBytes, sizeInBytes, 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(byte[] audioData, int offsetInBytes, int sizeInBytes, int readMode) {
        if (this.mState != 1 || this.mAudioFormat == 4) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e("android.media.AudioRecord", "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInBytes < 0 || sizeInBytes < 0 || offsetInBytes + sizeInBytes < 0 || offsetInBytes + sizeInBytes > audioData.length) {
            return -2;
        }
        return this.native_read_in_byte_array(audioData, offsetInBytes, sizeInBytes, readMode == 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(short[] audioData, int offsetInShorts, int sizeInShorts) {
        return this.read(audioData, offsetInShorts, sizeInShorts, 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(short[] audioData, int offsetInShorts, int sizeInShorts, int readMode) {
        if (this.mState != 1 || this.mAudioFormat == 4) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e("android.media.AudioRecord", "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInShorts < 0 || sizeInShorts < 0 || offsetInShorts + sizeInShorts < 0 || offsetInShorts + sizeInShorts > audioData.length) {
            return -2;
        }
        return this.native_read_in_short_array(audioData, offsetInShorts, sizeInShorts, readMode == 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(float[] audioData, int offsetInFloats, int sizeInFloats, int readMode) {
        if (this.mState == 0) {
            Log.e("android.media.AudioRecord", "AudioRecord.read() called in invalid state STATE_UNINITIALIZED");
            return -3;
        }
        if (this.mAudioFormat != 4) {
            Log.e("android.media.AudioRecord", "AudioRecord.read(float[] ...) requires format ENCODING_PCM_FLOAT");
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e("android.media.AudioRecord", "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioData == null || offsetInFloats < 0 || sizeInFloats < 0 || offsetInFloats + sizeInFloats < 0 || offsetInFloats + sizeInFloats > audioData.length) {
            return -2;
        }
        return this.native_read_in_float_array(audioData, offsetInFloats, sizeInFloats, readMode == 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(ByteBuffer audioBuffer, int sizeInBytes) {
        return this.read(audioBuffer, sizeInBytes, 0);
    }

    private final int $$robo$$android_media_AudioRecord$read(ByteBuffer audioBuffer, int sizeInBytes, int readMode) {
        if (this.mState != 1) {
            return -3;
        }
        if (readMode != 0 && readMode != 1) {
            Log.e("android.media.AudioRecord", "AudioRecord.read() called with invalid blocking mode");
            return -2;
        }
        if (audioBuffer == null || sizeInBytes < 0) {
            return -2;
        }
        return this.native_read_in_direct_buffer(audioBuffer, sizeInBytes, readMode == 0);
    }

    private final PersistableBundle $$robo$$android_media_AudioRecord$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_AudioRecord$native_getMetrics() {
        return null;
    }

    private final void $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener) {
        this.setRecordPositionUpdateListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener, Handler handler) {
        Object object = this.mPositionListenerLock;
        synchronized (object) {
            this.mPositionListener = listener;
            this.mEventHandler = listener != null ? (handler != null ? new NativeEventHandler(this, this, handler.getLooper()) : new NativeEventHandler(this, this, this.mInitializationLooper)) : null;
        }
    }

    private final int $$robo$$android_media_AudioRecord$setNotificationMarkerPosition(int markerInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_marker_pos(markerInFrames);
    }

    private final AudioDeviceInfo $$robo$$android_media_AudioRecord$getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_AudioRecord$testEnableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback();
        }
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_AudioRecord$testDisableNativeRoutingCallbacksLocked() {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_disableDeviceCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.testEnableNativeRoutingCallbacksLocked();
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : new Handler(this.mInitializationLooper)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
                this.testDisableNativeRoutingCallbacksLocked();
            }
        }
    }

    @Deprecated
    private final void $$robo$$android_media_AudioRecord$addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        this.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener, handler);
    }

    @Deprecated
    private final void $$robo$$android_media_AudioRecord$removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        this.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_AudioRecord$broadcastRoutingChange() {
        AudioManager.resetAudioPortGeneration();
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            for (NativeRoutingEventHandlerDelegate delegate : this.mRoutingChangeListeners.values()) {
                delegate.notifyClient();
            }
        }
    }

    private final int $$robo$$android_media_AudioRecord$setPositionNotificationPeriod(int periodInFrames) {
        if (this.mState == 0) {
            return -3;
        }
        return this.native_set_pos_update_period(periodInFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_AudioRecord$setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSource()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setInputDevice(preferredDeviceId);
        if (status) {
            AudioRecord audioRecord = this;
            synchronized (audioRecord) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AudioDeviceInfo $$robo$$android_media_AudioRecord$getPreferredDevice() {
        AudioRecord audioRecord = this;
        synchronized (audioRecord) {
            return this.mPreferredDevice;
        }
    }

    private final List<MicrophoneInfo> $$robo$$android_media_AudioRecord$getActiveMicrophones() throws IOException {
        AudioDeviceInfo device;
        ArrayList<MicrophoneInfo> activeMicrophones = new ArrayList<MicrophoneInfo>();
        int status = this.native_get_active_microphones(activeMicrophones);
        if (status != 0) {
            if (status != -3) {
                Log.e("android.media.AudioRecord", "getActiveMicrophones failed:" + status);
            }
            Log.i("android.media.AudioRecord", "getActiveMicrophones failed, fallback on routed device info");
        }
        AudioManager.setPortIdForMicrophones(activeMicrophones);
        if (activeMicrophones.size() == 0 && (device = this.getRoutedDevice()) != null) {
            MicrophoneInfo microphone = AudioManager.microphoneInfoFromAudioDeviceInfo(device);
            ArrayList<Pair<Integer, Integer>> channelMapping = new ArrayList<Pair<Integer, Integer>>();
            for (int i = 0; i < this.mChannelCount; ++i) {
                channelMapping.add(new Pair<Integer, Integer>(i, 1));
            }
            microphone.setChannelMapping(channelMapping);
            activeMicrophones.add(microphone);
        }
        return activeMicrophones;
    }

    private static final void $$robo$$android_media_AudioRecord$postEventFromNative(Object audiorecord_ref, int what, int arg1, int arg2, Object obj) {
        AudioRecord recorder = (AudioRecord)((WeakReference)audiorecord_ref).get();
        if (recorder == null) {
            return;
        }
        if (what == 1000) {
            recorder.broadcastRoutingChange();
            return;
        }
        if (recorder.mEventHandler != null) {
            Message m = recorder.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            recorder.mEventHandler.sendMessage(m);
        }
    }

    private final int $$robo$$android_media_AudioRecord$native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int[] nArray2, String string2, long l) {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecord$native_finalize() {
    }

    private final void $$robo$$android_media_AudioRecord$native_release() {
    }

    private final int $$robo$$android_media_AudioRecord$native_start(int n, int n2) {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecord$native_stop() {
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_byte_array(byte[] byArray, int n, int n2, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_short_array(short[] sArray, int n, int n2, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_float_array(float[] fArray, int n, int n2, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_read_in_direct_buffer(Object object, int n, boolean bl) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_buffer_size_in_frames() {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_set_marker_pos(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_marker_pos() {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_set_pos_update_period(int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_pos_update_period() {
        return 0;
    }

    private static final int $$robo$$android_media_AudioRecord$native_get_min_buff_size(int n, int n2, int n3) {
        return 0;
    }

    private final boolean $$robo$$android_media_AudioRecord$native_setInputDevice(int n) {
        return false;
    }

    private final int $$robo$$android_media_AudioRecord$native_getRoutedDeviceId() {
        return 0;
    }

    private final void $$robo$$android_media_AudioRecord$native_enableDeviceCallback() {
    }

    private final void $$robo$$android_media_AudioRecord$native_disableDeviceCallback() {
    }

    private final int $$robo$$android_media_AudioRecord$native_get_timestamp(AudioTimestamp audioTimestamp, int n) {
        return 0;
    }

    private final int $$robo$$android_media_AudioRecord$native_get_active_microphones(ArrayList<MicrophoneInfo> arrayList) {
        return 0;
    }

    private static final void $$robo$$android_media_AudioRecord$logd(String msg) {
        Log.d("android.media.AudioRecord", msg);
    }

    private static final void $$robo$$android_media_AudioRecord$loge(String msg) {
        Log.e("android.media.AudioRecord", msg);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioRecord$__constructor__(n, n2, n3, n4, n5);
    }

    public AudioRecord(int n, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this(new AudioAttributes.Builder().setInternalCapturePreset(n).build(), new AudioFormat.Builder().setChannelMask(AudioRecord.getChannelMaskFromLegacyConfig(n3, true)).setEncoding(n4).setSampleRate(n2).build(), n5, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord$__constructor__(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    private void __constructor__(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) throws IllegalArgumentException {
        this.$$robo$$android_media_AudioRecord$__constructor__(audioAttributes, audioFormat, n, n2);
    }

    public AudioRecord(AudioAttributes audioAttributes, AudioFormat audioFormat, int n, int n2) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord$__constructor__(android.media.AudioAttributes android.media.AudioFormat int int ), 0, this, audioAttributes, audioFormat, n, n2);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_media_AudioRecord$__constructor__(l);
    }

    AudioRecord(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord$__constructor__(long ), 0, this, l);
    }

    void deferred_connect(long l) {
        InvokeDynamicSupport.bootstrap("deferred_connect", $$robo$$android_media_AudioRecord$deferred_connect(long ), 0, this, l);
    }

    private static int getChannelMaskFromLegacyConfig(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getChannelMaskFromLegacyConfig", $$robo$$android_media_AudioRecord$getChannelMaskFromLegacyConfig(int boolean ), 0, (int)n, (boolean)bl);
    }

    private void audioParamCheck(int n, int n2, int n3) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("audioParamCheck", $$robo$$android_media_AudioRecord$audioParamCheck(int int int ), 0, this, n, n2, n3);
    }

    private void audioBuffSizeCheck(int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("audioBuffSizeCheck", $$robo$$android_media_AudioRecord$audioBuffSizeCheck(int ), 0, this, n);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_AudioRecord$release(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_AudioRecord$finalize(), 0, this);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_media_AudioRecord$getSampleRate(), 0, this);
    }

    public int getAudioSource() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSource", $$robo$$android_media_AudioRecord$getAudioSource(), 0, this);
    }

    public int getAudioFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioFormat", $$robo$$android_media_AudioRecord$getAudioFormat(), 0, this);
    }

    public int getChannelConfiguration() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelConfiguration", $$robo$$android_media_AudioRecord$getChannelConfiguration(), 0, this);
    }

    public AudioFormat getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_AudioRecord$getFormat(), 0, this);
    }

    public int getChannelCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelCount", $$robo$$android_media_AudioRecord$getChannelCount(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_media_AudioRecord$getState(), 0, this);
    }

    public int getRecordingState() {
        return (int)InvokeDynamicSupport.bootstrap("getRecordingState", $$robo$$android_media_AudioRecord$getRecordingState(), 0, this);
    }

    public int getBufferSizeInFrames() {
        return (int)InvokeDynamicSupport.bootstrap("getBufferSizeInFrames", $$robo$$android_media_AudioRecord$getBufferSizeInFrames(), 0, this);
    }

    public int getNotificationMarkerPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getNotificationMarkerPosition", $$robo$$android_media_AudioRecord$getNotificationMarkerPosition(), 0, this);
    }

    public int getPositionNotificationPeriod() {
        return (int)InvokeDynamicSupport.bootstrap("getPositionNotificationPeriod", $$robo$$android_media_AudioRecord$getPositionNotificationPeriod(), 0, this);
    }

    public int getTimestamp(AudioTimestamp audioTimestamp, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_AudioRecord$getTimestamp(android.media.AudioTimestamp int ), 0, this, audioTimestamp, n);
    }

    public static int getMinBufferSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMinBufferSize", $$robo$$android_media_AudioRecord$getMinBufferSize(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_AudioRecord$getAudioSessionId(), 0, this);
    }

    public void startRecording() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_AudioRecord$startRecording(), 0, this);
    }

    public void startRecording(MediaSyncEvent mediaSyncEvent) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("startRecording", $$robo$$android_media_AudioRecord$startRecording(android.media.MediaSyncEvent ), 0, this, mediaSyncEvent);
    }

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_AudioRecord$stop(), 0, this);
    }

    private void handleFullVolumeRec(boolean bl) {
        InvokeDynamicSupport.bootstrap("handleFullVolumeRec", $$robo$$android_media_AudioRecord$handleFullVolumeRec(boolean ), 0, this, bl);
    }

    public int read(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(byte[] int int ), 0, this, byArray, n, n2);
    }

    public int read(byte[] byArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(byte[] int int int ), 0, this, byArray, n, n2, n3);
    }

    public int read(short[] sArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(short[] int int ), 0, this, sArray, n, n2);
    }

    public int read(short[] sArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(short[] int int int ), 0, this, sArray, n, n2, n3);
    }

    public int read(float[] fArray, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(float[] int int int ), 0, this, fArray, n, n2, n3);
    }

    public int read(ByteBuffer byteBuffer, int n) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(java.nio.ByteBuffer int ), 0, this, byteBuffer, n);
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_media_AudioRecord$read(java.nio.ByteBuffer int int ), 0, this, byteBuffer, n, n2);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_AudioRecord$getMetrics(), 0, this);
    }

    private final native /* synthetic */ PersistableBundle $$robo$$native_getMetrics$nativeBinding();

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_AudioRecord$native_getMetrics(), 1, this);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener) {
        InvokeDynamicSupport.bootstrap("setRecordPositionUpdateListener", $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(android.media.AudioRecord$OnRecordPositionUpdateListener ), 0, this, onRecordPositionUpdateListener);
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener onRecordPositionUpdateListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setRecordPositionUpdateListener", $$robo$$android_media_AudioRecord$setRecordPositionUpdateListener(android.media.AudioRecord$OnRecordPositionUpdateListener android.os.Handler ), 0, this, onRecordPositionUpdateListener, handler);
    }

    public int setNotificationMarkerPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setNotificationMarkerPosition", $$robo$$android_media_AudioRecord$setNotificationMarkerPosition(int ), 0, this, n);
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        return InvokeDynamicSupport.bootstrap("getRoutedDevice", $$robo$$android_media_AudioRecord$getRoutedDevice(), 0, this);
    }

    private void testEnableNativeRoutingCallbacksLocked() {
        InvokeDynamicSupport.bootstrap("testEnableNativeRoutingCallbacksLocked", $$robo$$android_media_AudioRecord$testEnableNativeRoutingCallbacksLocked(), 0, this);
    }

    private void testDisableNativeRoutingCallbacksLocked() {
        InvokeDynamicSupport.bootstrap("testDisableNativeRoutingCallbacksLocked", $$robo$$android_media_AudioRecord$testDisableNativeRoutingCallbacksLocked(), 0, this);
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_AudioRecord$addOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener android.os.Handler ), 0, this, onRoutingChangedListener, handler);
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_AudioRecord$removeOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener ), 0, this, onRoutingChangedListener);
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_AudioRecord$addOnRoutingChangedListener(android.media.AudioRecord$OnRoutingChangedListener android.os.Handler ), 0, this, onRoutingChangedListener, handler);
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_AudioRecord$removeOnRoutingChangedListener(android.media.AudioRecord$OnRoutingChangedListener ), 0, this, onRoutingChangedListener);
    }

    private void broadcastRoutingChange() {
        InvokeDynamicSupport.bootstrap("broadcastRoutingChange", $$robo$$android_media_AudioRecord$broadcastRoutingChange(), 0, this);
    }

    public int setPositionNotificationPeriod(int n) {
        return (int)InvokeDynamicSupport.bootstrap("setPositionNotificationPeriod", $$robo$$android_media_AudioRecord$setPositionNotificationPeriod(int ), 0, this, n);
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo audioDeviceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredDevice", $$robo$$android_media_AudioRecord$setPreferredDevice(android.media.AudioDeviceInfo ), 0, this, audioDeviceInfo);
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        return InvokeDynamicSupport.bootstrap("getPreferredDevice", $$robo$$android_media_AudioRecord$getPreferredDevice(), 0, this);
    }

    public List<MicrophoneInfo> getActiveMicrophones() throws IOException {
        return InvokeDynamicSupport.bootstrap("getActiveMicrophones", $$robo$$android_media_AudioRecord$getActiveMicrophones(), 0, this);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_AudioRecord$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, Object var2, int[] var3, int var4, int var5, int var6, int var7, int[] var8, String var9, long var10);

    private int native_setup(Object object, Object object2, int[] nArray, int n, int n2, int n3, int n4, int[] nArray2, String string2, long l) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_AudioRecord$native_setup(java.lang.Object java.lang.Object int[] int int int int int[] java.lang.String long ), 1, this, object, object2, nArray, n, n2, n3, n4, nArray2, string2, l);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_AudioRecord$native_finalize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    public void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_AudioRecord$native_release(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_start$nativeBinding(int var1, int var2);

    private int native_start(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("native_start", $$robo$$android_media_AudioRecord$native_start(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ void $$robo$$native_stop$nativeBinding();

    private void native_stop() {
        InvokeDynamicSupport.bootstrap("native_stop", $$robo$$android_media_AudioRecord$native_stop(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_byte_array$nativeBinding(byte[] var1, int var2, int var3, boolean var4);

    private int native_read_in_byte_array(byte[] byArray, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_byte_array", $$robo$$android_media_AudioRecord$native_read_in_byte_array(byte[] int int boolean ), 1, this, byArray, n, n2, bl);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_short_array$nativeBinding(short[] var1, int var2, int var3, boolean var4);

    private int native_read_in_short_array(short[] sArray, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_short_array", $$robo$$android_media_AudioRecord$native_read_in_short_array(short[] int int boolean ), 1, this, sArray, n, n2, bl);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_float_array$nativeBinding(float[] var1, int var2, int var3, boolean var4);

    private int native_read_in_float_array(float[] fArray, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_float_array", $$robo$$android_media_AudioRecord$native_read_in_float_array(float[] int int boolean ), 1, this, fArray, n, n2, bl);
    }

    private final native /* synthetic */ int $$robo$$native_read_in_direct_buffer$nativeBinding(Object var1, int var2, boolean var3);

    private int native_read_in_direct_buffer(Object object, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("native_read_in_direct_buffer", $$robo$$android_media_AudioRecord$native_read_in_direct_buffer(java.lang.Object int boolean ), 1, this, object, n, bl);
    }

    private final native /* synthetic */ int $$robo$$native_get_buffer_size_in_frames$nativeBinding();

    private int native_get_buffer_size_in_frames() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_buffer_size_in_frames", $$robo$$android_media_AudioRecord$native_get_buffer_size_in_frames(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_marker_pos$nativeBinding(int var1);

    private int native_set_marker_pos(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_marker_pos", $$robo$$android_media_AudioRecord$native_set_marker_pos(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_marker_pos$nativeBinding();

    private int native_get_marker_pos() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_marker_pos", $$robo$$android_media_AudioRecord$native_get_marker_pos(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_set_pos_update_period$nativeBinding(int var1);

    private int native_set_pos_update_period(int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_set_pos_update_period", $$robo$$android_media_AudioRecord$native_set_pos_update_period(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_pos_update_period$nativeBinding();

    private int native_get_pos_update_period() {
        return (int)InvokeDynamicSupport.bootstrap("native_get_pos_update_period", $$robo$$android_media_AudioRecord$native_get_pos_update_period(), 1, this);
    }

    private static final native /* synthetic */ int $$robo$$native_get_min_buff_size$nativeBinding(int var0, int var1, int var2);

    private static int native_get_min_buff_size(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_get_min_buff_size", $$robo$$android_media_AudioRecord$native_get_min_buff_size(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    private final native /* synthetic */ boolean $$robo$$native_setInputDevice$nativeBinding(int var1);

    private boolean native_setInputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_setInputDevice", $$robo$$android_media_AudioRecord$native_setInputDevice(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_getRoutedDeviceId$nativeBinding();

    private int native_getRoutedDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("native_getRoutedDeviceId", $$robo$$android_media_AudioRecord$native_getRoutedDeviceId(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_enableDeviceCallback$nativeBinding();

    private void native_enableDeviceCallback() {
        InvokeDynamicSupport.bootstrap("native_enableDeviceCallback", $$robo$$android_media_AudioRecord$native_enableDeviceCallback(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_disableDeviceCallback$nativeBinding();

    private void native_disableDeviceCallback() {
        InvokeDynamicSupport.bootstrap("native_disableDeviceCallback", $$robo$$android_media_AudioRecord$native_disableDeviceCallback(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$native_get_timestamp$nativeBinding(AudioTimestamp var1, int var2);

    private int native_get_timestamp(AudioTimestamp audioTimestamp, int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_timestamp", $$robo$$android_media_AudioRecord$native_get_timestamp(android.media.AudioTimestamp int ), 1, this, audioTimestamp, n);
    }

    private final native /* synthetic */ int $$robo$$native_get_active_microphones$nativeBinding(ArrayList<MicrophoneInfo> var1);

    private int native_get_active_microphones(ArrayList<MicrophoneInfo> arrayList) {
        return (int)InvokeDynamicSupport.bootstrap("native_get_active_microphones", $$robo$$android_media_AudioRecord$native_get_active_microphones(java.util.ArrayList<android.media.MicrophoneInfo> ), 1, this, arrayList);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_media_AudioRecord$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$android_media_AudioRecord$loge(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ AudioRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MetricsConstants
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String ENCODING = "android.media.audiorecord.encoding";
        public static String SOURCE = "android.media.audiorecord.source";
        public static String LATENCY = "android.media.audiorecord.latency";
        public static String SAMPLERATE = "android.media.audiorecord.samplerate";
        public static String CHANNELS = "android.media.audiorecord.channels";

        private void $$robo$$android_media_AudioRecord_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioRecord_MetricsConstants$__constructor__();
        }

        private MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord_MetricsConstants$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NativeEventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioRecord mAudioRecord;
        /* synthetic */ AudioRecord this$0;

        private void $$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(AudioRecord audioRecord, AudioRecord recorder, Looper looper) {
            this.mAudioRecord = recorder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_AudioRecord_NativeEventHandler$handleMessage(Message msg) {
            OnRecordPositionUpdateListener listener = null;
            Object object = this.this$0.mPositionListenerLock;
            synchronized (object) {
                listener = this.mAudioRecord.mPositionListener;
            }
            switch (msg.what) {
                case 2: {
                    if (listener == null) break;
                    listener.onMarkerReached(this.mAudioRecord);
                    break;
                }
                case 3: {
                    if (listener == null) break;
                    listener.onPeriodicNotification(this.mAudioRecord);
                    break;
                }
                default: {
                    AudioRecord.loge("Unknown native event type: " + msg.what);
                }
            }
        }

        private void __constructor__(AudioRecord audioRecord, AudioRecord audioRecord2, Looper looper) {
            this.$$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(audioRecord, audioRecord2, looper);
        }

        NativeEventHandler(AudioRecord audioRecord, AudioRecord audioRecord2, Looper looper) {
            this.this$0 = audioRecord;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord_NativeEventHandler$__constructor__(android.media.AudioRecord android.media.AudioRecord android.os.Looper ), 0, this, audioRecord, audioRecord2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_AudioRecord_NativeEventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ NativeEventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeEventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnRecordPositionUpdateListener
    extends InstrumentedInterface {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener,
    InstrumentedInterface {
        public void onRoutingChanged(AudioRecord var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            if (router instanceof AudioRecord) {
                this.onRoutingChanged((AudioRecord)router);
            }
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioAttributes mAttributes;
        private AudioFormat mFormat;
        private int mBufferSizeInBytes;
        private int mSessionId;

        private void $$robo$$android_media_AudioRecord_Builder$__constructor__() {
            this.mSessionId = 0;
        }

        private final Builder $$robo$$android_media_AudioRecord_Builder$setAudioSource(int source) throws IllegalArgumentException {
            if (source < 0 || source > MediaRecorder.getAudioSourceMax()) {
                throw new IllegalArgumentException("Invalid audio source " + source);
            }
            this.mAttributes = new AudioAttributes.Builder().setInternalCapturePreset(source).build();
            return this;
        }

        @SystemApi
        private final Builder $$robo$$android_media_AudioRecord_Builder$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Illegal null AudioAttributes argument");
            }
            if (attributes.getCapturePreset() == -1) {
                throw new IllegalArgumentException("No valid capture preset in AudioAttributes argument");
            }
            this.mAttributes = attributes;
            return this;
        }

        private final Builder $$robo$$android_media_AudioRecord_Builder$setAudioFormat(AudioFormat format) throws IllegalArgumentException {
            if (format == null) {
                throw new IllegalArgumentException("Illegal null AudioFormat argument");
            }
            this.mFormat = format;
            return this;
        }

        private final Builder $$robo$$android_media_AudioRecord_Builder$setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            if (bufferSizeInBytes <= 0) {
                throw new IllegalArgumentException("Invalid buffer size " + bufferSizeInBytes);
            }
            this.mBufferSizeInBytes = bufferSizeInBytes;
            return this;
        }

        @SystemApi
        private final Builder $$robo$$android_media_AudioRecord_Builder$setSessionId(int sessionId) throws IllegalArgumentException {
            if (sessionId < 0) {
                throw new IllegalArgumentException("Invalid session ID " + sessionId);
            }
            this.mSessionId = sessionId;
            return this;
        }

        private final AudioRecord $$robo$$android_media_AudioRecord_Builder$build() throws UnsupportedOperationException {
            if (this.mFormat == null) {
                this.mFormat = new AudioFormat.Builder().setEncoding(2).setChannelMask(16).build();
            } else {
                if (this.mFormat.getEncoding() == 0) {
                    this.mFormat = new AudioFormat.Builder(this.mFormat).setEncoding(2).build();
                }
                if (this.mFormat.getChannelMask() == 0 && this.mFormat.getChannelIndexMask() == 0) {
                    this.mFormat = new AudioFormat.Builder(this.mFormat).setChannelMask(16).build();
                }
            }
            if (this.mAttributes == null) {
                this.mAttributes = new AudioAttributes.Builder().setInternalCapturePreset(0).build();
            }
            try {
                AudioRecord record;
                if (this.mBufferSizeInBytes == 0) {
                    this.mBufferSizeInBytes = this.mFormat.getChannelCount() * AudioFormat.getBytesPerSample(this.mFormat.getEncoding());
                }
                if ((record = new AudioRecord(this.mAttributes, this.mFormat, this.mBufferSizeInBytes, this.mSessionId)).getState() == 0) {
                    throw new UnsupportedOperationException("Cannot create AudioRecord");
                }
                return record;
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }

        private void __constructor__() {
            this.$$robo$$android_media_AudioRecord_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioRecord_Builder$__constructor__(), 0, this);
        }

        public Builder setAudioSource(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioSource", $$robo$$android_media_AudioRecord_Builder$setAudioSource(int ), 0, this, n);
        }

        @SystemApi
        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_AudioRecord_Builder$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
        }

        public Builder setAudioFormat(AudioFormat audioFormat) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioFormat", $$robo$$android_media_AudioRecord_Builder$setAudioFormat(android.media.AudioFormat ), 0, this, audioFormat);
        }

        public Builder setBufferSizeInBytes(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setBufferSizeInBytes", $$robo$$android_media_AudioRecord_Builder$setBufferSizeInBytes(int ), 0, this, n);
        }

        @SystemApi
        public Builder setSessionId(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setSessionId", $$robo$$android_media_AudioRecord_Builder$setSessionId(int ), 0, this, n);
        }

        public AudioRecord build() throws UnsupportedOperationException {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_AudioRecord_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReadMode {
    }
}

