/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaDrm
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaDrm";
    private AtomicBoolean mClosed;
    private CloseGuard mCloseGuard;
    private static String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    private EventHandler mEventHandler;
    private EventHandler mOnKeyStatusChangeEventHandler;
    private EventHandler mOnExpirationUpdateEventHandler;
    private OnEventListener mOnEventListener;
    private OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private OnExpirationUpdateListener mOnExpirationUpdateListener;
    private long mNativeContext;
    public static int CERTIFICATE_TYPE_NONE = 0;
    public static int CERTIFICATE_TYPE_X509 = 1;
    public static int EVENT_PROVISION_REQUIRED = 1;
    public static int EVENT_KEY_REQUIRED = 2;
    public static int EVENT_KEY_EXPIRED = 3;
    public static int EVENT_VENDOR_DEFINED = 4;
    public static int EVENT_SESSION_RECLAIMED = 5;
    private static int DRM_EVENT = 200;
    private static int EXPIRATION_UPDATE = 201;
    private static int KEY_STATUS_CHANGE = 202;
    public static int KEY_TYPE_STREAMING = 1;
    public static int KEY_TYPE_OFFLINE = 2;
    public static int KEY_TYPE_RELEASE = 3;
    public static int HDCP_LEVEL_UNKNOWN = 0;
    public static int HDCP_NONE = 1;
    public static int HDCP_V1 = 2;
    public static int HDCP_V2 = 3;
    public static int HDCP_V2_1 = 4;
    public static int HDCP_V2_2 = 5;
    public static int HDCP_NO_DIGITAL_OUTPUT = Integer.MAX_VALUE;
    public static int SECURITY_LEVEL_UNKNOWN = 0;
    public static int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1;
    public static int SECURITY_LEVEL_SW_SECURE_DECODE = 2;
    public static int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3;
    public static int SECURITY_LEVEL_HW_SECURE_DECODE = 4;
    public static int SECURITY_LEVEL_HW_SECURE_ALL = 5;
    public static int SECURITY_LEVEL_MAX = 6;
    public static String PROPERTY_VENDOR = "vendor";
    public static String PROPERTY_VERSION = "version";
    public static String PROPERTY_DESCRIPTION = "description";
    public static String PROPERTY_ALGORITHMS = "algorithms";
    public static String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null);
    }

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType);
    }

    private static final byte[] $$robo$$android_media_MediaDrm$getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static final boolean $$robo$$android_media_MediaDrm$isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return false;
    }

    private void $$robo$$android_media_MediaDrm$__constructor__(UUID uuid) throws UnsupportedSchemeException {
        this.mClosed = new AtomicBoolean();
        this.mCloseGuard = CloseGuard.get();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid), ActivityThread.currentOpPackageName());
        this.mCloseGuard.open("release");
    }

    private final void $$robo$$android_media_MediaDrm$setOnExpirationUpdateListener(OnExpirationUpdateListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, this, looper);
            }
        }
        this.mOnExpirationUpdateListener = listener;
    }

    private final void $$robo$$android_media_MediaDrm$setOnKeyStatusChangeListener(OnKeyStatusChangeListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, this, looper);
            }
        }
        this.mOnKeyStatusChangeListener = listener;
    }

    private final void $$robo$$android_media_MediaDrm$setOnEventListener(OnEventListener listener) {
        this.mOnEventListener = listener;
    }

    private final List<KeyStatus> $$robo$$android_media_MediaDrm$keyStatusListFromParcel(Parcel parcel) {
        int nelems = parcel.readInt();
        ArrayList<KeyStatus> keyStatusList = new ArrayList<KeyStatus>(nelems);
        while (nelems-- > 0) {
            byte[] keyId = parcel.createByteArray();
            int keyStatusCode = parcel.readInt();
            keyStatusList.add(new KeyStatus(keyId, keyStatusCode));
        }
        return keyStatusList;
    }

    private static final void $$robo$$android_media_MediaDrm$postEventFromNative(Object mediadrm_ref, int what, int eventType, int extra, Object obj) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        if (md.mEventHandler != null) {
            Message m = md.mEventHandler.obtainMessage(what, eventType, extra, obj);
            md.mEventHandler.sendMessage(m);
        }
    }

    private final byte[] $$robo$$android_media_MediaDrm$openSession() throws NotProvisionedException, ResourceBusyException {
        return this.openSession(MediaDrm.getMaxSecurityLevel());
    }

    private final byte[] $$robo$$android_media_MediaDrm$openSession(int n) throws NotProvisionedException, ResourceBusyException {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$closeSession(byte[] byArray) {
    }

    private final KeyRequest $$robo$$android_media_MediaDrm$getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$restoreKeys(byte[] byArray, byte[] byArray2) {
    }

    private final void $$robo$$android_media_MediaDrm$removeKeys(byte[] byArray) {
    }

    private final HashMap<String, String> $$robo$$android_media_MediaDrm$queryKeyStatus(byte[] byArray) {
        return null;
    }

    private final ProvisionRequest $$robo$$android_media_MediaDrm$getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    private final ProvisionRequest $$robo$$android_media_MediaDrm$getProvisionRequestNative(int n, String string2) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.provideProvisionResponseNative(response);
    }

    private final Certificate $$robo$$android_media_MediaDrm$provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return null;
    }

    private final List<byte[]> $$robo$$android_media_MediaDrm$getSecureStops() {
        return null;
    }

    private final List<byte[]> $$robo$$android_media_MediaDrm$getSecureStopIds() {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$getSecureStop(byte[] byArray) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$releaseSecureStops(byte[] byArray) {
    }

    private final void $$robo$$android_media_MediaDrm$removeSecureStop(byte[] byArray) {
    }

    private final void $$robo$$android_media_MediaDrm$removeAllSecureStops() {
    }

    private final void $$robo$$android_media_MediaDrm$releaseAllSecureStops() {
        this.removeAllSecureStops();
    }

    private final int $$robo$$android_media_MediaDrm$getConnectedHdcpLevel() {
        return 0;
    }

    private final int $$robo$$android_media_MediaDrm$getMaxHdcpLevel() {
        return 0;
    }

    private final int $$robo$$android_media_MediaDrm$getOpenSessionCount() {
        return 0;
    }

    private final int $$robo$$android_media_MediaDrm$getMaxSessionCount() {
        return 0;
    }

    private static final int $$robo$$android_media_MediaDrm$getMaxSecurityLevel() {
        return 6;
    }

    private final int $$robo$$android_media_MediaDrm$getSecurityLevel(byte[] byArray) {
        return 0;
    }

    private final String $$robo$$android_media_MediaDrm$getPropertyString(String string2) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$setPropertyString(String string2, String string3) {
    }

    private final byte[] $$robo$$android_media_MediaDrm$getPropertyByteArray(String string2) {
        return null;
    }

    private final void $$robo$$android_media_MediaDrm$setPropertyByteArray(String string2, byte[] byArray) {
    }

    private static final void $$robo$$android_media_MediaDrm$setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
    }

    private static final void $$robo$$android_media_MediaDrm$setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
    }

    private static final byte[] $$robo$$android_media_MediaDrm$encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return null;
    }

    private static final byte[] $$robo$$android_media_MediaDrm$decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return null;
    }

    private static final byte[] $$robo$$android_media_MediaDrm$signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return null;
    }

    private static final boolean $$robo$$android_media_MediaDrm$verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return false;
    }

    private final PersistableBundle $$robo$$android_media_MediaDrm$getMetrics() {
        PersistableBundle bundle = this.getMetricsNative();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_MediaDrm$getMetricsNative() {
        return null;
    }

    private final CryptoSession $$robo$$android_media_MediaDrm$getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(this, sessionId, cipherAlgorithm, macAlgorithm);
    }

    private final CertificateRequest $$robo$$android_media_MediaDrm$getCertificateRequest(int certType, String certAuthority) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(certType, certAuthority);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    private final Certificate $$robo$$android_media_MediaDrm$provideCertificateResponse(byte[] response) throws DeniedByServerException {
        return this.provideProvisionResponseNative(response);
    }

    private static final byte[] $$robo$$android_media_MediaDrm$signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return null;
    }

    private final byte[] $$robo$$android_media_MediaDrm$signRSA(byte[] sessionId, String algorithm, byte[] wrappedKey, byte[] message) {
        return MediaDrm.signRSANative(this, sessionId, algorithm, wrappedKey, message);
    }

    private final void $$robo$$android_media_MediaDrm$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_media_MediaDrm$close() {
        this.release();
    }

    @Deprecated
    private final void $$robo$$android_media_MediaDrm$release() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.native_release();
        }
    }

    private final void $$robo$$android_media_MediaDrm$native_release() {
    }

    private static final void $$robo$$android_media_MediaDrm$native_init() {
    }

    private final void $$robo$$android_media_MediaDrm$native_setup(Object object, byte[] byArray, String string2) {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaDrm.native_init();
    }

    public static boolean isCryptoSchemeSupported(UUID uUID) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupported", $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(java.util.UUID ), 0, (UUID)uUID);
    }

    public static boolean isCryptoSchemeSupported(UUID uUID, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupported", $$robo$$android_media_MediaDrm$isCryptoSchemeSupported(java.util.UUID java.lang.String ), 0, (UUID)uUID, (String)string2);
    }

    private static byte[] getByteArrayFromUUID(UUID uUID) {
        return InvokeDynamicSupport.bootstrapStatic("getByteArrayFromUUID", $$robo$$android_media_MediaDrm$getByteArrayFromUUID(java.util.UUID ), 0, (UUID)uUID);
    }

    private static final native /* synthetic */ boolean $$robo$$isCryptoSchemeSupportedNative$nativeBinding(byte[] var0, String var1);

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCryptoSchemeSupportedNative", $$robo$$android_media_MediaDrm$isCryptoSchemeSupportedNative(byte[] java.lang.String ), 1, (byte[])byArray, (String)string2);
    }

    private void __constructor__(UUID uUID) throws UnsupportedSchemeException {
        this.$$robo$$android_media_MediaDrm$__constructor__(uUID);
    }

    public MediaDrm(UUID uUID) throws UnsupportedSchemeException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm$__constructor__(java.util.UUID ), 0, this, uUID);
    }

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener onExpirationUpdateListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnExpirationUpdateListener", $$robo$$android_media_MediaDrm$setOnExpirationUpdateListener(android.media.MediaDrm$OnExpirationUpdateListener android.os.Handler ), 0, this, onExpirationUpdateListener, handler);
    }

    public void setOnKeyStatusChangeListener(OnKeyStatusChangeListener onKeyStatusChangeListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setOnKeyStatusChangeListener", $$robo$$android_media_MediaDrm$setOnKeyStatusChangeListener(android.media.MediaDrm$OnKeyStatusChangeListener android.os.Handler ), 0, this, onKeyStatusChangeListener, handler);
    }

    public void setOnEventListener(OnEventListener onEventListener) {
        InvokeDynamicSupport.bootstrap("setOnEventListener", $$robo$$android_media_MediaDrm$setOnEventListener(android.media.MediaDrm$OnEventListener ), 0, this, onEventListener);
    }

    private List<KeyStatus> keyStatusListFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("keyStatusListFromParcel", $$robo$$android_media_MediaDrm$keyStatusListFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_MediaDrm$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_media_MediaDrm$openSession(), 0, this);
    }

    private final native /* synthetic */ byte[] $$robo$$openSession$nativeBinding(int var1) throws NotProvisionedException, ResourceBusyException;

    public byte[] openSession(int n) throws NotProvisionedException, ResourceBusyException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_media_MediaDrm$openSession(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$closeSession$nativeBinding(byte[] var1);

    public void closeSession(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("closeSession", $$robo$$android_media_MediaDrm$closeSession(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ KeyRequest $$robo$$getKeyRequest$nativeBinding(byte[] var1, byte[] var2, String var3, int var4, HashMap<String, String> var5) throws NotProvisionedException;

    public KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return InvokeDynamicSupport.bootstrap("getKeyRequest", $$robo$$android_media_MediaDrm$getKeyRequest(byte[] byte[] java.lang.String int java.util.HashMap<java.lang.String, java.lang.String> ), 1, this, byArray, byArray2, string2, n, hashMap);
    }

    private final native /* synthetic */ byte[] $$robo$$provideKeyResponse$nativeBinding(byte[] var1, byte[] var2) throws NotProvisionedException, DeniedByServerException;

    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideKeyResponse", $$robo$$android_media_MediaDrm$provideKeyResponse(byte[] byte[] ), 1, this, byArray, byArray2);
    }

    private final native /* synthetic */ void $$robo$$restoreKeys$nativeBinding(byte[] var1, byte[] var2);

    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        InvokeDynamicSupport.bootstrap("restoreKeys", $$robo$$android_media_MediaDrm$restoreKeys(byte[] byte[] ), 1, this, byArray, byArray2);
    }

    private final native /* synthetic */ void $$robo$$removeKeys$nativeBinding(byte[] var1);

    public void removeKeys(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("removeKeys", $$robo$$android_media_MediaDrm$removeKeys(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ HashMap<String, String> $$robo$$queryKeyStatus$nativeBinding(byte[] var1);

    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("queryKeyStatus", $$robo$$android_media_MediaDrm$queryKeyStatus(byte[] ), 1, this, byArray);
    }

    public ProvisionRequest getProvisionRequest() {
        return InvokeDynamicSupport.bootstrap("getProvisionRequest", $$robo$$android_media_MediaDrm$getProvisionRequest(), 0, this);
    }

    private final native /* synthetic */ ProvisionRequest $$robo$$getProvisionRequestNative$nativeBinding(int var1, String var2);

    private ProvisionRequest getProvisionRequestNative(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getProvisionRequestNative", $$robo$$android_media_MediaDrm$getProvisionRequestNative(int java.lang.String ), 1, this, n, string2);
    }

    public void provideProvisionResponse(byte[] byArray) throws DeniedByServerException {
        InvokeDynamicSupport.bootstrap("provideProvisionResponse", $$robo$$android_media_MediaDrm$provideProvisionResponse(byte[] ), 0, this, byArray);
    }

    private final native /* synthetic */ Certificate $$robo$$provideProvisionResponseNative$nativeBinding(byte[] var1) throws DeniedByServerException;

    private Certificate provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideProvisionResponseNative", $$robo$$android_media_MediaDrm$provideProvisionResponseNative(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ List<byte[]> $$robo$$getSecureStops$nativeBinding();

    public List<byte[]> getSecureStops() {
        return InvokeDynamicSupport.bootstrap("getSecureStops", $$robo$$android_media_MediaDrm$getSecureStops(), 1, this);
    }

    private final native /* synthetic */ List<byte[]> $$robo$$getSecureStopIds$nativeBinding();

    public List<byte[]> getSecureStopIds() {
        return InvokeDynamicSupport.bootstrap("getSecureStopIds", $$robo$$android_media_MediaDrm$getSecureStopIds(), 1, this);
    }

    private final native /* synthetic */ byte[] $$robo$$getSecureStop$nativeBinding(byte[] var1);

    public byte[] getSecureStop(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getSecureStop", $$robo$$android_media_MediaDrm$getSecureStop(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ void $$robo$$releaseSecureStops$nativeBinding(byte[] var1);

    public void releaseSecureStops(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("releaseSecureStops", $$robo$$android_media_MediaDrm$releaseSecureStops(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ void $$robo$$removeSecureStop$nativeBinding(byte[] var1);

    public void removeSecureStop(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("removeSecureStop", $$robo$$android_media_MediaDrm$removeSecureStop(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ void $$robo$$removeAllSecureStops$nativeBinding();

    public void removeAllSecureStops() {
        InvokeDynamicSupport.bootstrap("removeAllSecureStops", $$robo$$android_media_MediaDrm$removeAllSecureStops(), 1, this);
    }

    public void releaseAllSecureStops() {
        InvokeDynamicSupport.bootstrap("releaseAllSecureStops", $$robo$$android_media_MediaDrm$releaseAllSecureStops(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$getConnectedHdcpLevel$nativeBinding();

    public int getConnectedHdcpLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectedHdcpLevel", $$robo$$android_media_MediaDrm$getConnectedHdcpLevel(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getMaxHdcpLevel$nativeBinding();

    public int getMaxHdcpLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxHdcpLevel", $$robo$$android_media_MediaDrm$getMaxHdcpLevel(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getOpenSessionCount$nativeBinding();

    public int getOpenSessionCount() {
        return (int)InvokeDynamicSupport.bootstrap("getOpenSessionCount", $$robo$$android_media_MediaDrm$getOpenSessionCount(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getMaxSessionCount$nativeBinding();

    public int getMaxSessionCount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxSessionCount", $$robo$$android_media_MediaDrm$getMaxSessionCount(), 1, this);
    }

    public static int getMaxSecurityLevel() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSecurityLevel", $$robo$$android_media_MediaDrm$getMaxSecurityLevel(), 0);
    }

    private final native /* synthetic */ int $$robo$$getSecurityLevel$nativeBinding(byte[] var1);

    public int getSecurityLevel(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("getSecurityLevel", $$robo$$android_media_MediaDrm$getSecurityLevel(byte[] ), 1, this, byArray);
    }

    private final native /* synthetic */ String $$robo$$getPropertyString$nativeBinding(String var1);

    public String getPropertyString(String string2) {
        return InvokeDynamicSupport.bootstrap("getPropertyString", $$robo$$android_media_MediaDrm$getPropertyString(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ void $$robo$$setPropertyString$nativeBinding(String var1, String var2);

    public void setPropertyString(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setPropertyString", $$robo$$android_media_MediaDrm$setPropertyString(java.lang.String java.lang.String ), 1, this, string2, string3);
    }

    private final native /* synthetic */ byte[] $$robo$$getPropertyByteArray$nativeBinding(String var1);

    public byte[] getPropertyByteArray(String string2) {
        return InvokeDynamicSupport.bootstrap("getPropertyByteArray", $$robo$$android_media_MediaDrm$getPropertyByteArray(java.lang.String ), 1, this, string2);
    }

    private final native /* synthetic */ void $$robo$$setPropertyByteArray$nativeBinding(String var1, byte[] var2);

    public void setPropertyByteArray(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setPropertyByteArray", $$robo$$android_media_MediaDrm$setPropertyByteArray(java.lang.String byte[] ), 1, this, string2, byArray);
    }

    private static final native /* synthetic */ void $$robo$$setCipherAlgorithmNative$nativeBinding(MediaDrm var0, byte[] var1, String var2);

    private static void setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setCipherAlgorithmNative", $$robo$$android_media_MediaDrm$setCipherAlgorithmNative(android.media.MediaDrm byte[] java.lang.String ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$setMacAlgorithmNative$nativeBinding(MediaDrm var0, byte[] var1, String var2);

    private static void setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setMacAlgorithmNative", $$robo$$android_media_MediaDrm$setMacAlgorithmNative(android.media.MediaDrm byte[] java.lang.String ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2);
    }

    private static final native /* synthetic */ byte[] $$robo$$encryptNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static byte[] encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return InvokeDynamicSupport.bootstrapStatic("encryptNative", $$robo$$android_media_MediaDrm$encryptNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    private static final native /* synthetic */ byte[] $$robo$$decryptNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static byte[] decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return InvokeDynamicSupport.bootstrapStatic("decryptNative", $$robo$$android_media_MediaDrm$decryptNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    private static final native /* synthetic */ byte[] $$robo$$signNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3);

    private static byte[] signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrapStatic("signNative", $$robo$$android_media_MediaDrm$signNative(android.media.MediaDrm byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3);
    }

    private static final native /* synthetic */ boolean $$robo$$verifyNative$nativeBinding(MediaDrm var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private static boolean verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyNative", $$robo$$android_media_MediaDrm$verifyNative(android.media.MediaDrm byte[] byte[] byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (byte[])byArray2, (byte[])byArray3, (byte[])byArray4);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_MediaDrm$getMetrics(), 0, this);
    }

    private final native /* synthetic */ PersistableBundle $$robo$$getMetricsNative$nativeBinding();

    private PersistableBundle getMetricsNative() {
        return InvokeDynamicSupport.bootstrap("getMetricsNative", $$robo$$android_media_MediaDrm$getMetricsNative(), 1, this);
    }

    public CryptoSession getCryptoSession(byte[] byArray, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getCryptoSession", $$robo$$android_media_MediaDrm$getCryptoSession(byte[] java.lang.String java.lang.String ), 0, this, byArray, string2, string3);
    }

    public CertificateRequest getCertificateRequest(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getCertificateRequest", $$robo$$android_media_MediaDrm$getCertificateRequest(int java.lang.String ), 0, this, n, string2);
    }

    public Certificate provideCertificateResponse(byte[] byArray) throws DeniedByServerException {
        return InvokeDynamicSupport.bootstrap("provideCertificateResponse", $$robo$$android_media_MediaDrm$provideCertificateResponse(byte[] ), 0, this, byArray);
    }

    private static final native /* synthetic */ byte[] $$robo$$signRSANative$nativeBinding(MediaDrm var0, byte[] var1, String var2, byte[] var3, byte[] var4);

    private static byte[] signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrapStatic("signRSANative", $$robo$$android_media_MediaDrm$signRSANative(android.media.MediaDrm byte[] java.lang.String byte[] byte[] ), 1, (MediaDrm)mediaDrm, (byte[])byArray, (String)string2, (byte[])byArray2, (byte[])byArray3);
    }

    public byte[] signRSA(byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrap("signRSA", $$robo$$android_media_MediaDrm$signRSA(byte[] java.lang.String byte[] byte[] ), 0, this, byArray, string2, byArray2, byArray3);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaDrm$finalize(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaDrm$close(), 0, this);
    }

    @Deprecated
    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaDrm$release(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    public void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_MediaDrm$native_release(), 1, this);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaDrm$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding(Object var1, byte[] var2, String var3);

    private void native_setup(Object object, byte[] byArray, String string2) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaDrm$native_setup(java.lang.Object byte[] java.lang.String ), 1, this, object, byArray, string2);
    }

    static {
        RobolectricInternals.classInitializing(MediaDrm.class);
    }

    public /* synthetic */ MediaDrm() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDrm)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MetricsConstants
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";
        public static String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";
        public static String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";
        public static String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";
        public static String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";
        public static String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";
        public static String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";
        public static String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";
        public static String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";
        public static String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";
        public static String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";
        public static String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";
        public static String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";
        public static String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";
        public static String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";
        public static String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";
        public static String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";
        public static String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";
        public static String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";
        public static String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";
        public static String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";
        public static String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";
        public static String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";
        public static String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";
        public static String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";
        public static String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";
        public static String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";
        public static String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";
        public static String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";
        public static String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";
        public static String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";
        public static String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";
        public static String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";
        public static String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";
        public static String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";

        private void $$robo$$android_media_MediaDrm_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_MetricsConstants$__constructor__();
        }

        private MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_MetricsConstants$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Certificate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mWrappedKey;
        private byte[] mCertificateData;

        private void $$robo$$android_media_MediaDrm_Certificate$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_Certificate$getWrappedPrivateKey() {
            if (this.mWrappedKey == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mWrappedKey;
        }

        private final byte[] $$robo$$android_media_MediaDrm_Certificate$getContent() {
            if (this.mCertificateData == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mCertificateData;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_Certificate$__constructor__();
        }

        Certificate() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_Certificate$__constructor__(), 0, this);
        }

        public byte[] getWrappedPrivateKey() {
            return InvokeDynamicSupport.bootstrap("getWrappedPrivateKey", $$robo$$android_media_MediaDrm_Certificate$getWrappedPrivateKey(), 0, this);
        }

        public byte[] getContent() {
            return InvokeDynamicSupport.bootstrap("getContent", $$robo$$android_media_MediaDrm_Certificate$getContent(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Certificate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class CertificateRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;

        private void $$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byte[] data, String defaultUrl) {
            this.mData = data;
            this.mDefaultUrl = defaultUrl;
        }

        private final byte[] $$robo$$android_media_MediaDrm_CertificateRequest$getData() {
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_CertificateRequest$getDefaultUrl() {
            return this.mDefaultUrl;
        }

        private void __constructor__(byte[] byArray, String string2) {
            this.$$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byArray, string2);
        }

        CertificateRequest(byte[] byArray, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_CertificateRequest$__constructor__(byte[] java.lang.String ), 0, this, byArray, string2);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_CertificateRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_CertificateRequest$getDefaultUrl(), 0, this);
        }

        public /* synthetic */ CertificateRequest() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CertificateRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class CryptoSession
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mSessionId;
        /* synthetic */ MediaDrm this$0;

        private void $$robo$$android_media_MediaDrm_CryptoSession$__constructor__(MediaDrm this$0, byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            MediaDrm.setCipherAlgorithmNative(this$0, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(this$0, sessionId, macAlgorithm);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(this.this$0, this.mSessionId, keyid, input, iv);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(this.this$0, this.mSessionId, keyid, input, iv);
        }

        private final byte[] $$robo$$android_media_MediaDrm_CryptoSession$sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(this.this$0, this.mSessionId, keyid, message);
        }

        private final boolean $$robo$$android_media_MediaDrm_CryptoSession$verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(this.this$0, this.mSessionId, keyid, message, signature);
        }

        private void __constructor__(MediaDrm mediaDrm, byte[] byArray, String string2, String string3) {
            this.$$robo$$android_media_MediaDrm_CryptoSession$__constructor__(mediaDrm, byArray, string2, string3);
        }

        CryptoSession(MediaDrm mediaDrm, byte[] byArray, String string2, String string3) {
            this.this$0 = mediaDrm;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_CryptoSession$__constructor__(android.media.MediaDrm byte[] java.lang.String java.lang.String ), 0, this, mediaDrm, byArray, string2, string3);
        }

        public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return InvokeDynamicSupport.bootstrap("encrypt", $$robo$$android_media_MediaDrm_CryptoSession$encrypt(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return InvokeDynamicSupport.bootstrap("decrypt", $$robo$$android_media_MediaDrm_CryptoSession$decrypt(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public byte[] sign(byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("sign", $$robo$$android_media_MediaDrm_CryptoSession$sign(byte[] byte[] ), 0, this, byArray, byArray2);
        }

        public boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$android_media_MediaDrm_CryptoSession$verify(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
        }

        public /* synthetic */ CryptoSession() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoSession)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ArrayProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdcpLevel {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProvisionRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;

        private void $$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_ProvisionRequest$getData() {
            if (this.mData == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_ProvisionRequest$getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mDefaultUrl;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__();
        }

        ProvisionRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_ProvisionRequest$__constructor__(), 0, this);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_ProvisionRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_ProvisionRequest$getDefaultUrl(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisionRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class KeyRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mData;
        private String mDefaultUrl;
        private int mRequestType;
        public static int REQUEST_TYPE_INITIAL = 0;
        public static int REQUEST_TYPE_RENEWAL = 1;
        public static int REQUEST_TYPE_RELEASE = 2;
        public static int REQUEST_TYPE_NONE = 3;
        public static int REQUEST_TYPE_UPDATE = 4;

        private void $$robo$$android_media_MediaDrm_KeyRequest$__constructor__() {
        }

        private final byte[] $$robo$$android_media_MediaDrm_KeyRequest$getData() {
            if (this.mData == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mData;
        }

        private final String $$robo$$android_media_MediaDrm_KeyRequest$getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mDefaultUrl;
        }

        private final int $$robo$$android_media_MediaDrm_KeyRequest$getRequestType() {
            return this.mRequestType;
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaDrm_KeyRequest$__constructor__();
        }

        KeyRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_KeyRequest$__constructor__(), 0, this);
        }

        public byte[] getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_media_MediaDrm_KeyRequest$getData(), 0, this);
        }

        public String getDefaultUrl() {
            return InvokeDynamicSupport.bootstrap("getDefaultUrl", $$robo$$android_media_MediaDrm_KeyRequest$getDefaultUrl(), 0, this);
        }

        public int getRequestType() {
            return (int)InvokeDynamicSupport.bootstrap("getRequestType", $$robo$$android_media_MediaDrm_KeyRequest$getRequestType(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyType {
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaDrm mMediaDrm;
        /* synthetic */ MediaDrm this$0;

        private void $$robo$$android_media_MediaDrm_EventHandler$__constructor__(MediaDrm mediaDrm, MediaDrm md, Looper looper) {
            this.mMediaDrm = md;
        }

        private final void $$robo$$android_media_MediaDrm_EventHandler$handleMessage(Message msg) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w("MediaDrm", "MediaDrm went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 200: {
                    if (this.this$0.mOnEventListener != null && msg.obj != null && msg.obj instanceof Parcel) {
                        byte[] data;
                        Parcel parcel = (Parcel)msg.obj;
                        byte[] sessionId = parcel.createByteArray();
                        if (sessionId.length == 0) {
                            sessionId = null;
                        }
                        if ((data = parcel.createByteArray()).length == 0) {
                            data = null;
                        }
                        Log.i("MediaDrm", "Drm event (" + msg.arg1 + "," + msg.arg2 + ")");
                        this.this$0.mOnEventListener.onEvent(this.mMediaDrm, sessionId, msg.arg1, msg.arg2, data);
                    }
                    return;
                }
                case 202: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (this.this$0.mOnKeyStatusChangeListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        List keyStatusList = this.this$0.keyStatusListFromParcel(parcel);
                        boolean hasNewUsableKey = parcel.readInt() != 0;
                        Log.i("MediaDrm", "Drm key status changed");
                        this.this$0.mOnKeyStatusChangeListener.onKeyStatusChange(this.mMediaDrm, sessionId, keyStatusList, hasNewUsableKey);
                    }
                    return;
                }
                case 201: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (this.this$0.mOnExpirationUpdateListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        long expirationTime = parcel.readLong();
                        Log.i("MediaDrm", "Drm key expiration update: " + expirationTime);
                        this.this$0.mOnExpirationUpdateListener.onExpirationUpdate(this.mMediaDrm, sessionId, expirationTime);
                    }
                    return;
                }
            }
            Log.e("MediaDrm", "Unknown message type " + msg.what);
        }

        private void __constructor__(MediaDrm mediaDrm, MediaDrm mediaDrm2, Looper looper) {
            this.$$robo$$android_media_MediaDrm_EventHandler$__constructor__(mediaDrm, mediaDrm2, looper);
        }

        public EventHandler(MediaDrm mediaDrm, MediaDrm mediaDrm2, Looper looper) {
            this.this$0 = mediaDrm;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_EventHandler$__constructor__(android.media.MediaDrm android.media.MediaDrm android.os.Looper ), 0, this, mediaDrm, mediaDrm2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaDrm_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrmEvent {
    }

    public static interface OnEventListener
    extends InstrumentedInterface {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class KeyStatus
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mKeyId;
        private int mStatusCode;
        public static int STATUS_USABLE = 0;
        public static int STATUS_EXPIRED = 1;
        public static int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static int STATUS_PENDING = 3;
        public static int STATUS_INTERNAL_ERROR = 4;

        private void $$robo$$android_media_MediaDrm_KeyStatus$__constructor__(byte[] keyId, int statusCode) {
            this.mKeyId = keyId;
            this.mStatusCode = statusCode;
        }

        private final int $$robo$$android_media_MediaDrm_KeyStatus$getStatusCode() {
            return this.mStatusCode;
        }

        private final byte[] $$robo$$android_media_MediaDrm_KeyStatus$getKeyId() {
            return this.mKeyId;
        }

        private void __constructor__(byte[] byArray, int n) {
            this.$$robo$$android_media_MediaDrm_KeyStatus$__constructor__(byArray, n);
        }

        KeyStatus(byte[] byArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_KeyStatus$__constructor__(byte[] int ), 0, this, byArray, n);
        }

        public int getStatusCode() {
            return (int)InvokeDynamicSupport.bootstrap("getStatusCode", $$robo$$android_media_MediaDrm_KeyStatus$getStatusCode(), 0, this);
        }

        public byte[] getKeyId() {
            return InvokeDynamicSupport.bootstrap("getKeyId", $$robo$$android_media_MediaDrm_KeyStatus$getKeyId(), 0, this);
        }

        public /* synthetic */ KeyStatus() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStatus)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface KeyStatusCode {
        }
    }

    public static interface OnKeyStatusChangeListener
    extends InstrumentedInterface {
        public void onKeyStatusChange(MediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener
    extends InstrumentedInterface {
        public void onExpirationUpdate(MediaDrm var1, byte[] var2, long var3);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MediaDrmStateException
    extends IllegalStateException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mErrorCode;
        private String mDiagnosticInfo;

        private void $$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(int errorCode, String detailMessage) {
            this.mErrorCode = errorCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + sign + Math.abs(errorCode);
        }

        private final int $$robo$$android_media_MediaDrm_MediaDrmStateException$getErrorCode() {
            return this.mErrorCode;
        }

        private final String $$robo$$android_media_MediaDrm_MediaDrmStateException$getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(n, string2);
        }

        public MediaDrmStateException(int n, String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaDrm_MediaDrmStateException$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public int getErrorCode() {
            return (int)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_media_MediaDrm_MediaDrmStateException$getErrorCode(), 0, this);
        }

        public String getDiagnosticInfo() {
            return InvokeDynamicSupport.bootstrap("getDiagnosticInfo", $$robo$$android_media_MediaDrm_MediaDrmStateException$getDiagnosticInfo(), 0, this);
        }

        public /* synthetic */ MediaDrmStateException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaDrmStateException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CertificateType {
    }
}

