/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.hardware.Camera;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRouting;
import android.media.CamcorderProfile;
import android.media.MediaCodec;
import android.media.MicrophoneInfo;
import android.media.NativeRoutingEventHandlerDelegate;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRecorder
implements AudioRouting,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaRecorder";
    private long mNativeContext;
    private Surface mSurface;
    private String mPath;
    private FileDescriptor mFd;
    private File mFile;
    private EventHandler mEventHandler;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private int mChannelCount;
    public static int MEDIA_RECORDER_ERROR_UNKNOWN = 1;
    public static int MEDIA_ERROR_SERVER_DIED = 100;
    public static int MEDIA_RECORDER_INFO_UNKNOWN = 1;
    public static int MEDIA_RECORDER_INFO_MAX_DURATION_REACHED = 800;
    public static int MEDIA_RECORDER_INFO_MAX_FILESIZE_REACHED = 801;
    public static int MEDIA_RECORDER_INFO_MAX_FILESIZE_APPROACHING = 802;
    public static int MEDIA_RECORDER_INFO_NEXT_OUTPUT_FILE_STARTED = 803;
    public static int MEDIA_RECORDER_TRACK_INFO_LIST_START = 1000;
    public static int MEDIA_RECORDER_TRACK_INFO_COMPLETION_STATUS = 1000;
    public static int MEDIA_RECORDER_TRACK_INFO_PROGRESS_IN_TIME = 1001;
    public static int MEDIA_RECORDER_TRACK_INFO_TYPE = 1002;
    public static int MEDIA_RECORDER_TRACK_INFO_DURATION_MS = 1003;
    public static int MEDIA_RECORDER_TRACK_INFO_MAX_CHUNK_DUR_MS = 1004;
    public static int MEDIA_RECORDER_TRACK_INFO_ENCODED_FRAMES = 1005;
    public static int MEDIA_RECORDER_TRACK_INTER_CHUNK_TIME_MS = 1006;
    public static int MEDIA_RECORDER_TRACK_INFO_INITIAL_DELAY_MS = 1007;
    public static int MEDIA_RECORDER_TRACK_INFO_START_OFFSET_MS = 1008;
    public static int MEDIA_RECORDER_TRACK_INFO_DATA_KBYTES = 1009;
    public static int MEDIA_RECORDER_TRACK_INFO_LIST_END = 2000;
    private AudioDeviceInfo mPreferredDevice;
    @GuardedBy(value="mRoutingChangeListeners")
    private ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> mRoutingChangeListeners;

    private void $$robo$$android_media_MediaRecorder$__constructor__() {
        this.mPreferredDevice = null;
        this.mRoutingChangeListeners = new ArrayMap();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.mChannelCount = 1;
        String packageName = ActivityThread.currentPackageName();
        this.native_setup(new WeakReference<MediaRecorder>(this), packageName, ActivityThread.currentOpPackageName());
    }

    @Deprecated
    private final void $$robo$$android_media_MediaRecorder$setCamera(Camera camera) {
    }

    private final Surface $$robo$$android_media_MediaRecorder$getSurface() {
        return null;
    }

    private final void $$robo$$android_media_MediaRecorder$setInputSurface(Surface surface) {
        if (!(surface instanceof MediaCodec.PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private final void $$robo$$android_media_MediaRecorder$native_setInputSurface(Surface surface) {
    }

    private final void $$robo$$android_media_MediaRecorder$setPreviewDisplay(Surface sv) {
        this.mSurface = sv;
    }

    private static final boolean $$robo$$android_media_MediaRecorder$isSystemOnlyAudioSource(int source) {
        switch (source) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    private static final String $$robo$$android_media_MediaRecorder$toLogFriendlyAudioSource(int source) {
        switch (source) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "MIC";
            }
            case 2: {
                return "VOICE_UPLINK";
            }
            case 3: {
                return "VOICE_DOWNLINK";
            }
            case 4: {
                return "VOICE_CALL";
            }
            case 5: {
                return "CAMCORDER";
            }
            case 6: {
                return "VOICE_RECOGNITION";
            }
            case 7: {
                return "VOICE_COMMUNICATION";
            }
            case 8: {
                return "REMOTE_SUBMIX";
            }
            case 9: {
                return "UNPROCESSED";
            }
            case 1998: {
                return "RADIO_TUNER";
            }
            case 1999: {
                return "HOTWORD";
            }
            case -1: {
                return "AUDIO_SOURCE_INVALID";
            }
        }
        return "unknown source " + source;
    }

    private final void $$robo$$android_media_MediaRecorder$setAudioSource(int n) throws IllegalStateException {
    }

    private static final int $$robo$$android_media_MediaRecorder$getAudioSourceMax() {
        return 9;
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoSource(int n) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setProfile(CamcorderProfile profile) {
        this.setOutputFormat(profile.fileFormat);
        this.setVideoFrameRate(profile.videoFrameRate);
        this.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        this.setVideoEncodingBitRate(profile.videoBitRate);
        this.setVideoEncoder(profile.videoCodec);
        if (profile.quality < 1000 || profile.quality > 1007) {
            this.setAudioEncodingBitRate(profile.audioBitRate);
            this.setAudioChannels(profile.audioChannels);
            this.setAudioSamplingRate(profile.audioSampleRate);
            this.setAudioEncoder(profile.audioCodec);
        }
    }

    private final void $$robo$$android_media_MediaRecorder$setCaptureRate(double fps) {
        this.setParameter("time-lapse-enable=1");
        this.setParameter("time-lapse-fps=" + fps);
    }

    private final void $$robo$$android_media_MediaRecorder$setOrientationHint(int degrees) {
        if (degrees != 0 && degrees != 90 && degrees != 180 && degrees != 270) {
            throw new IllegalArgumentException("Unsupported angle: " + degrees);
        }
        this.setParameter("video-param-rotation-angle-degrees=" + degrees);
    }

    private final void $$robo$$android_media_MediaRecorder$setLocation(float latitude, float longitude) {
        int latitudex10000 = (int)((double)(latitude * 10000.0f) + 0.5);
        int longitudex10000 = (int)((double)(longitude * 10000.0f) + 0.5);
        if (latitudex10000 > 900000 || latitudex10000 < -900000) {
            String msg = "Latitude: " + latitude + " out of range.";
            throw new IllegalArgumentException(msg);
        }
        if (longitudex10000 > 1800000 || longitudex10000 < -1800000) {
            String msg = "Longitude: " + longitude + " out of range";
            throw new IllegalArgumentException(msg);
        }
        this.setParameter("param-geotag-latitude=" + latitudex10000);
        this.setParameter("param-geotag-longitude=" + longitudex10000);
    }

    private final void $$robo$$android_media_MediaRecorder$setOutputFormat(int n) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoSize(int n, int n2) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoFrameRate(int n) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setMaxDuration(int n) throws IllegalArgumentException {
    }

    private final void $$robo$$android_media_MediaRecorder$setMaxFileSize(long l) throws IllegalArgumentException {
    }

    private final void $$robo$$android_media_MediaRecorder$setAudioEncoder(int n) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoEncoder(int n) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$setAudioSamplingRate(int samplingRate) {
        if (samplingRate <= 0) {
            throw new IllegalArgumentException("Audio sampling rate is not positive");
        }
        this.setParameter("audio-param-sampling-rate=" + samplingRate);
    }

    private final void $$robo$$android_media_MediaRecorder$setAudioChannels(int numChannels) {
        if (numChannels <= 0) {
            throw new IllegalArgumentException("Number of channels is not positive");
        }
        this.mChannelCount = numChannels;
        this.setParameter("audio-param-number-of-channels=" + numChannels);
    }

    private final void $$robo$$android_media_MediaRecorder$setAudioEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Audio encoding bit rate is not positive");
        }
        this.setParameter("audio-param-encoding-bitrate=" + bitRate);
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoEncodingBitRate(int bitRate) {
        if (bitRate <= 0) {
            throw new IllegalArgumentException("Video encoding bit rate is not positive");
        }
        this.setParameter("video-param-encoding-bitrate=" + bitRate);
    }

    private final void $$robo$$android_media_MediaRecorder$setVideoEncodingProfileLevel(int profile, int level) {
        if (profile <= 0) {
            throw new IllegalArgumentException("Video encoding profile is not positive");
        }
        if (level <= 0) {
            throw new IllegalArgumentException("Video encoding level is not positive");
        }
        this.setParameter("video-param-encoder-profile=" + profile);
        this.setParameter("video-param-encoder-level=" + level);
    }

    private final void $$robo$$android_media_MediaRecorder$setAuxiliaryOutputFile(FileDescriptor fd) {
        Log.w("MediaRecorder", "setAuxiliaryOutputFile(FileDescriptor) is no longer supported.");
    }

    private final void $$robo$$android_media_MediaRecorder$setAuxiliaryOutputFile(String path) {
        Log.w("MediaRecorder", "setAuxiliaryOutputFile(String) is no longer supported.");
    }

    private final void $$robo$$android_media_MediaRecorder$setOutputFile(FileDescriptor fd) throws IllegalStateException {
        this.mPath = null;
        this.mFile = null;
        this.mFd = fd;
    }

    private final void $$robo$$android_media_MediaRecorder$setOutputFile(File file) {
        this.mPath = null;
        this.mFd = null;
        this.mFile = file;
    }

    private final void $$robo$$android_media_MediaRecorder$setNextOutputFile(FileDescriptor fd) throws IOException {
        this._setNextOutputFile(fd);
    }

    private final void $$robo$$android_media_MediaRecorder$setOutputFile(String path) throws IllegalStateException {
        this.mFd = null;
        this.mFile = null;
        this.mPath = path;
    }

    private final void $$robo$$android_media_MediaRecorder$setNextOutputFile(File file) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");){
            this._setNextOutputFile(f.getFD());
        }
    }

    private final void $$robo$$android_media_MediaRecorder$_setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
    }

    private final void $$robo$$android_media_MediaRecorder$_setNextOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
    }

    private final void $$robo$$android_media_MediaRecorder$_prepare() throws IllegalStateException, IOException {
    }

    private final void $$robo$$android_media_MediaRecorder$prepare() throws IllegalStateException, IOException {
        if (this.mPath != null) {
            try (RandomAccessFile file = new RandomAccessFile(this.mPath, "rw");){
                this._setOutputFile(file.getFD());
            }
        } else if (this.mFd != null) {
            this._setOutputFile(this.mFd);
        } else if (this.mFile != null) {
            try (RandomAccessFile file = new RandomAccessFile(this.mFile, "rw");){
                this._setOutputFile(file.getFD());
            }
        } else {
            throw new IOException("No valid output file");
        }
        this._prepare();
    }

    private final void $$robo$$android_media_MediaRecorder$start() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$stop() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$pause() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$resume() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$reset() {
        this.native_reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
    }

    private final void $$robo$$android_media_MediaRecorder$native_reset() {
    }

    private final int $$robo$$android_media_MediaRecorder$getMaxAmplitude() throws IllegalStateException {
        return 0;
    }

    private final void $$robo$$android_media_MediaRecorder$setOnErrorListener(OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    private final void $$robo$$android_media_MediaRecorder$setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_MediaRecorder$setPreferredDevice(AudioDeviceInfo deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isSource()) {
            return false;
        }
        int preferredDeviceId = deviceInfo != null ? deviceInfo.getId() : 0;
        boolean status = this.native_setInputDevice(preferredDeviceId);
        if (status) {
            MediaRecorder mediaRecorder = this;
            synchronized (mediaRecorder) {
                this.mPreferredDevice = deviceInfo;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AudioDeviceInfo $$robo$$android_media_MediaRecorder$getPreferredDevice() {
        MediaRecorder mediaRecorder = this;
        synchronized (mediaRecorder) {
            return this.mPreferredDevice;
        }
    }

    private final AudioDeviceInfo $$robo$$android_media_MediaRecorder$getRoutedDevice() {
        int deviceId = this.native_getRoutedDeviceId();
        if (deviceId == 0) {
            return null;
        }
        AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
        for (int i = 0; i < devices.length; ++i) {
            if (devices[i].getId() != deviceId) continue;
            return devices[i];
        }
        return null;
    }

    @GuardedBy(value="mRoutingChangeListeners")
    private final void $$robo$$android_media_MediaRecorder$enableNativeRoutingCallbacksLocked(boolean enabled) {
        if (this.mRoutingChangeListeners.size() == 0) {
            this.native_enableDeviceCallback(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaRecorder$addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (listener != null && !this.mRoutingChangeListeners.containsKey(listener)) {
                this.enableNativeRoutingCallbacksLocked(true);
                this.mRoutingChangeListeners.put(listener, new NativeRoutingEventHandlerDelegate(this, listener, handler != null ? handler : this.mEventHandler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaRecorder$removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        ArrayMap<AudioRouting.OnRoutingChangedListener, NativeRoutingEventHandlerDelegate> arrayMap = this.mRoutingChangeListeners;
        synchronized (arrayMap) {
            if (this.mRoutingChangeListeners.containsKey(listener)) {
                this.mRoutingChangeListeners.remove(listener);
                this.enableNativeRoutingCallbacksLocked(false);
            }
        }
    }

    private final boolean $$robo$$android_media_MediaRecorder$native_setInputDevice(int n) {
        return false;
    }

    private final int $$robo$$android_media_MediaRecorder$native_getRoutedDeviceId() {
        return 0;
    }

    private final void $$robo$$android_media_MediaRecorder$native_enableDeviceCallback(boolean bl) {
    }

    private final List<MicrophoneInfo> $$robo$$android_media_MediaRecorder$getActiveMicrophones() throws IOException {
        AudioDeviceInfo device;
        ArrayList<MicrophoneInfo> activeMicrophones = new ArrayList<MicrophoneInfo>();
        int status = this.native_getActiveMicrophones(activeMicrophones);
        if (status != 0) {
            if (status != -3) {
                Log.e("MediaRecorder", "getActiveMicrophones failed:" + status);
            }
            Log.i("MediaRecorder", "getActiveMicrophones failed, fallback on routed device info");
        }
        AudioManager.setPortIdForMicrophones(activeMicrophones);
        if (activeMicrophones.size() == 0 && (device = this.getRoutedDevice()) != null) {
            MicrophoneInfo microphone = AudioManager.microphoneInfoFromAudioDeviceInfo(device);
            ArrayList<Pair<Integer, Integer>> channelMapping = new ArrayList<Pair<Integer, Integer>>();
            for (int i = 0; i < this.mChannelCount; ++i) {
                channelMapping.add(new Pair<Integer, Integer>(i, 1));
            }
            microphone.setChannelMapping(channelMapping);
            activeMicrophones.add(microphone);
        }
        return activeMicrophones;
    }

    private final int $$robo$$android_media_MediaRecorder$native_getActiveMicrophones(ArrayList<MicrophoneInfo> arrayList) {
        return 0;
    }

    private static final void $$robo$$android_media_MediaRecorder$postEventFromNative(Object mediarecorder_ref, int what, int arg1, int arg2, Object obj) {
        MediaRecorder mr = (MediaRecorder)((WeakReference)mediarecorder_ref).get();
        if (mr == null) {
            return;
        }
        if (mr.mEventHandler != null) {
            Message m = mr.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mr.mEventHandler.sendMessage(m);
        }
    }

    private final void $$robo$$android_media_MediaRecorder$release() {
    }

    private static final void $$robo$$android_media_MediaRecorder$native_init() {
    }

    private final void $$robo$$android_media_MediaRecorder$native_setup(Object object, String string2, String string3) throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaRecorder$native_finalize() {
    }

    private final void $$robo$$android_media_MediaRecorder$setParameter(String string2) {
    }

    private final PersistableBundle $$robo$$android_media_MediaRecorder$getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private final PersistableBundle $$robo$$android_media_MediaRecorder$native_getMetrics() {
        return null;
    }

    private final void $$robo$$android_media_MediaRecorder$finalize() {
        this.native_finalize();
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaRecorder.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaRecorder$__constructor__();
    }

    public MediaRecorder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder$__constructor__(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$setCamera$nativeBinding(Camera var1);

    @Deprecated
    public void setCamera(Camera camera) {
        InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_media_MediaRecorder$setCamera(android.hardware.Camera ), 1, this, camera);
    }

    private final native /* synthetic */ Surface $$robo$$getSurface$nativeBinding();

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_media_MediaRecorder$getSurface(), 1, this);
    }

    public void setInputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setInputSurface", $$robo$$android_media_MediaRecorder$setInputSurface(android.view.Surface ), 0, this, surface);
    }

    private final native /* synthetic */ void $$robo$$native_setInputSurface$nativeBinding(Surface var1);

    private void native_setInputSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("native_setInputSurface", $$robo$$android_media_MediaRecorder$native_setInputSurface(android.view.Surface ), 1, this, surface);
    }

    public void setPreviewDisplay(Surface surface) {
        InvokeDynamicSupport.bootstrap("setPreviewDisplay", $$robo$$android_media_MediaRecorder$setPreviewDisplay(android.view.Surface ), 0, this, surface);
    }

    public static boolean isSystemOnlyAudioSource(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemOnlyAudioSource", $$robo$$android_media_MediaRecorder$isSystemOnlyAudioSource(int ), 0, (int)n);
    }

    public static String toLogFriendlyAudioSource(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toLogFriendlyAudioSource", $$robo$$android_media_MediaRecorder$toLogFriendlyAudioSource(int ), 0, (int)n);
    }

    private final native /* synthetic */ void $$robo$$setAudioSource$nativeBinding(int var1) throws IllegalStateException;

    public void setAudioSource(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setAudioSource", $$robo$$android_media_MediaRecorder$setAudioSource(int ), 1, this, n);
    }

    public static int getAudioSourceMax() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAudioSourceMax", $$robo$$android_media_MediaRecorder$getAudioSourceMax(), 0);
    }

    private final native /* synthetic */ void $$robo$$setVideoSource$nativeBinding(int var1) throws IllegalStateException;

    public void setVideoSource(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setVideoSource", $$robo$$android_media_MediaRecorder$setVideoSource(int ), 1, this, n);
    }

    public void setProfile(CamcorderProfile camcorderProfile) {
        InvokeDynamicSupport.bootstrap("setProfile", $$robo$$android_media_MediaRecorder$setProfile(android.media.CamcorderProfile ), 0, this, camcorderProfile);
    }

    public void setCaptureRate(double d) {
        InvokeDynamicSupport.bootstrap("setCaptureRate", $$robo$$android_media_MediaRecorder$setCaptureRate(double ), 0, this, d);
    }

    public void setOrientationHint(int n) {
        InvokeDynamicSupport.bootstrap("setOrientationHint", $$robo$$android_media_MediaRecorder$setOrientationHint(int ), 0, this, n);
    }

    public void setLocation(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setLocation", $$robo$$android_media_MediaRecorder$setLocation(float float ), 0, this, f, f2);
    }

    private final native /* synthetic */ void $$robo$$setOutputFormat$nativeBinding(int var1) throws IllegalStateException;

    public void setOutputFormat(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setOutputFormat", $$robo$$android_media_MediaRecorder$setOutputFormat(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$setVideoSize$nativeBinding(int var1, int var2) throws IllegalStateException;

    public void setVideoSize(int n, int n2) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setVideoSize", $$robo$$android_media_MediaRecorder$setVideoSize(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ void $$robo$$setVideoFrameRate$nativeBinding(int var1) throws IllegalStateException;

    public void setVideoFrameRate(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setVideoFrameRate", $$robo$$android_media_MediaRecorder$setVideoFrameRate(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$setMaxDuration$nativeBinding(int var1) throws IllegalArgumentException;

    public void setMaxDuration(int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setMaxDuration", $$robo$$android_media_MediaRecorder$setMaxDuration(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$setMaxFileSize$nativeBinding(long var1) throws IllegalArgumentException;

    public void setMaxFileSize(long l) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setMaxFileSize", $$robo$$android_media_MediaRecorder$setMaxFileSize(long ), 1, this, l);
    }

    private final native /* synthetic */ void $$robo$$setAudioEncoder$nativeBinding(int var1) throws IllegalStateException;

    public void setAudioEncoder(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setAudioEncoder", $$robo$$android_media_MediaRecorder$setAudioEncoder(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$setVideoEncoder$nativeBinding(int var1) throws IllegalStateException;

    public void setVideoEncoder(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setVideoEncoder", $$robo$$android_media_MediaRecorder$setVideoEncoder(int ), 1, this, n);
    }

    public void setAudioSamplingRate(int n) {
        InvokeDynamicSupport.bootstrap("setAudioSamplingRate", $$robo$$android_media_MediaRecorder$setAudioSamplingRate(int ), 0, this, n);
    }

    public void setAudioChannels(int n) {
        InvokeDynamicSupport.bootstrap("setAudioChannels", $$robo$$android_media_MediaRecorder$setAudioChannels(int ), 0, this, n);
    }

    public void setAudioEncodingBitRate(int n) {
        InvokeDynamicSupport.bootstrap("setAudioEncodingBitRate", $$robo$$android_media_MediaRecorder$setAudioEncodingBitRate(int ), 0, this, n);
    }

    public void setVideoEncodingBitRate(int n) {
        InvokeDynamicSupport.bootstrap("setVideoEncodingBitRate", $$robo$$android_media_MediaRecorder$setVideoEncodingBitRate(int ), 0, this, n);
    }

    public void setVideoEncodingProfileLevel(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVideoEncodingProfileLevel", $$robo$$android_media_MediaRecorder$setVideoEncodingProfileLevel(int int ), 0, this, n, n2);
    }

    public void setAuxiliaryOutputFile(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("setAuxiliaryOutputFile", $$robo$$android_media_MediaRecorder$setAuxiliaryOutputFile(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public void setAuxiliaryOutputFile(String string2) {
        InvokeDynamicSupport.bootstrap("setAuxiliaryOutputFile", $$robo$$android_media_MediaRecorder$setAuxiliaryOutputFile(java.lang.String ), 0, this, string2);
    }

    public void setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setOutputFile", $$robo$$android_media_MediaRecorder$setOutputFile(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public void setOutputFile(File file) {
        InvokeDynamicSupport.bootstrap("setOutputFile", $$robo$$android_media_MediaRecorder$setOutputFile(java.io.File ), 0, this, file);
    }

    public void setNextOutputFile(FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrap("setNextOutputFile", $$robo$$android_media_MediaRecorder$setNextOutputFile(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public void setOutputFile(String string2) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("setOutputFile", $$robo$$android_media_MediaRecorder$setOutputFile(java.lang.String ), 0, this, string2);
    }

    public void setNextOutputFile(File file) throws IOException {
        InvokeDynamicSupport.bootstrap("setNextOutputFile", $$robo$$android_media_MediaRecorder$setNextOutputFile(java.io.File ), 0, this, file);
    }

    private final native /* synthetic */ void $$robo$$_setOutputFile$nativeBinding(FileDescriptor var1) throws IllegalStateException, IOException;

    private void _setOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
        InvokeDynamicSupport.bootstrap("_setOutputFile", $$robo$$android_media_MediaRecorder$_setOutputFile(java.io.FileDescriptor ), 1, this, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$_setNextOutputFile$nativeBinding(FileDescriptor var1) throws IllegalStateException, IOException;

    private void _setNextOutputFile(FileDescriptor fileDescriptor) throws IllegalStateException, IOException {
        InvokeDynamicSupport.bootstrap("_setNextOutputFile", $$robo$$android_media_MediaRecorder$_setNextOutputFile(java.io.FileDescriptor ), 1, this, fileDescriptor);
    }

    private final native /* synthetic */ void $$robo$$_prepare$nativeBinding() throws IllegalStateException, IOException;

    private void _prepare() throws IllegalStateException, IOException {
        InvokeDynamicSupport.bootstrap("_prepare", $$robo$$android_media_MediaRecorder$_prepare(), 1, this);
    }

    public void prepare() throws IllegalStateException, IOException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_media_MediaRecorder$prepare(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$start$nativeBinding() throws IllegalStateException;

    public void start() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_MediaRecorder$start(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$stop$nativeBinding() throws IllegalStateException;

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_MediaRecorder$stop(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$pause$nativeBinding() throws IllegalStateException;

    public void pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_MediaRecorder$pause(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$resume$nativeBinding() throws IllegalStateException;

    public void resume() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_MediaRecorder$resume(), 1, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_MediaRecorder$reset(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$native_reset$nativeBinding();

    private void native_reset() {
        InvokeDynamicSupport.bootstrap("native_reset", $$robo$$android_media_MediaRecorder$native_reset(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getMaxAmplitude$nativeBinding() throws IllegalStateException;

    public int getMaxAmplitude() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAmplitude", $$robo$$android_media_MediaRecorder$getMaxAmplitude(), 1, this);
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        InvokeDynamicSupport.bootstrap("setOnErrorListener", $$robo$$android_media_MediaRecorder$setOnErrorListener(android.media.MediaRecorder$OnErrorListener ), 0, this, onErrorListener);
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        InvokeDynamicSupport.bootstrap("setOnInfoListener", $$robo$$android_media_MediaRecorder$setOnInfoListener(android.media.MediaRecorder$OnInfoListener ), 0, this, onInfoListener);
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo audioDeviceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredDevice", $$robo$$android_media_MediaRecorder$setPreferredDevice(android.media.AudioDeviceInfo ), 0, this, audioDeviceInfo);
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        return InvokeDynamicSupport.bootstrap("getPreferredDevice", $$robo$$android_media_MediaRecorder$getPreferredDevice(), 0, this);
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        return InvokeDynamicSupport.bootstrap("getRoutedDevice", $$robo$$android_media_MediaRecorder$getRoutedDevice(), 0, this);
    }

    private void enableNativeRoutingCallbacksLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableNativeRoutingCallbacksLocked", $$robo$$android_media_MediaRecorder$enableNativeRoutingCallbacksLocked(boolean ), 0, this, bl);
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnRoutingChangedListener", $$robo$$android_media_MediaRecorder$addOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener android.os.Handler ), 0, this, onRoutingChangedListener, handler);
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener onRoutingChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnRoutingChangedListener", $$robo$$android_media_MediaRecorder$removeOnRoutingChangedListener(android.media.AudioRouting$OnRoutingChangedListener ), 0, this, onRoutingChangedListener);
    }

    private final native /* synthetic */ boolean $$robo$$native_setInputDevice$nativeBinding(int var1);

    private boolean native_setInputDevice(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_setInputDevice", $$robo$$android_media_MediaRecorder$native_setInputDevice(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$native_getRoutedDeviceId$nativeBinding();

    private int native_getRoutedDeviceId() {
        return (int)InvokeDynamicSupport.bootstrap("native_getRoutedDeviceId", $$robo$$android_media_MediaRecorder$native_getRoutedDeviceId(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$native_enableDeviceCallback$nativeBinding(boolean var1);

    private void native_enableDeviceCallback(boolean bl) {
        InvokeDynamicSupport.bootstrap("native_enableDeviceCallback", $$robo$$android_media_MediaRecorder$native_enableDeviceCallback(boolean ), 1, this, bl);
    }

    public List<MicrophoneInfo> getActiveMicrophones() throws IOException {
        return InvokeDynamicSupport.bootstrap("getActiveMicrophones", $$robo$$android_media_MediaRecorder$getActiveMicrophones(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$native_getActiveMicrophones$nativeBinding(ArrayList<MicrophoneInfo> var1);

    private int native_getActiveMicrophones(ArrayList<MicrophoneInfo> arrayList) {
        return (int)InvokeDynamicSupport.bootstrap("native_getActiveMicrophones", $$robo$$android_media_MediaRecorder$native_getActiveMicrophones(java.util.ArrayList<android.media.MicrophoneInfo> ), 1, this, arrayList);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_MediaRecorder$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private final native /* synthetic */ void $$robo$$release$nativeBinding();

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaRecorder$release(), 1, this);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaRecorder$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding(Object var1, String var2, String var3) throws IllegalStateException;

    private void native_setup(Object object, String string2, String string3) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaRecorder$native_setup(java.lang.Object java.lang.String java.lang.String ), 1, this, object, string2, string3);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaRecorder$native_finalize(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setParameter$nativeBinding(String var1);

    private void setParameter(String string2) {
        InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_MediaRecorder$setParameter(java.lang.String ), 1, this, string2);
    }

    public PersistableBundle getMetrics() {
        return InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_media_MediaRecorder$getMetrics(), 0, this);
    }

    private final native /* synthetic */ PersistableBundle $$robo$$native_getMetrics$nativeBinding();

    private PersistableBundle native_getMetrics() {
        return InvokeDynamicSupport.bootstrap("native_getMetrics", $$robo$$android_media_MediaRecorder$native_getMetrics(), 1, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaRecorder$finalize(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MediaRecorder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRecorder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MetricsConstants
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String AUDIO_BITRATE = "android.media.mediarecorder.audio-bitrate";
        public static String AUDIO_CHANNELS = "android.media.mediarecorder.audio-channels";
        public static String AUDIO_SAMPLERATE = "android.media.mediarecorder.audio-samplerate";
        public static String AUDIO_TIMESCALE = "android.media.mediarecorder.audio-timescale";
        public static String CAPTURE_FPS = "android.media.mediarecorder.capture-fps";
        public static String CAPTURE_FPS_ENABLE = "android.media.mediarecorder.capture-fpsenable";
        public static String FRAMERATE = "android.media.mediarecorder.frame-rate";
        public static String HEIGHT = "android.media.mediarecorder.height";
        public static String MOVIE_TIMESCALE = "android.media.mediarecorder.movie-timescale";
        public static String ROTATION = "android.media.mediarecorder.rotation";
        public static String VIDEO_BITRATE = "android.media.mediarecorder.video-bitrate";
        public static String VIDEO_IFRAME_INTERVAL = "android.media.mediarecorder.video-iframe-interval";
        public static String VIDEO_LEVEL = "android.media.mediarecorder.video-encoder-level";
        public static String VIDEO_PROFILE = "android.media.mediarecorder.video-encoder-profile";
        public static String VIDEO_TIMESCALE = "android.media.mediarecorder.video-timescale";
        public static String WIDTH = "android.media.mediarecorder.width";

        private void $$robo$$android_media_MediaRecorder_MetricsConstants$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_MediaRecorder_MetricsConstants$__constructor__();
        }

        private MetricsConstants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_MetricsConstants$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsConstants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaRecorder mMediaRecorder;
        private static int MEDIA_RECORDER_EVENT_LIST_START = 1;
        private static int MEDIA_RECORDER_EVENT_ERROR = 1;
        private static int MEDIA_RECORDER_EVENT_INFO = 2;
        private static int MEDIA_RECORDER_EVENT_LIST_END = 99;
        private static int MEDIA_RECORDER_TRACK_EVENT_LIST_START = 100;
        private static int MEDIA_RECORDER_TRACK_EVENT_ERROR = 100;
        private static int MEDIA_RECORDER_TRACK_EVENT_INFO = 101;
        private static int MEDIA_RECORDER_TRACK_EVENT_LIST_END = 1000;
        private static int MEDIA_RECORDER_AUDIO_ROUTING_CHANGED = 10000;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_EventHandler$__constructor__(MediaRecorder mediaRecorder, MediaRecorder mr, Looper looper) {
            this.mMediaRecorder = mr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaRecorder_EventHandler$handleMessage(Message msg) {
            if (this.mMediaRecorder.mNativeContext == 0L) {
                Log.w("MediaRecorder", "mediarecorder went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: 
                case 100: {
                    if (this.this$0.mOnErrorListener != null) {
                        this.this$0.mOnErrorListener.onError(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 2: 
                case 101: {
                    if (this.this$0.mOnInfoListener != null) {
                        this.this$0.mOnInfoListener.onInfo(this.mMediaRecorder, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 10000: {
                    AudioManager.resetAudioPortGeneration();
                    ArrayMap arrayMap = this.this$0.mRoutingChangeListeners;
                    synchronized (arrayMap) {
                        for (NativeRoutingEventHandlerDelegate delegate : this.this$0.mRoutingChangeListeners.values()) {
                            delegate.notifyClient();
                        }
                    }
                    return;
                }
            }
            Log.e("MediaRecorder", "Unknown message type " + msg.what);
        }

        private void __constructor__(MediaRecorder mediaRecorder, MediaRecorder mediaRecorder2, Looper looper) {
            this.$$robo$$android_media_MediaRecorder_EventHandler$__constructor__(mediaRecorder, mediaRecorder2, looper);
        }

        public EventHandler(MediaRecorder mediaRecorder, MediaRecorder mediaRecorder2, Looper looper) {
            this.this$0 = mediaRecorder;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_EventHandler$__constructor__(android.media.MediaRecorder android.media.MediaRecorder android.os.Looper ), 0, this, mediaRecorder, mediaRecorder2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaRecorder_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnInfoListener
    extends InstrumentedInterface {
        public void onInfo(MediaRecorder var1, int var2, int var3);
    }

    public static interface OnErrorListener
    extends InstrumentedInterface {
        public void onError(MediaRecorder var1, int var2, int var3);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class VideoEncoder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT = 0;
        public static int H263 = 1;
        public static int H264 = 2;
        public static int MPEG_4_SP = 3;
        public static int VP8 = 4;
        public static int HEVC = 5;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_VideoEncoder$__constructor__(MediaRecorder this$0) {
        }

        private void __constructor__(MediaRecorder mediaRecorder) {
            this.$$robo$$android_media_MediaRecorder_VideoEncoder$__constructor__(mediaRecorder);
        }

        private VideoEncoder(MediaRecorder mediaRecorder) {
            this.this$0 = mediaRecorder;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_VideoEncoder$__constructor__(android.media.MediaRecorder ), 0, this, mediaRecorder);
        }

        public /* synthetic */ VideoEncoder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoEncoder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class AudioEncoder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT = 0;
        public static int AMR_NB = 1;
        public static int AMR_WB = 2;
        public static int AAC = 3;
        public static int HE_AAC = 4;
        public static int AAC_ELD = 5;
        public static int VORBIS = 6;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_AudioEncoder$__constructor__(MediaRecorder this$0) {
        }

        private void __constructor__(MediaRecorder mediaRecorder) {
            this.$$robo$$android_media_MediaRecorder_AudioEncoder$__constructor__(mediaRecorder);
        }

        private AudioEncoder(MediaRecorder mediaRecorder) {
            this.this$0 = mediaRecorder;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_AudioEncoder$__constructor__(android.media.MediaRecorder ), 0, this, mediaRecorder);
        }

        public /* synthetic */ AudioEncoder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioEncoder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class OutputFormat
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT = 0;
        public static int THREE_GPP = 1;
        public static int MPEG_4 = 2;
        public static int RAW_AMR = 3;
        public static int AMR_NB = 3;
        public static int AMR_WB = 4;
        public static int AAC_ADIF = 5;
        public static int AAC_ADTS = 6;
        public static int OUTPUT_FORMAT_RTP_AVP = 7;
        public static int MPEG_2_TS = 8;
        public static int WEBM = 9;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_OutputFormat$__constructor__(MediaRecorder this$0) {
        }

        private void __constructor__(MediaRecorder mediaRecorder) {
            this.$$robo$$android_media_MediaRecorder_OutputFormat$__constructor__(mediaRecorder);
        }

        private OutputFormat(MediaRecorder mediaRecorder) {
            this.this$0 = mediaRecorder;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_OutputFormat$__constructor__(android.media.MediaRecorder ), 0, this, mediaRecorder);
        }

        public /* synthetic */ OutputFormat() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OutputFormat)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class VideoSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT = 0;
        public static int CAMERA = 1;
        public static int SURFACE = 2;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_VideoSource$__constructor__(MediaRecorder this$0) {
        }

        private void __constructor__(MediaRecorder mediaRecorder) {
            this.$$robo$$android_media_MediaRecorder_VideoSource$__constructor__(mediaRecorder);
        }

        private VideoSource(MediaRecorder mediaRecorder) {
            this.this$0 = mediaRecorder;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_VideoSource$__constructor__(android.media.MediaRecorder ), 0, this, mediaRecorder);
        }

        public /* synthetic */ VideoSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class AudioSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int AUDIO_SOURCE_INVALID = -1;
        public static int DEFAULT = 0;
        public static int MIC = 1;
        public static int VOICE_UPLINK = 2;
        public static int VOICE_DOWNLINK = 3;
        public static int VOICE_CALL = 4;
        public static int CAMCORDER = 5;
        public static int VOICE_RECOGNITION = 6;
        public static int VOICE_COMMUNICATION = 7;
        public static int REMOTE_SUBMIX = 8;
        public static int UNPROCESSED = 9;
        @SystemApi
        public static int RADIO_TUNER = 1998;
        @SystemApi
        public static int HOTWORD = 1999;
        /* synthetic */ MediaRecorder this$0;

        private void $$robo$$android_media_MediaRecorder_AudioSource$__constructor__(MediaRecorder this$0) {
        }

        private void __constructor__(MediaRecorder mediaRecorder) {
            this.$$robo$$android_media_MediaRecorder_AudioSource$__constructor__(mediaRecorder);
        }

        private AudioSource(MediaRecorder mediaRecorder) {
            this.this$0 = mediaRecorder;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaRecorder_AudioSource$__constructor__(android.media.MediaRecorder ), 0, this, mediaRecorder);
        }

        public /* synthetic */ AudioSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

