/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Rating
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Rating";
    public static int RATING_NONE = 0;
    public static int RATING_HEART = 1;
    public static int RATING_THUMB_UP_DOWN = 2;
    public static int RATING_3_STARS = 3;
    public static int RATING_4_STARS = 4;
    public static int RATING_5_STARS = 5;
    public static int RATING_PERCENTAGE = 6;
    private static float RATING_NOT_RATED = -1.0f;
    private int mRatingStyle;
    private float mRatingValue;
    public static Parcelable.Creator<Rating> CREATOR;

    private void $$robo$$android_media_Rating$__constructor__(int ratingStyle, float rating) {
        this.mRatingStyle = ratingStyle;
        this.mRatingValue = rating;
    }

    private final String $$robo$$android_media_Rating$toString() {
        return "Rating:style=" + this.mRatingStyle + " rating=" + (this.mRatingValue < 0.0f ? "unrated" : String.valueOf(this.mRatingValue));
    }

    private final int $$robo$$android_media_Rating$describeContents() {
        return this.mRatingStyle;
    }

    private final void $$robo$$android_media_Rating$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRatingStyle);
        dest.writeFloat(this.mRatingValue);
    }

    private static final Rating $$robo$$android_media_Rating$newUnratedRating(int ratingStyle) {
        switch (ratingStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new Rating(ratingStyle, -1.0f);
            }
        }
        return null;
    }

    private static final Rating $$robo$$android_media_Rating$newHeartRating(boolean hasHeart) {
        return new Rating(1, hasHeart ? 1.0f : 0.0f);
    }

    private static final Rating $$robo$$android_media_Rating$newThumbRating(boolean thumbIsUp) {
        return new Rating(2, thumbIsUp ? 1.0f : 0.0f);
    }

    private static final Rating $$robo$$android_media_Rating$newStarRating(int starRatingStyle, float starRating) {
        float maxRating = -1.0f;
        switch (starRatingStyle) {
            case 3: {
                maxRating = 3.0f;
                break;
            }
            case 4: {
                maxRating = 4.0f;
                break;
            }
            case 5: {
                maxRating = 5.0f;
                break;
            }
            default: {
                Log.e("Rating", "Invalid rating style (" + starRatingStyle + ") for a star rating");
                return null;
            }
        }
        if (starRating < 0.0f || starRating > maxRating) {
            Log.e("Rating", "Trying to set out of range star-based rating");
            return null;
        }
        return new Rating(starRatingStyle, starRating);
    }

    private static final Rating $$robo$$android_media_Rating$newPercentageRating(float percent) {
        if (percent < 0.0f || percent > 100.0f) {
            Log.e("Rating", "Invalid percentage-based rating value");
            return null;
        }
        return new Rating(6, percent);
    }

    private final boolean $$robo$$android_media_Rating$isRated() {
        return this.mRatingValue >= 0.0f;
    }

    private final int $$robo$$android_media_Rating$getRatingStyle() {
        return this.mRatingStyle;
    }

    private final boolean $$robo$$android_media_Rating$hasHeart() {
        if (this.mRatingStyle != 1) {
            return false;
        }
        return this.mRatingValue == 1.0f;
    }

    private final boolean $$robo$$android_media_Rating$isThumbUp() {
        if (this.mRatingStyle != 2) {
            return false;
        }
        return this.mRatingValue == 1.0f;
    }

    private final float $$robo$$android_media_Rating$getStarRating() {
        switch (this.mRatingStyle) {
            case 3: 
            case 4: 
            case 5: {
                if (!this.isRated()) break;
                return this.mRatingValue;
            }
        }
        return -1.0f;
    }

    private final float $$robo$$android_media_Rating$getPercentRating() {
        if (this.mRatingStyle != 6 || !this.isRated()) {
            return -1.0f;
        }
        return this.mRatingValue;
    }

    private /* synthetic */ void $$robo$$android_media_Rating$__constructor__(int x0, float x1, 1 x2) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Rating>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_Rating_1$__constructor__() {
            }

            private final Rating $$robo$$android_media_Rating_1$createFromParcel(Parcel p) {
                return new Rating(p.readInt(), p.readFloat());
            }

            private final Rating[] $$robo$$android_media_Rating_1$newArray(int size) {
                return new Rating[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_Rating_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Rating_1$__constructor__(), 0, this);
            }

            @Override
            public Rating createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_Rating_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Rating[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_Rating_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, float f) {
        this.$$robo$$android_media_Rating$__constructor__(n, f);
    }

    private Rating(int n, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_Rating$__constructor__(int float ), 0, this, n, f);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_Rating$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_Rating$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_Rating$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static Rating newUnratedRating(int n) {
        return InvokeDynamicSupport.bootstrapStatic("newUnratedRating", $$robo$$android_media_Rating$newUnratedRating(int ), 0, (int)n);
    }

    public static Rating newHeartRating(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("newHeartRating", $$robo$$android_media_Rating$newHeartRating(boolean ), 0, (boolean)bl);
    }

    public static Rating newThumbRating(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("newThumbRating", $$robo$$android_media_Rating$newThumbRating(boolean ), 0, (boolean)bl);
    }

    public static Rating newStarRating(int n, float f) {
        return InvokeDynamicSupport.bootstrapStatic("newStarRating", $$robo$$android_media_Rating$newStarRating(int float ), 0, (int)n, (float)f);
    }

    public static Rating newPercentageRating(float f) {
        return InvokeDynamicSupport.bootstrapStatic("newPercentageRating", $$robo$$android_media_Rating$newPercentageRating(float ), 0, (float)f);
    }

    public boolean isRated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRated", $$robo$$android_media_Rating$isRated(), 0, this);
    }

    public int getRatingStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getRatingStyle", $$robo$$android_media_Rating$getRatingStyle(), 0, this);
    }

    public boolean hasHeart() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasHeart", $$robo$$android_media_Rating$hasHeart(), 0, this);
    }

    public boolean isThumbUp() {
        return (boolean)InvokeDynamicSupport.bootstrap("isThumbUp", $$robo$$android_media_Rating$isThumbUp(), 0, this);
    }

    public float getStarRating() {
        return (float)InvokeDynamicSupport.bootstrap("getStarRating", $$robo$$android_media_Rating$getStarRating(), 0, this);
    }

    public float getPercentRating() {
        return (float)InvokeDynamicSupport.bootstrap("getPercentRating", $$robo$$android_media_Rating$getPercentRating(), 0, this);
    }

    private /* synthetic */ void __constructor__(int n, float f, 1 var3_3) {
        this.$$robo$$android_media_Rating$__constructor__(n, f, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(Rating.class);
    }

    public /* synthetic */ Rating() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rating)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StarStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

