/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.Activity;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.media.AudioManager;
import android.media.ExternalRingtonesCursorWrapper;
import android.media.IAudioService;
import android.media.IRingtonePlayer;
import android.media.MediaScannerConnection;
import android.media.Ringtone;
import android.media.Utils;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.MediaStore;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.database.SortCursor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RingtoneManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RingtoneManager";
    public static int TYPE_RINGTONE = 1;
    public static int TYPE_NOTIFICATION = 2;
    public static int TYPE_ALARM = 4;
    public static int TYPE_ALL = 7;
    public static String ACTION_RINGTONE_PICKER = "android.intent.action.RINGTONE_PICKER";
    public static String EXTRA_RINGTONE_SHOW_DEFAULT = "android.intent.extra.ringtone.SHOW_DEFAULT";
    public static String EXTRA_RINGTONE_SHOW_SILENT = "android.intent.extra.ringtone.SHOW_SILENT";
    @Deprecated
    public static String EXTRA_RINGTONE_INCLUDE_DRM = "android.intent.extra.ringtone.INCLUDE_DRM";
    public static String EXTRA_RINGTONE_EXISTING_URI = "android.intent.extra.ringtone.EXISTING_URI";
    public static String EXTRA_RINGTONE_DEFAULT_URI = "android.intent.extra.ringtone.DEFAULT_URI";
    public static String EXTRA_RINGTONE_TYPE = "android.intent.extra.ringtone.TYPE";
    public static String EXTRA_RINGTONE_TITLE = "android.intent.extra.ringtone.TITLE";
    public static String EXTRA_RINGTONE_AUDIO_ATTRIBUTES_FLAGS = "android.intent.extra.ringtone.AUDIO_ATTRIBUTES_FLAGS";
    public static String EXTRA_RINGTONE_PICKED_URI = "android.intent.extra.ringtone.PICKED_URI";
    private static String[] INTERNAL_COLUMNS;
    private static String[] MEDIA_COLUMNS;
    public static int ID_COLUMN_INDEX = 0;
    public static int TITLE_COLUMN_INDEX = 1;
    public static int URI_COLUMN_INDEX = 2;
    private Activity mActivity;
    private Context mContext;
    private Cursor mCursor;
    private int mType;
    private List<String> mFilterColumns;
    private boolean mStopPreviousRingtone;
    private Ringtone mPreviousRingtone;
    private boolean mIncludeParentRingtones;

    private void $$robo$$android_media_RingtoneManager$__constructor__(Activity activity) {
    }

    private void $$robo$$android_media_RingtoneManager$__constructor__(Activity activity, boolean includeParentRingtones) {
        this.mType = 1;
        this.mFilterColumns = new ArrayList<String>();
        this.mStopPreviousRingtone = true;
        this.mActivity = activity;
        this.mContext = activity;
        this.setType(this.mType);
        this.mIncludeParentRingtones = includeParentRingtones;
    }

    private void $$robo$$android_media_RingtoneManager$__constructor__(Context context) {
    }

    private void $$robo$$android_media_RingtoneManager$__constructor__(Context context, boolean includeParentRingtones) {
        this.mType = 1;
        this.mFilterColumns = new ArrayList<String>();
        this.mStopPreviousRingtone = true;
        this.mActivity = null;
        this.mContext = context;
        this.setType(this.mType);
        this.mIncludeParentRingtones = includeParentRingtones;
    }

    private final void $$robo$$android_media_RingtoneManager$setType(int type) {
        if (this.mCursor != null) {
            throw new IllegalStateException("Setting filter columns should be done before querying for ringtones.");
        }
        this.mType = type;
        this.setFilterColumnsList(type);
    }

    private final int $$robo$$android_media_RingtoneManager$inferStreamType() {
        switch (this.mType) {
            case 4: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 2;
    }

    private final void $$robo$$android_media_RingtoneManager$setStopPreviousRingtone(boolean stopPreviousRingtone) {
        this.mStopPreviousRingtone = stopPreviousRingtone;
    }

    private final boolean $$robo$$android_media_RingtoneManager$getStopPreviousRingtone() {
        return this.mStopPreviousRingtone;
    }

    private final void $$robo$$android_media_RingtoneManager$stopPreviousRingtone() {
        if (this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_media_RingtoneManager$getIncludeDrm() {
        return false;
    }

    @Deprecated
    private final void $$robo$$android_media_RingtoneManager$setIncludeDrm(boolean includeDrm) {
        if (includeDrm) {
            Log.w("RingtoneManager", "setIncludeDrm no longer supported");
        }
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getCursor() {
        Cursor parentRingtonesCursor;
        if (this.mCursor != null && this.mCursor.requery()) {
            return this.mCursor;
        }
        ArrayList<Cursor> ringtoneCursors = new ArrayList<Cursor>();
        ringtoneCursors.add(this.getInternalRingtones());
        ringtoneCursors.add(this.getMediaRingtones());
        if (this.mIncludeParentRingtones && (parentRingtonesCursor = this.getParentProfileRingtones()) != null) {
            ringtoneCursors.add(parentRingtonesCursor);
        }
        this.mCursor = new SortCursor(ringtoneCursors.toArray(new Cursor[ringtoneCursors.size()]), "title_key");
        return this.mCursor;
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getParentProfileRingtones() {
        Context parentContext;
        UserManager um = UserManager.get(this.mContext);
        UserInfo parentInfo = um.getProfileParent(this.mContext.getUserId());
        if (parentInfo != null && parentInfo.id != this.mContext.getUserId() && (parentContext = RingtoneManager.createPackageContextAsUser(this.mContext, parentInfo.id)) != null) {
            return new ExternalRingtonesCursorWrapper(this.getMediaRingtones(parentContext), parentInfo.id);
        }
        return null;
    }

    private final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(int position) {
        if (this.mStopPreviousRingtone && this.mPreviousRingtone != null) {
            this.mPreviousRingtone.stop();
        }
        this.mPreviousRingtone = RingtoneManager.getRingtone(this.mContext, this.getRingtoneUri(position), this.inferStreamType());
        return this.mPreviousRingtone;
    }

    private final Uri $$robo$$android_media_RingtoneManager$getRingtoneUri(int position) {
        if (this.mCursor == null || !this.mCursor.moveToPosition(position)) {
            return null;
        }
        return RingtoneManager.getUriFromCursor(this.mCursor);
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getExistingRingtoneUriFromPath(Context context, String path) {
        String[] proj = new String[]{"_id"};
        String[] selectionArgs = new String[]{path};
        try (Cursor cursor = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, proj, "_data=? ", selectionArgs, null);){
            if (cursor == null || !cursor.moveToFirst()) {
                Uri uri = null;
                return uri;
            }
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            if (id2 == -1) {
                Uri uri = null;
                return uri;
            }
            Uri uri = Uri.withAppendedPath(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, "" + id2);
            return uri;
        }
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getUriFromCursor(Cursor cursor) {
        return ContentUris.withAppendedId(Uri.parse(cursor.getString(2)), cursor.getLong(0));
    }

    private final int $$robo$$android_media_RingtoneManager$getRingtonePosition(Uri ringtoneUri) {
        if (ringtoneUri == null) {
            return -1;
        }
        Cursor cursor = this.getCursor();
        int cursorCount = cursor.getCount();
        if (!cursor.moveToFirst()) {
            return -1;
        }
        Uri currentUri = null;
        String previousUriString = null;
        for (int i = 0; i < cursorCount; ++i) {
            String uriString = cursor.getString(2);
            if (currentUri == null || !uriString.equals(previousUriString)) {
                currentUri = Uri.parse(uriString);
            }
            if (ringtoneUri.equals(ContentUris.withAppendedId(currentUri, cursor.getLong(0)))) {
                return i;
            }
            cursor.move(1);
            previousUriString = uriString;
        }
        return -1;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getValidRingtoneUri(Context context) {
        RingtoneManager rm = new RingtoneManager(context);
        Uri uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getInternalRingtones());
        if (uri == null) {
            uri = RingtoneManager.getValidRingtoneUriFromCursorAndClose(context, rm.getMediaRingtones());
        }
        return uri;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        if (cursor != null) {
            Uri uri = null;
            if (cursor.moveToFirst()) {
                uri = RingtoneManager.getUriFromCursor(cursor);
            }
            cursor.close();
            return uri;
        }
        return null;
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getInternalRingtones() {
        return this.query(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, INTERNAL_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key");
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getMediaRingtones() {
        return this.getMediaRingtones(this.mContext);
    }

    private final Cursor $$robo$$android_media_RingtoneManager$getMediaRingtones(Context context) {
        if (0 != context.checkPermission("android.permission.READ_EXTERNAL_STORAGE", Process.myPid(), Process.myUid())) {
            Log.w("RingtoneManager", "No READ_EXTERNAL_STORAGE permission, ignoring ringtones on ext storage");
            return null;
        }
        String status = Environment.getExternalStorageState();
        return status.equals("mounted") || status.equals("mounted_ro") ? this.query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, MEDIA_COLUMNS, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, "title_key", context) : null;
    }

    private final void $$robo$$android_media_RingtoneManager$setFilterColumnsList(int type) {
        List<String> columns = this.mFilterColumns;
        columns.clear();
        if ((type & 1) != 0) {
            columns.add("is_ringtone");
        }
        if ((type & 2) != 0) {
            columns.add("is_notification");
        }
        if ((type & 4) != 0) {
            columns.add("is_alarm");
        }
    }

    private static final String $$robo$$android_media_RingtoneManager$constructBooleanTrueWhereClause(List<String> columns) {
        if (columns == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = columns.size() - 1; i >= 0; --i) {
            sb.append(columns.get(i)).append("=1 or ");
        }
        if (columns.size() > 0) {
            sb.setLength(sb.length() - 4);
        }
        sb.append(")");
        return sb.toString();
    }

    private final Cursor $$robo$$android_media_RingtoneManager$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder, this.mContext);
    }

    private final Cursor $$robo$$android_media_RingtoneManager$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, Context context) {
        if (this.mActivity != null) {
            return this.mActivity.managedQuery(uri, projection, selection, selectionArgs, sortOrder);
        }
        return context.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
    }

    private static final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(Context context, Uri ringtoneUri) {
        return RingtoneManager.getRingtone(context, ringtoneUri, -1);
    }

    private static final Ringtone $$robo$$android_media_RingtoneManager$getRingtone(Context context, Uri ringtoneUri, int streamType) {
        try {
            Ringtone r = new Ringtone(context, true);
            if (streamType >= 0) {
                r.setStreamType(streamType);
            }
            r.setUri(ringtoneUri);
            return r;
        }
        catch (Exception ex) {
            Log.e("RingtoneManager", "Failed to open ringtone " + ringtoneUri + ": " + ex);
            return null;
        }
    }

    private final File $$robo$$android_media_RingtoneManager$getRingtonePathFromUri(Uri uri) {
        String[] projection = new String[]{"_data"};
        this.setFilterColumnsList(7);
        String path = null;
        try (Cursor cursor = this.query(uri, projection, RingtoneManager.constructBooleanTrueWhereClause(this.mFilterColumns), null, null);){
            if (cursor != null && cursor.moveToFirst()) {
                path = cursor.getString(cursor.getColumnIndex("_data"));
            }
        }
        return path != null ? new File(path) : null;
    }

    private static final void $$robo$$android_media_RingtoneManager$disableSyncFromParent(Context userContext) {
        IBinder b = ServiceManager.getService("audio");
        IAudioService audioService = IAudioService.Stub.asInterface(b);
        try {
            audioService.disableRingtoneSync(userContext.getUserId());
        }
        catch (RemoteException e) {
            Log.e("RingtoneManager", "Unable to disable ringtone sync.");
        }
    }

    private static final void $$robo$$android_media_RingtoneManager$enableSyncFromParent(Context userContext) {
        Settings.Secure.putIntForUser(userContext.getContentResolver(), "sync_parent_sounds", 1, userContext.getUserId());
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getActualDefaultRingtoneUri(Context context, int type) {
        Uri ringtoneUri;
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return null;
        }
        String uriString = Settings.System.getStringForUser(context.getContentResolver(), setting, context.getUserId());
        Uri uri = ringtoneUri = uriString != null ? Uri.parse(uriString) : null;
        if (ringtoneUri != null && ContentProvider.getUserIdFromUri(ringtoneUri) == context.getUserId()) {
            ringtoneUri = ContentProvider.getUriWithoutUserId(ringtoneUri);
        }
        return ringtoneUri;
    }

    private static final void $$robo$$android_media_RingtoneManager$setActualDefaultRingtoneUri(Context context, int type, Uri ringtoneUri) {
        String setting = RingtoneManager.getSettingForType(type);
        if (setting == null) {
            return;
        }
        ContentResolver resolver = context.getContentResolver();
        if (Settings.Secure.getIntForUser(resolver, "sync_parent_sounds", 0, context.getUserId()) == 1) {
            RingtoneManager.disableSyncFromParent(context);
        }
        if (!RingtoneManager.isInternalRingtoneUri(ringtoneUri)) {
            ringtoneUri = ContentProvider.maybeAddUserId(ringtoneUri, context.getUserId());
        }
        Settings.System.putStringForUser(resolver, setting, ringtoneUri != null ? ringtoneUri.toString() : null, context.getUserId());
        if (ringtoneUri != null) {
            Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
            try (InputStream in = RingtoneManager.openRingtone(context, ringtoneUri);
                 OutputStream out = resolver.openOutputStream(cacheUri);){
                FileUtils.copy(in, out);
            }
            catch (IOException e) {
                Log.w("RingtoneManager", "Failed to cache ringtone: " + e);
            }
        }
    }

    private static final boolean $$robo$$android_media_RingtoneManager$isInternalRingtoneUri(Uri uri) {
        return RingtoneManager.isRingtoneUriInStorage(uri, MediaStore.Audio.Media.INTERNAL_CONTENT_URI);
    }

    private static final boolean $$robo$$android_media_RingtoneManager$isExternalRingtoneUri(Uri uri) {
        return RingtoneManager.isRingtoneUriInStorage(uri, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
    }

    private static final boolean $$robo$$android_media_RingtoneManager$isRingtoneUriInStorage(Uri ringtone, Uri storage) {
        Uri uriWithoutUserId = ContentProvider.getUriWithoutUserId(ringtone);
        return uriWithoutUserId == null ? false : uriWithoutUserId.toString().startsWith(storage.toString());
    }

    private final boolean $$robo$$android_media_RingtoneManager$isCustomRingtone(Uri uri) {
        String[] directories;
        File parent;
        if (!RingtoneManager.isExternalRingtoneUri(uri)) {
            return false;
        }
        File ringtoneFile = uri == null ? null : this.getRingtonePathFromUri(uri);
        File file = parent = ringtoneFile == null ? null : ringtoneFile.getParentFile();
        if (parent == null) {
            return false;
        }
        for (String directory : directories = new String[]{Environment.DIRECTORY_RINGTONES, Environment.DIRECTORY_NOTIFICATIONS, Environment.DIRECTORY_ALARMS}) {
            if (!parent.equals(Environment.getExternalStoragePublicDirectory(directory))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Uri $$robo$$android_media_RingtoneManager$addCustomExternalRingtone(Uri fileUri, int type) throws FileNotFoundException, IllegalArgumentException, IOException {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            throw new IOException("External storage is not mounted. Unable to install ringtones.");
        }
        String mimeType = this.mContext.getContentResolver().getType(fileUri);
        if (mimeType == null) throw new IllegalArgumentException("Ringtone file must have MIME type \"audio/*\". Given file has MIME type \"" + mimeType + "\"");
        if (!mimeType.startsWith("audio/") && !mimeType.equals("application/ogg")) {
            throw new IllegalArgumentException("Ringtone file must have MIME type \"audio/*\". Given file has MIME type \"" + mimeType + "\"");
        }
        String subdirectory = RingtoneManager.getExternalDirectoryForType(type);
        File outFile = Utils.getUniqueExternalFile(this.mContext, subdirectory, Utils.getFileDisplayNameFromUri(this.mContext, fileUri), mimeType);
        try (InputStream input = this.mContext.getContentResolver().openInputStream(fileUri);
             FileOutputStream output = new FileOutputStream(outFile);){
            FileUtils.copy(input, output);
        }
        try {
            var7_8 = null;
            try (NewRingtoneScanner scanner = new NewRingtoneScanner(this, outFile);){
                Uri uri = scanner.take();
                return uri;
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Audio file failed to scan as a ringtone", e);
        }
    }

    private static final String $$robo$$android_media_RingtoneManager$getExternalDirectoryForType(int type) {
        switch (type) {
            case 1: {
                return Environment.DIRECTORY_RINGTONES;
            }
            case 2: {
                return Environment.DIRECTORY_NOTIFICATIONS;
            }
            case 4: {
                return Environment.DIRECTORY_ALARMS;
            }
        }
        throw new IllegalArgumentException("Unsupported ringtone type: " + type);
    }

    private final boolean $$robo$$android_media_RingtoneManager$deleteExternalRingtone(Uri uri) {
        if (!this.isCustomRingtone(uri)) {
            return false;
        }
        File ringtoneFile = this.getRingtonePathFromUri(uri);
        try {
            if (ringtoneFile != null && this.mContext.getContentResolver().delete(uri, null, null) > 0) {
                return ringtoneFile.delete();
            }
        }
        catch (SecurityException e) {
            Log.d("RingtoneManager", "Unable to delete custom ringtone", e);
        }
        return false;
    }

    private static final InputStream $$robo$$android_media_RingtoneManager$openRingtone(Context context, Uri uri) throws IOException {
        ContentResolver resolver = context.getContentResolver();
        try {
            return resolver.openInputStream(uri);
        }
        catch (IOException | SecurityException e) {
            Log.w("RingtoneManager", "Failed to open directly; attempting failover: " + e);
            IRingtonePlayer player = context.getSystemService(AudioManager.class).getRingtonePlayer();
            try {
                return new ParcelFileDescriptor.AutoCloseInputStream(player.openRingtone(uri));
            }
            catch (Exception e2) {
                throw new IOException(e2);
            }
        }
    }

    private static final String $$robo$$android_media_RingtoneManager$getSettingForType(int type) {
        if ((type & 1) != 0) {
            return "ringtone";
        }
        if ((type & 2) != 0) {
            return "notification_sound";
        }
        if ((type & 4) != 0) {
            return "alarm_alert";
        }
        return null;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getCacheForType(int type) {
        return RingtoneManager.getCacheForType(type, UserHandle.getCallingUserId());
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getCacheForType(int type, int userId) {
        if ((type & 1) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.RINGTONE_CACHE_URI, userId);
        }
        if ((type & 2) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.NOTIFICATION_SOUND_CACHE_URI, userId);
        }
        if ((type & 4) != 0) {
            return ContentProvider.maybeAddUserId(Settings.System.ALARM_ALERT_CACHE_URI, userId);
        }
        return null;
    }

    private static final boolean $$robo$$android_media_RingtoneManager$isDefault(Uri ringtoneUri) {
        return RingtoneManager.getDefaultType(ringtoneUri) != -1;
    }

    private static final int $$robo$$android_media_RingtoneManager$getDefaultType(Uri defaultRingtoneUri) {
        if ((defaultRingtoneUri = ContentProvider.getUriWithoutUserId(defaultRingtoneUri)) == null) {
            return -1;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_RINGTONE_URI)) {
            return 1;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_NOTIFICATION_URI)) {
            return 2;
        }
        if (defaultRingtoneUri.equals(Settings.System.DEFAULT_ALARM_ALERT_URI)) {
            return 4;
        }
        return -1;
    }

    private static final Uri $$robo$$android_media_RingtoneManager$getDefaultUri(int type) {
        if ((type & 1) != 0) {
            return Settings.System.DEFAULT_RINGTONE_URI;
        }
        if ((type & 2) != 0) {
            return Settings.System.DEFAULT_NOTIFICATION_URI;
        }
        if ((type & 4) != 0) {
            return Settings.System.DEFAULT_ALARM_ALERT_URI;
        }
        return null;
    }

    private static final Context $$robo$$android_media_RingtoneManager$createPackageContextAsUser(Context context, int userId) {
        try {
            return context.createPackageContextAsUser(context.getPackageName(), 0, UserHandle.of(userId));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("RingtoneManager", "Unable to create package context", e);
            return null;
        }
    }

    static void __staticInitializer__() {
        INTERNAL_COLUMNS = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.INTERNAL_CONTENT_URI + "\"", "title_key"};
        MEDIA_COLUMNS = new String[]{"_id", "title", "\"" + MediaStore.Audio.Media.EXTERNAL_CONTENT_URI + "\"", "title_key"};
    }

    private void __constructor__(Activity activity) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(activity);
    }

    public RingtoneManager(Activity activity) {
        this(activity, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.app.Activity ), 0, this, activity);
    }

    private void __constructor__(Activity activity, boolean bl) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(activity, bl);
    }

    public RingtoneManager(Activity activity, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.app.Activity boolean ), 0, this, activity, bl);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(context);
    }

    public RingtoneManager(Context context) {
        this(context, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_media_RingtoneManager$__constructor__(context, bl);
    }

    public RingtoneManager(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$android_media_RingtoneManager$setType(int ), 0, this, n);
    }

    public int inferStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("inferStreamType", $$robo$$android_media_RingtoneManager$inferStreamType(), 0, this);
    }

    public void setStopPreviousRingtone(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStopPreviousRingtone", $$robo$$android_media_RingtoneManager$setStopPreviousRingtone(boolean ), 0, this, bl);
    }

    public boolean getStopPreviousRingtone() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStopPreviousRingtone", $$robo$$android_media_RingtoneManager$getStopPreviousRingtone(), 0, this);
    }

    public void stopPreviousRingtone() {
        InvokeDynamicSupport.bootstrap("stopPreviousRingtone", $$robo$$android_media_RingtoneManager$stopPreviousRingtone(), 0, this);
    }

    @Deprecated
    public boolean getIncludeDrm() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIncludeDrm", $$robo$$android_media_RingtoneManager$getIncludeDrm(), 0, this);
    }

    @Deprecated
    public void setIncludeDrm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIncludeDrm", $$robo$$android_media_RingtoneManager$setIncludeDrm(boolean ), 0, this, bl);
    }

    public Cursor getCursor() {
        return InvokeDynamicSupport.bootstrap("getCursor", $$robo$$android_media_RingtoneManager$getCursor(), 0, this);
    }

    private Cursor getParentProfileRingtones() {
        return InvokeDynamicSupport.bootstrap("getParentProfileRingtones", $$robo$$android_media_RingtoneManager$getParentProfileRingtones(), 0, this);
    }

    public Ringtone getRingtone(int n) {
        return InvokeDynamicSupport.bootstrap("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(int ), 0, this, n);
    }

    public Uri getRingtoneUri(int n) {
        return InvokeDynamicSupport.bootstrap("getRingtoneUri", $$robo$$android_media_RingtoneManager$getRingtoneUri(int ), 0, this, n);
    }

    private static Uri getExistingRingtoneUriFromPath(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getExistingRingtoneUriFromPath", $$robo$$android_media_RingtoneManager$getExistingRingtoneUriFromPath(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private static Uri getUriFromCursor(Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("getUriFromCursor", $$robo$$android_media_RingtoneManager$getUriFromCursor(android.database.Cursor ), 0, (Cursor)cursor);
    }

    public int getRingtonePosition(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("getRingtonePosition", $$robo$$android_media_RingtoneManager$getRingtonePosition(android.net.Uri ), 0, this, uri);
    }

    public static Uri getValidRingtoneUri(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getValidRingtoneUri", $$robo$$android_media_RingtoneManager$getValidRingtoneUri(android.content.Context ), 0, (Context)context);
    }

    private static Uri getValidRingtoneUriFromCursorAndClose(Context context, Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("getValidRingtoneUriFromCursorAndClose", $$robo$$android_media_RingtoneManager$getValidRingtoneUriFromCursorAndClose(android.content.Context android.database.Cursor ), 0, (Context)context, (Cursor)cursor);
    }

    private Cursor getInternalRingtones() {
        return InvokeDynamicSupport.bootstrap("getInternalRingtones", $$robo$$android_media_RingtoneManager$getInternalRingtones(), 0, this);
    }

    private Cursor getMediaRingtones() {
        return InvokeDynamicSupport.bootstrap("getMediaRingtones", $$robo$$android_media_RingtoneManager$getMediaRingtones(), 0, this);
    }

    private Cursor getMediaRingtones(Context context) {
        return InvokeDynamicSupport.bootstrap("getMediaRingtones", $$robo$$android_media_RingtoneManager$getMediaRingtones(android.content.Context ), 0, this, context);
    }

    private void setFilterColumnsList(int n) {
        InvokeDynamicSupport.bootstrap("setFilterColumnsList", $$robo$$android_media_RingtoneManager$setFilterColumnsList(int ), 0, this, n);
    }

    private static String constructBooleanTrueWhereClause(List<String> list) {
        return InvokeDynamicSupport.bootstrapStatic("constructBooleanTrueWhereClause", $$robo$$android_media_RingtoneManager$constructBooleanTrueWhereClause(java.util.List<java.lang.String> ), 0, list);
    }

    private Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_media_RingtoneManager$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    private Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, Context context) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_media_RingtoneManager$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.content.Context ), 0, this, uri, stringArray, string2, stringArray2, string3, context);
    }

    public static Ringtone getRingtone(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    private static Ringtone getRingtone(Context context, Uri uri, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRingtone", $$robo$$android_media_RingtoneManager$getRingtone(android.content.Context android.net.Uri int ), 0, (Context)context, (Uri)uri, (int)n);
    }

    private File getRingtonePathFromUri(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getRingtonePathFromUri", $$robo$$android_media_RingtoneManager$getRingtonePathFromUri(android.net.Uri ), 0, this, uri);
    }

    public static void disableSyncFromParent(Context context) {
        InvokeDynamicSupport.bootstrapStatic("disableSyncFromParent", $$robo$$android_media_RingtoneManager$disableSyncFromParent(android.content.Context ), 0, (Context)context);
    }

    public static void enableSyncFromParent(Context context) {
        InvokeDynamicSupport.bootstrapStatic("enableSyncFromParent", $$robo$$android_media_RingtoneManager$enableSyncFromParent(android.content.Context ), 0, (Context)context);
    }

    public static Uri getActualDefaultRingtoneUri(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getActualDefaultRingtoneUri", $$robo$$android_media_RingtoneManager$getActualDefaultRingtoneUri(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static void setActualDefaultRingtoneUri(Context context, int n, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("setActualDefaultRingtoneUri", $$robo$$android_media_RingtoneManager$setActualDefaultRingtoneUri(android.content.Context int android.net.Uri ), 0, (Context)context, (int)n, (Uri)uri);
    }

    private static boolean isInternalRingtoneUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInternalRingtoneUri", $$robo$$android_media_RingtoneManager$isInternalRingtoneUri(android.net.Uri ), 0, (Uri)uri);
    }

    private static boolean isExternalRingtoneUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalRingtoneUri", $$robo$$android_media_RingtoneManager$isExternalRingtoneUri(android.net.Uri ), 0, (Uri)uri);
    }

    private static boolean isRingtoneUriInStorage(Uri uri, Uri uri2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRingtoneUriInStorage", $$robo$$android_media_RingtoneManager$isRingtoneUriInStorage(android.net.Uri android.net.Uri ), 0, (Uri)uri, (Uri)uri2);
    }

    public boolean isCustomRingtone(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCustomRingtone", $$robo$$android_media_RingtoneManager$isCustomRingtone(android.net.Uri ), 0, this, uri);
    }

    public Uri addCustomExternalRingtone(Uri uri, int n) throws FileNotFoundException, IllegalArgumentException, IOException {
        return InvokeDynamicSupport.bootstrap("addCustomExternalRingtone", $$robo$$android_media_RingtoneManager$addCustomExternalRingtone(android.net.Uri int ), 0, this, uri, n);
    }

    private static String getExternalDirectoryForType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getExternalDirectoryForType", $$robo$$android_media_RingtoneManager$getExternalDirectoryForType(int ), 0, (int)n);
    }

    public boolean deleteExternalRingtone(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteExternalRingtone", $$robo$$android_media_RingtoneManager$deleteExternalRingtone(android.net.Uri ), 0, this, uri);
    }

    private static InputStream openRingtone(Context context, Uri uri) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("openRingtone", $$robo$$android_media_RingtoneManager$openRingtone(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    private static String getSettingForType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSettingForType", $$robo$$android_media_RingtoneManager$getSettingForType(int ), 0, (int)n);
    }

    public static Uri getCacheForType(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCacheForType", $$robo$$android_media_RingtoneManager$getCacheForType(int ), 0, (int)n);
    }

    public static Uri getCacheForType(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getCacheForType", $$robo$$android_media_RingtoneManager$getCacheForType(int int ), 0, (int)n, (int)n2);
    }

    public static boolean isDefault(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefault", $$robo$$android_media_RingtoneManager$isDefault(android.net.Uri ), 0, (Uri)uri);
    }

    public static int getDefaultType(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultType", $$robo$$android_media_RingtoneManager$getDefaultType(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri getDefaultUri(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultUri", $$robo$$android_media_RingtoneManager$getDefaultUri(int ), 0, (int)n);
    }

    private static Context createPackageContextAsUser(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createPackageContextAsUser", $$robo$$android_media_RingtoneManager$createPackageContextAsUser(android.content.Context int ), 0, (Context)context, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(RingtoneManager.class);
    }

    public /* synthetic */ RingtoneManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RingtoneManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NewRingtoneScanner
    implements Closeable,
    MediaScannerConnection.MediaScannerConnectionClient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaScannerConnection mMediaScannerConnection;
        private File mFile;
        private LinkedBlockingQueue<Uri> mQueue;
        /* synthetic */ RingtoneManager this$0;

        private void $$robo$$android_media_RingtoneManager_NewRingtoneScanner$__constructor__(RingtoneManager ringtoneManager, File file) {
            this.mQueue = new LinkedBlockingQueue(1);
            this.mFile = file;
            this.mMediaScannerConnection = new MediaScannerConnection(ringtoneManager.mContext, this);
            this.mMediaScannerConnection.connect();
        }

        private final void $$robo$$android_media_RingtoneManager_NewRingtoneScanner$close() {
            this.mMediaScannerConnection.disconnect();
        }

        private final void $$robo$$android_media_RingtoneManager_NewRingtoneScanner$onMediaScannerConnected() {
            this.mMediaScannerConnection.scanFile(this.mFile.getAbsolutePath(), null);
        }

        private final void $$robo$$android_media_RingtoneManager_NewRingtoneScanner$onScanCompleted(String path, Uri uri) {
            if (uri == null) {
                this.mFile.delete();
                return;
            }
            try {
                this.mQueue.put(uri);
            }
            catch (InterruptedException e) {
                Log.e("RingtoneManager", "Unable to put new ringtone Uri in queue", e);
            }
        }

        private final Uri $$robo$$android_media_RingtoneManager_NewRingtoneScanner$take() throws InterruptedException {
            return this.mQueue.take();
        }

        private void __constructor__(RingtoneManager ringtoneManager, File file) {
            this.$$robo$$android_media_RingtoneManager_NewRingtoneScanner$__constructor__(ringtoneManager, file);
        }

        public NewRingtoneScanner(RingtoneManager ringtoneManager, File file) {
            this.this$0 = ringtoneManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_RingtoneManager_NewRingtoneScanner$__constructor__(android.media.RingtoneManager java.io.File ), 0, this, ringtoneManager, file);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_RingtoneManager_NewRingtoneScanner$close(), 0, this);
        }

        @Override
        public void onMediaScannerConnected() {
            InvokeDynamicSupport.bootstrap("onMediaScannerConnected", $$robo$$android_media_RingtoneManager_NewRingtoneScanner$onMediaScannerConnected(), 0, this);
        }

        @Override
        public void onScanCompleted(String string2, Uri uri) {
            InvokeDynamicSupport.bootstrap("onScanCompleted", $$robo$$android_media_RingtoneManager_NewRingtoneScanner$onScanCompleted(java.lang.String android.net.Uri ), 0, this, string2, uri);
        }

        public Uri take() throws InterruptedException {
            return InvokeDynamicSupport.bootstrap("take", $$robo$$android_media_RingtoneManager_NewRingtoneScanner$take(), 0, this);
        }

        public /* synthetic */ NewRingtoneScanner() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NewRingtoneScanner)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

