/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.PlayerBase;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class VolumeShaper
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mId;
    private WeakReference<PlayerBase> mWeakPlayerBase;

    private void $$robo$$android_media_VolumeShaper$__constructor__(Configuration configuration, PlayerBase playerBase) {
        this.mWeakPlayerBase = new WeakReference<PlayerBase>(playerBase);
        this.mId = this.applyPlayer(configuration, new Operation.Builder().defer().build());
    }

    private final int $$robo$$android_media_VolumeShaper$getId() {
        return this.mId;
    }

    private final void $$robo$$android_media_VolumeShaper$apply(Operation operation) {
        this.applyPlayer(new Configuration(this.mId), operation);
    }

    private final void $$robo$$android_media_VolumeShaper$replace(Configuration configuration, Operation operation, boolean join) {
        this.mId = this.applyPlayer(configuration, new Operation.Builder(operation).replace(this.mId, join).build());
    }

    private final float $$robo$$android_media_VolumeShaper$getVolume() {
        return this.getStatePlayer(this.mId).getVolume();
    }

    private final void $$robo$$android_media_VolumeShaper$close() {
        try {
            this.applyPlayer(new Configuration(this.mId), new Operation.Builder().terminate().build());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mWeakPlayerBase != null) {
            this.mWeakPlayerBase.clear();
        }
    }

    private final void $$robo$$android_media_VolumeShaper$finalize() {
        this.close();
    }

    private final int $$robo$$android_media_VolumeShaper$applyPlayer(Configuration configuration, Operation operation) {
        PlayerBase player;
        if (this.mWeakPlayerBase != null) {
            player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        int id2 = player.playerApplyVolumeShaper(configuration, operation);
        if (id2 < 0) {
            int VOLUME_SHAPER_INVALID_OPERATION = -38;
            if (id2 == -38) {
                throw new IllegalStateException("player or VolumeShaper deallocated");
            }
            throw new IllegalArgumentException("invalid configuration or operation: " + id2);
        }
        return id2;
    }

    private final State $$robo$$android_media_VolumeShaper$getStatePlayer(int id2) {
        PlayerBase player;
        if (this.mWeakPlayerBase != null) {
            player = (PlayerBase)this.mWeakPlayerBase.get();
            if (player == null) {
                throw new IllegalStateException("player deallocated");
            }
        } else {
            throw new IllegalStateException("uninitialized shaper");
        }
        State state = player.playerGetVolumeShaperState(id2);
        if (state == null) {
            throw new IllegalStateException("shaper cannot be found");
        }
        return state;
    }

    private void __constructor__(Configuration configuration, PlayerBase playerBase) {
        this.$$robo$$android_media_VolumeShaper$__constructor__(configuration, playerBase);
    }

    VolumeShaper(Configuration configuration, PlayerBase playerBase) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper$__constructor__(android.media.VolumeShaper$Configuration android.media.PlayerBase ), 0, this, configuration, playerBase);
    }

    int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_VolumeShaper$getId(), 0, this);
    }

    public void apply(Operation operation) {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_media_VolumeShaper$apply(android.media.VolumeShaper$Operation ), 0, this, operation);
    }

    public void replace(Configuration configuration, Operation operation, boolean bl) {
        InvokeDynamicSupport.bootstrap("replace", $$robo$$android_media_VolumeShaper$replace(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation boolean ), 0, this, configuration, operation, bl);
    }

    public float getVolume() {
        return (float)InvokeDynamicSupport.bootstrap("getVolume", $$robo$$android_media_VolumeShaper$getVolume(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_VolumeShaper$close(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_VolumeShaper$finalize(), 0, this);
    }

    private int applyPlayer(Configuration configuration, Operation operation) {
        return (int)InvokeDynamicSupport.bootstrap("applyPlayer", $$robo$$android_media_VolumeShaper$applyPlayer(android.media.VolumeShaper$Configuration android.media.VolumeShaper$Operation ), 0, this, configuration, operation);
    }

    private State getStatePlayer(int n) {
        return InvokeDynamicSupport.bootstrap("getStatePlayer", $$robo$$android_media_VolumeShaper$getStatePlayer(int ), 0, this, n);
    }

    public /* synthetic */ VolumeShaper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VolumeShaper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float mVolume;
        private float mXOffset;
        public static Parcelable.Creator<State> CREATOR;

        private final String $$robo$$android_media_VolumeShaper_State$toString() {
            return "VolumeShaper.State{mVolume = " + this.mVolume + ", mXOffset = " + this.mXOffset + "}";
        }

        private final int $$robo$$android_media_VolumeShaper_State$hashCode() {
            return Objects.hash(Float.valueOf(this.mVolume), Float.valueOf(this.mXOffset));
        }

        private final boolean $$robo$$android_media_VolumeShaper_State$equals(Object o) {
            if (!(o instanceof State)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            State other = (State)o;
            return this.mVolume == other.mVolume && this.mXOffset == other.mXOffset;
        }

        private final int $$robo$$android_media_VolumeShaper_State$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_VolumeShaper_State$writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mVolume);
            dest.writeFloat(this.mXOffset);
        }

        private void $$robo$$android_media_VolumeShaper_State$__constructor__(float volume, float xOffset) {
            this.mVolume = volume;
            this.mXOffset = xOffset;
        }

        private final float $$robo$$android_media_VolumeShaper_State$getVolume() {
            return this.mVolume;
        }

        private final float $$robo$$android_media_VolumeShaper_State$getXOffset() {
            return this.mXOffset;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<State>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_VolumeShaper_State_1$__constructor__() {
                }

                private final State $$robo$$android_media_VolumeShaper_State_1$createFromParcel(Parcel p) {
                    return new State(p.readFloat(), p.readFloat());
                }

                private final State[] $$robo$$android_media_VolumeShaper_State_1$newArray(int size) {
                    return new State[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_VolumeShaper_State_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_State_1$__constructor__(), 0, this);
                }

                @Override
                public State createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_VolumeShaper_State_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public State[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_VolumeShaper_State_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_VolumeShaper_State$toString(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_VolumeShaper_State$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_VolumeShaper_State$equals(java.lang.Object ), 0, this, object);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_VolumeShaper_State$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_VolumeShaper_State$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(float f, float f2) {
            this.$$robo$$android_media_VolumeShaper_State$__constructor__(f, f2);
        }

        State(float f, float f2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_State$__constructor__(float float ), 0, this, f, f2);
        }

        public float getVolume() {
            return (float)InvokeDynamicSupport.bootstrap("getVolume", $$robo$$android_media_VolumeShaper_State$getVolume(), 0, this);
        }

        public float getXOffset() {
            return (float)InvokeDynamicSupport.bootstrap("getXOffset", $$robo$$android_media_VolumeShaper_State$getXOffset(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Operation
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Operation PLAY;
        public static Operation REVERSE;
        private static int FLAG_NONE = 0;
        private static int FLAG_REVERSE = 1;
        private static int FLAG_TERMINATE = 2;
        private static int FLAG_JOIN = 4;
        private static int FLAG_DEFER = 8;
        private static int FLAG_CREATE_IF_NEEDED = 16;
        private static int FLAG_PUBLIC_ALL = 3;
        private int mFlags;
        private int mReplaceId;
        private float mXOffset;
        public static Parcelable.Creator<Operation> CREATOR;

        private final String $$robo$$android_media_VolumeShaper_Operation$toString() {
            return "VolumeShaper.Operation{mFlags = 0x" + Integer.toHexString(this.mFlags).toUpperCase() + ", mReplaceId = " + this.mReplaceId + ", mXOffset = " + this.mXOffset + "}";
        }

        private final int $$robo$$android_media_VolumeShaper_Operation$hashCode() {
            return Objects.hash(this.mFlags, this.mReplaceId, Float.valueOf(this.mXOffset));
        }

        private final boolean $$robo$$android_media_VolumeShaper_Operation$equals(Object o) {
            if (!(o instanceof Operation)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Operation other = (Operation)o;
            return this.mFlags == other.mFlags && this.mReplaceId == other.mReplaceId && Float.compare(this.mXOffset, other.mXOffset) == 0;
        }

        private final int $$robo$$android_media_VolumeShaper_Operation$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_VolumeShaper_Operation$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mFlags);
            dest.writeInt(this.mReplaceId);
            dest.writeFloat(this.mXOffset);
        }

        private void $$robo$$android_media_VolumeShaper_Operation$__constructor__(int flags, int replaceId, float xOffset) {
            this.mFlags = flags;
            this.mReplaceId = replaceId;
            this.mXOffset = xOffset;
        }

        private /* synthetic */ void $$robo$$android_media_VolumeShaper_Operation$__constructor__(int x0, int x1, float x2, 1 x3) {
        }

        static void __staticInitializer__() {
            PLAY = new Builder().build();
            REVERSE = new Builder().reverse().build();
            CREATOR = new Parcelable.Creator<Operation>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_VolumeShaper_Operation_1$__constructor__() {
                }

                private final Operation $$robo$$android_media_VolumeShaper_Operation_1$createFromParcel(Parcel p) {
                    int flags = p.readInt();
                    int replaceId = p.readInt();
                    float xOffset = p.readFloat();
                    return new Operation(flags, replaceId, xOffset);
                }

                private final Operation[] $$robo$$android_media_VolumeShaper_Operation_1$newArray(int size) {
                    return new Operation[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_VolumeShaper_Operation_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Operation_1$__constructor__(), 0, this);
                }

                @Override
                public Operation createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_VolumeShaper_Operation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Operation[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_VolumeShaper_Operation_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_VolumeShaper_Operation$toString(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_VolumeShaper_Operation$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_VolumeShaper_Operation$equals(java.lang.Object ), 0, this, object);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_VolumeShaper_Operation$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_VolumeShaper_Operation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(int n, int n2, float f) {
            this.$$robo$$android_media_VolumeShaper_Operation$__constructor__(n, n2, f);
        }

        private Operation(int n, int n2, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Operation$__constructor__(int int float ), 0, this, n, n2, f);
        }

        private /* synthetic */ void __constructor__(int n, int n2, float f, 1 var4_4) {
            this.$$robo$$android_media_VolumeShaper_Operation$__constructor__(n, n2, f, var4_4);
        }

        static {
            RobolectricInternals.classInitializing(Operation.class);
        }

        public /* synthetic */ Operation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Operation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int mFlags;
            int mReplaceId;
            float mXOffset;

            private void $$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__() {
                this.mFlags = 0;
                this.mReplaceId = -1;
                this.mXOffset = Float.NaN;
            }

            private void $$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__(Operation operation) {
                this.mReplaceId = operation.mReplaceId;
                this.mFlags = operation.mFlags;
                this.mXOffset = operation.mXOffset;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$replace(int id2, boolean join) {
                this.mReplaceId = id2;
                this.mFlags = join ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$defer() {
                this.mFlags |= 8;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$terminate() {
                this.mFlags |= 2;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$reverse() {
                this.mFlags ^= 1;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$createIfNeeded() {
                this.mFlags |= 0x10;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$setXOffset(float xOffset) {
                if (xOffset < -0.0f) {
                    throw new IllegalArgumentException("Negative xOffset not allowed");
                }
                if (xOffset > 1.0f) {
                    throw new IllegalArgumentException("xOffset > 1.f not allowed");
                }
                this.mXOffset = xOffset;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Operation_Builder$setFlags(int flags) {
                if ((flags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("flag has unknown bits set: " + flags);
                }
                this.mFlags = this.mFlags & 0xFFFFFFFC | flags;
                return this;
            }

            private final Operation $$robo$$android_media_VolumeShaper_Operation_Builder$build() {
                return new Operation(this.mFlags, this.mReplaceId, this.mXOffset);
            }

            private void __constructor__() {
                this.$$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__(), 0, this);
            }

            private void __constructor__(Operation operation) {
                this.$$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__(operation);
            }

            public Builder(Operation operation) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Operation_Builder$__constructor__(android.media.VolumeShaper$Operation ), 0, this, operation);
            }

            public Builder replace(int n, boolean bl) {
                return InvokeDynamicSupport.bootstrap("replace", $$robo$$android_media_VolumeShaper_Operation_Builder$replace(int boolean ), 0, this, n, bl);
            }

            public Builder defer() {
                return InvokeDynamicSupport.bootstrap("defer", $$robo$$android_media_VolumeShaper_Operation_Builder$defer(), 0, this);
            }

            public Builder terminate() {
                return InvokeDynamicSupport.bootstrap("terminate", $$robo$$android_media_VolumeShaper_Operation_Builder$terminate(), 0, this);
            }

            public Builder reverse() {
                return InvokeDynamicSupport.bootstrap("reverse", $$robo$$android_media_VolumeShaper_Operation_Builder$reverse(), 0, this);
            }

            public Builder createIfNeeded() {
                return InvokeDynamicSupport.bootstrap("createIfNeeded", $$robo$$android_media_VolumeShaper_Operation_Builder$createIfNeeded(), 0, this);
            }

            public Builder setXOffset(float f) {
                return InvokeDynamicSupport.bootstrap("setXOffset", $$robo$$android_media_VolumeShaper_Operation_Builder$setXOffset(float ), 0, this, f);
            }

            private Builder setFlags(int n) {
                return InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_media_VolumeShaper_Operation_Builder$setFlags(int ), 0, this, n);
            }

            public Operation build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_VolumeShaper_Operation_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flag {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Configuration
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAXIMUM_CURVE_POINTS = 16;
        static int TYPE_ID = 0;
        static int TYPE_SCALE = 1;
        public static int INTERPOLATOR_TYPE_STEP = 0;
        public static int INTERPOLATOR_TYPE_LINEAR = 1;
        public static int INTERPOLATOR_TYPE_CUBIC = 2;
        public static int INTERPOLATOR_TYPE_CUBIC_MONOTONIC = 3;
        public static int OPTION_FLAG_VOLUME_IN_DBFS = 1;
        public static int OPTION_FLAG_CLOCK_TIME = 2;
        private static int OPTION_FLAG_PUBLIC_ALL = 3;
        public static Configuration LINEAR_RAMP;
        public static Configuration CUBIC_RAMP;
        public static Configuration SINE_RAMP;
        public static Configuration SCURVE_RAMP;
        private int mType;
        private int mId;
        private int mOptionFlags;
        private double mDurationMs;
        private int mInterpolatorType;
        private float[] mTimes;
        private float[] mVolumes;
        public static Parcelable.Creator<Configuration> CREATOR;

        private static final int $$robo$$android_media_VolumeShaper_Configuration$getMaximumCurvePoints() {
            return 16;
        }

        private final String $$robo$$android_media_VolumeShaper_Configuration$toString() {
            return "VolumeShaper.Configuration{mType = " + this.mType + ", mId = " + this.mId + (this.mType == 0 ? "}" : ", mOptionFlags = 0x" + Integer.toHexString(this.mOptionFlags).toUpperCase() + ", mDurationMs = " + this.mDurationMs + ", mInterpolatorType = " + this.mInterpolatorType + ", mTimes[] = " + Arrays.toString(this.mTimes) + ", mVolumes[] = " + Arrays.toString(this.mVolumes) + "}");
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$hashCode() {
            return this.mType == 0 ? Objects.hash(this.mType, this.mId) : Objects.hash(this.mType, this.mId, this.mOptionFlags, this.mDurationMs, this.mInterpolatorType, Arrays.hashCode(this.mTimes), Arrays.hashCode(this.mVolumes));
        }

        private final boolean $$robo$$android_media_VolumeShaper_Configuration$equals(Object o) {
            if (!(o instanceof Configuration)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Configuration other = (Configuration)o;
            return this.mType == other.mType && this.mId == other.mId && (this.mType == 0 || this.mOptionFlags == other.mOptionFlags && this.mDurationMs == other.mDurationMs && this.mInterpolatorType == other.mInterpolatorType && Arrays.equals(this.mTimes, other.mTimes) && Arrays.equals(this.mVolumes, other.mVolumes));
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_VolumeShaper_Configuration$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeInt(this.mId);
            if (this.mType != 0) {
                dest.writeInt(this.mOptionFlags);
                dest.writeDouble(this.mDurationMs);
                dest.writeInt(this.mInterpolatorType);
                dest.writeFloat(0.0f);
                dest.writeFloat(0.0f);
                dest.writeInt(this.mTimes.length);
                for (int i = 0; i < this.mTimes.length; ++i) {
                    dest.writeFloat(this.mTimes[i]);
                    dest.writeFloat(this.mVolumes[i]);
                }
            }
        }

        private void $$robo$$android_media_VolumeShaper_Configuration$__constructor__(int id2) {
            if (id2 < 0) {
                throw new IllegalArgumentException("negative id " + id2);
            }
            this.mType = 0;
            this.mId = id2;
            this.mInterpolatorType = 0;
            this.mOptionFlags = 0;
            this.mDurationMs = 0.0;
            this.mTimes = null;
            this.mVolumes = null;
        }

        private void $$robo$$android_media_VolumeShaper_Configuration$__constructor__(int type, int id2, int optionFlags, double durationMs, int interpolatorType, float[] times, float[] volumes) {
            this.mType = type;
            this.mId = id2;
            this.mOptionFlags = optionFlags;
            this.mDurationMs = durationMs;
            this.mInterpolatorType = interpolatorType;
            this.mTimes = times;
            this.mVolumes = volumes;
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$getType() {
            return this.mType;
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$getId() {
            return this.mId;
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$getInterpolatorType() {
            return this.mInterpolatorType;
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$getOptionFlags() {
            return this.mOptionFlags & 3;
        }

        private final int $$robo$$android_media_VolumeShaper_Configuration$getAllOptionFlags() {
            return this.mOptionFlags;
        }

        private final long $$robo$$android_media_VolumeShaper_Configuration$getDuration() {
            return (long)this.mDurationMs;
        }

        private final float[] $$robo$$android_media_VolumeShaper_Configuration$getTimes() {
            return this.mTimes;
        }

        private final float[] $$robo$$android_media_VolumeShaper_Configuration$getVolumes() {
            return this.mVolumes;
        }

        private static final String $$robo$$android_media_VolumeShaper_Configuration$checkCurveForErrors(float[] times, float[] volumes, boolean log) {
            int i;
            if (times == null) {
                return "times array must be non-null";
            }
            if (volumes == null) {
                return "volumes array must be non-null";
            }
            if (times.length != volumes.length) {
                return "array length must match";
            }
            if (times.length < 2) {
                return "array length must be at least 2";
            }
            if (times.length > 16) {
                return "array length must be no larger than 16";
            }
            if (times[0] != 0.0f) {
                return "times must start at 0.f";
            }
            if (times[times.length - 1] != 1.0f) {
                return "times must end at 1.f";
            }
            for (i = 1; i < times.length; ++i) {
                if (times[i] > times[i - 1]) continue;
                return "times not monotonic increasing, check index " + i;
            }
            if (log) {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    return "volumes for log scale cannot be positive, check index " + i;
                }
            } else {
                for (i = 0; i < volumes.length; ++i) {
                    if (volumes[i] >= 0.0f && volumes[i] <= 1.0f) continue;
                    return "volumes for linear scale must be between 0.f and 1.f, check index " + i;
                }
            }
            return null;
        }

        private static final void $$robo$$android_media_VolumeShaper_Configuration$checkCurveForErrorsAndThrowException(float[] times, float[] volumes, boolean log, boolean ise) {
            String error = Configuration.checkCurveForErrors(times, volumes, log);
            if (error != null) {
                if (ise) {
                    throw new IllegalStateException(error);
                }
                throw new IllegalArgumentException(error);
            }
        }

        private static final void $$robo$$android_media_VolumeShaper_Configuration$checkValidVolumeAndThrowException(float volume, boolean log) {
            if (log) {
                if (!(volume <= 0.0f)) {
                    throw new IllegalArgumentException("dbfs volume must be 0.f or less");
                }
            } else if (!(volume >= 0.0f) || !(volume <= 1.0f)) {
                throw new IllegalArgumentException("volume must be >= 0.f and <= 1.f");
            }
        }

        private static final void $$robo$$android_media_VolumeShaper_Configuration$clampVolume(float[] volumes, boolean log) {
            if (log) {
                for (int i = 0; i < volumes.length; ++i) {
                    if (volumes[i] <= 0.0f) continue;
                    volumes[i] = 0.0f;
                }
            } else {
                for (int i = 0; i < volumes.length; ++i) {
                    if (!(volumes[i] >= 0.0f)) {
                        volumes[i] = 0.0f;
                        continue;
                    }
                    if (volumes[i] <= 1.0f) continue;
                    volumes[i] = 1.0f;
                }
            }
        }

        private /* synthetic */ void $$robo$$android_media_VolumeShaper_Configuration$__constructor__(int x0, int x1, int x2, double x3, int x4, float[] x5, float[] x6, 1 x7) {
        }

        static void __staticInitializer__() {
            LINEAR_RAMP = new Builder().setInterpolatorType(1).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDuration(1000L).build();
            CUBIC_RAMP = new Builder().setInterpolatorType(2).setCurve(new float[]{0.0f, 1.0f}, new float[]{0.0f, 1.0f}).setDuration(1000L).build();
            int POINTS = 16;
            float[] times = new float[16];
            float[] sines = new float[16];
            float[] scurve = new float[16];
            for (int i = 0; i < 16; ++i) {
                float sine;
                times[i] = (float)i / 15.0f;
                sines[i] = sine = (float)Math.sin((double)times[i] * Math.PI / 2.0);
                scurve[i] = sine * sine;
            }
            SINE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, sines).setDuration(1000L).build();
            SCURVE_RAMP = new Builder().setInterpolatorType(2).setCurve(times, scurve).setDuration(1000L).build();
            CREATOR = new Parcelable.Creator<Configuration>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_VolumeShaper_Configuration_1$__constructor__() {
                }

                private final Configuration $$robo$$android_media_VolumeShaper_Configuration_1$createFromParcel(Parcel p) {
                    int type = p.readInt();
                    int id2 = p.readInt();
                    if (type == 0) {
                        return new Configuration(id2);
                    }
                    int optionFlags = p.readInt();
                    double durationMs = p.readDouble();
                    int interpolatorType = p.readInt();
                    float firstSlope = p.readFloat();
                    float lastSlope = p.readFloat();
                    int length = p.readInt();
                    float[] times = new float[length];
                    float[] volumes = new float[length];
                    for (int i = 0; i < length; ++i) {
                        times[i] = p.readFloat();
                        volumes[i] = p.readFloat();
                    }
                    return new Configuration(type, id2, optionFlags, durationMs, interpolatorType, times, volumes);
                }

                private final Configuration[] $$robo$$android_media_VolumeShaper_Configuration_1$newArray(int size) {
                    return new Configuration[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_VolumeShaper_Configuration_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Configuration_1$__constructor__(), 0, this);
                }

                @Override
                public Configuration createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_VolumeShaper_Configuration_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Configuration[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_VolumeShaper_Configuration_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public static int getMaximumCurvePoints() {
            return (int)InvokeDynamicSupport.bootstrapStatic("getMaximumCurvePoints", $$robo$$android_media_VolumeShaper_Configuration$getMaximumCurvePoints(), 0);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_VolumeShaper_Configuration$toString(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_VolumeShaper_Configuration$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_VolumeShaper_Configuration$equals(java.lang.Object ), 0, this, object);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_VolumeShaper_Configuration$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_VolumeShaper_Configuration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_media_VolumeShaper_Configuration$__constructor__(n);
        }

        public Configuration(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Configuration$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(int n, int n2, int n3, double d, int n4, float[] fArray, float[] fArray2) {
            this.$$robo$$android_media_VolumeShaper_Configuration$__constructor__(n, n2, n3, d, n4, fArray, fArray2);
        }

        private Configuration(int n, int n2, int n3, double d, int n4, float[] fArray, float[] fArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Configuration$__constructor__(int int int double int float[] float[] ), 0, this, n, n2, n3, d, n4, fArray, fArray2);
        }

        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_media_VolumeShaper_Configuration$getType(), 0, this);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_VolumeShaper_Configuration$getId(), 0, this);
        }

        public int getInterpolatorType() {
            return (int)InvokeDynamicSupport.bootstrap("getInterpolatorType", $$robo$$android_media_VolumeShaper_Configuration$getInterpolatorType(), 0, this);
        }

        public int getOptionFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getOptionFlags", $$robo$$android_media_VolumeShaper_Configuration$getOptionFlags(), 0, this);
        }

        int getAllOptionFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getAllOptionFlags", $$robo$$android_media_VolumeShaper_Configuration$getAllOptionFlags(), 0, this);
        }

        public long getDuration() {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_media_VolumeShaper_Configuration$getDuration(), 0, this);
        }

        public float[] getTimes() {
            return InvokeDynamicSupport.bootstrap("getTimes", $$robo$$android_media_VolumeShaper_Configuration$getTimes(), 0, this);
        }

        public float[] getVolumes() {
            return InvokeDynamicSupport.bootstrap("getVolumes", $$robo$$android_media_VolumeShaper_Configuration$getVolumes(), 0, this);
        }

        private static String checkCurveForErrors(float[] fArray, float[] fArray2, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("checkCurveForErrors", $$robo$$android_media_VolumeShaper_Configuration$checkCurveForErrors(float[] float[] boolean ), 0, (float[])fArray, (float[])fArray2, (boolean)bl);
        }

        private static void checkCurveForErrorsAndThrowException(float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrapStatic("checkCurveForErrorsAndThrowException", $$robo$$android_media_VolumeShaper_Configuration$checkCurveForErrorsAndThrowException(float[] float[] boolean boolean ), 0, (float[])fArray, (float[])fArray2, (boolean)bl, (boolean)bl2);
        }

        private static void checkValidVolumeAndThrowException(float f, boolean bl) {
            InvokeDynamicSupport.bootstrapStatic("checkValidVolumeAndThrowException", $$robo$$android_media_VolumeShaper_Configuration$checkValidVolumeAndThrowException(float boolean ), 0, (float)f, (boolean)bl);
        }

        private static void clampVolume(float[] fArray, boolean bl) {
            InvokeDynamicSupport.bootstrapStatic("clampVolume", $$robo$$android_media_VolumeShaper_Configuration$clampVolume(float[] boolean ), 0, (float[])fArray, (boolean)bl);
        }

        private /* synthetic */ void __constructor__(int n, int n2, int n3, double d, int n4, float[] fArray, float[] fArray2, 1 var9_8) {
            this.$$robo$$android_media_VolumeShaper_Configuration$__constructor__(n, n2, n3, d, n4, fArray, fArray2, var9_8);
        }

        static {
            RobolectricInternals.classInitializing(Configuration.class);
        }

        public /* synthetic */ Configuration() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Configuration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private int mType;
            private int mId;
            private int mInterpolatorType;
            private int mOptionFlags;
            private double mDurationMs;
            private float[] mTimes;
            private float[] mVolumes;

            private void $$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__() {
                this.mType = 1;
                this.mId = -1;
                this.mInterpolatorType = 2;
                this.mOptionFlags = 2;
                this.mDurationMs = 1000.0;
                this.mTimes = null;
                this.mVolumes = null;
            }

            private void $$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__(Configuration configuration) {
                this.mType = 1;
                this.mId = -1;
                this.mInterpolatorType = 2;
                this.mOptionFlags = 2;
                this.mDurationMs = 1000.0;
                this.mTimes = null;
                this.mVolumes = null;
                this.mType = configuration.getType();
                this.mId = configuration.getId();
                this.mOptionFlags = configuration.getAllOptionFlags();
                this.mInterpolatorType = configuration.getInterpolatorType();
                this.mDurationMs = configuration.getDuration();
                this.mTimes = (float[])configuration.getTimes().clone();
                this.mVolumes = (float[])configuration.getVolumes().clone();
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$setId(int id2) {
                if (id2 < -1) {
                    throw new IllegalArgumentException("invalid id: " + id2);
                }
                this.mId = id2;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$setInterpolatorType(int interpolatorType) {
                switch (interpolatorType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.mInterpolatorType = interpolatorType;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid interpolatorType: " + interpolatorType);
                    }
                }
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$setOptionFlags(int optionFlags) {
                if ((optionFlags & 0xFFFFFFFC) != 0) {
                    throw new IllegalArgumentException("invalid bits in flag: " + optionFlags);
                }
                this.mOptionFlags = this.mOptionFlags & 0xFFFFFFFC | optionFlags;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$setDuration(long durationMillis) {
                if (durationMillis <= 0L) {
                    throw new IllegalArgumentException("duration: " + durationMillis + " not positive");
                }
                this.mDurationMs = durationMillis;
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$setCurve(float[] times, float[] volumes) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(times, volumes, log, false);
                this.mTimes = (float[])times.clone();
                this.mVolumes = (float[])volumes.clone();
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$reflectTimes() {
                int i;
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                for (i = 0; i < this.mTimes.length / 2; ++i) {
                    float temp = this.mTimes[i];
                    this.mTimes[i] = 1.0f - this.mTimes[this.mTimes.length - 1 - i];
                    this.mTimes[this.mTimes.length - 1 - i] = 1.0f - temp;
                    temp = this.mVolumes[i];
                    this.mVolumes[i] = this.mVolumes[this.mVolumes.length - 1 - i];
                    this.mVolumes[this.mVolumes.length - 1 - i] = temp;
                }
                if ((this.mTimes.length & 1) != 0) {
                    this.mTimes[i] = 1.0f - this.mTimes[i];
                }
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$invertVolumes() {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                float min = this.mVolumes[0];
                float max = this.mVolumes[0];
                for (int i = 1; i < this.mVolumes.length; ++i) {
                    if (this.mVolumes[i] < min) {
                        min = this.mVolumes[i];
                        continue;
                    }
                    if (!(this.mVolumes[i] > max)) continue;
                    max = this.mVolumes[i];
                }
                float maxmin = max + min;
                for (int i = 0; i < this.mVolumes.length; ++i) {
                    this.mVolumes[i] = maxmin - this.mVolumes[i];
                }
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$scaleToEndVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                Configuration.checkValidVolumeAndThrowException(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * this.mTimes[i];
                    }
                } else {
                    float scale = (volume - startVolume) / (endVolume - startVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - startVolume) + startVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            private final Builder $$robo$$android_media_VolumeShaper_Configuration_Builder$scaleToStartVolume(float volume) {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                Configuration.checkValidVolumeAndThrowException(volume, log);
                float startVolume = this.mVolumes[0];
                float endVolume = this.mVolumes[this.mVolumes.length - 1];
                if (endVolume == startVolume) {
                    float offset = volume - startVolume;
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = this.mVolumes[i] + offset * (1.0f - this.mTimes[i]);
                    }
                } else {
                    float scale = (volume - endVolume) / (startVolume - endVolume);
                    for (int i = 0; i < this.mVolumes.length; ++i) {
                        this.mVolumes[i] = scale * (this.mVolumes[i] - endVolume) + endVolume;
                    }
                }
                Configuration.clampVolume(this.mVolumes, log);
                return this;
            }

            private final Configuration $$robo$$android_media_VolumeShaper_Configuration_Builder$build() {
                boolean log = (this.mOptionFlags & 1) != 0;
                Configuration.checkCurveForErrorsAndThrowException(this.mTimes, this.mVolumes, log, true);
                return new Configuration(this.mType, this.mId, this.mOptionFlags, this.mDurationMs, this.mInterpolatorType, this.mTimes, this.mVolumes);
            }

            private void __constructor__() {
                this.$$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__(), 0, this);
            }

            private void __constructor__(Configuration configuration) {
                this.$$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__(configuration);
            }

            public Builder(Configuration configuration) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_VolumeShaper_Configuration_Builder$__constructor__(android.media.VolumeShaper$Configuration ), 0, this, configuration);
            }

            public Builder setId(int n) {
                return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_media_VolumeShaper_Configuration_Builder$setId(int ), 0, this, n);
            }

            public Builder setInterpolatorType(int n) {
                return InvokeDynamicSupport.bootstrap("setInterpolatorType", $$robo$$android_media_VolumeShaper_Configuration_Builder$setInterpolatorType(int ), 0, this, n);
            }

            public Builder setOptionFlags(int n) {
                return InvokeDynamicSupport.bootstrap("setOptionFlags", $$robo$$android_media_VolumeShaper_Configuration_Builder$setOptionFlags(int ), 0, this, n);
            }

            public Builder setDuration(long l) {
                return InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_media_VolumeShaper_Configuration_Builder$setDuration(long ), 0, this, l);
            }

            public Builder setCurve(float[] fArray, float[] fArray2) {
                return InvokeDynamicSupport.bootstrap("setCurve", $$robo$$android_media_VolumeShaper_Configuration_Builder$setCurve(float[] float[] ), 0, this, fArray, fArray2);
            }

            public Builder reflectTimes() {
                return InvokeDynamicSupport.bootstrap("reflectTimes", $$robo$$android_media_VolumeShaper_Configuration_Builder$reflectTimes(), 0, this);
            }

            public Builder invertVolumes() {
                return InvokeDynamicSupport.bootstrap("invertVolumes", $$robo$$android_media_VolumeShaper_Configuration_Builder$invertVolumes(), 0, this);
            }

            public Builder scaleToEndVolume(float f) {
                return InvokeDynamicSupport.bootstrap("scaleToEndVolume", $$robo$$android_media_VolumeShaper_Configuration_Builder$scaleToEndVolume(float ), 0, this, f);
            }

            public Builder scaleToStartVolume(float f) {
                return InvokeDynamicSupport.bootstrap("scaleToStartVolume", $$robo$$android_media_VolumeShaper_Configuration_Builder$scaleToStartVolume(float ), 0, this, f);
            }

            public Configuration build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_VolumeShaper_Configuration_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OptionFlag {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InterpolatorType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }
}

