/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.SystemApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusInfo;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.IAudioService;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioPolicyConfig;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class AudioPolicy
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioPolicy";
    private static boolean DEBUG = false;
    private Object mLock;
    @SystemApi
    public static int POLICY_STATUS_UNREGISTERED = 1;
    @SystemApi
    public static int POLICY_STATUS_REGISTERED = 2;
    private int mStatus;
    private String mRegistrationId;
    private AudioPolicyStatusListener mStatusListener;
    private boolean mIsFocusPolicy;
    @SystemApi
    public static int FOCUS_POLICY_DUCKING_IN_APP = 0;
    public static int FOCUS_POLICY_DUCKING_DEFAULT = 0;
    @SystemApi
    public static int FOCUS_POLICY_DUCKING_IN_POLICY = 1;
    private AudioPolicyFocusListener mFocusListener;
    private AudioPolicyVolumeCallback mVolCb;
    private Context mContext;
    private AudioPolicyConfig mConfig;
    private IAudioPolicyCallback mPolicyCb;
    private EventHandler mEventHandler;
    private static int MSG_POLICY_STATUS_CHANGE = 0;
    private static int MSG_FOCUS_GRANT = 1;
    private static int MSG_FOCUS_LOSS = 2;
    private static int MSG_MIX_STATE_UPDATE = 3;
    private static int MSG_FOCUS_REQUEST = 4;
    private static int MSG_FOCUS_ABANDON = 5;
    private static int MSG_VOL_ADJUST = 6;
    private static IAudioService sService;

    private final AudioPolicyConfig $$robo$$android_media_audiopolicy_AudioPolicy$getConfig() {
        return this.mConfig;
    }

    private final boolean $$robo$$android_media_audiopolicy_AudioPolicy$hasFocusListener() {
        return this.mFocusListener != null;
    }

    private final boolean $$robo$$android_media_audiopolicy_AudioPolicy$isFocusPolicy() {
        return this.mIsFocusPolicy;
    }

    private final boolean $$robo$$android_media_audiopolicy_AudioPolicy$isVolumeController() {
        return this.mVolCb != null;
    }

    private void $$robo$$android_media_audiopolicy_AudioPolicy$__constructor__(AudioPolicyConfig config, Context context, Looper looper, AudioPolicyFocusListener fl, AudioPolicyStatusListener sl, boolean isFocusPolicy, AudioPolicyVolumeCallback vc) {
        this.mLock = new Object();
        this.mPolicyCb = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AudioPolicy this$0;

            private void $$robo$$android_media_audiopolicy_AudioPolicy_1$__constructor__(AudioPolicy this$0) {
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusGrant(AudioFocusInfo afi, int requestResult) {
                this.this$0.sendMsg(1, afi, requestResult);
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusLoss(AudioFocusInfo afi, boolean wasNotified) {
                this.this$0.sendMsg(2, afi, wasNotified ? 1 : 0);
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusRequest(AudioFocusInfo afi, int requestResult) {
                this.this$0.sendMsg(4, afi, requestResult);
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusAbandon(AudioFocusInfo afi) {
                this.this$0.sendMsg(5, afi, 0);
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyMixStateUpdate(String regId, int state) {
                for (AudioMix mix : this.this$0.mConfig.getMixes()) {
                    if (!mix.getRegistration().equals(regId)) continue;
                    mix.mMixState = state;
                    this.this$0.sendMsg(3, mix, 0);
                }
            }

            private final void $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyVolumeAdjust(int adjustment) {
                this.this$0.sendMsg(6, null, adjustment);
            }

            private void __constructor__(AudioPolicy audioPolicy) {
                this.$$robo$$android_media_audiopolicy_AudioPolicy_1$__constructor__(audioPolicy);
            }
            {
                this.this$0 = audioPolicy;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_1$__constructor__(android.media.audiopolicy.AudioPolicy ), 0, this, audioPolicy);
            }

            @Override
            public void notifyAudioFocusGrant(AudioFocusInfo audioFocusInfo, int n) {
                InvokeDynamicSupport.bootstrap("notifyAudioFocusGrant", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusGrant(android.media.AudioFocusInfo int ), 0, this, audioFocusInfo, n);
            }

            @Override
            public void notifyAudioFocusLoss(AudioFocusInfo audioFocusInfo, boolean bl) {
                InvokeDynamicSupport.bootstrap("notifyAudioFocusLoss", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusLoss(android.media.AudioFocusInfo boolean ), 0, this, audioFocusInfo, bl);
            }

            @Override
            public void notifyAudioFocusRequest(AudioFocusInfo audioFocusInfo, int n) {
                InvokeDynamicSupport.bootstrap("notifyAudioFocusRequest", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusRequest(android.media.AudioFocusInfo int ), 0, this, audioFocusInfo, n);
            }

            @Override
            public void notifyAudioFocusAbandon(AudioFocusInfo audioFocusInfo) {
                InvokeDynamicSupport.bootstrap("notifyAudioFocusAbandon", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyAudioFocusAbandon(android.media.AudioFocusInfo ), 0, this, audioFocusInfo);
            }

            @Override
            public void notifyMixStateUpdate(String string2, int n) {
                InvokeDynamicSupport.bootstrap("notifyMixStateUpdate", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyMixStateUpdate(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void notifyVolumeAdjust(int n) {
                InvokeDynamicSupport.bootstrap("notifyVolumeAdjust", $$robo$$android_media_audiopolicy_AudioPolicy_1$notifyVolumeAdjust(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConfig = config;
        this.mStatus = 1;
        this.mContext = context;
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, this, looper);
        } else {
            this.mEventHandler = null;
            Log.e("AudioPolicy", "No event handler due to looper without a thread");
        }
        this.mFocusListener = fl;
        this.mStatusListener = sl;
        this.mIsFocusPolicy = isFocusPolicy;
        this.mVolCb = vc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final int $$robo$$android_media_audiopolicy_AudioPolicy$attachMixes(List<AudioMix> mixes) {
        if (mixes == null) {
            throw new IllegalArgumentException("Illegal null list of AudioMix");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot alter unregistered AudioPolicy");
            }
            ArrayList<AudioMix> zeMixes = new ArrayList<AudioMix>(mixes.size());
            for (AudioMix mix : mixes) {
                if (mix == null) {
                    throw new IllegalArgumentException("Illegal null AudioMix in attachMixes");
                }
                zeMixes.add(mix);
            }
            AudioPolicyConfig cfg = new AudioPolicyConfig(zeMixes);
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.addMixForPolicy(cfg, this.cb());
                if (status == 0) {
                    this.mConfig.add(zeMixes);
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e("AudioPolicy", "Dead object in attachMixes", e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final int $$robo$$android_media_audiopolicy_AudioPolicy$detachMixes(List<AudioMix> mixes) {
        if (mixes == null) {
            throw new IllegalArgumentException("Illegal null list of AudioMix");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot alter unregistered AudioPolicy");
            }
            ArrayList<AudioMix> zeMixes = new ArrayList<AudioMix>(mixes.size());
            for (AudioMix mix : mixes) {
                if (mix == null) {
                    throw new IllegalArgumentException("Illegal null AudioMix in detachMixes");
                }
                zeMixes.add(mix);
            }
            AudioPolicyConfig cfg = new AudioPolicyConfig(zeMixes);
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.removeMixForPolicy(cfg, this.cb());
                if (status == 0) {
                    this.mConfig.remove(zeMixes);
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e("AudioPolicy", "Dead object in detachMixes", e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiopolicy_AudioPolicy$setRegistration(String regId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRegistrationId = regId;
            this.mConfig.setRegistration(regId);
            this.mStatus = regId != null ? 2 : 1;
        }
        this.sendMsg(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_media_audiopolicy_AudioPolicy$policyReadyToUse() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                Log.e("AudioPolicy", "Cannot use unregistered AudioPolicy");
                return false;
            }
            if (this.mContext == null) {
                Log.e("AudioPolicy", "Cannot use AudioPolicy without context");
                return false;
            }
            if (this.mRegistrationId == null) {
                Log.e("AudioPolicy", "Cannot use unregistered AudioPolicy");
                return false;
            }
        }
        if (0 != this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_ROUTING")) {
            Slog.w("AudioPolicy", "Cannot use AudioPolicy for pid " + Binder.getCallingPid() + " / uid " + Binder.getCallingUid() + ", needs MODIFY_AUDIO_ROUTING");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicy$checkMixReadyToUse(AudioMix mix, boolean forTrack) throws IllegalArgumentException {
        if (mix == null) {
            String msg = forTrack ? "Invalid null AudioMix for AudioTrack creation" : "Invalid null AudioMix for AudioRecord creation";
            throw new IllegalArgumentException(msg);
        }
        if (!this.mConfig.mMixes.contains(mix)) {
            throw new IllegalArgumentException("Invalid mix: not part of this policy");
        }
        if ((mix.getRouteFlags() & 2) != 2) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for loop back");
        }
        if (forTrack && mix.getMixType() != 1) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for being a recording source");
        }
        if (!forTrack && mix.getMixType() != 0) {
            throw new IllegalArgumentException("Invalid AudioMix: not defined for capturing playback");
        }
    }

    @SystemApi
    private final int $$robo$$android_media_audiopolicy_AudioPolicy$getFocusDuckingBehavior() {
        return this.mConfig.mDuckingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final int $$robo$$android_media_audiopolicy_AudioPolicy$setFocusDuckingBehavior(int behavior) throws IllegalArgumentException, IllegalStateException {
        if (behavior != 0 && behavior != 1) {
            throw new IllegalArgumentException("Invalid ducking behavior " + behavior);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatus != 2) {
                throw new IllegalStateException("Cannot change ducking behavior for unregistered policy");
            }
            if (behavior == 1 && this.mFocusListener == null) {
                throw new IllegalStateException("Cannot handle ducking without an audio focus listener");
            }
            IAudioService service = AudioPolicy.getService();
            try {
                int status = service.setFocusPropertiesForPolicy(behavior, this.cb());
                if (status == 0) {
                    this.mConfig.mDuckingPolicy = behavior;
                }
                return status;
            }
            catch (RemoteException e) {
                Log.e("AudioPolicy", "Dead object in setFocusPropertiesForPolicy for behavior", e);
                return -1;
            }
        }
    }

    @SystemApi
    private final AudioRecord $$robo$$android_media_audiopolicy_AudioPolicy$createAudioRecordSink(AudioMix mix) throws IllegalArgumentException {
        if (!this.policyReadyToUse()) {
            Log.e("AudioPolicy", "Cannot create AudioRecord sink for AudioMix");
            return null;
        }
        this.checkMixReadyToUse(mix, false);
        AudioFormat mixFormat = new AudioFormat.Builder(mix.getFormat()).setChannelMask(AudioFormat.inChannelMaskFromOutChannelMask(mix.getFormat().getChannelMask())).build();
        AudioRecord ar = new AudioRecord(new AudioAttributes.Builder().setInternalCapturePreset(8).addTag(AudioPolicy.addressForTag(mix)).addTag("fixedVolume").build(), mixFormat, AudioRecord.getMinBufferSize(mix.getFormat().getSampleRate(), 12, mix.getFormat().getEncoding()), 0);
        return ar;
    }

    @SystemApi
    private final AudioTrack $$robo$$android_media_audiopolicy_AudioPolicy$createAudioTrackSource(AudioMix mix) throws IllegalArgumentException {
        if (!this.policyReadyToUse()) {
            Log.e("AudioPolicy", "Cannot create AudioTrack source for AudioMix");
            return null;
        }
        this.checkMixReadyToUse(mix, true);
        AudioTrack at = new AudioTrack(new AudioAttributes.Builder().setUsage(15).addTag(AudioPolicy.addressForTag(mix)).build(), mix.getFormat(), AudioTrack.getMinBufferSize(mix.getFormat().getSampleRate(), mix.getFormat().getChannelMask(), mix.getFormat().getEncoding()), 1, 0);
        return at;
    }

    @SystemApi
    private final int $$robo$$android_media_audiopolicy_AudioPolicy$getStatus() {
        return this.mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_audiopolicy_AudioPolicy$onPolicyStatusChange() {
        AudioPolicyStatusListener l;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStatusListener == null) {
                return;
            }
            l = this.mStatusListener;
        }
        l.onStatusChange();
    }

    private final IAudioPolicyCallback $$robo$$android_media_audiopolicy_AudioPolicy$cb() {
        return this.mPolicyCb;
    }

    private static final String $$robo$$android_media_audiopolicy_AudioPolicy$addressForTag(AudioMix mix) {
        return "addr=" + mix.getRegistration();
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicy$sendMsg(int msg) {
        if (this.mEventHandler != null) {
            this.mEventHandler.sendEmptyMessage(msg);
        }
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicy$sendMsg(int msg, Object obj, int i) {
        if (this.mEventHandler != null) {
            this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(msg, i, 0, obj));
        }
    }

    private static final IAudioService $$robo$$android_media_audiopolicy_AudioPolicy$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private final String $$robo$$android_media_audiopolicy_AudioPolicy$toLogFriendlyString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicy:\n");
        textDump = textDump + "config=" + this.mConfig.toLogFriendlyString();
        return textDump;
    }

    private /* synthetic */ void $$robo$$android_media_audiopolicy_AudioPolicy$__constructor__(AudioPolicyConfig x0, Context x1, Looper x2, AudioPolicyFocusListener x3, AudioPolicyStatusListener x4, boolean x5, AudioPolicyVolumeCallback x6, 1 x7) {
    }

    public AudioPolicyConfig getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_media_audiopolicy_AudioPolicy$getConfig(), 0, this);
    }

    public boolean hasFocusListener() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusListener", $$robo$$android_media_audiopolicy_AudioPolicy$hasFocusListener(), 0, this);
    }

    public boolean isFocusPolicy() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocusPolicy", $$robo$$android_media_audiopolicy_AudioPolicy$isFocusPolicy(), 0, this);
    }

    public boolean isVolumeController() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolumeController", $$robo$$android_media_audiopolicy_AudioPolicy$isVolumeController(), 0, this);
    }

    private void __constructor__(AudioPolicyConfig audioPolicyConfig, Context context, Looper looper, AudioPolicyFocusListener audioPolicyFocusListener, AudioPolicyStatusListener audioPolicyStatusListener, boolean bl, AudioPolicyVolumeCallback audioPolicyVolumeCallback) {
        this.$$robo$$android_media_audiopolicy_AudioPolicy$__constructor__(audioPolicyConfig, context, looper, audioPolicyFocusListener, audioPolicyStatusListener, bl, audioPolicyVolumeCallback);
    }

    private AudioPolicy(AudioPolicyConfig audioPolicyConfig, Context context, Looper looper, AudioPolicyFocusListener audioPolicyFocusListener, AudioPolicyStatusListener audioPolicyStatusListener, boolean bl, AudioPolicyVolumeCallback audioPolicyVolumeCallback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy$__constructor__(android.media.audiopolicy.AudioPolicyConfig android.content.Context android.os.Looper android.media.audiopolicy.AudioPolicy$AudioPolicyFocusListener android.media.audiopolicy.AudioPolicy$AudioPolicyStatusListener boolean android.media.audiopolicy.AudioPolicy$AudioPolicyVolumeCallback ), 0, this, audioPolicyConfig, context, looper, audioPolicyFocusListener, audioPolicyStatusListener, bl, audioPolicyVolumeCallback);
    }

    @SystemApi
    public int attachMixes(List<AudioMix> list) {
        return (int)InvokeDynamicSupport.bootstrap("attachMixes", $$robo$$android_media_audiopolicy_AudioPolicy$attachMixes(java.util.List<android.media.audiopolicy.AudioMix> ), 0, this, list);
    }

    @SystemApi
    public int detachMixes(List<AudioMix> list) {
        return (int)InvokeDynamicSupport.bootstrap("detachMixes", $$robo$$android_media_audiopolicy_AudioPolicy$detachMixes(java.util.List<android.media.audiopolicy.AudioMix> ), 0, this, list);
    }

    public void setRegistration(String string2) {
        InvokeDynamicSupport.bootstrap("setRegistration", $$robo$$android_media_audiopolicy_AudioPolicy$setRegistration(java.lang.String ), 0, this, string2);
    }

    private boolean policyReadyToUse() {
        return (boolean)InvokeDynamicSupport.bootstrap("policyReadyToUse", $$robo$$android_media_audiopolicy_AudioPolicy$policyReadyToUse(), 0, this);
    }

    private void checkMixReadyToUse(AudioMix audioMix, boolean bl) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("checkMixReadyToUse", $$robo$$android_media_audiopolicy_AudioPolicy$checkMixReadyToUse(android.media.audiopolicy.AudioMix boolean ), 0, this, audioMix, bl);
    }

    @SystemApi
    public int getFocusDuckingBehavior() {
        return (int)InvokeDynamicSupport.bootstrap("getFocusDuckingBehavior", $$robo$$android_media_audiopolicy_AudioPolicy$getFocusDuckingBehavior(), 0, this);
    }

    @SystemApi
    public int setFocusDuckingBehavior(int n) throws IllegalArgumentException, IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("setFocusDuckingBehavior", $$robo$$android_media_audiopolicy_AudioPolicy$setFocusDuckingBehavior(int ), 0, this, n);
    }

    @SystemApi
    public AudioRecord createAudioRecordSink(AudioMix audioMix) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("createAudioRecordSink", $$robo$$android_media_audiopolicy_AudioPolicy$createAudioRecordSink(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
    }

    @SystemApi
    public AudioTrack createAudioTrackSource(AudioMix audioMix) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrap("createAudioTrackSource", $$robo$$android_media_audiopolicy_AudioPolicy$createAudioTrackSource(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
    }

    @SystemApi
    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_media_audiopolicy_AudioPolicy$getStatus(), 0, this);
    }

    private void onPolicyStatusChange() {
        InvokeDynamicSupport.bootstrap("onPolicyStatusChange", $$robo$$android_media_audiopolicy_AudioPolicy$onPolicyStatusChange(), 0, this);
    }

    public IAudioPolicyCallback cb() {
        return InvokeDynamicSupport.bootstrap("cb", $$robo$$android_media_audiopolicy_AudioPolicy$cb(), 0, this);
    }

    private static String addressForTag(AudioMix audioMix) {
        return InvokeDynamicSupport.bootstrapStatic("addressForTag", $$robo$$android_media_audiopolicy_AudioPolicy$addressForTag(android.media.audiopolicy.AudioMix ), 0, (AudioMix)audioMix);
    }

    private void sendMsg(int n) {
        InvokeDynamicSupport.bootstrap("sendMsg", $$robo$$android_media_audiopolicy_AudioPolicy$sendMsg(int ), 0, this, n);
    }

    private void sendMsg(int n, Object object, int n2) {
        InvokeDynamicSupport.bootstrap("sendMsg", $$robo$$android_media_audiopolicy_AudioPolicy$sendMsg(int java.lang.Object int ), 0, this, n, object, n2);
    }

    private static IAudioService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_audiopolicy_AudioPolicy$getService(), 0);
    }

    public String toLogFriendlyString() {
        return InvokeDynamicSupport.bootstrap("toLogFriendlyString", $$robo$$android_media_audiopolicy_AudioPolicy$toLogFriendlyString(), 0, this);
    }

    private /* synthetic */ void __constructor__(AudioPolicyConfig audioPolicyConfig, Context context, Looper looper, AudioPolicyFocusListener audioPolicyFocusListener, AudioPolicyStatusListener audioPolicyStatusListener, boolean bl, AudioPolicyVolumeCallback audioPolicyVolumeCallback, 1 var8_8) {
        this.$$robo$$android_media_audiopolicy_AudioPolicy$__constructor__(audioPolicyConfig, context, looper, audioPolicyFocusListener, audioPolicyStatusListener, bl, audioPolicyVolumeCallback, var8_8);
    }

    public /* synthetic */ AudioPolicy() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyStatus {
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AudioPolicy this$0;

        private void $$robo$$android_media_audiopolicy_AudioPolicy_EventHandler$__constructor__(AudioPolicy audioPolicy, AudioPolicy ap, Looper looper) {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.this$0.onPolicyStatusChange();
                    break;
                }
                case 1: {
                    if (this.this$0.mFocusListener == null) break;
                    this.this$0.mFocusListener.onAudioFocusGrant((AudioFocusInfo)msg.obj, msg.arg1);
                    break;
                }
                case 2: {
                    if (this.this$0.mFocusListener == null) break;
                    this.this$0.mFocusListener.onAudioFocusLoss((AudioFocusInfo)msg.obj, msg.arg1 != 0);
                    break;
                }
                case 3: {
                    if (this.this$0.mStatusListener == null) break;
                    this.this$0.mStatusListener.onMixStateUpdate((AudioMix)msg.obj);
                    break;
                }
                case 4: {
                    if (this.this$0.mFocusListener != null) {
                        this.this$0.mFocusListener.onAudioFocusRequest((AudioFocusInfo)msg.obj, msg.arg1);
                        break;
                    }
                    Log.e("AudioPolicy", "Invalid null focus listener for focus request event");
                    break;
                }
                case 5: {
                    if (this.this$0.mFocusListener != null) {
                        this.this$0.mFocusListener.onAudioFocusAbandon((AudioFocusInfo)msg.obj);
                        break;
                    }
                    Log.e("AudioPolicy", "Invalid null focus listener for focus abandon event");
                    break;
                }
                case 6: {
                    if (this.this$0.mVolCb != null) {
                        this.this$0.mVolCb.onVolumeAdjustment(msg.arg1);
                        break;
                    }
                    Log.e("AudioPolicy", "Invalid null volume event");
                    break;
                }
                default: {
                    Log.e("AudioPolicy", "Unknown event " + msg.what);
                }
            }
        }

        private void __constructor__(AudioPolicy audioPolicy, AudioPolicy audioPolicy2, Looper looper) {
            this.$$robo$$android_media_audiopolicy_AudioPolicy_EventHandler$__constructor__(audioPolicy, audioPolicy2, looper);
        }

        public EventHandler(AudioPolicy audioPolicy, AudioPolicy audioPolicy2, Looper looper) {
            this.this$0 = audioPolicy;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_EventHandler$__constructor__(android.media.audiopolicy.AudioPolicy android.media.audiopolicy.AudioPolicy android.os.Looper ), 0, this, audioPolicy, audioPolicy2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_audiopolicy_AudioPolicy_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static abstract class AudioPolicyVolumeCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyVolumeCallback$__constructor__() {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyVolumeCallback$onVolumeAdjustment(int adjustment) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyVolumeCallback$__constructor__();
        }

        public AudioPolicyVolumeCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyVolumeCallback$__constructor__(), 0, this);
        }

        public void onVolumeAdjustment(int n) {
            InvokeDynamicSupport.bootstrap("onVolumeAdjustment", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyVolumeCallback$onVolumeAdjustment(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyVolumeCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static abstract class AudioPolicyFocusListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$__constructor__() {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusGrant(AudioFocusInfo afi, int requestResult) {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusLoss(AudioFocusInfo afi, boolean wasNotified) {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusRequest(AudioFocusInfo afi, int requestResult) {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusAbandon(AudioFocusInfo afi) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$__constructor__();
        }

        public AudioPolicyFocusListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$__constructor__(), 0, this);
        }

        public void onAudioFocusGrant(AudioFocusInfo audioFocusInfo, int n) {
            InvokeDynamicSupport.bootstrap("onAudioFocusGrant", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusGrant(android.media.AudioFocusInfo int ), 0, this, audioFocusInfo, n);
        }

        public void onAudioFocusLoss(AudioFocusInfo audioFocusInfo, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAudioFocusLoss", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusLoss(android.media.AudioFocusInfo boolean ), 0, this, audioFocusInfo, bl);
        }

        public void onAudioFocusRequest(AudioFocusInfo audioFocusInfo, int n) {
            InvokeDynamicSupport.bootstrap("onAudioFocusRequest", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusRequest(android.media.AudioFocusInfo int ), 0, this, audioFocusInfo, n);
        }

        public void onAudioFocusAbandon(AudioFocusInfo audioFocusInfo) {
            InvokeDynamicSupport.bootstrap("onAudioFocusAbandon", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyFocusListener$onAudioFocusAbandon(android.media.AudioFocusInfo ), 0, this, audioFocusInfo);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyFocusListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static abstract class AudioPolicyStatusListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$__constructor__() {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$onStatusChange() {
        }

        private final void $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$onMixStateUpdate(AudioMix mix) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$__constructor__();
        }

        public AudioPolicyStatusListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$__constructor__(), 0, this);
        }

        public void onStatusChange() {
            InvokeDynamicSupport.bootstrap("onStatusChange", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$onStatusChange(), 0, this);
        }

        public void onMixStateUpdate(AudioMix audioMix) {
            InvokeDynamicSupport.bootstrap("onMixStateUpdate", $$robo$$android_media_audiopolicy_AudioPolicy_AudioPolicyStatusListener$onMixStateUpdate(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyStatusListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ArrayList<AudioMix> mMixes;
        private Context mContext;
        private Looper mLooper;
        private AudioPolicyFocusListener mFocusListener;
        private AudioPolicyStatusListener mStatusListener;
        private boolean mIsFocusPolicy;
        private AudioPolicyVolumeCallback mVolCb;

        @SystemApi
        private void $$robo$$android_media_audiopolicy_AudioPolicy_Builder$__constructor__(Context context) {
            this.mIsFocusPolicy = false;
            this.mMixes = new ArrayList();
            this.mContext = context;
        }

        @SystemApi
        private final Builder $$robo$$android_media_audiopolicy_AudioPolicy_Builder$addMix(AudioMix mix) throws IllegalArgumentException {
            if (mix == null) {
                throw new IllegalArgumentException("Illegal null AudioMix argument");
            }
            this.mMixes.add(mix);
            return this;
        }

        @SystemApi
        private final Builder $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setLooper(Looper looper) throws IllegalArgumentException {
            if (looper == null) {
                throw new IllegalArgumentException("Illegal null Looper argument");
            }
            this.mLooper = looper;
            return this;
        }

        @SystemApi
        private final void $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyFocusListener(AudioPolicyFocusListener l) {
            this.mFocusListener = l;
        }

        @SystemApi
        private final Builder $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setIsAudioFocusPolicy(boolean isFocusPolicy) {
            this.mIsFocusPolicy = isFocusPolicy;
            return this;
        }

        @SystemApi
        private final void $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyStatusListener(AudioPolicyStatusListener l) {
            this.mStatusListener = l;
        }

        @SystemApi
        private final Builder $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyVolumeCallback(AudioPolicyVolumeCallback vc) {
            if (vc == null) {
                throw new IllegalArgumentException("Invalid null volume callback");
            }
            this.mVolCb = vc;
            return this;
        }

        @SystemApi
        private final AudioPolicy $$robo$$android_media_audiopolicy_AudioPolicy_Builder$build() {
            if (this.mStatusListener != null) {
                for (AudioMix mix : this.mMixes) {
                    mix.mCallbackFlags |= 1;
                }
            }
            if (this.mIsFocusPolicy && this.mFocusListener == null) {
                throw new IllegalStateException("Cannot be a focus policy without an AudioPolicyFocusListener");
            }
            return new AudioPolicy(new AudioPolicyConfig(this.mMixes), this.mContext, this.mLooper, this.mFocusListener, this.mStatusListener, this.mIsFocusPolicy, this.mVolCb);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_media_audiopolicy_AudioPolicy_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        @SystemApi
        public Builder addMix(AudioMix audioMix) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("addMix", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$addMix(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
        }

        @SystemApi
        public Builder setLooper(Looper looper) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setLooper", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setLooper(android.os.Looper ), 0, this, looper);
        }

        @SystemApi
        public void setAudioPolicyFocusListener(AudioPolicyFocusListener audioPolicyFocusListener) {
            InvokeDynamicSupport.bootstrap("setAudioPolicyFocusListener", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyFocusListener(android.media.audiopolicy.AudioPolicy$AudioPolicyFocusListener ), 0, this, audioPolicyFocusListener);
        }

        @SystemApi
        public Builder setIsAudioFocusPolicy(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIsAudioFocusPolicy", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setIsAudioFocusPolicy(boolean ), 0, this, bl);
        }

        @SystemApi
        public void setAudioPolicyStatusListener(AudioPolicyStatusListener audioPolicyStatusListener) {
            InvokeDynamicSupport.bootstrap("setAudioPolicyStatusListener", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyStatusListener(android.media.audiopolicy.AudioPolicy$AudioPolicyStatusListener ), 0, this, audioPolicyStatusListener);
        }

        @SystemApi
        public Builder setAudioPolicyVolumeCallback(AudioPolicyVolumeCallback audioPolicyVolumeCallback) {
            return InvokeDynamicSupport.bootstrap("setAudioPolicyVolumeCallback", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$setAudioPolicyVolumeCallback(android.media.audiopolicy.AudioPolicy$AudioPolicyVolumeCallback ), 0, this, audioPolicyVolumeCallback);
        }

        @SystemApi
        public AudioPolicy build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_audiopolicy_AudioPolicy_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

