/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioPolicyConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AudioPolicyConfig";
    protected ArrayList<AudioMix> mMixes;
    protected int mDuckingPolicy;
    private String mRegistrationId;
    private int mMixCounter;
    public static Parcelable.Creator<AudioPolicyConfig> CREATOR;

    private void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(AudioPolicyConfig conf) {
        this.mDuckingPolicy = 0;
        this.mRegistrationId = null;
        this.mMixCounter = 0;
        this.mMixes = conf.mMixes;
    }

    private void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(ArrayList<AudioMix> mixes) {
        this.mDuckingPolicy = 0;
        this.mRegistrationId = null;
        this.mMixCounter = 0;
        this.mMixes = mixes;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$addMix(AudioMix mix) throws IllegalArgumentException {
        if (mix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(mix);
    }

    private final ArrayList<AudioMix> $$robo$$android_media_audiopolicy_AudioPolicyConfig$getMixes() {
        return this.mMixes;
    }

    private final int $$robo$$android_media_audiopolicy_AudioPolicyConfig$hashCode() {
        return Objects.hash(this.mMixes);
    }

    private final int $$robo$$android_media_audiopolicy_AudioPolicyConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMixes.size());
        for (AudioMix mix : this.mMixes) {
            dest.writeInt(mix.getRouteFlags());
            dest.writeInt(mix.mCallbackFlags);
            dest.writeInt(mix.mDeviceSystemType);
            dest.writeString(mix.mDeviceAddress);
            dest.writeInt(mix.getFormat().getSampleRate());
            dest.writeInt(mix.getFormat().getEncoding());
            dest.writeInt(mix.getFormat().getChannelMask());
            ArrayList<AudioMixingRule.AudioMixMatchCriterion> criteria = mix.getRule().getCriteria();
            dest.writeInt(criteria.size());
            for (AudioMixingRule.AudioMixMatchCriterion criterion : criteria) {
                criterion.writeToParcel(dest);
            }
        }
    }

    private void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(Parcel in) {
        this.mDuckingPolicy = 0;
        this.mRegistrationId = null;
        this.mMixCounter = 0;
        this.mMixes = new ArrayList();
        int nbMixes = in.readInt();
        for (int i = 0; i < nbMixes; ++i) {
            AudioMix.Builder mixBuilder = new AudioMix.Builder();
            int routeFlags = in.readInt();
            mixBuilder.setRouteFlags(routeFlags);
            mixBuilder.setCallbackFlags(in.readInt());
            mixBuilder.setDevice(in.readInt(), in.readString());
            int sampleRate = in.readInt();
            int encoding = in.readInt();
            int channelMask = in.readInt();
            AudioFormat format = new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelMask).setEncoding(encoding).build();
            mixBuilder.setFormat(format);
            int nbRules = in.readInt();
            AudioMixingRule.Builder ruleBuilder = new AudioMixingRule.Builder();
            for (int j = 0; j < nbRules; ++j) {
                ruleBuilder.addRuleFromParcel(in);
            }
            mixBuilder.setMixingRule(ruleBuilder.build());
            this.mMixes.add(mixBuilder.build());
        }
    }

    private final String $$robo$$android_media_audiopolicy_AudioPolicyConfig$toLogFriendlyString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        textDump = textDump + this.mMixes.size() + " AudioMix: " + this.mRegistrationId + "\n";
        for (AudioMix mix : this.mMixes) {
            textDump = textDump + "* route flags=0x" + Integer.toHexString(mix.getRouteFlags()) + "\n";
            textDump = textDump + "  rate=" + mix.getFormat().getSampleRate() + "Hz\n";
            textDump = textDump + "  encoding=" + mix.getFormat().getEncoding() + "\n";
            textDump = textDump + "  channels=0x";
            textDump = textDump + Integer.toHexString(mix.getFormat().getChannelMask()).toUpperCase() + "\n";
            ArrayList<AudioMixingRule.AudioMixMatchCriterion> criteria = mix.getRule().getCriteria();
            for (AudioMixingRule.AudioMixMatchCriterion criterion : criteria) {
                switch (criterion.mRule) {
                    case 32769: {
                        textDump = textDump + "  exclude usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        textDump = textDump + "  match usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 32770: {
                        textDump = textDump + "  exclude capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 2: {
                        textDump = textDump + "  match capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 4: {
                        textDump = textDump + "  match UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 32772: {
                        textDump = textDump + "  exclude UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    default: {
                        textDump = textDump + "invalid rule!";
                    }
                }
                textDump = textDump + "\n";
            }
        }
        return textDump;
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$setRegistration(String regId) {
        boolean newRegNull;
        boolean currentRegNull = this.mRegistrationId == null || this.mRegistrationId.isEmpty();
        boolean bl = newRegNull = regId == null || regId.isEmpty();
        if (!(currentRegNull || newRegNull || this.mRegistrationId.equals(regId))) {
            Log.e("AudioPolicyConfig", "Invalid registration transition from " + this.mRegistrationId + " to " + regId);
            return;
        }
        this.mRegistrationId = regId == null ? "" : regId;
        for (AudioMix mix : this.mMixes) {
            this.setMixRegistration(mix);
        }
    }

    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$setMixRegistration(AudioMix mix) {
        if (!this.mRegistrationId.isEmpty()) {
            if ((mix.getRouteFlags() & 2) == 2) {
                mix.setRegistration(this.mRegistrationId + "mix" + AudioPolicyConfig.mixTypeId(mix.getMixType()) + ":" + this.mMixCounter);
            } else if ((mix.getRouteFlags() & 1) == 1) {
                mix.setRegistration(mix.mDeviceAddress);
            }
        } else {
            mix.setRegistration("");
        }
        ++this.mMixCounter;
    }

    @GuardedBy(value="mMixes")
    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$add(ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            this.setMixRegistration(mix);
            this.mMixes.add(mix);
        }
    }

    @GuardedBy(value="mMixes")
    private final void $$robo$$android_media_audiopolicy_AudioPolicyConfig$remove(ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            this.mMixes.remove(mix);
        }
    }

    private static final String $$robo$$android_media_audiopolicy_AudioPolicyConfig$mixTypeId(int type) {
        if (type == 0) {
            return "p";
        }
        if (type == 1) {
            return "r";
        }
        return "i";
    }

    private final String $$robo$$android_media_audiopolicy_AudioPolicyConfig$getRegistration() {
        return this.mRegistrationId;
    }

    private /* synthetic */ void $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__() {
            }

            private final AudioPolicyConfig $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$createFromParcel(Parcel p) {
                return new AudioPolicyConfig(p);
            }

            private final AudioPolicyConfig[] $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$newArray(int size) {
                return new AudioPolicyConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$__constructor__(), 0, this);
            }

            @Override
            public AudioPolicyConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AudioPolicyConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_audiopolicy_AudioPolicyConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(AudioPolicyConfig audioPolicyConfig) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(audioPolicyConfig);
    }

    protected AudioPolicyConfig(AudioPolicyConfig audioPolicyConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(android.media.audiopolicy.AudioPolicyConfig ), 0, this, audioPolicyConfig);
    }

    private void __constructor__(ArrayList<AudioMix> arrayList) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(arrayList);
    }

    AudioPolicyConfig(ArrayList<AudioMix> arrayList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(java.util.ArrayList<android.media.audiopolicy.AudioMix> ), 0, this, arrayList);
    }

    public void addMix(AudioMix audioMix) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("addMix", $$robo$$android_media_audiopolicy_AudioPolicyConfig$addMix(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
    }

    public ArrayList<AudioMix> getMixes() {
        return InvokeDynamicSupport.bootstrap("getMixes", $$robo$$android_media_audiopolicy_AudioPolicyConfig$getMixes(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_audiopolicy_AudioPolicyConfig$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_audiopolicy_AudioPolicyConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_audiopolicy_AudioPolicyConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(parcel);
    }

    private AudioPolicyConfig(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String toLogFriendlyString() {
        return InvokeDynamicSupport.bootstrap("toLogFriendlyString", $$robo$$android_media_audiopolicy_AudioPolicyConfig$toLogFriendlyString(), 0, this);
    }

    protected void setRegistration(String string2) {
        InvokeDynamicSupport.bootstrap("setRegistration", $$robo$$android_media_audiopolicy_AudioPolicyConfig$setRegistration(java.lang.String ), 0, this, string2);
    }

    private void setMixRegistration(AudioMix audioMix) {
        InvokeDynamicSupport.bootstrap("setMixRegistration", $$robo$$android_media_audiopolicy_AudioPolicyConfig$setMixRegistration(android.media.audiopolicy.AudioMix ), 0, this, audioMix);
    }

    protected void add(ArrayList<AudioMix> arrayList) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_media_audiopolicy_AudioPolicyConfig$add(java.util.ArrayList<android.media.audiopolicy.AudioMix> ), 0, this, arrayList);
    }

    protected void remove(ArrayList<AudioMix> arrayList) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_media_audiopolicy_AudioPolicyConfig$remove(java.util.ArrayList<android.media.audiopolicy.AudioMix> ), 0, this, arrayList);
    }

    private static String mixTypeId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("mixTypeId", $$robo$$android_media_audiopolicy_AudioPolicyConfig$mixTypeId(int ), 0, (int)n);
    }

    protected String getRegistration() {
        return InvokeDynamicSupport.bootstrap("getRegistration", $$robo$$android_media_audiopolicy_AudioPolicyConfig$getRegistration(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_media_audiopolicy_AudioPolicyConfig$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AudioPolicyConfig.class);
    }

    public /* synthetic */ AudioPolicyConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPolicyConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

